/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.AlignmentDialog;

import java.beans.PropertyVetoException;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.dialogs.AlignmentDialog;
import net.nooj4nlp.gui.main.Launcher;

public class AlignmentController {
    private int nbOfNodesAligned;
    private GrammarEditorShellController grammarController;
    private AlignmentDialog dialog;

    public AlignmentController(AlignmentDialog dialog, GrammarEditorShellController grammarController) {
        this.grammarController = grammarController;
        this.dialog = dialog;
    }

    public void close() {
        this.grammarController.alignmentDialog = null;
        this.dialog.dispose();
    }

    public void bottomAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int lowest = 0;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            int y;
            int line0;
            if (grf.selected.get(iNode).booleanValue() && lowest < (line0 = (y = grf.posY.get(iNode).intValue()) + grf.hei.get(iNode))) {
                lowest = line0;
            }
            ++iNode;
        }
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posY.set(iNode, lowest - grf.hei.get(iNode));
            }
            ++iNode;
        }
        this.grammarController.modify("bottom-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void topAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int top = 999999999;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            int y;
            int line0;
            if (grf.selected.get(iNode).booleanValue() && top > (line0 = (y = grf.posY.get(iNode).intValue()) - grf.hei.get(iNode))) {
                top = line0;
            }
            ++iNode;
        }
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posY.set(iNode, top + grf.hei.get(iNode));
            }
            ++iNode;
        }
        this.grammarController.modify("top-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void centerHorizontalAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int average = 0;
        int nbSelected = 0;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                int y = grf.posY.get(iNode);
                average += y;
                ++nbSelected;
            }
            ++iNode;
        }
        if (nbSelected < 2) {
            return;
        }
        average /= nbSelected;
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posY.set(iNode, average);
            }
            ++iNode;
        }
        this.grammarController.modify("horizontal-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void leftAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int lowest = 999999999;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            int x;
            if (grf.selected.get(iNode).booleanValue() && lowest > (x = grf.posX.get(iNode).intValue())) {
                lowest = x;
            }
            ++iNode;
        }
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posX.set(iNode, lowest);
            }
            ++iNode;
        }
        this.grammarController.modify("left-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void rightAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int rightest = 0;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            int x;
            int right;
            if (grf.selected.get(iNode).booleanValue() && rightest < (right = (x = grf.posX.get(iNode).intValue()) + grf.wid.get(iNode))) {
                rightest = right;
            }
            ++iNode;
        }
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posX.set(iNode, rightest - grf.wid.get(iNode));
            }
            ++iNode;
        }
        this.grammarController.modify("right-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void centerVerticalAlign() {
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int average = 0;
        int nbSelected = 0;
        this.nbOfNodesAligned = 0;
        int iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                ++nbSelected;
                int x = grf.posX.get(iNode);
                int center = x + (int)((float)grf.wid.get(iNode).intValue() / 2.0f);
                average += center;
            }
            ++iNode;
        }
        if (nbSelected < 2) {
            return;
        }
        average /= nbSelected;
        this.nbOfNodesAligned = 0;
        iNode = 0;
        while (iNode < grf.selected.size()) {
            if (grf.selected.get(iNode).booleanValue()) {
                ++this.nbOfNodesAligned;
                grf.posX.set(iNode, average - (int)((float)grf.wid.get(iNode).intValue() / 2.0f));
            }
            ++iNode;
        }
        this.grammarController.modify("vertical-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void useGrid() {
        if (this.grammarController == null) {
            return;
        }
        Grammar grm = this.grammarController.grammar;
        if (grm == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        grm.dispGrid = this.dialog.getCbUseGrid().isSelected();
        int iNode = 0;
        while (iNode < grf.posX.size()) {
            grf.posX.set(iNode, grf.posX.get(iNode) / 20 * 20);
            grf.posY.set(iNode, grf.posY.get(iNode) / 20 * 20);
            ++iNode;
        }
        if (grm.dispGrid) {
            this.grammarController.modify("snap to grid", false, false);
        }
        this.grammarController.editor.repaint();
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }
}

