/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.OpenTextFromCorpusActionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.SyntacticTreeShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import net.nooj4nlp.gui.utilities.Helper;

public class ConcordanceMouseActionListener
extends MouseAdapter {
    private ConcordanceShellController controller;
    private TextEditorShellController textController;
    private JTable concordanceTable;

    public ConcordanceMouseActionListener(ConcordanceShellController controller) {
        this.controller = controller;
        this.concordanceTable = this.controller.getConcordanceTable();
        this.textController = this.controller.getTextController();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.concordanceTable.getSelectedRowCount() < 1) {
                return;
            }
            List<Object> theItems = this.controller.getTheItems();
            int selectedRow = this.concordanceTable.getSelectedRow();
            Object[] item = new Object[6];
            DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
            Object fifth = tableModel.getValueAt(selectedRow, 4);
            Object sixth = tableModel.getValueAt(selectedRow, 5);
            int i = 0;
            while (i < theItems.size()) {
                Object[] tempItem = (Object[])theItems.get(i + 1);
                if (this.controller.getColorMap().get(tempItem[4]) == (Integer)fifth && sixth.equals(tempItem[5])) {
                    item = tempItem;
                    break;
                }
                i += 4;
            }
            ArrayList annotations = (ArrayList)item[5];
            CorpusEditorShellController corpusController = this.controller.getCorpusController();
            if (corpusController != null && corpusController.getShell() != null) {
                Corpus corpus = corpusController.getCorpus();
                String fileName = item[0].toString();
                String fullPath = String.valueOf(corpusController.getFullPath()) + "_dir" + System.getProperty("file.separator") + fileName;
                Ntext myText = null;
                TextEditorShellController textController = corpusController.getTextController();
                String clickedFilePath = "";
                if (textController != null) {
                    clickedFilePath = OpenTextFromCorpusActionListener.getClickedFilePath();
                    if (fullPath.equals(clickedFilePath)) {
                        myText = textController.getMyText();
                    } else {
                        try {
                            myText = Ntext.loadForCorpus(fullPath, corpus.lan, corpus.multiplier);
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                            return;
                        }
                    }
                    textController.getTextShell().dispose();
                    textController = null;
                } else {
                    try {
                        myText = Ntext.loadForCorpus(fullPath, corpus.lan, corpus.multiplier);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                        return;
                    }
                }
                TextEditorShell textShell = new TextEditorShell(corpusController, myText, fileName, myText.getDelimPattern(), false);
                corpusController.getShell().setTextEditorShell(textShell);
                textController = textShell.getTextController();
                MouseListener rightClickListener = textShell.getRightClickListener();
                textShell.removeMouseListener(rightClickListener);
                textShell.getTextPane().removeMouseListener(rightClickListener);
                Launcher.getDesktopPane().add(textShell);
                textShell.setVisible(true);
                File file = new File(fullPath);
                textController.setFileToBeOpenedOrImported(file);
                corpusController.setTextController(textController);
                myText.annotations = corpus.annotations;
                double absoluteBeginAddress0 = (Double)annotations.get(2);
                int absoluteBeginAddress = (int)absoluteBeginAddress0;
                textController.resetShellText();
                textController.setCurrentTextUnitIsBlack(true);
                textController.getTextShell().getTextPane().setCaretPosition(absoluteBeginAddress);
            } else {
                if (annotations == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Annotations are empty!", "NooJ Error!", 0);
                    return;
                }
                double absoluteBeginAddress0 = (Double)annotations.get(2);
                int absoluteBeginAddress = (int)absoluteBeginAddress0;
                this.textController.getTextShell().getTextPane().setCaretPosition(absoluteBeginAddress);
                TextEditorShell textShell = this.textController.getTextShell();
                Helper.putDialogOnTheTop(textShell);
            }
            if (this.controller.getSyntacticTreeShell() != null) {
                SyntacticTreeShell syntacticTree = this.controller.getSyntacticTreeShell();
                syntacticTree.getController().setConcordanceIndex(this.controller.getConcordanceShell().getConcordanceTable().getSelectedRow());
                syntacticTree.setVisible(true);
                syntacticTree.invalidate();
                syntacticTree.validate();
                syntacticTree.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Component component = e.getComponent();
        CursorChangeEffect.setCrossCursor(component);
    }
}

