/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceData;
import net.nooj4nlp.controller.ConcordanceShell.RightClickPopupMenuForConcordance;
import net.nooj4nlp.controller.ConcordanceShell.TextBoxConcordanceActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import net.nooj4nlp.gui.shells.SyntacticTreeShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ConcordanceShellController {
    private CorpusEditorShellController corpusController;
    private TextEditorShellController textController;
    private ConcordanceShell concordanceShell;
    private Corpus corpus = null;
    private JRadioButton rbCharacters;
    private JRadioButton rbWordForms;
    private JTable concordanceTable;
    private JCheckBox cbMatches;
    private JCheckBox cbOutputs;
    private Language Lan;
    private boolean RightToLeft;
    private boolean doNotRefresh = false;
    private boolean cbMatchesIsPressed = true;
    private boolean rbCharactersIsPressed = false;
    private boolean cbOutputsIsPressed = false;
    private boolean isConcordanceTableSorted = false;
    private List<Object> theItems = null;
    private SyntacticTreeShell syntacticTreeShell = null;
    private static int before = 5;
    private static int after = 5;
    private Map<Color, Integer> colorMap = new HashMap<Color, Integer>();
    private DefaultTableModel tableModel = null;

    public ConcordanceShellController(ConcordanceShell concordanceShell) {
        this.colorMap.put(Color.BLACK, 1);
        this.colorMap.put(Color.RED, 2);
        this.colorMap.put(Color.GREEN, 3);
        this.colorMap.put(Color.BLUE, 4);
        boolean isItAText = false;
        this.concordanceShell = concordanceShell;
        this.corpusController = this.concordanceShell.getCorpusController();
        this.textController = this.concordanceShell.getTextController();
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            this.corpus = this.corpusController.getCorpus();
            this.Lan = this.corpus.lan;
            this.textController = this.corpusController.getTextController();
        } else if (this.textController != null) {
            this.Lan = this.textController.getMyText().Lan;
            isItAText = true;
            this.textController.setConcordanceController(this);
        }
        this.RightToLeft = this.Lan.rightToLeft;
        this.doNotRefresh = false;
        this.rbCharacters = this.concordanceShell.getRbCharacters();
        this.rbWordForms = this.concordanceShell.getRbWordForms();
        this.concordanceTable = this.concordanceShell.getConcordanceTable();
        this.concordanceTable.setFont(Launcher.preferences.TFont);
        this.cbMatches = this.concordanceShell.getCbMatches();
        this.cbOutputs = this.concordanceShell.getCbOutputs();
        if (isItAText) {
            if ((this.Lan.isoName.equals("zh") || this.Lan.isoName.equals("ja")) && !this.rbCharacters.isSelected()) {
                this.doNotRefresh = false;
                this.rbCharacters.setSelected(true);
                this.rbWordForms.setEnabled(false);
                this.doNotRefresh = true;
            } else if (this.Lan.rightToLeft) {
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                renderer.setHorizontalAlignment(4);
                this.concordanceTable.setDefaultRenderer(Object.class, renderer);
            } else {
                DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
                tableModel.getDataVector().removeAllElements();
                tableModel.fireTableDataChanged();
            }
        } else {
            if ((this.Lan.isoName.equals("zh") || this.Lan.isoName.equals("ja")) && !this.rbCharacters.isSelected()) {
                this.doNotRefresh = false;
                this.rbCharacters.setSelected(true);
                this.rbWordForms.setEnabled(false);
                this.doNotRefresh = true;
            }
            if (this.Lan.rightToLeft) {
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                renderer.setHorizontalAlignment(4);
                this.concordanceTable.setDefaultRenderer(Object.class, renderer);
            } else {
                DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
                tableModel.getDataVector().removeAllElements();
                tableModel.fireTableDataChanged();
            }
        }
        this.theItems = new ArrayList<Object>();
    }

    public boolean AddData(Ntext text, String fileName, Color c, int tuNb, double beginAddress0, double endAddress0, ArrayList<Object> seqOfAnnotations, boolean onlyOneExample, String query) {
        Object[] item;
        Color actualColor;
        if (fileName == null) {
            fileName = "";
        }
        String lCon = "";
        String seq = "";
        String rCon = "";
        String mSeq = "";
        int beginAddress = (int)beginAddress0;
        int endAddress = (int)endAddress0;
        if ((double)endAddress < endAddress0) {
            while (endAddress < text.buffer.length() && Language.isLetter(text.buffer.charAt(endAddress))) {
                ++endAddress;
            }
        }
        seq = text.buffer.substring(beginAddress, endAddress);
        String output = "";
        if (seqOfAnnotations != null && (output = seqOfAnnotations.get(1).toString()) != null && output != "") {
            seq = String.valueOf(seq) + "/" + output;
        }
        if (onlyOneExample) {
            int i = 0;
            while (i < this.theItems.size()) {
                String seq0;
                Object[] item2 = (Object[])this.theItems.get(i + 1);
                Color actualColor2 = (Color)item2[4];
                if (actualColor2.equals(c) && seq.equals(seq0 = item2[2].toString())) {
                    return false;
                }
                i += 4;
            }
        }
        RefObject<String> lConRef = new RefObject<String>(lCon);
        RefObject<String> rConRef = new RefObject<String>(rCon);
        RefObject<String> mSeqRef = new RefObject<String>(mSeq);
        this.compute(this.rbCharacters.isSelected(), beginAddress, endAddress, text.buffer, before, after, seq, lConRef, mSeqRef, rConRef);
        lCon = (String)lConRef.argvalue;
        rCon = (String)rConRef.argvalue;
        mSeq = (String)mSeqRef.argvalue;
        int iAlready = this.theItems.size() - 4;
        if (iAlready >= 0 && (actualColor = (Color)(item = (Object[])this.theItems.get(iAlready + 1))[4]).equals(c)) {
            String fileName0 = item[0].toString();
            String lCon0 = item[1].toString();
            String seq0 = item[2].toString();
            String rCon0 = item[3].toString();
            if (fileName.equals(fileName0) && lCon.equals(lCon0) && seq.equals(seq0) && rCon.equals(rCon0)) {
                return false;
            }
        }
        Object[] cItem = new Object[6];
        ArrayList<Serializable> annotations = new ArrayList<Serializable>();
        annotations.add(Integer.valueOf(tuNb));
        annotations.add(seqOfAnnotations);
        annotations.add(Double.valueOf(beginAddress0));
        annotations.add(Double.valueOf(endAddress0));
        cItem = this.RightToLeft ? new Object[]{fileName, rCon, mSeq, lCon, c, annotations} : new Object[]{fileName, lCon, mSeq, rCon, c, annotations};
        this.theItems.add(query);
        this.theItems.add(cItem);
        this.theItems.add(true);
        this.theItems.add(output);
        return true;
    }

    public void compute(boolean characterMode, int beginAddress, int endAddress, String textBuffer, int before, int after, String result, RefObject<String> lConRef, RefObject<String> mSeqRef, RefObject<String> rConRef) {
        int index;
        mSeqRef.argvalue = "";
        rConRef.argvalue = "";
        lConRef.argvalue = "";
        int bufferLength = textBuffer.length();
        if (characterMode) {
            lConRef.argvalue = beginAddress > before ? textBuffer.substring(beginAddress - before, beginAddress) : textBuffer.substring(0, beginAddress);
            rConRef.argvalue = bufferLength > endAddress + after ? textBuffer.substring(endAddress, endAddress + after) : textBuffer.substring(endAddress, bufferLength);
        } else {
            int nbOfTokens = 0;
            boolean inAWord = false;
            int i = beginAddress - 1;
            while (i > 0) {
                if (Language.isLetter(textBuffer.charAt(i))) {
                    if (!inAWord) {
                        ++nbOfTokens;
                    }
                    inAWord = true;
                } else {
                    if (nbOfTokens >= before) break;
                    if (inAWord) {
                        inAWord = false;
                    }
                }
                --i;
            }
            if (i < 0) {
                i = 0;
            }
            lConRef.argvalue = textBuffer.substring(i, beginAddress);
            nbOfTokens = 0;
            inAWord = true;
            i = endAddress;
            while (i < bufferLength) {
                if (Language.isLetter(textBuffer.charAt(i))) {
                    if (!inAWord) {
                        ++nbOfTokens;
                    }
                    inAWord = true;
                } else {
                    if (nbOfTokens >= after) break;
                    if (inAWord) {
                        inAWord = false;
                    }
                }
                ++i;
            }
            if (i > bufferLength) {
                i = bufferLength;
            }
            rConRef.argvalue = textBuffer.substring(endAddress, i);
        }
        if (this.cbMatches.isSelected()) {
            index = result.indexOf(0);
            if (index == -1 || index == result.length() - 1) {
                mSeqRef.argvalue = result;
            } else {
                mSeqRef.argvalue = result.substring(0, index);
                if (this.cbOutputs.isSelected()) {
                    mSeqRef.argvalue = String.valueOf(mSeqRef.argvalue) + "/" + result.substring(index + 1);
                }
            }
        } else {
            mSeqRef.argvalue = this.cbOutputs.isSelected() ? ((index = result.indexOf(0)) == -1 || index < result.length() - 1 ? "" : result.substring(index + 1)) : "";
        }
    }

    public void refreshConcordance() {
        if (this.tableModel != null && this.isConcordanceTableSorted) {
            this.concordanceTable.setModel(this.tableModel);
            this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(5));
            this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(4));
            this.setConcordanceTableSorted(false);
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        if (this.textController != null) {
            List<Color> listOfColors = this.textController.getListOfColors();
            if (this.textController != null && listOfColors != null) {
                this.textController.setListOfColors(new ArrayList<Color>());
                this.textController.setAbsoluteBeginAddresses(new ArrayList<Integer>());
                this.textController.setAbsoluteEndAddresses(new ArrayList<Integer>());
            }
        }
        if (this.syntacticTreeShell != null) {
            this.syntacticTreeShell.dispose();
            this.setSyntacticTreeShell(null);
        }
        String lastFullPath = "";
        String lastBuffer = "";
        TextEditorShellController corpusTextController = null;
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            corpusTextController = this.corpusController.getTextController();
        }
        if (this.corpusController != null && this.corpusController.getShell() != null && corpusTextController != null) {
            lastFullPath = corpusTextController.getFileToBeOpenedOrImported().getAbsolutePath();
            lastBuffer = corpusTextController.getMyText().buffer;
        }
        if (this.theItems == null || this.theItems.size() == 0) {
            this.concordanceShell.dispose();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Concordance is empty!", "NooJ: No match", 0);
            if (this.corpusController != null && this.corpusController.getShell() != null) {
                this.corpusController.setConcordanceController(null);
            }
            if (this.textController != null) {
                this.textController.setConcordanceController(null);
            }
            return;
        }
        int i = 0;
        while (i < this.theItems.size()) {
            Object[] item = (Object[])this.theItems.get(i + 1);
            boolean isSelected = (Boolean)this.theItems.get(i + 2);
            String fileName = item[0].toString();
            if (isSelected) {
                ArrayList annotation = (ArrayList)item[5];
                ArrayList seqOfOutputs = (ArrayList)annotation.get(1);
                if (seqOfOutputs == null || seqOfOutputs.size() == 0) {
                    this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                    this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                    RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
                } else {
                    String output = seqOfOutputs.get(1).toString();
                    if (output == null || output.equals("")) {
                        this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                        this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                        RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
                    } else if (output.charAt(0) == '<' || output.charAt(0) == '$') {
                        this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(true);
                        this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(true);
                        RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(true);
                    } else {
                        this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                        this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                        RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
                    }
                }
                String myTextBuffer = "";
                if (this.corpusController != null && this.corpusController.getShell() != null) {
                    String fullPath = String.valueOf(this.corpusController.getFullPath()) + "_dir" + System.getProperty("file.separator") + item[0].toString();
                    if (!fullPath.equals(lastFullPath)) {
                        Ntext myText = null;
                        try {
                            myText = Ntext.loadJustBufferForCorpus(fullPath, this.corpus.lan, this.corpus.multiplier);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                            return;
                        }
                        if (myText == null) {
                            return;
                        }
                        myTextBuffer = myText.buffer;
                        lastFullPath = fullPath;
                        lastBuffer = myTextBuffer;
                    } else {
                        myTextBuffer = lastBuffer;
                    }
                } else {
                    myTextBuffer = this.textController.getMyText().buffer;
                }
                double absoluteBeginAddress0 = (Double)annotation.get(2);
                double absoluteEndAddress0 = (Double)annotation.get(3);
                int absoluteBeginAddress = (int)absoluteBeginAddress0;
                int absoluteEndAddress = (int)absoluteEndAddress0;
                int lengthOfBuffer = myTextBuffer.length();
                if (absoluteBeginAddress > lengthOfBuffer || absoluteEndAddress > lengthOfBuffer) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Concordance is not synced with text!", "NooJ Sync Error", 0);
                    return;
                }
                if ((double)absoluteEndAddress < absoluteEndAddress0) {
                    while (absoluteEndAddress < lengthOfBuffer && Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                        ++absoluteEndAddress;
                    }
                }
                String sOutput = "";
                ArrayList seqOfAnnotations = (ArrayList)((ArrayList)item[5]).get(1);
                if (seqOfAnnotations != null) {
                    String sOutput0 = seqOfAnnotations.get(1).toString();
                    sOutput = sOutput0.replace("#", "");
                }
                String lCon = "";
                String mSeq = "";
                String rCon = "";
                String seq = String.valueOf(myTextBuffer.substring(absoluteBeginAddress, absoluteEndAddress)) + "\u0000" + sOutput;
                RefObject<String> lConRef = new RefObject<String>(lCon);
                RefObject<String> rConRef = new RefObject<String>(rCon);
                RefObject<String> mSeqRef = new RefObject<String>(mSeq);
                this.compute(this.rbCharacters.isSelected(), absoluteBeginAddress, absoluteEndAddress, myTextBuffer, before, after, seq, lConRef, mSeqRef, rConRef);
                lCon = (String)lConRef.argvalue;
                rCon = (String)rConRef.argvalue;
                mSeq = (String)mSeqRef.argvalue;
                Object[] cItem = new Object[6];
                cItem = !this.RightToLeft ? new Object[]{fileName, ConcordanceShellController.cleanUpConcordanceString(lCon), ConcordanceShellController.cleanUpConcordanceString(mSeq), ConcordanceShellController.cleanUpConcordanceString(rCon), this.colorMap.get(item[4]), item[5]} : new Object[]{fileName, ConcordanceShellController.cleanUpConcordanceString(rCon), ConcordanceShellController.cleanUpConcordanceString(mSeq), ConcordanceShellController.cleanUpConcordanceString(lCon), this.colorMap.get(item[4]), item[5]};
                this.concordanceShell.getCustomForegroundTableRenderer().addColoredRowsToAMap(tableModel.getRowCount(), (Color)item[4]);
                tableModel.addRow(cItem);
            }
            i += 4;
        }
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 0);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 1);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 2);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 3);
        this.setTableModel(null);
        this.concordanceShell.getEntriesNBLabel().setText(String.valueOf(this.concordanceTable.getRowCount()) + "/" + this.theItems.size() / 4);
        this.mColorClick();
    }

    public static String cleanUpConcordanceString(String text) {
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (Character.isISOControl(c) || Character.isWhitespace(c)) {
                sb.setCharAt(i, ' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public void radioButtonEvent(boolean isRBCharactersSelected) {
        if (isRBCharactersSelected) {
            before *= 10;
            after *= 10;
            this.rbCharactersIsPressed = true;
        } else {
            before = (before - before % 10) / 10;
            after = (after - after % 10) / 10;
            this.rbCharactersIsPressed = false;
        }
        if (this.doNotRefresh) {
            return;
        }
        this.refreshConcordance();
    }

    public void setWidthOfTableColumn(JTable table, DefaultTableModel tableModel, int column) {
        int width = 0;
        int row = 0;
        while (row < tableModel.getRowCount()) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
            ++row;
        }
        if (column == 0 && width < 50) {
            width = 50;
        } else if (width < 166) {
            width = 166;
        }
        if (column == 2 && !this.cbMatchesIsPressed) {
            width = 50;
        }
        table.getColumnModel().getColumn(column).setMaxWidth(width + 5);
        table.getColumnModel().getColumn(column).setPreferredWidth(width + 5);
    }

    public void annotate() {
        int iAdded = 0;
        int iRemoved = 0;
        RefObject<Integer> iAddedRef = new RefObject<Integer>(iAdded);
        RefObject<Integer> iRemovedRef = new RefObject<Integer>(iRemoved);
        ArrayList<Object> annotations = this.corpusController != null && this.corpusController.getShell() != null ? this.corpus.annotations : this.textController.getMyText().annotations;
        String lastFullPath = "";
        Ntext myLastText = null;
        if (this.corpusController != null && this.corpusController.getShell() != null && this.textController != null) {
            lastFullPath = this.textController.getFileToBeOpenedOrImported().getAbsolutePath();
            myLastText = this.textController.getMyText();
        }
        Engine engine = null;
        boolean processAll = false;
        int[] selectedRows = this.concordanceTable.getSelectedRows();
        int selectedRowsLength = selectedRows.length;
        if (selectedRowsLength == 0) {
            processAll = true;
        }
        int i = 0;
        while (i < this.concordanceTable.getRowCount()) {
            DefaultTableModel tableModel;
            ArrayList annotation;
            int TUnb;
            if ((processAll || this.concordanceTable.isRowSelected(i)) && (TUnb = ((Integer)(annotation = (ArrayList)(tableModel = (DefaultTableModel)this.concordanceTable.getModel()).getValueAt(i, 5)).get(0)).intValue()) > 0) {
                if (this.corpusController != null && this.corpusController.getShell() != null) {
                    String corpusDirPath = String.valueOf(this.corpusController.getFullPath()) + "_dir";
                    engine = this.corpusController.getEngine();
                    String fileName = tableModel.getValueAt(i, 0).toString();
                    String fullPath = String.valueOf(corpusDirPath) + System.getProperty("file.separator") + fileName;
                    Ntext myText = null;
                    if (fullPath.equals(lastFullPath)) {
                        myText = myLastText;
                    } else {
                        try {
                            myText = Ntext.loadForCorpus(fullPath, this.corpus.lan, this.corpus.multiplier);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                            return;
                        }
                        lastFullPath = fullPath;
                        myLastText = myText;
                    }
                    if (myText == null) {
                        return;
                    }
                    int xRefNb = this.corpus.annotations.size();
                    ArrayList seqOfAnnotations = (ArrayList)annotation.get(1);
                    if (seqOfAnnotations != null) {
                        String seq = seqOfAnnotations.get(1).toString();
                        if (seqOfAnnotations.size() <= 4) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seq + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                            break;
                        }
                        if (seq.charAt(0) != '<') {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seqOfAnnotations.get(1) + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                            break;
                        }
                        this.annotationHelpFunction(engine, myText, seqOfAnnotations, annotations, TUnb, xRefNb, iAddedRef, iRemovedRef, true);
                    }
                    try {
                        myText.saveForCorpus(fullPath);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while saving text data for corpus!", 0);
                        return;
                    }
                }
                engine = this.textController.getEngine();
                Ntext myText = this.textController.getMyText();
                int xRefNb = myText.annotations.size();
                ArrayList seqOfAnnotations = (ArrayList)annotation.get(1);
                if (seqOfAnnotations != null) {
                    String seq = seqOfAnnotations.get(1).toString();
                    if (seqOfAnnotations.size() <= 4) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seq + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                        break;
                    }
                    if (seq.charAt(0) != '<') {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seqOfAnnotations.get(1) + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                        break;
                    }
                    this.annotationHelpFunction(engine, myText, seqOfAnnotations, seqOfAnnotations, TUnb, xRefNb, iAddedRef, iRemovedRef, false);
                }
            }
            ++i;
        }
        iAdded = (Integer)iAddedRef.argvalue;
        iRemoved = (Integer)iRemovedRef.argvalue;
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(iAdded) + " annotations were added; " + iRemoved + " annotations were removed", "NooJ: text was annotated", 1);
        if (iAdded > 0 || iRemoved > 0) {
            if (this.corpusController != null && this.corpusController.getShell() != null) {
                if (this.textController != null) {
                    this.textController.getTextShell().getChckbxShowTextAnnotation().setSelected(false);
                }
                this.corpusController.setModified(true);
                this.corpusController.updateTitle();
                this.corpusController.updateTextPaneStats();
                this.corpusController.updateResults();
            } else {
                this.textController.updateTextPaneStats();
                this.textController.modify();
            }
        }
    }

    private void annotationHelpFunction(Engine engine, Ntext myText, ArrayList<?> seqOfAnnotations, ArrayList<Object> annotations, int TUnb, int xRefNb, RefObject<Integer> iAddedRef, RefObject<Integer> iRemovedRef, boolean corpusContextCall) {
        int ia = 4;
        while (ia < seqOfAnnotations.size()) {
            double absoluteBeginAddress = (Double)seqOfAnnotations.get(ia);
            RefObject<Double> absBegAddressRef = new RefObject<Double>(absoluteBeginAddress);
            engine.moveBegAddressOufOfSpaces(myText.buffer, myText.XmlNodes != null, absBegAddressRef);
            absoluteBeginAddress = (Double)absBegAddressRef.argvalue;
            String sOutput = seqOfAnnotations.get(ia + 1).toString();
            double absoluteEndAddress = (Double)seqOfAnnotations.get(ia + 2);
            if (absoluteBeginAddress == absoluteEndAddress) {
                long hund_BeginAddress = (long)((absoluteBeginAddress + 0.005) * 100.0) - (long)(100 * myText.mft.tuAddresses[TUnb]);
                double beginAddress = (double)hund_BeginAddress / 100.0;
                boolean anXRefWasRemoved = false;
                RefObject<Boolean> anXRefWasRemovedRef = new RefObject<Boolean>(anXRefWasRemoved);
                iRemovedRef.argvalue = corpusContextCall ? Integer.valueOf((Integer)iRemovedRef.argvalue + myText.mft.filterTransitions(this.corpus.annotations, TUnb, beginAddress, sOutput, anXRefWasRemovedRef)) : Integer.valueOf((Integer)iRemovedRef.argvalue + myText.mft.filterTransitions(myText.annotations, TUnb, beginAddress, sOutput, anXRefWasRemovedRef));
                anXRefWasRemoved = (Boolean)anXRefWasRemovedRef.argvalue;
                if (anXRefWasRemoved) {
                    myText.mft.filterInconsistentXrefs(annotations, TUnb);
                }
            }
            ia += 3;
        }
        int nbXRef = 0;
        int ia2 = 4;
        while (ia2 < seqOfAnnotations.size()) {
            String sOutput = seqOfAnnotations.get(ia2 + 1).toString();
            if (!sOutput.equals("") && sOutput.indexOf("XREF") != -1) {
                ++nbXRef;
            }
            ia2 += 3;
        }
        ia2 = 4;
        while (ia2 < seqOfAnnotations.size()) {
            double absoluteBeginAddress = (Double)seqOfAnnotations.get(ia2);
            RefObject<Double> absBegAddressRef = new RefObject<Double>(absoluteBeginAddress);
            if (corpusContextCall) {
                engine.moveBegAddressOufOfSpaces(myText.buffer, this.corpus.xmlNodes != null, absBegAddressRef);
            } else {
                engine.moveBegAddressOufOfSpaces(myText.buffer, myText.XmlNodes != null, absBegAddressRef);
            }
            absoluteBeginAddress = (Double)absBegAddressRef.argvalue;
            String sOutput = seqOfAnnotations.get(ia2 + 1).toString();
            double absoluteEndAddress = (Double)seqOfAnnotations.get(ia2 + 2);
            if (absoluteBeginAddress < absoluteEndAddress) {
                double relativeBeginAddress = absoluteBeginAddress - (double)myText.mft.tuAddresses[TUnb];
                double relativeEndAddress = absoluteEndAddress - (double)myText.mft.tuAddresses[TUnb];
                if (corpusContextCall && this.corpus.hPhrases == null) {
                    this.corpus.hPhrases = new HashMap();
                } else if (!corpusContextCall && myText.hPhrases == null) {
                    myText.hPhrases = new HashMap();
                }
                String sInput = Dic.cleanupEntry(myText.buffer.substring((int)absoluteBeginAddress, (int)absoluteEndAddress), myText.XmlNodes != null);
                if (!sOutput.equals("") && sOutput.indexOf("XREF") != -1) {
                    sOutput = sOutput.replace("XREF", "XREF=" + xRefNb + "." + nbXRef);
                }
                sOutput = Dic.cleanUpDoubleQuotes(sOutput);
                if (corpusContextCall) {
                    if (!Dic.isALexicalAnnotation(sOutput)) {
                        String lexeme = String.valueOf(sInput) + ",SYNTAX," + sOutput;
                        if (Dic.isALexicalAnnotation(lexeme)) {
                            engine.addSyntaxToCorpus(annotations, null, this.corpus.hPhrases, lexeme, myText.mft, TUnb, relativeBeginAddress, relativeEndAddress, false);
                        } else {
                            engine.addSyntaxToCorpus(annotations, null, this.corpus.hPhrases, String.valueOf(sInput) + ",INVALIDANNOTATION", myText.mft, TUnb, relativeBeginAddress, relativeEndAddress, false);
                        }
                    } else {
                        engine.addLexemeToCorpus(annotations, this.corpus.hPhrases, String.valueOf(sInput) + "," + sOutput, myText.mft, TUnb, relativeBeginAddress, relativeEndAddress);
                    }
                } else if (!Dic.isALexicalAnnotation(sOutput)) {
                    engine.addLexemeToText(annotations, myText.hPhrases, String.valueOf(sInput) + ",SYNTAX," + sOutput, myText.mft, TUnb, relativeBeginAddress, relativeEndAddress);
                } else {
                    engine.addLexemeToText(annotations, myText.hPhrases, String.valueOf(sInput) + "," + sOutput, myText.mft, TUnb, relativeBeginAddress, relativeEndAddress);
                }
                iAddedRef.argvalue = (Integer)iAddedRef.argvalue + 1;
            }
            ia2 += 3;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.theItems.size()) {
            this.theItems.set(i + 2, true);
            i += 4;
        }
        JTextField beforeTF = this.concordanceShell.getBeforeTF();
        JTextField afterTF = this.concordanceShell.getAfterTF();
        TextBoxConcordanceActionListener textBoxConcordanceActionListener = (TextBoxConcordanceActionListener)this.concordanceShell.getBeforeTF().getKeyListeners()[0];
        textBoxConcordanceActionListener.reset(beforeTF, afterTF);
    }

    private void mColorClick() {
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            this.textController = this.corpusController.getTextController();
            if (this.textController != null) {
                this.textController.getTextShell().dispose();
                this.corpusController.setTextController(null);
                this.textController = null;
            }
            this.corpusController.setListOfConcordanceFiles(new ArrayList<String>());
            this.corpusController.setListOfColors(new ArrayList<Color>());
            this.corpusController.setAbsoluteBeginAddresses(new ArrayList<Integer>());
            this.corpusController.setAbsoluteEndAddresses(new ArrayList<Integer>());
            int i = 0;
            while (i < this.theItems.size()) {
                Object[] item = (Object[])this.theItems.get(i + 1);
                boolean isSelected = (Boolean)this.theItems.get(i + 2);
                if (isSelected) {
                    ArrayList annotation = (ArrayList)item[5];
                    double absoluteBeginAddress0 = (Double)annotation.get(2);
                    double absoluteEndAddress0 = (Double)annotation.get(3);
                    int absoluteBeginAddress = (int)absoluteBeginAddress0;
                    int absoluteEndAddress = (int)absoluteEndAddress0;
                    this.corpusController.getListOfConcordanceFiles().add(item[0].toString());
                    this.corpusController.getListOfColors().add((Color)item[4]);
                    this.corpusController.getAbsoluteBeginAddresses().add(absoluteBeginAddress);
                    this.corpusController.getAbsoluteEndAddresses().add(absoluteEndAddress);
                    this.corpusController.setColored(true);
                }
                i += 4;
            }
        } else {
            this.textController.setListOfColors(new ArrayList<Color>());
            this.textController.setAbsoluteBeginAddresses(new ArrayList<Integer>());
            this.textController.setAbsoluteEndAddresses(new ArrayList<Integer>());
            String myTextBuffer = this.textController.getMyText().buffer;
            int i = 0;
            while (i < this.theItems.size()) {
                Object[] item = (Object[])this.theItems.get(i + 1);
                boolean isSelected = (Boolean)this.theItems.get(i + 2);
                if (isSelected) {
                    ArrayList annotation = (ArrayList)item[5];
                    double absoluteBeginAddress0 = (Double)annotation.get(2);
                    double absoluteEndAddress0 = (Double)annotation.get(3);
                    int absoluteBeginAddress = (int)absoluteBeginAddress0;
                    int absoluteEndAddress = (int)absoluteEndAddress0;
                    if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
                        while (Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                            ++absoluteEndAddress;
                        }
                    }
                    this.textController.getListOfColors().add((Color)item[4]);
                    this.textController.getAbsoluteBeginAddresses().add(absoluteBeginAddress);
                    this.textController.getAbsoluteEndAddresses().add(absoluteEndAddress);
                    this.textController.setColored(true);
                }
                i += 4;
            }
            TextEditorShell textShell = this.textController.getTextShell();
            UnitSelectionListener unitSelectionListener = textShell.getUnitSelectionListener();
            unitSelectionListener.paintTextInRGB();
            unitSelectionListener.partialColorText(this.textController, this.textController.getMyText(), textShell.getTextPane(), textShell, true);
        }
    }

    public void loadConcordance(String fileName) {
        try {
            ConcordanceData cd = ConcordanceData.load(fileName);
            if (cd == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load concordance", "NooJ: file error", 0);
                return;
            }
            Launcher.getDesktopPane().add(this.concordanceShell);
            this.concordanceShell.setVisible(true);
            this.theItems.addAll(cd.getTheItems());
            this.refreshConcordance();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load concordance", "NooJ: file error", 0);
            return;
        }
    }

    public void saveConcordance() {
        if (Launcher.getSaveConcordanceChooser().showSaveDialog(null) != 0) {
            return;
        }
        File selectedFile = Launcher.getSaveConcordanceChooser().getSelectedFile();
        String fileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "jncc";
        String parentPath = selectedFile.getParent();
        String filePath = String.valueOf(parentPath) + System.getProperty("file.separator") + fileName;
        if ((selectedFile = new File(filePath)).exists()) {
            int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(fileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
            if (value == 1 || value == -1) {
                return;
            }
            selectedFile.delete();
        }
        ConcordanceData cd = this.corpusController != null && this.corpusController.getShell() != null ? new ConcordanceData(this.corpusController.getFullPath(), this.theItems) : new ConcordanceData(this.textController.getFileToBeOpenedOrImported().getAbsolutePath(), this.theItems);
        try {
            cd.save(filePath);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save concordance!", "NooJ", 0);
            return;
        }
    }

    public void saveConcordanceForNooJ() {
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Not implemented!", "NooJ: cannot SaveForNooJ a concordance", 1);
    }

    public static void setBefore(int before) {
        ConcordanceShellController.before = before;
    }

    public static void setAfter(int after) {
        ConcordanceShellController.after = after;
    }

    public void setTheItems(List<Object> theItems) {
        this.theItems = theItems;
    }

    public static int getBefore() {
        return before;
    }

    public static int getAfter() {
        return after;
    }

    public ConcordanceShell getConcordanceShell() {
        return this.concordanceShell;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void setCbMatchesIsPressed(boolean cbMatchesIsPressed) {
        this.cbMatchesIsPressed = cbMatchesIsPressed;
    }

    public List<Object> getTheItems() {
        return this.theItems;
    }

    public JTable getConcordanceTable() {
        return this.concordanceTable;
    }

    public CorpusEditorShellController getCorpusController() {
        return this.corpusController;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public boolean isCbMatchesIsPressed() {
        return this.cbMatchesIsPressed;
    }

    public boolean isRbCharactersIsPressed() {
        return this.rbCharactersIsPressed;
    }

    public boolean isCbOutputsIsPressed() {
        return this.cbOutputsIsPressed;
    }

    public void setCbOutputsIsPressed(boolean cbOutputsIsPressed) {
        this.cbOutputsIsPressed = cbOutputsIsPressed;
    }

    public Map<Color, Integer> getColorMap() {
        return this.colorMap;
    }

    public Language getLan() {
        return this.Lan;
    }

    public boolean isConcordanceTableSorted() {
        return this.isConcordanceTableSorted;
    }

    public void setConcordanceTableSorted(boolean isConcordanceTableSorted) {
        this.isConcordanceTableSorted = isConcordanceTableSorted;
    }

    public void setConcordanceTable(JTable concordanceTable) {
        this.concordanceTable = concordanceTable;
    }

    public SyntacticTreeShell getSyntacticTreeShell() {
        return this.syntacticTreeShell;
    }

    public void setSyntacticTreeShell(SyntacticTreeShell syntacticTreeShell) {
        this.syntacticTreeShell = syntacticTreeShell;
    }
}

