/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.nooj4nlp.engine.Constants;

public class CustomForegroundTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3751665304019380449L;
    private boolean sortedPreview = false;
    private Map<Integer, Color> coloredRowsMap = new HashMap<Integer, Color>();
    private Map<Integer, Color> sortedRowsMap = new HashMap<Integer, Color>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!this.sortedPreview) {
            if (this.coloredRowsMap.containsKey(row)) {
                c.setForeground(this.coloredRowsMap.get(row));
            }
        } else if (this.sortedRowsMap.containsKey(row)) {
            c.setForeground(this.sortedRowsMap.get(row));
        }
        return c;
    }

    public void addColoredRowsToAMap(int row, Color color) {
        if (this.coloredRowsMap.containsKey(row)) {
            return;
        }
        this.coloredRowsMap.put(row, color);
    }

    public void sortTableColors() {
        int blackLines = 0;
        int redLines = 0;
        int greenLines = 0;
        Map<Integer, Color> actualColorMap = this.getColoredRowsMap();
        for (Map.Entry<Integer, Color> pairs : actualColorMap.entrySet()) {
            Color color = pairs.getValue();
            if (color.equals(Color.BLACK)) {
                ++blackLines;
                continue;
            }
            if (color.equals(Constants.NOOJ_RED_BUTTON_COLOR)) {
                ++redLines;
                continue;
            }
            if (!color.equals(Constants.NOOJ_GREEN_BUTTON_COLOR)) continue;
            ++greenLines;
        }
        HashMap<Integer, Color> sortedColorMap = new HashMap<Integer, Color>();
        int i = 0;
        while (i < actualColorMap.size()) {
            if (i < blackLines) {
                sortedColorMap.put(i, Color.BLACK);
            } else if (i < blackLines + redLines) {
                sortedColorMap.put(i, Constants.NOOJ_RED_BUTTON_COLOR);
            } else if (i < blackLines + redLines + greenLines) {
                sortedColorMap.put(i, Constants.NOOJ_GREEN_BUTTON_COLOR);
            } else {
                sortedColorMap.put(i, Constants.NOOJ_BLUE_BUTTON_COLOR);
            }
            ++i;
        }
        this.setSortedRowsMap(sortedColorMap);
        this.setSortedPreview(true);
    }

    public void updateMapsWhenRowIsDeleted(int sortedIndex, int unsortedIndex) {
        this.setColoredRowsMap(CustomForegroundTableRenderer.removeDeletedItemsFromColorMaps(this.coloredRowsMap, unsortedIndex));
        this.setSortedRowsMap(CustomForegroundTableRenderer.removeDeletedItemsFromColorMaps(this.sortedRowsMap, sortedIndex));
    }

    private static Map<Integer, Color> removeDeletedItemsFromColorMaps(Map<Integer, Color> colorMap, int index) {
        if (index == -1) {
            return new HashMap<Integer, Color>();
        }
        if (!colorMap.containsKey(index)) {
            return new HashMap<Integer, Color>();
        }
        colorMap = new TreeMap<Integer, Color>(colorMap);
        Iterator<Map.Entry<Integer, Color>> iter = colorMap.entrySet().iterator();
        int i = index;
        while (iter.hasNext()) {
            Map.Entry<Integer, Color> pairs = iter.next();
            if (pairs.getKey() <= index) continue;
            colorMap.put(i, pairs.getValue());
            ++i;
        }
        colorMap.remove(colorMap.size() - 1);
        return colorMap;
    }

    public Map<Integer, Color> getColoredRowsMap() {
        return this.coloredRowsMap;
    }

    public void setSortedPreview(boolean sortedPreview) {
        this.sortedPreview = sortedPreview;
    }

    public void setSortedRowsMap(Map<Integer, Color> sortedRowsMap) {
        this.sortedRowsMap = sortedRowsMap;
    }

    public void setColoredRowsMap(Map<Integer, Color> coloredRowsMap) {
        this.coloredRowsMap = coloredRowsMap;
    }
}

