/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import org.apache.commons.io.FilenameUtils;

public class ExportConcordanceActionListener
implements ActionListener {
    private int typeOfExport;
    private ConcordanceShellController controller;
    private CorpusEditorShellController corpusController;
    private int before = 0;
    private int after = 0;

    public ExportConcordanceActionListener(ConcordanceShellController controller, int typeOfExport) {
        this.controller = controller;
        this.typeOfExport = typeOfExport;
        this.corpusController = this.controller.getCorpusController();
        this.before = ConcordanceShellController.getBefore();
        this.after = ConcordanceShellController.getAfter();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.typeOfExport == 1) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Tab Separated Text (*.txt)", "txt");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogTitle("Save As");
            jFileChooser.setFileFilter(filter);
            int result = jFileChooser.showSaveDialog(this.controller.getConcordanceShell());
            if (result == 0) {
                String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                String inputFileName = String.valueOf(FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName())) + "." + "txt";
                String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
                File newFile = new File(pathOfInputFile);
                if (newFile.exists()) {
                    int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
                    if (value == 1 || value == -1) {
                        return;
                    }
                    newFile.delete();
                    this.saveConcordanceAsTXT(pathOfInputFile);
                } else {
                    this.saveConcordanceAsTXT(pathOfInputFile);
                }
            }
        } else if (this.typeOfExport == 2) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Web Page (*.htm)", "htm");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogTitle("Save As");
            jFileChooser.setFileFilter(filter);
            int result = jFileChooser.showSaveDialog(this.controller.getConcordanceShell());
            if (result == 0) {
                String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                String inputFileName = String.valueOf(FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName())) + "." + "htm";
                String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
                File newFile = new File(pathOfInputFile);
                if (newFile.exists()) {
                    int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
                    if (value == 1 || value == -1) {
                        return;
                    }
                    newFile.delete();
                    this.saveConcordanceAsHTM(pathOfInputFile);
                } else {
                    this.saveConcordanceAsHTM(pathOfInputFile);
                }
            }
        } else if (this.typeOfExport == 3) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogTitle("Save As");
            jFileChooser.setFileFilter(filter);
            int result = jFileChooser.showSaveDialog(this.controller.getConcordanceShell());
            if (result == 0) {
                String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                String inputFileName = String.valueOf(FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName())) + "." + "txt";
                String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
                File newFile = new File(pathOfInputFile);
                if (newFile.exists()) {
                    int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
                    if (value == 1 || value == -1) {
                        return;
                    }
                    newFile.delete();
                    this.saveConcordancesIndex(pathOfInputFile);
                } else {
                    this.saveConcordancesIndex(pathOfInputFile);
                }
            }
        }
    }

    private void saveConcordanceAsTXT(String pathOfFileToBeSaved) {
        PrintWriter pw = null;
        List<Object> theItems = this.controller.getTheItems();
        File txtFile = new File(pathOfFileToBeSaved);
        if (txtFile.exists()) {
            return;
        }
        try {
            txtFile.createNewFile();
            pw = new PrintWriter(txtFile);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance file " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance file " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
            return;
        }
        if (this.controller.getCorpusController() != null) {
            String corpusDirPath = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            String lastFullPath = "";
            Ntext myLastText = null;
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    Object[] item = (Object[])theItems.get(i + 1);
                    String fileName = item[0].toString();
                    String fullPath = String.valueOf(corpusDirPath) + System.getProperty("file.separator") + fileName;
                    Ntext myText = null;
                    if (fullPath.equals(lastFullPath)) {
                        myText = myLastText;
                    } else {
                        Corpus corpus = this.corpusController.getCorpus();
                        try {
                            myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                        }
                        catch (IOException e) {
                            if (pw != null) {
                                pw.close();
                            }
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                            return;
                        }
                        lastFullPath = fullPath;
                        myLastText = myText;
                    }
                    if (myText == null) {
                        pw.write("Cannot load Text " + fileName + ".");
                        pw.close();
                        return;
                    }
                    pw.write(String.valueOf(fileName) + "\t");
                    this.exportTXThelpFunction(pw, item, myText);
                }
                i += 4;
            }
            pw.close();
        } else {
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    Object[] item = (Object[])theItems.get(i + 1);
                    this.exportTXThelpFunction(pw, item, this.controller.getTextController().getMyText());
                }
                i += 4;
            }
            pw.close();
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: concordance saved as " + txtFile.getName(), "NooJ Export Concordance", 1);
    }

    private void saveConcordanceAsHTM(String pathOfFileToBeSaved) {
        PrintWriter pw = null;
        PrintWriter pwCon = null;
        File txtFile = new File(pathOfFileToBeSaved);
        if (txtFile.exists()) {
            return;
        }
        try {
            txtFile.createNewFile();
            pw = new PrintWriter(txtFile);
            pw.write(String.valueOf(this.html_header("NooJ Concordance's Index")) + "\n");
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance site " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance site " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
            return;
        }
        String concordanceFullPathPrefix = String.valueOf(txtFile.getParent()) + System.getProperty("file.separator") + "concord";
        int concordanceNumber = 0;
        RefObject<Integer> concordanceNumberRef = new RefObject<Integer>(concordanceNumber);
        JTable concordanceTable = this.controller.getConcordanceTable();
        DefaultTableModel tableModel = (DefaultTableModel)concordanceTable.getModel();
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            String lastFullPath = "";
            Ntext myLastText = null;
            String lastIndexName = "";
            RefObject<Object> pwConRef = new RefObject<Object>(pwCon);
            RefObject<PrintWriter> pwRef = new RefObject<PrintWriter>(pw);
            RefObject<String> lastIndexNameRef = new RefObject<String>(lastIndexName);
            int i = 0;
            while (i < tableModel.getRowCount()) {
                String fileName = tableModel.getValueAt(i, 0).toString();
                String fullPath = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fileName;
                Ntext myText = null;
                if (fullPath.equals(lastFullPath)) {
                    myText = myLastText;
                } else {
                    Corpus corpus = this.corpusController.getCorpus();
                    try {
                        myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                    }
                    catch (IOException e) {
                        if (pw != null) {
                            pw.close();
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                        return;
                    }
                    lastFullPath = fullPath;
                    myLastText = myText;
                }
                if (myText == null) {
                    pw.write("Cannot load Text " + fileName + ".");
                    pw.close();
                    return;
                }
                this.exportHTMhelpFunction(pwConRef, pwRef, myText, lastIndexNameRef, fileName, concordanceFullPathPrefix, tableModel, i, concordanceNumberRef, true);
                ++i;
            }
            pwCon = (PrintWriter)pwConRef.argvalue;
            pw = (PrintWriter)pwRef.argvalue;
            pwCon.write(this.html_tailer());
            pwCon.close();
            pw.write(this.html_tailer());
            pw.close();
        } else {
            String lastIndexName = "";
            Ntext myText = this.controller.getTextController().getMyText();
            RefObject<Object> pwConRef = new RefObject<Object>(pwCon);
            RefObject<PrintWriter> pwRef = new RefObject<PrintWriter>(pw);
            RefObject<String> lastIndexNameRef = new RefObject<String>(lastIndexName);
            int i = 0;
            while (i < tableModel.getRowCount()) {
                this.exportHTMhelpFunction(pwConRef, pwRef, myText, lastIndexNameRef, "", concordanceFullPathPrefix, tableModel, i, concordanceNumberRef, false);
                ++i;
            }
            pwCon = (PrintWriter)pwConRef.argvalue;
            pw = (PrintWriter)pwRef.argvalue;
            pwCon.write(this.html_tailer());
            pwCon.close();
            pw.write(this.html_tailer());
            pw.close();
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: concordance saved as " + txtFile.getName(), "NooJ Export Concordance", 1);
    }

    private void saveConcordancesIndex(String pathOfFileToBeSaved) {
        PrintWriter pw = null;
        List<Object> theItems = this.controller.getTheItems();
        File txtFile = new File(pathOfFileToBeSaved);
        if (txtFile.exists()) {
            return;
        }
        try {
            txtFile.createNewFile();
            pw = new PrintWriter(txtFile);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Cannot create index file " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export index entries", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Cannot create index file " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export index entries", 0);
            return;
        }
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            ArrayList keys = new ArrayList();
            ArrayList pages = new ArrayList();
            ArrayList addresses = new ArrayList();
            String lastFullPath = "";
            Ntext myLastText = null;
            RefObject<ArrayList<String>> keysRef = new RefObject<ArrayList<String>>(keys);
            RefObject<ArrayList<String>> pagesRef = new RefObject<ArrayList<String>>(pages);
            RefObject<ArrayList<Integer>> addressesRef = new RefObject<ArrayList<Integer>>(addresses);
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    Object[] item = (Object[])theItems.get(i + 1);
                    String fileName = item[0].toString();
                    String fullPath = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fileName;
                    Ntext myText = null;
                    if (lastFullPath.equals(fullPath)) {
                        myText = myLastText;
                    } else {
                        Corpus corpus = this.corpusController.getCorpus();
                        try {
                            myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                        }
                        catch (IOException e) {
                            if (pw != null) {
                                pw.close();
                            }
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                            return;
                        }
                        myLastText = myText;
                    }
                    if (myText == null) {
                        pw.close();
                        return;
                    }
                    String myTextBuffer = myText.buffer;
                    this.exportIndexHelpFunction1(item, myTextBuffer, keysRef, pagesRef, addressesRef, fileName);
                }
                i += 4;
            }
            keys = (ArrayList)keysRef.argvalue;
            pages = (ArrayList)pagesRef.argvalue;
            addresses = (ArrayList)addressesRef.argvalue;
            RefObject<PrintWriter> pwRef = new RefObject<PrintWriter>(pw);
            this.exportIndexHelpFunction2(pwRef, keys, pages, addresses, true);
            pw = (PrintWriter)pwRef.argvalue;
        } else {
            ArrayList keys = new ArrayList();
            ArrayList addresses = new ArrayList();
            RefObject<ArrayList<String>> keysRef = new RefObject<ArrayList<String>>(keys);
            RefObject<ArrayList<Integer>> addressesRef = new RefObject<ArrayList<Integer>>(addresses);
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    Object[] item = (Object[])theItems.get(i + 1);
                    String myTextBuffer = this.controller.getTextController().getMyText().buffer;
                    this.exportIndexHelpFunction1(item, myTextBuffer, keysRef, null, addressesRef, "");
                }
                i += 4;
            }
            keys = (ArrayList)keysRef.argvalue;
            addresses = (ArrayList)addressesRef.argvalue;
            RefObject<PrintWriter> pwRef = new RefObject<PrintWriter>(pw);
            this.exportIndexHelpFunction2(pwRef, keys, null, addresses, false);
            pw = (PrintWriter)pwRef.argvalue;
        }
        if (pw != null) {
            pw.close();
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: index saved as " + txtFile.getName(), "NooJ Export Index", 1);
    }

    private void exportTXThelpFunction(PrintWriter pw, Object[] item, Ntext myText) {
        ArrayList seqOfAnnotations;
        String myTextBuffer = myText.buffer;
        ArrayList annotation = (ArrayList)item[5];
        double absoluteBeginAddress0 = (Double)annotation.get(2);
        double absoluteEndAddress0 = (Double)annotation.get(3);
        int absoluteBeginAddress = (int)absoluteBeginAddress0;
        int absoluteEndAddress = (int)absoluteEndAddress0;
        if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
            while (Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                ++absoluteEndAddress;
            }
        }
        String sOutput = (seqOfAnnotations = (ArrayList)((ArrayList)item[5]).get(1)) == null ? "" : seqOfAnnotations.get(1).toString();
        String lCon = "";
        String mSeq = "";
        String rCon = "";
        RefObject<String> lConRef = new RefObject<String>(lCon);
        RefObject<String> mSeqRef = new RefObject<String>(mSeq);
        RefObject<String> rConRef = new RefObject<String>(rCon);
        String seq = myTextBuffer.substring(absoluteBeginAddress, absoluteEndAddress);
        ConcordanceShell shell = this.controller.getConcordanceShell();
        if (shell.getCbOutputs().isSelected()) {
            seq = String.valueOf(seq) + "\u0000" + sOutput;
        }
        this.controller.compute(shell.getRbCharacters().isSelected(), absoluteBeginAddress, absoluteEndAddress, myTextBuffer, this.before, this.after, seq, lConRef, mSeqRef, rConRef);
        lCon = (String)lConRef.argvalue;
        mSeq = (String)mSeqRef.argvalue;
        rCon = (String)rConRef.argvalue;
        if (this.before > 0) {
            pw.write(String.valueOf(ConcordanceShellController.cleanUpConcordanceString(lCon)) + "\t");
        }
        pw.write(String.valueOf(ConcordanceShellController.cleanUpConcordanceString(mSeq)) + "\t");
        if (this.after > 0) {
            pw.write(String.valueOf(ConcordanceShellController.cleanUpConcordanceString(rCon)) + "\t");
        }
        pw.write(String.valueOf(absoluteBeginAddress) + "\t" + absoluteEndAddress);
        pw.write("\n");
    }

    private void exportHTMhelpFunction(RefObject<PrintWriter> pwConRef, RefObject<PrintWriter> pwRef, Ntext myText, RefObject<String> lastIndexNameRef, String fileName, String concordanceFullPathPrefix, DefaultTableModel tableModel, int i, RefObject<Integer> concordanceNumber, boolean corpusContext) {
        ArrayList seqOfAnnotations;
        String myTextBuffer = myText.buffer;
        PrintWriter pwCon = (PrintWriter)pwConRef.argvalue;
        PrintWriter pw = (PrintWriter)pwRef.argvalue;
        String lastIndexName = (String)lastIndexNameRef.argvalue;
        ArrayList annotation = (ArrayList)tableModel.getValueAt(i, 5);
        double absoluteBeginAddress0 = (Double)annotation.get(2);
        double absoluteEndAddress0 = (Double)annotation.get(3);
        int absoluteBeginAddress = (int)absoluteBeginAddress0;
        int absoluteEndAddress = (int)absoluteEndAddress0;
        if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
            while (Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                ++absoluteEndAddress;
            }
        }
        String sOutput = (seqOfAnnotations = (ArrayList)annotation.get(1)) == null ? "" : seqOfAnnotations.get(1).toString();
        String lCon = "";
        String mSeq = "";
        String rCon = "";
        RefObject<String> lConRef = new RefObject<String>(lCon);
        RefObject<String> mSeqRef = new RefObject<String>(mSeq);
        RefObject<String> rConRef = new RefObject<String>(rCon);
        String sInput = myTextBuffer.substring(absoluteBeginAddress, absoluteEndAddress);
        String indexKey = "";
        String seq = "";
        ConcordanceShell shell = this.controller.getConcordanceShell();
        if (shell.getCbOutputs().isSelected()) {
            seq = String.valueOf(sInput) + "\u0000" + sOutput;
        } else {
            indexKey = seq = sInput;
        }
        this.controller.compute(shell.getRbCharacters().isSelected(), absoluteBeginAddress, absoluteEndAddress, myTextBuffer, this.before, this.after, seq, lConRef, mSeqRef, rConRef);
        lCon = (String)lConRef.argvalue;
        mSeq = (String)mSeqRef.argvalue;
        rCon = (String)rConRef.argvalue;
        if (!indexKey.equals(lastIndexName)) {
            if (pwCon != null) {
                pwCon.close();
            }
            concordanceNumber.argvalue = (Integer)concordanceNumber.argvalue + 1;
            String concordancePath = String.valueOf(concordanceFullPathPrefix) + concordanceNumber.argvalue + "." + "htm";
            File conFile = new File(concordancePath);
            if (conFile.exists()) {
                conFile.delete();
            }
            try {
                conFile.createNewFile();
                pwCon = new PrintWriter(conFile);
                pwCon.write(this.html_header("Concordance for \"" + indexKey + "\"\n"));
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance site " + conFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create concordance site " + conFile.getName() + "\r" + e.getMessage(), "NooJ: cannot export concordance entries", 0);
                return;
            }
            String concordancePathFixed = "file:///" + concordancePath;
            pw.write("<p><a href=\"" + concordancePathFixed + "\">" + indexKey + "</a></p>\n");
            lastIndexName = indexKey;
        }
        pwCon.write("<p>");
        if (corpusContext) {
            pwCon.write("(<i>" + FilenameUtils.removeExtension(fileName) + "</i>) ");
        }
        if (this.before > 0) {
            pwCon.write(String.valueOf(ConcordanceShellController.cleanUpConcordanceString(lCon)) + "\t");
        }
        pwCon.write("<b>" + ConcordanceShellController.cleanUpConcordanceString(sInput) + "</b>\t");
        if (this.after > 0) {
            pwCon.write(ConcordanceShellController.cleanUpConcordanceString(rCon));
        }
        pwCon.write("</p>");
        pwConRef.argvalue = pwCon;
        pwRef.argvalue = pw;
        lastIndexNameRef.argvalue = lastIndexName;
    }

    private String html_header(String title) {
        return "<!doctype html public \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n<head>\n<title>" + title + "</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head>\n<body>\n";
    }

    private String html_tailer() {
        return "</body>\n</html>";
    }

    private void exportIndexHelpFunction1(Object[] item, String myTextBuffer, RefObject<ArrayList<String>> keysRef, RefObject<ArrayList<String>> pagesRef, RefObject<ArrayList<Integer>> addressesRef, String fileName) {
        ArrayList seqOfAnnotations;
        ArrayList keys = (ArrayList)keysRef.argvalue;
        ArrayList pages = new ArrayList();
        if (!fileName.equals("")) {
            pages = (ArrayList)pagesRef.argvalue;
        }
        ArrayList addresses = (ArrayList)addressesRef.argvalue;
        ArrayList annotation = (ArrayList)item[5];
        double absoluteBeginAddress0 = (Double)annotation.get(2);
        double absoluteEndAddress0 = (Double)annotation.get(3);
        int absoluteBeginAddress = (int)absoluteBeginAddress0;
        int absoluteEndAddress = (int)absoluteEndAddress0;
        if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
            while (Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                ++absoluteEndAddress;
            }
        }
        String sOutput = (seqOfAnnotations = (ArrayList)((ArrayList)item[5]).get(1)) == null ? "" : seqOfAnnotations.get(1).toString();
        String lCon = "";
        String mSeq = "";
        String rCon = "";
        RefObject<String> lConRef = new RefObject<String>(lCon);
        RefObject<String> mSeqRef = new RefObject<String>(mSeq);
        RefObject<String> rConRef = new RefObject<String>(rCon);
        String seq = myTextBuffer.substring(absoluteBeginAddress, absoluteEndAddress);
        ConcordanceShell shell = this.controller.getConcordanceShell();
        if (shell.getCbOutputs().isSelected()) {
            seq = String.valueOf(seq) + "/" + sOutput;
        }
        this.controller.compute(shell.getRbCharacters().isSelected(), absoluteBeginAddress, absoluteEndAddress, myTextBuffer, this.before, this.after, seq, lConRef, mSeqRef, rConRef);
        lCon = (String)lConRef.argvalue;
        mSeq = (String)mSeqRef.argvalue;
        rCon = (String)rConRef.argvalue;
        keys.add(mSeq);
        if (!fileName.equals("")) {
            pages.add(fileName);
        }
        addresses.add(absoluteBeginAddress);
        keysRef.argvalue = keys;
        if (!fileName.equals("")) {
            pagesRef.argvalue = pages;
        }
        addressesRef.argvalue = addresses;
    }

    private void exportIndexHelpFunction2(RefObject<PrintWriter> pwRef, ArrayList<String> keys, ArrayList<String> pages, ArrayList<Integer> addresses, boolean corpusContext) {
        String pageT;
        String keyJ;
        String keyI;
        int j;
        PrintWriter pw = (PrintWriter)pwRef.argvalue;
        int i = 0;
        while (i < keys.size() - 1) {
            j = i + 1;
            while (j < keys.size()) {
                keyI = keys.get(i);
                keyJ = keys.get(j);
                if (keyJ.compareTo(keyI) < 0) {
                    String keyT = keyI;
                    keys.set(i, keyJ);
                    keys.set(j, keyT);
                    if (corpusContext) {
                        String pageI = pages.get(i);
                        String pageJ = pages.get(j);
                        pageT = pageI;
                        pages.set(i, pageJ);
                        pages.set(j, pageT);
                    }
                    int addT = addresses.get(i);
                    addresses.set(i, addresses.get(j));
                    addresses.set(j, addT);
                }
                ++j;
            }
            ++i;
        }
        if (corpusContext) {
            i = 0;
            while (i < keys.size() - 1) {
                j = i + 1;
                while (j < keys.size()) {
                    keyI = keys.get(i);
                    if (keyI.equals(keyJ = keys.get(j))) {
                        String pageI = pages.get(i);
                        String pageJ = pages.get(j);
                        if (pageJ.compareTo(pageI) < 0) {
                            String keyT = keyI;
                            keys.set(i, keyJ);
                            keys.set(j, keyT);
                            pageT = pageI;
                            pages.set(i, pageJ);
                            pages.set(j, pageT);
                            int addT = addresses.get(i);
                            addresses.set(i, addresses.get(j));
                            addresses.set(j, addT);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            String lastKey = "";
            String lastPage = "";
            int i2 = 0;
            while (i2 < keys.size()) {
                String key = keys.get(i2);
                String page = pages.get(i2);
                if (!key.equals(lastKey) || !page.equals(lastPage)) {
                    if (!key.equals(lastKey)) {
                        pw.write("\n" + key + ", " + page);
                        lastPage = page;
                        lastKey = key;
                    } else if (!page.equals(lastPage)) {
                        pw.write(", " + page);
                        lastPage = page;
                    }
                }
                ++i2;
            }
        } else {
            String lastKey = "";
            int i3 = 0;
            while (i3 < keys.size()) {
                String key = keys.get(i3);
                int address = addresses.get(i3);
                if (!key.equals(lastKey)) {
                    pw.write("\n" + key + ", " + address);
                    lastKey = key;
                } else {
                    pw.write(", " + address);
                }
                ++i3;
            }
        }
        pw.write("\n");
        pw.close();
        pwRef.argvalue = pw;
    }
}

