/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ExtractConcordanceActionListener
implements ActionListener {
    private ConcordanceShellController controller;
    private CorpusEditorShellController corpusController;
    private boolean matchingTU;

    public ExtractConcordanceActionListener(ConcordanceShellController controller, boolean matchingTU) {
        this.controller = controller;
        this.corpusController = this.controller.getCorpusController();
        this.matchingTU = matchingTU;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("UTF-8 Text File (*.txt)", "txt");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setDialogTitle("Save As");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showSaveDialog(this.controller.getConcordanceShell());
        if (result == 0) {
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = String.valueOf(FilenameUtils.removeExtension(jFileChooser.getSelectedFile().getName())) + "." + "txt";
            String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists()) {
                int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
                if (value == 1 || value == -1) {
                    return;
                }
                newFile.delete();
                this.extractTextUnits(pathOfInputFile);
            } else {
                this.extractTextUnits(pathOfInputFile);
            }
        }
    }

    private void extractTextUnits(String pathOfFileToBeSaved) {
        PrintWriter pw = null;
        List<Object> theItems = this.controller.getTheItems();
        File txtFile = new File(pathOfFileToBeSaved);
        if (txtFile.exists()) {
            return;
        }
        try {
            txtFile.createNewFile();
            pw = new PrintWriter(txtFile);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create sub-corpus " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot extract matching text units", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create sub-corpus " + txtFile.getName() + "\r" + e.getMessage(), "NooJ: cannot extract matching text units", 0);
            return;
        }
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            Boolean[] textUnitIsExported;
            Corpus corpus = this.corpusController.getCorpus();
            String corpusDirPath = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            HashMap<String, Boolean[]> textsToBeExported = new HashMap<String, Boolean[]>();
            String lastFullPath = "";
            Ntext myLastText = null;
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    Object[] item = (Object[])theItems.get(i + 1);
                    if (!this.matchingTU && item[5] == null) {
                        if (pw != null) {
                            pw.close();
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Annotations are empty!", "NooJ: Annotations are empty!", 0);
                        return;
                    }
                    ArrayList annotation = (ArrayList)item[5];
                    String fileName = item[0].toString();
                    String fullPath = String.valueOf(corpusDirPath) + System.getProperty("file.separator") + fileName;
                    Ntext myText = null;
                    if (fullPath.equals(lastFullPath)) {
                        myText = myLastText;
                    } else {
                        try {
                            myText = Ntext.loadForCorpus(fullPath, corpus.lan, corpus.multiplier);
                        }
                        catch (IOException e) {
                            if (pw != null) {
                                pw.close();
                            }
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                            return;
                        }
                        lastFullPath = fullPath;
                        myLastText = myText;
                        TextEditorShellController textController = this.corpusController.getTextController();
                        JInternalFrame textShell = null;
                        if (textController == null) {
                            textShell = new TextEditorShell(this.corpusController, myText, fileName, myText.getDelimPattern(), false);
                            textController = ((TextEditorShell)textShell).getTextController();
                            this.corpusController.getShell().setTextEditorShell((TextEditorShell)textShell);
                            this.corpusController.setTextController(textController);
                            textController.setFileToBeOpenedOrImported(new File(fullPath));
                            ((TextEditorShell)textShell).getLblnTus().setText("/ " + ((TextEditorShell)textShell).getText().nbOfTextUnits + " TUs");
                            Launcher.getDesktopPane().add(textShell);
                            textShell.setVisible(true);
                        } else {
                            textController.resetShellText();
                        }
                        textController.setMyText(myText);
                        if (textShell != null) {
                            textShell.dispose();
                            Launcher.getDesktopPane().remove(textShell);
                            textShell.setVisible(false);
                        }
                    }
                    if (myText == null) {
                        if (pw != null) {
                            pw.close();
                        }
                        return;
                    }
                    double absoluteBeginAddress0 = (Double)annotation.get(2);
                    double absoluteEndAddress0 = (Double)annotation.get(3);
                    int absoluteBeginAddress = (int)absoluteBeginAddress0;
                    int absoluteEndAddress = (int)absoluteEndAddress0;
                    if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
                        while (Language.isLetter(myText.buffer.charAt(absoluteEndAddress))) {
                            ++absoluteEndAddress;
                        }
                    }
                    if (!textsToBeExported.containsKey(fullPath)) {
                        Boolean[] booleanArray = new Boolean[myText.mft.tuAddresses.length + 1];
                        int j = 0;
                        while (j < booleanArray.length) {
                            booleanArray[j] = false;
                            ++j;
                        }
                        textsToBeExported.put(fullPath, booleanArray);
                    }
                    textUnitIsExported = (Boolean[])textsToBeExported.get(fullPath);
                    int tuNb = (Integer)annotation.get(0);
                    if (tuNb == -1) {
                        tuNb = this.corpusController.getTextController().locateTextUnit(absoluteBeginAddress);
                    }
                    textUnitIsExported[tuNb] = true;
                    ((Boolean[])textsToBeExported.get((Object)fullPath))[tuNb] = true;
                }
                i += 4;
            }
            lastFullPath = "";
            myLastText = null;
            for (String fullPath2 : textsToBeExported.keySet()) {
                Ntext myText2 = null;
                if (fullPath2.equals(lastFullPath)) {
                    myText2 = myLastText;
                } else {
                    try {
                        myText2 = Ntext.loadForCorpus(fullPath2, corpus.lan, corpus.multiplier);
                    }
                    catch (IOException f) {
                        if (pw != null) {
                            pw.close();
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), f.getMessage(), "Error while loading text for corpus!", 0);
                        return;
                    }
                    lastFullPath = fullPath2;
                    myLastText = myText2;
                }
                textUnitIsExported = (Boolean[])textsToBeExported.get(fullPath2);
                int iTU = 1;
                while (iTU < myText2.mft.tuAddresses.length) {
                    if (textUnitIsExported[iTU] != null && (textUnitIsExported[iTU].booleanValue() && this.matchingTU || !textUnitIsExported[iTU].booleanValue() && !this.matchingTU)) {
                        int iTUindex = myText2.mft.tuAddresses[iTU];
                        pw.write("<TU>\n");
                        pw.write(String.valueOf(myText2.buffer.substring(iTUindex, iTUindex + myText2.mft.tuLengths[iTU])) + "\n");
                        pw.write("</TU>\n\n");
                    }
                    ++iTU;
                }
            }
            if (pw != null) {
                pw.close();
            }
        } else {
            TextEditorShellController textController = this.controller.getTextController();
            Ntext myText = textController.getMyText();
            boolean[] textUnitIsExported = new boolean[myText.mft.tuAddresses.length + 1];
            int i = 0;
            while (i < theItems.size()) {
                boolean visible = (Boolean)theItems.get(i + 2);
                if (visible) {
                    int tuNb;
                    Object[] item = (Object[])theItems.get(i + 1);
                    if (!this.matchingTU && item[5] == null) {
                        if (pw != null) {
                            pw.close();
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Annotations are empty!", "NooJ: Annotations are empty!", 0);
                        return;
                    }
                    ArrayList annotation = (ArrayList)item[5];
                    double absoluteBeginAddress0 = (Double)annotation.get(2);
                    double absoluteEndAddress0 = (Double)annotation.get(3);
                    int absoluteBeginAddress = (int)absoluteBeginAddress0;
                    int absoluteEndAddress = (int)absoluteEndAddress0;
                    if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
                        while (Language.isLetter(myText.buffer.charAt(absoluteEndAddress))) {
                            ++absoluteEndAddress;
                        }
                    }
                    if ((tuNb = ((Integer)annotation.get(0)).intValue()) == -1) {
                        tuNb = textController.locateTextUnit(absoluteBeginAddress);
                    }
                    textUnitIsExported[tuNb] = true;
                }
                i += 4;
            }
            int iTU = 1;
            while (iTU < myText.mft.tuAddresses.length) {
                if (textUnitIsExported[iTU] && this.matchingTU || !textUnitIsExported[iTU] && !this.matchingTU) {
                    int iTUindex = myText.mft.tuAddresses[iTU];
                    pw.write("<TU>\n");
                    pw.write(String.valueOf(myText.buffer.substring(iTUindex, iTUindex + myText.mft.tuLengths[iTU])) + "\n");
                    pw.write("</TU>\n\n");
                }
                ++iTU;
            }
        }
        pw.close();
        if (this.matchingTU) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: matching text units' corpus saved as " + txtFile.getName(), "NooJ Export Matching Text Units", 1);
        } else {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: non-matching text units' corpus saved as " + txtFile.getName(), "NooJ Export Non-Matching Text Units", 1);
        }
    }
}

