/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConstructCorpusDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import net.nooj4nlp.controller.ConstructCorpusDialog.ConstructCorpusDialogController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.TextIO;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.engine.Zip;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ConstructCorpusDialogBuildCorpusListener
implements ActionListener {
    private ConstructCorpusDialogController controller;

    public ConstructCorpusDialogBuildCorpusListener(ConstructCorpusDialogController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fileName = this.controller.getFldFileName().getText();
        if (fileName.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename should not be empty.", "NooJ", 1);
            return;
        }
        File fileToBeSplit = new File(fileName);
        if (!fileToBeSplit.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot open file " + fileName, "NooJ", 1);
            return;
        }
        String extension = FilenameUtils.getExtension(fileName);
        if (this.controller.getRdbtnPdf().isSelected()) {
            extension = "txt";
        }
        if (this.controller.getRdbtnBuildACorpus().isSelected() && this.controller.getFldCorpus().getText().equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter resulting corpus file name.", "NooJ", 1);
            return;
        }
        if (this.controller.getRdbtnStoreAllFiles().isSelected() && this.controller.getFldFolder().getText().equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter a directory where to store the result.", "NooJ", 1);
            return;
        }
        if (!this.controller.getRdbtnPdf().isSelected() && this.controller.getFldPerlExpr().getText().equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter a pattern to recognize section delimiters.", "NooJ", 1);
            return;
        }
        int textNumber = 1;
        try {
            textNumber = Integer.parseInt(this.controller.getFldFileNumber().getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter the first file's number.", "NooJ", 1);
            return;
        }
        StringBuffer buffer = new StringBuffer(512);
        List<String> bufferList = null;
        String encodingCode = null;
        String encodingName = null;
        Pattern regexp = null;
        int iLen = 0;
        if (this.controller.getRdbtnPdf().isSelected()) {
            try {
                bufferList = TextIO.loadPdfFileToStrings(fileName);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot read PDF file.", "NooJ", 1);
                return;
            }
        }
        BufferedReader reader = null;
        if (this.controller.getRdbtnAsciiOrBytemarked().isSelected()) {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToBeSplit), "UTF8"));
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot open file " + fileName, "NooJ", 0);
                return;
            }
            catch (UnsupportedEncodingException e3) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e3.getMessage(), "Error while encoding! Unsupported encoding!", 0);
            }
        } else {
            String selectedEncoding = (String)this.controller.getListTextFormats().getSelectedValue();
            Charset enc = Charset.forName(selectedEncoding.substring(0, selectedEncoding.indexOf(91)));
            encodingCode = enc.name();
            encodingName = enc.displayName();
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToBeSplit), encodingCode));
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot open file " + fileName, "NooJ", 1);
                return;
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot read from file " + fileName, "NooJ", 1);
                return;
            }
        }
        try {
            String line0 = reader.readLine();
            while (line0 != null) {
                buffer.append(line0);
                line0 = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e2) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException enc) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot read from file " + fileName, "NooJ", 1);
            return;
        }
        regexp = Pattern.compile(this.controller.getFldPerlExpr().getText(), 8);
        Corpus corpus = null;
        String corpusDirName = null;
        File corpusDir = null;
        String languageName = Launcher.preferences.deflanguage;
        if (this.controller.getRdbtnBuildACorpus().isSelected()) {
            corpus = this.controller.getRdbtnAsciiOrBytemarked().isSelected() || this.controller.getRdbtnPdf().isSelected() ? new Corpus("\n", null, 1, null, null, languageName) : new Corpus("\n", null, 2, encodingCode, encodingName, languageName);
            corpusDirName = String.valueOf(this.controller.getFldCorpus().getText()) + "_dir";
            corpusDir = new File(corpusDirName);
            if (corpus.lan.chartable == null && (this.controller.getRdbtnAsciiOrBytemarked().isSelected() || this.controller.getRdbtnPdf().isSelected())) {
                String chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + corpus.lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "charvariants.txt";
                File chartFile = new File(chartName);
                if (!chartFile.exists()) {
                    chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + corpus.lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "_charvariants.txt";
                    chartFile = new File(chartName);
                }
                if (chartFile.exists()) {
                    StringBuilder errMessage = new StringBuilder("");
                    try {
                        if (!corpus.lan.loadCharacterVariants(chartName, errMessage)) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Warning: cannot load characters' variants file " + chartName, "NooJ WARNING: " + errMessage, 1);
                            return;
                        }
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Warning: cannot load characters' variants file " + chartName, "NooJ WARNING: " + errMessage, 1);
                        return;
                    }
                }
            }
        }
        if (this.controller.getRdbtnPdf().isSelected()) {
            int i = 0;
            while (i < bufferList.size()) {
                String rName = null;
                String resName = null;
                File resFile = null;
                iLen = Integer.toString(bufferList.size()).length();
                String textNumberString = String.format("%0" + iLen + "d", textNumber);
                if (this.controller.getRdbtnStoreAllFiles().isSelected()) {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(this.controller.getFldFolder().getText()) + System.getProperty("file.separator") + rName;
                } else {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + rName;
                }
                BufferedWriter writer = null;
                try {
                    resFile = new File(resName);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(resFile));
                    writer = new BufferedWriter(outputStreamWriter);
                    writer.write(bufferList.get(i));
                    writer.close();
                }
                catch (FileNotFoundException e1) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                catch (IOException e1) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                if (this.controller.getRdbtnBuildACorpus().isSelected()) {
                    try {
                        corpus.addTextFile(corpusDirName, resName, null);
                        resFile.delete();
                    }
                    catch (ClassNotFoundException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (BadLocationException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                }
                ++textNumber;
                ++i;
            }
        } else {
            OutputStreamWriter outputStreamWriter = null;
            Matcher mc = regexp.matcher(buffer);
            int start = 0;
            int groupCount = 0;
            while (mc.find()) {
                ++groupCount;
            }
            iLen = Integer.toString(groupCount).length();
            mc = regexp.matcher(buffer);
            while (mc.find()) {
                int end = mc.start();
                int len = mc.end() - end;
                if (start == end) continue;
                String rName = null;
                String resName = null;
                File resFile = null;
                String textNumberString = String.format("%0" + iLen + "d", textNumber);
                if (this.controller.getRdbtnStoreAllFiles().isSelected()) {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(this.controller.getFldFolder().getText()) + System.getProperty("file.separator") + rName;
                } else {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + rName;
                }
                BufferedWriter writer = null;
                if (this.controller.getRdbtnAsciiOrBytemarked().isSelected()) {
                    try {
                        resFile = new File(resName);
                        outputStreamWriter = new OutputStreamWriter(new FileOutputStream(resFile));
                        writer = new BufferedWriter(outputStreamWriter);
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                        return;
                    }
                }
                try {
                    resFile = new File(resName);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(resFile, false), encodingCode);
                    writer = new BufferedWriter(outputStreamWriter);
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                catch (UnsupportedEncodingException e2) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Encoding not supported." + resName, "NooJ", 1);
                    return;
                }
                try {
                    writer.write(buffer.substring(start, end));
                    writer.close();
                }
                catch (IOException e1) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                if (this.controller.getRdbtnBuildACorpus().isSelected()) {
                    try {
                        corpus.addTextFile(corpusDirName, resName, null);
                        resFile.delete();
                    }
                    catch (ClassNotFoundException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (BadLocationException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                }
                start = end + len;
                ++textNumber;
            }
            if (start < buffer.length()) {
                String rName = null;
                String resName = null;
                String textNumberString = String.format("%0" + iLen + "d", textNumber);
                File resFile = null;
                String folderPath = this.controller.getFldFolder().getText();
                if (this.controller.getRdbtnStoreAllFiles().isSelected()) {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(folderPath) + System.getProperty("file.separator") + rName;
                } else {
                    rName = String.valueOf(this.controller.getFldBaseName().getText()) + textNumberString + "." + extension;
                    resName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + rName;
                }
                BufferedWriter writer = null;
                if (this.controller.getRdbtnAsciiOrBytemarked().isSelected()) {
                    try {
                        resFile = new File(resName);
                        outputStreamWriter = new OutputStreamWriter(new FileOutputStream(resFile));
                        writer = new BufferedWriter(outputStreamWriter);
                    }
                    catch (FileNotFoundException e1) {
                        try {
                            if (outputStreamWriter != null) {
                                outputStreamWriter.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                        return;
                    }
                }
                try {
                    resFile = new File(resName);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(resFile, false), encodingCode);
                    writer = new BufferedWriter(outputStreamWriter);
                }
                catch (FileNotFoundException e1) {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                catch (UnsupportedEncodingException e2) {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Encoding not supported." + resName, "NooJ", 1);
                    return;
                }
                try {
                    writer.write(buffer.substring(start));
                }
                catch (IOException e1) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + resName, "NooJ", 1);
                    return;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                if (this.controller.getRdbtnBuildACorpus().isSelected()) {
                    try {
                        corpus.addTextFile(corpusDirName, resName, null);
                        resFile.delete();
                    }
                    catch (ClassNotFoundException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                    catch (BadLocationException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while adding text file to corpus!", 0);
                        return;
                    }
                }
                ++textNumber;
            }
        }
        if (corpus != null) {
            try {
                corpus.saveIn(corpusDirName);
                String destinationZipFilePath = this.controller.getFldCorpus().getText();
                Zip.compressDir(corpusDirName, destinationZipFilePath);
                Utils.deleteDir(corpusDir);
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Corpus " + destinationZipFilePath + " contains " + (textNumber - 1) + " files.", "NooJ", 1);
                return;
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while saving corpus to corpus directory!", 0);
                return;
            }
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: " + (textNumber - 1) + " files created in folder: " + this.controller.getFldFolder().getText(), "NooJ", 1);
    }
}

