/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.CorpusEditorShell.TableSorterActionListener;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TextIO;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class AddActionListener
implements ActionListener {
    private static final String PROCESS_NONE_TXT_FILES_AS_TXT = "Are you sure you want to process files as RAW TXTs?";
    private static final String PROCESS_NONE_TXT_FILES_AS_TXT_TITLE = "NooJ: suspicious file name extension";
    private CorpusEditorShellController controller;
    private JInternalFrame frame;
    private Corpus corpus;
    private String encodingName;
    private boolean alreadyAsked = false;

    public AddActionListener(CorpusEditorShellController controller, JInternalFrame frame) {
        this.controller = controller;
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.corpus = this.controller.getCorpus();
        this.encodingName = this.corpus.encodingName;
        FileNameExtensionFilter filter = null;
        filter = this.encodingName.equalsIgnoreCase("WORD") ? new FileNameExtensionFilter("MS-WORD Documents (*.doc)|*.doc", "doc") : (this.encodingName.equalsIgnoreCase("HTML") ? new FileNameExtensionFilter("HTML Pages (*.htm;*.html)|*.htm; *.html", "htm") : (this.encodingName.equalsIgnoreCase("XML") ? new FileNameExtensionFilter("XML Documents (*.xml)|*.xml", "xml") : (this.encodingName.equalsIgnoreCase("RTF") ? new FileNameExtensionFilter("RTF Documents (*.rtf)|*.rtf", "rtf") : new FileNameExtensionFilter("Text Files (*.txt)|*.txt", "txt"))));
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showOpenDialog(this.frame);
        final File[] selectedFiles = jFileChooser.getSelectedFiles();
        if (result == 0) {
            jFileChooser.removeChoosableFileFilter(filter);
            if (this.encodingName.equals("Default")) {
                File[] fileArray = selectedFiles;
                int n = selectedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String extension = FilenameUtils.getExtension(file.getName());
                    if (extension.equalsIgnoreCase("doc") || extension.equalsIgnoreCase("htm") || extension.equalsIgnoreCase("html") || extension.equalsIgnoreCase("xml") || extension.equalsIgnoreCase("rtf")) {
                        this.alreadyAsked = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.alreadyAsked) {
                int optionType = 2;
                int messageType = 2;
                final JButton ok = new JButton("OK");
                final JButton cancel = new JButton("Cancel");
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AddActionListener.this.alreadyAsked = false;
                        AddActionListener.closeDialogWindow(ok);
                        AddActionListener.this.processFilesAndUpdate(selectedFiles);
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AddActionListener.closeDialogWindow(cancel);
                    }
                });
                Object[] selValues = new Object[]{ok, cancel};
                JOptionPane.showOptionDialog(Launcher.getDesktopPane(), PROCESS_NONE_TXT_FILES_AS_TXT, PROCESS_NONE_TXT_FILES_AS_TXT_TITLE, optionType, messageType, null, selValues, selValues[0]);
            } else {
                this.processFilesAndUpdate(selectedFiles);
            }
            this.updateEditCorpusWindow();
        } else if (result == 1) {
            jFileChooser.removeChoosableFileFilter(filter);
        }
        JTable table = this.controller.getTableTexts();
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        TableSorterActionListener tableSorterActionListener = this.controller.getShell().getTableSorterActionListener();
        tableSorterActionListener.sortTheTable(this.controller.getTableTexts(), tableModel, tableSorterActionListener.getIndex());
    }

    private void processFilesAndUpdate(File[] selectedFiles) {
        File[] fileArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Mft nTextMft;
            File f = fileArray[n2];
            this.addFileToCorpus(f);
            Ntext nText = null;
            String filePath = f.getAbsolutePath();
            if (FilenameUtils.getExtension(f.getName()).equals("jnot") && this.encodingName.equals("Default")) {
                String errorMessage = "";
                RefObject<String> errorMessageRef = new RefObject<String>(errorMessage);
                try {
                    nText = Ntext.load(filePath, this.corpus.languageName, errorMessageRef);
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading Ntext!", 0);
                    return;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading Ntext!", 0);
                    return;
                }
                if (nText == null) {
                    System.out.println("NooJ: text file format does not match corpus file format!\nFormat is incorrect for file: " + filePath + "\n" + (String)errorMessageRef.argvalue);
                }
            } else {
                nText = new Ntext(this.corpus);
                try {
                    nText.buffer = TextIO.loadText(filePath, this.corpus.encodingType, this.corpus.encodingCode, this.encodingName, this.corpus.lan.chartable);
                }
                catch (IOException e) {
                    System.out.println("NooJ: text file format does not match corpus file format!\nFormat is incorrect for file: " + filePath + "\n" + e.getMessage());
                    return;
                }
                catch (BadLocationException e) {
                    System.out.println("NooJ: text file format does not match corpus file format!\nFormat is incorrect for file: " + filePath + "\n" + e.getMessage());
                    return;
                }
            }
            if (nText.buffer.equals("")) {
                System.out.println("Cannot load Text from file " + filePath);
                return;
            }
            nText.DelimPattern = this.corpus.delimPattern;
            nText.XmlNodes = this.corpus.xmlNodes;
            Engine engine = this.controller.getEngine();
            if (engine != null) {
                if (this.corpus.xmlNodes != null) {
                    nText.delimitXmlTextUnitsAndImportXmlTags(this.corpus, engine, this.corpus.xmlNodes, this.corpus.annotations, this.corpus.hLexemes, this.corpus.hPhrases);
                } else {
                    nText.delimitTextUnits(engine);
                }
            }
            if ((nTextMft = nText.mft) != null) {
                nTextMft.beforeSaving(nTextMft.multiplier);
            }
            String fileNameWithoutExtension = FilenameUtils.removeExtension(f.getName());
            String fullFilePath = String.valueOf(this.controller.getFullPath()) + "_dir" + System.getProperty("file.separator") + fileNameWithoutExtension + "." + "jnot";
            File file = new File(fullFilePath);
            long fileSize = file.length();
            TableModel model = this.controller.getTableTexts().getModel();
            Date date = new Date(f.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String dateString = sdf.format(date);
            Object[] obj = new Object[]{fileNameWithoutExtension, fileSize, dateString, nText};
            ((DefaultTableModel)model).addRow(obj);
            ++n2;
        }
        this.controller.getCorpus().annotations = null;
        this.controller.setModified(true);
        this.controller.updateTitle();
        this.controller.updateTextPaneStats();
        this.controller.updateResults();
    }

    private void addFileToCorpus(File file) {
        boolean i = false;
        if (i < true && this.corpus.lan.chartable == null) {
            String chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + this.corpus.lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "charvariants.txt";
            File fileCharvians = new File(chartName);
            if (!fileCharvians.exists()) {
                chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + this.corpus.lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "_charvariants.txt";
                fileCharvians = new File(chartName);
                if (fileCharvians.exists()) {
                    AddActionListener.tryToLoadCharVariants(chartName, this.corpus.lan);
                }
            } else {
                AddActionListener.tryToLoadCharVariants(chartName, this.corpus.lan);
            }
        }
        this.suiteFunction(file);
    }

    public static void closeDialogWindow(Component componentInWindow) {
        Window w = SwingUtilities.getWindowAncestor(componentInWindow);
        if (w != null) {
            w.dispose();
        }
    }

    private void suiteFunction(File file) {
        String corpusDirName = String.valueOf(this.controller.getFullPath()) + "_dir";
        try {
            this.corpus.addTextFile(corpusDirName, file.getAbsolutePath(), this.controller.getEngine());
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot add text file!" + file.getName(), "NooJ WARNING: Cannot add text file!", 1);
            return;
        }
        this.controller.setModified(true);
    }

    public static void tryToLoadCharVariants(String chartName, Language lan) {
        StringBuilder errorMessage = new StringBuilder("");
        try {
            if (!lan.loadCharacterVariants(chartName, errorMessage)) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Warning: cannot load characters' variants file " + chartName, "NooJ WARNING: " + errorMessage, 1);
                return;
            }
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Warning: cannot load characters' variants file " + chartName, "NooJ WARNING: " + errorMessage, 1);
            return;
        }
    }

    private void updateEditCorpusWindow() {
        this.controller.updateTextPaneStats();
        this.controller.updateTitle();
    }
}

