/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;

public class AmbiguitiesUnambiguitiesActionListener
implements ActionListener {
    private boolean isButtonPressed;
    private CorpusEditorShellController corpusController;
    private TextEditorShellController textController;
    private AmbiguitiesUnambiguitiesDialog auDialog;
    private boolean areAmbiguities;

    public AmbiguitiesUnambiguitiesActionListener(CorpusEditorShellController corpusController, TextEditorShellController textController, AmbiguitiesUnambiguitiesDialog ambiguitiesUnambigutiesDialog, boolean areAmbiguities, boolean buttonPressed) {
        this.isButtonPressed = buttonPressed;
        this.corpusController = corpusController;
        this.textController = textController;
        this.auDialog = ambiguitiesUnambigutiesDialog;
        this.areAmbiguities = areAmbiguities;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isButtonPressed) {
            ConcordanceShellController concordanceController;
            JTable ambigUnambigTable = this.auDialog.getTableAmbigUnambig();
            DefaultTableModel tableModel = (DefaultTableModel)ambigUnambigTable.getModel();
            int[] selectedItems = ambigUnambigTable.getSelectedRows();
            int selectedItemsLength = selectedItems.length;
            int k = 0;
            while (k < selectedItemsLength) {
                selectedItems[k] = ambigUnambigTable.convertRowIndexToModel(selectedItems[k]);
                ++k;
            }
            if (selectedItemsLength == 0) {
                return;
            }
            JButton button = (JButton)e.getSource();
            Color currentColor = ((ColoredJButtonUI)button.getUI()).getBackgroundColor();
            if (currentColor.equals(Color.GRAY)) {
                currentColor = Color.BLACK;
            }
            ArrayList<Object> seqOfAnnotations = new ArrayList<Object>();
            if (this.areAmbiguities) {
                String analysis = this.auDialog.getComboPattern().getSelectedItem().toString();
                if (analysis.equals("") || analysis.charAt(0) != '<' || analysis.charAt(analysis.length() - 1) != '>') {
                    return;
                }
                if (this.corpusController != null && this.corpusController.getShell() != null) {
                    ConcordanceShell concordanceShell;
                    this.corpusController.setListOfConcordanceFiles(null);
                    this.corpusController.setListOfColors(null);
                    this.corpusController.setAbsoluteBeginAddresses(null);
                    this.corpusController.setAbsoluteEndAddresses(null);
                    TextEditorShellController corpusTextController = this.corpusController.getTextController();
                    if (corpusTextController != null) {
                        CustomJSpinner spinner = corpusTextController.getTextShell().getSpinner();
                        spinner.setCustomValue(1);
                    }
                    if ((concordanceController = this.corpusController.getConcordanceController()) != null) {
                        concordanceShell = concordanceController.getConcordanceShell();
                        concordanceShell.getCustomForegroundTableRenderer().setSortedPreview(false);
                        concordanceShell.getCustomForegroundTableRenderer().setColoredRowsMap(new HashMap<Integer, Color>());
                        concordanceShell.dispose();
                        concordanceController.setTableModel(null);
                        concordanceController = null;
                    }
                    concordanceShell = new ConcordanceShell(this.corpusController, this.corpusController.getTextController());
                    Launcher.getDesktopPane().add(concordanceShell);
                    concordanceShell.setVisible(true);
                    this.corpusController.setConcordanceController(concordanceShell.getController());
                    concordanceController = concordanceShell.getController();
                    CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                    renderer.setSortedPreview(false);
                    renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                    concordanceController.setTheItems(new ArrayList<Object>());
                    Corpus corpus = this.corpusController.getCorpus();
                    ArrayList<String> listOfTextFiles = corpus.listOfFileTexts;
                    int i = 0;
                    while (i < selectedItemsLength) {
                        for (String fileName : listOfTextFiles) {
                            String fullPath = String.valueOf(this.corpusController.getFullPath()) + "_dir" + System.getProperty("file.separator") + fileName;
                            Ntext myText = null;
                            try {
                                myText = Ntext.loadForCorpus(fullPath, corpus.lan, corpus.multiplier);
                            }
                            catch (IOException e1) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                                return;
                            }
                            ArrayList positions = (ArrayList)tableModel.getValueAt(selectedItems[i], 2);
                            int j = 0;
                            while (j < positions.size()) {
                                double absoluteBeginAddress = (Double)positions.get(j);
                                double absoluteEndAddress = (Double)positions.get(j + 1);
                                String fileNameInConcordance = positions.get(j + 2).toString();
                                if (fileName.equals(fileNameInConcordance)) {
                                    double tuNumb = Double.valueOf(positions.get(j + 3).toString());
                                    int tuNb = (int)tuNumb;
                                    seqOfAnnotations.add(tuNb);
                                    seqOfAnnotations.add(analysis);
                                    seqOfAnnotations.add(absoluteBeginAddress);
                                    seqOfAnnotations.add(absoluteEndAddress);
                                    seqOfAnnotations.add(absoluteBeginAddress);
                                    seqOfAnnotations.add(analysis);
                                    seqOfAnnotations.add(absoluteBeginAddress);
                                    concordanceController.AddData(myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                                }
                                j += 4;
                            }
                        }
                        ++i;
                    }
                } else {
                    ConcordanceShell concordanceShell;
                    this.textController.setListOfColors(null);
                    this.textController.setAbsoluteBeginAddresses(null);
                    this.textController.setAbsoluteEndAddresses(null);
                    CustomJSpinner spinner = this.textController.getTextShell().getSpinner();
                    spinner.setCustomValue(1);
                    concordanceController = this.textController.getConcordanceController();
                    if (concordanceController == null) {
                        concordanceShell = new ConcordanceShell(this.corpusController, this.textController);
                        Launcher.getDesktopPane().add(concordanceShell);
                        concordanceShell.setVisible(true);
                    } else {
                        concordanceShell = concordanceController.getConcordanceShell();
                        concordanceShell.getCustomForegroundTableRenderer().setSortedPreview(false);
                    }
                    concordanceController = concordanceShell.getController();
                    CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                    renderer.setSortedPreview(false);
                    renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                    this.textController.setConcordanceController(concordanceController);
                    concordanceController.setTheItems(new ArrayList<Object>());
                    int i = 0;
                    while (i < selectedItemsLength) {
                        ArrayList positions = (ArrayList)tableModel.getValueAt(selectedItems[i], 2);
                        int j = 0;
                        while (j < positions.size()) {
                            double absoluteBeginAddress = (Double)positions.get(j);
                            double absoluteEndAddress = (Double)positions.get(j + 1);
                            double tuNumb = Double.valueOf(positions.get(j + 2).toString());
                            int tuNb = (int)tuNumb;
                            seqOfAnnotations.add(tuNb);
                            seqOfAnnotations.add(analysis);
                            seqOfAnnotations.add(absoluteBeginAddress);
                            seqOfAnnotations.add(absoluteEndAddress);
                            seqOfAnnotations.add(absoluteBeginAddress);
                            seqOfAnnotations.add(analysis);
                            seqOfAnnotations.add(absoluteBeginAddress);
                            concordanceController.AddData(this.textController.getMyText(), "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                            j += 3;
                        }
                        ++i;
                    }
                }
            } else {
                String analysis = tableModel.getValueAt(selectedItems[0], 1).toString();
                if (analysis.equals("") || analysis.charAt(0) != '<' || analysis.charAt(analysis.length() - 1) != '>') {
                    return;
                }
                ArrayList positions = (ArrayList)tableModel.getValueAt(selectedItems[0], 2);
                if (this.corpusController != null && this.corpusController.getShell() != null) {
                    ConcordanceShell concordanceShell;
                    this.corpusController.setListOfConcordanceFiles(null);
                    this.corpusController.setListOfColors(null);
                    this.corpusController.setAbsoluteBeginAddresses(null);
                    this.corpusController.setAbsoluteEndAddresses(null);
                    TextEditorShellController corpusTextController = this.corpusController.getTextController();
                    if (corpusTextController != null) {
                        CustomJSpinner spinner = corpusTextController.getTextShell().getSpinner();
                        spinner.setCustomValue(1);
                    }
                    if ((concordanceController = this.corpusController.getConcordanceController()) != null) {
                        concordanceShell = concordanceController.getConcordanceShell();
                        concordanceShell.dispose();
                        concordanceController = null;
                    }
                    concordanceShell = new ConcordanceShell(this.corpusController, this.corpusController.getTextController());
                    Launcher.getDesktopPane().add(concordanceShell);
                    concordanceShell.setVisible(true);
                    this.corpusController.setConcordanceController(concordanceShell.getController());
                    concordanceController = concordanceShell.getController();
                    CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                    renderer.setSortedPreview(false);
                    renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                    concordanceController.setTheItems(new ArrayList<Object>());
                    Corpus corpus = this.corpusController.getCorpus();
                    ArrayList<String> listOfTextFiles = corpus.listOfFileTexts;
                    for (String fileName : listOfTextFiles) {
                        String fullPath = String.valueOf(this.corpusController.getFullPath()) + "_dir" + System.getProperty("file.separator") + fileName;
                        Ntext myText = null;
                        try {
                            myText = Ntext.loadForCorpus(fullPath, corpus.lan, corpus.multiplier);
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                            return;
                        }
                        int j = 0;
                        while (j < positions.size()) {
                            double absoluteBeginAddress = (Double)positions.get(j);
                            double absoluteEndAddress = (Double)positions.get(j + 1);
                            String fileNameInConcordance = positions.get(j + 2).toString();
                            if (fileName.equals(fileNameInConcordance)) {
                                double tuNumb = Double.valueOf(positions.get(j + 3).toString());
                                int tuNb = (int)tuNumb;
                                seqOfAnnotations.add(tuNb);
                                seqOfAnnotations.add(analysis);
                                seqOfAnnotations.add(absoluteBeginAddress);
                                seqOfAnnotations.add(absoluteEndAddress);
                                seqOfAnnotations.add(absoluteBeginAddress);
                                seqOfAnnotations.add(analysis);
                                seqOfAnnotations.add(absoluteBeginAddress);
                                concordanceController.AddData(myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                            }
                            j += 4;
                        }
                    }
                } else {
                    ConcordanceShell concordanceShell;
                    this.textController.setListOfColors(null);
                    this.textController.setAbsoluteBeginAddresses(null);
                    this.textController.setAbsoluteEndAddresses(null);
                    CustomJSpinner spinner = this.textController.getTextShell().getSpinner();
                    spinner.setCustomValue(1);
                    concordanceController = this.textController.getConcordanceController();
                    if (concordanceController == null) {
                        concordanceShell = new ConcordanceShell(this.corpusController, this.textController);
                        Launcher.getDesktopPane().add(concordanceShell);
                        concordanceShell.setVisible(true);
                    } else {
                        concordanceShell = concordanceController.getConcordanceShell();
                    }
                    concordanceController = concordanceShell.getController();
                    CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                    renderer.setSortedPreview(false);
                    renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                    this.textController.setConcordanceController(concordanceController);
                    concordanceController.setTheItems(new ArrayList<Object>());
                    int j = 0;
                    while (j < positions.size()) {
                        double absoluteBeginAddress = (Double)positions.get(j);
                        double absoluteEndAddress = (Double)positions.get(j + 1);
                        double tuNumb = Double.valueOf(positions.get(j + 2).toString());
                        int tuNb = (int)tuNumb;
                        seqOfAnnotations.add(tuNb);
                        seqOfAnnotations.add(analysis);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        seqOfAnnotations.add(absoluteEndAddress);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        seqOfAnnotations.add(analysis);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        concordanceController.AddData(this.textController.getMyText(), "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                        j += 3;
                    }
                }
            }
            concordanceController.refreshConcordance();
            ambigUnambigTable.clearSelection();
        } else {
            AmbiguitiesUnambiguitiesActionListener.fillTheTable(this.corpusController, this.textController, this.auDialog, this.areAmbiguities);
        }
    }

    private static String keepOnlyCategory(String ambig) {
        String[] tokensList = Dic.parseSequenceOfSymbols(ambig);
        StringBuilder result = new StringBuilder();
        String[] stringArray = tokensList;
        int n = tokensList.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            int tPos = t.indexOf(",");
            if (tPos == -1) {
                result.append(t);
            } else {
                ++tPos;
                int i = 0;
                while (tPos + i < t.length() && Character.isUpperCase(t.charAt(tPos + i))) {
                    ++i;
                }
                if (i == 0) {
                    result.append(t);
                } else {
                    String cat = t.substring(tPos, tPos + i);
                    result.append("<" + cat + "> ");
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public static void fillTheTable(CorpusEditorShellController corpusController, TextEditorShellController textController, AmbiguitiesUnambiguitiesDialog auDialog, boolean areAmbiguities) {
        HashMap<Object, Object> hList = new HashMap();
        JTable tableAmbigUnambig = auDialog.getTableAmbigUnambig();
        DefaultTableModel tableModel = (DefaultTableModel)tableAmbigUnambig.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        if (auDialog.isACorpus()) {
            hList = areAmbiguities ? corpusController.getCorpus().hAmbiguities : corpusController.getCorpus().hUnambiguities;
            for (String string : hList.keySet()) {
                Object[] obj;
                ArrayList positions = (ArrayList)hList.get(string);
                int freq = positions.size() / 4;
                if (auDialog.getcBoxDisplayCategories().isSelected()) {
                    obj = new Object[]{freq, AmbiguitiesUnambiguitiesActionListener.keepOnlyCategory(string), positions};
                    tableModel.addRow(obj);
                    continue;
                }
                obj = new Object[]{freq, string, positions};
                tableModel.addRow(obj);
            }
            tableAmbigUnambig.setModel(tableModel);
        } else {
            hList = areAmbiguities ? textController.getMyText().hAmbiguities : textController.getMyText().hUnambiguities;
            for (String string : hList.keySet()) {
                Object[] obj;
                ArrayList positions = (ArrayList)hList.get(string);
                int freq = positions.size() / 3;
                if (auDialog.getcBoxDisplayCategories().isSelected() && areAmbiguities) {
                    obj = new Object[]{freq, AmbiguitiesUnambiguitiesActionListener.keepOnlyCategory(string), positions};
                    tableModel.addRow(obj);
                    continue;
                }
                obj = new Object[]{freq, string, positions};
                tableModel.addRow(obj);
            }
            tableAmbigUnambig.setModel(tableModel);
        }
        AmbiguitiesUnambiguitiesActionListener.setWidthOfTableColumn(tableAmbigUnambig, tableModel, 0);
        AmbiguitiesUnambiguitiesActionListener.setWidthOfTableColumn(tableAmbigUnambig, tableModel, 1);
    }

    private static void setWidthOfTableColumn(JTable table, DefaultTableModel tableModel, int column) {
        int width = 0;
        int row = 0;
        while (row < tableModel.getRowCount()) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
            ++row;
        }
        if (column == 0 && width < 50) {
            width = 50;
        } else if (column != 0 && width < 230) {
            width = 230;
        }
        table.getColumnModel().getColumn(column).setMaxWidth(width + 5);
        table.getColumnModel().getColumn(column).setPreferredWidth(width + 5);
    }
}

