/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AlphabetDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.CorpusEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class CloseInternalFrameListener
implements InternalFrameListener {
    private CorpusEditorShellController controller;
    private JInternalFrame frame;

    public CloseInternalFrameListener(CorpusEditorShellController controller, JInternalFrame frame) {
        this.controller = controller;
        this.frame = frame;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.frame.getClass().equals(CorpusEditorShell.class)) {
            this.frame.setDefaultCloseOperation(2);
            if (Launcher.backgroundWorking) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot close window: Press 'Cancel'", "NooJ: a process is running", 1);
                this.controller.setBeingClosed(false);
                this.frame.setDefaultCloseOperation(0);
                return;
            }
            this.controller.setBeingClosed(true);
            if (this.controller.getCorpus() == null) {
                return;
            }
            CorpusEditorShell shell = this.controller.getShell();
            if (shell.getAlphabetDialog() != null) {
                shell.getAlphabetDialog().dispose();
            }
            if (shell.getDigramsDialog() != null) {
                shell.getDigramsDialog().dispose();
            }
            if (shell.getTokensDialog() != null) {
                shell.getTokensDialog().dispose();
            }
            if (shell.getAmbiguitiesDialog() != null) {
                shell.getAmbiguitiesDialog().dispose();
            }
            if (shell.getUnAmbiguitiesDialog() != null) {
                shell.getUnAmbiguitiesDialog().dispose();
            }
            TextEditorShellController textController = this.controller.getTextController();
            ConcordanceShellController concordanceController = this.controller.getConcordanceController();
            if (concordanceController != null) {
                concordanceController.getConcordanceShell().dispose();
                if (textController != null) {
                    textController.setConcordanceController(null);
                }
                concordanceController.setTableModel(null);
                CustomForegroundTableRenderer customForegroundTableRenderer = (CustomForegroundTableRenderer)concordanceController.getConcordanceTable().getDefaultRenderer(Object.class);
                customForegroundTableRenderer.setSortedPreview(false);
                customForegroundTableRenderer.setColoredRowsMap(new HashMap<Integer, Color>());
            }
            if (textController != null) {
                TextEditorShell textShell = textController.getTextShell();
                textShell.setAlphabetDialog(null);
                textShell.dispose();
            }
            if (this.controller.getLocateDialog() != null) {
                this.controller.getLocateDialog().dispose();
            }
            if (shell.getExportXmlDialog() != null) {
                shell.getExportXmlDialog().dispose();
            }
            if (this.controller.isModified() && !Launcher.projectMode) {
                int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save Corpus?", "NooJ: corpus has not been saved", 0);
                if (answer == 0) {
                    this.controller.saveCorpus();
                } else {
                    String corpusDirName = String.valueOf(this.controller.getFullPath()) + "_dir";
                    File corpusDir = new File(corpusDirName);
                    Utils.deleteDir(corpusDir);
                }
            }
            this.controller.desactivateOps();
        } else if (this.frame.getClass().equals(AlphabetDialog.class)) {
            AlphabetDialog dialog = (AlphabetDialog)this.frame;
            if (dialog.getCorpusController() != null) {
                dialog.getCorpusController().getShell().setAlphabetDialog(null);
            } else if (dialog.getTextController() != null) {
                dialog.getTextController().getTextShell().setAlphabetDialog(null);
            }
            dialog.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }
}

