/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AlphabetDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.utilities.Helper;

public class ComputeMouseAdapter
extends MouseAdapter {
    private CorpusEditorShellController controller;
    private JList list;
    private AlphabetDialog alphabetDialog;
    private TokensDigramsDialog tokensDialog;
    private TokensDigramsDialog digramsDialog;
    private AmbiguitiesUnambiguitiesDialog ambiguitiesDialog;
    private AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog;

    public ComputeMouseAdapter(CorpusEditorShellController controller, JList list) {
        this.controller = controller;
        this.list = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) return;
        try {
            CursorChangeEffect.setCustomCursor(3);
            int index = this.list.locationToIndex(e.getPoint());
            ListModel listModel = this.list.getModel();
            Object item = listModel.getElementAt(index);
            this.list.ensureIndexIsVisible(index);
            if (item.equals("Characters")) {
                this.alphabetDialog = this.controller.getShell().getAlphabetDialog();
                if (this.alphabetDialog != null) {
                    Helper.putDialogOnTheTop(this.alphabetDialog);
                    return;
                }
                this.alphabetDialog = new AlphabetDialog(this.controller, null);
                this.alphabetDialog.fillInTheData(true);
                this.controller.getShell().setAlphabetDialog(this.alphabetDialog);
                Launcher.getDesktopPane().add(this.alphabetDialog);
                this.alphabetDialog.setVisible(true);
                Helper.putDialogOnTheTop(this.alphabetDialog);
                return;
            }
            if (item.equals("Tokens")) {
                if (this.controller.getCorpus().annotations == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please perform linguistic analysis first.", "NooJ", 1);
                    return;
                }
                this.tokensDialog = this.controller.getShell().getTokensDialog();
                if (this.tokensDialog != null) {
                    Helper.putDialogOnTheTop(this.tokensDialog);
                    return;
                }
                this.tokensDialog = new TokensDigramsDialog(this.controller, null, true);
                this.tokensDialog.fillInTheData();
                this.controller.getShell().setTokensDialog(this.tokensDialog);
                Launcher.getDesktopPane().add(this.tokensDialog);
                this.tokensDialog.setVisible(true);
                Helper.putDialogOnTheTop(this.tokensDialog);
                return;
            }
            if (item.equals("Digrams")) {
                this.digramsDialog = this.controller.getShell().getDigramsDialog();
                if (this.digramsDialog != null) {
                    Helper.putDialogOnTheTop(this.digramsDialog);
                    return;
                }
                this.digramsDialog = new TokensDigramsDialog(this.controller, null, false);
                this.digramsDialog.fillInTheData();
                this.controller.getShell().setDigramsDialog(this.digramsDialog);
                Launcher.getDesktopPane().add(this.digramsDialog);
                this.digramsDialog.setVisible(true);
                Helper.putDialogOnTheTop(this.digramsDialog);
                return;
            }
            if (item.equals("Annotations")) {
                DictionaryEditorShell annotationsEditor = new DictionaryEditorShell();
                this.controller.fillInVocabulary(annotationsEditor);
                Launcher.getDesktopPane().add(annotationsEditor);
                annotationsEditor.setVisible(true);
                annotationsEditor.getController().modify();
                return;
            }
            if (item.equals("Unknowns")) {
                DictionaryEditorShell unknownsEditor = new DictionaryEditorShell();
                this.controller.fillInUnknowns(unknownsEditor);
                Launcher.getDesktopPane().add(unknownsEditor);
                unknownsEditor.setVisible(true);
                unknownsEditor.getController().modify();
                return;
            }
            if (item.equals("Ambiguities")) {
                this.ambiguitiesDialog = this.controller.getShell().getAmbiguitiesDialog();
                if (this.ambiguitiesDialog != null) {
                    Helper.putDialogOnTheTop(this.ambiguitiesDialog);
                    return;
                }
                this.ambiguitiesDialog = new AmbiguitiesUnambiguitiesDialog(this.controller, null, true);
                this.ambiguitiesDialog.fillInTheData();
                this.controller.getShell().setAmbiguitiesDialog(this.ambiguitiesDialog);
                Launcher.getDesktopPane().add(this.ambiguitiesDialog);
                this.ambiguitiesDialog.setVisible(true);
                Helper.putDialogOnTheTop(this.ambiguitiesDialog);
                return;
            }
            if (!item.equals("Unambiguous Words")) return;
            this.unAmbiguitiesDialog = this.controller.getShell().getUnAmbiguitiesDialog();
            if (this.unAmbiguitiesDialog != null) {
                Helper.putDialogOnTheTop(this.unAmbiguitiesDialog);
                return;
            }
            this.unAmbiguitiesDialog = new AmbiguitiesUnambiguitiesDialog(this.controller, null, false);
            this.unAmbiguitiesDialog.fillInTheData();
            this.controller.getShell().setUnAmbiguitiesDialog(this.unAmbiguitiesDialog);
            Launcher.getDesktopPane().add(this.unAmbiguitiesDialog);
            this.unAmbiguitiesDialog.setVisible(true);
            Helper.putDialogOnTheTop(this.unAmbiguitiesDialog);
            return;
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }
}

