/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.engine.Zip;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.LocateDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.CorpusEditorShell;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class CorpusEditorShellController {
    private Engine engine;
    private Corpus corpus;
    private String fullPath;
    private String fullName;
    private CorpusEditorShell shell;
    private TextEditorShell textShell;
    private TextEditorShellController textController = null;
    private ConcordanceShellController concordanceController = null;
    private LocateDialog locateDialog;
    private boolean modified;
    private boolean colored = false;
    private boolean beingClosed;
    private JTextPane textPaneStats;
    private JTable tableTexts;
    private JList listResults;
    private List<String> locateGrammarMemoryList = new ArrayList<String>();
    private List<String> locateRegexMemoryList = new ArrayList<String>();
    private List<Color> listOfColors = null;
    private List<Integer> absoluteBeginAddresses = null;
    private List<Integer> absoluteEndAddresses = null;
    private List<String> listOfConcordanceFiles = null;

    public CorpusEditorShellController(CorpusEditorShell shell, JTextPane textPaneStats, JTable tableTexts, JList listResults) {
        this.shell = shell;
        this.textPaneStats = textPaneStats;
        this.tableTexts = tableTexts;
        this.listResults = listResults;
        this.modified = false;
        this.beingClosed = false;
    }

    public void createAndSaveNewCorpus(String delimPattern, String[] xmlNodes, int encodingType, String encodingCode, String encodingName, String languageName, File corpusDirectory, String corpusName) {
        this.corpus = new Corpus(delimPattern, xmlNodes, encodingType, encodingCode, encodingName, languageName);
        if (corpusDirectory.isDirectory()) {
            String directoryPath = corpusDirectory.getPath();
            String nocFilePath = String.valueOf(directoryPath) + System.getProperty("file.separator") + corpusName + "." + "jnoc";
            String corpusDirPath = String.valueOf(nocFilePath) + "_dir";
            File corpusDir = new File(corpusDirPath);
            if (corpusDir.exists()) {
                Utils.deleteDir(corpusDir);
            }
            new File(corpusDirPath).mkdir();
            try {
                this.corpus.saveIn(corpusDirPath);
                Zip.compressDir(corpusDirPath, nocFilePath);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while opening new (empty) corpus.", "NooJ", 0);
                return;
            }
        }
    }

    public CorpusEditorShell openNoojCorpus(File file, boolean isNewCorpus) {
        this.loadCorpusFromFile(file);
        CorpusEditorShell editor = new CorpusEditorShell(this);
        Launcher.getDesktopPane().add(editor);
        editor.setVisible(true);
        if (isNewCorpus) {
            this.setModified(true);
        } else {
            this.setModified(false);
        }
        return editor;
    }

    private void loadCorpusFromFile(File file) {
        this.setFullPath(file.getAbsolutePath());
        this.setFullName(file.getName());
        try {
            this.setCorpus(Corpus.load(file.getAbsolutePath(), Launcher.preferences.deflanguage));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading corpus from its directory!", 0);
            return;
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading corpus from its directory!", 0);
            return;
        }
        if (this.getCorpus() == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + file.getName(), "Nooj: Corpus file is corrupted", 0);
            return;
        }
    }

    public void openNoojEngine() {
        Corpus corpus = this.getCorpus();
        RefObject<Language> corpusLanRef = new RefObject<Language>(corpus.lan);
        Engine engine = new Engine(corpusLanRef, Paths.applicationDir, Paths.docDir, Launcher.preferences.openProjDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        this.setEngine(engine);
        corpus.lan = (Language)corpusLanRef.argvalue;
        this.setCorpus(corpus);
    }

    public void updateTextPaneStats() {
        this.textPaneStats.setText("");
        StringBuilder textToBeSet = new StringBuilder();
        textToBeSet.append("Corpus language is \"" + this.corpus.lan.engName + "\"\n");
        textToBeSet.append("Original Text File format is \"" + this.corpus.encodingName + "\".\n");
        textToBeSet.append("Corpus consists of " + this.tableTexts.getModel().getRowCount() + " text files.\n");
        String[] xmlNodes = this.corpus.xmlNodes;
        if (xmlNodes != null) {
            textToBeSet.append("XML Text Nodes are: ");
            String[] stringArray = xmlNodes;
            int n = xmlNodes.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                textToBeSet.append(String.valueOf(tag) + " ");
                ++n2;
            }
            textToBeSet.append("\n");
        } else if (this.corpus.delimPattern.equals("")) {
            textToBeSet.append("Corpus has no delimiter => processed each text as one TU\n");
        } else if (this.corpus.delimPattern.equals("\n")) {
            textToBeSet.append("Text Delimiter is: \\n (NEWLINE)\n");
        } else {
            textToBeSet.append("Text Delimiter is: \"" + this.corpus.delimPattern + "\"\n");
        }
        if (this.corpus.nbOfTextUnits > 0) {
            textToBeSet.append("Corpus contains " + this.corpus.nbOfTextUnits + " text units delimited by \"" + (this.corpus.delimPattern.equals("\n") ? "\\n" : this.corpus.delimPattern) + "\"\n");
        }
        if (this.corpus.nbOfChars > 0) {
            textToBeSet.append(String.valueOf(this.corpus.nbOfChars) + " characters");
        }
        if (this.corpus.nbOfDiffChars > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffChars + " diff)");
        }
        if (this.corpus.nbOfChars > 0) {
            textToBeSet.append(", including\n");
        }
        if (this.corpus.nbOfLetters > 0) {
            textToBeSet.append("  " + this.corpus.nbOfLetters + " letters");
        }
        if (this.corpus.nbOfDiffLetters > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffLetters + " diff)");
        }
        if (this.corpus.nbOfLetters > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.nbOfDigits > 0) {
            textToBeSet.append("  " + this.corpus.nbOfDigits + " digits");
        }
        if (this.corpus.nbOfDiffDigits > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffDigits + " diff)");
        }
        if (this.corpus.nbOfDigits > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.nbOfBlanks > 0) {
            textToBeSet.append("  " + this.corpus.nbOfBlanks + " blanks");
        }
        if (this.corpus.nbOfDiffBlanks > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffBlanks + " diff)");
        }
        if (this.corpus.nbOfBlanks > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.nbOfDelimiters > 0) {
            textToBeSet.append("  " + this.corpus.nbOfDelimiters + " other delimiters");
        }
        if (this.corpus.nbOfDiffDelimiters > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffDelimiters + " diff)");
        }
        if (this.corpus.nbOfDelimiters > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.nbOfTokens > 0) {
            textToBeSet.append(String.valueOf(this.corpus.nbOfTokens) + " tokens");
        }
        if (this.corpus.nbOfDiffTokens > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffTokens + " diff)");
        }
        if (this.corpus.nbOfTokens > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.nbOfWords > 0) {
            textToBeSet.append(String.valueOf(this.corpus.nbOfWords) + " word forms");
        }
        if (this.corpus.nbOfDiffWords > 0) {
            textToBeSet.append(" (" + this.corpus.nbOfDiffWords + " diff)");
        }
        if (this.corpus.nbOfWords > 0) {
            textToBeSet.append("\n");
        }
        if (this.corpus.listOfResources != null) {
            textToBeSet.append("Linguistic Resources applied to the text:\n");
            for (String res : this.corpus.listOfResources) {
                textToBeSet.append(String.valueOf(res) + " ");
            }
            textToBeSet.append("\n");
        }
        if (this.corpus.annotations != null) {
            textToBeSet.append("Corpus contains ");
            textToBeSet.append(String.valueOf(this.corpus.annotations.size()) + " different annotations.");
        }
        this.textPaneStats.setText(textToBeSet.toString());
    }

    public void resetLv() {
        if (this.corpus.listOfFileTexts == null) {
            ((DefaultTableModel)this.tableTexts.getModel()).getDataVector().removeAllElements();
            return;
        }
        int size = this.corpus.listOfFileTexts.size();
        ((DefaultTableModel)this.tableTexts.getModel()).getDataVector().removeAllElements();
        DefaultTableModel tableModel = (DefaultTableModel)this.tableTexts.getModel();
        int i = 0;
        while (i < size) {
            String fileName = this.corpus.listOfFileTexts.get(i);
            String fileNameWithoutExtension = FilenameUtils.removeExtension(fileName);
            String fullFilePath = String.valueOf(this.getFullPath()) + "_dir" + System.getProperty("file.separator") + fileName;
            File file = new File(fullFilePath);
            long fileSize = file.length();
            Date date = new Date(file.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String dateString = sdf.format(date);
            Object[] row = new Object[]{fileNameWithoutExtension, fileSize, dateString, ""};
            tableModel.addRow(row);
            ++i;
        }
        this.tableTexts.removeColumn(this.tableTexts.getColumnModel().getColumn(3));
    }

    public void updateResults() {
        DefaultListModel model = (DefaultListModel)this.listResults.getModel();
        model.clear();
        if (this.tableTexts.getComponentCount() > 0) {
            model.addElement("Characters");
            model.addElement("Tokens");
            model.addElement("Digrams");
        }
        if (this.corpus.annotations != null) {
            if (this.corpus.annotations.size() < 1000) {
                model.addElement("Annotations");
            }
            model.addElement("Unknowns");
            model.addElement("Ambiguities");
            model.addElement("Unambiguous Words");
        }
    }

    public void updateTitle() {
        StringBuilder titleStringBuilder = new StringBuilder("Corpus ");
        titleStringBuilder.append(this.fullName);
        if (this.modified) {
            titleStringBuilder.append(" [Modified]");
        }
        this.shell.setTitle(titleStringBuilder.toString());
    }

    public void computeAlphabet() {
        String corpusDirName = String.valueOf(this.fullPath) + "_dir";
        HashMap<Character, Integer> theChars = new HashMap<Character, Integer>();
        int itemNb = 0;
        for (String itemName : this.corpus.listOfFileTexts) {
            ++itemNb;
            if (Launcher.multithread) {
                int nprogress;
                if (Launcher.backgroundWorker.isCancellationPending()) {
                    return;
                }
                if (Launcher.processName.equals("corpus alphabetisation") && (nprogress = (int)((float)itemNb * 100.0f / (float)this.corpus.listOfFileTexts.size())) != Launcher.progressPercentage) {
                    Launcher.progressPercentage = nprogress;
                    if (Launcher.backgroundWorker.isBusy()) {
                        Launcher.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            String itemFullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + itemName;
            try {
                Ntext myText = Ntext.loadForCorpus(itemFullName, this.corpus.lan, this.corpus.multiplier);
                if (myText == null) continue;
                Dic.writeLog(" > parsing " + itemName);
                this.engine.countChars(myText, theChars);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                return;
            }
        }
        this.engine.computeAlphabet(this.corpus, theChars);
        this.modified = true;
    }

    public void computeTokens() {
        this.corpus.hTokens = new HashMap();
        String corpusDirName = String.valueOf(this.fullPath) + "_dir";
        DefaultTableModel tableModel = (DefaultTableModel)this.tableTexts.getModel();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            Ntext myText;
            tableModel.getValueAt(i, 0);
            String itemNotName = tableModel.getValueAt(i, 0) + ".jnot";
            String itemFullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + itemNotName;
            Object itemTag = tableModel.getValueAt(i, 3);
            Ntext ntext = myText = itemTag.equals("") ? null : (Ntext)itemTag;
            if (myText == null) {
                try {
                    myText = Ntext.loadForCorpus(itemFullName, this.corpus.lan, this.corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
            }
            this.engine.computeTokens(this.corpus, myText);
            tableModel.setValueAt(myText, i, 3);
            ++i;
        }
        this.modified = true;
    }

    public void computeDigrams() {
        this.corpus.hDigrams = new HashMap();
        String corpusDirName = String.valueOf(this.fullPath) + "_dir";
        DefaultTableModel tableModel = (DefaultTableModel)this.tableTexts.getModel();
        int i = 0;
        while (i < this.tableTexts.getRowCount()) {
            Ntext myText;
            tableModel.getValueAt(i, 0);
            String itemNotName = tableModel.getValueAt(i, 0) + ".jnot";
            String itemFullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + itemNotName;
            Object itemTag = tableModel.getValueAt(i, 3);
            Ntext ntext = myText = itemTag.equals("") ? null : (Ntext)itemTag;
            if (myText == null) {
                try {
                    myText = Ntext.loadForCorpus(itemFullName, this.corpus.lan, this.corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
            }
            this.engine.computeDigrams(this.corpus, myText);
            tableModel.setValueAt(myText, i, 3);
            ++i;
        }
        this.modified = true;
    }

    public void computeAmbiguities(boolean areAmbiguities) {
        if (areAmbiguities) {
            this.corpus.hAmbiguities = new HashMap();
        } else {
            this.corpus.hUnambiguities = new HashMap();
        }
        String corpusDirName = String.valueOf(this.fullPath) + "_dir";
        int itemNb = 0;
        for (String itemName : this.corpus.listOfFileTexts) {
            RefObject<HashMap<String, ArrayList<Object>>> refHash;
            ++itemNb;
            if (Launcher.multithread) {
                int nprogress;
                if (Launcher.backgroundWorker.isCancellationPending()) {
                    return;
                }
                if ((Launcher.processName.equals("corpus ambiguities") || Launcher.processName.equals("corpus unambiguities")) && (nprogress = (int)((float)itemNb * 100.0f / (float)this.corpus.listOfFileTexts.size())) != Launcher.progressPercentage) {
                    Launcher.progressPercentage = nprogress;
                    if (Launcher.backgroundWorker.isBusy()) {
                        Launcher.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            String itemFullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + itemName;
            Ntext myText = null;
            try {
                myText = Ntext.loadForCorpus(itemFullName, this.corpus.lan, this.corpus.multiplier);
                if (myText == null) continue;
                Dic.writeLog(" > parsing " + itemName);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                return;
            }
            if (areAmbiguities) {
                refHash = new RefObject<HashMap<String, ArrayList<Object>>>(this.corpus.hAmbiguities);
                this.engine.computeAmbiguities(this.corpus, itemName, myText, this.corpus.annotations, refHash);
                continue;
            }
            refHash = new RefObject<HashMap<String, ArrayList<Object>>>(this.corpus.hUnambiguities);
            this.engine.computeUnambiguities(this.corpus, itemName, myText, this.corpus.annotations, refHash);
        }
    }

    /*
     * Exception decompiling
     */
    public void linguisticAnalysis() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void desactivateOps() {
        this.shell.getBtnAdd().setEnabled(false);
        this.shell.getBtnRemove().setEnabled(false);
    }

    public void reactivateOps() {
        this.shell.getBtnAdd().setEnabled(true);
        this.shell.getBtnRemove().setEnabled(true);
    }

    public void saveCorpus() {
        if (this.fullPath == null) {
            this.saveAsCorpus();
        } else {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.save(this.fullPath);
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    public void saveAsCorpus() {
        String languageName = this.corpus.lan.isoName;
        String corpusDirName = "";
        if (!this.fullPath.equals("")) {
            corpusDirName = String.valueOf(this.fullPath) + "_dir";
        }
        String currentDirToBeSetPath = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + languageName + System.getProperty("file.separator") + "Projects";
        File currentDirToBeSet = new File(currentDirToBeSetPath);
        JFileChooser saveCorpusChooser = Launcher.getSaveCorpusChooser();
        saveCorpusChooser.setCurrentDirectory(currentDirToBeSet);
        if (saveCorpusChooser.showSaveDialog(null) != 0) {
            return;
        }
        File selectedFile = saveCorpusChooser.getSelectedFile();
        this.fullPath = selectedFile.getAbsolutePath();
        this.fullName = selectedFile.getName();
        String parentPath = saveCorpusChooser.getCurrentDirectory().getAbsolutePath();
        String inputFileName = String.valueOf(FilenameUtils.removeExtension(this.fullName)) + "." + "jnoc";
        String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
        File newFile = new File(pathOfInputFile);
        if (newFile.exists()) {
            int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(this.fullName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
            if (value == 1 || value == -1) {
                return;
            }
            newFile.delete();
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            if (!corpusDirName.equals("")) {
                this.save(corpusDirName, pathOfInputFile);
            } else {
                this.save(pathOfInputFile);
            }
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void saveCorpusForNooJ() {
        String languageName = this.corpus.lan.isoName;
        String dirName = String.valueOf(Paths.applicationDir) + "resources" + System.getProperty("file.separator") + "initial" + System.getProperty("file.separator") + languageName + System.getProperty("file.separator") + "Projects(java)";
        String fileName = this.fullName;
        String nooJName = String.valueOf(dirName) + System.getProperty("file.separator") + fileName;
        try {
            CursorChangeEffect.setCustomCursor(3);
            File parent = new File(dirName);
            if (!parent.exists()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Save file path does not exists!", "Error while saving corpus to corpus directory!", 0);
                return;
            }
            File file = new File(nooJName);
            if (file.exists()) {
                file.delete();
            }
            this.save(nooJName);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Corpus File " + nooJName + " has been updated!", "NooJ Update", 1);
    }

    private void save(String corpusDirPath, String fullPath) {
        try {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.corpus.saveIn(corpusDirPath);
                File corpusDir = new File(fullPath);
                if (corpusDir.exists()) {
                    Utils.deleteDir(corpusDir);
                }
                Zip.compressDir(corpusDirPath, fullPath);
                this.modified = false;
                this.updateTitle();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while saving corpus to corpus directory!", 0);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    private void save(String fullPath) {
        String corpusDirPath = String.valueOf(fullPath) + "_dir";
        File fileCorpus = new File(fullPath);
        if (fileCorpus.exists()) {
            fileCorpus.delete();
        }
        this.save(corpusDirPath, fullPath);
    }

    public void fillInUnknowns(DictionaryEditorShell unknownsEditor) {
        String lang = this.corpus.lan.isoName;
        unknownsEditor.getController().initLoad(lang);
        StringBuilder builder = new StringBuilder();
        for (Object tokenObj : this.corpus.annotations) {
            String token = (String)tokenObj;
            if (token == null) continue;
            Object entry = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            Object lemma = null;
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            Object category = null;
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            Object features = null;
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            if (!Dic.parseDELAFFeatureArray(token, entryRef, lemmaRef, categoryRef, featuresRef)) {
                builder.append(String.valueOf(token) + " # invalid lexeme\n");
                Dic.writeLog("Lexeme <" + token + "> is invalid");
                continue;
            }
            if (!((String)categoryRef.argvalue).equals("UNKNOWN")) continue;
            builder.append(String.valueOf(token) + "\n");
        }
        if (builder.length() > 10000000) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Unknown Dictionary is too large (>10MB) to be displayed", "NooJ: dictionary (> 10 MB) is too large", 1);
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Do you want to save it in a file?", "NooJ", 0);
            if (answer == 0) {
                String fn = "unknown.dic";
                String pn = String.valueOf(Paths.applicationDir) + fn;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(pn);
                    fileOutputStream.write(unknownsEditor.getTextPane().getText().getBytes());
                    fileOutputStream.write(builder.toString().getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    return;
                }
                catch (IOException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Unknown Dictionary saved in file " + pn, "NooJ", 1);
            }
            return;
        }
        String existingText = unknownsEditor.getTextPane().getText();
        StringBuilder newText = new StringBuilder(existingText);
        newText.append(builder.toString());
        unknownsEditor.getTextPane().setText(newText.toString());
        unknownsEditor.getController().sortDictionary(true);
    }

    public void fillInVocabulary(DictionaryEditorShell annotationsEditor) {
        String info;
        String lemma;
        String entry;
        if (!this.corpus.getRidOfUnusedAnnotationsForCorpus(this.fullPath)) {
            return;
        }
        annotationsEditor.getController().initLoad(this.corpus.lan.isoName);
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> frozenExpressions = new HashMap<String, String>();
        for (Object lexemeObj : this.corpus.annotations) {
            RefObject<Object> infoRef;
            RefObject<Object> lemmaRef;
            RefObject<Object> entryRef;
            String lexeme = (String)lexemeObj;
            if (lexeme == null || !Dic.parseDELAF(lexeme, entryRef = new RefObject<Object>((entry = null)), lemmaRef = new RefObject<Object>((lemma = null)), infoRef = new RefObject<Object>((info = null)))) continue;
            info = (String)infoRef.argvalue;
            lemma = (String)lemmaRef.argvalue;
            entry = (String)entryRef.argvalue;
            if (info != null && (Dic.lookFor("NW", info) != null || Dic.lookFor("FXC", info) != null)) continue;
            int index = info.indexOf("XREF=");
            if (index != -1) {
                int i0 = index + "XREF=".length();
                int i = 0;
                while (i0 + i < info.length() && Character.isDigit(info.charAt(i0 + i))) {
                    ++i;
                }
                String xrefString = null;
                xrefString = i0 + i < info.length() ? info.substring(i0, i) : info.substring(i0);
                if (frozenExpressions.containsKey(xrefString)) {
                    String oldInfo;
                    RefObject<Object> oldInfoRef;
                    String oldLemma;
                    RefObject<Object> oldLemmaRef;
                    String oldEntry;
                    RefObject<Object> oldEntryRef;
                    String old = (String)frozenExpressions.get(xrefString);
                    if (!Dic.parseDELAF(old, oldEntryRef = new RefObject<Object>((oldEntry = null)), oldLemmaRef = new RefObject<Object>((oldLemma = null)), oldInfoRef = new RefObject<Object>((oldInfo = null)))) continue;
                    oldEntry = (String)oldEntryRef.argvalue;
                    oldLemma = (String)oldLemmaRef.argvalue;
                    oldInfo = (String)oldInfoRef.argvalue;
                    frozenExpressions.put(xrefString, String.valueOf(oldEntry) + "_" + entry + "," + oldInfo);
                    continue;
                }
                frozenExpressions.put(xrefString, String.valueOf(entry) + "," + Dic.removeFeature("XREF", info));
                continue;
            }
            if (lemma.equals("SYNTAX")) {
                sb.append(String.valueOf(entry) + "," + info + "\n");
                continue;
            }
            String category = null;
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            String[] features = null;
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            if (!Dic.parseDELAFFeatureArray(lexeme, entryRef, lemmaRef, categoryRef, featuresRef)) continue;
            features = (String[])featuresRef.argvalue;
            String newFeatures = Dic.getRidOfSpecialFeatures(features);
            category = (String)categoryRef.argvalue;
            if (entry.equals(lemma)) {
                sb.append(String.valueOf(entry) + "," + category + newFeatures + "\r");
                continue;
            }
            sb.append(String.valueOf(entry) + "," + lemma + "," + category + newFeatures + "\r");
        }
        if (frozenExpressions.size() > 0) {
            for (Object lexeme : frozenExpressions.values()) {
                String lexemeString = lexeme.toString();
                entry = null;
                lemma = null;
                info = null;
                String category = null;
                RefObject<Object> entryRef = new RefObject<Object>(entry);
                RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
                RefObject<Object> infoRef = new RefObject<Object>(info);
                RefObject<Object> categoryRef = new RefObject<Object>(category);
                if (!Dic.parseDELAF(lexemeString, entryRef, lemmaRef, infoRef)) continue;
                lemma = (String)lemmaRef.argvalue;
                entry = (String)entryRef.argvalue;
                info = (String)infoRef.argvalue;
                if (lemma.equals("SYNTAX")) {
                    sb.append(String.valueOf(entry) + "," + info + "\r");
                    continue;
                }
                String[] features = null;
                RefObject<Object> featuresRef = new RefObject<Object>(features);
                if (!Dic.parseDELAFFeatureArray(lexemeString, entryRef, lemmaRef, categoryRef, featuresRef)) continue;
                features = (String[])featuresRef.argvalue;
                String newFeatures = Dic.getRidOfSpecialFeatures(features);
                if (entry.equals(lemma)) {
                    sb.append(String.valueOf(entry) + "," + category + newFeatures + "\r");
                    continue;
                }
                sb.append(String.valueOf(entry) + "," + lemma + "," + category + newFeatures + "\r");
            }
        }
        if (sb.length() > 10000000) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary is too large (>10MB) to be displayed", "NooJ: dictionary (> 10 MB) is too large", 1);
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Do you want to save it in a file?", "NooJ", 0);
            if (answer == 0) {
                String fn = "dictionary.dic";
                String pn = String.valueOf(Paths.applicationDir) + fn;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(pn);
                    fileOutputStream.write(annotationsEditor.getTextPane().getText().getBytes());
                    fileOutputStream.write(sb.toString().getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    return;
                }
                catch (IOException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary saved in file " + pn, "NooJ", 1);
            }
            return;
        }
        String existingText = annotationsEditor.getTextPane().getText();
        StringBuilder newText = new StringBuilder(existingText);
        newText.append(sb.toString());
        annotationsEditor.getTextPane().setText(newText.toString());
        if (!annotationsEditor.getController().check()) {
            annotationsEditor.getController().getErrorShell().setVisible(true);
        }
        annotationsEditor.getController().sortDictionary(true);
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public CorpusEditorShell getShell() {
        return this.shell;
    }

    public void setShell(CorpusEditorShell shell) {
        this.shell = shell;
    }

    public JTextPane getTextPaneStats() {
        return this.textPaneStats;
    }

    public void setTextPaneStats(JTextPane textPaneStats) {
        this.textPaneStats = textPaneStats;
    }

    public JTable getTableTexts() {
        return this.tableTexts;
    }

    public void setTableTexts(JTable tableTexts) {
        this.tableTexts = tableTexts;
    }

    public JList getListResults() {
        return this.listResults;
    }

    public void setListResults(JList listResults) {
        this.listResults = listResults;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
    }

    public boolean isBeingClosed() {
        return this.beingClosed;
    }

    public void setBeingClosed(boolean beingClosed) {
        this.beingClosed = beingClosed;
    }

    public List<Integer> getAbsoluteBeginAddresses() {
        return this.absoluteBeginAddresses;
    }

    public void setAbsoluteBeginAddresses(List<Integer> absoluteBeginAddresses) {
        this.absoluteBeginAddresses = absoluteBeginAddresses;
    }

    public List<Color> getListOfColors() {
        return this.listOfColors;
    }

    public void setListOfColors(List<Color> listOfColors) {
        this.listOfColors = listOfColors;
    }

    public List<Integer> getAbsoluteEndAddresses() {
        return this.absoluteEndAddresses;
    }

    public void setAbsoluteEndAddresses(List<Integer> absoluteEndAddresses) {
        this.absoluteEndAddresses = absoluteEndAddresses;
    }

    public LocateDialog getLocateDialog() {
        return this.locateDialog;
    }

    public void setLocateDialog(LocateDialog locateDialog) {
        this.locateDialog = locateDialog;
    }

    public ConcordanceShellController getConcordanceController() {
        return this.concordanceController;
    }

    public void setConcordanceController(ConcordanceShellController concordanceController) {
        this.concordanceController = concordanceController;
    }

    public List<String> getListOfConcordanceFiles() {
        return this.listOfConcordanceFiles;
    }

    public void setListOfConcordanceFiles(List<String> listOfConcordanceFiles) {
        this.listOfConcordanceFiles = listOfConcordanceFiles;
    }

    public List<String> getLocateGrammarMemoryList() {
        return this.locateGrammarMemoryList;
    }

    public void setLocateGrammarMemoryList(List<String> locateGrammarMemoryList) {
        this.locateGrammarMemoryList = locateGrammarMemoryList;
    }

    public List<String> getLocateRegexMemoryList() {
        return this.locateRegexMemoryList;
    }

    public void setLocateRegexMemoryList(List<String> locateRegexMemoryList) {
        this.locateRegexMemoryList = locateRegexMemoryList;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public void setTextController(TextEditorShellController textController) {
        this.textController = textController;
    }

    public TextEditorShell getTextShell() {
        return this.textShell;
    }

    public void setTextShell(TextEditorShell textShell) {
        this.textShell = textShell;
    }
}

