/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ExportColoredToHtmlActionListener
implements ActionListener {
    private CorpusEditorShellController corpusController;
    private TextEditorShellController textController;
    private boolean corpus;
    private List<Color> listOfColors;
    private List<Integer> absoluteBeginAddresses;
    private List<Integer> absoluteEndAddresses;
    private List<String> listOfConcordanceFiles;

    public ExportColoredToHtmlActionListener(CorpusEditorShellController corpusController, TextEditorShellController textController) {
        this.corpusController = corpusController;
        this.textController = textController;
        if (corpusController != null && corpusController.getShell() != null) {
            this.corpus = true;
            this.listOfConcordanceFiles = corpusController.getListOfConcordanceFiles();
            this.listOfColors = corpusController.getListOfColors();
            this.absoluteBeginAddresses = corpusController.getAbsoluteBeginAddresses();
            this.absoluteEndAddresses = corpusController.getAbsoluteEndAddresses();
        } else if (textController != null) {
            this.corpus = false;
            this.listOfColors = textController.getListOfColors();
            this.absoluteBeginAddresses = textController.getAbsoluteBeginAddresses();
            this.absoluteEndAddresses = textController.getAbsoluteEndAddresses();
            this.listOfConcordanceFiles = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.corpus) {
            String dName;
            File dir;
            String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            if (Launcher.projectMode) {
                dir = new File(Paths.projectDir);
                dName = dir.getParent();
            } else {
                dir = new File(this.corpusController.getFullPath());
                dName = dir.getParent();
            }
            String lastFullName = "";
            Ntext myLastText = null;
            for (String fName : this.corpusController.getCorpus().listOfFileTexts) {
                String fullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fName;
                Ntext myText = null;
                if (fullName.equals(lastFullName)) {
                    myText = myLastText;
                } else {
                    try {
                        myText = Ntext.loadForCorpus(fullName, this.corpusController.getCorpus().lan, this.corpusController.getCorpus().multiplier);
                        lastFullName = fullName;
                        if (this.corpusController.getTextController() == null) {
                            TextEditorShell textShell = new TextEditorShell(this.corpusController, myText, fullName, myText.DelimPattern, false);
                            Launcher.getDesktopPane().add(textShell);
                            this.corpusController.setTextController(textShell.getTextController());
                            textShell.setVisible(true);
                        } else {
                            this.corpusController.getTextController().setMyText(myText);
                            this.corpusController.getTextController().setFileToBeOpenedOrImported(new File(fullName));
                            this.corpusController.getTextController().resetShellText();
                        }
                        if (myText == null) continue;
                        String coloredFName = String.valueOf(dName) + System.getProperty("file.separator") + FilenameUtils.removeExtension(fName) + ".html";
                        String textBuffer = myText.buffer;
                        if (this.listOfConcordanceFiles != null) {
                            if (this.listOfConcordanceFiles.contains(fName)) {
                                this.saveColoredTextFromCorpus(fName, coloredFName, textBuffer);
                            } else {
                                this.saveNonColoredText(coloredFName, textBuffer);
                            }
                        } else {
                            this.saveNonColoredText(coloredFName, textBuffer);
                        }
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while exporting all colored corpus files into folder " + corpusDirName, "NooJ", 1);
                        return;
                    }
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: all colored corpus files have been exported into folder " + corpusDirName, "NooJ", 1);
                return;
            }
        } else {
            File file = this.textController.getFileToBeOpenedOrImported();
            String fName = file.getName();
            String coloredFName = String.valueOf(FilenameUtils.removeExtension(file.getAbsolutePath())) + ".html";
            Ntext myText = this.textController.getMyText();
            this.saveColoredText(fName, coloredFName, myText.buffer);
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Colored Text saved as " + coloredFName, "NooJ", 1);
            return;
        }
    }

    private void saveColoredTextFromCorpus(String fName, String coloredFName, String textBuffer) {
        ArrayList<ColorData> colorDataList = new ArrayList<ColorData>();
        int i = 0;
        while (i < this.listOfConcordanceFiles.size()) {
            if (this.listOfConcordanceFiles.get(i).equals(fName)) {
                ColorData cd = new ColorData(this.listOfColors.get(i), this.absoluteBeginAddresses.get(i), this.absoluteEndAddresses.get(i));
                colorDataList.add(cd);
            }
            ++i;
        }
        Collections.sort(colorDataList);
        this.createColoredFile(colorDataList, coloredFName, textBuffer);
    }

    private void saveColoredText(String fName, String coloredFName, String textBuffer) {
        ArrayList<ColorData> colorDataList = new ArrayList<ColorData>();
        int i = 0;
        while (i < this.absoluteBeginAddresses.size()) {
            ColorData cd = new ColorData(this.listOfColors.get(i), this.absoluteBeginAddresses.get(i), this.absoluteEndAddresses.get(i));
            colorDataList.add(cd);
            ++i;
        }
        Collections.sort(colorDataList);
        this.createColoredFile(colorDataList, coloredFName, textBuffer);
    }

    private void createColoredFile(List<ColorData> colorDataList, String coloredFName, String textBuffer) {
        File file = new File(coloredFName);
        try {
            file.createNewFile();
            PrintWriter pw = new PrintWriter(coloredFName);
            pw.write("<pre>");
            int currentChar = 0;
            int j = 0;
            while (j < colorDataList.size()) {
                ColorData cd = colorDataList.get(j);
                pw.append(textBuffer.substring(currentChar, cd.getBeginAddress()));
                pw.append("<font style=\"color:#");
                String rgb = Integer.toHexString(cd.getColor().getRGB());
                rgb = rgb.substring(2, rgb.length());
                pw.append(rgb);
                pw.append("\">");
                pw.append(textBuffer.substring(cd.getBeginAddress(), cd.getEndAddress()));
                pw.append("</font>");
                currentChar = cd.getEndAddress();
                ++j;
            }
            pw.append(textBuffer.substring(currentChar));
            pw.append("</pre>");
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while exporting colored text " + coloredFName, "NooJ", 1);
            return;
        }
    }

    private void saveNonColoredText(String coloredFName, String textBuffer) {
        File file = new File(coloredFName);
        try {
            file.createNewFile();
            PrintWriter pw = new PrintWriter(coloredFName);
            pw.write("<pre>");
            pw.append(textBuffer);
            pw.append("</pre>");
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while exporting non-colored text " + coloredFName, "NooJ", 1);
            return;
        }
    }

    private class ColorData
    implements Comparable<Object> {
        private Color color;
        private Integer beginAddress;
        private Integer endAddress;

        public ColorData(Color c, Integer ba, Integer ea) {
            this.color = c;
            this.beginAddress = ba;
            this.endAddress = ea;
        }

        @Override
        public int compareTo(Object o) {
            ColorData other = (ColorData)o;
            if (this.beginAddress < other.beginAddress) {
                return -1;
            }
            if (this.beginAddress > other.beginAddress) {
                return 1;
            }
            return 0;
        }

        public Color getColor() {
            return this.color;
        }

        public Integer getBeginAddress() {
            return this.beginAddress;
        }

        public Integer getEndAddress() {
            return this.endAddress;
        }
    }
}

