/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell.ExportXmlDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.dialogs.ExportXmlDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ExportAnnotatedToXmlButtonActionListener
implements ActionListener {
    private ExportXmlDialog exportXmlDialog;

    public ExportAnnotatedToXmlButtonActionListener(ExportXmlDialog exportXmlDialog) {
        this.exportXmlDialog = exportXmlDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] xmlAnnotations;
        if (this.exportXmlDialog.getRdbtnAllSyntax().isSelected()) {
            xmlAnnotations = new String[]{"<SYNTAX>"};
        } else {
            int nbOfAnnotations = 0;
            ArrayList<String> tmp = new ArrayList<String>();
            String cbSelectedText = this.exportXmlDialog.getCobxXmlAnnotations().getSelectedItem().toString();
            int i = 0;
            while (i < cbSelectedText.length()) {
                if (cbSelectedText.substring(i, i + 1).equals(Character.valueOf('<'))) {
                    int j = 0;
                    while (i + j < cbSelectedText.length() && !cbSelectedText.substring(i + j, i + j + 1).equals(Character.valueOf('>'))) {
                        ++j;
                    }
                    tmp.add(cbSelectedText.substring(i, i + j + 1));
                    if (++nbOfAnnotations >= 3) break;
                    i += j;
                }
                ++i;
            }
            if (tmp.size() == 0) {
                xmlAnnotations = null;
            } else {
                xmlAnnotations = new String[tmp.size()];
                i = 0;
                while (i < tmp.size()) {
                    xmlAnnotations[i] = (String)tmp.get(i);
                    ++i;
                }
            }
            if (xmlAnnotations == null || xmlAnnotations.length == 0) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please enter annotations as XML tags, e.g. <DATE> or <NP>", "NooJ: no tag to export", 1);
                return;
            }
            i = 0;
            while (i < xmlAnnotations.length) {
                if (xmlAnnotations[i].equals("<TRANS>")) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Special annotation <TRANS> requires a text field, e.g. <TRANS+FR> or <TRANS+PREDICATE>", "NooJ: no text field to use for translation", 1);
                    return;
                }
                ++i;
            }
        }
        if (this.exportXmlDialog.isCorpus()) {
            String dName;
            File dir;
            CorpusEditorShellController controller = this.exportXmlDialog.getCorpusController();
            Language lan = controller.getCorpus().lan;
            String corpusDirName = String.valueOf(controller.getFullPath()) + "_dir";
            if (Launcher.projectMode) {
                dir = new File(Paths.projectDir);
                dName = dir.getParent();
            } else {
                dir = new File(controller.getFullPath());
                dName = dir.getParent();
            }
            for (String fName : controller.getCorpus().listOfFileTexts) {
                String fullName = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fName;
                try {
                    Ntext myText = Ntext.loadForCorpus(fullName, lan, controller.getCorpus().multiplier);
                    if (myText == null) continue;
                    String xmlFileName = String.valueOf(dName) + System.getProperty("file.separator") + FilenameUtils.removeExtension(fName) + ".xml.txt";
                    this.exportXmlAnnotations(xmlFileName, myText, controller.getCorpus().annotations, xmlAnnotations, false, this.exportXmlDialog.getChbxOnly().isSelected(), lan);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: all annotated corpus files have been exported into folder " + dName, "NooJ", 1);
            this.exportXmlDialog.dispose();
        } else {
            TextEditorShellController textController = this.exportXmlDialog.getTextController();
            String xmlFileName = null;
            if (Launcher.projectMode) {
                File dir = new File(Paths.projectDir);
                String dName = dir.getParent();
                xmlFileName = String.valueOf(dName) + System.getProperty("file.separator") + FilenameUtils.removeExtension(textController.getTextName()) + ".xml.txt";
            } else {
                xmlFileName = String.valueOf(FilenameUtils.removeExtension(textController.getTextName())) + ".xml.txt";
            }
            Ntext text = textController.getMyText();
            Language lan = text.getLanguage();
            this.exportXmlAnnotations(xmlFileName, text, text.annotations, xmlAnnotations, true, this.exportXmlDialog.getChbxOnly().isSelected(), lan);
        }
    }

    private void exportXmlAnnotations(String xmlFileName, Ntext text, ArrayList<Object> annotations, String[] xmlAnnotations, boolean interactive, boolean filterOut, Language lan) {
        PrintWriter pw = null;
        try {
            File xmlFile = new File(xmlFileName);
            xmlFile.createNewFile();
            pw = new PrintWriter(xmlFileName);
            int currentAddress = 0;
            int itu = 1;
            while (itu <= text.nbOfTextUnits) {
                if (currentAddress < text.mft.tuAddresses[itu] && !filterOut) {
                    pw.write(text.buffer.substring(currentAddress, text.mft.tuAddresses[itu]));
                }
                String currentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuLengths[itu] + text.mft.tuAddresses[itu]);
                currentAddress = text.mft.tuLengths[itu] + text.mft.tuAddresses[itu];
                text.buildXmlTaggedText(currentLine, 0, filterOut, pw, itu, annotations, xmlAnnotations, lan, false);
                ++itu;
            }
            if (!filterOut) {
                pw.write(text.buffer.substring(currentAddress));
            }
            pw.close();
            if (interactive) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: text has been exported into file " + xmlFileName, "NooJ", 1);
                return;
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: cannot create file " + xmlFileName, 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while exporting corpus to XML!", 0);
            return;
        }
    }
}

