/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.main.Launcher;

public class LinguisticAnalysisActionListener
implements ActionListener,
PropertyChangeListener {
    private CorpusEditorShellController controller;

    public LinguisticAnalysisActionListener(CorpusEditorShellController controller) {
        this.controller = controller;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        ConcordanceShellController concordanceController = this.controller.getConcordanceController();
        if (concordanceController != null && concordanceController.getConcordanceShell().isVisible()) {
            concordanceController.getConcordanceShell().hide();
        }
        this.controller.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Linguistic Analysis...";
        Launcher.getStatusBar().getProgressLabel().setText("Linguistic Analysis...");
        if (Launcher.multithread) {
            Launcher.backgroundWorking = true;
            Launcher.backgroundWorker = new BackgroundWorker("corpus linguistic analysis", null, this.controller, null);
            Launcher.backgroundWorker.addPropertyChangeListener(this);
            Launcher.backgroundWorker.execute();
        } else {
            this.controller.linguisticAnalysis();
            this.controller.reactivateOps();
            this.controller.updateTextPaneStats();
            this.controller.updateResults();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
        }
    }
}

