/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DebugShell;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MatchType;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.components.DebugJTableRenderer;
import net.nooj4nlp.gui.components.DebugJTreeRenderer;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DebugShell;

public class DebugShellController {
    private DebugShell debugShell;
    private GrammarEditorShellController grammarController;
    private Language lan;

    public DebugShellController(DebugShell debugShell, GrammarEditorShellController grammarController) {
        this.debugShell = debugShell;
        this.grammarController = grammarController;
        this.lan = null;
    }

    public void comboPressedKeyEvent(KeyEvent e) {
        this.clearAllItems(this.debugShell, true, true);
        if (e.getKeyCode() == 10) {
            this.debug();
        } else {
            this.stopBlinking();
        }
    }

    public void buttonPressedFunction() {
        this.clearAllItems(this.debugShell, true, true);
        this.debug();
    }

    private void debug() {
        this.clearAllItems(this.debugShell, true, false);
        String comboText = this.debugShell.getComboExpression().getSelectedItem().toString();
        ArrayList<Object> aDebug = this.debugLine(comboText);
        if (aDebug != null && aDebug.size() > 1) {
            int i = 1;
            while (i < aDebug.size()) {
                String debugString;
                int lastPosition = 0;
                ArrayList aNodes = (ArrayList)aDebug.get(i);
                ArrayList aInputs = (ArrayList)aDebug.get(i + 1);
                String output = aDebug.get(i + 2) == null ? null : aDebug.get(i + 2).toString();
                StringBuilder sbI = new StringBuilder();
                StringBuilder sbO = new StringBuilder();
                int j = 0;
                while (j < aNodes.size()) {
                    if (aNodes.get(j) instanceof String) {
                        sbI.append(" (\"" + aNodes.get(j).toString() + "\" ");
                    } else {
                        int nodeNb = (Integer)aNodes.get(j);
                        if (nodeNb == 1) {
                            sbI.append(" )");
                            while (j + 1 < aNodes.size() && (Integer)aNodes.get(j + 1) == -1) {
                                ++j;
                            }
                        } else if (j < aInputs.size()) {
                            if (aInputs.get(j) instanceof String) {
                                String morpheme = aInputs.get(j).toString();
                                if (morpheme != null && morpheme.length() > 2 && morpheme.charAt(0) == '$' && morpheme.charAt(1) == '(') {
                                    sbI.append(String.valueOf(morpheme) + " ");
                                } else if (morpheme == "$)") {
                                    sbI.append(" " + morpheme + " ");
                                } else {
                                    sbI.append(morpheme);
                                }
                            } else {
                                int position = ((Double)aInputs.get(j)).intValue();
                                if (position > lastPosition) {
                                    while (position > comboText.length()) {
                                        --position;
                                    }
                                    String tok = comboText.substring(lastPosition, position);
                                    sbI.append(tok);
                                    lastPosition = position;
                                }
                            }
                        }
                    }
                    ++j;
                }
                if (output != null && !output.equals("")) {
                    sbO.append(output);
                }
                Color colorOfARow = (debugString = aDebug.get(0).toString()).equals("perfect") ? new Color(0, 128, 0) : (debugString.equals("partial") ? Color.BLUE : Color.RED);
                Object[] rowObject = new Object[]{sbI.toString(), sbO.toString(), aNodes.clone()};
                JTable debugTable = this.debugShell.getTableTraces();
                DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
                DebugJTableRenderer renderer = this.debugShell.getCustomTableRenderer();
                renderer.getColoredRowsMap().put(tableModel.getRowCount(), colorOfARow);
                tableModel.addRow(rowObject);
                i += 3;
            }
        }
    }

    private ArrayList<Object> debugLine(String currentLine) {
        boolean applyRes;
        Grammar grammar = this.grammarController.grammar;
        if (grammar == null) {
            return null;
        }
        if (this.lan == null) {
            this.lan = this.grammarController.lan;
        }
        RefObject<Language> lanRef = new RefObject<Language>(this.lan);
        Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        this.lan = (Language)lanRef.argvalue;
        String errorMessage = "";
        RefObject<String> errorMessageRef = new RefObject<String>(errorMessage);
        try {
            if (!engine.loadResources(Launcher.preferences.ldic.get(this.lan.isoName), Launcher.preferences.lsyn.get(this.lan.isoName), true, errorMessageRef)) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessageRef.argvalue, "Warning: Cannot load linguistic resources!", 2);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return null;
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        errorMessage = grammar.compileAll(engine);
        if (errorMessage != null) {
            Dic.writeLog(errorMessage);
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error!", 0);
            return null;
        }
        String line = currentLine;
        if (grammar.gramType == GramType.MORPHO) {
            Gram grm = grammar.grams.get("Main");
            if (grm == null || grm.states == null || grm.states.size() < 2) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + grammar.fullName + " has no Main graph!", "NooJ: no main graph in grammar", 0);
                return null;
            }
            RefObject<ArrayList<Integer>> solLengthsRef = new RefObject<ArrayList<Integer>>(new ArrayList());
            RefObject<ArrayList<ArrayList<Object>>> solNodesRef = new RefObject<ArrayList<ArrayList<Object>>>(new ArrayList());
            RefObject<ArrayList<ArrayList<String>>> solInputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
            RefObject<ArrayList<ArrayList<String>>> solOutputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
            int da = grammar.morphoMatch("Main", line, grm, solLengthsRef, solInputsRef, solOutputsRef, solNodesRef);
            ArrayList solLengths = (ArrayList)solLengthsRef.argvalue;
            ArrayList solNodes = (ArrayList)solNodesRef.argvalue;
            ArrayList solInputs = (ArrayList)solInputsRef.argvalue;
            ArrayList solOutputs = (ArrayList)solOutputsRef.argvalue;
            if (da > 0) {
                boolean perfectMatch = false;
                int longestMatch = -1;
                ArrayList<Object> res = new ArrayList<Object>();
                int iSol = 0;
                while (iSol < solLengths.size()) {
                    int l = (Integer)solLengths.get(iSol);
                    if (l == line.length()) {
                        perfectMatch = true;
                    } else if (l > longestMatch) {
                        longestMatch = l;
                    }
                    ++iSol;
                }
                iSol = 0;
                while (iSol < solNodes.size()) {
                    ArrayList aSolTrace;
                    ArrayList aSolNode;
                    if (perfectMatch) {
                        int stL = (Integer)solLengths.get(iSol);
                        if (stL >= line.length()) {
                            ArrayList stO;
                            aSolNode = (ArrayList)solNodes.get(iSol);
                            aSolTrace = (ArrayList)solInputs.get(iSol);
                            StringBuilder oTrace = grammar.processVariablesInOutputs(aSolTrace, stO = (ArrayList)solOutputs.get(iSol));
                            if (Grammar.isComplex(oTrace)) {
                                String errorMessage2 = "";
                                RefObject<String> errorMessageRef2 = new RefObject<String>(errorMessage2);
                                ArrayList<ArrayList<String>> cSols = grammar.processConstraints(oTrace.toString(), errorMessageRef2);
                                errorMessage2 = (String)errorMessageRef2.argvalue;
                                if (cSols == null || cSols.size() == 0) {
                                    res.add(aSolNode);
                                    res.add(aSolTrace);
                                    res.add(errorMessage2);
                                } else {
                                    ArrayList<ArrayList<String>> listOfSols = grammar.defactorize(cSols);
                                    int icSol = 0;
                                    while (icSol < listOfSols.size()) {
                                        ArrayList<String> los = listOfSols.get(icSol);
                                        engine.processELCSFVariables(los, line);
                                        StringBuilder resTrace = Grammar.computeInput(los);
                                        res.add(aSolNode);
                                        res.add(aSolTrace);
                                        res.add(resTrace.toString());
                                        ++icSol;
                                    }
                                }
                            } else {
                                res.add(aSolNode);
                                res.add(aSolTrace);
                                res.add(oTrace.toString());
                            }
                        }
                    } else {
                        int stl = (Integer)solLengths.get(iSol);
                        if (stl >= longestMatch) {
                            aSolNode = (ArrayList)solNodes.get(iSol);
                            aSolTrace = (ArrayList)solInputs.get(iSol);
                            res.add(aSolNode);
                            res.add(aSolTrace);
                            res.add(null);
                        }
                    }
                    ++iSol;
                }
                if (perfectMatch) {
                    res.add(0, "perfect");
                } else {
                    res.add(0, "partial");
                }
                return res;
            }
            da = grammar.morphoMatch("Main", line, grm, solLengthsRef, solInputsRef, solOutputsRef, solNodesRef);
            solLengths = (ArrayList)solLengthsRef.argvalue;
            solNodes = (ArrayList)solNodesRef.argvalue;
            solInputs = (ArrayList)solInputsRef.argvalue;
            solOutputs = (ArrayList)solOutputsRef.argvalue;
            int longestMatch = -1;
            ArrayList<Object> res = new ArrayList<Object>();
            int iSol = 0;
            while (iSol < solNodes.size()) {
                ArrayList n = (ArrayList)solNodes.get(iSol);
                int l = n.size();
                if (l > longestMatch) {
                    longestMatch = l;
                }
                ++iSol;
            }
            iSol = 0;
            while (iSol < solNodes.size()) {
                ArrayList aSolNode = (ArrayList)solNodes.get(iSol);
                if (aSolNode.size() >= longestMatch) {
                    ArrayList aSolTrace = (ArrayList)solInputs.get(iSol);
                    res.add(aSolNode);
                    res.add(aSolTrace);
                    res.add(null);
                }
                ++iSol;
            }
            res.add(0, "failure");
            return res;
        }
        Ntext myText = new Ntext(this.lan.isoName);
        myText.buffer = line;
        myText.mft = engine.delimit(myText);
        HashMap<String, ArrayList<String>> simpleWordCache = new HashMap<String, ArrayList<String>>();
        myText.annotations = new ArrayList();
        RefObject<String> errorMessageRef2 = new RefObject<String>(errorMessage);
        if (!engine.tokenize(null, myText, myText.annotations, simpleWordCache, errorMessageRef2)) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessageRef2.argvalue, "NooJ Tokenizer Error", 0);
            myText.annotations = null;
            myText.hLexemes = null;
            myText.hUnknowns = null;
            return null;
        }
        simpleWordCache = null;
        myText.hPhrases = new HashMap();
        RefObject<String> errorMessageRef3 = new RefObject<String>("");
        if (engine.synGrms != null && engine.synGrms.size() > 0) {
            block70: {
                block69: {
                    applyRes = engine.applyAllGrammars(null, myText, myText.annotations, 0, errorMessageRef3);
                    errorMessage = (String)errorMessageRef3.argvalue;
                    if (applyRes || errorMessage == null) break block69;
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                    return null;
                }
                if (applyRes) break block70;
                myText.hPhrases = null;
                return null;
            }
            try {
                myText.cleanupBadAnnotations(myText.annotations);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return null;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
        }
        errorMessageRef3 = new RefObject<String>("");
        if (engine.synGrms != null && engine.synGrms.size() > 0) {
            block72: {
                block71: {
                    applyRes = engine.applyAllGrammars(null, myText, myText.annotations, 1, errorMessageRef3);
                    errorMessage = (String)errorMessageRef3.argvalue;
                    if (applyRes || errorMessage == null) break block71;
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                    return null;
                }
                if (applyRes) break block72;
                myText.hPhrases = null;
                return null;
            }
            try {
                myText.cleanupBadAnnotations(myText.annotations);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return null;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
        }
        RefObject<ArrayList<Double>> solLengthsRef = new RefObject<ArrayList<Double>>(new ArrayList());
        RefObject<ArrayList<ArrayList<Object>>> solNodesRef = new RefObject<ArrayList<ArrayList<Object>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<Double>>> solInputsRef = new RefObject<ArrayList<ArrayList<Double>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<String>>> solOutputsRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
        RefObject<ArrayList<ArrayList<String>>> solVariablesRef = new RefObject<ArrayList<ArrayList<String>>>(new ArrayList());
        Gram grm = grammar.grams.get("Main");
        if (grm == null || grm.states == null || grm.states.size() < 2) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + grammar.fullName + " has no Main graph!", "NooJ: no main graph in grammar", 0);
            return null;
        }
        ArrayList<String> recursive = new ArrayList<String>();
        int da = grammar.syntaxMatch("Main", 0, line, 0.0, 1, myText.mft, myText.annotations, grm, solLengthsRef, solInputsRef, solVariablesRef, solOutputsRef, solNodesRef, MatchType.LONGEST, true, false, recursive);
        ArrayList solLengths = (ArrayList)solLengthsRef.argvalue;
        ArrayList solNodes = (ArrayList)solNodesRef.argvalue;
        ArrayList solVariables = (ArrayList)solVariablesRef.argvalue;
        ArrayList solInputs = (ArrayList)solInputsRef.argvalue;
        ArrayList solOutputs = (ArrayList)solOutputsRef.argvalue;
        if (da > 0) {
            boolean partialMatch = false;
            ArrayList<Object> res = new ArrayList<Object>();
            int iSol = 0;
            while (iSol < solLengths.size()) {
                double l = (Double)solLengths.get(iSol);
                if (l < (double)line.length()) {
                    partialMatch = true;
                }
                ++iSol;
            }
            iSol = 0;
            while (iSol < solNodes.size()) {
                ArrayList aSolNode = (ArrayList)solNodes.get(iSol);
                ArrayList relAddresses = (ArrayList)solInputs.get(iSol);
                ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
                int rightMargin = ((Double)solLengths.get(iSol)).intValue();
                boolean check = true;
                ArrayList resOutputs = null;
                ArrayList resVariables = new ArrayList();
                resVariables.add(new HashMap());
                RefObject<Object> resOutputsRef = new RefObject<Object>(resOutputs);
                RefObject<ArrayList<HashMap<String, String>>> resVariablesRef = new RefObject<ArrayList<HashMap<String, String>>>(resVariables);
                RefObject<String> errMessageRef = new RefObject<String>("");
                if (Dic.isThereALexicalConstraint((ArrayList)solOutputs.get(iSol))) {
                    try {
                        check = engine.newProcessConstraints(line, myText.mft, myText.annotations, 1, grammar, (ArrayList)solInputs.get(iSol), rightMargin, (ArrayList)solVariables.get(iSol), 0.0, (ArrayList)solOutputs.get(iSol), resOutputsRef, resVariablesRef, 0, errMessageRef);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                        return null;
                    }
                }
                resOutputs = (ArrayList)resOutputsRef.argvalue;
                resVariables = (ArrayList)resVariablesRef.argvalue;
                errorMessage = (String)errMessageRef.argvalue;
                if (!check) {
                    res.add(aSolNode);
                    res.add(absAddresses);
                    ArrayList<Object> seqOfAnnotations = engine.mergeIntoAnnotations(line, 1, 0.0, (Double)solLengths.get(iSol), absAddresses, (ArrayList)solOutputs.get(iSol), false);
                    if (seqOfAnnotations != null && seqOfAnnotations.size() > 0) {
                        if (!check) {
                            res.add(String.valueOf(errorMessage) + ": " + seqOfAnnotations.get(1).toString());
                        } else {
                            res.add(seqOfAnnotations.get(1).toString());
                        }
                    } else {
                        res.add(null);
                    }
                } else if (resOutputs == null || resOutputs.size() == 0) {
                    res.add(aSolNode);
                    res.add(absAddresses);
                    res.add(null);
                } else {
                    for (ArrayList output2 : resOutputs) {
                        res.add(aSolNode);
                        res.add(absAddresses);
                        ArrayList<Object> seqOfAnnotations = engine.mergeIntoAnnotations(line, 1, 0.0, (Double)solLengths.get(iSol), absAddresses, output2, false);
                        if (seqOfAnnotations != null && seqOfAnnotations.size() > 0) {
                            res.add(seqOfAnnotations.get(1).toString());
                            continue;
                        }
                        res.add(null);
                    }
                }
                ++iSol;
            }
            if (partialMatch) {
                res.add(0, "partial");
            } else {
                res.add(0, "perfect");
            }
            return res;
        }
        recursive = new ArrayList();
        da = grammar.failureSyntaxMatch("Main", 0, line, 0.0, 1, myText.mft, myText.annotations, grm, solLengthsRef, solInputsRef, solVariablesRef, solOutputsRef, solNodesRef, MatchType.LONGEST, true, false, recursive);
        if (da == 0) {
            return null;
        }
        solLengths = (ArrayList)solLengthsRef.argvalue;
        solNodes = (ArrayList)solNodesRef.argvalue;
        solVariables = (ArrayList)solVariablesRef.argvalue;
        solInputs = (ArrayList)solInputsRef.argvalue;
        solOutputs = (ArrayList)solOutputsRef.argvalue;
        ArrayList<Object> res = new ArrayList<Object>();
        double longestLength = 0.0;
        int iSol = 0;
        while (iSol < solNodes.size()) {
            ArrayList relAddresses = (ArrayList)solInputs.get(iSol);
            ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
            double len = absAddresses.get(absAddresses.size() - 1);
            if (len > longestLength) {
                longestLength = len;
            }
            ++iSol;
        }
        iSol = 0;
        while (iSol < solNodes.size()) {
            ArrayList aSolNode = (ArrayList)solNodes.get(iSol);
            ArrayList relAddresses = (ArrayList)solInputs.get(iSol);
            ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, myText.mft.tuAddresses[1]);
            double len = absAddresses.get(absAddresses.size() - 1);
            if (len == longestLength) {
                res.add(aSolNode);
                res.add(absAddresses);
                res.add(null);
            }
            ++iSol;
        }
        res.add(0, "failure");
        return res;
    }

    private void stopBlinking() {
        this.grammarController.getTimerDbg().stop();
        ArrayList<Graph> graphs = this.grammarController.grammar.graphs;
        int ig = 0;
        while (ig < graphs.size()) {
            Graph grf = graphs.get(ig);
            grf.stopDebug();
            ++ig;
        }
    }

    private void clearAllItems(DebugShell debugShell, boolean clearTableItems, boolean clearTreeItems) {
        if (clearTableItems) {
            JTable debugTable = debugShell.getTableTraces();
            DebugJTableRenderer renderer = debugShell.getCustomTableRenderer();
            renderer.setColoredRowsMap(new HashMap<Integer, Color>());
            DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
        }
        if (clearTreeItems) {
            DefaultTreeModel debugTreeModel = (DefaultTreeModel)debugShell.getTreeDebug().getModel();
            ((DefaultMutableTreeNode)debugTreeModel.getRoot()).removeAllChildren();
            debugTreeModel.reload();
        }
    }

    public void tableSelectionChangedFunction() {
        JTable debugTable = this.debugShell.getTableTraces();
        DefaultTableModel tableModel = (DefaultTableModel)debugTable.getModel();
        if (debugTable.getSelectedRowCount() == 0) {
            this.stopBlinking();
            return;
        }
        int iSol = debugTable.getSelectedRows()[0];
        ArrayList nodeTrace = (ArrayList)tableModel.getValueAt(iSol, 2);
        String graphName = nodeTrace.get(0).toString();
        this.parseNodeTrace(graphName, nodeTrace, 1);
        String sTrace = debugTable.getValueAt(iSol, 0).toString();
        this.buildSyntacticTree(sTrace);
        this.grammarController.getTimerDbg().start();
    }

    private void buildSyntacticTree(String sTrace) {
        this.clearAllItems(this.debugShell, false, true);
        JTree treeDebug = this.debugShell.getTreeDebug();
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)treeDebug.getModel().getRoot();
        DefaultTreeModel treeModel = (DefaultTreeModel)treeDebug.getModel();
        DefaultMutableTreeNode tn = new DefaultMutableTreeNode("Main");
        DebugJTreeRenderer customRenderer = this.debugShell.getCustomTreeRenderer();
        customRenderer.setBackgroundColor(Color.YELLOW);
        int ic = " (\"Main\" ".length();
        this.visit(sTrace, ic, tn);
        top.add(tn);
        treeModel.reload(top);
        treeDebug.expandPath(treeDebug.getPathForRow(0));
    }

    private int visit(String sTrace, int ic, DefaultMutableTreeNode tn) {
        while (ic < sTrace.length()) {
            DefaultMutableTreeNode tc;
            char character = sTrace.charAt(ic);
            if (character == ' ') {
                ++ic;
                continue;
            }
            if (character == ')') {
                return ic + 1;
            }
            if (character == '(') {
                String tr = sTrace.substring(ic + 2);
                if (tr.length() > 0 && tr.charAt(0) == '\"') {
                    int index = tr.indexOf(34);
                    String fName = tr.substring(0, index);
                    tc = new DefaultMutableTreeNode(fName);
                    tn.add(tc);
                    ic += index + 3;
                    ic = this.visit(sTrace, ic, tc);
                    continue;
                }
                ++ic;
            }
            int j = 0;
            while (ic + j < sTrace.length() && sTrace.charAt(ic + j) != '(' && sTrace.charAt(ic + j) != ')') {
                ++j;
            }
            String name = sTrace.substring(ic, ic + j);
            tc = new DefaultMutableTreeNode(name);
            tn.add(tc);
            ic += j;
        }
        return ic;
    }

    private int parseNodeTrace(String graphName, ArrayList<Object> nodeTrace, int i) {
        ArrayList<Object> blinkingNodes = new ArrayList<Object>();
        while (i < nodeTrace.size()) {
            if (nodeTrace.get(i) instanceof String) {
                String gName = nodeTrace.get(i).toString();
                i = this.parseNodeTrace(gName, nodeTrace, i + 1);
            } else {
                int iNode = (Integer)nodeTrace.get(i);
                if (iNode != -1) {
                    blinkingNodes.add(iNode);
                    if (iNode == 1) break;
                }
            }
            ++i;
        }
        Graph grf = null;
        ArrayList<Graph> graphs = this.grammarController.grammar.graphs;
        int ig = 0;
        while (ig < graphs.size()) {
            Graph grf0 = graphs.get(ig);
            if (grf0.name.equals(graphName)) {
                grf = grf0;
                break;
            }
            ++ig;
        }
        if (grf != null) {
            grf.setDebug(blinkingNodes);
        }
        return i;
    }
}

