/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryDialog;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Dictionary;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ErrorShell;

public class DictionaryDialogController {
    private FindReplaceDialog findReplaceDialog;
    private JTextField txtDictionaryName;
    private JCheckBox chckbxCheckAgreement;
    private JPanel pnlDisplayDictionary;
    private JTextPane txtDictionary;
    private JButton btnNewButton;
    private JButton btnEdit;
    private JButton btnInflect;
    private JButton btnCompile;
    private TitledBorder titledBorder;
    public Language lan = null;

    public DictionaryDialogController(JTextField txtDictionaryName, JCheckBox chckbxCheckAgreement, JPanel pnlDisplayDictionary, JTextPane txtDictionary, JButton btnNewButton, JButton btnEdit, JButton btnInflect, JButton btnCompile, TitledBorder titledBorder) {
        this.txtDictionaryName = txtDictionaryName;
        this.chckbxCheckAgreement = chckbxCheckAgreement;
        this.pnlDisplayDictionary = pnlDisplayDictionary;
        this.txtDictionary = txtDictionary;
        this.btnNewButton = btnNewButton;
        this.btnEdit = btnEdit;
        this.btnInflect = btnInflect;
        this.btnCompile = btnCompile;
        this.titledBorder = titledBorder;
    }

    public JTextField getTxtDictionaryName() {
        return this.txtDictionaryName;
    }

    public JCheckBox getChckbxCheckAgreement() {
        return this.chckbxCheckAgreement;
    }

    public JPanel getPnlDisplayDictionary() {
        return this.pnlDisplayDictionary;
    }

    public TitledBorder getTitledBorder() {
        return this.titledBorder;
    }

    public JTextPane getTxtDictionary() {
        return this.txtDictionary;
    }

    public static int count(String fullname) {
        BufferedReader bufferedReader = null;
        int itu = 0;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (!line.equals("") && line.charAt(0) != '#') {
                        ++itu;
                    }
                    line = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    bufferedReader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return itu;
    }

    public static int count(JTextPane rtbText) {
        int nbofentries = 0;
        Document document = rtbText.getDocument();
        Element rootElem = document.getDefaultRootElement();
        int j = 0;
        while (j < rootElem.getElementCount()) {
            Element lineElem = rootElem.getElement(j);
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            String lineText = null;
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            }
            if (!lineText.equals("")) {
                int i = 0;
                while (i < lineText.length() && lineText.charAt(i) != '#') {
                    if (lineText.charAt(i) == '\\') {
                        ++i;
                    }
                    ++i;
                }
                String line = i < lineText.length() && lineText.charAt(i) == '#' ? lineText.substring(0, i) : lineText;
                if (!line.equals("")) {
                    ++nbofentries;
                }
            }
            ++j;
        }
        return nbofentries;
    }

    public boolean loadLines(int firstline, int nboflines) {
        this.txtDictionary.setText("");
        BufferedReader bufferedReader = null;
        try {
            CursorChangeEffect.setCustomCursor(3);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.txtDictionaryName.getText()), "UTF8"));
            int iline = 0;
            StringBuilder builder = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null && iline < firstline + nboflines) {
                if (iline >= firstline) {
                    builder.append(String.valueOf(line) + "\n");
                }
                line = bufferedReader.readLine();
                ++iline;
            }
            bufferedReader.close();
            this.txtDictionary.setText(builder.toString());
            if (iline >= firstline + nboflines) {
                this.txtDictionary.setText(String.valueOf(this.txtDictionary.getText()) + "...");
                this.txtDictionary.select(0, 0);
                return false;
            }
            this.txtDictionary.select(0, 0);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CursorChangeEffect.setCustomCursor(0);
        }
        return false;
    }

    public static String getDictionaryContent(String fullname) {
        BufferedReader bufferedReader = null;
        StringBuilder builder = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
            builder = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(String.valueOf(line) + "\n");
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            if (fullname.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename cannot be empty!", "NooJ", 1);
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error occurred while reading file \"" + fullname + "\"!", "NooJ", 1);
            }
            try {
                bufferedReader.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return null;
            }
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return null;
        }
        return builder.toString();
    }

    public void desactivateOps() {
        this.btnNewButton.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnInflect.setEnabled(false);
        this.btnCompile.setEnabled(false);
        this.txtDictionaryName.setEnabled(false);
    }

    public void reactivateOps() {
        this.btnNewButton.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnInflect.setEnabled(true);
        this.btnCompile.setEnabled(true);
        this.txtDictionaryName.setEnabled(true);
        if (Dictionary.errMessage != null && Dictionary.errMessage.toString().length() > 0) {
            String errorMessage = Dictionary.errMessage.toString();
            Dic.writeLog(errorMessage);
            ErrorShell errorShell = new ErrorShell();
            errorShell.getTxtError().setText(String.valueOf(errorShell.getTxtError().getText()) + errorMessage);
            Launcher.getDesktopPane().add(errorShell);
            errorShell.setVisible(true);
        }
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }
}

