/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryDialog;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class EnrichActionListener
implements ActionListener {
    private DictionaryDialogController controller;

    public EnrichActionListener(DictionaryDialogController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.controller.lan == null) {
            this.controller.lan = new Language(Launcher.preferences.deflanguage);
        }
        RefObject<Language> lanRef = new RefObject<Language>(this.controller.lan);
        Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        this.controller.lan = (Language)lanRef.argvalue;
        String errmessage = null;
        RefObject<Object> errmessageRef = new RefObject<Object>(errmessage);
        try {
            if (!engine.loadResources(Launcher.preferences.ldic.get(this.controller.lan.isoName), Launcher.preferences.lsyn.get(this.controller.lan.isoName), true, errmessageRef)) {
                errmessage = (String)errmessageRef.argvalue;
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errmessage, "NooJ: cannot load linguistic resources", 0);
                return;
            }
        }
        catch (HeadlessException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "No input devices found!", 0);
            return;
        }
        catch (ClassNotFoundException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return;
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
        String buffer = DictionaryDialogController.getDictionaryContent(this.controller.getTxtDictionaryName().getText());
        if (buffer == null) {
            return;
        }
        String[] lines = null;
        String resultingdictionary = null;
        lines = buffer.split("\n");
        resultingdictionary = engine.enrichDictionary(lines);
        String tmp = this.controller.getTxtDictionaryName().getText();
        String fname = FilenameUtils.removeExtension(FilenameUtils.getName(tmp));
        String ext = FilenameUtils.getExtension(tmp);
        String dname = FilenameUtils.getFullPath(tmp);
        String fullname2 = String.valueOf(dname) + fname + "-en." + ext;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fullname2));
            out.write(resultingdictionary);
            out.close();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
        resultingdictionary = null;
        if (JOptionPane.showConfirmDialog(null, "Do you want to work with new created dictionary " + fullname2 + "?", "NooJ", 0) == 0) {
            this.controller.getTxtDictionaryName().setText(fullname2);
            if (this.controller.loadLines(0, 500)) {
                this.controller.getPnlDisplayDictionary().setBorder(new TitledBorder(null, "Display " + FilenameUtils.getName(this.controller.getTxtDictionaryName().getText()), 4, 2, null, null));
            } else {
                this.controller.getPnlDisplayDictionary().setBorder(new TitledBorder(null, "Display beginning of " + FilenameUtils.getName(this.controller.getTxtDictionaryName().getText()), 4, 2, null, null));
            }
        }
    }
}

