/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class SortActionListener
implements ActionListener {
    private DictionaryDialogController controller;

    public SortActionListener(DictionaryDialogController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Language lan = new Language(Launcher.preferences.deflanguage);
        ArrayList<String> lines = new ArrayList<String>();
        String rtbtext = DictionaryDialogController.getDictionaryContent(this.controller.getTxtDictionaryName().getText());
        if (rtbtext == null) {
            return;
        }
        String[] rtblines = rtbtext.split("\n");
        int iline = 0;
        while (iline < rtblines.length) {
            String line = rtblines[iline];
            while (line.length() == 0 || line.charAt(0) == '#') {
                lines.add(line);
                if (++iline >= rtblines.length) break;
                line = rtblines[iline];
            }
            ArrayList<String> lines0 = new ArrayList<String>();
            while (line.length() > 0 && line.charAt(0) != '#') {
                lines0.add(line);
                if (++iline >= rtblines.length) break;
                line = rtblines[iline];
            }
            DictionaryEditorShellController.sortLines(lines0, lan);
            lines.addAll(lines0);
        }
        StringBuilder sb = new StringBuilder();
        int iline2 = 0;
        while (iline2 < lines.size()) {
            String line = (String)lines.get(iline2);
            if (iline2 < lines.size() - 1 || !line.equals("")) {
                sb.append(String.valueOf(line) + "\n");
            }
            ++iline2;
        }
        rtblines = null;
        String resultingdictionary = sb.toString();
        sb = null;
        String tmp = this.controller.getTxtDictionaryName().getText();
        String fname = FilenameUtils.removeExtension(FilenameUtils.getName(tmp));
        String ext = FilenameUtils.getExtension(tmp);
        String dname = FilenameUtils.getFullPath(tmp);
        String fullname2 = String.valueOf(dname) + fname + "-s." + ext;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fullname2));
            out.write(resultingdictionary);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resultingdictionary = null;
        if (JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Do you want to work with new created dictionary " + fullname2 + "?", "NooJ", 0) == 0) {
            this.controller.getTxtDictionaryName().setText(fullname2);
            if (this.controller.loadLines(0, 500)) {
                this.controller.getPnlDisplayDictionary().setBorder(new TitledBorder(null, "Display " + FilenameUtils.getName(this.controller.getTxtDictionaryName().getText()), 4, 2, null, null));
            } else {
                this.controller.getPnlDisplayDictionary().setBorder(new TitledBorder(null, "Display beginning of " + FilenameUtils.getName(this.controller.getTxtDictionaryName().getText()), 4, 2, null, null));
            }
        }
    }
}

