/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.FlexDescEditorShell;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Utilities;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import org.apache.commons.io.FilenameUtils;

public class FlexDescEditorShellController {
    private JTextPane textPane;
    private FlexDescEditorShell shell;
    private String fullName;
    private boolean modified;
    private GramType grammartype;
    private Language iLan;
    private Language oLan;
    private ArrayList<Object> coloredSequences;
    private boolean coloring;
    private boolean colored;
    private FindReplaceDialog findReplaceDialog;

    public FlexDescEditorShellController(JTextPane textPane, FlexDescEditorShell flexDescEditorShell) {
        this.textPane = textPane;
        this.shell = flexDescEditorShell;
        this.modified = false;
        this.fullName = null;
        this.shell.setTitle("Untitled");
        this.findReplaceDialog = null;
    }

    public boolean loadFromFile(String fullname) {
        this.fullName = fullname;
        BufferedReader sr = null;
        StringBuilder builder = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
        }
        catch (FileNotFoundException e) {
            if (fullname.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename cannot be empty!", "NooJ", 1);
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File \"" + fullname + "\" not found!", "NooJ", 1);
            }
            return false;
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while encoding! Unsupported encoding!", 0);
        }
        try {
            builder = new StringBuilder();
            String line0 = sr.readLine();
            while (line0 != null) {
                builder.append(line0);
                builder.append("\n");
                line0 = sr.readLine();
            }
            this.textPane.setText(builder.toString());
            sr.close();
        }
        catch (IOException e) {
            try {
                sr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: Cannot load file " + fullname, "NooJ", 1);
            return false;
        }
        if (!this.checkHeader()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Header file is invalid", "Grammar file is corrupted", 1);
            return false;
        }
        String gtname = this.getGrammarTypeName();
        if (gtname == null) {
            String ext = FilenameUtils.getExtension(fullname);
            if (ext.equals("flx") || ext.equals("FLX")) {
                gtname = "FLX";
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot process grammar type ." + ext, "Grammar file extension error", 1);
                return false;
            }
        }
        this.grammartype = gtname.equals("FLX") ? GramType.FLX : (gtname.equals("MORPHO") ? GramType.MORPHO : GramType.SYNTAX);
        if (this.grammartype == GramType.FLX) {
            this.iLan = new Language(this.getLanguage());
            if (this.iLan == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot process language in file " + fullname, "Grammar file is corrupted", 0);
                return false;
            }
            this.oLan = null;
        } else {
            this.iLan = new Language(this.getILanguage());
            if (this.iLan == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot process language in file " + fullname, "Grammar file is corrupted", 0);
                return false;
            }
            this.oLan = new Language(this.getOLanguage());
            if (this.oLan == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot process output language in file " + fullname, "Grammar file is corrupted", 0);
                return false;
            }
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
        this.textPane.setCaretPosition(0);
        return true;
    }

    public void saveFlexDesc() {
        if (this.fullName == null) {
            this.saveAsFlexDesc();
        } else {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.save();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    public void saveAsFlexDesc() {
        FileNameExtensionFilter filter;
        File file;
        JFileChooser chooser = Launcher.getSaveGramChooser();
        if (this.fullName != null) {
            chooser.setSelectedFile(new File(this.fullName));
        } else {
            chooser.setSelectedFile(new File(""));
        }
        String ext = null;
        if (this.grammartype == GramType.SYNTAX) {
            file = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.iLan.isoName, "Syntactic Analysis")));
            chooser.setCurrentDirectory(file);
            filter = new FileNameExtensionFilter("Syntactic Grammar (*.nog)", "nog");
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            ext = ".nog";
        } else if (this.grammartype == GramType.MORPHO) {
            file = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.iLan.isoName, "Lexical Analysis")));
            chooser.setCurrentDirectory(file);
            filter = new FileNameExtensionFilter("Morphological Grammar (*.nom)", "nom");
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            ext = ".nom";
        } else {
            file = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.iLan.isoName, "Lexical Analysis")));
            chooser.setCurrentDirectory(file);
            filter = new FileNameExtensionFilter("Inflect/Deriv. Grammar (*.jnof)", "jnof");
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            ext = ".jnof";
        }
        if (chooser.showSaveDialog(this.shell) != 0) {
            return;
        }
        String fileStr = chooser.getSelectedFile().getAbsolutePath();
        if (!fileStr.endsWith(ext)) {
            fileStr = String.valueOf(fileStr) + ext;
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(fileStr, false);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void saveFlexDescForNooJ() {
        String languagename = this.iLan.isoName;
        String dirname = null;
        dirname = this.grammartype == GramType.SYNTAX ? FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat("initial", FilenameUtils.concat(languagename, "Syntactic Analysis"))) : FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat(languagename, "Lexical Analysis"));
        String fname = FilenameUtils.getName(this.fullName);
        String noojname = FilenameUtils.concat(dirname, fname);
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(noojname, true);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        JOptionPane.showMessageDialog(this.shell, "File " + noojname + " has been updated.", "NooJ Update", 1);
    }

    public void save() {
        if (this.fullName == null) {
            this.saveAsFlexDesc();
        } else {
            this.save(this.fullName, false);
        }
    }

    private void save(String fullname, boolean forNooJ) {
        block19: {
            if (!forNooJ) {
                String fname = FilenameUtils.getName(fullname);
                if (fname.charAt(0) == '_' && JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0) != 0) {
                    return;
                }
                try {
                    Utilities.savePreviousVersion(fullname, Launcher.preferences.multiplebackups);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: cannot save previous version of file", "NooJ", 1);
                }
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(fullname));
                    writer.write(this.textPane.getText());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: cannot save inflectional description", "NooJ", 0);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!forNooJ) {
            this.fullName = fullname;
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
    }

    public void initLoad(GramType grammartype, Language iLan, Language oLan, String author, String institution) {
        this.grammartype = grammartype;
        this.iLan = iLan;
        this.oLan = oLan;
        this.textPane.setText("");
        StringBuilder builder = new StringBuilder();
        builder.append("# NooJ V3\n");
        builder.append("#\n");
        if (this.grammartype == GramType.FLX) {
            builder.append("# Inflectional/Derivational description\n");
        } else if (this.grammartype == GramType.MORPHO) {
            builder.append("# Morphological grammar\n");
        } else {
            builder.append("# Syntactic grammar\n");
        }
        if (author != null && !author.equals("")) {
            builder.append("# Author: " + author + "\n");
        }
        if (institution != null && !institution.equals("")) {
            builder.append("# Institution: " + institution + "\n");
        }
        builder.append("#\n");
        if (this.grammartype == GramType.FLX) {
            builder.append("# Language is: " + iLan.isoName + "\n");
        } else {
            builder.append("# Input Language is: " + iLan.isoName + "\n");
            builder.append("# Output Language is: " + oLan.isoName + "\n");
        }
        builder.append("#\n");
        builder.append("# Special Characters: '=' '<' '>' '\\' '\"' ':' '+' '/' '#' ';'\n");
        builder.append("#\n");
        if (this.grammartype == GramType.FLX) {
            builder.append("# Generic Commands:\n");
            builder.append("# <B>: keyboard Backspace\n");
            builder.append("# <C>: change Case\n");
            builder.append("# <D>: Duplicate current char\n");
            builder.append("# <E>: Empty string\n");
            builder.append("# <L>: keyboard Left arrow\n");
            builder.append("# <N>: go to end of Next word form\n");
            builder.append("# <P>: go to end of Previous word form\n");
            builder.append("# <R>: keyboard Right arrow\n");
            builder.append("# <S>: delete/Suppress current char\n");
            builder.append("# Arguments for commands <B>, <L>, <N>, <P>, <R>, <S>:\n");
            builder.append("# xx number: repeat xx times\n");
            builder.append("# W: whole word\n");
            builder.append("# Examples\n");
            builder.append("# <R3>: go right 3 times\n");
            builder.append("# <LW>: go to beg. of word\n");
            builder.append("#\n");
            builder.append("# Language-Specific Commands:\n");
            builder.append(String.valueOf(iLan.inflectionCommands()) + "\n");
        } else {
            builder.append("# Special Start Rule: Main\n");
            builder.append("#\n\n");
            builder.append("Main = ");
        }
        this.textPane.setText(builder.toString());
    }

    private boolean checkHeader() {
        String lineText;
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return false;
        }
        Element lineElem = rootElem.getElement(0);
        if (lineElem == null) {
            return false;
        }
        int lineStart = lineElem.getStartOffset();
        int lineEnd = lineElem.getEndOffset();
        try {
            lineText = document.getText(lineStart, lineEnd - lineStart).trim();
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return false;
        }
        return lineText.equals("# NooJ V1") || lineText.equals("# NooJ V2") || lineText.equals("# NooJ V3");
    }

    private String getGrammarTypeName() {
        String line;
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() < 3) {
            return null;
        }
        Element lineElem = rootElem.getElement(1);
        if (lineElem == null) {
            return null;
        }
        int lineStart = lineElem.getStartOffset();
        int lineEnd = lineElem.getEndOffset();
        try {
            line = document.getText(lineStart, lineEnd - lineStart).trim();
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        if (line.equals("# Inflectional/Derivational Description")) {
            return "FLX";
        }
        lineElem = rootElem.getElement(2);
        if (lineElem == null) {
            return null;
        }
        lineStart = lineElem.getStartOffset();
        lineEnd = lineElem.getEndOffset();
        try {
            line = document.getText(lineStart, lineEnd - lineStart).trim();
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        if (line.equals("# Inflectional/Derivational description")) {
            return "FLX";
        }
        if (line.equals("# Morphological grammar")) {
            return "MORPHO";
        }
        if (line.equals("# Syntactic grammar")) {
            return "SYNTAX";
        }
        return null;
    }

    private String getLanguage() {
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return null;
        }
        int i = 0;
        Element lineElem;
        while ((lineElem = rootElem.getElement(i)) != null) {
            String pref;
            String lineText;
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
            if (lineText.length() >= 17 && (pref = lineText.substring(0, 15)).equals("# Language is: ")) {
                return lineText.substring(15);
            }
            ++i;
        }
        return null;
    }

    private String getILanguage() {
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return null;
        }
        int i = 0;
        Element lineElem;
        while ((lineElem = rootElem.getElement(i)) != null) {
            String pref;
            String lineText;
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
            if (lineText.length() >= 23 && (pref = lineText.substring(0, 21)).equals("# Input Language is: ")) {
                return lineText.substring(21);
            }
            ++i;
        }
        return null;
    }

    private String getOLanguage() {
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return null;
        }
        int i = 0;
        Element lineElem;
        while ((lineElem = rootElem.getElement(i)) != null) {
            String pref;
            String lineText;
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return null;
            }
            if (lineText.length() >= 24 && (pref = lineText.substring(0, 22)).equals("# Output Language is: ")) {
                return lineText.substring(22);
            }
            ++i;
        }
        return null;
    }

    public void modify() {
        if (this.coloring) {
            return;
        }
        if (this.colored) {
            this.colored = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StyledDocument doc = FlexDescEditorShellController.this.textPane.getStyledDocument();
                    doc.setCharacterAttributes(0, FlexDescEditorShellController.this.textPane.getText().length(), FlexDescEditorShellController.this.textPane.getStyle("black"), true);
                    int x = FlexDescEditorShellController.this.textPane.getCaretPosition();
                    FlexDescEditorShellController.this.textPane.setCaretPosition(0);
                    FlexDescEditorShellController.this.textPane.setCaretPosition(x);
                }
            });
        }
        this.modified = true;
        if (this.fullName == null) {
            this.shell.setTitle("Untitled [Modified]");
        } else {
            this.shell.setTitle(String.valueOf(FilenameUtils.getName(this.fullName)) + " [Modified]");
        }
    }

    public void close() {
        if (this.findReplaceDialog != null) {
            this.findReplaceDialog.dispose();
            this.setFindReplaceDialog(null);
        }
        if (this.modified && Launcher.projectMode) {
            int code = this.grammartype == GramType.FLX ? JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save inflectional/derivational description?", "NooJ: inflectional description file has not been not saved", 1) : (this.grammartype == GramType.MORPHO ? JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save morphological grammar?", "NooJ: morphological grammar has not been not saved", 1) : JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save syntactic grammar?", "NooJ: syntactic grammar has not been not saved", 1));
            if (code == 2) {
                return;
            }
            if (code == 0) {
                this.save();
            }
        }
        this.shell.dispose();
    }

    public boolean computeColoring() {
        this.coloredSequences = new ArrayList();
        if (!this.checkHeader()) {
            return false;
        }
        this.colorrules();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void colorrules() {
        buf = this.textPane.getText();
        i = 0;
        while (true) {
            if (i < buf.length() && Character.isWhitespace(buf.charAt(i))) {
                ++i;
                continue;
            }
            if (i != buf.length()) ** GOTO lbl15
            return;
lbl-1000:
            // 1 sources

            {
                i = this.colorcomment(i);
                while (i < buf.length() && Character.isWhitespace(buf.charAt(i))) {
                    ++i;
                }
                if (i != buf.length()) continue;
                return;
lbl15:
                // 2 sources

                ** while (buf.charAt((int)i) == '#')
            }
lbl16:
            // 1 sources

            j = 0;
            while (i + j < buf.length() && buf.charAt(i + j) != '=' && buf.charAt(i + j) != '#') {
                ++j;
            }
            k1 = i;
            while (buf.charAt(k1) == ' ') {
                ++k1;
            }
            k2 = i + j - 1;
            while (buf.charAt(k2) == ' ') {
                --k2;
            }
            buf2 = buf.substring(k1, k2);
            if (buf2.indexOf(32) != -1) {
                this.coloredSequences.add(i);
                j = buf.length() - i;
                this.coloredSequences.add(j);
                this.coloredSequences.add(Color.RED);
                JOptionPane.showMessageDialog(this.shell, "There is a space character in rule name", "NooJ rule syntax error", 1);
                return;
            }
            if (j == 0) {
                this.coloredSequences.add(i);
                j = buf.length() - i;
                this.coloredSequences.add(j);
                this.coloredSequences.add(Color.RED);
                JOptionPane.showMessageDialog(this.shell, "There is no name for rule definition", "NooJ rule syntax error", 1);
                return;
            }
            if (i + j == buf.length()) {
                this.coloredSequences.add(i);
                j = buf.length() - i;
                this.coloredSequences.add(j);
                this.coloredSequences.add(Color.RED);
                JOptionPane.showMessageDialog(this.shell, "There is no '=' in rule definition", "NooJ rule syntax error", 1);
                return;
            }
            if (buf.charAt(i + j) == '#') {
                this.coloredSequences.add(i);
                j = buf.length() - i;
                this.coloredSequences.add(j);
                this.coloredSequences.add(Color.RED);
                JOptionPane.showMessageDialog(this.shell, "There is a comment inside a rule name", "NooJ rule syntax error", 1);
                return;
            }
            this.coloredSequences.add(i);
            this.coloredSequences.add(j + 1);
            this.coloredSequences.add(Color.BLUE);
            i += j + 1;
            j = 0;
            while (i + j < buf.length() && buf.charAt(i + j) != ';') {
                if (buf.charAt(i + j) == '\"') {
                    ++j;
                    while (i + j < buf.length() && buf.charAt(i + j) != '\"') {
                        ++j;
                    }
                    if (i + j == buf.length()) {
                        this.coloredSequences.add(i);
                        this.coloredSequences.add(j);
                        this.coloredSequences.add(Color.RED);
                        JOptionPane.showMessageDialog(this.shell, "There is no closing \" in rule", "NooJ rule syntax error", 1);
                        return;
                    }
                } else if (buf.charAt(i + j) == '\\') {
                    ++j;
                } else if (buf.charAt(i + j) == ':') {
                    k = 1;
                    while (i + j + k < buf.length() && buf.charAt(i + j + k) != ' ' && buf.charAt(i + j + k) != '/' && buf.charAt(i + j + k) != '+' && buf.charAt(i + j + k) != '|' && buf.charAt(i + j + k) != ')' && buf.charAt(i + j + k) != ';' && buf.charAt(i + j + k) != '#') {
                        ++k;
                    }
                    if (i + j == buf.length()) {
                        this.coloredSequences.add(i);
                        this.coloredSequences.add(buf.length() - i);
                        this.coloredSequences.add(Color.RED);
                        JOptionPane.showMessageDialog(this.shell, "There is no ending ';' in rule", "NooJ rule syntax error", 1);
                        return;
                    }
                    this.coloredSequences.add(i + j);
                    this.coloredSequences.add(k);
                    this.coloredSequences.add(Color.ORANGE);
                    j += k - 1;
                } else if (buf.charAt(i + j) == '/') {
                    if (buf.charAt(i + j + 1) == '\"') {
                        k = 2;
                        while (i + j + k < buf.length() && buf.charAt(i + j + k) != '\"') {
                            ++k;
                        }
                        if (i + j + k == buf.length()) {
                            this.coloredSequences.add(i);
                            this.coloredSequences.add(buf.length() - i);
                            this.coloredSequences.add(Color.RED);
                            JOptionPane.showMessageDialog(this.shell, "There is no closing \" in rule", "NooJ rule syntax error", 1);
                            return;
                        }
                        ++k;
                    } else {
                        k = 1;
                        while (i + j + k < buf.length() && buf.charAt(i + j + k) != ' ' && buf.charAt(i + j + k) != '|' && buf.charAt(i + j + k) != ')' && buf.charAt(i + j + k) != ';') {
                            ++k;
                        }
                    }
                    if (i + j + k == buf.length()) {
                        this.coloredSequences.add(i);
                        this.coloredSequences.add(buf.length() - i);
                        this.coloredSequences.add(Color.RED);
                        JOptionPane.showMessageDialog(this.shell, "Unexpected ending: no ';' in rule", "NooJ rule syntax error", 1);
                        return;
                    }
                    this.coloredSequences.add(i + j);
                    this.coloredSequences.add(k);
                    this.coloredSequences.add(Color.DARK_GRAY);
                    j += k - 1;
                } else if (buf.charAt(i + j) == '$' && buf.length() > i + j + 1 && (buf.charAt(i + j + 1) == '(' || buf.charAt(i + j + 1) == ')')) {
                    k = 2;
                    while (i + j + k < buf.length() && buf.charAt(i + j + k) != ' ' && buf.charAt(i + j + k) != '|' && buf.charAt(i + j + k) != ')' && buf.charAt(i + j + k) != ';') {
                        ++k;
                    }
                    if (i + j + k == buf.length()) {
                        this.coloredSequences.add(i);
                        this.coloredSequences.add(buf.length() - i);
                        this.coloredSequences.add(Color.RED);
                        JOptionPane.showMessageDialog(this.shell, "Unexpected ending: no ';' in rule", "NooJ rule syntax error", 1);
                        return;
                    }
                    this.coloredSequences.add(i + j);
                    this.coloredSequences.add(k);
                    this.coloredSequences.add(Color.RED);
                    j += k - 1;
                } else if (buf.charAt(i + j) == '=') {
                    this.coloredSequences.add(i);
                    j = buf.length() - i;
                    this.coloredSequences.add(j);
                    this.coloredSequences.add(Color.RED);
                    JOptionPane.showMessageDialog(this.shell, "There is no ending ';' in rule", "NooJ rule syntax error", 1);
                    return;
                }
                ++j;
            }
            if (i + j == buf.length()) {
                this.coloredSequences.add(i);
                this.coloredSequences.add(j - 1);
                this.coloredSequences.add(Color.RED);
                JOptionPane.showMessageDialog(this.shell, "There is no ending ';' in rule", "NooJ rule syntax error", 1);
                return;
            }
            this.coloredSequences.add(i + j);
            this.coloredSequences.add(1);
            this.coloredSequences.add(Color.BLUE);
            i += j + 1;
        }
    }

    private int colorcomment(int ibuf) {
        String pref;
        String buf = this.textPane.getText();
        int i = 1;
        while (ibuf + i < buf.length() && buf.charAt(ibuf + i) != '\n') {
            ++i;
        }
        String commentline = buf.substring(ibuf, ibuf + i);
        if (commentline.length() == 17 && (pref = commentline.substring(0, 15)).equals("# Language is: ")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(17);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.length() == 23 && (pref = commentline.substring(0, 21)).equals("# Input Language is: ")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(23);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.length() == 24 && (pref = commentline.substring(0, 22)).equals("# Output Language is: ")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(24);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.indexOf("# Author: ") == 0) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(commentline.length());
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.indexOf("# Institution: ") == 0) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(commentline.length());
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.equals("# NooJ V1") || commentline.equals("# NooJ V2") || commentline.equals("# NooJ V3")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(19);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.equals("# Syntactic grammar")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(19);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.equals("# Morphological grammar")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(23);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        if (commentline.equals("# Inflectional/Derivational description")) {
            this.coloredSequences.add(ibuf);
            this.coloredSequences.add(23);
            this.coloredSequences.add(Color.GREEN);
            return ibuf + i;
        }
        this.coloredSequences.add(ibuf);
        this.coloredSequences.add(i);
        this.coloredSequences.add(Color.GREEN);
        return ibuf + i;
    }

    public void totalColoring() {
        if (this.coloredSequences == null || this.coloredSequences.size() == 0) {
            return;
        }
        this.coloring = true;
        StyledDocument doc = this.textPane.getStyledDocument();
        doc.setCharacterAttributes(0, this.textPane.getText().length(), this.textPane.getStyle("red"), true);
        int i = 0;
        while (i < this.coloredSequences.size()) {
            int s = (Integer)this.coloredSequences.get(i);
            int l = (Integer)this.coloredSequences.get(i + 1);
            Color c = (Color)this.coloredSequences.get(i + 2);
            doc.setCharacterAttributes(s, l, this.textPane.getStyle("black"), true);
            if (c == Color.RED) {
                doc.setCharacterAttributes(s, l, this.textPane.getStyle("red"), true);
            } else if (c == Color.GREEN) {
                doc.setCharacterAttributes(s, l, this.textPane.getStyle("green"), true);
            } else if (c == Color.BLUE) {
                doc.setCharacterAttributes(s, l, this.textPane.getStyle("blue"), true);
            } else if (c == Color.ORANGE) {
                doc.setCharacterAttributes(s, l, this.textPane.getStyle("orange"), true);
            } else if (c == Color.DARK_GRAY) {
                doc.setCharacterAttributes(s, l, this.textPane.getStyle("gray"), true);
            }
            i += 3;
        }
        this.coloring = false;
        this.colored = true;
    }

    public String getFullName() {
        return this.fullName;
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Language getiLan() {
        return this.iLan;
    }
}

