/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GramStructShell;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.shells.GramStructShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class GramStructShellController {
    public JTree tvGraphs;
    public GrammarEditorShell formGrammar;
    public GramStructShell structShell;
    private boolean[] visited;
    private boolean hack_clearing;

    public GramStructShellController(GramStructShell s, GrammarEditorShell shell) {
        this.structShell = s;
        this.tvGraphs = s.tvGraphs;
        this.formGrammar = shell;
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.tvGraphs.getModel().getRoot();
        this.expandAll(this.tvGraphs, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (parent.getPathCount() == 1) {
            return;
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public int findGraph(String gname) {
        int index = -1;
        int ig = 0;
        while (ig < this.formGrammar.getController().grammar.graphs.size()) {
            Graph grf2 = this.formGrammar.getController().grammar.graphs.get(ig);
            if (grf2 != null && grf2.name.equals(gname)) {
                index = ig;
                break;
            }
            ++ig;
        }
        return index;
    }

    String getNameFromTreeNodeLabel(String text) {
        String label = text;
        int le = label.length();
        if (le > 4 && label.substring(le - 4, le - 2).equals(" (") && label.substring(le - 1, le).equals(")")) {
            label = label.substring(0, le - 4);
        }
        return label;
    }

    boolean isRecursive(String gname, TreeNode node) {
        node = node.getParent();
        while (node != null) {
            String label = this.getNameFromTreeNodeLabel(node.toString());
            if (label.equals(gname)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private boolean isChild(String gname, TreeNode node) {
        int i = 0;
        while (i < node.getChildCount()) {
            if (node.getChildAt(i).toString().equals(gname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void visit(JTree tv) {
        String gname;
        Graph grf;
        this.hack_clearing = true;
        ((DefaultMutableTreeNode)tv.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)tv.getModel()).reload();
        this.hack_clearing = false;
        this.visited = new boolean[this.formGrammar.getController().grammar.graphs.size()];
        int i = 0;
        while (i < this.formGrammar.getController().grammar.graphs.size()) {
            this.visited[i] = false;
            ++i;
        }
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)tv.getModel().getRoot();
        int index = -1;
        int i2 = 0;
        while (i2 < this.formGrammar.getController().grammar.graphs.size()) {
            grf = this.formGrammar.getController().grammar.graphs.get(i2);
            if (grf != null && (gname = grf.name).equals("Main")) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index != -1) {
            this.visited[index] = true;
            Graph grf2 = this.formGrammar.getController().grammar.graphs.get(index);
            if (grf2 != null) {
                String gname2 = grf2.name;
                DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname2);
                top.add(tn);
                this.visitEmbeddedGraphs(grf2, tn);
            }
        }
        i = 0;
        while (i < this.formGrammar.getController().grammar.graphs.size()) {
            if (!this.visited[i]) {
                this.visited[i] = true;
                grf = this.formGrammar.getController().grammar.graphs.get(i);
                if (grf != null) {
                    gname = grf.name;
                    DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname);
                    top.add(tn);
                    this.visitEmbeddedGraphs(grf, tn);
                }
            }
            ++i;
        }
        ((DefaultTreeModel)tv.getModel()).reload();
        tv.setEnabled(true);
        tv.update(this.tvGraphs.getGraphics());
    }

    public void recursiveDelete(TreeNode currentNode, int current) {
        this.hack_clearing = true;
        JTree tv = this.tvGraphs;
        ((DefaultMutableTreeNode)tv.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)tv.getModel()).reload();
        this.hack_clearing = false;
        this.visited = new boolean[this.formGrammar.getController().grammar.graphs.size()];
        int i = 0;
        while (i < this.formGrammar.getController().grammar.graphs.size()) {
            this.visited[i] = false;
            ++i;
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("");
        ((DefaultTreeModel)tv.getModel()).setRoot(top);
        this.visited[current] = true;
        Graph grf = this.formGrammar.getController().grammar.graphs.get(current);
        if (grf != null) {
            String gname = grf.name;
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname);
            top.add(tn);
            this.visitEmbeddedGraphs(grf, tn);
        }
        int ig = 0;
        while (ig < this.formGrammar.getController().grammar.graphs.size()) {
            if (this.visited[ig]) {
                this.formGrammar.getController().grammar.graphs.set(ig, null);
            }
            ++ig;
        }
        ig = 0;
        while (ig < this.formGrammar.getController().grammar.graphs.size()) {
            Graph g = this.formGrammar.getController().grammar.graphs.get(ig);
            if (g == null) {
                this.formGrammar.getController().grammar.graphs.remove(ig);
                continue;
            }
            ++ig;
        }
        this.tvGraphs.update(this.tvGraphs.getGraphics());
    }

    private void renameNodes(DefaultMutableTreeNode tn, String oldname, String newname) {
        String label = tn.toString();
        if (label.length() > 4 && label.substring(label.length() - 4).equals(" (R)")) {
            if ((label = label.substring(0, label.length() - 4)).equals(oldname)) {
                tn = new DefaultMutableTreeNode(String.valueOf(newname) + " (R)");
            }
            return;
        }
        if (tn.toString().equals(oldname)) {
            tn = new DefaultMutableTreeNode(newname);
        }
        if (tn.getChildCount() == 0) {
            return;
        }
        int i = 0;
        while (i < tn.getChildCount()) {
            DefaultMutableTreeNode t = (DefaultMutableTreeNode)tn.getChildAt(i);
            if (t.toString().equals(oldname)) {
                t = new DefaultMutableTreeNode(newname);
            }
            if (!this.isRecursive(t.toString(), t)) {
                this.renameNodes(t, oldname, newname);
            }
            ++i;
        }
    }

    void rename(String oldname, String newname) {
        int i = 0;
        while (i < this.formGrammar.getController().grammar.graphs.size()) {
            Graph grf = this.formGrammar.getController().grammar.graphs.get(i);
            if (grf != null) {
                if (grf.name.equals(oldname)) {
                    grf.name = newname;
                }
                int inode = 0;
                while (inode < grf.label.size()) {
                    ArrayList<String> recterms;
                    if (inode != 1 && !grf.commentNode(inode) && !grf.areaNode(inode) && (recterms = Graph.embGraphsLabel(grf.label.get(inode))) != null) {
                        grf.renameEmbeddedGraphInLabel(inode, oldname, newname);
                    }
                    ++inode;
                }
            }
            ++i;
        }
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.tvGraphs.getModel().getRoot();
        this.renameNodes(tn, oldname, newname);
        this.tvGraphs.update(this.tvGraphs.getGraphics());
    }

    private void visitEmbeddedGraphs(Graph grf, DefaultMutableTreeNode tn) {
        int nbofnodes = grf.label.size();
        int inode = 0;
        while (inode < nbofnodes) {
            ArrayList<String> recterms;
            if (inode != 1 && !grf.commentNode(inode) && !grf.areaNode(inode) && (recterms = Graph.embGraphsLabel(grf.label.get(inode))) != null) {
                int iterm = 0;
                while (iterm < recterms.size()) {
                    String gname = recterms.get(iterm);
                    if (!this.isChild(gname, tn)) {
                        DefaultMutableTreeNode ntn;
                        int index;
                        if (this.isRecursive(gname, tn)) {
                            index = -1;
                            int i = 0;
                            while (i < tn.getChildCount()) {
                                if (tn.getChildAt(i).toString().equals(String.valueOf(gname) + " (R)")) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (index == -1) {
                                ntn = new DefaultMutableTreeNode(String.valueOf(gname) + " (R)");
                                tn.add(ntn);
                            }
                        } else {
                            index = this.findGraph(gname);
                            if (index != -1) {
                                this.visited[index] = true;
                                ntn = new DefaultMutableTreeNode(gname);
                                tn.add(ntn);
                                Graph grf2 = this.formGrammar.getController().grammar.graphs.get(index);
                                this.visitEmbeddedGraphs(grf2, ntn);
                                this.tvGraphs.update(this.tvGraphs.getGraphics());
                            } else {
                                index = -1;
                                int i = 0;
                                while (i < tn.getChildCount()) {
                                    if (tn.getChildAt(i).toString().equals(String.valueOf(gname) + " (X)")) {
                                        index = i;
                                        break;
                                    }
                                    ++i;
                                }
                                if (index == -1) {
                                    ntn = new DefaultMutableTreeNode(String.valueOf(gname) + " (X)");
                                    tn.add(ntn);
                                }
                                this.tvGraphs.update(this.tvGraphs.getGraphics());
                            }
                        }
                    }
                    ++iterm;
                }
            }
            ++inode;
        }
    }

    public void loadParent() {
        if (this.formGrammar.getController().currentNode.getParent() != null) {
            this.formGrammar.getController().currentNode = (DefaultMutableTreeNode)this.formGrammar.getController().currentNode.getParent();
        }
        if (this.tvGraphs.isVisible()) {
            this.tvGraphs.setSelectionPath(new TreePath(this.formGrammar.getController().currentNode));
        } else {
            int c = this.findGraph(this.formGrammar.getController().currentNode.toString());
            if (c != -1) {
                this.formGrammar.getController().current = c;
                this.formGrammar.getController().grf = this.formGrammar.getController().grammar.graphs.get(this.formGrammar.getController().current);
                if (this.formGrammar.getController().dialogHistory != null && this.formGrammar.getController().dialogHistory.isVisible()) {
                    this.formGrammar.getController().dialogHistory.getController().updateNewFor(this.formGrammar);
                }
            }
        }
        this.formGrammar.getController().editor.pGraph.invalidate();
        this.formGrammar.getController().editor.pGraph.repaint();
    }

    public void loadFirstChild() {
        if (this.formGrammar.getController().currentNode.getChildAt(0) != null) {
            this.formGrammar.getController().currentNode = (DefaultMutableTreeNode)this.formGrammar.getController().currentNode.getChildAt(0);
        }
        if (this.tvGraphs.isVisible()) {
            this.tvGraphs.setSelectionPath(new TreePath(this.formGrammar.getController().currentNode));
        } else {
            int c = this.findGraph(this.formGrammar.getController().currentNode.toString());
            if (c != -1) {
                this.formGrammar.getController().current = c;
                this.formGrammar.getController().grf = this.formGrammar.getController().grammar.graphs.get(this.formGrammar.getController().current);
                if (this.formGrammar.getController().dialogHistory != null && this.formGrammar.getController().dialogHistory.isVisible()) {
                    this.formGrammar.getController().dialogHistory.getController().updateNewFor(this.formGrammar);
                }
            }
        }
        this.formGrammar.getController().editor.pGraph.invalidate();
        this.formGrammar.getController().editor.pGraph.repaint();
    }

    public void loadNextChild() {
        int index;
        if (this.formGrammar.getController().currentNode.getNextNode() != null) {
            this.formGrammar.getController().currentNode = this.formGrammar.getController().currentNode.getNextNode();
        }
        if (!this.tvGraphs.isVisible() && (index = this.findGraph(this.formGrammar.getController().currentNode.toString())) != -1) {
            this.formGrammar.getController().current = index;
            this.formGrammar.getController().grf = this.formGrammar.getController().grammar.graphs.get(this.formGrammar.getController().current);
            if (this.formGrammar.getController().dialogHistory != null && this.formGrammar.getController().dialogHistory.isVisible()) {
                this.formGrammar.getController().dialogHistory.getController().updateNewFor(this.formGrammar);
            }
        }
        this.formGrammar.pGraph.invalidate();
        this.formGrammar.pGraph.repaint();
    }

    public void loadPreviousChild() {
        int index;
        if (this.formGrammar.getController().currentNode.getPreviousNode() != null) {
            this.formGrammar.getController().currentNode = this.formGrammar.getController().currentNode.getPreviousNode();
        }
        if (!this.tvGraphs.isVisible() && (index = this.findGraph(this.formGrammar.getController().currentNode.toString())) != -1) {
            this.formGrammar.getController().current = index;
            this.formGrammar.getController().grf = this.formGrammar.getController().grammar.graphs.get(this.formGrammar.getController().current);
            if (this.formGrammar.getController().dialogHistory != null && this.formGrammar.getController().dialogHistory.isVisible()) {
                this.formGrammar.getController().dialogHistory.getController().updateNewFor(this.formGrammar);
            }
        }
        this.formGrammar.pGraph.invalidate();
        this.formGrammar.pGraph.repaint();
    }

    public void select() {
        if (this.isHack_clearing()) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tvGraphs.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        String label = this.getNameFromTreeNodeLabel(node.toString());
        int index = this.findGraph(label);
        if (index != -1) {
            this.getFormGrammar().current = index;
            this.getFormGrammar().grf = this.getFormGrammar().grammar.graphs.get(this.getFormGrammar().current);
            if (this.getFormGrammar().dialogHistory != null) {
                this.getFormGrammar().dialogHistory.getController().updateNewFor(this.formGrammar);
            }
            this.getFormGrammar().currentNode = node;
            if (this.isRecursive(label, node)) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getParent();
                while (n != null) {
                    if (label == this.getNameFromTreeNodeLabel(n.toString())) {
                        this.getFormGrammar().currentNode = n;
                        break;
                    }
                    n = (DefaultMutableTreeNode)n.getParent();
                }
            }
        } else if (JOptionPane.showConfirmDialog(null, "Create New Graph?", "NooJ", 0) == 0) {
            Graph ngrf = new Graph();
            ngrf.wholeGrammar = this.getFormGrammar().grammar;
            ngrf.name = this.getNameFromTreeNodeLabel(node.toString());
            ngrf.addNode("<E>", 30, 30);
            ngrf.addNode("", 50, 60);
            this.getFormGrammar().grammar.graphs.add(ngrf);
            this.getFormGrammar().current = this.getFormGrammar().grammar.graphs.size() - 1;
            this.getFormGrammar().grf = this.getFormGrammar().grammar.graphs.get(this.getFormGrammar().current);
            if (this.getFormGrammar().dialogHistory != null) {
                this.getFormGrammar().dialogHistory.getController().updateNewFor(this.getFormGrammar().editor);
            }
            this.getFormGrammar().currentNode = node;
            this.tvGraphs.getModel().valueForPathChanged(this.tvGraphs.getSelectionPath(), ngrf.name);
        } else {
            this.getFormGrammar().currentNode = (DefaultMutableTreeNode)node.getParent();
        }
        this.tvGraphs.setSelectionPath(new TreePath(this.getFormGrammar().currentNode));
        this.tvGraphs.expandPath(new TreePath(this.getFormGrammar().currentNode));
        this.getFormGrammar().visitHistory.add(this.getFormGrammar().currentNode);
        this.formGrammar.invalidate();
        this.formGrammar.repaint();
    }

    public boolean isHack_clearing() {
        return this.hack_clearing;
    }

    public GrammarEditorShellController getFormGrammar() {
        return this.formGrammar.getController();
    }
}

