/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GramStructShell;

import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.nooj4nlp.controller.GramStructShell.GramStructShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.utilities.Helper;

public class SelectionListener
implements TreeSelectionListener {
    private GramStructShellController controller;

    public SelectionListener(GramStructShellController controller) {
        this.controller = controller;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        if (this.controller.isHack_clearing()) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.controller.tvGraphs.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        String label = this.controller.getNameFromTreeNodeLabel(node.toString());
        int index = this.controller.findGraph(label);
        if (index != -1) {
            this.controller.getFormGrammar().current = index;
            this.controller.getFormGrammar().grf = this.controller.getFormGrammar().grammar.graphs.get(this.controller.getFormGrammar().current);
            if (this.controller.getFormGrammar().dialogHistory != null) {
                this.controller.getFormGrammar().dialogHistory.getController().updateNewFor(this.controller.getFormGrammar().editor);
            }
            this.controller.getFormGrammar().currentNode = node;
            if (this.controller.isRecursive(label, node)) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getParent();
                while (n != null) {
                    if (label == this.controller.getNameFromTreeNodeLabel(n.toString())) {
                        this.controller.getFormGrammar().currentNode = n;
                        break;
                    }
                    n = (DefaultMutableTreeNode)n.getParent();
                }
            }
        } else if (JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Create New Graph?", "NooJ", 0) == 0) {
            Graph ngrf = new Graph();
            ngrf.wholeGrammar = this.controller.getFormGrammar().grammar;
            ngrf.name = this.controller.getNameFromTreeNodeLabel(node.toString());
            ngrf.addNode("<E>", 30, 30);
            ngrf.addNode("", 50, 60);
            this.controller.getFormGrammar().grammar.graphs.add(ngrf);
            this.controller.getFormGrammar().current = this.controller.getFormGrammar().grammar.graphs.size() - 1;
            this.controller.getFormGrammar().grf = this.controller.getFormGrammar().grammar.graphs.get(this.controller.getFormGrammar().current);
            if (this.controller.getFormGrammar().dialogHistory != null) {
                this.controller.getFormGrammar().dialogHistory.getController().updateNewFor(this.controller.getFormGrammar().editor);
            }
            this.controller.getFormGrammar().currentNode = node;
            this.controller.tvGraphs.getModel().valueForPathChanged(this.controller.tvGraphs.getSelectionPath(), ngrf.name);
        } else {
            this.controller.getFormGrammar().currentNode = (DefaultMutableTreeNode)node.getParent();
        }
        this.controller.tvGraphs.setSelectionPath(new TreePath(this.controller.getFormGrammar().currentNode));
        this.controller.tvGraphs.expandPath(new TreePath(this.controller.getFormGrammar().currentNode));
        this.controller.getFormGrammar().visitHistory.add(this.controller.getFormGrammar().currentNode);
        this.controller.formGrammar.invalidate();
        this.controller.formGrammar.repaint();
        Helper.putDialogOnTheTop(this.controller.structShell);
    }
}

