/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarEditorShell;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.nooj4nlp.controller.DebugShell.DbgTimerActionListener;
import net.nooj4nlp.controller.GrammarEditorShell.TimerActionListener;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Utilities;
import net.nooj4nlp.gui.dialogs.AlignmentDialog;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.dialogs.GraphPresentationDialog;
import net.nooj4nlp.gui.dialogs.HistoryDialog;
import net.nooj4nlp.gui.dialogs.ProduceParaphrasesDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ContractShell;
import net.nooj4nlp.gui.shells.DebugShell;
import net.nooj4nlp.gui.shells.GramStructShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class GrammarEditorShellController {
    public boolean modified;
    public int current;
    public DefaultMutableTreeNode currentNode;
    private String fullName;
    public Language lan;
    private Language lan2;
    public ArrayList<Object> visitHistory;
    public Font iFont;
    public Font oFont;
    public Font cFont;
    public Graph grf;
    public Grammar grammar;
    public String originallabel;
    public int graphnum = 0;
    public GrammarEditorShell editor;
    private FindReplaceDialog findReplaceDialog = null;
    public GramStructShell formGramStruct;
    public AlignmentDialog alignmentDialog;
    public GraphPresentationDialog presentationDialog;
    public DebugShell debugShell;
    private JLabel label;
    public boolean first_paint = true;
    public int mouseOX;
    public int mouseOY;
    public int mouseX;
    public int mouseY;
    boolean mouseD;
    public boolean mouseM;
    public int mouseN;
    public int mouseEdited;
    public int mouseR;
    public Rectangle SelectionRectangle;
    public int lasteditednode = 0;
    public int nbofcreatednodes = 1;
    public ContractShell contractShell;
    public ProduceParaphrasesDialog transformationDialog;
    public HistoryDialog dialogHistory;
    private int timerSelCount;
    private Timer timerSel;
    private Timer timerDbg;

    public GrammarEditorShellController(GrammarEditorShell shell, Language l, Language l2) {
        this.editor = shell;
        this.label = this.editor.info;
        this.label.setText("TEST");
        this.lan = l;
        this.lan2 = l2;
        this.contractShell = new ContractShell(this.editor, this.grammar, this.lan);
        this.formGramStruct = new GramStructShell(this.editor);
        this.dialogHistory = new HistoryDialog(this.editor);
        this.visitHistory = new ArrayList();
        this.timerSel = new Timer(100, new TimerActionListener(this.editor));
        this.timerSel.start();
        this.timerDbg = new Timer(100, new DbgTimerActionListener(this));
        this.SelectionRectangle = new Rectangle();
        this.resetMouseStatus();
    }

    public GrammarEditorShellController(GrammarEditorShell shell, String fname) {
        this.editor = shell;
        this.label = this.editor.info;
        this.label.setText("TEST");
        this.lan2 = null;
        this.lan = null;
        this.fullName = fname;
        this.contractShell = new ContractShell(this.editor, this.grammar, this.lan);
        this.formGramStruct = new GramStructShell(this.editor);
        this.dialogHistory = new HistoryDialog(this.editor);
        this.visitHistory = new ArrayList();
        this.timerSelCount = 0;
        this.timerSel = new Timer(100, new TimerActionListener(this.editor));
        this.timerSel.start();
        this.timerDbg = new Timer(100, new DbgTimerActionListener(this));
        this.SelectionRectangle = new Rectangle();
        this.resetMouseStatus();
    }

    public void updateFormHeader() {
        this.label.setText(this.lan.engName);
        if (this.grammar.gramType == GramType.SYNTAX && this.lan2 != null) {
            this.label.setText(String.valueOf(this.label.getText()) + "/" + this.lan2.engName);
        }
        JFileChooser chooser = Launcher.getSaveGramChooser();
        if (this.grammar.gramType == GramType.FLX) {
            this.label.setText(String.valueOf(this.label.getText()) + " inflectional grammar");
            File directory = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis")));
            chooser.setCurrentDirectory(directory);
        } else if (this.grammar.gramType == GramType.MORPHO) {
            this.label.setText(String.valueOf(this.label.getText()) + " morphological grammar");
            File directory = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis")));
            chooser.setCurrentDirectory(directory);
        } else {
            this.label.setText(String.valueOf(this.label.getText()) + " syntactic grammar");
            File directory = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Syntactic Analysis")));
            chooser.setCurrentDirectory(directory);
        }
        this.editor.getMntmDebug().setEnabled(this.grammar != null && this.grammar.gramType != GramType.FLX && this.grammar.lockType == 0);
        this.editor.getMntmShowStructure().setEnabled(this.grammar != null && this.grammar.lockType == 0);
        if (this.grammar.graphs.size() > 1) {
            this.label.setText(String.valueOf(this.label.getText()) + " consists of " + this.grammar.graphs.size() + " graphs");
        }
        if (this.grammar.lockType == 1) {
            this.label.setText(String.valueOf(this.label.getText()) + " (protected)");
        } else if (this.grammar.lockType == 2) {
            this.label.setText(String.valueOf(this.label.getText()) + " (Community protected)");
        }
        this.label.setText(String.valueOf(this.label.getText()) + ".");
    }

    public void ModifyExamples() {
        this.modified = true;
        if (this.fullName == null) {
            this.editor.setTitle("Untitled [Modified]");
        } else {
            this.editor.setTitle(String.valueOf(FilenameUtils.getName(this.fullName)) + " [Modified]");
        }
        if (this.dialogHistory != null && this.dialogHistory.isVisible()) {
            this.dialogHistory.getController().updateCurrentFor(this.editor);
        }
    }

    public void newGrammar(GramType gt, String author, String institution, String password, short locktype, String ilanguage, String olanguage, Preferences preferences) {
        this.grammar = new Grammar(gt, author, institution, password, locktype, ilanguage, olanguage, preferences);
        this.iFont = new Font(this.grammar.iFontName, this.grammar.iFontStyle, (int)this.grammar.iFontSize);
        this.oFont = new Font(this.grammar.oFontName, this.grammar.oFontStyle, (int)this.grammar.oFontSize);
        this.cFont = new Font(this.grammar.cFontName, this.grammar.cFontStyle, (int)this.grammar.cFontSize);
        this.lan = new Language(ilanguage);
        if (this.lan == null) {
            return;
        }
        if (olanguage == null) {
            this.lan2 = new Language(ilanguage);
        }
        this.lan2 = new Language(olanguage);
        if (this.lan2 == null) {
            return;
        }
        if (this.lan.rightToLeft) {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.contractShell.getController().txtConsole.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.contractShell.getController().txtConsole.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        Graph g = new Graph();
        g.name = "Main";
        g.wholeGrammar = this.grammar;
        g.addNode("<E>", 30, 30);
        g.addNode("", 50, 60);
        g.saveCurrentGraphInHistory("New Grammar");
        this.grammar.graphs.add(g);
        this.resetTvGraphs();
        this.modified = false;
        this.updateFormHeader();
        this.editor.setTitle("Untitled");
    }

    private void resetTvGraphs() {
        this.current = 0;
        this.grf = this.grammar.graphs.get(this.current);
        if (this.dialogHistory != null && this.dialogHistory.isVisible()) {
            this.dialogHistory.getController().updateNewFor(this.editor);
        }
        if (this.formGramStruct.tvGraphs.isEnabled()) {
            this.formGramStruct.getController().visit(this.formGramStruct.tvGraphs);
            this.editor.formGramStruct = this.formGramStruct;
            this.currentNode = (DefaultMutableTreeNode)this.formGramStruct.tvGraphs.getModel().getRoot();
        }
    }

    public void removeCurrentGraph() {
        this.grammar.graphs.remove(this.grf);
        this.updateFormHeader();
    }

    public void loadIntexGrammar(String fullname, GramType gt, String ilanguage, String olanguage, String encodingcode, Preferences preferences) {
        this.grammar = Grammar.importWithAllEmbeddedGraphs(fullname, gt, ilanguage, olanguage, encodingcode, preferences);
        if (this.grammar == null) {
            return;
        }
        this.iFont = new Font(this.grammar.iFontName, this.grammar.iFontStyle, (int)this.grammar.iFontSize);
        this.oFont = new Font(this.grammar.oFontName, this.grammar.oFontStyle, (int)this.grammar.oFontSize);
        this.cFont = new Font(this.grammar.cFontName, this.grammar.cFontStyle, (int)this.grammar.cFontSize);
        for (Graph o : this.grammar.graphs) {
            Graph g = o;
            if (g == null) continue;
            g.history = new ArrayList();
            g.iHistory = 0;
            g.inodeconnected = -1;
            g.inodemoved = -1;
            g.saveCurrentGraphInHistory("import INTEX graph");
        }
        this.grammar.author = null;
        this.grammar.institution = null;
        this.lan = new Language(ilanguage);
        if (this.lan == null) {
            return;
        }
        this.lan2 = new Language(olanguage);
        if (this.lan2 == null) {
            return;
        }
        this.contractShell.getController().lan = this.lan;
        if (this.lan.rightToLeft) {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        this.grammar.gramType = gt;
        this.editor.getMntmShowContract().setEnabled(gt != GramType.FLX);
        this.resetTvGraphs();
        this.modified = false;
        this.editor.setTitle("Untitled [Modified]");
        this.updateFormHeader();
        this.fullName = null;
    }

    public void SaveGraph(String fullname) {
        boolean righttoleft = this.lan.rightToLeft;
        this.grf.saveIntex(fullname, righttoleft);
    }

    public boolean addIntexGraph(String fullgname, String graphname, String encodingcode, GramType gt) {
        File f = new File(fullgname);
        if (!f.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file:\n" + fullgname, "NooJ: graph file is not found", 2);
            return false;
        }
        Graph grf0 = Graph.loadIntex(this.grammar, fullgname, encodingcode, gt);
        if (grf0 == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load graph:\n" + fullgname, "NooJ: INTEX graph format error", 2);
            return false;
        }
        grf0.name = graphname;
        if (grf0 != null) {
            boolean alreadythere = false;
            int jgrf = 0;
            while (jgrf < this.grammar.graphs.size()) {
                Graph grf1 = this.grammar.graphs.get(jgrf);
                if (grf1.name == grf0.name) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Graph " + grf0.name + " already exists.", "NooJ: duplicate graph will not be imported", 2);
                    alreadythere = true;
                    break;
                }
                ++jgrf;
            }
            if (!alreadythere) {
                this.grammar.graphs.add(grf0);
                ArrayList<String> recGraph = new ArrayList<String>();
                recGraph.add(graphname);
                if (!this.grammar.importEmbeddedGraphs(f.getParentFile().getName(), grf0, recGraph, encodingcode, gt)) {
                    return false;
                }
            }
        }
        this.updateFormHeader();
        return true;
    }

    public void addNoojGrammar(String fullname, String graphname, GramType gt) {
        Grammar grm0 = Grammar.loadONooJGrammar(fullname);
        if (grm0 == null) {
            return;
        }
        int igrf = 0;
        while (igrf < grm0.graphs.size()) {
            Graph grf0 = grm0.graphs.get(igrf);
            if (igrf == 0) {
                grf0.name = FilenameUtils.removeExtension(new File(fullname).getName());
            }
            boolean alreadythere = false;
            int jgrf = 0;
            while (jgrf < this.grammar.graphs.size()) {
                Graph grf1 = this.grammar.graphs.get(jgrf);
                if (grf1.name.equals(grf0.name)) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Graph " + grf0.name + " already exists!", "NooJ: duplicate graph will not be imported", 2);
                    alreadythere = true;
                    break;
                }
                ++jgrf;
            }
            if (!alreadythere) {
                this.grammar.graphs.add(grf0);
            }
            ++igrf;
        }
        this.resetTvGraphs();
        this.editor.pGraph.invalidate();
        this.updateFormHeader();
    }

    public void LoadGrammar(String fullname, boolean fromCSharp) {
        this.grammar = Grammar.loadONooJGrammar(fullname);
        if (this.grammar == null) {
            return;
        }
        if ((double)this.grammar.iFontSize == 0.0) {
            this.grammar.iFontSize = 12.0f;
        }
        this.iFont = new Font(this.grammar.iFontName, this.grammar.iFontStyle, (int)this.grammar.iFontSize);
        if ((double)this.grammar.oFontSize == 0.0) {
            this.grammar.oFontSize = 12.0f;
        }
        this.oFont = new Font(this.grammar.oFontName, this.grammar.oFontStyle, (int)this.grammar.oFontSize);
        if ((double)this.grammar.cFontSize == 0.0) {
            this.grammar.cFontSize = 12.0f;
        }
        this.cFont = new Font(this.grammar.cFontName, this.grammar.cFontStyle, (int)this.grammar.cFontSize);
        HashMap alreadythere = new HashMap();
        int ig = 0;
        while (ig < this.grammar.graphs.size()) {
            Graph g = this.grammar.graphs.get(ig);
            if (g == null) {
                this.grammar.graphs.remove(ig);
                continue;
            }
            String gname = g.name;
            if (gname == null || gname.equals("") || alreadythere.containsKey(gname)) {
                this.grammar.graphs.remove(ig);
                continue;
            }
            alreadythere.put(gname, null);
            if (g.history == null) {
                g.history = new ArrayList();
                g.iHistory = 0;
                g.inodeconnected = -1;
                g.inodemoved = -1;
                g.saveCurrentGraphInHistory("load grammar");
            }
            if (g.name.equals("Main") && ig != 0) {
                Graph tmp = this.grammar.graphs.get(0);
                this.grammar.graphs.set(0, g);
                this.grammar.graphs.set(ig, tmp);
            }
            ++ig;
        }
        if (this.grammar.lockType != 0) {
            this.contractShell.getController().txtConsole.setEditable(false);
        }
        this.lan = new Language(this.grammar.iLanguage);
        if (this.lan == null) {
            return;
        }
        if (this.lan.isoName != this.grammar.iLanguage) {
            this.grammar.iLanguage = this.lan.isoName;
            this.lan = new Language(this.grammar.iLanguage);
        }
        this.lan2 = new Language(this.grammar.oLanguage);
        if (this.lan2 == null) {
            return;
        }
        if (this.lan2.isoName != this.grammar.oLanguage) {
            this.grammar.oLanguage = this.lan2.isoName;
            this.lan2 = new Language(this.grammar.oLanguage);
        }
        if (this.lan.rightToLeft) {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.editor.pGraph.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        if (this.grammar.windowHeight != 0 && this.grammar.windowWidth != 0) {
            this.editor.setSize(new Dimension(this.grammar.windowWidth, this.grammar.windowHeight));
        }
        this.contractShell.getController().lan = this.lan;
        this.contractShell.getController().grammar = this.grammar;
        this.contractShell.getController().txtConsole.setText(this.grammar.checkText);
        if (this.lan.rightToLeft) {
            this.contractShell.getController().txtConsole.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.contractShell.getController().txtConsole.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        this.resetTvGraphs();
        this.modified = false;
        this.editor.setTitle(new File(fullname).getName());
        this.updateFormHeader();
    }

    private void save() {
        this.save(this.fullName, false);
    }

    private void save(String fullname, boolean forNooJ) {
        if (fullname == null || fullname.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save grammar", "NooJ: undefined file name", 2);
            return;
        }
        if (!forNooJ) {
            int dr;
            String fnamenoext = FilenameUtils.removeExtension(new File(fullname).getName());
            if (fnamenoext.charAt(0) == '_' && (dr = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0, 3, null, null, null)) == 1) {
                return;
            }
            try {
                Utilities.savePreviousVersion(fullname, Launcher.preferences.multiplebackups);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.grammar.windowHeight = this.editor.getHeight();
        this.grammar.windowWidth = this.editor.getWidth();
        if (this.contractShell == null) {
            this.contractShell = new ContractShell(this.editor, this.grammar, this.lan);
        }
        this.grammar.checkText = this.contractShell.getController().txtConsole.getText();
        if (this.grammar.gramType != GramType.FLX) {
            try {
                int dr;
                int grammarschecksok = this.contractShell.getController().checkContract();
                if (grammarschecksok == 0 && (dr = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Grammar is broken. Do you want to save it anyway?", "NooJ: Contract failed", 0, 3, null, null, null)) == 1) {
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.grammar.saveONooJGrammar(fullname);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: cannot save grammar", "Error", 2);
            return;
        }
        this.modified = false;
        if (!forNooJ) {
            this.fullName = fullname;
        }
        this.editor.setTitle(new File(fullname).getName());
    }

    public void revert() {
        this.LoadGrammar(this.fullName, false);
        this.editor.rtBox.setSize(0, 0);
        this.editor.rtBox.setLocation(new Point(0, 0));
        if (!this.timerSel.isRunning()) {
            this.timerSel.start();
        }
        this.editor.invalidate();
        this.editor.repaint();
    }

    private void resetMouseStatus() {
        this.mouseN = -1;
        this.mouseEdited = -1;
        this.mouseM = false;
        this.mouseD = false;
        this.mouseEdited = -1;
        this.mouseN = -1;
    }

    public int getMark() {
        int inode = 2;
        while (inode < this.grf.hei.size()) {
            boolean sel;
            if (inode != this.mouseEdited && this.grf.areaNode(inode) && (sel = this.grf.selected.get(inode).booleanValue())) {
                int h;
                int x = this.grf.posX.get(inode);
                int y = this.grf.posY.get(inode);
                int w = this.grf.wid.get(inode);
                Rectangle rect = new Rectangle((int)((float)(x + w) * this.grf.scale), (int)((float)(y + (h = this.grf.hei.get(inode).intValue())) * this.grf.scale), 10, 10);
                if (rect.contains(this.mouseX, this.mouseY)) {
                    return inode;
                }
            }
            ++inode;
        }
        return -1;
    }

    public void getMouseN() {
        int ybottom;
        int ytop;
        int xright;
        int xleft;
        float scale = this.grf.scale;
        this.mouseN = -1;
        int inode = 0;
        while (inode < this.grf.hei.size()) {
            if (inode != this.mouseEdited && !this.grf.areaNode(inode)) {
                xleft = (int)((float)this.grf.posX.get(inode).intValue() * scale);
                xright = xleft + this.grf.wid.get(inode);
                ytop = (int)((float)this.grf.posY.get(inode).intValue() * scale) - this.grf.hei.get(inode);
                ybottom = (int)((float)this.grf.posY.get(inode).intValue() * scale) + this.grf.hei.get(inode);
                if (this.mouseOX >= xleft && this.mouseOX <= xright && this.mouseOY >= ytop && this.mouseOY <= ybottom) {
                    this.mouseN = inode;
                    return;
                }
            }
            ++inode;
        }
        inode = 0;
        while (inode < this.grf.hei.size()) {
            if (inode != this.mouseEdited && this.grf.areaNode(inode)) {
                xleft = (int)((float)this.grf.posX.get(inode).intValue() * scale);
                xright = xleft + (int)((float)this.grf.wid.get(inode).intValue() * scale);
                ytop = (int)((float)this.grf.posY.get(inode).intValue() * scale) - (int)((float)this.grf.hei.get(inode).intValue() * scale);
                ybottom = (int)((float)this.grf.posY.get(inode).intValue() * scale) + (int)((float)this.grf.hei.get(inode).intValue() * scale);
                if (this.mouseOX >= xleft && this.mouseOX <= xright && this.mouseOY >= ytop && this.mouseOY <= ybottom) {
                    this.mouseN = inode;
                    return;
                }
            }
            ++inode;
        }
    }

    public void getMouseNodes() {
        float scale = this.grf.scale;
        Rectangle SelRectangle = this.computeRectangle(this.SelectionRectangle);
        int xr = SelRectangle.x;
        int yr = SelRectangle.y;
        int x2r = xr + SelRectangle.width;
        int y2r = yr + SelRectangle.height;
        int inode = 0;
        while (inode < this.grf.hei.size()) {
            if (inode == this.mouseEdited || this.grf.areaNode(inode)) {
                this.grf.selected.set(inode, false);
            } else {
                int xleft = (int)((float)this.grf.posX.get(inode).intValue() * scale);
                int xright = xleft + this.grf.wid.get(inode);
                int ytop = (int)((float)this.grf.posY.get(inode).intValue() * scale) - this.grf.hei.get(inode);
                int ybottom = (int)((float)this.grf.posY.get(inode).intValue() * scale) + this.grf.hei.get(inode);
                if (xr <= xleft && x2r >= xleft && yr <= ytop && y2r >= ytop) {
                    this.grf.selected.set(inode, true);
                } else if (xr <= xleft && x2r >= xleft && yr <= ybottom && y2r >= ybottom) {
                    this.grf.selected.set(inode, true);
                } else if (xr <= xright && x2r >= xright && yr <= ytop && y2r >= ytop) {
                    this.grf.selected.set(inode, true);
                } else if (xr <= xright && x2r >= xright && yr <= ybottom && y2r >= ybottom) {
                    this.grf.selected.set(inode, true);
                } else {
                    this.grf.selected.set(inode, false);
                }
            }
            ++inode;
        }
    }

    public String cleanup(String label) {
        boolean found = false;
        int i = 0;
        while (i < label.length()) {
            if (label.charAt(i) == '\\') {
                ++i;
            } else if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
            } else if (label.charAt(i) == '<') {
                ++i;
                while (i < label.length() && label.charAt(i) != '>') {
                    ++i;
                }
            } else if (label.charAt(i) == '/' && !found) {
                found = true;
                if (i == 0) {
                    label = "<E>\n" + label;
                    break;
                }
                if (label.charAt(i - 1) != '\n') {
                    label = String.valueOf(label.substring(0, i)) + "\n" + label.substring(i);
                    break;
                }
            }
            ++i;
        }
        int nbterms = 0;
        StringBuilder res = new StringBuilder();
        int i2 = 0;
        while (i2 < label.length()) {
            String term;
            int j = 0;
            while (i2 + j < label.length() && label.charAt(i2 + j) != '\n') {
                ++j;
            }
            if (j < label.length()) {
                if (j > 0) {
                    term = label.substring(i2, i2 + j);
                    if (term.charAt(0) != '/') {
                        term = term.trim();
                    }
                    if (term.length() > 0) {
                        if (++nbterms > 1) {
                            res.append('\n');
                        }
                        res.append(term);
                    }
                    i2 += j;
                }
                ++i2;
                continue;
            }
            term = label.substring(i2);
            if (term.length() > 0 && term.charAt(0) != '/') {
                term = term.trim();
            }
            if (term.length() > 0) {
                if (++nbterms > 1) {
                    res.append('\n');
                }
                res.append(term);
            }
            i2 += j;
        }
        return res.toString();
    }

    private boolean hasOutput(String label) {
        int i = 0;
        while (i < label.length()) {
            if (label.charAt(i) == '/') {
                return true;
            }
            if (label.charAt(i) == '\\') {
                ++i;
            } else if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
            } else if (label.charAt(i) == '<') {
                ++i;
                while (i < label.length() && label.charAt(i) != '>') {
                    ++i;
                }
            }
            ++i;
        }
        return false;
    }

    public void displayRtbox(int inode) {
        this.timerSel.stop();
        this.grf.tColor = new Color(255, 215, 0);
        int rx = (int)((float)this.grf.posX.get(inode).intValue() * this.grf.scale);
        int ry = (int)((float)this.grf.posY.get(inode).intValue() * this.grf.scale);
        this.originallabel = this.grf.label.get(inode);
        this.editor.rtBox.setText(this.originallabel);
        boolean hasOutput = this.hasOutput(this.editor.rtBox.getText());
        if (this.grf.commentNode(inode)) {
            this.editor.rtBox.setFont(this.grf.cfont);
            this.editor.rtBox.setForeground(this.grammar.cColor);
            int height = this.grf.interline * this.editor.rtBox.getLineCount() + 10;
            int width = this.grf.widB.get(inode);
            if (this.editor.rtBox.getWidth() < 50) {
                width = 50;
            }
            this.editor.rtBox.setSize(width, height);
            if (!hasOutput) {
                this.editor.rtBox.setLocation(new Point(rx, ry - this.editor.rtBox.getHeight() / 2));
            } else {
                this.editor.rtBox.setLocation(new Point(rx, ry - (this.grf.interline * (this.editor.rtBox.getLineCount() - 1) + 10) / 2));
            }
        } else if (this.grf.areaNode(inode)) {
            this.editor.rtBox.setFont(this.grf.cfont);
            this.editor.rtBox.setForeground(this.grammar.cColor);
            if (!hasOutput) {
                this.editor.rtBox.setLocation(new Point(rx, ry - this.editor.rtBox.getHeight() / 2));
            } else {
                this.editor.rtBox.setLocation(new Point(rx, ry - (this.grf.interline * (this.editor.rtBox.getLineCount() - 1) + 10) / 2));
            }
        } else {
            this.editor.rtBox.setFont(this.grf.ifont);
            this.editor.rtBox.setForeground(this.grammar.fColor);
            int width = this.grf.widB.get(inode);
            if (this.editor.rtBox.getWidth() < 50) {
                width = 50;
            }
            int height = this.grf.interline * this.editor.rtBox.getLineCount() + 10;
            this.editor.rtBox.setSize(width, height);
            if (!hasOutput) {
                this.editor.rtBox.setLocation(new Point(rx, ry - this.editor.rtBox.getHeight() / 2));
            } else {
                this.editor.rtBox.setLocation(new Point(rx, ry - (this.grf.interline * (this.editor.rtBox.getLineCount() - 1) + 10) / 2));
            }
        }
        this.mouseEdited = inode;
        this.editor.rtBox.requestFocusInWindow();
        this.editor.rtBox.selectAll();
        this.editor.pGraph.invalidate();
        this.editor.pGraph.repaint();
    }

    public void hideRtbox() {
        this.timerSel.start();
        this.resetMouseStatus();
        this.editor.rtBox.setSize(0, 0);
        this.editor.rtBox.setLocation(new Point(0, 0));
        this.mouseEdited = -1;
        this.editor.requestFocusInWindow();
        this.editor.pGraph.invalidate();
        this.editor.pGraph.repaint();
    }

    public Rectangle computeRectangle(Rectangle selectionrectangle) {
        Rectangle drawRectangle = new Rectangle();
        if (selectionrectangle.width < 0) {
            drawRectangle.x = selectionrectangle.x + selectionrectangle.width;
            drawRectangle.width = -selectionrectangle.width;
        } else {
            drawRectangle.x = selectionrectangle.x;
            drawRectangle.width = selectionrectangle.width;
        }
        if (selectionrectangle.height < 0) {
            drawRectangle.y = selectionrectangle.y + selectionrectangle.height;
            drawRectangle.height = -selectionrectangle.height;
        } else {
            drawRectangle.y = selectionrectangle.y;
            drawRectangle.height = selectionrectangle.height;
        }
        return drawRectangle;
    }

    public void modify(String modification, boolean needtovisit, boolean invalidate) {
        this.grf.debugInvisible = false;
        this.timerDbg.stop();
        this.modified = true;
        if (this.fullName == null) {
            this.editor.setTitle("Untitled [Modified]");
        } else {
            this.editor.setTitle(String.valueOf(new File(this.fullName).getName()) + " [Modified]");
        }
        if (this.mouseD) {
            return;
        }
        if (this.contractShell.isVisible()) {
            this.contractShell.getController().UncolorCheckText();
        }
        if (invalidate) {
            this.formGramStruct.tvGraphs.setEnabled(false);
        } else if (needtovisit) {
            ArrayList<String> fullpath = new ArrayList<String>();
            fullpath.add(this.currentNode.toString());
            this.currentNode = (DefaultMutableTreeNode)this.currentNode.getParent();
            while (this.currentNode != null && !this.currentNode.toString().equals("")) {
                fullpath.add(this.currentNode.toString());
                if (this.currentNode.getParent() == null) break;
                this.currentNode = (DefaultMutableTreeNode)this.currentNode.getParent();
            }
            this.formGramStruct.getController().visit(this.formGramStruct.tvGraphs);
            Collections.reverse(fullpath);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultMutableTreeNode)((DefaultTreeModel)this.formGramStruct.tvGraphs.getModel()).getRoot()).getFirstChild();
            int ic = 0;
            while (ic < root.getChildCount()) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)root.getChildAt(ic);
                if (tn.toString() == fullpath.get(0)) {
                    this.currentNode = tn;
                    break;
                }
                ++ic;
            }
            int i = 1;
            while (i < fullpath.size()) {
                String label = (String)fullpath.get(i);
                int ic2 = 0;
                while (ic2 < this.currentNode.getChildCount()) {
                    DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.currentNode.getChildAt(ic2);
                    if (tn.toString() == label) {
                        this.currentNode = tn;
                        break;
                    }
                    ++ic2;
                }
                ++i;
            }
            if (this.currentNode == null) {
                this.currentNode = root;
            }
            this.formGramStruct.tvGraphs.expandPath(new TreePath(this.currentNode.getPath()));
        }
        if (this.grf != null) {
            this.grf.saveCurrentGraphInHistory(modification);
        }
        if (this.dialogHistory != null && this.dialogHistory.isVisible()) {
            this.dialogHistory.getController().updateNewFor(this.editor);
        }
        try {
            this.editor.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        this.editor.invalidate();
        this.editor.repaint();
    }

    private int findGraph(String gname) {
        int index = -1;
        int ig = 0;
        while (ig < this.grammar.graphs.size()) {
            Graph grf2 = this.grammar.graphs.get(ig);
            if (grf2 != null && grf2.name.equals(gname)) {
                index = ig;
                break;
            }
            ++ig;
        }
        return index;
    }

    public void findAndLoadGraph(String gname) {
        int index = this.findGraph(gname);
        if (index == -1) {
            int dr = JOptionPane.showConfirmDialog(this.editor, "Graph " + gname + " not found. Create it?", "NooJ: graph does not exist", 0);
            if (dr == 1) {
                return;
            }
            Graph ngrf = new Graph();
            ngrf.wholeGrammar = this.grammar;
            ngrf.name = gname;
            ngrf.addNode("<E>", 30, 30);
            ngrf.addNode("", 50, 60);
            this.grammar.graphs.add(ngrf);
            this.current = this.grammar.graphs.size();
        } else {
            this.current = index;
        }
        this.grf = this.grammar.graphs.get(this.current);
        this.updateGraphStructure();
        if (this.dialogHistory != null && this.dialogHistory.isVisible()) {
            this.dialogHistory.getController().updateNewFor(this.editor);
        }
    }

    public boolean findPattern(String pattern, int startnode, RefObject<Integer> graph_nb, RefObject<Integer> node_nb, RefObject<Integer> position, RefObject<Integer> length) {
        position.argvalue = length.argvalue = Integer.valueOf(0);
        node_nb.argvalue = length.argvalue;
        Graph fgrf = this.grammar.graphs.get((Integer)graph_nb.argvalue);
        int inode = 0;
        while (inode < fgrf.label.size()) {
            String buf;
            int pos;
            if (inode != 1 && (pos = (buf = this.grf.label.get(inode)).indexOf(pattern, 0)) != -1) {
                node_nb.argvalue = inode;
                position.argvalue = pos;
                length.argvalue = pattern.length();
                return true;
            }
            ++inode;
        }
        int igrf = 0;
        while (igrf < this.grammar.graphs.size()) {
            if (igrf != (Integer)graph_nb.argvalue) {
                fgrf = this.grammar.graphs.get(igrf);
                int inode2 = 0;
                while (inode2 < fgrf.label.size()) {
                    String buf;
                    int pos;
                    if (inode2 != 1 && (pos = (buf = fgrf.label.get(inode2)).indexOf(pattern, 0)) != -1) {
                        graph_nb.argvalue = igrf;
                        node_nb.argvalue = inode2;
                        position.argvalue = pos;
                        length.argvalue = pattern.length();
                        return true;
                    }
                    ++inode2;
                }
            }
            ++igrf;
        }
        return false;
    }

    public boolean findNextPattern(String pattern, int startnode, RefObject<Integer> graph_nb, RefObject<Integer> node_nb, RefObject<Integer> position, RefObject<Integer> length) {
        Graph fgrf = this.grammar.graphs.get((Integer)graph_nb.argvalue);
        int inode = (Integer)node_nb.argvalue;
        while (inode < fgrf.label.size()) {
            if (inode != 1) {
                String buf = this.grf.label.get(inode);
                int pos = inode == (Integer)node_nb.argvalue ? buf.indexOf(pattern, (Integer)position.argvalue + (Integer)length.argvalue) : buf.indexOf(pattern, 0);
                if (pos != -1) {
                    node_nb.argvalue = inode;
                    position.argvalue = pos;
                    length.argvalue = pattern.length();
                    return true;
                }
            }
            ++inode;
        }
        int igrf = (Integer)graph_nb.argvalue + 1;
        while (igrf < this.grammar.graphs.size()) {
            fgrf = this.grammar.graphs.get(igrf);
            int inode2 = 0;
            while (inode2 < fgrf.label.size()) {
                String buf;
                int pos;
                if (inode2 != 1 && (pos = (buf = fgrf.label.get(inode2)).indexOf(pattern, 0)) != -1) {
                    graph_nb.argvalue = igrf;
                    node_nb.argvalue = inode2;
                    position.argvalue = pos;
                    length.argvalue = pattern.length();
                    return true;
                }
                ++inode2;
            }
            ++igrf;
        }
        return false;
    }

    public int replaceAll(String pattern, String replacement) {
        int count = 0;
        int igrf = 0;
        while (igrf < this.grammar.graphs.size()) {
            Graph fgrf = this.grammar.graphs.get(igrf);
            int inode = 0;
            while (inode < fgrf.label.size()) {
                if (inode != 1) {
                    String buf = fgrf.label.get(inode);
                    StringBuilder res = new StringBuilder();
                    int start = 0;
                    boolean found = false;
                    int pos = 0;
                    while (pos != -1) {
                        pos = buf.indexOf(pattern, start);
                        if (pos == -1) break;
                        found = true;
                        ++count;
                        res.append(buf.substring(start, start + pos - start));
                        res.append(replacement);
                        start = pos + pattern.length();
                    }
                    if (found) {
                        res.append(buf.substring(start));
                        fgrf.label.set(inode, res.toString());
                    }
                }
                ++inode;
            }
            ++igrf;
        }
        if (count > 0) {
            this.modify("replacements", true, true);
        }
        return count;
    }

    public int replaceAllPerl(Pattern rexp, String replacement) {
        int count = 0;
        int igrf = 0;
        while (igrf < this.grammar.graphs.size()) {
            Graph fgrf = this.grammar.graphs.get(igrf);
            int inode = 0;
            while (inode < fgrf.label.size()) {
                if (inode != 1) {
                    String buf = fgrf.label.get(inode);
                    Matcher matchCollection = rexp.matcher(buf);
                    int matchCount = 0;
                    while (matchCollection.find()) {
                        ++matchCount;
                    }
                    if (matchCount != 0) {
                        count += matchCount;
                        StringBuilder res = new StringBuilder();
                        int start = 0;
                        matchCollection.reset();
                        int i = 0;
                        while (i < matchCount) {
                            matchCollection.find();
                            int pos = matchCollection.start();
                            int length = matchCollection.group().length();
                            res.append(buf.substring(start, start + pos - start));
                            res.append(replacement);
                            start = pos + length;
                            ++i;
                        }
                        res.append(buf.substring(start));
                        fgrf.label.set(inode, res.toString());
                    }
                }
                ++inode;
            }
            ++igrf;
        }
        if (count > 0) {
            this.modify("replacements", true, true);
        }
        return count;
    }

    public boolean findPattern(Pattern rexp, int startnode, RefObject<Integer> graph_nb, RefObject<Integer> node_nb, RefObject<Integer> position, RefObject<Integer> length) {
        position.argvalue = length.argvalue = Integer.valueOf(0);
        node_nb.argvalue = length.argvalue;
        Graph fgrf = this.grammar.graphs.get((Integer)graph_nb.argvalue);
        int inode = 0;
        while (inode < fgrf.label.size()) {
            if (inode != 1) {
                String buf = this.grf.label.get(inode);
                Matcher matchCollection = rexp.matcher(buf);
                int matchCount = 0;
                while (matchCollection.find()) {
                    ++matchCount;
                }
                if (matchCount != 0) {
                    matchCollection.reset();
                    matchCollection.find();
                    node_nb.argvalue = inode;
                    position.argvalue = matchCollection.start();
                    length.argvalue = matchCollection.group().length();
                    return true;
                }
            }
            ++inode;
        }
        int igrf = 0;
        while (igrf < this.grammar.graphs.size()) {
            if (igrf != (Integer)graph_nb.argvalue) {
                fgrf = this.grammar.graphs.get(igrf);
                int inode2 = 0;
                while (inode2 < fgrf.label.size()) {
                    if (inode2 != 1) {
                        String buf = fgrf.label.get(inode2);
                        Matcher matchCollection = rexp.matcher(buf);
                        int matchCount = 0;
                        while (matchCollection.find()) {
                            ++matchCount;
                        }
                        if (matchCount != 0) {
                            matchCollection.find();
                            graph_nb.argvalue = igrf;
                            node_nb.argvalue = inode2;
                            position.argvalue = matchCollection.start();
                            length.argvalue = matchCollection.group().length();
                            return true;
                        }
                    }
                    ++inode2;
                }
            }
            ++igrf;
        }
        return false;
    }

    public boolean findNextPattern(Pattern rexp, int startnode, RefObject<Integer> graph_nb, RefObject<Integer> node_nb, RefObject<Integer> position, RefObject<Integer> length) {
        Graph fgrf = this.grammar.graphs.get((Integer)graph_nb.argvalue);
        int inode = (Integer)node_nb.argvalue;
        while (inode < fgrf.label.size()) {
            if (inode != 1) {
                String buf = this.grf.label.get(inode);
                Matcher matchCollection = rexp.matcher(buf);
                if (inode == (Integer)node_nb.argvalue) {
                    matchCollection.region((Integer)position.argvalue + (Integer)length.argvalue, buf.length());
                }
                int matchCount = 0;
                while (matchCollection.find()) {
                    ++matchCount;
                }
                if (matchCount != 0) {
                    matchCollection.reset();
                    if (inode == (Integer)node_nb.argvalue) {
                        matchCollection.region((Integer)position.argvalue + (Integer)length.argvalue, buf.length());
                    }
                    matchCollection.find();
                    node_nb.argvalue = inode;
                    position.argvalue = matchCollection.start();
                    length.argvalue = matchCollection.group().length();
                    return true;
                }
            }
            ++inode;
        }
        int igrf = (Integer)graph_nb.argvalue + 1;
        while (igrf < this.grammar.graphs.size()) {
            fgrf = this.grammar.graphs.get(igrf);
            int inode2 = 0;
            while (inode2 < fgrf.label.size()) {
                if (inode2 != 1) {
                    String buf = fgrf.label.get(inode2);
                    Matcher matchCollection = rexp.matcher(buf);
                    int matchCount = 0;
                    while (matchCollection.find()) {
                        ++matchCount;
                    }
                    if (matchCount != 0) {
                        matchCollection.reset();
                        matchCollection.find();
                        graph_nb.argvalue = igrf;
                        node_nb.argvalue = inode2;
                        position.argvalue = matchCollection.start();
                        length.argvalue = matchCollection.group().length();
                        return true;
                    }
                }
                ++inode2;
            }
            ++igrf;
        }
        return false;
    }

    public boolean UpdateGraphStructureFromTop(TreeNode root) {
        while (root != null) {
            if (root.toString().equals(this.grf.name)) {
                this.currentNode = (DefaultMutableTreeNode)root;
                this.formGramStruct.tvGraphs.grabFocus();
                if (this.formGramStruct.isVisible()) {
                    this.formGramStruct.tvGraphs.setSelectionPath(new TreePath(((DefaultMutableTreeNode)root).getPath()));
                    ((DefaultTreeModel)this.formGramStruct.tvGraphs.getModel()).reload();
                    return true;
                }
            }
            if (((DefaultMutableTreeNode)root).getChildCount() != 0 && this.UpdateGraphStructureFromTop(((DefaultMutableTreeNode)root).getFirstChild())) {
                return true;
            }
            root = ((DefaultMutableTreeNode)root).getNextSibling();
        }
        return false;
    }

    private void updateGraphStructure() {
        if (this.currentNode.getChildCount() != 0) {
            TreeNode node = this.currentNode.getFirstChild();
            while (node != null && !node.toString().equals(this.grf.name)) {
                node = ((DefaultMutableTreeNode)node).getNextSibling();
            }
            if (node != null) {
                this.currentNode = (DefaultMutableTreeNode)node;
                ((DefaultTreeModel)this.formGramStruct.tvGraphs.getModel()).reload();
                this.formGramStruct.tvGraphs.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node).getPath()));
            }
        }
        this.editor.rtBox.grabFocus();
    }

    public void saveGrammar() {
        if (this.fullName == null) {
            this.saveAsGrammar();
        } else {
            this.editor.setCursor(Cursor.getPredefinedCursor(3));
            this.save();
            this.editor.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void saveAsGrammar() {
        FileNameExtensionFilter filterGrammar = null;
        if (this.grammar.gramType == GramType.MORPHO) {
            String currentDirToBeSetPath = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis"));
            Launcher.getSaveGramChooser().setCurrentDirectory(new File(currentDirToBeSetPath));
            filterGrammar = new FileNameExtensionFilter("NooJ Morphology (*.jnom)", "jnom");
            Launcher.getSaveGramChooser().addChoosableFileFilter(filterGrammar);
            Launcher.getSaveGramChooser().setFileFilter(filterGrammar);
        } else if (this.grammar.gramType == GramType.FLX) {
            filterGrammar = new FileNameExtensionFilter("NooJ Inflection (*.jnof)", "jnof");
            Launcher.getSaveGramChooser().addChoosableFileFilter(filterGrammar);
            Launcher.getSaveGramChooser().setFileFilter(filterGrammar);
        } else if (this.grammar.gramType == GramType.SYNTAX) {
            filterGrammar = new FileNameExtensionFilter("NooJ Grammar (*.nog)", "nog");
            Launcher.getSaveGramChooser().addChoosableFileFilter(filterGrammar);
            Launcher.getSaveGramChooser().setFileFilter(filterGrammar);
        }
        if (Launcher.getSaveGramChooser().showSaveDialog(null) == 1) {
            return;
        }
        this.editor.setCursor(Cursor.getPredefinedCursor(3));
        String extension = Launcher.getSaveGramChooser().getFileFilter().getDescription();
        String ext = "";
        if (extension == "NooJ Inflection (*.jnof)") {
            ext = ".nog";
        } else if (extension == "NooJ Morphology (*.jnom))") {
            ext = ".nog";
        } else if (extension == "NooJ Grammar (*.nog)") {
            ext = ".nog";
        }
        this.fullName = String.valueOf(Launcher.getSaveGramChooser().getSelectedFile().getAbsolutePath()) + ext;
        if (this.fullName == null || this.fullName.equals("")) {
            JOptionPane.showMessageDialog(this.editor, "Cannot set file name to '" + this.fullName + "'");
            this.editor.getLastCursor();
            return;
        }
        this.save();
        this.editor.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void saveGrammarForNooJ() {
        String languagename = this.lan.isoName;
        String dirname = this.grammar.gramType == GramType.SYNTAX ? FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat("initial", FilenameUtils.concat(languagename, "Syntactic Analysis"))) : FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat("initial", FilenameUtils.concat(languagename, "Lexical Analysis")));
        if (this.fullName == null) {
            JOptionPane.showMessageDialog(this.editor, "Name this grammar first", "NooJ: Grammar has no name", 2);
            return;
        }
        String fname = new File(this.fullName).getName();
        String noojname = String.valueOf(dirname) + System.getProperty("file.separator") + fname;
        this.editor.setCursor(Cursor.getPredefinedCursor(3));
        this.save(noojname, true);
        this.editor.setCursor(Cursor.getPredefinedCursor(0));
        JOptionPane.showMessageDialog(this.editor, "File " + noojname + " has been updated", "NooJ Update", -1);
    }

    public void zoom(int zoomPercentage) {
        this.grf.fits = zoomPercentage;
        this.editor.repaint();
    }

    public void deleteGraphAndItsChildren() {
        if (this.currentNode == null) {
            return;
        }
        String gName = this.grf.name;
        if (this.grammar.graphs.size() > 1) {
            this.modify("recursively delete graph " + gName, true, false);
            this.formGramStruct.getController().recursiveDelete(this.currentNode, this.current);
        }
        this.updateFormHeader();
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Timer getTimerDbg() {
        return this.timerDbg;
    }
}

