/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarEditorShell;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class JPGraphMouseMotionListener
implements MouseMotionListener {
    private GrammarEditorShell editor;
    private GrammarEditorShellController controller;

    public JPGraphMouseMotionListener(GrammarEditorShell shell) {
        this.editor = shell;
        this.controller = this.editor.getController();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Graph grf = this.controller.grf;
        if (grf == null) {
            return;
        }
        if (!this.controller.mouseM) {
            this.controller.mouseM = true;
            this.controller.mouseX = this.controller.mouseOX;
            this.controller.mouseY = this.controller.mouseOY;
            this.controller.mouseR = this.controller.getMark();
            if (this.controller.mouseR == -1) {
                this.controller.getMouseN();
            }
            return;
        }
        if (this.controller.mouseR != -1) {
            this.controller.grf.posY.set(this.controller.mouseR, grf.posY.get(this.controller.mouseR) + (int)((float)(e.getY() - this.controller.mouseY) / grf.scale) / 2);
            this.controller.grf.wid.set(this.controller.mouseR, grf.wid.get(this.controller.mouseR) + (int)((float)(e.getX() - this.controller.mouseX) / grf.scale));
            this.controller.grf.hei.set(this.controller.mouseR, grf.hei.get(this.controller.mouseR) + (int)((float)(e.getY() - this.controller.mouseY) / grf.scale) / 2);
            this.editor.pGraph.invalidate();
            this.controller.mouseX = e.getX();
            this.controller.mouseY = e.getY();
        }
        if (this.controller.mouseN != -1) {
            this.controller.grf.nbofnodesmoved = 0;
            this.controller.grf.inodemoved = -1;
            int inode = 0;
            while (inode < this.controller.grf.label.size()) {
                boolean sel = this.controller.grf.selected.get(inode);
                if (inode != this.controller.mouseEdited && (sel || inode == this.controller.mouseN)) {
                    this.controller.grf.posX.set(inode, this.controller.grf.posX.get(inode) + (int)((float)(e.getX() - this.controller.mouseX) / this.controller.grf.scale));
                    this.controller.grf.posY.set(inode, this.controller.grf.posY.get(inode) + (int)((float)(e.getY() - this.controller.mouseY) / this.controller.grf.scale));
                    ++this.controller.grf.nbofnodesmoved;
                    this.controller.grf.inodemoved = inode;
                }
                ++inode;
            }
            this.controller.mouseX = e.getX();
            this.controller.mouseY = e.getY();
            this.controller.modify(null, false, false);
        } else {
            this.controller.SelectionRectangle.x = this.controller.mouseOX;
            this.controller.SelectionRectangle.y = this.controller.mouseOY;
            this.controller.SelectionRectangle.width = e.getX() - this.controller.mouseOX;
            this.controller.SelectionRectangle.height = e.getY() - this.controller.mouseOY;
            this.controller.getMouseNodes();
        }
        this.editor.pGraph.invalidate();
        this.editor.pGraph.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

