/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GraphPresentationDialog;

import java.awt.Color;
import java.awt.Font;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.gui.components.UsualColoredButtonUI;
import net.nooj4nlp.gui.dialogs.GraphPresentationDialog;
import net.nooj4nlp.gui.main.Launcher;

public class GraphPresentationController {
    private GraphPresentationDialog dialog;
    private GrammarEditorShellController grammarController;
    private Font iFont;
    private Font oFont;
    private Font cFont;
    private Grammar currentGrammar;

    public GraphPresentationController(GraphPresentationDialog dialog, GrammarEditorShellController grammarController) {
        this.dialog = dialog;
        this.grammarController = grammarController;
    }

    public void showDialog() {
        this.currentGrammar = this.grammarController.grammar;
        this.dialog.getCbDate().setSelected(this.currentGrammar.dispDate);
        this.dialog.getCbFrame().setSelected(this.currentGrammar.dispFrame);
        this.dialog.getCbFileName().setSelected(this.currentGrammar.dispFile);
        this.dialog.getCbDirName().setSelected(this.currentGrammar.dispDir);
        this.dialog.getCbAuthor().setSelected(this.currentGrammar.dispAuthor);
        this.dialog.getCbInstitution().setSelected(this.currentGrammar.dispInstitution);
        this.dialog.getCbCircleEmptyNodes().setSelected(this.currentGrammar.dispState);
        Font grammarIFont = this.grammarController.iFont;
        this.iFont = new Font(grammarIFont.getFamily(), grammarIFont.getStyle(), grammarIFont.getSize());
        String labelInputText = String.valueOf(this.iFont.getFamily()) + ", " + this.iFont.getSize();
        if (this.iFont.isBold()) {
            labelInputText = String.valueOf(labelInputText) + ", Bold";
        }
        if (this.iFont.isItalic()) {
            labelInputText = String.valueOf(labelInputText) + ", Italic";
        }
        this.dialog.getLabelInput().setText(labelInputText);
        Font grammarOFont = this.grammarController.oFont;
        this.oFont = new Font(grammarOFont.getFamily(), grammarOFont.getStyle(), grammarOFont.getSize());
        String labelOutputText = String.valueOf(this.oFont.getFamily()) + ", " + this.oFont.getSize();
        if (this.oFont.isBold()) {
            labelOutputText = String.valueOf(labelOutputText) + ", Bold";
        }
        if (this.oFont.isItalic()) {
            labelOutputText = String.valueOf(labelOutputText) + ", Italic";
        }
        this.dialog.getLabelOutput().setText(labelOutputText);
        Font grammarCFont = this.grammarController.cFont;
        this.cFont = new Font(grammarCFont.getFamily(), grammarCFont.getStyle(), grammarCFont.getSize());
        String labelComText = String.valueOf(this.cFont.getFamily()) + ", " + this.cFont.getSize();
        if (this.cFont.isBold()) {
            labelComText = String.valueOf(labelComText) + ", Bold";
        }
        if (this.cFont.isItalic()) {
            labelComText = String.valueOf(labelComText) + ", Italic";
        }
        this.dialog.getLabelCom().setText(labelComText);
        this.dialog.getButtonAuxiliary().setUI(new UsualColoredButtonUI(this.currentGrammar.aColor, this.currentGrammar.fColor));
        this.dialog.getButtonBackground().setUI(new UsualColoredButtonUI(this.currentGrammar.bColor, this.currentGrammar.fColor));
        this.dialog.getButtonComments().setUI(new UsualColoredButtonUI(this.currentGrammar.cColor, this.currentGrammar.fColor));
        this.dialog.getButtonForeground().setUI(new UsualColoredButtonUI(this.currentGrammar.fColor, this.currentGrammar.bColor));
        this.dialog.getButtonSelection().setUI(new UsualColoredButtonUI(this.currentGrammar.sColor, this.currentGrammar.fColor));
        this.dialog.getButtonVariables().setUI(new UsualColoredButtonUI(this.currentGrammar.vColor != null ? this.currentGrammar.vColor : Color.BLUE, this.currentGrammar.fColor));
    }

    public void apply() {
        this.currentGrammar.dispDate = this.dialog.getCbDate().isSelected();
        this.currentGrammar.dispFrame = this.dialog.getCbFrame().isSelected();
        this.currentGrammar.dispFile = this.dialog.getCbFileName().isSelected();
        this.currentGrammar.dispDir = this.dialog.getCbDirName().isSelected();
        this.currentGrammar.dispAuthor = this.dialog.getCbAuthor().isSelected();
        this.currentGrammar.dispInstitution = this.dialog.getCbInstitution().isSelected();
        this.currentGrammar.dispState = this.dialog.getCbCircleEmptyNodes().isSelected();
        this.currentGrammar.aColor = ((UsualColoredButtonUI)this.dialog.getButtonAuxiliary().getUI()).getBackgroundColor();
        this.currentGrammar.bColor = ((UsualColoredButtonUI)this.dialog.getButtonBackground().getUI()).getBackgroundColor();
        this.currentGrammar.cColor = ((UsualColoredButtonUI)this.dialog.getButtonComments().getUI()).getBackgroundColor();
        this.currentGrammar.fColor = ((UsualColoredButtonUI)this.dialog.getButtonForeground().getUI()).getBackgroundColor();
        this.currentGrammar.sColor = ((UsualColoredButtonUI)this.dialog.getButtonSelection().getUI()).getBackgroundColor();
        this.currentGrammar.vColor = ((UsualColoredButtonUI)this.dialog.getButtonVariables().getUI()).getBackgroundColor();
        String iFontName = this.iFont.getFamily();
        int iFontSize = this.iFont.getSize();
        int iFontStyle = this.iFont.getStyle();
        this.grammarController.iFont = new Font(iFontName, iFontStyle, iFontSize);
        this.currentGrammar.iFontName = iFontName;
        this.currentGrammar.iFontSize = iFontSize;
        this.currentGrammar.iFontStyle = iFontStyle;
        String oFontName = this.oFont.getFamily();
        int oFontSize = this.oFont.getSize();
        int oFontStyle = this.oFont.getStyle();
        this.grammarController.oFont = new Font(oFontName, oFontStyle, oFontSize);
        this.currentGrammar.oFontName = oFontName;
        this.currentGrammar.oFontSize = oFontSize;
        this.currentGrammar.oFontStyle = oFontStyle;
        String cFontName = this.cFont.getFamily();
        int cFontSize = this.cFont.getSize();
        int cFontStyle = this.cFont.getStyle();
        this.grammarController.cFont = new Font(cFontName, cFontStyle, cFontSize);
        this.currentGrammar.cFontName = cFontName;
        this.currentGrammar.cFontSize = cFontSize;
        this.currentGrammar.cFontStyle = cFontStyle;
        this.grammarController.editor.invalidate();
        this.grammarController.editor.validate();
        this.grammarController.editor.repaint();
    }

    public void reset() {
        Font iLauncherFont = Launcher.preferences.IFont;
        this.iFont = new Font(iLauncherFont.getFamily(), iLauncherFont.getStyle(), iLauncherFont.getSize());
        String labelInputText = String.valueOf(this.iFont.getFamily()) + ", " + this.iFont.getSize();
        if (this.iFont.isBold()) {
            labelInputText = String.valueOf(labelInputText) + ", Bold";
        }
        if (this.iFont.isItalic()) {
            labelInputText = String.valueOf(labelInputText) + ", Italic";
        }
        this.dialog.getLabelInput().setText(labelInputText);
        Font oLauncherFont = Launcher.preferences.OFont;
        this.oFont = new Font(oLauncherFont.getFamily(), oLauncherFont.getStyle(), oLauncherFont.getSize());
        String labelOutputText = String.valueOf(this.oFont.getFamily()) + ", " + this.oFont.getSize();
        if (this.oFont.isBold()) {
            labelOutputText = String.valueOf(labelOutputText) + ", Bold";
        }
        if (this.oFont.isItalic()) {
            labelOutputText = String.valueOf(labelOutputText) + ", Italic";
        }
        this.dialog.getLabelOutput().setText(labelOutputText);
        Font cLauncherFont = Launcher.preferences.CFont;
        this.cFont = new Font(cLauncherFont.getFamily(), cLauncherFont.getStyle(), cLauncherFont.getSize());
        String labelComText = String.valueOf(this.cFont.getFamily()) + ", " + this.cFont.getSize();
        if (this.cFont.isBold()) {
            labelComText = String.valueOf(labelComText) + ", Bold";
        }
        if (this.cFont.isItalic()) {
            labelComText = String.valueOf(labelComText) + ", Italic";
        }
        this.dialog.getLabelCom().setText(labelComText);
        ((UsualColoredButtonUI)this.dialog.getButtonAuxiliary().getUI()).setBackgroundColor(Launcher.preferences.AColor);
        ((UsualColoredButtonUI)this.dialog.getButtonBackground().getUI()).setBackgroundColor(Launcher.preferences.BColor);
        ((UsualColoredButtonUI)this.dialog.getButtonComments().getUI()).setBackgroundColor(Launcher.preferences.CColor);
        ((UsualColoredButtonUI)this.dialog.getButtonForeground().getUI()).setBackgroundColor(Launcher.preferences.FColor);
        ((UsualColoredButtonUI)this.dialog.getButtonSelection().getUI()).setBackgroundColor(Launcher.preferences.SColor);
        ((UsualColoredButtonUI)this.dialog.getButtonVariables().getUI()).setBackgroundColor(Launcher.preferences.VColor);
        this.dialog.getCbDate().setSelected(Launcher.preferences.DispDate);
        this.dialog.getCbFrame().setSelected(Launcher.preferences.DispFrame);
        this.dialog.getCbFileName().setSelected(Launcher.preferences.DispFile);
        this.dialog.getCbDirName().setSelected(Launcher.preferences.DispDir);
        this.dialog.getCbAuthor().setSelected(Launcher.preferences.DispAuthor);
        this.dialog.getCbInstitution().setSelected(Launcher.preferences.DispInstitution);
        this.dialog.getCbCircleEmptyNodes().setSelected(Launcher.preferences.DispState);
        this.apply();
    }

    public void setDefault() {
        Font newCPrefFont;
        Font newOPrefFont;
        Font newIPrefFont;
        Preferences pref = Launcher.preferences;
        pref.IFont = newIPrefFont = new Font(this.iFont.getFamily(), this.iFont.getStyle(), this.iFont.getSize());
        pref.OFont = newOPrefFont = new Font(this.oFont.getFamily(), this.oFont.getStyle(), this.oFont.getSize());
        pref.CFont = newCPrefFont = new Font(this.cFont.getFamily(), this.cFont.getStyle(), this.cFont.getSize());
        pref.AColor = ((UsualColoredButtonUI)this.dialog.getButtonAuxiliary().getUI()).getBackgroundColor();
        pref.BColor = ((UsualColoredButtonUI)this.dialog.getButtonBackground().getUI()).getBackgroundColor();
        pref.CColor = ((UsualColoredButtonUI)this.dialog.getButtonComments().getUI()).getBackgroundColor();
        pref.FColor = ((UsualColoredButtonUI)this.dialog.getButtonForeground().getUI()).getBackgroundColor();
        pref.SColor = ((UsualColoredButtonUI)this.dialog.getButtonSelection().getUI()).getBackgroundColor();
        pref.VColor = ((UsualColoredButtonUI)this.dialog.getButtonVariables().getUI()).getBackgroundColor();
        pref.DispDate = this.dialog.getCbDate().isSelected();
        pref.DispFrame = this.dialog.getCbFrame().isSelected();
        pref.DispFile = this.dialog.getCbFileName().isSelected();
        pref.DispDir = this.dialog.getCbDirName().isSelected();
        pref.DispAuthor = this.dialog.getCbAuthor().isSelected();
        pref.DispInstitution = this.dialog.getCbInstitution().isSelected();
        pref.DispState = this.dialog.getCbCircleEmptyNodes().isSelected();
    }

    public void close() {
        this.grammarController.presentationDialog = null;
        this.dialog.dispose();
    }

    public Font getiFont() {
        return this.iFont;
    }

    public Font getoFont() {
        return this.oFont;
    }

    public Font getcFont() {
        return this.cFont;
    }

    public void setiFont(Font iFont) {
        this.iFont = iFont;
    }

    public void setoFont(Font oFont) {
        this.oFont = oFont;
    }

    public void setcFont(Font cFont) {
        this.cFont = cFont;
    }

    public GraphPresentationDialog getDialog() {
        return this.dialog;
    }
}

