/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.HistoryDialog;

import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.dialogs.HistoryDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class HistoryDialogController {
    public HistoryDialog dialog;
    public boolean hack_clearing;
    private GrammarEditorShell formGrammar;

    public HistoryDialogController(HistoryDialog historyDialog) {
        this.dialog = historyDialog;
        if (this.dialog.tv != null) {
            ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).removeAllChildren();
            ((DefaultTreeModel)this.dialog.tv.getModel()).reload();
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("+");
        ((DefaultTreeModel)this.dialog.tv.getModel()).setRoot(top);
    }

    public void updateNewFor(GrammarEditorShell fg) {
        this.formGrammar = fg;
        Graph grf = this.formGrammar.getController().grf;
        if (grf == null) {
            return;
        }
        this.hack_clearing = true;
        if (this.dialog.tv != null) {
            ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).removeAllChildren();
            ((DefaultTreeModel)this.dialog.tv.getModel()).reload();
        }
        this.hack_clearing = false;
        String filename = "";
        if (this.formGrammar.getController().getFullName() != null) {
            filename = FilenameUtils.removeExtension(new File(this.formGrammar.getController().getFullName()).getName());
        }
        this.dialog.setTitle(String.valueOf(filename) + ":" + grf.name);
        if (grf.history != null) {
            int imodifs = 0;
            while (imodifs < grf.history.size()) {
                String modification = (String)grf.history.get(imodifs);
                DefaultMutableTreeNode tnode = new DefaultMutableTreeNode(modification);
                ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).add(tnode);
                imodifs += 2;
            }
        }
        HistoryDialogController.setTreeState(this.dialog.tv, true);
        try {
            this.formGrammar.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        this.formGrammar.invalidate();
        this.formGrammar.repaint();
        this.dialog.setTitle("History of " + filename);
    }

    public void updateCurrentFor(GrammarEditorShell fg) {
        this.formGrammar = fg;
        Graph grf = this.formGrammar.getController().grf;
        int inode = 0;
        while (inode < ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).getChildCount()) {
            int imodif = inode * 2;
            int cfr_ignored_0 = grf.iHistory;
            ++inode;
        }
        try {
            this.formGrammar.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        HistoryDialogController.setTreeState(this.dialog.tv, true);
        this.formGrammar.invalidate();
        this.formGrammar.repaint();
    }

    private static void setTreeState(JTree tree, boolean expanded) {
        Object root = tree.getModel().getRoot();
        HistoryDialogController.setTreeState(tree, new TreePath(root), expanded);
    }

    private static void setTreeState(JTree tree, TreePath path, boolean expanded) {
        Object lastNode = path.getLastPathComponent();
        int i = 0;
        while (i < tree.getModel().getChildCount(lastNode)) {
            Object child = tree.getModel().getChild(lastNode, i);
            TreePath pathToChild = path.pathByAddingChild(child);
            HistoryDialogController.setTreeState(tree, pathToChild, expanded);
            ++i;
        }
        if (expanded) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }
}

