/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.LocateDialog;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.AddActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.Regexps;
import net.nooj4nlp.engine.TheSolutions;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.dialogs.LocateDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import org.apache.commons.io.FilenameUtils;

public class ConcordanceLocateActionListener
implements ActionListener,
PropertyChangeListener {
    private Corpus corpus;
    private String corpusName;
    private String corpusDirPath;
    private String corpusPath;
    private boolean isACorpus;
    private Color currentColor;
    private TextEditorShellController textController;
    private CorpusEditorShellController corpusController;
    private Language myLan;
    private Engine myEngine;
    private Ntext myText;
    private boolean confirmConflict = true;
    private JComboBox regexCombo;
    private JComboBox grammarCombo;
    private JCheckBox cbReset;
    private String grammarComboText;
    private String regexComboText;
    private LocateDialog locateDialog;

    public ConcordanceLocateActionListener(boolean corpus, TextEditorShellController textController, CorpusEditorShellController corpusController, LocateDialog locateDialog) {
        this.isACorpus = corpus;
        this.corpusController = corpusController;
        this.textController = textController;
        this.locateDialog = locateDialog;
        this.regexCombo = this.locateDialog.getNooJRegeXCombo();
        this.grammarCombo = this.locateDialog.getNooJGrammarPathCombo();
        this.cbReset = this.locateDialog.getResetConcordanceCBox();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ConcordanceShellController concordanceController;
        JButton button = (JButton)e.getSource();
        this.currentColor = ((ColoredJButtonUI)button.getUI()).getBackgroundColor();
        if (this.currentColor.equals(Color.GRAY)) {
            this.currentColor = Color.BLACK;
        }
        this.grammarComboText = this.grammarCombo.getSelectedItem().toString();
        this.regexComboText = this.regexCombo.getSelectedItem().toString();
        if (!this.locateDialog.getRbNooJGrammar().isSelected()) {
            List<String> regexList;
            if (this.isACorpus) {
                regexList = this.corpusController.getLocateRegexMemoryList();
                regexList.add(this.regexComboText);
                this.corpusController.setLocateRegexMemoryList(regexList);
            } else {
                regexList = this.textController.getLocateRegexMemoryList();
                regexList.add(this.regexComboText);
                this.textController.setLocateRegexMemoryList(regexList);
            }
            this.regexCombo.addItem(this.regexComboText);
        }
        if (this.isACorpus) {
            ConcordanceShell concordanceShell;
            this.corpus = this.corpusController.getCorpus();
            this.corpusName = this.corpusController.getFullName();
            this.corpusPath = this.corpusController.getFullPath();
            this.corpusDirPath = String.valueOf(this.corpusPath) + "_dir";
            if (this.corpus.annotations == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "You have changed the corpus. Please (re)apply linguistic analysis!", "NooJ: corpus has been edited!", 0);
                return;
            }
            concordanceController = this.corpusController.getConcordanceController();
            if (concordanceController != null) {
                concordanceShell = concordanceController.getConcordanceShell();
                concordanceShell.getCustomForegroundTableRenderer().setSortedPreview(false);
                concordanceShell.getCustomForegroundTableRenderer().setColoredRowsMap(new HashMap<Integer, Color>());
                concordanceShell.dispose();
                concordanceController.setTableModel(null);
                concordanceController = null;
            }
            concordanceShell = new ConcordanceShell(this.corpusController, this.corpusController.getTextController());
            Launcher.getDesktopPane().add(concordanceShell);
            concordanceShell.setVisible(true);
            this.corpusController.setConcordanceController(concordanceShell.getController());
            concordanceController = concordanceShell.getController();
            if (this.cbReset.isSelected()) {
                concordanceController.setTheItems(new ArrayList<Object>());
            }
        } else {
            this.textController.setListOfColors(null);
            this.textController.setAbsoluteBeginAddresses(null);
            this.textController.setAbsoluteEndAddresses(null);
            if (this.textController.isTextWasEdited()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "First (re)apply linguistic resources!", "NooJ: text has been edited!", 0);
                return;
            }
            if (this.textController.getMyText().mft == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "First (re)apply linguistic resources!", "NooJ: no TAS is available for text!", 0);
                return;
            }
            this.myText = this.textController.getMyText();
            concordanceController = this.textController.getConcordanceController();
            if (concordanceController == null) {
                ConcordanceShell concordanceShell = new ConcordanceShell(this.corpusController, this.textController);
                Launcher.getDesktopPane().add(concordanceShell);
                concordanceShell.setVisible(true);
                this.textController.setConcordanceController(concordanceShell.getController());
                concordanceController = concordanceShell.getController();
            } else {
                ConcordanceShell concordanceShell = concordanceController.getConcordanceShell();
                concordanceShell.getCustomForegroundTableRenderer().setSortedPreview(false);
                concordanceShell.getCustomForegroundTableRenderer().setColoredRowsMap(new HashMap<Integer, Color>());
            }
            if (this.cbReset.isSelected()) {
                concordanceController.setTheItems(new ArrayList<Object>());
            }
        }
        this.initializeLaunchLocate(concordanceController);
    }

    private void initializeLaunchLocate(ConcordanceShellController controller) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        if (this.isACorpus) {
            this.corpusController.desactivateOps();
        } else {
            this.textController.desactivateOps();
        }
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Locating pattern...";
        Launcher.getStatusBar().getProgressLabel().setText("Locating pattern...");
        if (Launcher.multithread) {
            Launcher.backgroundWorking = true;
            Launcher.backgroundWorker = this.isACorpus ? new BackgroundWorker("corpus locate", null, this.corpusController, null) : new BackgroundWorker("text locate", this.textController, null, null);
            Launcher.backgroundWorker.addPropertyChangeListener(this);
            Launcher.backgroundWorker.execute();
        } else {
            this.launchLocate();
            if (this.isACorpus) {
                this.corpusController.reactivateOps();
            } else {
                this.textController.reactivateOps();
            }
            controller.refreshConcordance();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
            controller.getConcordanceShell().show();
        }
    }

    public void launchLocate() {
        this.myLan = null;
        this.myEngine = null;
        this.myEngine = this.isACorpus ? this.corpusController.getEngine() : this.textController.getEngine();
        this.myLan = this.myEngine.Lan;
        this.myEngine.backgroundWorker = Launcher.backgroundWorker;
        this.myEngine.BackgroundWorking = Launcher.backgroundWorking;
        if (!this.myEngine.ResourcesLoaded) {
            RefObject<Object> errMessage = new RefObject<Object>(null);
            try {
                int answer;
                if (!this.myEngine.loadResources(Launcher.preferences.ldic.get(this.myLan.isoName), Launcher.preferences.lsyn.get(this.myLan.isoName), true, errMessage) && (answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), String.valueOf((String)errMessage.argvalue) + ". Do you want to proceed anyway?", "NooJ WARNING: ", 0)) == 1) {
                    return;
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, (String)errMessage.argvalue, 1);
                return;
            }
        }
        int limit = -1;
        if (this.locateDialog.getRbOnly().isSelected()) {
            String inputText = this.locateDialog.getTxtNumberOfOccurrences().getText();
            try {
                limit = Integer.valueOf(inputText);
                int length = 0;
                if (this.isACorpus) {
                    this.corpus = this.corpusController.getCorpus();
                    ArrayList<String> listOfTextFiles = this.corpus.listOfFileTexts;
                    int i = 0;
                    while (i < listOfTextFiles.size()) {
                        String filePath = String.valueOf(this.corpusDirPath) + System.getProperty("file.separator") + (String)listOfTextFiles.get(i);
                        File file = new File(filePath);
                        length = (int)((long)length + file.length());
                        ++i;
                    }
                } else {
                    length = this.textController.getTextShell().getTextPane().getText().length();
                }
                if (limit < 1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Input number was outside of range! Please, type a number between 1 and total size of text!", "NooJ error, length of text: " + length, 0);
                    return;
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please, type a valid number!", "NooJ error", 0);
            }
        }
        boolean onlyOneExample = this.locateDialog.getOneOccPerMatchCBox().isSelected();
        char typeOfMatch = this.locateDialog.getRbShortestMatches().isSelected() ? (char)'S' : (this.locateDialog.getRbLongestMatches().isSelected() ? (char)'L' : 'A');
        if (this.locateDialog.getRbStringPattern().isSelected()) {
            this.stringMatch(limit, onlyOneExample, this.currentColor, this.regexComboText);
        } else if (this.locateDialog.getRbPerlPattern().isSelected()) {
            this.perlMatch(limit, onlyOneExample, this.currentColor, this.regexComboText);
        } else if (this.locateDialog.getRbNooJPattern().isSelected()) {
            this.regexpMatch(typeOfMatch, limit, onlyOneExample, this.currentColor, this.regexComboText);
        } else {
            this.grammarMatch(typeOfMatch, limit, onlyOneExample, this.currentColor, this.grammarComboText, this.locateDialog.getSyntacticAnalysisCBox().isSelected());
        }
    }

    private void stringMatch(int limit, boolean onlyOneExample, Color currentColor, String regexComboCurrentText) {
        int absoluteBeginAddress = 0;
        int absoluteEndAddress = 0;
        if (regexComboCurrentText.length() == 0) {
            return;
        }
        int counter = 0;
        if (this.isACorpus) {
            Dic.writeLog("Locating string in corpus " + this.corpusName);
            int itemNb = 0;
            for (String fileName : this.corpus.listOfFileTexts) {
                ++itemNb;
                if (Launcher.multithread) {
                    int nprogress;
                    if (Launcher.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    if (Launcher.processName.substring(0, 6).equals("corpus") && (nprogress = (int)((float)itemNb * 100.0f / (float)this.corpusController.getCorpus().listOfFileTexts.size())) != Launcher.progressPercentage) {
                        Launcher.progressPercentage = nprogress;
                        if (Launcher.backgroundWorker.isBusy()) {
                            Launcher.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                String filePath = String.valueOf(this.corpusDirPath) + System.getProperty("file.separator") + fileName;
                try {
                    this.myText = Ntext.loadForCorpus(filePath, this.corpus.lan, this.corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
                if (this.myText == null) continue;
                Dic.writeLog(" > parsing " + fileName);
                absoluteBeginAddress = this.myText.buffer.indexOf(regexComboCurrentText, 0);
                while (absoluteBeginAddress >= 0) {
                    absoluteEndAddress = absoluteBeginAddress + regexComboCurrentText.length();
                    ConcordanceShellController concordanceController = this.corpusController.getConcordanceController();
                    boolean effectivelyAdded = concordanceController.AddData(this.myText, fileName, currentColor, -1, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "STRING = " + regexComboCurrentText);
                    if (effectivelyAdded) {
                        ++counter;
                    }
                    if (limit != -1 && counter >= limit) break;
                    absoluteBeginAddress = absoluteEndAddress;
                    absoluteBeginAddress = this.myText.buffer.indexOf(regexComboCurrentText, absoluteBeginAddress);
                    if (limit != -1 && counter >= limit) break;
                }
                if (limit == -1 || counter < limit) {
                    continue;
                }
                break;
            }
        } else {
            Dic.writeLog("Locating string in text " + this.textController.getTextName());
            absoluteBeginAddress = this.myText.buffer.indexOf(regexComboCurrentText, 0);
            while (absoluteBeginAddress >= 0) {
                absoluteEndAddress = absoluteBeginAddress + regexComboCurrentText.length();
                ConcordanceShellController concordanceController = this.textController.getConcordanceController();
                boolean effectivelyAdded = concordanceController.AddData(this.myText, "", currentColor, -1, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "STRING = " + regexComboCurrentText);
                if (effectivelyAdded) {
                    ++counter;
                }
                if (limit == -1 || counter < limit) {
                    absoluteBeginAddress = absoluteEndAddress;
                    absoluteBeginAddress = this.myText.buffer.indexOf(regexComboCurrentText, absoluteBeginAddress);
                    continue;
                }
                break;
            }
        }
    }

    private void perlMatch(int limit, boolean onlyOneExample, Color currentColor, String regexComboCurrentText) {
        int absoluteBeginAddress = 0;
        int absoluteEndAddress = 0;
        if (regexComboCurrentText.length() == 0) {
            return;
        }
        Pattern rexp = Pattern.compile(regexComboCurrentText, 8);
        int counter = 0;
        if (this.isACorpus) {
            Dic.writeLog("Applying PERL-type query to corpus " + this.corpusName);
            int itemNb = 0;
            for (String fileName : this.corpus.listOfFileTexts) {
                ++itemNb;
                if (Launcher.multithread) {
                    int nprogress;
                    if (Launcher.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    if (Launcher.processName.substring(0, 6).equals("corpus") && (nprogress = (int)((float)itemNb * 100.0f / (float)this.corpusController.getCorpus().listOfFileTexts.size())) != Launcher.progressPercentage) {
                        Launcher.progressPercentage = nprogress;
                        if (Launcher.backgroundWorker.isBusy()) {
                            Launcher.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                String filePath = String.valueOf(this.corpusDirPath) + System.getProperty("file.separator") + fileName;
                try {
                    this.myText = Ntext.loadForCorpus(filePath, this.corpus.lan, this.corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
                if (this.myText == null) continue;
                Dic.writeLog(" > parsing " + fileName);
                absoluteBeginAddress = this.myText.buffer.indexOf(regexComboCurrentText, 0);
                Matcher mc = rexp.matcher(this.myText.buffer);
                while (mc.find()) {
                    absoluteBeginAddress = mc.start();
                    absoluteEndAddress = mc.end();
                    ConcordanceShellController concordanceController = this.corpusController.getConcordanceController();
                    boolean effectivelyAdded = concordanceController.AddData(this.myText, fileName, currentColor, -1, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "PERL RE = " + regexComboCurrentText);
                    if (effectivelyAdded) {
                        ++counter;
                    }
                    if (limit != -1 && counter >= limit) break;
                }
                if (limit == -1 || counter < limit) {
                    continue;
                }
                break;
            }
        } else {
            Dic.writeLog("Applying PERL-type query to text " + this.textController.getTextName());
            Matcher mc = rexp.matcher(this.myText.buffer);
            while (mc.find()) {
                absoluteBeginAddress = mc.start();
                absoluteEndAddress = mc.end();
                ConcordanceShellController concordanceController = this.textController.getConcordanceController();
                boolean effectivelyAdded = concordanceController.AddData(this.myText, "", currentColor, -1, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "PERL RE = " + regexComboCurrentText);
                if (effectivelyAdded) {
                    ++counter;
                }
                if (limit == -1 || counter < limit) {
                    continue;
                }
                break;
            }
        }
    }

    private void regexpMatch(char typeOfMatch, int limit, boolean onlyOneExample, Color currentColor, String regexComboCurrentText) {
        block33: {
            Regexps regexps;
            int counter;
            block34: {
                counter = 0;
                try {
                    Regexp regexp = new Regexp(this.myLan, regexComboCurrentText, GramType.SYNTAX);
                    regexp.Grm.prepareForParsing();
                    regexps = new Regexps(this.myLan, GramType.SYNTAX, regexp.Grm, this.myEngine);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Invalid regular expression!", "NooJ", 0);
                    return;
                }
                if (!this.isACorpus) break block34;
                Dic.writeLog("Applying regular expression to corpus " + this.corpusName);
                int itemNb = 0;
                for (String fileName : this.corpus.listOfFileTexts) {
                    ++itemNb;
                    if (Launcher.multithread) {
                        int nprogress;
                        if (Launcher.backgroundWorker.isCancellationPending()) {
                            return;
                        }
                        if (Launcher.processName.substring(0, 6).equals("corpus") && (nprogress = (int)((float)itemNb * 100.0f / (float)this.corpusController.getCorpus().listOfFileTexts.size())) != Launcher.progressPercentage) {
                            Launcher.progressPercentage = nprogress;
                            if (Launcher.backgroundWorker.isBusy()) {
                                Launcher.backgroundWorker.reportProgress(nprogress);
                            }
                        }
                    }
                    String filePath = String.valueOf(this.corpusDirPath) + System.getProperty("file.separator") + fileName;
                    try {
                        this.myText = Ntext.loadForCorpus(filePath, this.corpus.lan, this.corpus.multiplier);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                        return;
                    }
                    if (this.myText == null) continue;
                    Dic.writeLog(" > parsing " + fileName);
                    if (this.myText.mft == null) {
                        Dic.writeLog(" ! no linguistic data available for text " + fileName);
                        continue;
                    }
                    TheSolutions solutions = null;
                    boolean thereIsUnAmbiguity = false;
                    String errorMessage = "";
                    if (onlyOneExample) {
                        try {
                            solutions = this.myEngine.syntacticParsing(this.corpus, this.myText, this.corpus.annotations, regexps.grammar, typeOfMatch, -1, false, false, new RefObject<Boolean>(thereIsUnAmbiguity), new RefObject<String>(errorMessage));
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
                            return;
                        }
                        catch (ClassNotFoundException e) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, e.getMessage(), 1);
                            return;
                        }
                    }
                    try {
                        solutions = this.myEngine.syntacticParsing(this.corpus, this.myText, this.corpus.annotations, regexps.grammar, typeOfMatch, limit, false, false, new RefObject<Boolean>(thereIsUnAmbiguity), new RefObject<String>(errorMessage));
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
                        return;
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, e.getMessage(), 1);
                        return;
                    }
                    if (!errorMessage.equals("")) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                        return;
                    }
                    if (solutions == null || solutions != null && solutions.list.size() == 0) continue;
                    int sizeOfSolutionsList = solutions.list.size();
                    int isol = 0;
                    while (isol < sizeOfSolutionsList) {
                        int tuNb = solutions.getTuNb(isol);
                        double absoluteBeginAddress = solutions.getBegAddress(isol) + (double)this.myText.mft.tuAddresses[tuNb];
                        double absoluteEndAddress = absoluteBeginAddress + solutions.getLength(isol);
                        ArrayList<Double> relAddresses = solutions.getInput(isol);
                        ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, this.myText.mft.tuAddresses[tuNb]);
                        ArrayList<String> output = solutions.getOutput(isol);
                        ArrayList<Object> seqOfAnnotations = this.myEngine.mergeIntoAnnotations(this.myText.buffer, tuNb, absoluteBeginAddress, absoluteEndAddress, absAddresses, output, false);
                        boolean effectivelyAdded = false;
                        ConcordanceShellController concordanceController = this.corpusController.getConcordanceController();
                        effectivelyAdded = seqOfAnnotations == null ? concordanceController.AddData(this.myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "RE = " + regexComboCurrentText) : concordanceController.AddData(this.myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, onlyOneExample, "RE = " + regexComboCurrentText);
                        if (effectivelyAdded) {
                            ++counter;
                        }
                        if (limit != -1 && counter >= limit) break;
                        ++isol;
                    }
                    if (limit == -1 || counter < limit) {
                        continue;
                    }
                    break block33;
                }
                break block33;
            }
            if (this.myText == null || this.myText.buffer == null || this.myText.mft == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please (re)apply linguistic resources!", "NooJ: file .jnot corrupted", 0);
                return;
            }
            Dic.writeLog("Applying regular expression to text " + this.textController.getTextName());
            TheSolutions solutions = null;
            boolean thereIsUnAmbiguity = false;
            String errorMessage = "";
            if (onlyOneExample) {
                try {
                    solutions = this.myEngine.syntacticParsing(null, this.myText, this.myText.annotations, regexps.grammar, typeOfMatch, -1, false, false, new RefObject<Boolean>(thereIsUnAmbiguity), new RefObject<String>(errorMessage));
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, e.getMessage(), 1);
                    return;
                }
            }
            try {
                solutions = this.myEngine.syntacticParsing(null, this.myText, this.myText.annotations, regexps.grammar, typeOfMatch, limit, false, false, new RefObject<Boolean>(thereIsUnAmbiguity), new RefObject<String>(errorMessage));
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, e.getMessage(), 1);
                return;
            }
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                return;
            }
            int sizeOfSolutionsList = solutions.list.size();
            if (solutions == null || sizeOfSolutionsList <= 0) break block33;
            int isol = 0;
            while (isol < sizeOfSolutionsList) {
                int tuNb = solutions.getTuNb(isol);
                double absoluteBeginAddress = solutions.getBegAddress(isol) + (double)this.myText.mft.tuAddresses[tuNb];
                double absoluteEndAddress = absoluteBeginAddress + solutions.getLength(isol);
                ArrayList<Double> relAddresses = solutions.getInput(isol);
                ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, this.myText.mft.tuAddresses[tuNb]);
                ArrayList<String> output = solutions.getOutput(isol);
                ArrayList<Object> seqOfAnnotations = this.myEngine.mergeIntoAnnotations(this.myText.buffer, tuNb, absoluteBeginAddress, absoluteEndAddress, absAddresses, output, false);
                boolean effectivelyAdded = false;
                ConcordanceShellController concordanceController = this.textController.getConcordanceController();
                effectivelyAdded = seqOfAnnotations == null ? concordanceController.AddData(this.myText, "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "RE = " + regexComboCurrentText) : concordanceController.AddData(this.myText, "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, onlyOneExample, "RE = " + regexComboCurrentText);
                if (effectivelyAdded) {
                    ++counter;
                }
                if (limit == -1 || counter < limit) {
                    ++isol;
                    continue;
                }
                break;
            }
        }
    }

    private void grammarMatch(char typeOfMatch, int limit, boolean onlyOneExample, Color currentColor, String selectedGrammar, boolean isSyntacticAnalysisCBSelected) {
        String errorMessage = null;
        File grammarFile = new File(selectedGrammar);
        if (!grammarFile.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file ", "NooJ: Cannot find grammar!", 0);
            errorMessage = "Grammar file " + selectedGrammar + " does not exists!";
            Dic.writeLog(errorMessage);
            return;
        }
        String grammarFileName = grammarFile.getName();
        Dic.writeLog("Compiling grammar...");
        Launcher.progressMessage = "Compiling grammar...";
        Grammar grammar = null;
        boolean isTextual = Grammar.isItTextual(selectedGrammar);
        if (isTextual) {
            RefObject<String> errorRef = new RefObject<String>(errorMessage);
            grammar = Grammar.loadTextual(selectedGrammar, GramType.SYNTAX, errorRef);
            errorMessage = (String)errorRef.argvalue;
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Problem in grammar " + grammarFileName + ":\n" + errorMessage, "NooJ: Cannot handle grammar!", 0);
                return;
            }
        } else {
            grammar = Grammar.loadONooJGrammar(selectedGrammar);
        }
        if (grammar == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load grammar " + grammarFileName, "NooJ: Problem with grammar!", 0);
            return;
        }
        errorMessage = grammar.compileAll(this.myEngine);
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ: Problem with grammar!", 0);
            return;
        }
        String languageName = grammar.iLanguage;
        if (!this.myLan.isoName.equals(languageName)) {
            int optionType = 2;
            int messageType = 2;
            JButton ok = new JButton("OK");
            final JButton cancel = new JButton("Cancel");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConcordanceLocateActionListener.this.confirmConflict = true;
                }
            });
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConcordanceLocateActionListener.this.confirmConflict = false;
                    AddActionListener.closeDialogWindow(cancel);
                }
            });
            Object[] selValues = new Object[]{ok, cancel};
            JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Grammar's input language differs from text language. Continue anyway?", "NooJ: Language inconsistency", optionType, messageType, null, selValues, selValues[0]);
            if (!this.confirmConflict) {
                return;
            }
        }
        Launcher.progressMessage = "Applying grammar...";
        int counter = 0;
        if (this.isACorpus) {
            Dic.writeLog("Applying grammar to corpus " + this.corpusName);
            int itemNb = 0;
            for (String fileName : this.corpus.listOfFileTexts) {
                ++itemNb;
                if (Launcher.multithread) {
                    if (Launcher.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    if (Launcher.processName.substring(0, 6).equals("corpus")) {
                        Launcher.progressMessage = "Applying grammar (" + counter + ")...";
                        int nprogress = (int)((float)itemNb * 100.0f / (float)this.corpusController.getCorpus().listOfFileTexts.size());
                        if (nprogress != Launcher.progressPercentage) {
                            Launcher.progressPercentage = nprogress;
                            if (Launcher.backgroundWorker.isBusy()) {
                                Launcher.backgroundWorker.reportProgress(nprogress);
                            }
                        }
                    }
                }
                String filePath = String.valueOf(this.corpusDirPath) + System.getProperty("file.separator") + fileName;
                try {
                    this.myText = Ntext.loadForCorpus(filePath, this.corpus.lan, this.corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text for corpus!", 0);
                    return;
                }
                if (this.myText == null) continue;
                Dic.writeLog(" > parsing " + fileName);
                if (this.myText.mft == null) {
                    Dic.writeLog(" ! no linguistic data available for " + fileName);
                    return;
                }
                TheSolutions solutions = null;
                boolean thereIsUnAmbiguity = false;
                RefObject<String> errmessageRef = new RefObject<String>(errorMessage);
                if (onlyOneExample) {
                    try {
                        solutions = this.myEngine.syntacticParsing(this.corpus, this.myText, this.corpus.annotations, grammar, typeOfMatch, -1, isSyntacticAnalysisCBSelected, true, new RefObject<Boolean>(thereIsUnAmbiguity), errmessageRef);
                        errorMessage = (String)errmessageRef.argvalue;
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (there is no class)!", 0);
                        return;
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (input-output error)!", 0);
                        return;
                    }
                }
                try {
                    solutions = this.myEngine.syntacticParsing(this.corpus, this.myText, this.corpus.annotations, grammar, typeOfMatch, limit, isSyntacticAnalysisCBSelected, true, new RefObject<Boolean>(thereIsUnAmbiguity), errmessageRef);
                    errorMessage = (String)errmessageRef.argvalue;
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (there is no class)!", 0);
                    return;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (input-output error)!", 0);
                    return;
                }
                if (errorMessage != null && solutions == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                    return;
                }
                int sizeOfSolutionsList = solutions.list.size();
                if (solutions == null || sizeOfSolutionsList == 0) continue;
                int isol = 0;
                while (isol < sizeOfSolutionsList) {
                    int tuNb = solutions.getTuNb(isol);
                    double absoluteBeginAddress = solutions.getBegAddress(isol) + (double)this.myText.mft.tuAddresses[tuNb];
                    double absoluteEndAddress = absoluteBeginAddress + solutions.getLength(isol);
                    ArrayList<Double> relAddresses = solutions.getInput(isol);
                    ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, this.myText.mft.tuAddresses[tuNb]);
                    ArrayList<String> output = solutions.getOutput(isol);
                    ArrayList<Object> seqOfAnnotations = this.myEngine.mergeIntoAnnotations(this.myText.buffer, tuNb, absoluteBeginAddress, absoluteEndAddress, absAddresses, output, isSyntacticAnalysisCBSelected);
                    boolean effectivelyAdded = false;
                    ConcordanceShellController concordanceController = this.corpusController.getConcordanceController();
                    effectivelyAdded = seqOfAnnotations == null ? concordanceController.AddData(this.myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "GRAM = " + FilenameUtils.removeExtension(selectedGrammar)) : concordanceController.AddData(this.myText, fileName, currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, onlyOneExample, "GRAM = " + FilenameUtils.removeExtension(selectedGrammar));
                    if (effectivelyAdded) {
                        ++counter;
                    }
                    if (limit != -1 && counter >= limit) break;
                    ++isol;
                }
                if (limit == -1 || counter < limit) {
                    continue;
                }
                break;
            }
        } else {
            int sizeOfSolutionsList;
            Dic.writeLog("Applying regular expression to text " + this.textController.getTextName());
            if (this.myText == null || this.myText.buffer == null || this.myText.mft == null) {
                Dic.writeLog(" error.");
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please (re)apply linguistic resources!", "NooJ: file .jnot corrupted", 0);
                return;
            }
            TheSolutions solutions = null;
            boolean thereIsUnAmbiguity = false;
            RefObject<String> errmessageRef = new RefObject<String>(errorMessage);
            if (onlyOneExample) {
                try {
                    solutions = this.myEngine.syntacticParsing(null, this.myText, this.myText.annotations, grammar, typeOfMatch, -1, isSyntacticAnalysisCBSelected, true, new RefObject<Boolean>(thereIsUnAmbiguity), errmessageRef);
                    errorMessage = (String)errmessageRef.argvalue;
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (there is no class)!", 0);
                    return;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (input-output error)!", 0);
                    return;
                }
            }
            try {
                solutions = this.myEngine.syntacticParsing(null, this.myText, this.myText.annotations, grammar, typeOfMatch, limit, isSyntacticAnalysisCBSelected, true, new RefObject<Boolean>(thereIsUnAmbiguity), errmessageRef);
                errorMessage = (String)errmessageRef.argvalue;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (there is no class)!", 0);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while doing new syntactic parsing (input-output error)!", 0);
                return;
            }
            if (errorMessage != null && solutions == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                return;
            }
            int n = sizeOfSolutionsList = solutions != null ? solutions.list.size() : 0;
            if (solutions != null && sizeOfSolutionsList > 0) {
                int isol = 0;
                while (isol < sizeOfSolutionsList) {
                    int tuNb = solutions.getTuNb(isol);
                    double absoluteBeginAddress = solutions.getBegAddress(isol) + (double)this.myText.mft.tuAddresses[tuNb];
                    double absoluteEndAddress = absoluteBeginAddress + solutions.getLength(isol);
                    ArrayList<Double> relAddresses = solutions.getInput(isol);
                    ArrayList<Double> absAddresses = Engine.rel2Abs(relAddresses, this.myText.mft.tuAddresses[tuNb]);
                    ArrayList<String> output = solutions.getOutput(isol);
                    ArrayList<Object> seqOfAnnotations = this.myEngine.mergeIntoAnnotations(this.myText.buffer, tuNb, absoluteBeginAddress, absoluteEndAddress, absAddresses, output, isSyntacticAnalysisCBSelected);
                    boolean effectivelyAdded = false;
                    ConcordanceShellController concordanceController = this.textController.getConcordanceController();
                    effectivelyAdded = seqOfAnnotations == null ? concordanceController.AddData(this.myText, "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, null, onlyOneExample, "GRAM = " + FilenameUtils.removeExtension(selectedGrammar)) : concordanceController.AddData(this.myText, "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, onlyOneExample, "GRAM = " + FilenameUtils.removeExtension(selectedGrammar));
                    if (effectivelyAdded) {
                        ++counter;
                    }
                    if (limit == -1 || counter < limit) {
                        ++isol;
                        continue;
                    }
                    break;
                }
            } else {
                if (solutions == null || sizeOfSolutionsList == 0) {
                    return;
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Syntactic Parsing Error", 0);
                return;
            }
        }
    }
}

