/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.MorphologyDialog;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultListModel;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.RefObject;

public class AnimationTask
extends TimerTask {
    private DefaultListModel resultModel;
    private String word;
    private String command;
    private int icommand;
    private Language lan;
    private Timer timer;

    public AnimationTask(DefaultListModel resultModel, String word, String command, int icommand, Language lan, Timer timer) {
        this.resultModel = resultModel;
        this.word = word;
        this.command = command;
        this.icommand = icommand;
        this.lan = lan;
        this.timer = timer;
    }

    @Override
    public void run() {
        String com = this.command.substring(0, this.icommand);
        int pos = 0;
        RefObject<Integer> posRef = new RefObject<Integer>(pos);
        String result = Gram.processInflection(this.lan, this.word, com, posRef);
        pos = (Integer)posRef.argvalue;
        int index = result.indexOf(60);
        this.resultModel.removeAllElements();
        this.resultModel.addElement(String.valueOf(result.substring(0, pos)) + "\u2502" + result.substring(pos) + " " + this.command.substring(this.icommand));
        if (index != -1) {
            this.timer.cancel();
        } else {
            if (this.icommand < this.command.length() && this.command.charAt(this.icommand) == '<') {
                ++this.icommand;
                while (this.icommand < this.command.length() && this.command.charAt(this.icommand) != '>') {
                    ++this.icommand;
                }
            } else if (this.icommand < this.command.length() && this.command.charAt(this.icommand) == '\"') {
                ++this.icommand;
                while (this.icommand < this.command.length() && this.command.charAt(this.icommand) != '\"') {
                    ++this.icommand;
                }
            } else if (this.icommand < this.command.length() && this.command.charAt(this.icommand) == '\\') {
                ++this.icommand;
            }
            ++this.icommand;
            if (this.icommand > this.command.length()) {
                this.timer.cancel();
            }
        }
    }
}

