/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.MorphologyDialog;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.nooj4nlp.engine.Language;

public class ListListener
implements ListSelectionListener {
    private JList listLanguage;
    private JComboBox comboWordRoot;
    private JComboBox comboCommandSuffix;
    private JComboBox comboLemma;
    private JComboBox comboExpression;
    private JComboBox comboLookup;
    private JLabel lblLanguage;

    public ListListener(JList listLanguage, JComboBox comboWordRoot, JComboBox comboCommandSuffix, JComboBox comboLemma, JComboBox comboExpression, JComboBox comboLookup, JLabel lblLanguage) {
        this.listLanguage = listLanguage;
        this.comboWordRoot = comboWordRoot;
        this.comboCommandSuffix = comboCommandSuffix;
        this.comboLemma = comboLemma;
        this.comboExpression = comboExpression;
        this.comboLookup = comboLookup;
        this.lblLanguage = lblLanguage;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        Language lan = new Language((String)this.listLanguage.getSelectedValue());
        this.UpdateExamplesForLan(lan);
    }

    private void UpdateExamplesForLan(Language lan) {
        this.lblLanguage.setText("<html>" + lan.natName + " / " + lan.engName + "</html>");
        if (lan.isoName.equals("la")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] artista");
            this.comboWordRoot.addItem("[2] amo");
            this.comboWordRoot.addItem("[3] cado");
            this.comboWordRoot.addItem("[4] altus");
            this.comboWordRoot.addItem("[5] is");
            this.comboWordRoot.addItem("[6] res publica");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] rum");
            this.comboCommandSuffix.addItem("[2] <B>amus");
            this.comboCommandSuffix.addItem("[3] <B>unt");
            this.comboCommandSuffix.addItem("[4] <B2>ior");
            this.comboCommandSuffix.addItem("[5] <L>u<L2>e");
            this.comboCommandSuffix.addItem("[6] rum<P><B>rum");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] artista");
            this.comboLemma.addItem("[2] amo");
            this.comboLemma.addItem("[3] cado");
            this.comboLemma.addItem("[4] altus");
            this.comboLemma.addItem("[5] is");
            this.comboLemma.addItem("[6] res publica");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/nom+s | <E>/voc+s | m/ac+s | e/gen+s | e/dat+s | <E>/ab+s");
            this.comboExpression.addItem("[2] <B>amus/Act+1+p+Pres+Ind | <B>atis/Act+2+p+Pres+Ind | <B>ant/Act+3+p+Pres+Ind");
            this.comboExpression.addItem("[3] <E>/Act+1+s+Pres+Ind | <B>is/Act+2+s+Pres+Ind | <B>it/Act+3+s+Pres+Ind");
            this.comboExpression.addItem("[4] <B2>iores/comp+nom+p+m | <B2>iores/comp+voc+p+m | <B2>iores/comp+ac+p+m");
            this.comboExpression.addItem("[5] <E>/nom+m+s | <B>i/nom+m+p | <L>u<L2>e/gen+m+s | <B2>eorum/gen+m+p | <B2>eum/ac+m+s | <B2>eos/ac+m+p");
            this.comboExpression.addItem("[6] <E>/nom+s | e/nom+p | e<P><B>i/gen+s | rum<P><B>rum/gen+p | m<P><B>m/ac+s | s/ac+s");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("artista");
            this.comboLookup.addItem("amo");
            this.comboLookup.addItem("cado");
            this.comboLookup.addItem("altus");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("it")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] uomo");
            this.comboWordRoot.addItem("[2] arma");
            this.comboWordRoot.addItem("[3] re");
            this.comboWordRoot.addItem("[4] avere");
            this.comboWordRoot.addItem("[5] rompere");
            this.comboWordRoot.addItem("[6] mostro sacro");
            this.comboWordRoot.addItem("[7] tavola rotonda");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] <B>ini");
            this.comboCommandSuffix.addItem("[2] <B>i");
            this.comboCommandSuffix.addItem("[3] gina");
            this.comboCommandSuffix.addItem("[4] <BW>hanno");
            this.comboCommandSuffix.addItem("[5] <B6>uppi");
            this.comboCommandSuffix.addItem("[6] <B>i<P><B>i");
            this.comboCommandSuffix.addItem("[7] <B>e<P><B>e");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] artista");
            this.comboLemma.addItem("[2] amare");
            this.comboLemma.addItem("[3] cadere");
            this.comboLemma.addItem("[4] andare");
            this.comboLemma.addItem("[5] compagno di strada");
            this.comboLemma.addItem("[6] foglio rosa");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/m+s | <E>/f+s | <B>i/m+p | <B>e/f+p");
            this.comboExpression.addItem("[2] <B3>o/Pr+1+s | <B3>i/Pr+2+s | <B2>/Pr+3+s | <B3>iamo/Pr+1+p | <B2>te/Pr+2+p | <B2>no/Pr+3+p");
            this.comboExpression.addItem("[3] <B3><D>i/Pass+1+s | <B2>sti/Pass+2+s | <B3><D>e/Pass+3+s | <B2>mmo/Pass+1+p | <B2>ste/Pass+2+p | <B3><D>ero/Pass+3+p");
            this.comboExpression.addItem("[4] <BW>vado/Pr+1+s | <BW>vai/Pr+2+s | <BW>va/Pr+3+s |  <B3>iamo/Pr+1+p | <B2>te/Pr+2+p | <BW>vanno/Pr+3+p");
            this.comboExpression.addItem("[5] <E>/m+s | <P2><B>a/f+s | <P2><B>e/f+p | <P2><B>i/m+p");
            this.comboExpression.addItem("[6] <E>/m+s  |  <P><B>/m+p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
        } else if (lan.isoName.equals("fr") || lan.isoName.equals("ac")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] cousin");
            this.comboWordRoot.addItem("[2] cheval");
            this.comboWordRoot.addItem("[3] recordman");
            this.comboWordRoot.addItem("[4] avoir");
            this.comboWordRoot.addItem("[5] lever");
            this.comboWordRoot.addItem("[5] mener");
            this.comboWordRoot.addItem("[6] cousin germain");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] es");
            this.comboCommandSuffix.addItem("[2] <B>ux");
            this.comboCommandSuffix.addItem("[3] <B3>women");
            this.comboCommandSuffix.addItem("[4] <BW>ont");
            this.comboCommandSuffix.addItem("[5] <B><L2><B>\u00e8<RW>nt");
            this.comboCommandSuffix.addItem("[6] es<P>es<NW>");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] artiste");
            this.comboLemma.addItem("[2] aimer");
            this.comboLemma.addItem("[3] appeler");
            this.comboLemma.addItem("[3] jeter");
            this.comboLemma.addItem("[4] cousin germain");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/m+s | <E>/f+s | s/m+p | s/f+p");
            this.comboExpression.addItem("[2] <B>/PR+1+s | <B>s/PR+2+s | <B>/PR+3+s | <B2>ons/PR+1+p | <B>z/PR+2+p | <B>nt/PR+3+p");
            this.comboExpression.addItem("[3] <B2><D>e/PR+1+s | <B2><D>es/PR+2+s | <B2><D>e/PR+3+s + <B2>ons/PR+1+p | <B>z/PR+2+p | <B2><D>ent/PR+3+p");
            this.comboExpression.addItem("[4] <E>/m+s | e<P>e/f+s | s<P>s/m+p | es<P>es/f+p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("aimer");
            this.comboLookup.addItem("avoir");
            this.comboLookup.addItem("cousin");
            this.comboLookup.addItem("mangerions");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("hy")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] \u057f\u0561\u0580\u056b");
            this.comboWordRoot.addItem("[2] \u057d\u056b\u0580\u0565\u056c");
            this.comboWordRoot.addItem("[3] \u0584\u0578\u0575\u0580");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] \u0576\u0565\u0580");
            this.comboCommandSuffix.addItem("[2] <B>\u0581\u056b");
            this.comboCommandSuffix.addItem("[3] <L><B2><R>\u0578\u057b");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] \u056d\u0561\u0572\u0561\u056c");
            this.comboLemma.addItem("[2] \u0578\u0582\u057f\u0565\u056c");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <B>\u0574/PR+s+1 | <B>\u057d/PR+s+2 | <B>\u0575/PR+s+3");
            this.comboExpression.addItem("[2] <BW>\u056f\u0565\u0580\u0561\u0575/Aor+1+s | <BW>\u056f\u0565\u0580\u0561\u0580/Aor+2+s | <BW>\u056f\u0565\u0580\u0561\u0582/Aor+3+s");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("\u056d\u0561\u0572\u0561\u056c");
            this.comboLookup.addItem("\u0578\u0582\u057f\u0565\u056c");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("ca")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] peu");
            this.comboWordRoot.addItem("[2] dia");
            this.comboWordRoot.addItem("[3] bacall\u00e0");
            this.comboWordRoot.addItem("[4] ve\u00ed");
            this.comboWordRoot.addItem("[5] arr\u00f2s");
            this.comboWordRoot.addItem("[6] professor associat");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] s");
            this.comboCommandSuffix.addItem("[2] <B>es");
            this.comboCommandSuffix.addItem("[3] <A>ns");
            this.comboCommandSuffix.addItem("[4] <B>\u00efns");
            this.comboCommandSuffix.addItem("[5] <L><A><R><D>os");
            this.comboCommandSuffix.addItem("[6] <B>des<P>es");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] tebi");
            this.comboLemma.addItem("[2] ser");
            this.comboLemma.addItem("[3] estimar");
            this.comboLemma.addItem("[4] professor associat");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/m+s | a<L3><\u00c0>/f+s | s/m+p | es<L4><\u00c0>/f+p");
            this.comboExpression.addItem("[2] <B2>\u00f3c/PR+1+s | <BW>ets/PR+2+s | <BW>\u00e9s/PR+3+s");
            this.comboExpression.addItem("[3] <B2>o/PR+1+s | <B2>es/PR+2+s | <B>/PR+3+s | <B2>em/PR+1+p | <B2>eu/PR+2+p | <B2>en/PR+3+p");
            this.comboExpression.addItem("[4] <E>/m+s | <B>da<P>a/f+s | s<P>s/m+p | <B>des<P>es/f+p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("cantar");
            this.comboLookup.addItem("bacall\u00e0");
            this.comboLookup.addItem("arr\u00f2s");
            this.comboLookup.addItem("professor associat");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("sp")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] libro");
            this.comboWordRoot.addItem("[2] curriculum");
            this.comboWordRoot.addItem("[3] avi\u00f3n");
            this.comboWordRoot.addItem("[4] tener");
            this.comboWordRoot.addItem("[5] hombre rana");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] s");
            this.comboCommandSuffix.addItem("[2] <B2>a");
            this.comboCommandSuffix.addItem("[3] <L><A><R>es");
            this.comboCommandSuffix.addItem("[4] <B4>ienen");
            this.comboCommandSuffix.addItem("[5] s<P>s");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] ser");
            this.comboLemma.addItem("[2] conducir");
            this.comboLemma.addItem("[3] crimen");
            this.comboLemma.addItem("[3] joven");
            this.comboLemma.addItem("[4] profesor asociado");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <B2>oy/Pr+1+s | <BW>eres/Pr+2+s | <BW>es/Pr+3+s");
            this.comboExpression.addItem("[2] <B3>zco/Pr+1+s | <B2>es/Pr+2+s | <B2>e/Pr+3+s | <B>mos/Pr+1+p");
            this.comboExpression.addItem("[3] es<L5><\u00c1>/m+p");
            this.comboExpression.addItem("[4] <E>/m+s | s<P>es/m+p | <B>a<P>a/f+s | <B>as<P>as/f+p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("cantar");
            this.comboLookup.addItem("profesor");
            this.comboLookup.addItem("profesor asociado");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("ro")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] copac");
            this.comboWordRoot.addItem("[2] fiu");
            this.comboWordRoot.addItem("[3] amend\u0103");
            this.comboWordRoot.addItem("[4] astru");
            this.comboWordRoot.addItem("[5] floare-de-nu-m\u0103-uita");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] i");
            this.comboCommandSuffix.addItem("[2] <B>i");
            this.comboCommandSuffix.addItem("[3] <B2>zi");
            this.comboCommandSuffix.addItem("[4] <B>i<L3><B>\u015f");
            this.comboCommandSuffix.addItem("[5] <PW><B><L><B><R>i");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] c\u00e2nta");
            this.comboLemma.addItem("[2] doctor");
            this.comboLemma.addItem("[3] avea");
            this.comboLemma.addItem("[4] profesor asociat");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <B>/Pr+1+s | <B2>\u0163i/Pr+2+s | <B>\u0103/Pr+3+s");
            this.comboExpression.addItem("[2] <E>/m+s | i\u0163\u0103/f+s | i/m+p | i\u0163e/f+p");
            this.comboExpression.addItem("[3] <B3> (m/Pr+1+s | i/Pr+2+s | re/Pr+3+s) | <B>m/Pr+1+p | <B>\u0163i/Pr+2+p | <B3>u/Pr+3+p");
            this.comboExpression.addItem("[4] <E>/m+s | \u0103<P><L>a<R>\u0103/f+s | <B>\u0163i<P>i/m+p | e<P><L>a<R>e/f+p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("c\u00e2nta");
            this.comboLookup.addItem("avea");
            this.comboLookup.addItem("profesor asociat");
            this.comboLookup.setSelectedIndex(-1);
        } else if (lan.isoName.equals("bg")) {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] \u0431\u043e\u0440");
            this.comboWordRoot.addItem("[2] \u0436\u0435\u043d\u0430");
            this.comboWordRoot.addItem("[3] \u0441\u044a\u043c");
            this.comboWordRoot.addItem("[4] \u0432\u0440\u044a\u0445");
            this.comboWordRoot.addItem("[5] \u0437\u0432\u044a\u043d\u0435\u0446");
            this.comboWordRoot.addItem("[6] \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0430 \u0441\u0435\u0441\u0442\u0440\u0430");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] \u043e\u0432\u0435");
            this.comboCommandSuffix.addItem("[2] <B>\u0438");
            this.comboCommandSuffix.addItem("[3] <BW>\u0431\u044f\u0445");
            this.comboCommandSuffix.addItem("[4] <L3>\u044a<R><S><R>\u044a\u0442");
            this.comboCommandSuffix.addItem("[5] <L><B><R1>\u0438");
            this.comboCommandSuffix.addItem("[6] <P>\u0442\u0430");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] \u0411\u043e\u0440");
            this.comboLemma.addItem("[2] \u043c\u0438\u043d\u0438\u0441\u0442\u044a\u0440");
            this.comboLemma.addItem("[3] \u0432\u0440\u044a\u0445");
            this.comboLemma.addItem("[4] \u0441\u0432\u044f\u0442");
            this.comboLemma.addItem("[5] \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0430 \u0441\u0435\u0441\u0442\u0440\u0430");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/s+0 | \u044a\u0442/s+l | \u0430/s+h | \u0430/s+c | \u043e\u0432\u0435/pl+0 | \u043e\u0432\u0435\u0442\u0435/pl+d");
            this.comboExpression.addItem("[2] <E>/s+0 | \u044a\u0442/s+l | \u0430/s+h + <L><B><R> (\u0438/pl+0 | \u0438\u0442\u0435/pl+d + \u0435/v)");
            this.comboExpression.addItem("[3] <E>/s+0 | <L3>\u044a<R><S><R> (\u044a\u0442/s+l | \u0430/s+h + \u0430/c | \u043e\u0432\u0435/pl+0 | \u043e\u0432\u0435\u0442\u0435/pl+d)");
            this.comboExpression.addItem("[4] <E>/s+0 |  a/c   + <L><B>\u0435<R> (\u044a\u0442/s+l | \u0430/s+h  | \u043e\u0432\u0435/pl+0  | \u043e\u0432\u0435\u0442\u0435/pl+d)");
            this.comboExpression.addItem("[5] <E>/s+0 | <P>\u0442\u0430/s+d | <B>\u0438<P><B>\u0438/pl+0 | <B>\u0438<P><B>\u0438\u0442\u0435/pl+d)");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
            this.comboLookup.addItem("\u0438\u0437\u0433\u043b\u0435\u0434");
            this.comboLookup.addItem("\u043f\u0438\u0448\u0430");
            this.comboLookup.addItem("\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u043d");
            this.comboLookup.setSelectedIndex(-1);
        } else {
            this.comboWordRoot.removeAllItems();
            this.comboWordRoot.addItem("[1] table");
            this.comboWordRoot.addItem("[2] accessory");
            this.comboWordRoot.addItem("[3] man");
            this.comboWordRoot.addItem("[4] be");
            this.comboWordRoot.addItem("[5] stir");
            this.comboWordRoot.addItem("[5] stop");
            this.comboWordRoot.addItem("[5] trig");
            this.comboWordRoot.addItem("[6] knight commander");
            this.comboWordRoot.setSelectedIndex(-1);
            this.comboCommandSuffix.removeAllItems();
            this.comboCommandSuffix.addItem("[1] s");
            this.comboCommandSuffix.addItem("[2] <B>ies");
            this.comboCommandSuffix.addItem("[3] <B3>woman");
            this.comboCommandSuffix.addItem("[4] <BW>is");
            this.comboCommandSuffix.addItem("[5] <D>ed");
            this.comboCommandSuffix.addItem("[6] s<P>s");
            this.comboCommandSuffix.setSelectedIndex(-1);
            this.comboLemma.removeAllItems();
            this.comboLemma.addItem("[1] artist");
            this.comboLemma.addItem("[2] love");
            this.comboLemma.addItem("[2] help");
            this.comboLemma.addItem("[3] stir");
            this.comboLemma.addItem("[3] stop");
            this.comboLemma.addItem("[3] trig");
            this.comboLemma.addItem("[4] knight commander");
            this.comboLemma.setSelectedIndex(-1);
            this.comboExpression.removeAllItems();
            this.comboExpression.addItem("[1] <E>/s | s/p");
            this.comboExpression.addItem("[2] <E>/Pr+1+s | <E>/Pr+2+s | s/Pr+3+s | <E>/Pr+1+p | <E>/Pr+2+p | <E>/Pr+3+p");
            this.comboExpression.addItem("[3] <D>ed/Pret | <D>ed/PP");
            this.comboExpression.addItem("[4] <E>/s | s<P>s/p");
            this.comboExpression.setSelectedIndex(-1);
            this.comboLookup.removeAllItems();
        }
    }
}

