/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.StatsShell;

import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.StatsShell.CustomCellRenderer;
import net.nooj4nlp.controller.StatsShell.DrawingJPanel;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.helper.PenAttributes;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.StatsShell;
import org.apache.commons.io.FilenameUtils;

public class StatsShellController {
    private StatsShell statsShell;
    private CorpusEditorShellController corpusController;
    private TextEditorShellController textController;
    private ConcordanceShellController concordanceController;
    private HashMap<String, PenAttributes<Color, Float>> pens;
    private float[] discontiniousArray;
    private Font font;
    private Color brush = Color.BLACK;
    private HashMap<String, Double> tfIDfAllTerms;
    private HashMap<String, ArrayList<Object>> distances;
    private ArrayList<Object> freqSortedTerms;
    private ArrayList<ArrayList<Object>> allSS;
    private ArrayList<HashMap<String, Double>> tfIDfFreqInEachText;
    private String[] fileNames;
    private String[] tfIDfFileNames;
    private long[] freqInCorpus;
    private long[][] freqInEachText;
    private int nbOfColors;
    private int sizeOfCorpus;
    private int freqNumberOfTerms;
    private int freqMaxFrequency;
    private int[] tfIDfSizeOfEachText;
    private int[] sizeOfEachText;
    private boolean tfIDf_firstTime;
    private boolean distancesFirstTime;

    public StatsShellController(CorpusEditorShellController corpusController, TextEditorShellController textController, ConcordanceShellController concordanceController, StatsShell statsShell) {
        this.corpusController = corpusController;
        this.textController = textController;
        this.concordanceController = concordanceController;
        this.statsShell = statsShell;
        this.font = Launcher.preferences.TFont;
        this.pens = new HashMap();
        this.pens.put("pen", new PenAttributes(Color.BLACK, 1.0f));
        this.pens.put("pen2", new PenAttributes(Color.BLACK, 2.0f));
        this.pens.put("penr", new PenAttributes(Color.RED, 1.0f));
        this.pens.put("pen2r", new PenAttributes(Color.RED, 2.0f));
        this.discontiniousArray = new float[]{8.0f, 8.0f, 2.0f, 8.0f};
        this.freqSortedTerms = null;
        this.allSS = null;
        this.tfIDfFreqInEachText = null;
        this.tfIDfSizeOfEachText = null;
        this.tfIDfAllTerms = null;
        this.distances = null;
        JPanel displayPanel = this.statsShell.getDisplayPanel();
        displayPanel.add((Component)this.statsShell.getPanelOfFrequencies(), "Frequencies");
        this.statsShell.getRbFrequencies().setSelected(true);
        this.changePanel(displayPanel, "Frequencies");
        displayPanel.add((Component)this.statsShell.getPanelOfStandardScore(), "StandardScore");
        displayPanel.add((Component)this.statsShell.getPanelOfRelevances(), "Relevances");
        displayPanel.add((Component)this.statsShell.getPanelOfSimilarities(), "Similarity");
        this.tfIDf_firstTime = true;
        this.distancesFirstTime = true;
    }

    private String lenFormat(String text, int len) {
        int textLength = text.length();
        if (text == null || text.equals("")) {
            return text;
        }
        if (textLength == len) {
            return text;
        }
        if (textLength > len) {
            return text.substring(len);
        }
        String concatString = "";
        int i = 0;
        while (i < textLength - len) {
            concatString = String.valueOf(concatString) + ' ';
            ++i;
        }
        return String.valueOf(text) + concatString;
    }

    private void computeFrequency() {
        int freq;
        this.freqMaxFrequency = 1;
        HashMap<String, Integer> hTerms = new HashMap<String, Integer>();
        DefaultTableModel concordanceTableModel = (DefaultTableModel)this.concordanceController.getConcordanceTable().getModel();
        int i = 0;
        while (i < concordanceTableModel.getRowCount()) {
            String term = concordanceTableModel.getValueAt(i, 2).toString();
            if (hTerms.containsKey(term)) {
                freq = (Integer)hTerms.get(term);
                hTerms.put(term, freq + 1);
                if (freq + 1 > this.freqMaxFrequency) {
                    this.freqMaxFrequency = freq + 1;
                }
            } else {
                hTerms.put(term, 1);
            }
            ++i;
        }
        this.freqNumberOfTerms = hTerms.size();
        this.freqSortedTerms = new ArrayList();
        for (String term : hTerms.keySet()) {
            freq = (Integer)hTerms.get(term);
            int i2 = 0;
            while (i2 < this.freqSortedTerms.size()) {
                int cFreq = (Integer)this.freqSortedTerms.get(i2 + 1);
                if (cFreq < freq) break;
                i2 += 2;
            }
            if (i2 < this.freqSortedTerms.size()) {
                this.freqSortedTerms.add(i2, term);
                this.freqSortedTerms.add(i2 + 1, freq);
                continue;
            }
            this.freqSortedTerms.add(term);
            this.freqSortedTerms.add(freq);
        }
    }

    public void paintFrequency(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawingJPanel parentPanel = this.statsShell.getPanelOfFrequencies();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, parentPanel.getWidth(), parentPanel.getHeight());
        g2D.setColor((Color)this.pens.get((Object)"pen").color);
        g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen").stroke));
        g2D.drawLine(50, 550, 795, 550);
        g2D.drawLine(795, 550, 785, 547);
        g2D.drawLine(795, 550, 785, 553);
        g2D.setFont(this.font);
        g2D.setColor(this.brush);
        g2D.drawString("Rank", 763, 568);
        int numberOfTerms = this.freqNumberOfTerms;
        if (numberOfTerms > 30) {
            numberOfTerms = 30;
        }
        int width = 700 / numberOfTerms;
        g2D.setColor((Color)this.pens.get((Object)"pen").color);
        g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen").stroke));
        g2D.drawLine(50, 5, 50, 550);
        g2D.drawLine(50, 5, 47, 15);
        g2D.drawLine(50, 5, 53, 15);
        g2D.setFont(this.font);
        g2D.setColor(this.brush);
        g2D.drawString("Frequency", 60, 25);
        int yGrad = this.freqMaxFrequency < 10 ? 1 : (this.freqMaxFrequency < 100 ? 10 : (this.freqMaxFrequency < 1000 ? 100 : (this.freqMaxFrequency < 10000 ? 1000 : (this.freqMaxFrequency < 100000 ? 10000 : (this.freqMaxFrequency < 1000000 ? 100000 : 100000)))));
        int i = 1;
        while (yGrad * i < this.freqMaxFrequency) {
            int y = 550 - (int)((double)(yGrad * i) * 500.0 / (double)this.freqMaxFrequency);
            g2D.drawLine(47, y, 53, y);
            g2D.drawString(String.valueOf(yGrad * i), 30, y + 12);
            y = 550 - (int)(500.0 * (double)yGrad * ((double)i - 0.5) / (double)this.freqMaxFrequency);
            g2D.drawLine(47, y, 53, y);
            ++i;
        }
        g2D.drawString(String.valueOf(this.freqMaxFrequency), 30, 45);
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, this.discontiniousArray, 0.0f);
        g2D.setStroke(dashed);
        g2D.drawLine(50, 50, 795, 50);
        int i2 = 0;
        while (i2 < this.freqSortedTerms.size()) {
            double angleOfRotation = 1.5707963267948966;
            String term = this.freqSortedTerms.get(i2).toString();
            int freq = (Integer)this.freqSortedTerms.get(i2 + 1);
            int x = 50 + i2 / 2 * width + width;
            int y = 550 - (int)((double)freq * 500.0 / (double)this.freqMaxFrequency);
            g2D.setColor((Color)this.pens.get((Object)"pen2r").color);
            g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen2r").stroke));
            g2D.translate(50 + width * (i2 / 2 + 1), 545);
            g2D.rotate(-angleOfRotation);
            g2D.setFont(this.font);
            g2D.setColor(this.brush);
            g2D.drawString(term, 4, 14);
            g2D.rotate(angleOfRotation);
            g2D.translate(-50 - width * (i2 / 2 + 1), -545);
            g2D.setColor((Color)this.pens.get((Object)"pen2r").color);
            g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen2r").stroke));
            g2D.drawLine(x, y, x, 550);
            g2D.drawLine(x - 5, y, x + 5, y);
            if (i2 == 0 || i2 == 8 || i2 == 18) {
                String label = String.valueOf(i2 / 2 + 1);
                g2D.setFont(this.font);
                g2D.setColor(this.brush);
                g2D.drawString(label, x, 565);
            }
            i2 += 2;
        }
    }

    private void createFrequencyReport() {
        if (this.freqSortedTerms == null) {
            return;
        }
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showOpenDialog(this.statsShell);
        if (result == 0) {
            int value;
            File selectedFile = jFileChooser.getSelectedFile();
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "txt";
            String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists() && ((value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null)) == 1 || value == -1)) {
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(pathOfInputFile);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create statistical report file " + selectedFile.getName() + "\r" + e.getMessage(), "NooJ: cannot save statistical report", 0);
                return;
            }
            DefaultTableModel concordanceTableModel = (DefaultTableModel)this.concordanceController.getConcordanceTable().getModel();
            if (this.corpusController != null && this.corpusController.getShell() != null) {
                pw.write("Corpus " + this.corpusController.getFullPath() + "\n\n");
                pw.write("Corpus contains " + ((DefaultTableModel)this.corpusController.getShell().getTableTexts().getModel()).getRowCount() + "texts.\n\n");
                String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
                this.sizeOfCorpus = 0;
                Corpus corpus = this.corpusController.getCorpus();
                for (String fileName : corpus.listOfFileTexts) {
                    String fullPath = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fileName;
                    Ntext myText = null;
                    try {
                        myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                    }
                    catch (IOException e) {
                        if (pw != null) {
                            pw.close();
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                        return;
                    }
                    if (myText == null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Corpus is corrupted: cannot read text " + fullPath, "NooJ: Problem", 0);
                        continue;
                    }
                    this.sizeOfCorpus += myText.buffer.length();
                }
                pw.write("Corpus contains " + this.sizeOfCorpus + " characters.\n\n");
                pw.write("Concordance has " + concordanceTableModel.getRowCount() + " matches.\n\n");
            } else {
                pw.write("Text " + this.textController.getFileToBeOpenedOrImported().getAbsolutePath() + "\n\n");
                pw.write("Text contains " + this.textController.getMyText().buffer.length() + " characters.\n\n");
                pw.write("Concordance has " + concordanceTableModel.getRowCount() + " matches.\n\n");
            }
            pw.write("Rank\tTerm\tFrequency\n");
            int i = 0;
            while (i < this.freqSortedTerms.size()) {
                String term = this.freqSortedTerms.get(i).toString();
                int freq = (Integer)this.freqSortedTerms.get(i + 1);
                pw.write(String.valueOf(String.valueOf(i / 2 + 1)) + "\t" + term + "\t" + freq + "\n");
                i += 2;
            }
            pw.write("\n");
            pw.close();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Terms Frequency report saved in file " + newFile.getName(), "NooJ: frequency report successfully created!", 1);
        }
    }

    private void createStandardScoreReport() {
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showOpenDialog(this.statsShell);
        if (result == 0) {
            int value;
            File selectedFile = jFileChooser.getSelectedFile();
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "txt";
            String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists() && ((value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null)) == 1 || value == -1)) {
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(pathOfInputFile);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create statistical report file " + selectedFile.getName() + "\r" + e.getMessage(), "NooJ: cannot save statistical report", 0);
                return;
            }
            int nt = this.fileNames.length;
            if (this.corpusController != null) {
                pw.write("Corpus " + this.corpusController.getFullPath() + "\n");
                pw.write("\n");
                pw.write(String.valueOf(this.corpusController.getTableTexts().getModel().getRowCount()) + " texts\t");
                pw.write(String.valueOf(this.sizeOfCorpus) + " characters\n");
                pw.write("\n");
                pw.write("NT: \tnumber of texts in corpus = " + nt + "\n");
                pw.write("NM: \tnumber of matches in corpus\n");
                pw.write("AF: \tabsolute frequency in each text\n");
                pw.write("RS: \trelative size of each text (in chars) = size of each text / total size of corpus\n");
                pw.write("EF: \texpected frequency in each text = NM * RS\n");
                pw.write("SD: \tstandard deviation = Sqr (Sum (AF - EF)^2) / NT)\n");
                pw.write("NSD: \tnormalized standard deviation = SD/NM\n");
                pw.write("SS: \tstandard score = (AF - EF) / SD\n");
                pw.write("\n");
                pw.write("\n");
                pw.write(String.valueOf(this.lenFormat("Text", 15)) + "\t");
                pw.write("Size   \t");
            } else {
                pw.write("Text " + this.textController.getTextName() + "\n");
                pw.write("\n");
                pw.write("20 parts\t");
                pw.write(String.valueOf(this.sizeOfCorpus) + " characters\n");
                pw.write("\n");
                pw.write("NT: \tnumber of parts in text = 20\n");
                pw.write("NM: \tnumber of matches in text\n");
                pw.write("AF: \tabsolute frequency in each part\n");
                pw.write("RS: \trelative size of each part = 1/20\n");
                pw.write("EF: \texpected frequency in each part = AF * RS\n");
                pw.write("SD: \tstandard deviation = Sqr (Sum ((AF - EF)^2 / NT))\n");
                pw.write("NSD: \tnormalized standard deviation = SD/NM\n");
                pw.write("SS: \tstandard score = (AF - EF) / SD\n");
                pw.write("\n");
                pw.write("\n");
            }
            double[] sds = new double[this.freqInEachText.length];
            double[] nsds = new double[this.freqInEachText.length];
            int iColor = 0;
            while (iColor < this.freqInEachText.length) {
                long nm = 0L;
                double sd = 0.0;
                int iTxt = 0;
                while (iTxt < this.fileNames.length) {
                    long af = this.freqInEachText[iColor][iTxt];
                    nm += af;
                    double ef = 1.0 * (double)this.freqInCorpus[iColor] * (double)this.sizeOfEachText[iTxt] / (double)this.sizeOfCorpus;
                    sd += ((double)af - ef) * ((double)af - ef) / (double)nt;
                    ++iTxt;
                }
                sds[iColor] = Math.sqrt(sd);
                double nsd = 0.0;
                int iTxt2 = 0;
                while (iTxt2 < this.fileNames.length) {
                    long af = this.freqInEachText[iColor][iTxt2];
                    double ef = 1.0 * (double)this.freqInCorpus[iColor] * (double)this.sizeOfEachText[iTxt2] / (double)this.sizeOfCorpus;
                    nsd += ((double)af - ef) / (double)nm * (((double)af - ef) / (double)nm) / (double)nt;
                    ++iTxt2;
                }
                nsds[iColor] = Math.sqrt(nsd);
                if (this.freqInEachText.length > 1) {
                    pw.write("NM[" + (iColor + 1) + "] = " + nm + "\n");
                    pw.write("SD[" + (iColor + 1) + "] = " + sds[iColor] + "\n");
                    pw.write("NSD[" + (iColor + 1) + "] = " + nsds[iColor] + "\n");
                } else {
                    pw.write("NM = " + nm + "\n");
                    pw.write("SD = " + sds[iColor] + "\n");
                    pw.write("NSD = " + nsds[iColor] + "\n");
                }
                ++iColor;
            }
            pw.write(String.valueOf(this.lenFormat("Part", 15)) + "\t");
            pw.write("Size   \t");
            iColor = 0;
            while (iColor < this.freqInEachText.length) {
                if (this.freqInEachText.length > 1) {
                    pw.write("AF[" + (iColor + 1) + "]\t");
                    pw.write("EF[" + (iColor + 1) + "]\t");
                    pw.write("SS[" + (iColor + 1) + "]\t");
                } else {
                    pw.write("AF\t");
                    pw.write("EF\t");
                    pw.write("SS\t");
                }
                ++iColor;
            }
            pw.write("\n");
            int iTxt = 0;
            while (iTxt < this.fileNames.length) {
                pw.write(String.valueOf(this.lenFormat(this.fileNames[iTxt], 15)) + "\t");
                pw.write(String.valueOf(this.sizeOfEachText[iTxt]) + "\t");
                int iColor2 = 0;
                while (iColor2 < this.freqInEachText.length) {
                    long af = this.freqInEachText[iColor2][iTxt];
                    pw.write(String.valueOf(af) + "\t");
                    double ef = 1.0 * (double)this.freqInCorpus[iColor2] * (double)this.sizeOfEachText[iTxt] / (double)this.sizeOfCorpus;
                    pw.write(String.valueOf(ef) + "\t");
                    double ss = (1.0 * (double)this.freqInEachText[iColor2][iTxt] - ef) / sds[iColor2];
                    pw.write(String.valueOf(ss) + "\t");
                    ++iColor2;
                }
                pw.write("\n");
                ++iTxt;
            }
            pw.close();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Standard Score report saved in file " + newFile.getName(), "NooJ: standard score report successfully created!", 1);
        }
    }

    private void createTfIDfReport() {
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showOpenDialog(this.statsShell);
        if (result == 0) {
            int value;
            File selectedFile = jFileChooser.getSelectedFile();
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "txt";
            String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists() && ((value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null)) == 1 || value == -1)) {
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(pathOfInputFile);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create Relevance report file " + selectedFile.getName() + "\r" + e.getMessage(), "NooJ: cannot save Relevance report", 0);
                return;
            }
            if (this.corpusController != null) {
                pw.write("Corpus " + this.corpusController.getFullPath() + "\n");
                pw.write("\n");
                pw.write(String.valueOf(this.corpusController.getTableTexts().getModel().getRowCount()) + " documents\t");
                pw.write("\n");
            } else {
                pw.write("Text " + this.textController.getFileToBeOpenedOrImported().getAbsolutePath() + "\n");
                pw.write("\n");
                pw.write("20 parts\t");
                pw.write("\n");
            }
            pw.write("ND: \tnumber of documents in corpus = " + this.tfIDfFileNames.length + "\n");
            pw.write("ND(T): \tnumber of documents in which term T occurs\n");
            pw.write("C(T,D): \tnumber of occurrences of term T in document D\n");
            pw.write("TF: \tnormalized frequency of term T in document D = C(T,D) * Term size / Document size\n");
            pw.write("IDF: \tinverse document frequency = ND / ND(T)\n");
            pw.write("Relevance:\t TF-IDF = Weight of term T in document D = TF * log10 (ND / IDF)\n");
            pw.write("\n");
            int iTxt = 0;
            while (iTxt < this.tfIDfFreqInEachText.size()) {
                HashMap<String, Double> htfIDf = this.tfIDfFreqInEachText.get(iTxt);
                for (String term : htfIDf.keySet()) {
                    BigDecimal convertedValue = BigDecimal.valueOf(htfIDf.get(term));
                    String tfIDFString = String.valueOf(convertedValue.setScale(20, 4));
                    pw.write(String.valueOf(this.tfIDfFileNames[iTxt]) + ";" + term + ";" + tfIDFString + "\n");
                }
                ++iTxt;
            }
            pw.close();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Relevance report saved in file " + newFile.getName(), "NooJ: Relevance report successfully created!", 1);
        }
    }

    private void createDistReport() {
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text (*.txt)", "txt");
        jFileChooser.setFileFilter(filter);
        int result = jFileChooser.showOpenDialog(this.statsShell);
        if (result == 0) {
            int value;
            File selectedFile = jFileChooser.getSelectedFile();
            String parentPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String inputFileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "txt";
            String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
            File newFile = new File(pathOfInputFile);
            if (newFile.exists() && ((value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null)) == 1 || value == -1)) {
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(pathOfInputFile);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot create Similarity report file " + selectedFile.getName() + "\r" + e.getMessage(), "NooJ: cannot save Similarity report", 0);
                return;
            }
            if (this.corpusController != null) {
                pw.write("Corpus " + this.corpusController.getFullPath() + "\n\n");
                pw.write(String.valueOf(this.corpusController.getTableTexts().getModel().getRowCount()) + " documents\t\n");
            } else {
                pw.write("Text " + this.textController.getFileToBeOpenedOrImported().getAbsolutePath() + "\n\n");
                pw.write("20 parts\t\n");
            }
            pw.write("ND: \tnumber of documents in corpus = " + this.tfIDfFileNames.length + "\n");
            pw.write("ND(T): \tnumber of documents in which term T occurs\n");
            pw.write("C(T,D): \tnumber of occurrences of term T in document D\n");
            pw.write("TF: \tnormalized frequency of term T in document D = C(T,D) * Term size / Document size\n");
            pw.write("IDF: \tinverse document frequency = ND / ND(T)\n");
            pw.write("TF-IDF: \tWeight of term T in document D = TF * log10 (ND / IDF)\n");
            pw.write("Similarity: \tDistance between TFIDF of term1 and TFIDF of term2 DIST = d(TFIDF1,TFIDF2)\n\n");
            for (String term1 : this.distances.keySet()) {
                pw.write("\t" + term1);
            }
            pw.write("\n");
            for (String term1 : this.distances.keySet()) {
                pw.write(String.valueOf(term1) + "\t");
                ArrayList<String> listOfDists = new ArrayList<String>();
                listOfDists.add(term1);
                ArrayList<Object> dist1 = this.distances.get(term1);
                for (String term2 : this.distances.keySet()) {
                    double dist2 = -1.0;
                    int i = 0;
                    while (i < dist1.size()) {
                        String term3 = dist1.get(i).toString();
                        if (term3.equals(term2)) {
                            dist2 = (Double)dist1.get(i + 1);
                            break;
                        }
                        i += 2;
                    }
                    pw.write(String.valueOf(dist2));
                    pw.write("\t");
                }
                pw.write("\n");
            }
            pw.close();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Similarity report saved in file " + newFile.getName(), "NooJ: Similarity report successfully created!", 1);
        }
    }

    private void computeTfidf() {
        Map<String, Double> hFreq;
        int nbOfDocuments;
        this.tfIDfFreqInEachText = null;
        this.tfIDfSizeOfEachText = null;
        this.tfIDfAllTerms = new HashMap();
        DefaultTableModel concordanceTableModel = (DefaultTableModel)this.concordanceController.getConcordanceTable().getModel();
        if (this.corpusController != null) {
            String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            DefaultTableModel tableModel = (DefaultTableModel)this.corpusController.getTableTexts().getModel();
            nbOfDocuments = tableModel.getRowCount();
            this.tfIDfSizeOfEachText = new int[nbOfDocuments];
            this.tfIDfFileNames = new String[nbOfDocuments];
            int iTxt = 0;
            Corpus corpus = this.corpusController.getCorpus();
            for (String fileName : corpus.listOfFileTexts) {
                int sizeOfMyText;
                String fullPath = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fileName;
                Ntext myText = null;
                try {
                    myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                    return;
                }
                if (myText == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Corpus is corrupted: cannot read text " + fullPath, "NooJ: Problem", 0);
                    continue;
                }
                this.tfIDfSizeOfEachText[iTxt] = sizeOfMyText = myText.buffer.length();
                this.tfIDfFileNames[iTxt] = FilenameUtils.removeExtension(fileName);
                this.sizeOfCorpus += sizeOfMyText;
                ++iTxt;
            }
            this.tfIDfFreqInEachText = new ArrayList();
            int i = 0;
            while (i < nbOfDocuments) {
                this.tfIDfFreqInEachText.add(new HashMap());
                ++i;
            }
            i = 0;
            while (i < concordanceTableModel.getRowCount()) {
                Object tag = concordanceTableModel.getValueAt(i, 5);
                if (tag != null) {
                    String fileName = FilenameUtils.removeExtension(concordanceTableModel.getValueAt(i, 0).toString());
                    iTxt = -1;
                    int j = 0;
                    while (j < this.tfIDfFileNames.length) {
                        if (fileName.equals(this.tfIDfFileNames[j])) {
                            iTxt = j;
                            break;
                        }
                        ++j;
                    }
                    if (iTxt != -1) {
                        String term;
                        Map hFreq2 = this.tfIDfFreqInEachText.get(iTxt);
                        if (hFreq2.containsKey(term = concordanceTableModel.getValueAt(i, 2).toString())) {
                            int freq = ((Double)hFreq2.get(term)).intValue();
                            hFreq2.put(term, new Double(freq + 1));
                        } else {
                            hFreq2.put(term, new Double(1.0));
                            if (!this.tfIDfAllTerms.containsKey(term)) {
                                this.tfIDfAllTerms.put(term, new Double(0.0));
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            nbOfDocuments = 20;
            int sizeOfCorpus = this.textController.getMyText().buffer.length();
            this.tfIDfSizeOfEachText = new int[20];
            this.tfIDfSizeOfEachText = new int[20];
            this.tfIDfFileNames = new String[20];
            int i = 0;
            while (i < 20) {
                this.tfIDfFileNames[i] = "Part #" + (i + 1);
                int n = i++;
                this.tfIDfSizeOfEachText[n] = this.tfIDfSizeOfEachText[n] + sizeOfCorpus / 20;
            }
            this.tfIDfFreqInEachText = new ArrayList();
            i = 0;
            while (i < 20) {
                this.tfIDfFreqInEachText.add(new HashMap());
                ++i;
            }
            i = 0;
            while (i < concordanceTableModel.getRowCount()) {
                Object tag = concordanceTableModel.getValueAt(i, 5);
                if (tag != null) {
                    String term;
                    ArrayList arrayList = (ArrayList)tag;
                    int absoluteBeginAddress = new Double(arrayList.get(2).toString()).intValue();
                    int partition = (int)((double)absoluteBeginAddress * 20.0 / (double)sizeOfCorpus);
                    Map hCount = this.tfIDfFreqInEachText.get(partition);
                    if (hCount.containsKey(term = concordanceTableModel.getValueAt(i, 2).toString())) {
                        int count = ((Double)hCount.get(term)).intValue();
                        hCount.put(term, new Double(count + 1));
                    } else {
                        hCount.put(term, new Double(1.0));
                        if (!this.tfIDfAllTerms.containsKey(term)) {
                            // empty if block
                        }
                        this.tfIDfAllTerms.put(term, new Double(0.0));
                    }
                }
                ++i;
            }
        }
        int iTxt = 0;
        while (iTxt < this.tfIDfFreqInEachText.size()) {
            Map hCount = this.tfIDfFreqInEachText.get(iTxt);
            HashMap<String, Double> hFreq3 = new HashMap<String, Double>();
            for (String string : hCount.keySet()) {
                int nbOfOccurences = ((Double)hCount.get(string)).intValue();
                int termSize = string.length();
                double freq = 1.0 * (double)nbOfOccurences * (double)termSize / (double)this.tfIDfSizeOfEachText[iTxt];
                hFreq3.put(string, freq);
            }
            this.tfIDfFreqInEachText.set(iTxt, hFreq3);
            ++iTxt;
        }
        iTxt = 0;
        while (iTxt < this.tfIDfFreqInEachText.size()) {
            hFreq = this.tfIDfFreqInEachText.get(iTxt);
            for (String term : ((HashMap)hFreq).keySet()) {
                int nbOfDocumentsForTerm = this.tfIDfAllTerms.get(term).intValue();
                this.tfIDfAllTerms.put(term, new Double(nbOfDocumentsForTerm + 1));
            }
            ++iTxt;
        }
        iTxt = 0;
        while (iTxt < this.tfIDfFreqInEachText.size()) {
            hFreq = this.tfIDfFreqInEachText.get(iTxt);
            HashMap<String, Double> htfIDf = new HashMap<String, Double>();
            for (String string : hFreq.keySet()) {
                double freq = hFreq.get(string);
                double tfIDf = freq * Math.log10(nbOfDocuments / this.tfIDfAllTerms.get(string).intValue());
                htfIDf.put(string, tfIDf);
            }
            this.tfIDfFreqInEachText.set(iTxt, htfIDf);
            ++iTxt;
        }
    }

    private void fillInTfIDf() {
        JTable tableOfRelevences = this.statsShell.getPanelOfRelevances().getTableOfRelevances();
        DefaultTableModel tableModel = (DefaultTableModel)tableOfRelevences.getModel();
        ArrayList<String[]> tableData = new ArrayList<String[]>();
        String[] stringArray = this.tfIDfFileNames;
        int n = this.tfIDfFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            tableModel.addColumn(fileName);
            ++n2;
        }
        CustomCellRenderer customCellRenderer = (CustomCellRenderer)tableOfRelevences.getDefaultRenderer(Object.class);
        boolean[][] cellMatrix = customCellRenderer.getCellMatrix();
        boolean matrixInitialized = false;
        int counter = 0;
        ArrayList<String> listOfFreqs = new ArrayList<String>();
        for (String term : this.tfIDfAllTerms.keySet()) {
            listOfFreqs.add(term);
            double maxTfIDf = 0.0;
            int iTxt = 0;
            while (iTxt < this.tfIDfFreqInEachText.size()) {
                HashMap<String, Double> hFreq = this.tfIDfFreqInEachText.get(iTxt);
                if (!hFreq.containsKey(term)) {
                    listOfFreqs.add("");
                } else {
                    double tfIDf = hFreq.get(term);
                    if (tfIDf == 0.0) {
                        listOfFreqs.add("");
                    } else {
                        String tfIDFString = String.valueOf(tfIDf);
                        if (tfIDFString.length() < 13) {
                            listOfFreqs.add(tfIDFString);
                        } else {
                            BigDecimal convertedValue = BigDecimal.valueOf(tfIDf);
                            tfIDFString = String.valueOf(convertedValue.setScale(10, 4));
                            listOfFreqs.add(tfIDFString);
                        }
                        if (tfIDf > maxTfIDf) {
                            maxTfIDf = tfIDf;
                        }
                    }
                }
                ++iTxt;
            }
            int sizeOfFreqList = listOfFreqs.size() / (counter + 1);
            String[] line = new String[sizeOfFreqList + 1];
            line = (String[])Arrays.copyOf(listOfFreqs.subList(counter * sizeOfFreqList, (counter + 1) * sizeOfFreqList).toArray(), sizeOfFreqList + 1, String[].class);
            line[sizeOfFreqList] = String.valueOf(maxTfIDf);
            tableData.add(line);
            ++counter;
        }
        Collections.sort(tableData, new Comparator<String[]>(){

            @Override
            public int compare(String[] strings, String[] strings2) {
                return strings[0].compareToIgnoreCase(strings2[0]);
            }
        });
        int l = 0;
        while (l < counter) {
            String[] line = (String[])tableData.get(l);
            int lengthOfLine = line.length;
            int i = 1;
            while (i < lengthOfLine - 1) {
                String txt = line[i];
                if (!txt.equals("")) {
                    double tfIDf = Double.parseDouble(txt);
                    Double d = new Double(line[lengthOfLine - 1]);
                    if (tfIDf >= d - 0.001) {
                        if (!matrixInitialized) {
                            int sizeOfAllTerms = this.tfIDfAllTerms.size();
                            boolean[][] tempCellMatrix = new boolean[lengthOfLine][sizeOfAllTerms];
                            int j = 0;
                            while (j < lengthOfLine) {
                                int k = 0;
                                while (k < sizeOfAllTerms) {
                                    tempCellMatrix[j][k] = false;
                                    ++k;
                                }
                                ++j;
                            }
                            cellMatrix = tempCellMatrix;
                            matrixInitialized = true;
                        }
                        cellMatrix[i][l] = true;
                        customCellRenderer.setCellMatrix(cellMatrix);
                        customCellRenderer.setTableHasColoredCells(true);
                    }
                }
                ++i;
            }
            ++l;
        }
        int i = 0;
        while (i < tableData.size()) {
            tableModel.addRow((Object[])tableData.get(i));
            ++i;
        }
        i = 0;
        while (i < tableModel.getColumnCount()) {
            StatsShellController.setWidthOfTableColumn(tableOfRelevences, tableModel, i);
            ++i;
        }
    }

    private void fillInDistances() {
        JTable tableOfDistances = this.statsShell.getPanelOfSimilarities().getTableOfDistances();
        DefaultTableModel tableModel = (DefaultTableModel)tableOfDistances.getModel();
        for (String term2 : this.distances.keySet()) {
            tableModel.addColumn(term2);
        }
        for (String term1 : this.distances.keySet()) {
            ArrayList<String> listOfDists = new ArrayList<String>();
            listOfDists.add(term1);
            ArrayList<Object> dist1 = this.distances.get(term1);
            for (String term2 : this.distances.keySet()) {
                double dist2 = -1.0;
                int i = 0;
                while (i < dist1.size()) {
                    String term3 = dist1.get(i).toString();
                    if (term3.equals(term2)) {
                        dist2 = (Double)dist1.get(i + 1);
                        break;
                    }
                    i += 2;
                }
                if (dist2 == 0.0) {
                    listOfDists.add("");
                    continue;
                }
                String distString = String.valueOf(dist2);
                if (distString.length() < 13) {
                    listOfDists.add(distString);
                    continue;
                }
                BigDecimal convertedValue = BigDecimal.valueOf(dist2);
                distString = String.valueOf(convertedValue.setScale(10, 4));
                listOfDists.add(distString);
            }
            int sizeOfDistList = listOfDists.size();
            Object[] line = new String[sizeOfDistList];
            line = (String[])Arrays.copyOf(listOfDists.toArray(), sizeOfDistList, String[].class);
            tableModel.addRow(line);
        }
        int i = 0;
        while (i < tableModel.getColumnCount()) {
            StatsShellController.setWidthOfTableColumn(tableOfDistances, tableModel, i);
            ++i;
        }
    }

    private double computeDistance(String term1, String term2) {
        double distance = 0.0;
        if (term1.equals(term2)) {
            return 0.0;
        }
        int iTxt = 0;
        while (iTxt < this.tfIDfFreqInEachText.size()) {
            HashMap<String, Double> htfIDf = this.tfIDfFreqInEachText.get(iTxt);
            double tfIDf1 = 0.0;
            if (htfIDf.containsKey(term1)) {
                tfIDf1 = htfIDf.get(term1);
            }
            double tfIDf2 = 0.0;
            if (htfIDf.containsKey(term2)) {
                tfIDf2 = htfIDf.get(term2);
            }
            double dist = (tfIDf2 - tfIDf1) * (tfIDf2 - tfIDf1);
            distance += dist;
            ++iTxt;
        }
        return Math.sqrt(distance);
    }

    private void computeDistances() {
        if (this.tfIDfFreqInEachText == null) {
            this.computeTfidf();
        }
        this.distances = new HashMap();
        for (String term1 : this.tfIDfAllTerms.keySet()) {
            ArrayList<Object> dist1 = new ArrayList<Object>();
            for (String term2 : this.tfIDfAllTerms.keySet()) {
                double distance2 = this.computeDistance(term1, term2);
                dist1.add(term2);
                dist1.add(distance2);
            }
            this.distances.put(term1, dist1);
        }
    }

    private void computeStandardScore() {
        Color c;
        this.nbOfColors = 0;
        this.freqInEachText = null;
        this.freqInCorpus = null;
        this.sizeOfCorpus = 0;
        HashMap<Color, Integer> colors = new HashMap<Color, Integer>();
        ArrayList<Color> aColors = new ArrayList<Color>();
        DefaultTableModel tableModel = (DefaultTableModel)this.concordanceController.getConcordanceTable().getModel();
        if (this.corpusController != null) {
            int corpusTableSize = this.corpusController.getShell().getTableTexts().getModel().getRowCount();
            this.sizeOfEachText = new int[corpusTableSize];
            this.fileNames = new String[corpusTableSize];
            String corpusDirName = String.valueOf(this.corpusController.getFullPath()) + "_dir";
            int iTxt = 0;
            Corpus corpus = this.corpusController.getCorpus();
            for (String fileName : corpus.listOfFileTexts) {
                String fullPath = String.valueOf(corpusDirName) + System.getProperty("file.separator") + fileName;
                Ntext myText = null;
                try {
                    myText = Ntext.loadJustBufferForCorpus(fullPath, corpus.lan, corpus.multiplier);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while loading text buffer for corpus!", 0);
                    return;
                }
                if (myText == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Corpus is corrupted: cannot read text " + fullPath, "NooJ: Problem", 0);
                    continue;
                }
                this.sizeOfEachText[iTxt] = myText.buffer.length();
                this.sizeOfCorpus += myText.buffer.length();
                this.fileNames[iTxt] = FilenameUtils.removeExtension(fileName);
                ++iTxt;
            }
            int i = 0;
            while (i < tableModel.getRowCount()) {
                int color = (Integer)tableModel.getValueAt(i, 4);
                c = color == 1 ? Color.BLACK : (color == 2 ? Color.RED : (color == 3 ? Color.GREEN : Color.BLUE));
                if (!colors.containsKey(c)) {
                    colors.put(c, this.nbOfColors);
                    aColors.add(c);
                    ++this.nbOfColors;
                }
                ++i;
            }
            this.freqInEachText = new long[this.nbOfColors][];
            this.freqInCorpus = new long[this.nbOfColors];
            int iCol = 0;
            while (iCol < this.nbOfColors) {
                this.freqInEachText[iCol] = new long[corpusTableSize];
                ++iCol;
            }
            i = 0;
            while (i < tableModel.getRowCount()) {
                String fileName = FilenameUtils.removeExtension(tableModel.getValueAt(i, 0).toString());
                iTxt = -1;
                int j = 0;
                while (j < this.fileNames.length) {
                    if (fileName.equals(this.fileNames[j])) {
                        iTxt = j;
                        break;
                    }
                    ++j;
                }
                if (iTxt != -1) {
                    int color = (Integer)tableModel.getValueAt(i, 4);
                    Color c2 = color == 1 ? Color.BLACK : (color == 2 ? Color.RED : (color == 3 ? Color.GREEN : Color.BLUE));
                    int colorNb = (Integer)colors.get(c2);
                    long[] lArray = this.freqInEachText[colorNb];
                    int n = iTxt;
                    lArray[n] = lArray[n] + 1L;
                    int n2 = colorNb;
                    this.freqInCorpus[n2] = this.freqInCorpus[n2] + 1L;
                }
                ++i;
            }
        } else {
            this.sizeOfEachText = new int[20];
            this.fileNames = new String[20];
            this.sizeOfEachText = new int[20];
            this.fileNames = new String[20];
            this.sizeOfCorpus = this.textController.getMyText().buffer.length();
            int iTxt = 0;
            while (iTxt < 20) {
                int n = iTxt;
                this.sizeOfEachText[n] = this.sizeOfEachText[n] + this.sizeOfCorpus / 20;
                this.fileNames[iTxt] = "Part #" + (iTxt + 1);
                ++iTxt;
            }
            int i = 0;
            while (i < tableModel.getRowCount()) {
                int color = (Integer)tableModel.getValueAt(i, 4);
                Color c3 = color == 1 ? Color.BLACK : (color == 2 ? Color.RED : (color == 3 ? Color.GREEN : Color.BLUE));
                if (!colors.containsKey(c3)) {
                    colors.put(c3, this.nbOfColors);
                    aColors.add(c3);
                    ++this.nbOfColors;
                }
                ++i;
            }
            this.freqInEachText = new long[this.nbOfColors][];
            this.freqInCorpus = new long[this.nbOfColors];
            int iCol = 0;
            while (iCol < this.nbOfColors) {
                this.freqInEachText[iCol] = new long[20];
                ++iCol;
            }
            i = 0;
            while (i < tableModel.getRowCount()) {
                Object tag = tableModel.getValueAt(i, 5);
                if (tag != null) {
                    ArrayList annotation = (ArrayList)tag;
                    int absoluteBeginAddress = new Double(annotation.get(2).toString()).intValue();
                    int partition = (int)((double)absoluteBeginAddress * 20.0 / (double)this.sizeOfCorpus);
                    int color = (Integer)tableModel.getValueAt(i, 4);
                    c = color == 1 ? Color.BLACK : (color == 2 ? Color.RED : (color == 3 ? Color.GREEN : Color.BLUE));
                    int colorNb = (Integer)colors.get(c);
                    long[] lArray = this.freqInEachText[colorNb];
                    int n = partition;
                    lArray[n] = lArray[n] + 1L;
                    int n3 = colorNb;
                    this.freqInCorpus[n3] = this.freqInCorpus[n3] + 1L;
                }
                ++i;
            }
        }
        int nt = this.fileNames.length;
        double[] sds = new double[this.freqInEachText.length];
        double[] nsds = new double[this.freqInEachText.length];
        int iColor = 0;
        while (iColor < this.freqInEachText.length) {
            long nm = 0L;
            double sd = 0.0;
            int iTxt = 0;
            while (iTxt < this.fileNames.length) {
                long af = this.freqInEachText[iColor][iTxt];
                nm += af;
                double ef = 1.0 * (double)this.freqInCorpus[iColor] * (double)this.sizeOfEachText[iTxt] / (double)this.sizeOfCorpus;
                sd += ((double)af - ef) * ((double)af - ef) / (double)nt;
                ++iTxt;
            }
            sds[iColor] = Math.sqrt(sd);
            double nsd = 0.0;
            int iTxt2 = 0;
            while (iTxt2 < this.fileNames.length) {
                long af = this.freqInEachText[iColor][iTxt2];
                double ef = 1.0 * (double)this.freqInCorpus[iColor] * (double)this.sizeOfEachText[iTxt2] / (double)this.sizeOfCorpus;
                nsd += ((double)af - ef) / (double)nm * (((double)af - ef) / (double)nm) / (double)nt;
                ++iTxt2;
            }
            nsds[iColor] = Math.sqrt(nsd);
            ++iColor;
        }
        this.allSS = new ArrayList();
        iColor = 0;
        while (iColor < this.freqInEachText.length) {
            ArrayList color = new ArrayList();
            color.add(aColors.get(iColor));
            int iTxt = 0;
            while (iTxt < this.fileNames.length) {
                double ef = 1.0 * (double)this.freqInCorpus[iColor] * (double)this.sizeOfEachText[iTxt] / (double)this.sizeOfCorpus;
                double ss = (1.0 * (double)this.freqInEachText[iColor][iTxt] - ef) / sds[iColor];
                color.add(ss);
                ++iTxt;
            }
            this.allSS.add(color);
            ++iColor;
        }
    }

    public void paintStandardScore(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawingJPanel parentPanel = this.statsShell.getPanelOfStandardScore();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, parentPanel.getWidth(), parentPanel.getHeight());
        g2D.setColor((Color)this.pens.get((Object)"pen").color);
        g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen").stroke));
        g2D.drawLine(5, 300, 795, 300);
        g2D.drawLine(795, 300, 785, 297);
        g2D.drawLine(795, 300, 785, 303);
        int nbOfPoints = this.allSS.get(0).size();
        double angleOfRotation = 0.7853981633974483;
        double width = 700.0 / (double)nbOfPoints;
        if (nbOfPoints <= 30) {
            int i = 0;
            while (i < nbOfPoints) {
                int lineParameter = 50 + (int)(width * (double)i);
                g2D.drawLine(lineParameter, 297, lineParameter, 303);
                if (i < this.fileNames.length) {
                    int translateParameter = 45 + (int)(width * (double)(i + 1));
                    g2D.translate(translateParameter, 290);
                    g2D.rotate(-angleOfRotation);
                    g2D.setFont(this.font);
                    g2D.setColor(this.brush);
                    g2D.drawString(this.fileNames[i], 0, 0);
                    g2D.rotate(angleOfRotation);
                    g2D.translate(-translateParameter, -290);
                }
                ++i;
            }
        } else {
            int interval = nbOfPoints / 20;
            int i = 0;
            while (i < nbOfPoints) {
                if (i < this.fileNames.length && (i % interval == 0 || i == nbOfPoints - 1)) {
                    int lineParameter = 50 + (int)(width * (double)i);
                    int translateParameter = 45 + (int)(width * (double)(i + 1));
                    g2D.drawLine(lineParameter, 297, lineParameter, 303);
                    g2D.translate(translateParameter, 290);
                    g2D.rotate(-angleOfRotation);
                    g2D.setFont(this.font);
                    g2D.setColor(this.brush);
                    g2D.drawString(this.fileNames[i], 10, 0);
                    g2D.rotate(angleOfRotation);
                    g2D.translate(-translateParameter, -290);
                }
                ++i;
            }
        }
        g2D.setColor((Color)this.pens.get((Object)"pen").color);
        g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen").stroke));
        g2D.drawLine(50, 5, 50, 595);
        g2D.drawLine(50, 5, 47, 15);
        g2D.drawLine(50, 5, 53, 15);
        g2D.setFont(this.font);
        g2D.setColor(this.brush);
        g2D.drawString("Standard Score", 58, 25);
        g2D.setColor((Color)this.pens.get((Object)"pen").color);
        g2D.setStroke(new BasicStroke(this.pens.get((Object)"pen").stroke));
        double maxSS = 0.0;
        for (ArrayList<Object> color : this.allSS) {
            int i = 1;
            while (i < color.size()) {
                double ss = new Double(color.get(i).toString());
                if (ss > maxSS) {
                    maxSS = ss;
                }
                ++i;
            }
        }
        int height = maxSS <= 2.2 ? 113 : (int)(250.0 / maxSS);
        double highestGrade = maxSS < 2.2 ? 3.2 : maxSS + 1.0;
        int i = -((int)maxSS) - 1;
        while ((double)i < highestGrade) {
            int lineParameter = 300 - i * height;
            g2D.drawLine(47, lineParameter, 53, lineParameter);
            g2D.setFont(this.font);
            g2D.setColor(this.brush);
            g2D.drawString(String.valueOf(i), 34, lineParameter + 11);
            if (i == 2 || i == -2) {
                BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, this.discontiniousArray, 0.0f);
                g2D.setStroke(dashed);
                g2D.drawLine(50, lineParameter, 795, lineParameter);
            }
            ++i;
        }
        if (this.allSS != null & this.allSS.size() > 0) {
            for (ArrayList<Object> color : this.allSS) {
                Color c = (Color)color.get(0);
                g2D.setColor(c);
                BasicStroke thickness = new BasicStroke(2.0f);
                g2D.setStroke(thickness);
                Point pt = new Point(0, 0);
                int i2 = 1;
                while (i2 < color.size()) {
                    double ss = new Double(color.get(i2).toString());
                    int parameter = (int)(300.0f - (float)ss * (float)height);
                    int lineParameter = 50 + (int)(width * (double)i2);
                    if (pt.x != 0 || pt.y != 0) {
                        g2D.drawLine(pt.x, pt.y, 50 + (int)(width * (double)i2), parameter);
                    }
                    g2D.drawLine(50 + (int)(width * (double)i2 - 3.0), parameter, 50 + (int)(width * (double)i2 + 3.0), parameter);
                    g2D.drawLine(lineParameter, parameter - 3, 50 + (int)(width * (double)i2), parameter + 3);
                    pt.x = lineParameter;
                    pt.y = parameter;
                    ++i2;
                }
            }
        }
    }

    private void launchAnalysis() {
        if (this.statsShell.getRbFrequencies().isSelected()) {
            if (this.freqSortedTerms == null) {
                this.computeFrequency();
            }
            this.statsShell.getPanelOfFrequencies().repaint();
        } else if (this.statsShell.getRbStandardScore().isSelected()) {
            if (this.allSS == null) {
                this.computeStandardScore();
            }
            this.statsShell.getRbStandardScore().repaint();
        } else if (this.statsShell.getRbTfIDf().isSelected() && this.tfIDf_firstTime) {
            if (this.tfIDfFreqInEachText == null) {
                this.computeTfidf();
            }
            this.fillInTfIDf();
            this.tfIDf_firstTime = false;
        } else if (this.statsShell.getRbDistances().isSelected() && this.distancesFirstTime) {
            if (this.distances == null) {
                this.computeDistances();
            }
            this.fillInDistances();
            this.distancesFirstTime = false;
        }
    }

    public void exportStatistics() {
        if (this.statsShell.getRbFrequencies().isSelected()) {
            this.createFrequencyReport();
        } else if (this.statsShell.getRbStandardScore().isSelected()) {
            this.createStandardScoreReport();
        } else if (this.statsShell.getRbTfIDf().isSelected()) {
            this.createTfIDfReport();
        } else if (this.statsShell.getRbDistances().isSelected()) {
            this.createDistReport();
        }
    }

    public void changePanel(JPanel panel, String previewPanelName) {
        CardLayout cards = (CardLayout)panel.getLayout();
        cards.show(panel, previewPanelName);
        this.launchAnalysis();
    }

    private static void setWidthOfTableColumn(JTable table, DefaultTableModel tableModel, int column) {
        int width = 0;
        int row = 0;
        while (row < tableModel.getRowCount()) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
            ++row;
        }
        String columnText = table.getColumnName(column);
        int preferedWidthOfHeader = table.getGraphics().getFontMetrics().stringWidth(columnText);
        if (width < preferedWidthOfHeader) {
            width = preferedWidthOfHeader;
        }
        table.getColumnModel().getColumn(column).setPreferredWidth(width + 10);
    }
}

