/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.SyntacticTreeShell;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.gui.components.STree;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.SyntacticTreeShell;

public class SyntacticTreeShellController {
    private SyntacticTreeShell shell;
    private int concordanceIndex;
    private STree tree;
    private String[] tokens;
    private int itokens;

    public SyntacticTreeShellController(SyntacticTreeShell shell) {
        this.shell = shell;
    }

    /*
     * Unable to fully structure code
     */
    private STree parse() {
        token = this.tokens[this.itokens];
        t = new STree(token.substring(1), this.shell.getPanel1());
        ++this.itokens;
        while (this.itokens < this.tokens.length && this.tokens[this.itokens] != ">") {
            block3: {
                block5: {
                    block4: {
                        if (this.tokens[this.itokens].equals("")) break block3;
                        if (!Dic.isALexicalSymbol(this.tokens[this.itokens])) break block4;
                        c = new STree(this.tokens[this.itokens], this.shell.getPanel1());
                        ** GOTO lbl18
                    }
                    if (this.tokens[this.itokens].charAt(0) != '<') break block5;
                    c = this.parse();
                    ** GOTO lbl18
                }
                if (this.tokens[this.itokens].charAt(0) != '$') {
                    t.label = String.valueOf(t.label) + this.tokens[this.itokens];
                } else {
                    c = new STree(this.tokens[this.itokens], this.shell.getPanel1());
lbl18:
                    // 3 sources

                    t.addChild(c);
                }
            }
            ++this.itokens;
        }
        return t;
    }

    private STree parseSyntacticAnalysis(String buffer, boolean derivationtree) {
        String tok;
        int n;
        String sep = "[#]";
        this.tokens = buffer.split(sep);
        if ((this.tokens == null || this.tokens.length < 2) && buffer.charAt(buffer.length() - 1) != '#') {
            return null;
        }
        ArrayList<String> nodes = new ArrayList<String>();
        if (derivationtree) {
            nodes.add("<Main");
            String[] stringArray = this.tokens;
            int n2 = this.tokens.length;
            n = 0;
            while (n < n2) {
                tok = stringArray[n];
                if (tok.equals(":")) {
                    nodes.add(">");
                } else if (tok.length() > 1 && tok.charAt(0) == ':') {
                    nodes.add("<" + tok.substring(1));
                } else if (tok.length() > 2 && tok.charAt(0) == '<' && tok.charAt(tok.length() - 1) == '>') {
                    nodes.add(tok);
                }
                ++n;
            }
            nodes.add(">");
        } else {
            String[] stringArray = this.tokens;
            int n3 = this.tokens.length;
            n = 0;
            while (n < n3) {
                tok = stringArray[n];
                if (tok.length() != 0 && tok.charAt(0) != ':') {
                    nodes.add(tok);
                }
                ++n;
            }
        }
        String roottok = (String)nodes.get(0);
        if (roottok != null && !roottok.equals("") && roottok.charAt(0) != '<') {
            nodes.add(0, "<NOSTRUCTURE");
            nodes.add(">");
        }
        this.tokens = nodes.toArray(new String[nodes.size()]);
        this.itokens = 0;
        STree t = this.parse();
        return t;
    }

    public void resetEntry(Graphics grphcs) {
        int margin;
        Graphics2D g = (Graphics2D)grphcs;
        if (this.shell == null) {
            return;
        }
        this.shell.getlConcEntries().setText("Concordance Entry / " + this.shell.getConcordanceShellController().getTheItems().size() / 4);
        this.shell.getTbUnitNumber().setText(Integer.toString(this.concordanceIndex + 1));
        Object[] citem = (Object[])this.shell.getConcordanceShellController().getTheItems().get(this.concordanceIndex * 4 + 1);
        ArrayList ctag = (ArrayList)citem[5];
        ArrayList annotation = (ArrayList)ctag.get(1);
        String input = (String)citem[2];
        if (input.indexOf(47) != -1) {
            input = input.substring(0, input.indexOf(47));
        }
        String output = (String)annotation.get(1);
        this.shell.getLabel1().setFont(Launcher.preferences.TFont);
        this.shell.getLabel1().setText(input);
        this.tree = this.parseSyntacticAnalysis(output, this.shell.getRbDerivationTree().isSelected());
        if (this.tree == null) {
            this.shell.dispose();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There is no structural information in the concordance", "NooJ", 1);
            return;
        }
        this.shell.getPanel1().setFont(Launcher.preferences.DFont);
        FontMetrics metrics = g.getFontMetrics(this.shell.getPanel1().getFont());
        int depth = this.tree.computeDepth();
        STree.LINE = metrics.getHeight();
        int panelheight = depth * STree.LINE * 5 + STree.LINE;
        this.tree.computeYPosition(panelheight, STree.LINE * 5);
        STree.currentleftposition = margin = metrics.stringWidth("MMMM");
        this.tree.computeWidth(grphcs, this.shell.getPanel1().getFont(), this.shell.getCbDisplayAll().isSelected());
        this.tree.computeXPosition(margin);
        int panelwidth = STree.currentleftposition;
        this.shell.getPanel1().setSize(new Dimension(panelwidth, panelheight));
        this.shell.getLabel1().setSize(new Dimension(panelwidth, this.shell.getLabel1().getHeight()));
    }

    public SyntacticTreeShell getShell() {
        return this.shell;
    }

    public STree getTree() {
        return this.tree;
    }

    public int getConcordanceIndex() {
        return this.concordanceIndex;
    }

    public void setConcordanceIndex(int concordanceIndex) {
        if (concordanceIndex >= this.shell.getConcordanceShellController().getTheItems().size() / 4) {
            concordanceIndex = this.shell.getConcordanceShellController().getTheItems().size() / 4 - 1;
        }
        if (concordanceIndex < 0) {
            concordanceIndex = 0;
        }
        this.concordanceIndex = concordanceIndex;
    }
}

