/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.CorpusEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class CloseInternalFrameListener
implements InternalFrameListener {
    private TextEditorShellController textController;
    private CorpusEditorShellController corpusController;
    private JInternalFrame frame;

    public CloseInternalFrameListener(TextEditorShellController textController, JInternalFrame frame, CorpusEditorShellController corpusController) {
        this.textController = textController;
        this.corpusController = corpusController;
        this.frame = frame;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        int answer;
        this.frame.setDefaultCloseOperation(2);
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot close window: Press 'Cancel'", "NooJ: a process is running", 1);
            this.frame.setDefaultCloseOperation(0);
            return;
        }
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            CorpusEditorShell corpusEditorShell = this.corpusController.getShell();
            if (corpusEditorShell != null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please close corpus before quitting", "NooJ: a corpus is opened", 2);
                return;
            }
            this.corpusController.setBeingClosed(true);
        }
        TextEditorShell textEditorShell = this.textController.getTextShell();
        ConcordanceShellController concordanceController = this.textController.getConcordanceController();
        if (textEditorShell.getAlphabetDialog() != null) {
            textEditorShell.getAlphabetDialog().dispose();
        }
        if (textEditorShell.getTokensDialog() != null) {
            textEditorShell.getTokensDialog().dispose();
        }
        if (textEditorShell.getDigramsDialog() != null) {
            textEditorShell.getDigramsDialog().dispose();
        }
        if (textEditorShell.getAmbiguitiesDialog() != null) {
            textEditorShell.getAmbiguitiesDialog().dispose();
        }
        if (textEditorShell.getUnAmbiguitiesDialog() != null) {
            textEditorShell.getUnAmbiguitiesDialog().dispose();
        }
        if (textEditorShell.getFindReplaceDialog() != null) {
            textEditorShell.getFindReplaceDialog().dispose();
        }
        if (concordanceController != null) {
            concordanceController.getConcordanceShell().dispose();
            this.textController.setConcordanceController(null);
            concordanceController.setTableModel(null);
            CustomForegroundTableRenderer customForegroundTableRenderer = (CustomForegroundTableRenderer)concordanceController.getConcordanceTable().getDefaultRenderer(Object.class);
            customForegroundTableRenderer.setSortedPreview(false);
            customForegroundTableRenderer.setColoredRowsMap(new HashMap<Integer, Color>());
        }
        if (textEditorShell.getLocateDialog() != null) {
            textEditorShell.getLocateDialog().dispose();
        }
        if (textEditorShell.getExportXmlDialog() != null) {
            textEditorShell.getExportXmlDialog().dispose();
        }
        if (this.textController.isModified() && !Launcher.projectMode && (answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save Text?", "NooJ: text results have not been saved", 0)) == 0) {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.textController.saveText();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }
}

