/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AlphabetDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import net.nooj4nlp.gui.utilities.Helper;

public class ComputeMouseAdapterForText
extends MouseAdapter {
    private TextEditorShellController controller;
    private TextEditorShell textShell;
    private Ntext myText;
    private JTextPane textPane;
    private JList list;
    private AlphabetDialog alphabetDialog;
    private TokensDigramsDialog tokensDialog;
    private TokensDigramsDialog digramsDialog;
    private AmbiguitiesUnambiguitiesDialog ambiguitiesDialog;
    private AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog;

    public ComputeMouseAdapterForText(TextEditorShellController controller) {
        this.controller = controller;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        block21: {
            if (e.getClickCount() != 2) return;
            try {
                this.textShell = this.controller.getTextShell();
                CursorChangeEffect.setCustomCursor(3);
                this.myText = this.controller.getMyText();
                this.textPane = this.textShell.getTextPane();
                this.list = this.textShell.getListOfResults();
                if (this.controller.isTextWasEdited() || this.myText.buffer.equals("")) {
                    this.myText.buffer = this.textPane.getText().replace("\r", "");
                    this.controller.setTextWasEdited(false);
                    this.myText.mft = null;
                }
                this.textPane.setEditable(false);
                int index = this.list.locationToIndex(e.getPoint());
                ListModel listModel = this.list.getModel();
                Object item = listModel.getElementAt(index);
                this.list.ensureIndexIsVisible(index);
                if (item.equals("Characters")) {
                    this.alphabetDialog = this.textShell.getAlphabetDialog();
                    if (this.alphabetDialog != null) {
                        Helper.putDialogOnTheTop(this.alphabetDialog);
                        return;
                    }
                    this.alphabetDialog = new AlphabetDialog(null, this.controller);
                    this.alphabetDialog.fillInTheData(false);
                    this.textShell.setAlphabetDialog(this.alphabetDialog);
                    Launcher.getDesktopPane().add(this.alphabetDialog);
                    this.alphabetDialog.setVisible(true);
                    Helper.putDialogOnTheTop(this.alphabetDialog);
                    break block21;
                }
                if (item.equals("Tokens")) {
                    if (this.myText.annotations == null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please perform linguistic analysis first.", "NooJ", 1);
                        return;
                    }
                    this.tokensDialog = this.textShell.getTokensDialog();
                    if (this.tokensDialog != null) {
                        Helper.putDialogOnTheTop(this.tokensDialog);
                        return;
                    }
                    this.tokensDialog = new TokensDigramsDialog(null, this.controller, true);
                    this.tokensDialog.fillInTheData();
                    this.textShell.setTokensDialog(this.tokensDialog);
                    Launcher.getDesktopPane().add(this.tokensDialog);
                    this.tokensDialog.setVisible(true);
                    Helper.putDialogOnTheTop(this.tokensDialog);
                    break block21;
                }
                if (item.equals("Digrams")) {
                    if (this.myText.annotations == null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please perform linguistic analysis first.", "NooJ", 1);
                        return;
                    }
                    this.digramsDialog = this.textShell.getDigramsDialog();
                    if (this.digramsDialog != null) {
                        Helper.putDialogOnTheTop(this.digramsDialog);
                        return;
                    }
                    this.digramsDialog = new TokensDigramsDialog(null, this.controller, false);
                    this.digramsDialog.fillInTheData();
                    this.textShell.setDigramsDialog(this.digramsDialog);
                    Launcher.getDesktopPane().add(this.digramsDialog);
                    this.digramsDialog.setVisible(true);
                    Helper.putDialogOnTheTop(this.digramsDialog);
                    break block21;
                }
                if (item.equals("Annotations")) {
                    DictionaryEditorShell annotationsEditor = new DictionaryEditorShell();
                    this.controller.fillInVocabulary(annotationsEditor);
                    annotationsEditor.getLblnTus().setText("Vocabulary contains " + DictionaryDialogController.count(annotationsEditor.getTextPane()) + " entries.");
                    Launcher.getDesktopPane().add(annotationsEditor);
                    annotationsEditor.setVisible(true);
                    annotationsEditor.getController().modify();
                    break block21;
                }
                if (item.equals("Unknowns")) {
                    DictionaryEditorShell unknownsEditor = new DictionaryEditorShell();
                    this.controller.fillInUnknowns(unknownsEditor);
                    unknownsEditor.getLblnTus().setText("Unknowns are " + DictionaryDialogController.count(unknownsEditor.getTextPane()) + " entries.");
                    Launcher.getDesktopPane().add(unknownsEditor);
                    unknownsEditor.setVisible(true);
                    unknownsEditor.getController().modify();
                    break block21;
                }
                if (item.equals("Ambiguities")) {
                    this.ambiguitiesDialog = this.textShell.getAmbiguitiesDialog();
                    if (this.ambiguitiesDialog != null) {
                        Helper.putDialogOnTheTop(this.ambiguitiesDialog);
                        return;
                    }
                    this.ambiguitiesDialog = new AmbiguitiesUnambiguitiesDialog(null, this.controller, true);
                    this.ambiguitiesDialog.fillInTheData();
                    this.textShell.setAmbiguitiesDialog(this.ambiguitiesDialog);
                    Launcher.getDesktopPane().add(this.ambiguitiesDialog);
                    this.ambiguitiesDialog.setVisible(true);
                    Helper.putDialogOnTheTop(this.ambiguitiesDialog);
                    break block21;
                }
                if (item.equals("Unambiguous Words")) {
                    this.unAmbiguitiesDialog = this.textShell.getUnAmbiguitiesDialog();
                    if (this.unAmbiguitiesDialog != null) {
                        Helper.putDialogOnTheTop(this.unAmbiguitiesDialog);
                        return;
                    }
                    this.unAmbiguitiesDialog = new AmbiguitiesUnambiguitiesDialog(null, this.controller, false);
                    this.unAmbiguitiesDialog.fillInTheData();
                    this.textShell.setUnAmbiguitiesDialog(this.unAmbiguitiesDialog);
                    Launcher.getDesktopPane().add(this.unAmbiguitiesDialog);
                    this.unAmbiguitiesDialog.setVisible(true);
                    Helper.putDialogOnTheTop(this.unAmbiguitiesDialog);
                }
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
                JMenu mnText = this.controller.getTextShell().getMnText();
                mnText.setVisible(false);
            }
        }
        JCheckBox cbTAS = this.textShell.getChckbxShowTextAnnotation();
        if (cbTAS.isSelected()) {
            Container container = this.textShell.getContentPane();
            cbTAS.setSelected(false);
            JSplitPane splitPane = this.textShell.getSplitPane();
            JScrollPane textScroll = this.textShell.getScrollPane();
            JScrollPane panelScroll = this.textShell.getPanelScrollPane();
            this.textShell.getTasActionListener().start(container, cbTAS, splitPane, textScroll, panelScroll, this.controller);
        }
        this.controller.modify();
    }
}

