/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.CorpusEditorShell.AddActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.dialogs.TextCorpusDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ImportTextActionListener
implements ActionListener {
    private TextCorpusDialog dialog;
    private JList languages;
    public static boolean xmlButtonChecked = false;
    private boolean corpus;
    private File fileToBeImported;

    public ImportTextActionListener(JList listOfLanguages, TextCorpusDialog dialog, boolean corpus, File fileToBeImported) {
        this.dialog = dialog;
        this.languages = listOfLanguages;
        this.corpus = corpus;
        this.fileToBeImported = fileToBeImported;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String chartName;
        File fileCharvians;
        String delimiterPattern;
        int encodingType;
        String directory3;
        File dir3;
        String directory2;
        File dir2;
        int selectedIndex;
        if (TextCorpusDialog.getRdbtnPerlRegExpr().isSelected()) {
            JComboBox comboPerl = TextCorpusDialog.getComboPerl();
            selectedIndex = comboPerl.getSelectedIndex();
            List<String> perlList = Launcher.getRegexMemoryList();
            if (selectedIndex == -1) {
                selectedIndex = comboPerl.getItemCount();
                perlList.add(comboPerl.getSelectedItem().toString());
                Launcher.setRegexMemoryList(perlList);
            }
            Launcher.setCorpusTextRadioButtonSelectionMemory(3);
            Launcher.setRegexMemoryIndex(selectedIndex);
        } else if (TextCorpusDialog.getRdbtnXmlTextNodes().isSelected()) {
            JComboBox comboXml = TextCorpusDialog.getComboXml();
            selectedIndex = comboXml.getSelectedIndex();
            List<String> xmlList = Launcher.getXmlMemoryList();
            if (selectedIndex == -1) {
                selectedIndex = comboXml.getItemCount();
                xmlList.add(comboXml.getSelectedItem().toString());
                Launcher.setXmlMemoryList(xmlList);
            }
            Launcher.setCorpusTextRadioButtonSelectionMemory(4);
            Launcher.setXmlMemoryIndex(selectedIndex);
        } else if (TextCorpusDialog.getRdbtnNoDelimiterwhole().isSelected()) {
            Launcher.setCorpusTextRadioButtonSelectionMemory(1);
        } else {
            Launcher.setCorpusTextRadioButtonSelectionMemory(2);
        }
        String languageName = this.languages.getSelectedValue().toString();
        String directory = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + languageName;
        File dir = new File(directory);
        if (!dir.exists()) {
            new File(directory).mkdir();
        }
        if (!(dir2 = new File(directory2 = String.valueOf(directory) + System.getProperty("file.separator") + "Lexical Analysis")).exists()) {
            new File(directory2).mkdir();
        }
        if (!(dir3 = new File(directory3 = String.valueOf(directory) + System.getProperty("file.separator") + "Syntactic Analysis")).exists()) {
            new File(directory3).mkdir();
        }
        String encodingCode = null;
        String encodingName = "";
        if (this.dialog.getRdbtnAsciiUnicode().isSelected()) {
            encodingType = 1;
            encodingCode = null;
            encodingName = "Default";
        } else if (TextCorpusDialog.getRdbtnOtherRawText().isSelected()) {
            encodingType = 2;
            String fmt = TextCorpusDialog.getListFFormats().getSelectedValue().toString();
            try {
                Charset enc = Charset.forName(fmt.substring(0, fmt.indexOf(91)));
                encodingCode = enc.name();
                encodingName = enc.displayName();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.toString(), "NooJ: Cannot handle encoding #" + encodingType, 1);
                encodingCode = null;
                encodingName = "Default";
            }
        } else if (this.dialog.getRdbtnRichTextFormat().isSelected()) {
            encodingType = 3;
            encodingName = "RTF";
        } else if (this.dialog.getRdbtndoc().isSelected()) {
            encodingType = 4;
            encodingName = "WORD";
        } else if (this.dialog.getRdbtnHtmlPage().isSelected()) {
            encodingType = 5;
            encodingName = "HTML";
        } else if (this.dialog.getRdbtnPdfDocument().isSelected()) {
            encodingType = 6;
            encodingName = "PDF";
        } else {
            encodingType = 7;
            encodingCode = null;
            encodingName = "Default";
        }
        Language lan = new Language(languageName);
        String[] xmlTags = null;
        if (TextCorpusDialog.getRdbtnLineDelimiter().isSelected()) {
            delimiterPattern = "\n";
        } else if (TextCorpusDialog.getRdbtnPerlRegExpr().isSelected()) {
            delimiterPattern = TextCorpusDialog.getComboPerl().getSelectedItem().toString();
        } else if (TextCorpusDialog.getRdbtnXmlTextNodes().isSelected()) {
            xmlButtonChecked = true;
            delimiterPattern = "";
            String comboString = TextCorpusDialog.getComboXml().getSelectedItem().toString();
            ArrayList<String> tmp = new ArrayList<String>();
            int i = 0;
            while (i < comboString.length()) {
                if (comboString.charAt(i) == '<') {
                    int j = 0;
                    while (i + j < comboString.length() && comboString.charAt(j) != '>') {
                        ++j;
                    }
                    tmp.add(comboString.substring(i, j + 1 - i));
                    i += j;
                    break;
                }
                ++i;
            }
            xmlTags = new String[tmp.size()];
            int k = 0;
            while (k < tmp.size()) {
                xmlTags[k] = (String)tmp.get(k);
                ++k;
            }
        } else {
            delimiterPattern = "";
        }
        boolean i = false;
        if (i < true && !(fileCharvians = new File(chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "charvariants.txt")).exists()) {
            chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "_charvariants.txt";
            fileCharvians = new File(chartName);
            if (!fileCharvians.exists()) {
                chartName = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + lan.isoName + System.getProperty("file.separator") + "Lexical Analysis" + System.getProperty("file.separator") + "_charvariants.txt";
                fileCharvians = new File(chartName);
                if (fileCharvians.exists()) {
                    AddActionListener.tryToLoadCharVariants(chartName, lan);
                }
            } else {
                AddActionListener.tryToLoadCharVariants(chartName, lan);
            }
        }
        if (!this.corpus) {
            TextEditorShellController textController = new TextEditorShellController(this.fileToBeImported);
            textController.suiteFunction(lan, languageName, delimiterPattern, xmlTags, encodingType, encodingCode, encodingName);
            this.dialog.dispose();
        } else {
            File corpusDirectory = this.fileToBeImported.getParentFile();
            String corpusName = FilenameUtils.removeExtension(this.fileToBeImported.getName());
            CorpusEditorShellController controller = new CorpusEditorShellController(null, null, null, null);
            controller.createAndSaveNewCorpus(delimiterPattern, xmlTags, encodingType, encodingCode, encodingName, languageName, corpusDirectory, corpusName);
            this.dialog.dispose();
            controller.openNoojCorpus(new File(String.valueOf(corpusDirectory.getPath()) + System.getProperty("file.separator") + corpusName + "." + "jnoc"), true);
            controller.openNoojEngine();
        }
    }
}

