/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.JMftPanelMouseAdapter;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class JMftPanel
extends JPanel {
    private static final long serialVersionUID = 1000554144734771086L;
    private TuGraph tuGraph;
    private JScrollPane parentScrollPane;
    private TextEditorShellController textController;
    private double selectAllAnnotationsAtPosition;

    public JMftPanel(TextEditorShellController textController) {
        this.textController = textController;
        this.selectAllAnnotationsAtPosition = textController.getSelectAllAnnotationsAtPosition();
        this.setLayout(null);
        this.addMouseListener(new JMftPanelMouseAdapter(textController));
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        TextEditorShell textShell = this.textController.getTextShell();
        this.textController.setTuGraph((Integer)textShell.getSpinner().getValue());
        this.tuGraph = this.textController.getTuGraph();
        CorpusEditorShellController corpusController = textShell.getCorpusController();
        Ntext myText = this.textController.getMyText();
        if (corpusController != null && corpusController.getShell() != null) {
            myText.annotations = corpusController.getCorpus().annotations;
        }
        if (this.tuGraph == null || myText.annotations == null) {
            return;
        }
        if (this.tuGraph.needToBeComputed) {
            this.tuGraph.computeDrawing(myText.annotations, this, g);
        }
        this.tuGraph.draw(myText.annotations, this.selectAllAnnotationsAtPosition, this, g);
        super.paintChildren(g);
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public void setTextController(TextEditorShellController textController) {
        this.textController = textController;
    }

    public JScrollPane getParentScrollPane() {
        return this.parentScrollPane;
    }

    public void setParentScrollPane(JScrollPane parentScrollPane) {
        this.parentScrollPane = parentScrollPane;
    }

    public double getSelectAllAnnotationsAtPosition() {
        return this.selectAllAnnotationsAtPosition;
    }

    public void setSelectAllAnnotationsAtPosition(double selectAllAnnotationsAtPosition) {
        this.selectAllAnnotationsAtPosition = selectAllAnnotationsAtPosition;
    }
}

