/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class OpenTextFromCorpusActionListener
extends MouseAdapter {
    private JTable table;
    private CorpusEditorShellController controller;
    private Corpus corpus;
    private static String clickedFilePath;

    public OpenTextFromCorpusActionListener(CorpusEditorShellController controller, JTable table) {
        this.controller = controller;
        this.table = table;
        this.corpus = this.controller.getCorpus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int index = this.table.getSelectedRow();
            index = this.controller.getTableTexts().convertRowIndexToModel(index);
            TableModel model = this.table.getModel();
            String fileName = String.valueOf(((DefaultTableModel)model).getValueAt(index, 0).toString()) + "." + "jnot";
            String corpusParentPath = new File(this.controller.getFullPath()).getParent();
            clickedFilePath = String.valueOf(corpusParentPath) + System.getProperty("file.separator") + this.controller.getFullName() + "_dir" + System.getProperty("file.separator") + fileName;
            Ntext myText = null;
            try {
                myText = Ntext.loadForCorpus(clickedFilePath, this.corpus.lan, this.corpus.multiplier);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while loading text for corpus!", 0);
                return;
            }
            if (myText == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load Text " + fileName, "NooJ: No text", 0);
                return;
            }
            try {
                MouseListener rightClickListener;
                CursorChangeEffect.setCustomCursor(3);
                myText.annotations = this.corpus.annotations;
                boolean modifyAndUpdate = false;
                if (myText.mft == null) {
                    modifyAndUpdate = true;
                    String errorMessage = this.controller.getEngine().delimitTextUnits(myText);
                    if (!errorMessage.equals("")) {
                        Dic.writeLog(errorMessage);
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error!", 0);
                        return;
                    }
                }
                TextEditorShell textShell = null;
                if (this.controller.getShell().getTextEditorShell() == null) {
                    textShell = new TextEditorShell(this.controller, myText, fileName, myText.getDelimPattern(), false);
                    rightClickListener = textShell.getRightClickListener();
                    textShell.removeMouseListener(rightClickListener);
                    textShell.getTextPane().removeMouseListener(rightClickListener);
                    this.controller.getShell().setTextEditorShell(textShell);
                    textShell.getTextController().setFileToBeOpenedOrImported(new File(clickedFilePath));
                    this.controller.setTextController(textShell.getTextController());
                } else {
                    this.controller.getTextShell().dispose();
                    textShell = new TextEditorShell(this.controller, myText, fileName, myText.getDelimPattern(), false);
                    rightClickListener = textShell.getRightClickListener();
                    textShell.getTextPane().removeMouseListener(rightClickListener);
                    textShell.removeMouseListener(rightClickListener);
                    textShell.getTextController().setFileToBeOpenedOrImported(new File(clickedFilePath));
                    textShell.getTextController().resetShellText();
                    this.controller.setTextController(textShell.getTextController());
                }
                textShell.getLblnTus().setText("/ " + textShell.getText().nbOfTextUnits + " TUs");
                if (modifyAndUpdate) {
                    textShell.getTextController().modify();
                    textShell.getTextController().updateTextPaneStats();
                }
                UnitSelectionListener unitSelectionListener = textShell.getUnitSelectionListener();
                JTextPane textPane = textShell.getTextPane();
                textPane.removeCaretListener(unitSelectionListener);
                textShell.getTextController().rtbTextUpdate(true);
                textPane.addCaretListener(unitSelectionListener);
                Launcher.getDesktopPane().add(textShell);
                textShell.setVisible(true);
                textShell.getUnitSelectionListener().paintTextInRGB();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    public static String getClickedFilePath() {
        return clickedFilePath;
    }
}

