/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;

public class TASactionListener
implements ActionListener {
    private JCheckBox tasCheckBox;
    private JScrollPane textScroll;
    private JScrollPane tasScroll;
    private Container container;
    private JSplitPane splitPane;
    private TextEditorShellController textController;
    private int dividerActualPosition = 0;

    public TASactionListener(Container container, JCheckBox tasCheckBox, JSplitPane splitPane, JScrollPane textScroll, JScrollPane tasScroll, TextEditorShellController textController) {
        this.tasCheckBox = tasCheckBox;
        this.textScroll = textScroll;
        this.tasScroll = tasScroll;
        this.container = container;
        this.splitPane = splitPane;
        this.textController = textController;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.start(this.container, this.tasCheckBox, this.splitPane, this.textScroll, this.tasScroll, this.textController);
    }

    public void start(Container container, JCheckBox tasCheckBox, JSplitPane splitPane, JScrollPane textScroll, JScrollPane tasScroll, TextEditorShellController textController) {
        if (tasCheckBox.isSelected()) {
            try {
                CursorChangeEffect.setCustomCursor(3);
                textScroll.setVisible(false);
                container.remove(textScroll);
                splitPane.setTopComponent(textScroll);
                splitPane.setBottomComponent(tasScroll);
                textScroll.setVisible(true);
                splitPane.setVisible(true);
                if (this.dividerActualPosition != 0) {
                    splitPane.setDividerLocation(this.dividerActualPosition);
                }
                textController.setTuGraph((Integer)textController.getTextShell().getSpinner().getValue());
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        } else {
            this.dividerActualPosition = splitPane.getDividerLocation();
            textScroll.setVisible(false);
            splitPane.remove(textScroll);
            splitPane.remove(tasScroll);
            splitPane.setVisible(false);
            textScroll.setVisible(true);
            container.add((Component)textScroll, "cell 0 3, span 3, grow, hidemode 2");
        }
        container.invalidate();
        container.validate();
        container.repaint();
    }
}

