/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.ImportTextActionListener;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TextIO;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.engine.Utilities;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.dialogs.TextCorpusDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class TextEditorShellController {
    private boolean modified;
    private boolean colored = false;
    private TextEditorShell textShell;
    private Engine engine;
    private JTextPane paneOfTextEditor;
    private boolean textIsBeingColored = false;
    private Ntext myText;
    private boolean currentTextUnitIsBlack;
    private File fileToBeOpenedOrImported;
    private boolean textWasEdited = false;
    private String textName;
    private List<String> locateGrammarMemoryList = new ArrayList<String>();
    private List<String> locateRegexMemoryList = new ArrayList<String>();
    private CorpusEditorShellController corpusController;
    private ConcordanceShellController concordanceController;
    private Corpus corpus;
    private boolean NooJRightToLeft;
    private JTextArea textInfo;
    private List<Color> listOfColors = null;
    private List<Integer> absoluteBeginAddresses = null;
    private List<Integer> absoluteEndAddresses = null;
    private TuGraph tuGraph;
    private double selectAllAnnotationsAtPosition;
    private ArrayList<Object> annotationsHistoric;

    public TextEditorShellController(TextEditorShell shell) {
        this.textShell = shell;
        this.corpusController = this.textShell.getCorpusController();
        this.myText = this.textShell.getText();
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            this.engine = this.corpusController.getEngine();
            JList resultsList = this.textShell.getListOfResults();
            resultsList.setVisible(false);
            this.textShell.getScrollList().setVisible(false);
            this.textInfo = this.textShell.getTxtInfo();
            this.textInfo.setVisible(false);
        } else {
            this.startNoojEngine();
        }
        this.NooJRightToLeft = this.myText.Lan.rightToLeft;
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributeSet, this.NooJRightToLeft ? 2 : 0);
        StyleConstants.setFontFamily(attributeSet, Launcher.preferences.TFont.getFamily());
        StyleConstants.setFontSize(attributeSet, Launcher.preferences.TFont.getSize());
        this.paneOfTextEditor = this.textShell.getTextPane();
        if (this.myText.buffer != null) {
            this.paneOfTextEditor.getStyledDocument().setParagraphAttributes(0, this.myText.buffer.length(), attributeSet, true);
        } else {
            this.paneOfTextEditor.getStyledDocument().setParagraphAttributes(0, 0, attributeSet, true);
        }
        this.fileToBeOpenedOrImported = null;
    }

    public TextEditorShellController(File fileToBeOpenedOrImported) {
        this.fileToBeOpenedOrImported = fileToBeOpenedOrImported;
        this.textName = fileToBeOpenedOrImported.getName();
    }

    public TextEditorShell openText(File file) {
        this.fileToBeOpenedOrImported = file;
        this.textName = this.fileToBeOpenedOrImported.getName();
        try {
            this.myText = Ntext.load(file.getAbsolutePath(), Launcher.preferences.deflanguage, new RefObject<String>("error"));
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + file.getName(), "NooJ Error!", 0);
            return null;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + file.getName(), "NooJ Error!", 0);
            return null;
        }
        if (this.myText == null || this.myText.buffer == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Nooj: Text file is corrupted!", "NooJ error", 0);
            return null;
        }
        this.startNoojEngine();
        String errorMessage = "";
        if (this.myText.mft == null) {
            errorMessage = this.engine.delimitTextUnits(this.myText);
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error! " + errorMessage, 0);
                return null;
            }
            this.textShell = new TextEditorShell(null, this.myText, file.getName(), this.myText.getDelimPattern(), false);
            if (this.textShell != null) {
                this.textShell.refreshListenersAndAdapters();
                TextEditorShellController controller = this.textShell.getTextController();
                controller.fileToBeOpenedOrImported = this.fileToBeOpenedOrImported;
                controller.textName = this.fileToBeOpenedOrImported.getName();
                UnitSelectionListener unitSelectionListener = this.textShell.getUnitSelectionListener();
                this.textShell.getTextPane().removeCaretListener(unitSelectionListener);
                controller.rtbTextUpdate(true);
                this.textShell.getTextPane().addCaretListener(unitSelectionListener);
                controller.updateTextPaneStats();
            }
            this.modify();
        } else {
            this.textShell = new TextEditorShell(null, this.myText, file.getName(), this.myText.getDelimPattern(), false);
            if (this.textShell != null) {
                this.textShell.refreshListenersAndAdapters();
                TextEditorShellController controller = this.textShell.getTextController();
                controller.fileToBeOpenedOrImported = this.fileToBeOpenedOrImported;
                controller.textName = this.fileToBeOpenedOrImported.getName();
                UnitSelectionListener unitSelectionListener = this.textShell.getUnitSelectionListener();
                this.textShell.getTextPane().removeCaretListener(unitSelectionListener);
                controller.rtbTextUpdate(true);
                this.textShell.getTextPane().addCaretListener(unitSelectionListener);
                controller.updateTextPaneStats();
            }
        }
        Launcher.getDesktopPane().add(this.textShell);
        this.textShell.setVisible(true);
        return this.textShell;
    }

    public void importText(File selectedFile) {
        this.fileToBeOpenedOrImported = selectedFile;
        this.textName = this.fileToBeOpenedOrImported.getName();
        TextCorpusDialog dialog = new TextCorpusDialog(false, true, Launcher.lastActive, this.fileToBeOpenedOrImported);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Import a text");
        dialog.getListLanguages().setSelectedValue(Launcher.preferences.deflanguage, false);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public void rtbTextUpdate(boolean aNewText) {
        this.textIsBeingColored = false;
        JCheckBox cBox = this.textShell.getChckbxShowTextAnnotation();
        CustomJSpinner spinner = this.textShell.getSpinner();
        this.paneOfTextEditor = this.textShell.getTextPane();
        if (aNewText) {
            this.paneOfTextEditor.setText(this.myText.buffer);
            this.paneOfTextEditor.getDocument().putProperty("__EndOfLine__", "\r\n");
            this.paneOfTextEditor.setCaretPosition(0);
        }
        if (this.myText.mft == null) {
            spinner.setEnabled(false);
            if (cBox.isSelected()) {
                cBox.setSelected(false);
            }
            cBox.setEnabled(false);
            this.setTextColorOfAPane(this.paneOfTextEditor, Color.BLACK);
            return;
        }
        if (!spinner.isEnabled()) {
            spinner.setEnabled(true);
        }
        if ((Integer)spinner.getValue() > this.myText.nbOfTextUnits) {
            spinner.setValue(this.myText.nbOfTextUnits);
        } else if ((Integer)spinner.getValue() < 1) {
            spinner.setCustomValue(1);
        }
        ArrayList<Object> annotations = new ArrayList();
        annotations = this.corpus != null ? this.corpus.annotations : this.myText.getAnnotations();
        if (annotations != null && this.myText.mft != null) {
            cBox.setEnabled(true);
            if (cBox.isSelected()) {
                int currentUnit = (Integer)spinner.getValue();
                this.tuGraph = this.myText.mft.getTuGraph(currentUnit, this.tuGraph);
                if (this.tuGraph != null) {
                    this.tuGraph.setNeedToBeComputed(true);
                }
                this.textShell.invalidate();
                this.textShell.validate();
                this.textShell.repaint();
            }
            this.textShell.getUnitSelectionListener().partialColorText(this, this.myText, this.paneOfTextEditor, this.textShell, true);
        }
    }

    private void setTextColorOfAPane(JTextPane textPane, Color color) {
        MutableAttributeSet attributes = textPane.getInputAttributes();
        StyleConstants.setForeground(attributes, color);
        StyledDocument doc = textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attributes, true);
    }

    private void startNoojEngine() {
        this.engine = new Engine(new RefObject<Language>(this.myText.Lan), Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
    }

    public void updateTextPaneStats() {
        this.textShell.getTxtInfo().setText("");
        StringBuilder textToBeSet = new StringBuilder();
        textToBeSet.append("Language is \"" + this.myText.Lan.engName + "\" (" + this.myText.Lan.isoName + ").\n");
        String[] xmlNodes = this.myText.XmlNodes;
        if (xmlNodes != null) {
            textToBeSet.append("XML Text Nodes are: ");
            String[] stringArray = xmlNodes;
            int n = xmlNodes.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                textToBeSet.append(String.valueOf(tag) + " ");
                ++n2;
            }
            textToBeSet.append("\n");
        } else if (this.myText.getDelimPattern().equals("")) {
            textToBeSet.append("Text has no delimiter => processed as one TU\n");
        } else if (this.myText.getDelimPattern().equals("\n")) {
            textToBeSet.append("Text Delimiter is: \\n (NEWLINE)\n");
        } else {
            textToBeSet.append("Text Delimiter is: \"" + this.myText.getDelimPattern() + "\"\n");
        }
        if (this.myText.nbOfTextUnits > 1) {
            textToBeSet.append("Text contains " + this.myText.nbOfTextUnits + " Text Units (TUs).\n");
        }
        if (this.myText.nbOfChars > 1 && this.myText.nbOfDiffChars > 1) {
            textToBeSet.append(String.valueOf(this.myText.nbOfChars) + " characters " + "(" + this.myText.nbOfDiffChars + " diff), including\n");
        }
        if (this.myText.nbOfLetters > 1 && this.myText.nbOfDiffLetters > 1) {
            textToBeSet.append("  " + this.myText.nbOfLetters + " letters  (" + this.myText.nbOfDiffLetters + " diff),\n");
        }
        if (this.myText.nbOfDigits > 1 && this.myText.nbOfDiffDigits > 1) {
            textToBeSet.append("  " + this.myText.nbOfDigits + " digits  (" + this.myText.nbOfDiffDigits + " diff),\n");
        }
        if (this.myText.nbOfBlanks > 1 && this.myText.nbOfDiffBlanks > 1) {
            textToBeSet.append("  " + this.myText.nbOfBlanks + " blanks  (" + this.myText.nbOfDiffBlanks + " diff),\n");
        }
        if (this.myText.nbOfDelimiters > 1 && this.myText.nbOfDiffDelimiters > 1) {
            textToBeSet.append("  " + this.myText.nbOfDelimiters + " other delimiters  (" + this.myText.nbOfDiffDelimiters + " diff),\n");
        }
        if (this.myText.nbOfTokens > 1) {
            textToBeSet.append(String.valueOf(this.myText.nbOfTokens) + " tokens ");
            if (this.myText.nbOfDiffTokens > 1) {
                textToBeSet.append(" (" + this.myText.nbOfDiffTokens + " diff) including:\n");
            }
            if (this.myText.nbOfWords > 1) {
                textToBeSet.append(String.valueOf(this.myText.nbOfWords) + " word forms\n");
            }
            if (this.myText.nbOfDiffWords > 1) {
                textToBeSet.append(" (" + this.myText.nbOfDiffWords + " diff)");
            }
            if (this.myText.nbOfDigits > 1) {
                textToBeSet.append(String.valueOf(this.myText.nbOfDigits) + " digits\n");
            }
            if (this.myText.nbOfDiffDigits > 1) {
                textToBeSet.append(" (" + this.myText.nbOfDiffDigits + " diff)");
            }
            if (this.myText.nbOfDelimiters > 1) {
                textToBeSet.append(String.valueOf(this.myText.nbOfDelimiters) + " delimiters\n");
            }
            if (this.myText.nbOfDiffDelimiters > 1) {
                textToBeSet.append(" (" + this.myText.nbOfDiffDelimiters + " diff)");
            }
        }
        DefaultListModel model = (DefaultListModel)this.textShell.getListOfResults().getModel();
        model.clear();
        model.addElement("Characters");
        model.addElement("Tokens");
        model.addElement("Digrams");
        if (this.myText.mft != null && this.myText.nbOfTextUnits > 0) {
            this.textShell.getLblnTus().setEnabled(true);
            this.textShell.getLblnTus().setText("/ " + this.textShell.getText().nbOfTextUnits + " TUs");
        }
        if (this.myText.annotations != null && this.myText.mft != null) {
            textToBeSet.append("Text contains ");
            textToBeSet.append(String.valueOf(this.myText.mft.nbOfTransitions) + " annotations ");
            textToBeSet.append("(" + this.myText.annotations.size() + " different)\n");
            if (this.myText.annotations.size() < 1000) {
                model.addElement("Annotations");
            }
            if (this.myText.hUnknowns != null) {
                model.addElement("Unknowns");
            }
            model.addElement("Ambiguities");
            model.addElement("Unambiguous Words");
            this.textShell.getChckbxShowTextAnnotation().setEnabled(true);
        } else {
            this.textShell.getChckbxShowTextAnnotation().setEnabled(false);
        }
        if (this.myText.listOfResources != null) {
            textToBeSet.append("Linguistic Resources applied to the text:\n");
            for (String res : this.myText.listOfResources) {
                textToBeSet.append(String.valueOf(res.toString()) + " ");
            }
            textToBeSet.append("\n");
        }
        this.textShell.getTxtInfo().setText(textToBeSet.toString());
    }

    public void suiteFunction(Language lan, String language, String delimiter, String[] xmlTags, int encodingType, String encodingCode, String encodingName) {
        this.myText = new Ntext(language, delimiter, xmlTags);
        try {
            this.myText.buffer = TextIO.loadText(this.fileToBeOpenedOrImported.getAbsolutePath(), encodingType, encodingCode, encodingName, lan.chartable);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + this.fileToBeOpenedOrImported.getName(), "NooJ Error!", 0);
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + this.fileToBeOpenedOrImported.getName(), "NooJ Error!", 0);
        }
        if (this.myText.buffer == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot import text file: " + this.fileToBeOpenedOrImported.getName(), "NooJ Error!", 0);
        }
        this.startNoojEngine();
        String errorMessage = "";
        if (ImportTextActionListener.xmlButtonChecked) {
            errorMessage = this.engine.delimitXmlTextUnitsAndImportXmlTags(null, this.myText);
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error! " + errorMessage, 1);
                return;
            }
        } else {
            errorMessage = this.engine.delimitTextUnits(this.myText);
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ Error! " + errorMessage, 1);
                return;
            }
            this.textShell = new TextEditorShell(null, this.myText, "Import " + this.fileToBeOpenedOrImported.getName(), this.myText.getDelimPattern(), false);
            this.textShell.setTextController(this);
            this.textShell.refreshListenersAndAdapters();
            Launcher.getDesktopPane().add(this.textShell);
            this.textShell.setVisible(true);
            this.modify();
            this.rtbTextUpdate(true);
            this.updateTextPaneStats();
            return;
        }
        this.textShell = new TextEditorShell(null, this.myText, "Import " + this.fileToBeOpenedOrImported.getName(), this.myText.getDelimPattern(), false);
        this.textShell.setTextController(this);
        this.textShell.refreshListenersAndAdapters();
        Launcher.getDesktopPane().add(this.textShell);
        this.textShell.setVisible(true);
    }

    public void linguisticAnalysis() {
        HashMap<String, ArrayList<String>> simpleWordCache;
        String prio;
        String fName;
        if (this.textWasEdited) {
            this.textWasEdited = false;
            this.myText.mft = null;
            this.myText.buffer = null;
        }
        if (this.myText.buffer == null || this.myText.buffer.equals("")) {
            this.myText.buffer = this.paneOfTextEditor.getText().replace("\r", "");
        }
        boolean thereAreNoResources = false;
        if (Launcher.preferences.ldic.get(this.myText.Lan.isoName) == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no selected lexical resource for " + this.myText.Lan.isoName + ".\nAre you sure you want to continue?", "NooJ", 1);
            thereAreNoResources = true;
            return;
        }
        RefObject<Language> mytextLanRef = new RefObject<Language>(this.myText.Lan);
        this.engine = new Engine(mytextLanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        this.myText.Lan = (Language)mytextLanRef.argvalue;
        RefObject<String> errMessage = new RefObject<String>("");
        try {
            if (!this.engine.loadResources(Launcher.preferences.ldic.get(this.myText.Lan.isoName), Launcher.preferences.lsyn.get(this.myText.Lan.isoName), true, errMessage) && !thereAreNoResources) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load lexical resource for " + this.myText.Lan.isoName, (String)errMessage.argvalue, 1);
                return;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, (String)errMessage.argvalue, 1);
            return;
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ cannot load linguistic resource for " + this.myText.Lan.isoName, (String)errMessage.argvalue, 1);
            return;
        }
        this.myText.listOfResources = new ArrayList();
        ArrayList<String> res = Launcher.preferences.ldic.get(this.myText.Lan.isoName);
        if (res != null) {
            for (String fullName : res) {
                fName = FilenameUtils.getName(fullName);
                prio = fName.substring(0, 2);
                fName = fName.substring(2);
                this.myText.listOfResources.add(String.valueOf(fName) + "(" + prio + ")");
            }
        }
        if ((res = Launcher.preferences.lsyn.get(this.myText.Lan.isoName)) != null) {
            for (String fullName : res) {
                fName = FilenameUtils.getName(fullName);
                prio = fName.substring(0, 2);
                fName = fName.substring(2);
                this.myText.listOfResources.add(String.valueOf(fName) + "(" + prio + ")");
            }
        }
        if (this.myText.mft == null) {
            if (Launcher.multithread) {
                if (Launcher.backgroundWorker.isCancellationPending()) {
                    this.myText.mft = null;
                    return;
                }
                Launcher.progressMessage = "Splitting text into text units...";
                Launcher.progressPercentage = 0;
                if (Launcher.backgroundWorker.isBusy()) {
                    Launcher.backgroundWorker.reportProgress(0);
                }
            }
            if (this.myText.XmlNodes == null) {
                this.myText.mft = this.engine.delimit(this.myText);
                this.myText.annotations = new ArrayList();
                this.myText.hLexemes = new HashMap();
            } else {
                this.engine.delimitXmlTextUnitsAndImportXmlTags(null, this.myText);
            }
            if (this.myText.mft == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot split text into text units!", (String)errMessage.argvalue, 0);
                return;
            }
        } else if (this.myText.XmlNodes == null) {
            this.myText.mft.resetTransitions();
            this.myText.annotations = new ArrayList();
            this.myText.hLexemes = new HashMap();
        }
        this.myText.hUnknowns = new HashMap();
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                this.myText.annotations = null;
                this.myText.hLexemes = null;
                this.myText.hUnknowns = null;
                return;
            }
            Launcher.progressMessage = "Lexical Analysis...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        if (!this.engine.tokenize(null, this.myText, this.myText.annotations, simpleWordCache = new HashMap<String, ArrayList<String>>(), errMessage)) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ Tokenizer Error", (String)errMessage.argvalue, 0);
            this.myText.annotations = null;
            this.myText.hLexemes = null;
            this.myText.hUnknowns = null;
            return;
        }
        simpleWordCache = null;
        if (this.myText.XmlNodes == null) {
            this.myText.hPhrases = new HashMap();
        }
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                this.myText.hPhrases = null;
                return;
            }
            Launcher.progressMessage = "Apply dictionary/grammars...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        this.applySyntax(0, errMessage);
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                this.myText.hPhrases = null;
                return;
            }
            Launcher.progressMessage = "Apply syntactic grammars...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        this.applySyntax(1, errMessage);
        this.reactivateOps();
    }

    public void desactivateOps() {
        Launcher.getMenuBar().repaint();
    }

    public void reactivateOps() {
        Launcher.getMenuBar().repaint();
    }

    private void applySyntax(int startingPoint, RefObject<String> errMessage) {
        if (this.engine.synGrms != null && this.engine.synGrms.size() > 0) {
            boolean applyres = false;
            try {
                applyres = this.engine.applyAllGrammars(null, this.myText, this.myText.annotations, startingPoint, errMessage);
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ Apply Grammars Error", (String)errMessage.argvalue, 0);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ Apply Grammars Error", (String)errMessage.argvalue, 0);
            }
            if (!applyres && errMessage != null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ Syntactic Parsing Error", (String)errMessage.argvalue, 0);
                return;
            }
            if (!applyres) {
                this.myText.hPhrases = null;
                return;
            }
            if (startingPoint == 0) {
                this.myText.cleanupBadAnnotations(this.myText.annotations);
            }
        }
    }

    public void resetShellText() {
        this.textIsBeingColored = true;
        this.textInfo = this.textShell.getTxtInfo();
        if (this.corpusController != null && this.corpusController.getShell() != null) {
            this.corpus = this.corpusController.getCorpus();
            this.textShell.getListOfResults().setVisible(false);
            this.textShell.getScrollList().setVisible(false);
            this.textInfo.setVisible(false);
            this.engine = this.corpusController.getEngine();
        } else {
            this.engine = new Engine(new RefObject<Language>(this.myText.Lan), Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        }
        this.NooJRightToLeft = this.myText.Lan.rightToLeft;
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributeSet, this.NooJRightToLeft ? 2 : 0);
        StyleConstants.setFontFamily(attributeSet, Launcher.preferences.TFont.getFamily());
        StyleConstants.setFontSize(attributeSet, Launcher.preferences.TFont.getSize());
        this.paneOfTextEditor.getStyledDocument().setParagraphAttributes(0, this.myText.buffer.length(), attributeSet, true);
        if (this.textInfo.isVisible()) {
            this.updateTextPaneStats();
            this.rtbTextUpdate(false);
        }
        this.textWasEdited = false;
    }

    public void modify() {
        this.modified = true;
        if (this.textName == null) {
            this.textShell.setTitle("Untitled [Modified]");
        } else {
            this.textShell.setTitle(String.valueOf(this.textName) + " [Modified]");
        }
        if (this.textShell.getChckbxShowTextAnnotation().isSelected()) {
            this.textShell.getChckbxShowTextAnnotation().setSelected(false);
        }
        this.annotationsHistoric = new ArrayList();
    }

    private void modifyKeepTasDisplayed() {
        this.modified = true;
        if (this.textName == null) {
            this.textShell.setTitle("Untitled [Modified]");
        } else {
            this.textShell.setTitle(String.valueOf(this.textName) + " [Modified]");
        }
        if (!this.textShell.isNewText()) {
            CustomJSpinner spinner = this.textShell.getSpinner();
            spinner.setCustomValue((Integer)spinner.getValue());
        }
    }

    public void saveText() {
        if (this.fileToBeOpenedOrImported == null) {
            this.saveAsText();
        } else {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.save("");
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    public void saveAsText() {
        int value;
        File selectedFile;
        String languageName = this.myText.Lan.isoName;
        String currentDirToBeSetPath = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + languageName + System.getProperty("file.separator") + "Projects";
        File currentDirToBeSet = new File(currentDirToBeSetPath);
        JFileChooser saveTextChooser = Launcher.getSaveTextChooser();
        saveTextChooser.setCurrentDirectory(currentDirToBeSet);
        if (saveTextChooser.showSaveDialog(null) == 1) {
            return;
        }
        this.fileToBeOpenedOrImported = selectedFile = saveTextChooser.getSelectedFile();
        this.textName = this.fileToBeOpenedOrImported.getName();
        String parentPath = saveTextChooser.getCurrentDirectory().getAbsolutePath();
        String inputFileName = String.valueOf(FilenameUtils.removeExtension(selectedFile.getName())) + "." + "jnot";
        String pathOfInputFile = String.valueOf(parentPath) + System.getProperty("file.separator") + inputFileName;
        File newFile = new File(pathOfInputFile);
        if (newFile.exists() && ((value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), String.valueOf(inputFileName) + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null)) == 1 || value == -1)) {
            return;
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(pathOfInputFile);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    private void save(String path) {
        if (path.equals("")) {
            String fileName = this.fileToBeOpenedOrImported.getName();
            String jnotFileName = String.valueOf(FilenameUtils.removeExtension(fileName)) + "." + "jnot";
            String parentPath = this.fileToBeOpenedOrImported.getParent();
            path = String.valueOf(parentPath) + System.getProperty("file.separator") + jnotFileName;
        }
        if (this.fileToBeOpenedOrImported == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save text", "NooJ: undefined file name", 0);
            return;
        }
        if (this.fileToBeOpenedOrImported != null && path.equals(this.fileToBeOpenedOrImported.getAbsolutePath())) {
            this.fileToBeOpenedOrImported.delete();
        }
        this.textShell.getText().buffer = this.textShell.getTextPane().getText();
        this.save(path, false);
    }

    private void save(String fullName, boolean forNooJ) {
        if (!forNooJ) {
            int answer;
            String fNameNoExt = FilenameUtils.removeExtension(fullName);
            if (fNameNoExt.charAt(0) == '_' && (answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0)) == 1) {
                return;
            }
            try {
                Utilities.savePreviousVersion(fullName, Launcher.preferences.multiplebackups);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while saving previous version of a text!", 0);
                return;
            }
        }
        if (this.textWasEdited) {
            this.myText.buffer = this.textShell.getTextPane().getText().replace("\r", "");
            this.myText.mft = null;
            this.textWasEdited = false;
        }
        try {
            this.myText.save(fullName);
            this.listOfColors = null;
            this.absoluteBeginAddresses = null;
            this.absoluteEndAddresses = null;
            this.modified = false;
            if (!forNooJ) {
                this.textName = fullName;
            }
            this.textShell.setTitle(FilenameUtils.getName(this.textName));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save text: " + e.getMessage(), "NooJ", 0);
            return;
        }
    }

    public void saveTextForNooJ() {
        String languageName = this.myText.Lan.isoName;
        String dirName = String.valueOf(Paths.applicationDir) + "resources" + System.getProperty("file.separator") + "initial" + System.getProperty("file.separator") + languageName + System.getProperty("file.separator") + "Projects";
        String fileName = this.fileToBeOpenedOrImported.getName();
        String nooJName = String.valueOf(dirName) + System.getProperty("file.separator") + fileName;
        try {
            CursorChangeEffect.setCustomCursor(3);
            File parent = new File(dirName);
            if (!parent.exists()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Save file path does not exists!", "Error while saving text to text directory!", 0);
                return;
            }
            File file = new File(nooJName);
            if (file.exists()) {
                file.delete();
            }
            this.save(nooJName);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File " + nooJName + " has been updated!", "NooJ Update", 1);
    }

    public void modifyTextFont(String fontFamily, int fontSize) {
        this.NooJRightToLeft = this.myText.Lan.rightToLeft;
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributeSet, this.NooJRightToLeft ? 2 : 0);
        StyleConstants.setFontFamily(attributeSet, fontFamily);
        StyleConstants.setFontSize(attributeSet, fontSize);
        this.paneOfTextEditor.getStyledDocument().setParagraphAttributes(0, this.myText.buffer.length(), attributeSet, false);
        this.paneOfTextEditor.repaint();
    }

    public boolean isCurrentTextUnitIsBlack() {
        return this.currentTextUnitIsBlack;
    }

    public void setCurrentTextUnitIsBlack(boolean currentTextUnitIsBlack) {
        this.currentTextUnitIsBlack = currentTextUnitIsBlack;
    }

    public File getFileToBeOpenedOrImported() {
        return this.fileToBeOpenedOrImported;
    }

    public Ntext getMyText() {
        return this.myText;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public TextEditorShell getTextShell() {
        return this.textShell;
    }

    public void setFileToBeOpenedOrImported(File fileToBeOpenedOrImported) {
        this.fileToBeOpenedOrImported = fileToBeOpenedOrImported;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
    }

    public boolean isNooJRightToLeft() {
        return this.NooJRightToLeft;
    }

    public void fillInVocabulary(DictionaryEditorShell annotationsEditor) {
        String newFeatures;
        RefObject<Object> featuresRef;
        RefObject<String> infoRef;
        RefObject<String> lemmaRef;
        RefObject<String> entryRef;
        String category;
        String info;
        String lemma;
        String entry;
        if (!this.myText.updateAnnotationsForText()) {
            return;
        }
        annotationsEditor.getController().initLoad(this.myText.Lan.isoName);
        StringBuilder sb = new StringBuilder();
        HashMap frozenExpressions = new HashMap();
        for (Object lexemeObj : this.myText.annotations) {
            String lexeme = (String)lexemeObj;
            if (lexeme == null) continue;
            entry = "";
            lemma = "";
            info = "";
            category = "";
            entryRef = new RefObject<String>(entry);
            lemmaRef = new RefObject<String>(lemma);
            infoRef = new RefObject<String>(info);
            if (!Dic.parseDELAF(lexeme, entryRef, lemmaRef, infoRef)) continue;
            info = (String)infoRef.argvalue;
            lemma = (String)lemmaRef.argvalue;
            entry = (String)entryRef.argvalue;
            if (lemma.equals("SYNTAX")) {
                entry = Dic.protectComma(entry);
                sb.append(String.valueOf(entry) + "," + info + "\n");
                continue;
            }
            RefObject<String> categoryRef = new RefObject<String>(category);
            String[] features = null;
            featuresRef = new RefObject<Object>(features);
            if (!Dic.parseDELAFFeatureArray(lexeme, entryRef, lemmaRef, categoryRef, featuresRef)) continue;
            features = (String[])featuresRef.argvalue;
            category = (String)categoryRef.argvalue;
            newFeatures = Dic.getRidOfSpecialFeatures(features);
            if ((entry = Dic.protectComma(entry)).equals(lemma = Dic.protectComma(lemma))) {
                sb.append(String.valueOf(entry) + "," + category + newFeatures + "\n");
                continue;
            }
            sb.append(String.valueOf(entry) + "," + lemma + "," + category + newFeatures + "\n");
        }
        if (frozenExpressions.size() > 0) {
            for (Object lexeme : frozenExpressions.values()) {
                String lexemeString = lexeme.toString();
                entry = "";
                lemma = "";
                info = "";
                category = "";
                entryRef = new RefObject<String>(entry);
                lemmaRef = new RefObject<String>(lemma);
                infoRef = new RefObject<String>(info);
                RefObject<String> categoryRef = new RefObject<String>(category);
                if (!Dic.parseDELAF(lexemeString, entryRef, lemmaRef, infoRef)) continue;
                lemma = (String)lemmaRef.argvalue;
                entry = (String)entryRef.argvalue;
                info = (String)infoRef.argvalue;
                if (lemma.equals("SYNTAX")) {
                    entry = Dic.protectComma(entry);
                    sb.append(String.valueOf(entry) + "," + info + "\r");
                    continue;
                }
                String[] features = null;
                featuresRef = new RefObject<Object>(features);
                if (!Dic.parseDELAFFeatureArray(lexemeString, entryRef, lemmaRef, categoryRef, featuresRef)) continue;
                features = (String[])featuresRef.argvalue;
                newFeatures = Dic.getRidOfSpecialFeatures(features);
                if (entry.equals(lemma)) {
                    sb.append(String.valueOf(entry) + "," + category + newFeatures + "\r");
                    continue;
                }
                sb.append(String.valueOf(entry) + "," + lemma + "," + category + newFeatures + "\r");
            }
        }
        if (sb.length() > 10000000) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary is too large (>10MB) to be displayed", "NooJ: dictionary (> 10 MB) is too large", 1);
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Do you want to save it in a file?", "NooJ", 0);
            if (answer == 0) {
                String fn = "dictionary.dic";
                String pn = String.valueOf(Paths.applicationDir) + fn;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(pn);
                    fileOutputStream.write(annotationsEditor.getTextPane().getText().getBytes());
                    fileOutputStream.write(sb.toString().getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    return;
                }
                catch (IOException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary saved in file " + pn, "NooJ", 1);
            }
            return;
        }
        annotationsEditor.getTextPane().setText(sb.toString());
        annotationsEditor.getController().sortDictionary(true);
    }

    public void fillInUnknowns(DictionaryEditorShell unknownsEditor) {
        String lang = this.myText.Lan.isoName;
        unknownsEditor.getController().initLoad(lang);
        StringBuilder builder = new StringBuilder();
        for (Object tokenObj : this.myText.annotations) {
            String token = (String)tokenObj;
            if (token == null) continue;
            String entry = "";
            RefObject<String> entryRef = new RefObject<String>(entry);
            String lemma = "";
            RefObject<String> lemmaRef = new RefObject<String>(lemma);
            String category = "";
            RefObject<String> categoryRef = new RefObject<String>(category);
            Object features = null;
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            if (!Dic.parseDELAFFeatureArray(token, entryRef, lemmaRef, categoryRef, featuresRef)) {
                builder.append(String.valueOf(token) + " # invalid lexeme\n");
                Dic.writeLog("Lexeme <" + token + "> is invalid");
                continue;
            }
            if (!((String)categoryRef.argvalue).equals("UNKNOWN")) continue;
            builder.append(String.valueOf(token) + "\n");
        }
        if (builder.length() > 10000000) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Unknown Dictionary is too large (>10MB) to be displayed", "NooJ: dictionary (> 10 MB) is too large", 1);
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Do you want to save it in a file?", "NooJ", 0);
            if (answer == 0) {
                String fn = "unknown.dic";
                String pn = String.valueOf(Paths.applicationDir) + fn;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(pn);
                    fileOutputStream.write(unknownsEditor.getTextPane().getText().getBytes());
                    fileOutputStream.write(builder.toString().getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    return;
                }
                catch (IOException e) {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Unknown Dictionary saved in file " + pn, "NooJ", 1);
            }
            return;
        }
        String existingText = unknownsEditor.getTextPane().getText();
        StringBuilder newText = new StringBuilder(existingText);
        newText.append(builder.toString());
        unknownsEditor.getTextPane().setText(newText.toString());
        unknownsEditor.getController().sortDictionary(true);
    }

    public void computeAlphabet() {
        this.engine.computeAlphabet(this.myText);
    }

    public void computeTokens() {
        this.myText.hTokens = new HashMap();
        this.engine.computeTokens(null, this.myText);
    }

    public void computeDigrams() {
        this.myText.hDigrams = new HashMap();
        if (this.myText.mft != null) {
            this.engine.computeDigrams(null, this.myText);
        }
    }

    public void computeAmbiguities(boolean isAmbig) {
        if (isAmbig) {
            this.myText.hAmbiguities = new HashMap();
            RefObject<HashMap<String, ArrayList<Object>>> refHash = new RefObject<HashMap<String, ArrayList<Object>>>(this.myText.hAmbiguities);
            this.engine.computeAmbiguities(null, null, this.myText, this.myText.annotations, refHash);
            this.myText.hAmbiguities = (HashMap)refHash.argvalue;
        } else {
            this.myText.hUnambiguities = new HashMap();
            RefObject<HashMap<String, ArrayList<Object>>> refHash = new RefObject<HashMap<String, ArrayList<Object>>>(this.myText.hUnambiguities);
            this.engine.computeUnambiguities(null, null, this.myText, this.myText.annotations, refHash);
            this.myText.hUnambiguities = (HashMap)refHash.argvalue;
        }
    }

    public int locateTextUnit(int beginAddressOfTU) {
        int tuNb = 1;
        while (tuNb < this.myText.nbOfTextUnits && beginAddressOfTU > this.myText.mft.tuAddresses[tuNb] + this.myText.mft.tuLengths[tuNb]) {
            ++tuNb;
        }
        if (tuNb <= this.myText.nbOfTextUnits) {
            return tuNb;
        }
        return -1;
    }

    public void setTuGraph(int currentUnit) {
        this.tuGraph = this.myText.mft.getTuGraph(currentUnit, this.tuGraph);
        this.tuGraph.setNeedToBeComputed(true);
    }

    public void showAndScrollTas(int rtbPosition) {
        String rtbText = this.textShell.getTextPane().getText();
        if (rtbPosition >= 0 && rtbPosition < rtbText.length()) {
            if (Language.isLetter(rtbText.charAt(rtbPosition)) && !this.myText.Lan.asianTokenizer) {
                while (rtbPosition >= 0 && Language.isLetter(rtbText.charAt(rtbPosition))) {
                    --rtbPosition;
                }
                ++rtbPosition;
            }
            int currentUnit = (Integer)this.textShell.getSpinner().getValue();
            this.selectAllAnnotationsAtPosition = rtbPosition - this.myText.mft.tuAddresses[currentUnit];
        }
        this.textShell.getHiddenPanel().setSelectAllAnnotationsAtPosition(this.selectAllAnnotationsAtPosition);
        if (this.tuGraph.needToBeComputed) {
            Graphics g = this.textShell.getHiddenPanel().getGraphics();
            Graphics2D g2d = (Graphics2D)g;
            this.tuGraph.computeDrawing(this.myText.annotations, this.textShell.getHiddenPanel(), g2d);
        }
        this.tuGraph.computeCurrentFrameX(this.selectAllAnnotationsAtPosition, this.textShell.getHiddenPanel());
        this.tuGraph.computeXYcoord(this.textShell.getHiddenPanel(), this.selectAllAnnotationsAtPosition, -1);
        JButton test = new JButton(Integer.toString((int)this.selectAllAnnotationsAtPosition));
        test.setLocation(new Point(this.tuGraph.xCoord, 0));
        test.setUI(new BasicButtonUI(){

            @Override
            public void paint(Graphics g, JComponent component) {
                int thicknessOfBorders = 3;
                Graphics2D g2D = (Graphics2D)g;
                JButton myButton = (JButton)component;
                Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
                myButton.setFont(buttonFont);
                myButton.setBorder(BorderFactory.createLineBorder(Color.RED, thicknessOfBorders));
                g2D.setColor(Color.WHITE);
                g2D.fillRoundRect(thicknessOfBorders, thicknessOfBorders, component.getWidth() - thicknessOfBorders, component.getHeight() - thicknessOfBorders, thicknessOfBorders, thicknessOfBorders);
                super.paint(g2D, component);
            }
        });
        test.setSize(60, 20);
        this.textShell.getHiddenPanel().removeAll();
        this.textShell.getHiddenPanel().add(test);
        JScrollPane scroll = this.textShell.getPanelScrollPane();
        scroll.getVerticalScrollBar().setValue(0);
        scroll.getHorizontalScrollBar().setValue(this.tuGraph.xCoord);
        this.textShell.getTextPane().getCaret().setVisible(true);
        this.textShell.invalidate();
        this.textShell.validate();
        this.textShell.repaint();
    }

    public void textHasJustBeenEdited() {
        if (this.textWasEdited) {
            return;
        }
        this.textWasEdited = true;
        this.modify();
        JCheckBox cbShowAnnottation = this.textShell.getChckbxShowTextAnnotation();
        if (cbShowAnnottation.isSelected()) {
            cbShowAnnottation.setSelected(false);
        }
        cbShowAnnottation.setEnabled(false);
        this.myText.nbOfDiffChars = -1;
        this.myText.nbOfChars = -1;
        this.myText.nbOfTokens = -1;
        this.myText.nbOfDelimiters = -1;
        this.myText.nbOfBlanks = -1;
        this.myText.nbOfDigits = -1;
        this.myText.nbOfLetters = -1;
        this.myText.listOfResources = null;
        this.setListOfColors(null);
        this.setAbsoluteBeginAddresses(null);
        this.setAbsoluteEndAddresses(null);
        TextEditorShell textEditorShell = this.getTextShell();
        ConcordanceShellController concordanceController = this.getConcordanceController();
        if (textEditorShell.getAlphabetDialog() != null) {
            textEditorShell.getAlphabetDialog().dispose();
        }
        if (textEditorShell.getTokensDialog() != null) {
            textEditorShell.getTokensDialog().dispose();
        }
        if (textEditorShell.getAmbiguitiesDialog() != null) {
            textEditorShell.getAmbiguitiesDialog().dispose();
        }
        if (textEditorShell.getUnAmbiguitiesDialog() != null) {
            textEditorShell.getUnAmbiguitiesDialog().dispose();
        }
        if (concordanceController != null) {
            concordanceController.getConcordanceShell().dispose();
            concordanceController = null;
        }
        if (textEditorShell.getLocateDialog() != null) {
            textEditorShell.getLocateDialog().dispose();
        }
        if (textEditorShell.getExportXmlDialog() != null) {
            textEditorShell.getExportXmlDialog().dispose();
        }
        this.updateTextPaneStats();
    }

    public void removeAnnotation() {
        if (!this.textShell.getTextPane().isVisible()) {
            return;
        }
        if (this.tuGraph == null) {
            return;
        }
        if (this.tuGraph.selectedAnnotation_tokenId == -1) {
            return;
        }
        RefObject<Double> refRelEndAddress = new RefObject<Double>(0.0);
        int tuNbCurrent = (Integer)this.textShell.getSpinner().getValue();
        if (this.myText.mft.removeTransition(tuNbCurrent, this.tuGraph.selectedAnnotation_relBegAddress, this.tuGraph.selectedAnnotation_tokenId, refRelEndAddress)) {
            this.annotationsHistoric.add(tuNbCurrent);
            this.annotationsHistoric.add(this.tuGraph.selectedAnnotation_relBegAddress);
            this.annotationsHistoric.add(this.tuGraph.selectedAnnotation_tokenId);
            this.annotationsHistoric.add(refRelEndAddress.argvalue);
        }
        this.tuGraph = this.myText.mft.getTuGraph(tuNbCurrent, this.tuGraph);
        if (this.tuGraph != null) {
            this.tuGraph.needToBeComputed = true;
        }
        this.updateTextPaneStats();
        this.modifyKeepTasDisplayed();
        this.textShell.invalidate();
        this.textShell.validate();
        this.textShell.repaint();
    }

    private void scrollToAnnotation(double relBegAddress) {
        int tuNbCurrent = (Integer)this.textShell.getSpinner().getValue();
        int rtbPosition = (int)relBegAddress + this.myText.mft.tuAddresses[tuNbCurrent];
        this.textShell.getTextPane().setCaretPosition(rtbPosition);
        if (this.tuGraph == null) {
            return;
        }
        this.tuGraph.needToBeComputed = true;
        if (this.textShell.getChckbxShowTextAnnotation().isSelected()) {
            String rtbText = this.textShell.getTextPane().getText();
            if (Language.isLetter(rtbText.charAt(rtbPosition))) {
                while (rtbPosition >= 0 && Language.isLetter(rtbText.charAt(rtbPosition))) {
                    --rtbPosition;
                }
                ++rtbPosition;
            }
            this.selectAllAnnotationsAtPosition = relBegAddress;
            this.textShell.getHiddenPanel().setSelectAllAnnotationsAtPosition(this.selectAllAnnotationsAtPosition);
            if (this.tuGraph.needToBeComputed) {
                Graphics g = this.textShell.getHiddenPanel().getGraphics();
                Graphics2D g2d = (Graphics2D)g;
                this.tuGraph.computeDrawing(this.myText.annotations, this.textShell.getHiddenPanel(), g2d);
            }
            this.tuGraph.computeCurrentFrameX(this.selectAllAnnotationsAtPosition, this.textShell.getHiddenPanel());
            this.tuGraph.computeXYcoord(this.textShell.getHiddenPanel(), this.selectAllAnnotationsAtPosition, -1);
            JButton test = new JButton(Integer.toString((int)this.selectAllAnnotationsAtPosition));
            test.setLocation(new Point(this.tuGraph.xCoord, 0));
            test.setUI(new BasicButtonUI(){

                @Override
                public void paint(Graphics g, JComponent component) {
                    int thicknessOfBorders = 3;
                    Graphics2D g2D = (Graphics2D)g;
                    JButton myButton = (JButton)component;
                    Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
                    myButton.setFont(buttonFont);
                    myButton.setBorder(BorderFactory.createLineBorder(Color.RED, thicknessOfBorders));
                    g2D.setColor(Color.WHITE);
                    g2D.fillRoundRect(thicknessOfBorders, thicknessOfBorders, component.getWidth() - thicknessOfBorders, component.getHeight() - thicknessOfBorders, thicknessOfBorders, thicknessOfBorders);
                    super.paint(g2D, component);
                }
            });
            test.setMinimumSize(new Dimension(60, 20));
            this.textShell.getHiddenPanel().removeAll();
            this.textShell.getHiddenPanel().add(test);
            JScrollPane scroll = this.textShell.getPanelScrollPane();
            scroll.getVerticalScrollBar().setValue(0);
            scroll.getHorizontalScrollBar().setValue(this.tuGraph.xCoord);
            this.textShell.invalidate();
            this.textShell.validate();
            this.textShell.repaint();
        }
    }

    public void addAnnotation() {
        if (this.annotationsHistoric.size() < 4) {
            return;
        }
        int i = this.annotationsHistoric.size() - 4;
        int tuNb = (Integer)this.annotationsHistoric.get(i);
        double relBegAddress = (Double)this.annotationsHistoric.get(i + 1);
        int tokenId = (Integer)this.annotationsHistoric.get(i + 2);
        double relEndAddress = (Double)this.annotationsHistoric.get(i + 3);
        this.myText.mft.addTransition(tuNb, relBegAddress, tokenId, relEndAddress);
        this.annotationsHistoric.remove(i);
        this.annotationsHistoric.remove(i);
        this.annotationsHistoric.remove(i);
        this.annotationsHistoric.remove(i);
        int tuNbCurrent = (Integer)this.textShell.getSpinner().getValue();
        if (tuNb != tuNbCurrent) {
            tuNbCurrent = tuNb;
            this.textShell.getSpinner().setValue(tuNb);
            this.rtbTextUpdate(false);
        }
        this.tuGraph = this.myText.mft.getTuGraph(tuNbCurrent, this.tuGraph);
        if (this.tuGraph != null) {
            this.tuGraph.needToBeComputed = true;
        }
        this.updateTextPaneStats();
        this.modifyKeepTasDisplayed();
        this.scrollToAnnotation(relBegAddress);
    }

    public void linguisticAnalysisForNewText(JTextPane textPane, TextEditorShell textShell) {
        int numberOfTU = this.getMyText().nbOfTextUnits;
        final CustomJSpinner spinner = new CustomJSpinner(textShell, numberOfTU);
        StyledDocument doc = textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
        if (textShell.isNewText()) {
            Container contentPane = textShell.getContentPane();
            JLabel labelTU = textShell.getLblnTus();
            contentPane.remove(textShell.getSpinner());
            final JFormattedTextField jtf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            jtf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        String text = jtf.getText();
                        try {
                            Integer newValue = Integer.valueOf(text);
                            if (newValue > spinner.getUpperLimit() || newValue < 1) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Input number was outside of range! Please, type a number between 1 and total number of TUs!", "NooJ error", 0);
                                return;
                            }
                            spinner.setCustomValue(newValue);
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please, type a valid number!", "NooJ error", 0);
                        }
                    }
                }
            });
            textShell.setSpinner(spinner);
            textShell.getSpinner().setEnabled(true);
            contentPane.remove(labelTU);
            contentPane.add((Component)spinner, "flowx, cell 0 0, alignx left, aligny top");
            contentPane.add((Component)labelTU, "cell 0 0, alignx center, aligny top");
            labelTU.setText("/ " + numberOfTU);
            textShell.revalidate();
            textShell.repaint();
            UnitSelectionListener tuListener = new UnitSelectionListener(this, textPane);
            textPane.addCaretListener(tuListener);
            textShell.setUnitSelectionListener(tuListener);
            textPane.setCaretPosition(0);
            doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
            spinner.setCustomValue(1);
        }
    }

    public ConcordanceShellController getConcordanceController() {
        return this.concordanceController;
    }

    public void setConcordanceController(ConcordanceShellController concordanceController) {
        this.concordanceController = concordanceController;
    }

    public List<Color> getListOfColors() {
        return this.listOfColors;
    }

    public void setListOfColors(List<Color> listOfColors) {
        this.listOfColors = listOfColors;
    }

    public List<Integer> getAbsoluteBeginAddresses() {
        return this.absoluteBeginAddresses;
    }

    public void setAbsoluteBeginAddresses(List<Integer> absoluteBeginAddresses) {
        this.absoluteBeginAddresses = absoluteBeginAddresses;
    }

    public List<Integer> getAbsoluteEndAddresses() {
        return this.absoluteEndAddresses;
    }

    public void setAbsoluteEndAddresses(List<Integer> absoluteEndAddresses) {
        this.absoluteEndAddresses = absoluteEndAddresses;
    }

    public TuGraph getTuGraph() {
        return this.tuGraph;
    }

    public double getSelectAllAnnotationsAtPosition() {
        return this.selectAllAnnotationsAtPosition;
    }

    public void setSelectAllAnnotationsAtPosition(double selectAllAnnotationsAtPosition) {
        this.selectAllAnnotationsAtPosition = selectAllAnnotationsAtPosition;
    }

    public void setMyText(Ntext myText) {
        this.myText = myText;
    }

    public CorpusEditorShellController getCorpusController() {
        return this.corpusController;
    }

    public List<String> getLocateGrammarMemoryList() {
        return this.locateGrammarMemoryList;
    }

    public void setLocateGrammarMemoryList(List<String> locateGrammarMemoryList) {
        this.locateGrammarMemoryList = locateGrammarMemoryList;
    }

    public List<String> getLocateRegexMemoryList() {
        return this.locateRegexMemoryList;
    }

    public void setLocateRegexMemoryList(List<String> locateRegexMemoryList) {
        this.locateRegexMemoryList = locateRegexMemoryList;
    }

    public String getTextName() {
        return this.textName;
    }

    public boolean isTextWasEdited() {
        return this.textWasEdited;
    }

    public void setTextWasEdited(boolean textWasEdited) {
        this.textWasEdited = textWasEdited;
    }

    public boolean isTextIsBeingColored() {
        return this.textIsBeingColored;
    }

    public void setTextIsBeingColored(boolean textIsBeingColored) {
        this.textIsBeingColored = textIsBeingColored;
    }
}

