/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretListener;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class TextLinguisticAnalysisActionListener
implements ActionListener,
PropertyChangeListener {
    private TextEditorShellController controller;
    private TextEditorShell textShell;
    private JTextPane textPane;

    public TextLinguisticAnalysisActionListener(TextEditorShellController controller) {
        this.controller = controller;
        this.textShell = this.controller.getTextShell();
        this.textPane = this.textShell.getTextPane();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        JCheckBox cbTAS = this.textShell.getChckbxShowTextAnnotation();
        if (cbTAS.isSelected()) {
            Container container = this.textShell.getContentPane();
            cbTAS.setSelected(false);
            JSplitPane splitPane = this.textShell.getSplitPane();
            JScrollPane textScroll = this.textShell.getScrollPane();
            JScrollPane panelScroll = this.textShell.getPanelScrollPane();
            this.textShell.getTasActionListener().start(container, cbTAS, splitPane, textScroll, panelScroll, this.controller);
        }
        this.controller.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Linguistic Analysis...";
        Launcher.getStatusBar().getProgressLabel().setText("Linguistic Analysis...");
        if (Launcher.multithread) {
            Launcher.backgroundWorking = true;
            Launcher.backgroundWorker = new BackgroundWorker("text linguistic analysis", this.controller, null, null);
            Launcher.backgroundWorker.addPropertyChangeListener(this);
            Launcher.backgroundWorker.execute();
        } else {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "mono-thread", "NooJ", 1);
            this.controller.linguisticAnalysis();
            this.linguisticAnalysisForNewText(this.textPane, this.textShell);
            this.controller.reactivateOps();
            this.controller.updateTextPaneStats();
            this.controller.rtbTextUpdate(false);
            this.controller.modify();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
            this.undoModifyChanges();
        }
    }

    private void linguisticAnalysisForNewText(JTextPane textPane, TextEditorShell textShell) {
        int numberOfTU = this.controller.getMyText().nbOfTextUnits;
        final CustomJSpinner spinner = new CustomJSpinner(textShell, numberOfTU);
        StyledDocument doc = textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
        if (textShell.isNewText()) {
            Container contentPane = textShell.getContentPane();
            JLabel labelTU = textShell.getLblnTus();
            contentPane.remove(textShell.getSpinner());
            final JFormattedTextField jtf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            jtf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        String text = jtf.getText();
                        try {
                            Integer newValue = Integer.valueOf(text);
                            if (newValue > spinner.getUpperLimit() || newValue < 1) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Input number was outside of range! Please, type a number between 1 and total number of TUs!", "NooJ error", 0);
                                return;
                            }
                            spinner.setCustomValue(newValue);
                        }
                        catch (NumberFormatException ex) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please, type a valid number!", "NooJ error", 0);
                        }
                    }
                }
            });
            textShell.setSpinner(spinner);
            textShell.getSpinner().setEnabled(true);
            contentPane.remove(labelTU);
            contentPane.add((Component)spinner, "flowx, cell 0 0, alignx left, aligny top");
            contentPane.add((Component)labelTU, "cell 0 0, alignx center, aligny top");
            labelTU.setText("/ " + numberOfTU);
            textShell.revalidate();
            textShell.repaint();
            UnitSelectionListener tuListener = new UnitSelectionListener(this.controller, textPane);
            textPane.addCaretListener(tuListener);
            textShell.setUnitSelectionListener(tuListener);
            textPane.setCaretPosition(0);
            doc.setCharacterAttributes(0, doc.getLength(), textPane.getStyle("Inactive"), true);
            spinner.setCustomValue(1);
        }
    }

    private void undoModifyChanges() {
        CaretListener[] listeners = this.textPane.getCaretListeners();
        if (listeners.length == 0) {
            this.textPane.moveCaretPosition(0);
            this.textPane.getCaret().setVisible(true);
            this.textPane.addCaretListener(new UnitSelectionListener(this.controller, this.textPane));
            this.textPane.setEditable(false);
        }
        this.textPane.setEditable(false);
        CustomJSpinner spinner = this.textShell.getSpinner();
        JCheckBox cbShowAnnottation = this.textShell.getChckbxShowTextAnnotation();
        if (!cbShowAnnottation.isEnabled()) {
            cbShowAnnottation.setEnabled(true);
        }
        if (!spinner.isEnabled()) {
            spinner.setEnabled(true);
            spinner.setCustomValue(0);
        }
    }
}

