/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEncodingDialog;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.nooj4nlp.engine.BasicConversion;
import net.nooj4nlp.gui.main.Launcher;

public class TextDocumentListener
implements DocumentListener {
    private JList listEncoding;
    private JTextField fldText;
    private JTextArea fldValDecimal;
    private JTextArea fldValHexadecimal;

    public TextDocumentListener(JList listEncoding, JTextField fldText, JTextArea fldValDecimal, JTextArea fldValHexadecimal) {
        this.listEncoding = listEncoding;
        this.fldText = fldText;
        this.fldValDecimal = fldValDecimal;
        this.fldValHexadecimal = fldValHexadecimal;
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.warn();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.warn();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.warn();
    }

    private void warn() {
        String encoding = (String)this.listEncoding.getSelectedValue();
        if (encoding == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please select an encoding", "NooJ", 1);
            this.fldText.setText("");
            return;
        }
        Charset enc = Charset.forName(encoding.substring(0, encoding.indexOf(91)));
        String text = this.fldText.getText();
        this.fldValDecimal.setText("");
        this.fldValHexadecimal.setText("");
        int it = 0;
        while (it < text.length()) {
            String cars = Character.toString(text.charAt(it));
            ByteBuffer byteBuf = enc.encode(cars);
            byte[] buf = byteBuf.array();
            int ib = 0;
            while (ib < buf.length) {
                int x = buf[ib] & 0xFF;
                String dec = Integer.toString(x);
                this.fldValDecimal.append(String.valueOf(dec) + " ");
                String hex = BasicConversion.dectohex(x);
                this.fldValHexadecimal.append(String.valueOf(hex) + " ");
                ++ib;
            }
            if (it < text.length() - 1) {
                this.fldValDecimal.append("- ");
                this.fldValHexadecimal.append("- ");
            }
            ++it;
        }
    }
}

