/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.packageconfigurationdialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.controller.FlexDescEditorShell.FlexDescEditorShellController;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.controller.PropDefEditorShell.PropDefEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.controller.packageconfigurationdialog.DialogStatus;
import net.nooj4nlp.controller.packageconfigurationdialog.Project;
import net.nooj4nlp.controller.packageconfigurationdialog.SaveProjectActionListener;
import net.nooj4nlp.controller.packageconfigurationdialog.WindowPosition;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Utilities;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.engine.Zip;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.DocumentationDialog;
import net.nooj4nlp.gui.dialogs.LocateDialog;
import net.nooj4nlp.gui.dialogs.PackageConfigurationDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.CorpusEditorShell;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import net.nooj4nlp.gui.shells.PropDefEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import net.nooj4nlp.gui.utilities.Helper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class PackageConfigurationDialogController {
    private static PackageConfigurationDialog packageConfigDialog;
    private static Project project;
    private ArrayList<Object> languagesResourcesLex;
    private ArrayList<Object> languagesResourcesSyn;
    private boolean modified;
    private String fullName;
    private static String projectDir;
    private static DocumentationDialog formDocumentation;

    public PackageConfigurationDialogController(PackageConfigurationDialog packageConfigurationDialog) {
        packageConfigDialog = packageConfigurationDialog;
        packageConfigDialog.setTitle("Untitled");
        packageConfigDialog.getTableFiles().setFont(Launcher.preferences.TFont);
        project = new Project();
    }

    public String copyNooJStatusToProject() {
        JInternalFrame[] openFrames;
        RefObject<Object> languages = new RefObject<Object>(null);
        project.setListOfForms(new ArrayList<JInternalFrame>());
        Object[] columnNames = new String[]{"Type", "File", "Directory", ""};
        DefaultTableModel tableModel = new DefaultTableModel(null, columnNames);
        packageConfigDialog.getTableFiles().setModel(tableModel);
        packageConfigDialog.getTableFiles().removeColumn(packageConfigDialog.getTableFiles().getColumnModel().getColumn(3));
        packageConfigDialog.getTextResources().setText("");
        JInternalFrame[] jInternalFrameArray = openFrames = Launcher.getDesktopPane().getAllFrames();
        int n = openFrames.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame currentForm = jInternalFrameArray[n2];
            if (currentForm.isVisible()) {
                String gName;
                String grammarPath;
                DialogStatus dialogStatus;
                String radioQuery;
                ArrayList<JInternalFrame> list2;
                LocateDialog locateDialog;
                WindowPosition wp;
                WindowPosition wp2;
                Object controller;
                JInternalFrame shell;
                ArrayList<JInternalFrame> list;
                String formName = currentForm.getClass().getSimpleName();
                if (formName.equals("GrammarEditorShell")) {
                    list = project.getListOfForms();
                    list.add(currentForm);
                    project.setListOfForms(list);
                    shell = (GrammarEditorShell)currentForm;
                    controller = ((GrammarEditorShell)shell).getController();
                    if (((GrammarEditorShellController)controller).getFullName() == null || ((GrammarEditorShellController)controller).isModified()) {
                        return "NooJ: first save grammar " + FilenameUtils.getName(((GrammarEditorShellController)controller).getFullName());
                    }
                    this.addALanguage(((GrammarEditorShellController)controller).grammar.iLanguage, languages);
                    this.addALanguage(((GrammarEditorShellController)controller).grammar.oLanguage, languages);
                    wp2 = new WindowPosition(shell.getX(), shell.getY(), shell.getWidth(), shell.getHeight());
                    File gramFile = new File(((GrammarEditorShellController)controller).getFullName());
                    this.add("Grammar", FilenameUtils.getName(((GrammarEditorShellController)controller).getFullName()), gramFile.getParent(), wp2);
                } else if (formName.equals("DictionaryEditorShell")) {
                    list = project.getListOfForms();
                    list.add(currentForm);
                    project.setListOfForms(list);
                    shell = (DictionaryEditorShell)currentForm;
                    controller = ((DictionaryEditorShell)shell).getController();
                    if (((DictionaryEditorShellController)controller).getFullName() == null || ((DictionaryEditorShellController)controller).isModified()) {
                        return "NooJ: first save dictionary " + FilenameUtils.getName(((DictionaryEditorShellController)controller).getFullName());
                    }
                    String lname = ((DictionaryEditorShellController)controller).getLan().isoName;
                    this.addALanguage(lname, languages);
                    wp = new WindowPosition(shell.getX(), shell.getY(), shell.getWidth(), shell.getHeight());
                    File gramFile = new File(((DictionaryEditorShellController)controller).getFullName());
                    this.add("Dictionary", FilenameUtils.getName(((DictionaryEditorShellController)controller).getFullName()), gramFile.getParent(), wp);
                } else if (formName.equals("TextEditorShell")) {
                    TextEditorShell shell2 = (TextEditorShell)currentForm;
                    if (shell2.getCorpusController() != null) break;
                    ArrayList<JInternalFrame> list3 = project.getListOfForms();
                    list3.add(currentForm);
                    project.setListOfForms(list3);
                    controller = shell2.getTextController();
                    File fileToBeOpenedOrImported = ((TextEditorShellController)controller).getFileToBeOpenedOrImported();
                    if (fileToBeOpenedOrImported.getName() == null || ((TextEditorShellController)controller).isModified()) {
                        String absolutePath = fileToBeOpenedOrImported.getAbsolutePath();
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Save text " + FilenameUtils.removeExtension(absolutePath), "NooJ", 1);
                        return "NooJ: first save text " + absolutePath;
                    }
                    this.addALanguage(((TextEditorShellController)controller).getMyText().LanguageName, languages);
                    wp = new WindowPosition(shell2.getX(), shell2.getY(), shell2.getWidth(), shell2.getHeight());
                    this.add("Text", FilenameUtils.getName(fileToBeOpenedOrImported.getName()), fileToBeOpenedOrImported.getParent(), wp);
                    locateDialog = shell2.getLocateDialog();
                    if (locateDialog != null && locateDialog.isVisible()) {
                        list2 = project.getListOfForms();
                        list2.add(locateDialog);
                        project.setListOfForms(list2);
                        wp = new WindowPosition(locateDialog.getX(), locateDialog.getY(), locateDialog.getWidth(), locateDialog.getHeight());
                        radioQuery = "";
                        if (locateDialog.getRbStringPattern().isSelected()) {
                            radioQuery = "string";
                        } else if (locateDialog.getRbPerlPattern().isSelected()) {
                            radioQuery = "perl re";
                        } else if (locateDialog.getRbNooJPattern().isSelected()) {
                            radioQuery = "nooj re";
                        } else if (locateDialog.getRbNooJGrammar().isSelected()) {
                            radioQuery = locateDialog.getSyntacticAnalysisCBox().isSelected() ? "Grammar" : "grammar";
                        }
                        dialogStatus = null;
                        grammarPath = locateDialog.getNooJGrammarPathCombo().getSelectedItem().toString();
                        if (!grammarPath.equals("")) {
                            gName = locateDialog.getNooJGrammarPathCombo().getSelectedItem().toString();
                            if (!this.isTheGrammarOpened(gName)) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + gName + " is not opened", "NooJ Project is missing one file", 1);
                                return "NooJ: either open grammar " + gName + " or clear up the 'Locate NooJ Grammar' field";
                            }
                            dialogStatus = new DialogStatus(((TextEditorShellController)controller).getFileToBeOpenedOrImported().getAbsolutePath(), locateDialog.getNooJRegeXCombo().getSelectedItem().toString(), FilenameUtils.getName(gName), radioQuery);
                        } else {
                            dialogStatus = new DialogStatus(((TextEditorShellController)controller).getFileToBeOpenedOrImported().getAbsolutePath(), locateDialog.getNooJRegeXCombo().getSelectedItem().toString(), "", radioQuery);
                        }
                        this.addDialogLocate(dialogStatus);
                    }
                } else if (formName.equals("CorpusEditorShell")) {
                    list = project.getListOfForms();
                    list.add(currentForm);
                    project.setListOfForms(list);
                    shell = (CorpusEditorShell)currentForm;
                    controller = ((CorpusEditorShell)shell).getController();
                    this.addALanguage(((CorpusEditorShellController)controller).getCorpus().languageName, languages);
                    wp2 = new WindowPosition(shell.getX(), shell.getY(), shell.getWidth(), shell.getHeight());
                    File file = new File(((CorpusEditorShellController)controller).getFullPath());
                    this.add("Corpus", FilenameUtils.getName(((CorpusEditorShellController)controller).getFullName()), file.getParent(), wp2);
                    locateDialog = ((CorpusEditorShellController)controller).getLocateDialog();
                    if (locateDialog != null && locateDialog.isVisible()) {
                        list2 = project.getListOfForms();
                        list2.add(locateDialog);
                        project.setListOfForms(list2);
                        wp2 = new WindowPosition(locateDialog.getX(), locateDialog.getY(), locateDialog.getWidth(), locateDialog.getHeight());
                        radioQuery = "";
                        if (locateDialog.getRbStringPattern().isSelected()) {
                            radioQuery = "string";
                        } else if (locateDialog.getRbPerlPattern().isSelected()) {
                            radioQuery = "perl re";
                        } else if (locateDialog.getRbNooJPattern().isSelected()) {
                            radioQuery = "nooj re";
                        } else if (locateDialog.getRbNooJGrammar().isSelected()) {
                            radioQuery = "grammar";
                        }
                        dialogStatus = null;
                        grammarPath = locateDialog.getNooJGrammarPathCombo().getSelectedItem().toString();
                        if (!grammarPath.equals("")) {
                            gName = locateDialog.getNooJGrammarPathCombo().getSelectedItem().toString();
                            if (!this.isTheGrammarOpened(gName)) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar " + gName + " is not opened", "NooJ Project is missing one file", 1);
                                return "NooJ: either open grammar " + gName + " or clear up the 'Locate NooJ Grammar' field";
                            }
                            dialogStatus = new DialogStatus(((CorpusEditorShellController)controller).getFullName(), locateDialog.getNooJRegeXCombo().getSelectedItem().toString(), gName, radioQuery);
                        } else {
                            dialogStatus = new DialogStatus(((CorpusEditorShellController)controller).getFullName(), locateDialog.getNooJRegeXCombo().getSelectedItem().toString(), "", radioQuery);
                        }
                        this.addDialogLocate(dialogStatus);
                    }
                } else if (formName.equalsIgnoreCase("FlexDescEditorShell")) {
                    list = project.getListOfForms();
                    list.add(currentForm);
                    project.setListOfForms(list);
                    shell = (FlexDescEditorShell)currentForm;
                    controller = ((FlexDescEditorShell)shell).getController();
                    if (((FlexDescEditorShellController)controller).getFullName() == null || ((FlexDescEditorShellController)controller).isModified()) {
                        return "NooJ: first save morphological description file " + FilenameUtils.getName(((FlexDescEditorShellController)controller).getFullName());
                    }
                    this.addALanguage(((FlexDescEditorShellController)controller).getiLan().isoName, languages);
                    wp2 = new WindowPosition(shell.getX(), shell.getY(), shell.getWidth(), shell.getHeight());
                    File flexFile = new File(((FlexDescEditorShellController)controller).getFullName());
                    this.add("FlexDesc", FilenameUtils.getName(((FlexDescEditorShellController)controller).getFullName()), flexFile.getParent(), wp2);
                } else if (formName.equalsIgnoreCase("PropDefEditorShell")) {
                    list = project.getListOfForms();
                    list.add(currentForm);
                    project.setListOfForms(list);
                    shell = (PropDefEditorShell)currentForm;
                    controller = ((PropDefEditorShell)shell).getController();
                    if (((PropDefEditorShellController)controller).getFullName() == null || ((PropDefEditorShellController)controller).isModified()) {
                        return "NooJ: first save properties' definition file " + FilenameUtils.getName(((PropDefEditorShellController)controller).getFullName());
                    }
                    this.addALanguage(((PropDefEditorShellController)controller).getLan().isoName, languages);
                    wp2 = new WindowPosition(shell.getX(), shell.getY(), shell.getWidth(), shell.getHeight());
                    File dicoFile = new File(((PropDefEditorShellController)controller).getFullName());
                    this.add("DicoDef", FilenameUtils.getName(((PropDefEditorShellController)controller).getFullName()), dicoFile.getParent(), wp2);
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < packageConfigDialog.getTableFiles().getColumnCount()) {
            Helper.setWidthOfTableColumn(packageConfigDialog.getTableFiles(), tableModel, i);
            ++i;
        }
        if (languages.argvalue == null) {
            return "NooJ: no opened window; cannot find any language";
        }
        this.displayCurrentLinguisticResourcesForLanguages((ArrayList)languages.argvalue);
        return null;
    }

    private void addALanguage(String lname, RefObject<ArrayList<String>> listOfLanguages) {
        boolean found = false;
        if (listOfLanguages.argvalue == null) {
            listOfLanguages.argvalue = new ArrayList();
        }
        for (String l : (ArrayList)listOfLanguages.argvalue) {
            if (!l.equals(lname)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((ArrayList)listOfLanguages.argvalue).add(lname);
        }
    }

    private void add(String type, String fname, String dname, WindowPosition wp) {
        DefaultTableModel model = (DefaultTableModel)packageConfigDialog.getTableFiles().getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            if (model.getValueAt(i, 1).equals(fname)) {
                return;
            }
            ++i;
        }
        Object[] row = new Object[]{type, fname, dname, wp};
        model.addRow(row);
    }

    private void addDialogLocate(DialogStatus ds) {
        DefaultTableModel model = (DefaultTableModel)packageConfigDialog.getTableFiles().getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            if (model.getValueAt(i, 1).equals("LocateDialog")) {
                return;
            }
            ++i;
        }
        Object[] row = new Object[]{"Locate", "", "", ds};
        model.addRow(row);
    }

    private void displayCurrentLinguisticResourcesForLanguages(ArrayList<String> languageNames) {
        this.languagesResourcesLex = new ArrayList();
        this.languagesResourcesSyn = new ArrayList();
        JTextArea textResources = packageConfigDialog.getTextResources();
        textResources.setText("");
        StringBuilder sb = new StringBuilder(textResources.getText());
        for (String languageName : languageNames) {
            int pr;
            String prio;
            sb.append("Language: " + languageName + "\n");
            ArrayList<String> lex = Launcher.preferences.ldic.get(languageName);
            if (lex == null || lex.size() == 0) {
                sb.append("No lexical resource\n");
            } else {
                sb.append(String.valueOf(lex.size()) + " lexical resources: \n");
                for (String prefname : lex) {
                    String fname = FilenameUtils.getName(prefname);
                    String ext = FilenameUtils.getExtension(prefname);
                    prio = fname.substring(0, 2);
                    fname = fname.substring(2);
                    pr = Integer.parseInt(prio);
                    if (pr > 0) {
                        sb.append("-- ");
                        sb.append(fname);
                        sb.append(" (Low Priority ");
                        sb.append(pr);
                        sb.append(")\n");
                    } else if (pr == 0) {
                        sb.append("-- ");
                        sb.append(fname);
                        sb.append("\n");
                    } else {
                        sb.append("-- ");
                        sb.append(fname);
                        sb.append(" (High Priority ");
                        sb.append(Math.abs(pr));
                        sb.append(")\n");
                    }
                    this.languagesResourcesLex.add(languageName);
                    this.languagesResourcesLex.add(fname);
                    this.languagesResourcesLex.add(pr);
                    if (!ext.equalsIgnoreCase("jnod")) continue;
                    String gname = String.valueOf(FilenameUtils.getName(fname)) + "nog";
                    String dname = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(languageName, "Lexical Analysis"));
                    String gfullname = FilenameUtils.concat(dname, gname);
                    File f = new File(gfullname);
                    if (!f.exists()) continue;
                    if (pr > 0) {
                        sb.append("-- " + gname + " (Low Priority " + pr + ")\n");
                    } else if (pr == 0) {
                        sb.append("-- " + gname + "\n");
                    } else {
                        sb.append("-- " + gname + " (High Priority " + Math.abs(pr) + ")\n");
                    }
                    this.languagesResourcesLex.add(languageName);
                    this.languagesResourcesLex.add(gname);
                    this.languagesResourcesLex.add(pr);
                }
            }
            ArrayList<String> syn = Launcher.preferences.lsyn.get(languageName);
            if (syn == null || syn.size() == 0) {
                sb.append("No syntactic resource\n");
                continue;
            }
            sb.append(String.valueOf(syn.size()) + " syntactic resources: \n");
            for (String prefname : syn) {
                String fname = FilenameUtils.getName(prefname);
                prio = fname.substring(0, 2);
                fname = fname.substring(2);
                pr = Integer.parseInt(prio);
                if (pr == 0) {
                    sb.append("-- " + fname + "\n");
                } else {
                    sb.append("-- " + fname + " (Step #" + pr + ")\n");
                }
                this.languagesResourcesSyn.add(languageName);
                this.languagesResourcesSyn.add(fname);
                this.languagesResourcesSyn.add(pr);
            }
        }
        textResources.setText(sb.toString());
    }

    private boolean isTheGrammarOpened(String gname) {
        JInternalFrame[] openFrames;
        boolean found = false;
        JInternalFrame[] jInternalFrameArray = openFrames = Launcher.getDesktopPane().getAllFrames();
        int n = openFrames.length;
        int n2 = 0;
        while (n2 < n) {
            GrammarEditorShell shell;
            GrammarEditorShellController controller;
            String formName;
            JInternalFrame currentForm = jInternalFrameArray[n2];
            if (currentForm.isVisible() && (formName = currentForm.getClass().getSimpleName()).equals("GrammarEditorShell") && (controller = (shell = (GrammarEditorShell)currentForm).getController()).getFullName().equals(gname)) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }

    public void modify() {
        this.modified = true;
        if (this.fullName == null) {
            packageConfigDialog.setTitle("Untitled [Modified]");
        } else {
            packageConfigDialog.setTitle(String.valueOf(FilenameUtils.getName(this.fullName)) + "[Modified]");
        }
    }

    private void unmodify() {
        this.modified = false;
        if (this.fullName == null) {
            packageConfigDialog.setTitle("Untitled");
        } else {
            packageConfigDialog.setTitle(FilenameUtils.getName(this.fullName));
        }
    }

    public void save() {
        this.save(this.fullName, false);
    }

    public void saveProjectForNooj() {
        String dirName = String.valueOf(Paths.applicationDir) + System.getProperty("file.separator") + "resources" + System.getProperty("file.separator") + "initial" + Launcher.preferences.deflanguage + System.getProperty("file.separator") + "Projects";
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        if (this.fullName == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "This project has no name.", "NooJ", 0);
            return;
        }
        String fName = FilenameUtils.getName(this.fullName);
        String noojName = String.valueOf(dirName) + System.getProperty("file.separator") + fName;
        CursorChangeEffect.setCustomCursor(3);
        this.save(noojName, true);
        CursorChangeEffect.setCustomCursor(0);
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File " + noojName + " has been updated.", "NooJ Update", 1);
    }

    private void save(String fullName, boolean forNooj) {
        if (!forNooj) {
            int answer;
            String fNameNoExt = FilenameUtils.removeExtension(fullName);
            if (fNameNoExt.charAt(0) == '_' && (answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0)) == 1) {
                return;
            }
            try {
                Utilities.savePreviousVersion(fullName, Launcher.preferences.multiplebackups);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        project.save(packageConfigDialog.getTableFiles(), packageConfigDialog.getTextDocumentation(), fullName, Paths.docDir, this.languagesResourcesLex, this.languagesResourcesSyn);
        if (!forNooj) {
            this.fullName = fullName;
        }
        this.unmodify();
    }

    public void saveProject() {
        SaveProjectActionListener.saveProject();
    }

    public void saveAsProject() {
        SaveProjectActionListener.saveAsProject();
    }

    private void updateFromProject() {
        String type;
        DefaultTableModel model = (DefaultTableModel)packageConfigDialog.getTableFiles().getModel();
        model.getDataVector().removeAllElements();
        model.fireTableDataChanged();
        ArrayList<Object> listOfFiles = project.getListOfFiles();
        int i = 0;
        while (i < listOfFiles.size()) {
            type = (String)listOfFiles.get(i);
            if (!type.equals("Locate")) {
                String fName = (String)listOfFiles.get(i + 1);
                WindowPosition wp = (WindowPosition)listOfFiles.get(i + 2);
                this.add(type, fName, "--", wp);
            }
            i += 3;
        }
        i = 0;
        while (i < listOfFiles.size()) {
            type = (String)listOfFiles.get(i);
            if (type.equals("Locate")) {
                DialogStatus ds = (DialogStatus)listOfFiles.get(i + 2);
                this.addDialogLocate(ds);
            }
            i += 3;
        }
        this.updatePreferenceFromProject();
        this.unmodify();
    }

    private void updatePreferenceFromProject() {
        packageConfigDialog.getTextDocumentation().setText("");
        this.languagesResourcesLex = new ArrayList();
        this.languagesResourcesSyn = new ArrayList();
        try {
            Launcher.preferences = new Preferences(String.valueOf(this.fullName) + "_dir");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot update preferences from project", "NooJ", 0);
        }
        JTextArea rtbResources = packageConfigDialog.getTextResources();
        for (String languageName : Launcher.preferences.languages) {
            int pr;
            String temp;
            String prio;
            String ext;
            String fName;
            File resource;
            int n;
            int n2;
            File[] fileArray;
            File[] resourceFiles;
            rtbResources.append("Language '" + languageName + "': ");
            String lDirName = FilenameUtils.concat(String.valueOf(this.fullName) + "_dir", languageName);
            String tDirName = FilenameUtils.concat(lDirName, "Lexical Analysis");
            File tDir = new File(tDirName);
            if (!tDir.exists()) {
                tDirName = lDirName;
            }
            if ((resourceFiles = tDir.listFiles()) != null) {
                if (resourceFiles.length == 0) {
                    rtbResources.append("No lexical resource\n");
                } else {
                    rtbResources.append("Lexical resources: \n");
                    fileArray = resourceFiles;
                    n2 = resourceFiles.length;
                    n = 0;
                    while (n < n2) {
                        resource = fileArray[n];
                        fName = resource.getName();
                        ext = FilenameUtils.getExtension(fName);
                        if (ext.equals("jnod") || ext.equals("jnom") || ext.equals("nog") && !tDirName.equals(lDirName)) {
                            prio = fName.substring(0, 2);
                            fName = temp = fName.substring(2);
                            pr = Integer.parseInt(prio);
                            if (pr > 0) {
                                rtbResources.append("-- " + fName + " (Low Priority " + pr + ")\n");
                            } else if (pr == 0) {
                                rtbResources.append("-- " + fName + "\n");
                            } else {
                                rtbResources.append("-- " + fName + " (High Priority " + Math.abs(pr) + ")\n");
                            }
                            this.languagesResourcesLex.add(languageName);
                            this.languagesResourcesLex.add(fName);
                            this.languagesResourcesLex.add(pr);
                        }
                        ++n;
                    }
                }
            }
            if (!(tDir = new File(tDirName = FilenameUtils.concat(lDirName, "Syntactic Analysis"))).exists()) {
                tDirName = lDirName;
            }
            if ((resourceFiles = tDir.listFiles()) == null) continue;
            if (resourceFiles.length == 0) {
                rtbResources.append("No syntactic resource\n");
                continue;
            }
            rtbResources.append("Syntactic resources: \n");
            fileArray = resourceFiles;
            n2 = resourceFiles.length;
            n = 0;
            while (n < n2) {
                resource = fileArray[n];
                fName = resource.getName();
                ext = FilenameUtils.getExtension(fName);
                if (ext.equals("nog")) {
                    prio = fName.substring(0, 2);
                    fName = temp = fName.substring(2);
                    pr = Integer.parseInt(prio);
                    rtbResources.append("-- " + fName + " (Step #" + pr + ")\n");
                    this.languagesResourcesSyn.add(languageName);
                    this.languagesResourcesSyn.add(fName);
                    this.languagesResourcesSyn.add(pr);
                }
                ++n;
            }
        }
    }

    public void setPackageConfigDialog(PackageConfigurationDialog packageConfigDialog) {
        PackageConfigurationDialogController.packageConfigDialog = packageConfigDialog;
    }

    private boolean openAllFiles(String projName) {
        String type;
        String prjDir = String.valueOf(projName) + "_dir";
        ArrayList<Object> listOfFiles = project.getListOfFiles();
        int i = 0;
        while (i < listOfFiles.size()) {
            type = (String)listOfFiles.get(i);
            if (!type.equals("Locate")) {
                String fName = (String)listOfFiles.get(i + 1);
                WindowPosition wp = (WindowPosition)listOfFiles.get(i + 2);
                String fullName = FilenameUtils.concat(prjDir, fName);
                if (!this.openFile(type, fullName, wp)) {
                    return false;
                }
            }
            i += 3;
        }
        i = 0;
        while (i < listOfFiles.size()) {
            type = (String)listOfFiles.get(i);
            if (type.equals("Locate")) {
                JInternalFrame[] allFrames;
                DialogStatus ds = (DialogStatus)listOfFiles.get(i + 2);
                LocateDialog dl = null;
                JInternalFrame[] jInternalFrameArray = allFrames = Launcher.getDesktopPane().getAllFrames();
                int n = allFrames.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame currentForm = jInternalFrameArray[n2];
                    if (FilenameUtils.getName(currentForm.getTitle()).equals(ds.getParentWindowName())) {
                        JInternalFrame shell;
                        if (currentForm.getClass().getName().equals("TextEditorShell")) {
                            shell = (TextEditorShell)currentForm;
                            dl = ((TextEditorShell)shell).getLocateDialog();
                            break;
                        }
                        shell = (CorpusEditorShell)currentForm;
                        dl = ((CorpusEditorShell)shell).getController().getLocateDialog();
                        break;
                    }
                    ++n2;
                }
                if (dl != null) {
                    dl.getNooJRegeXCombo().setSelectedItem(ds.getRexp());
                    String gram = ds.getGram();
                    dl.getNooJGrammarPathCombo().setSelectedItem(gram);
                    String radioQuery = ds.getRadioQuery();
                    dl.getSyntacticAnalysisCBox().setSelected(radioQuery.charAt(0) == 'G');
                    if (!gram.equals("")) {
                        String grmName = FilenameUtils.concat(prjDir, gram);
                        File gramFile = new File(grmName);
                        if (gramFile.exists()) {
                            dl.getNooJGrammarPathCombo().setSelectedItem(grmName);
                        } else {
                            dl.getNooJGrammarPathCombo().setSelectedItem("CANNOT FIND " + gram);
                        }
                    }
                    if (radioQuery.equals("string")) {
                        dl.getRbStringPattern().setSelected(true);
                    } else if (radioQuery.equals("perl re")) {
                        dl.getRbPerlPattern().setSelected(true);
                    } else if (radioQuery.equals("nooj re")) {
                        dl.getRbNooJPattern().setSelected(true);
                    } else if (radioQuery.equals("grammar")) {
                        dl.getRbNooJGrammar().setSelected(true);
                    } else if (radioQuery.equals("Grammar")) {
                        dl.getRbNooJGrammar().setSelected(true);
                        dl.getSyntacticAnalysisCBox().setSelected(true);
                    }
                    dl.show();
                }
            }
            i += 3;
        }
        String docFilePath = FilenameUtils.concat(prjDir, "ReadMe.rtf");
        File docFile = new File(docFilePath);
        if (docFile.exists()) {
            packageConfigDialog.getTextDocumentation().setText("TODO");
            if (Launcher.projectMode && !packageConfigDialog.getTextDocumentation().getText().equals("")) {
                if (formDocumentation == null) {
                    try {
                        formDocumentation = new DocumentationDialog(docFilePath);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(e.getMessage()) + "2", "NooJ: cannot load documentation", 0);
                        return false;
                    }
                    catch (BadLocationException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(e.getMessage()) + "2", "NooJ: cannot load documentation", 0);
                        return false;
                    }
                }
                Launcher.getDesktopPane().add(formDocumentation);
                formDocumentation.setVisible(true);
            }
        }
        return true;
    }

    private boolean openFile(String type, String fullName, WindowPosition wp) {
        File file = new File(fullName);
        if (type.equals("Text")) {
            TextEditorShellController controller = new TextEditorShellController(file);
            TextEditorShell shell = controller.openText(file);
            UnitSelectionListener unitSelectionListener = shell.getUnitSelectionListener();
            JTextPane textPane = shell.getTextPane();
            textPane.removeCaretListener(unitSelectionListener);
            shell.getTextController().rtbTextUpdate(true);
            textPane.addCaretListener(unitSelectionListener);
            controller.updateTextPaneStats();
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
        } else if (type.equals("Corpus")) {
            CorpusEditorShellController controller = new CorpusEditorShellController(null, null, null, null);
            CorpusEditorShell shell = controller.openNoojCorpus(file, false);
            controller.openNoojEngine();
            if (controller == null || controller.getCorpus() == null) {
                return false;
            }
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
        } else if (type.equals("Dictionary")) {
            DictionaryEditorShell shell = DictionaryEditorShellController.openNooJDictionary(fullName);
            DictionaryEditorShellController controller = shell.getController();
            if (controller == null) {
                return false;
            }
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
        } else if (type.equals("FlexDesc")) {
            FlexDescEditorShell shell = new FlexDescEditorShell();
            FlexDescEditorShellController controller = shell.getController();
            if (controller == null) {
                return false;
            }
            controller.loadFromFile(fullName);
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
        } else if (type.equals("DicoDef")) {
            PropDefEditorShell shell = new PropDefEditorShell();
            PropDefEditorShellController controller = shell.getController();
            if (controller == null) {
                return false;
            }
            controller.loadFromFile(fullName);
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
        } else if (type.equals("Grammar")) {
            GrammarEditorShell shell = new GrammarEditorShell(fullName);
            GrammarEditorShellController controller = shell.getController();
            if (controller == null) {
                return false;
            }
            controller.LoadGrammar(fullName, false);
            ArrayList<JInternalFrame> list = project.getListOfForms();
            list.add(shell);
            project.setListOfForms(list);
            shell.setBounds(wp.getPosX(), wp.getPosY(), wp.getWidth(), wp.getHeight());
            shell.show();
        }
        return true;
    }

    public void openProject(String fullName) {
        File dir;
        String dFullName;
        String lName;
        String zName;
        String zFullName;
        File fileInProjectDir;
        File[] filesInProjectDir;
        projectDir = String.valueOf(fullName) + "_dir";
        File prDir = new File(projectDir);
        Launcher.setOpenDirectories();
        try {
            if (prDir.exists()) {
                Utils.deleteDir(prDir);
            }
            Zip.uncompressDir(projectDir, fullName);
        }
        catch (IOException e) {
            boolean success;
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: project file corrupted (1)", 0);
            if (prDir.exists() && !(success = Utils.deleteDir(prDir))) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: cannot delete temporary directory " + projectDir, 0);
            }
            Launcher.projectMode = false;
            return;
        }
        boolean oldMethod = false;
        File[] fileArray = filesInProjectDir = prDir.listFiles();
        int n = filesInProjectDir.length;
        int n2 = 0;
        while (n2 < n) {
            fileInProjectDir = fileArray[n2];
            zFullName = fileInProjectDir.getAbsolutePath();
            if (FilenameUtils.getExtension(zFullName).equals("zip")) {
                zName = fileInProjectDir.getName();
                lName = FilenameUtils.removeExtension(zName);
                dFullName = FilenameUtils.concat(projectDir, lName);
                try {
                    Zip.uncompressDir(dFullName, zFullName);
                    oldMethod = true;
                    dir = new File(dFullName);
                    if (!dir.exists()) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no linguistic resources for language " + lName, "NooJ Project Warning", 1);
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no linguistic resources for language " + lName, "NooJ Project Warning", 1);
                    return;
                }
                String zLex = FilenameUtils.concat(dFullName, "Lexical Analysis.zip");
                String lex = FilenameUtils.concat(projectDir, FilenameUtils.concat(lName, "Lexical Analysis"));
                File lexFile = new File(zLex);
                if (lexFile.exists()) {
                    try {
                        Zip.uncompressDir(lex, zLex);
                        lexFile = new File(lex);
                        if (!lexFile.exists()) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no lexical resources for language " + lName, "NooJ Project Warning", 1);
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no lexical resources for language " + lName, "NooJ Project Warning", 1);
                    }
                }
                String zSyn = FilenameUtils.concat(dFullName, "Syntactic Analysis.zip");
                String syn = FilenameUtils.concat(projectDir, FilenameUtils.concat(lName, "Syntactic Analysis"));
                File synFile = new File(zSyn);
                if (synFile.exists()) {
                    try {
                        Zip.uncompressDir(syn, zSyn);
                        synFile = new File(syn);
                        if (!synFile.exists()) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no syntactic resources for language " + lName, "NooJ Project Warning", 1);
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "There are no syntactic resources for language " + lName, "NooJ Project Warning", 1);
                    }
                }
            }
            ++n2;
        }
        if (!oldMethod) {
            fileArray = filesInProjectDir;
            n = filesInProjectDir.length;
            n2 = 0;
            while (n2 < n) {
                fileInProjectDir = fileArray[n2];
                zFullName = fileInProjectDir.getAbsolutePath();
                zName = fileInProjectDir.getName();
                if (zName.length() >= 7 && zName.charAt(0) == '-' && zName.charAt(3) == '-' && Language.isALanguage(lName = zName.substring(1, 3))) {
                    String dsa;
                    File synDir;
                    String dla;
                    File lexDir;
                    dFullName = FilenameUtils.concat(projectDir, lName);
                    dir = new File(dFullName);
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!(lexDir = new File(dla = FilenameUtils.concat(dFullName, "Lexical Analysis"))).exists()) {
                        lexDir.mkdir();
                    }
                    if (!(synDir = new File(dsa = FilenameUtils.concat(dFullName, "Syntactic Analysis"))).exists()) {
                        synDir.mkdir();
                    }
                    if (zName.substring(4).equals("_properties.def")) {
                        File srcFile = new File(zFullName);
                        File destFile = new File(FilenameUtils.concat(dla, "_properties.def"));
                        try {
                            FileUtils.moveFile(srcFile, destFile);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                        }
                    } else if (zName.length() >= 7 && zName.charAt(6) == '-') {
                        File destFile;
                        File srcFile;
                        String tName = zName.substring(7);
                        String typeOfResource = zName.substring(4, 6);
                        if (typeOfResource.equals("LA")) {
                            srcFile = new File(zFullName);
                            destFile = new File(FilenameUtils.concat(dla, tName));
                            try {
                                FileUtils.moveFile(srcFile, destFile);
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                            }
                        } else if (typeOfResource.equals("SA")) {
                            srcFile = new File(zFullName);
                            destFile = new File(FilenameUtils.concat(dsa, tName));
                            try {
                                FileUtils.moveFile(srcFile, destFile);
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        packageConfigDialog.setTitle(FilenameUtils.getName(fullName));
        packageConfigDialog.getTableFiles().setFont(Launcher.preferences.TFont);
        this.modified = false;
        this.fullName = fullName;
        project = Project.load(String.valueOf(this.fullName) + "_dir");
        if (project != null) {
            this.updateFromProject();
            if (!this.openAllFiles(this.fullName)) {
                project = null;
            } else {
                this.unmodify();
            }
        }
        if (project == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load project " + fullName, "NooJ", 1);
            return;
        }
        Dic.writeLog("Open Project " + FilenameUtils.getName(fullName));
    }

    public static void closeProject() {
        File dir;
        Launcher.getMntmRunProject().setText("Run Project");
        Launcher.getMntmNewProject().setEnabled(true);
        if (project == null) {
            return;
        }
        if (formDocumentation != null) {
            formDocumentation.dispose();
            formDocumentation = null;
        }
        for (JInternalFrame form : project.getListOfForms()) {
            if (!form.isVisible()) continue;
            form.dispose();
        }
        if (packageConfigDialog != null) {
            packageConfigDialog.dispose();
        }
        String prjDir = projectDir;
        if (projectDir != null && (dir = new File(prjDir)).exists()) {
            Utils.deleteDir(dir);
        }
        project = null;
        Launcher.getStatusBar().getProjectLabel().setText("");
        Launcher.projectMode = false;
        projectDir = null;
        Launcher.preferences = Launcher.savedPreferences;
        Launcher.setOpenDirectories();
    }

    public PackageConfigurationDialog getPackageConfigDialog() {
        return packageConfigDialog;
    }

    public static Project getProject() {
        return project;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public static String getProjectDir() {
        return projectDir;
    }

    public static void setProjectDir(String projectDir) {
        PackageConfigurationDialogController.projectDir = projectDir;
    }
}

