/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.packageconfigurationdialog;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.nooj4nlp.controller.packageconfigurationdialog.DialogStatus;
import net.nooj4nlp.controller.packageconfigurationdialog.WindowPosition;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.engine.Zip;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Project
implements Serializable {
    private static final long serialVersionUID = -6147896220161601998L;
    private ArrayList<Object> listOfFiles;
    private transient ArrayList<JInternalFrame> listOfForms = new ArrayList();

    public static Project load(String prjdir) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Project prj = null;
        try {
            fis = new FileInputStream(FilenameUtils.concat(prjdir, "project.xml"));
            ois = new ObjectInputStream(fis);
            prj = (Project)ois.readObject();
            fis.close();
        }
        catch (FileNotFoundException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream!", 0);
        }
        catch (IOException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
        catch (ClassNotFoundException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
        }
        prj.listOfForms = new ArrayList();
        return prj;
    }

    /*
     * WARNING - void declaration
     */
    public void save(JTable table, JTextPane rtbText, String projname, String docdir, ArrayList<Object> languagesResourcesLex, ArrayList<Object> languagesResourcesSyn) {
        void var10_13;
        File f2;
        File f1;
        String tname;
        String sname;
        String sdirname;
        int priority;
        boolean found;
        Object lname;
        void var10_11;
        String prjdir = String.valueOf(projname) + "_dir";
        File f = new File(prjdir);
        if (!f.exists()) {
            f.mkdir();
        }
        ArrayList<Object> languages = new ArrayList<Object>();
        boolean bl = false;
        while (var10_11 < languagesResourcesLex.size()) {
            lname = (String)languagesResourcesLex.get((int)var10_11);
            found = false;
            for (String string : languages) {
                if (!string.equalsIgnoreCase((String)lname)) continue;
                found = true;
                break;
            }
            if (!found) {
                languages.add(lname);
            }
            String string = (String)languagesResourcesLex.get((int)(var10_11 + true));
            priority = (Integer)languagesResourcesLex.get((int)(var10_11 + 2));
            sdirname = FilenameUtils.concat(docdir, FilenameUtils.concat((String)lname, "Lexical Analysis"));
            sname = FilenameUtils.concat(sdirname, string);
            tname = null;
            tname = priority < 0 ? FilenameUtils.concat(prjdir, "-" + (String)lname + "-LA-" + String.format("%1d", priority) + string) : FilenameUtils.concat(prjdir, "-" + (String)lname + "-LA-" + String.format("%02d", priority) + string);
            f1 = new File(sname);
            f2 = new File(tname);
            if (f1.exists() && !f2.exists()) {
                try {
                    FileUtils.copyFile(f1, f2);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                }
            }
            var10_11 += 3;
        }
        boolean bl2 = false;
        while (var10_13 < languagesResourcesSyn.size()) {
            lname = (String)languagesResourcesSyn.get((int)var10_13);
            found = false;
            for (String string : languages) {
                if (!string.equalsIgnoreCase((String)lname)) continue;
                found = true;
                break;
            }
            if (!found) {
                languages.add(lname);
            }
            String string = (String)languagesResourcesSyn.get((int)(var10_13 + true));
            priority = (Integer)languagesResourcesSyn.get((int)(var10_13 + 2));
            sdirname = FilenameUtils.concat(docdir, FilenameUtils.concat((String)lname, "Syntactic Analysis"));
            sname = FilenameUtils.concat(sdirname, string);
            tname = null;
            tname = FilenameUtils.concat(prjdir, "-" + (String)lname + "-SA-" + String.format("%02d", priority) + string);
            f1 = new File(sname);
            f2 = new File(tname);
            if (f1.exists() && !f2.exists()) {
                try {
                    FileUtils.copyFile(f1, f2);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                }
            }
            var10_13 += 3;
        }
        for (String string : languages) {
            String sdirname2 = FilenameUtils.concat(docdir, FilenameUtils.concat(string, "Lexical Analysis"));
            String string2 = FilenameUtils.concat(sdirname2, "_properties.def");
            String tname2 = FilenameUtils.concat(prjdir, "-" + string + "-" + "_properties.def");
            File f12 = new File(string2);
            File f22 = new File(tname2);
            if (!f12.exists() || f22.exists()) continue;
            try {
                FileUtils.copyFile(f12, f22);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        StyledDocument styledDocument = (StyledDocument)rtbText.getDocument();
        HTMLEditorKit kit = new HTMLEditorKit();
        String rtfFilePath = FilenameUtils.concat(prjdir, "ReadMe.rtf");
        BufferedWriter bufferedWriter = null;
        try {
            File rtfFile = new File(rtfFilePath);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(rtfFile));
            BufferedWriter bufferedWriter2 = new BufferedWriter(outputStreamWriter);
            kit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
            bufferedWriter2.close();
        }
        catch (FileNotFoundException e1) {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "NooJ", 0);
            return;
        }
        catch (IOException e1) {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "NooJ", 0);
            return;
        }
        catch (BadLocationException e) {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "NooJ", 0);
            return;
        }
        this.listOfFiles = new ArrayList();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            String type = (String)model.getValueAt(i, 0);
            if (type.equals("Locate")) {
                DialogStatus ds = (DialogStatus)model.getValueAt(i, 3);
                this.listOfFiles.add(type);
                this.listOfFiles.add("");
                this.listOfFiles.add(ds);
            } else {
                String fName = (String)model.getValueAt(i, 1);
                String dName = (String)model.getValueAt(i, 2);
                WindowPosition wp = (WindowPosition)model.getValueAt(i, 3);
                this.listOfFiles.add(type);
                this.listOfFiles.add(fName);
                this.listOfFiles.add(wp);
                String fullName = FilenameUtils.concat(dName, fName);
                String resName = FilenameUtils.concat(prjdir, fName);
                if (!fullName.equals(resName)) {
                    File src = new File(fullName);
                    if (!src.exists()) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file " + fullName, "NooJ", 0);
                        return;
                    }
                    File dest = new File(resName);
                    try {
                        FileUtils.copyFile(src, dest);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    }
                }
            }
            ++i;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(FilenameUtils.concat(prjdir, "project.xml"));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.flush();
            fos.close();
        }
        catch (IOException e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException fName) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
        File projDir = new File(projname);
        if (projDir.exists()) {
            Utils.deleteDir(projDir);
        }
        try {
            Zip.compressDir(prjdir, projname);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
    }

    public ArrayList<Object> getListOfFiles() {
        return this.listOfFiles;
    }

    public ArrayList<JInternalFrame> getListOfForms() {
        return this.listOfForms;
    }

    public void setListOfForms(ArrayList<JInternalFrame> listOfForms) {
        this.listOfForms = listOfForms;
    }
}

