/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.gui.components.CustomCell;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;

public class CopyToPreferences {
    private JComboBox cbDefLanguage;
    private JCheckBox cbBackups;
    private JTable lvDic;
    private JTable lvMor;
    private JTable lvSGrm;
    private PreferencesDialog dialog;

    public CopyToPreferences(PreferencesDialog dialog) {
        this.dialog = dialog;
    }

    public void CopyToPref() {
        Font DFont;
        this.cbDefLanguage = this.dialog.getCbDefLanguage();
        this.cbBackups = this.dialog.getChckbxNoojManagesMultiple();
        if (this.cbDefLanguage.getSelectedItem() != null) {
            Launcher.preferences.deflanguage = (String)this.cbDefLanguage.getSelectedItem();
            this.CopyLvsToPref(Launcher.preferences.deflanguage);
        }
        Launcher.preferences.multiplebackups = this.cbBackups.isSelected();
        Font TFont = this.dialog.getTFont();
        if (TFont != null) {
            Launcher.preferences.TFont = new Font(TFont.getName(), TFont.getStyle(), TFont.getSize());
        }
        if ((DFont = this.dialog.getDFont()) != null) {
            Launcher.preferences.DFont = new Font(DFont.getName(), DFont.getStyle(), DFont.getSize());
        }
        Launcher.modifyAllFonts();
    }

    private void CopyLvsToPref(String lname) {
        String prio;
        ArrayList<String> f = new ArrayList<String>();
        this.lvDic = this.dialog.getTableDictionary();
        this.lvMor = this.dialog.getTableMorphology();
        DefaultTableModel dicModel = (DefaultTableModel)this.lvDic.getModel();
        for (Vector item : dicModel.getDataVector()) {
            Vector row = item;
            boolean selected = ((CustomCell)row.get((int)0)).checkBox.isSelected();
            if (!selected) continue;
            String fname = ((CustomCell)row.get((int)0)).label.getText();
            String prio2 = (String)row.get(1);
            if (prio2.equalsIgnoreCase("")) {
                fname = "00" + fname;
            } else if (prio2.startsWith("H")) {
                fname = "-" + prio2.substring(1) + fname;
            } else if (prio2.startsWith("L")) {
                fname = "0" + prio2.substring(1) + fname;
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "in lvdic: prio = " + prio2 + " for fname = " + fname, "MDS-DEBUG", 0);
                continue;
            }
            f.add(fname);
        }
        DefaultTableModel morModel = (DefaultTableModel)this.lvMor.getModel();
        for (Object e : morModel.getDataVector()) {
            Vector row = (Vector)e;
            boolean selected = ((CustomCell)row.get((int)0)).checkBox.isSelected();
            if (!selected) continue;
            String fname = ((CustomCell)row.get((int)0)).label.getText();
            prio = (String)row.get(1);
            if (prio.equalsIgnoreCase("")) {
                fname = "00" + fname;
            } else if (prio.startsWith("H")) {
                fname = "-" + prio.substring(1) + fname;
            } else if (prio.startsWith("L")) {
                fname = "0" + prio.substring(1) + fname;
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "in lvdic: prio = " + prio + " for fname = " + fname, "MDS-DEBUG", 0);
                continue;
            }
            f.add(fname);
        }
        Launcher.preferences.ldic.put(lname, f);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.lvSGrm = this.dialog.getTableResources();
        DefaultTableModel grmModel = (DefaultTableModel)this.lvSGrm.getModel();
        for (Vector item : grmModel.getDataVector()) {
            Vector row = item;
            prio = Integer.toString((Integer)row.get(0));
            if (prio.equalsIgnoreCase("")) continue;
            String fname = (String)row.get(1);
            if (prio.length() == 0 || prio.length() > 2) {
                prio = "00";
            } else if (prio.length() == 1) {
                prio = "0" + prio;
            }
            fname = String.valueOf(prio) + fname;
            arrayList.add(fname);
        }
        Launcher.preferences.lsyn.put(lname, arrayList);
    }
}

