/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.preferencesdialog.UpdateDialogListener;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.components.CustomCell;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ImportLexActionListener
implements ActionListener {
    private PreferencesDialog dialog = null;
    private UpdateDialogListener updateDialogListener;

    public ImportLexActionListener(PreferencesDialog dialog, UpdateDialogListener updateDialogListener) {
        this.dialog = dialog;
        this.updateDialogListener = updateDialogListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File sourceFile = e.getSource() == this.dialog.getBtnImportFileLex() ? this.openFileDialog(true) : this.openFileDialog(false);
        if (sourceFile == null || !sourceFile.exists()) {
            return;
        }
        String extension = FilenameUtils.getExtension(sourceFile.getName());
        String pathToSave = "Lexical Analysis";
        if (extension.equals("nog")) {
            pathToSave = "Syntactic Analysis";
        }
        String language = (String)this.dialog.getCbDefLanguage().getSelectedItem();
        String to = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + language + System.getProperty("file.separator") + pathToSave + System.getProperty("file.separator") + sourceFile.getName();
        File targetFile = new File(to);
        if (targetFile.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File + " + sourceFile.getAbsolutePath() + " - exists. Delete it first!", "NooJ: invalid operation", 0);
            return;
        }
        try {
            FileUtils.copyFile(sourceFile, targetFile);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
        CustomCell cell = new CustomCell();
        cell.getLabel().setText(sourceFile.getName());
        cell.getLabel().setSize(cell.getLabel().getPreferredSize().width, cell.getLabel().getPreferredSize().height);
        cell.setForeground(Color.BLACK);
        String fileExtension = FilenameUtils.getExtension(sourceFile.getName());
        if (fileExtension.equals("jnod")) {
            ((DefaultTableModel)this.dialog.getTableDictionary().getModel()).addRow(new Object[]{cell, ""});
        } else if (fileExtension.equals("jnom")) {
            ((DefaultTableModel)this.dialog.getTableMorphology().getModel()).addRow(new Object[]{cell, ""});
        } else {
            ((DefaultListModel)this.dialog.getListSynResources().getModel()).addElement(sourceFile.getName());
        }
        this.updateDialogListener.updateFromFormMainPreferences();
    }

    private File openFileDialog(boolean lexPageActive) {
        FileNameExtensionFilter filter;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open a grammar");
        FileNameExtensionFilter additionalFilter = null;
        if (lexPageActive) {
            filter = new FileNameExtensionFilter("Dictionaries (*.jnod)", "jnod", "jnod");
            additionalFilter = new FileNameExtensionFilter("Morphology (*.jnom)", "jnom", "jnom");
        } else {
            filter = new FileNameExtensionFilter("Syntactic grammar (*.nog)", "nog", "nog");
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(filter);
        if (lexPageActive) {
            fileChooser.addChoosableFileFilter(additionalFilter);
        }
        fileChooser.setFileFilter(filter);
        fileChooser.showOpenDialog(this.dialog);
        return fileChooser.getSelectedFile();
    }
}

