/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.preferencesdialog.UpdateDialogListener;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;

public class LoadActionListener
implements ActionListener {
    private PreferencesDialog dialog;
    private UpdateDialogListener updateDialogListener;

    public LoadActionListener(PreferencesDialog dialog, UpdateDialogListener updateDialogListener) {
        this.updateDialogListener = updateDialogListener;
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File sourceFile = this.openFileDialog();
        if (sourceFile == null) {
            return;
        }
        Preferences preferences = Preferences.Load(sourceFile.getAbsolutePath());
        if (preferences == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load preference file", "NooJ setup problem?", 0);
            return;
        }
        Launcher.preferences = preferences;
        this.updateDialogListener.updateFromFormMainPreferences();
    }

    private File openFileDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open Preferences");
        FileNameExtensionFilter filterImportLex = new FileNameExtensionFilter("Preferences|*.jnoj", "jnoj");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(filterImportLex);
        fileChooser.setFileFilter(filterImportLex);
        fileChooser.showOpenDialog(this.dialog);
        return fileChooser.getSelectedFile();
    }
}

