/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.nooj4nlp.controller.preferencesdialog.SelectDefLanguageActionListener;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;

public class UpdateDialogListener {
    private JComboBox cbDefLanguage;
    private Font TFont;
    private Font DFont;
    private JLabel fText;
    private JLabel fDic;
    private JCheckBox chckbxNoojManagesMultiple;
    private PreferencesDialog dialog;

    public UpdateDialogListener(PreferencesDialog dialog, JComboBox cbDefLanguage, Font TFont, Font DFont, JLabel fText, JLabel fDic, JCheckBox chckbxNoojManagesMultiple) {
        this.cbDefLanguage = cbDefLanguage;
        this.TFont = TFont;
        this.DFont = DFont;
        this.fDic = fDic;
        this.fText = fText;
        this.chckbxNoojManagesMultiple = chckbxNoojManagesMultiple;
        this.dialog = dialog;
    }

    public void updateFromFormMainPreferences() {
        this.cbDefLanguage.removeAllItems();
        if (Launcher.preferences.deflanguage == null) {
            return;
        }
        if (Launcher.projectMode) {
            for (String lan : Launcher.preferences.languages) {
                this.cbDefLanguage.addItem(lan);
            }
            this.cbDefLanguage.setSelectedIndex(0);
        } else {
            SelectDefLanguageActionListener selectDefLangListener = this.dialog.getSelectDefLanguageListener();
            this.cbDefLanguage.removeActionListener(selectDefLangListener);
            String[] stringArray = Language.getAllLanguages();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lan = stringArray[n2];
                this.cbDefLanguage.addItem(lan);
                ++n2;
            }
            this.cbDefLanguage.addActionListener(selectDefLangListener);
            int index = -1;
            int i = 0;
            while (i < this.cbDefLanguage.getItemCount()) {
                if (Launcher.preferences.deflanguage.equalsIgnoreCase((String)this.cbDefLanguage.getItemAt(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                this.cbDefLanguage.setSelectedIndex(index);
            }
        }
        this.chckbxNoojManagesMultiple.setSelected(Launcher.preferences.multiplebackups);
        Font f = Launcher.preferences.TFont;
        this.TFont = new Font(f.getName(), f.getStyle(), f.getSize());
        this.fText.setText(String.valueOf(this.TFont.getName()) + ", " + this.TFont.getSize());
        if (this.TFont.isBold()) {
            this.fText.setText(String.valueOf(this.fText.getText()) + ", Bold");
        }
        if (this.TFont.isItalic()) {
            this.fText.setText(String.valueOf(this.fText.getText()) + ", Italic");
        }
        f = Launcher.preferences.DFont;
        this.DFont = new Font(f.getName(), f.getStyle(), f.getSize());
        this.fDic.setText(String.valueOf(this.DFont.getName()) + ", " + this.DFont.getSize());
        if (this.DFont.isBold()) {
            this.fDic.setText(String.valueOf(this.fDic.getText()) + ", Bold");
        }
        if (this.DFont.isItalic()) {
            this.fDic.setText(String.valueOf(this.fDic.getText()) + ", Italic");
        }
        this.fText.setFont(this.TFont);
        this.fDic.setFont(this.DFont);
    }
}

