/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.preferencesdialog.LexTableMouseListener;
import net.nooj4nlp.controller.preferencesdialog.SynTableMouseListener;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.components.CustomCell;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class UpdateTablesListener {
    private JTable lvDic;
    private JTable lvMor;
    private JList lbAvailableSyntacticResources;
    private JTable lvSGrm;
    private PreferencesDialog dialog;
    private String docDirLex;
    private String docDirSyn;
    private String prjDirLex;
    private String prjDirSyn;

    public UpdateTablesListener(JTable lvDic, JTable lvMor, JList lbAvailableSyntacticResources, JTable lvSGrm, PreferencesDialog dialog) {
        this.lvDic = lvDic;
        this.lvMor = lvMor;
        this.dialog = dialog;
        this.lbAvailableSyntacticResources = lbAvailableSyntacticResources;
        this.lvSGrm = lvSGrm;
    }

    public void GetAllResourcesFromDisk(boolean projectmode, String languagename) {
        this.lvDic = this.dialog.getTableDictionary();
        DefaultTableModel dicModel = (DefaultTableModel)this.lvDic.getModel();
        if (dicModel.getRowCount() > 0) {
            dicModel.getDataVector().removeAllElements();
            dicModel.fireTableDataChanged();
        }
        this.lvDic.addMouseListener(new LexTableMouseListener(this.lvDic, this.lvMor, this.dialog, true));
        this.lvMor = this.dialog.getTableMorphology();
        DefaultTableModel morModel = (DefaultTableModel)this.lvMor.getModel();
        if (morModel.getRowCount() > 0) {
            morModel.getDataVector().removeAllElements();
            morModel.fireTableDataChanged();
        }
        this.lvMor.addMouseListener(new LexTableMouseListener(this.lvDic, this.lvMor, this.dialog, false));
        this.lvSGrm = this.dialog.getTableResources();
        DefaultTableModel resModel = (DefaultTableModel)this.lvSGrm.getModel();
        this.lvSGrm.addMouseListener(new SynTableMouseListener(this.lvSGrm, this.lbAvailableSyntacticResources, this.dialog, false));
        this.lbAvailableSyntacticResources = this.dialog.getListSynResources();
        DefaultListModel listModel = (DefaultListModel)this.lbAvailableSyntacticResources.getModel();
        if (listModel.size() > 0) {
            listModel.clear();
        }
        this.lbAvailableSyntacticResources.addMouseListener(new SynTableMouseListener(this.lvSGrm, this.lbAvailableSyntacticResources, this.dialog, true));
        boolean loadprojectresources = false;
        if (projectmode) {
            String zname = FilenameUtils.concat(Paths.projectDir, languagename);
            File dir = new File(zname);
            loadprojectresources = dir.isDirectory();
        }
        if (!loadprojectresources) {
            int n;
            this.docDirLex = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + languagename + System.getProperty("file.separator") + "Lexical Analysis";
            File ldir = new File(this.docDirLex);
            if (!ldir.isDirectory()) {
                ldir.mkdirs();
            } else {
                String[] list;
                this.lvDic.getColumn("Dictionary").setCellRenderer(new CellEditorRenderer());
                this.lvDic.getColumn("Dictionary").setCellEditor(new CellEditorRenderer());
                this.lvMor.getColumn("Morphology").setCellRenderer(new CellEditorRenderer());
                this.lvMor.getColumn("Morphology").setCellEditor(new CellEditorRenderer());
                String[] stringArray = list = ldir.list();
                n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    File f;
                    CustomCell value;
                    String file = stringArray[n2];
                    String ext = FilenameUtils.getExtension(file);
                    if (ext.equalsIgnoreCase("jnod")) {
                        value = new CustomCell();
                        value.label.setText(file);
                        value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                        f = new File(String.valueOf(this.docDirLex) + System.getProperty("file.separator") + file.substring(0, file.lastIndexOf(".")) + "nog");
                        if (f.exists()) {
                            value.setForeground(Color.RED);
                        }
                        dicModel.addRow(new Object[]{value, ""});
                    } else if (ext.equalsIgnoreCase("jnom")) {
                        value = new CustomCell();
                        value.label.setText(file);
                        value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                        f = new File(String.valueOf(this.docDirLex) + System.getProperty("file.separator") + file.substring(0, file.lastIndexOf(".")) + "jnom");
                        if (f.exists()) {
                            value.setForeground(Color.RED);
                        }
                        morModel.addRow(new Object[]{value, ""});
                    }
                    ++n2;
                }
            }
            this.docDirSyn = String.valueOf(Paths.docDir) + System.getProperty("file.separator") + languagename + System.getProperty("file.separator") + "Syntactic Analysis";
            File sdir = new File(this.docDirSyn);
            if (!sdir.isDirectory()) {
                sdir.mkdirs();
            } else {
                String[] list;
                String[] stringArray = list = sdir.list();
                int n3 = list.length;
                n = 0;
                while (n < n3) {
                    String file = stringArray[n];
                    String ext = FilenameUtils.getExtension(file);
                    if (ext.equalsIgnoreCase("nog")) {
                        listModel.addElement(file);
                    }
                    ++n;
                }
            }
        } else {
            this.lvDic.getColumn("Dictionary").setCellRenderer(new CellEditorRenderer());
            this.lvDic.getColumn("Dictionary").setCellEditor(new CellEditorRenderer());
            this.lvMor.getColumn("Morphology").setCellRenderer(new CellEditorRenderer());
            this.lvMor.getColumn("Morphology").setCellEditor(new CellEditorRenderer());
            String lexName = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(languagename, "Lexical Analysis"));
            File lexDir = new File(lexName);
            this.prjDirLex = lexDir.exists() ? lexName : FilenameUtils.concat(Paths.projectDir, languagename);
            File tempDir = new File(this.prjDirLex);
            File[] fileArray = tempDir.listFiles();
            int n = fileArray.length;
            int n4 = 0;
            while (n4 < n) {
                File file = fileArray[n4];
                String fullName = file.getName();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Resource file " + fullName + " does not exist.", "NooJ: Project file is invalid", 1);
                } else {
                    String dName = file.getParent();
                    String fName = fullName;
                    String fName2 = fName.substring(2);
                    String ext = FilenameUtils.getExtension(fullName);
                    if (ext.equalsIgnoreCase("jnod")) {
                        Color c = Color.black;
                        String nogFileName = FilenameUtils.concat(dName, FilenameUtils.concat(FilenameUtils.removeExtension(fullName), "nog"));
                        File nogFile = new File(nogFileName);
                        if (nogFile.exists()) {
                            c = Color.red;
                        }
                        CustomCell value = new CustomCell();
                        value.label.setText(fName2);
                        value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                        value.setForeground(c);
                        dicModel.addRow(new Object[]{value, ""});
                    } else if (ext.equalsIgnoreCase("jnom")) {
                        morModel.addRow(new Object[]{new JCheckBox(fName2), ""});
                    }
                }
                ++n4;
            }
            this.lvSGrm.getColumn("Grammar").setCellRenderer(new CellEditorRenderer());
            this.lvSGrm.getColumn("Grammar").setCellEditor(new CellEditorRenderer());
            String synName = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(languagename, "Syntactic Analysis"));
            File synDir = new File(synName);
            this.prjDirSyn = synDir.exists() ? synName : FilenameUtils.concat(Paths.projectDir, languagename);
            tempDir = new File(this.prjDirSyn);
            File[] fileArray2 = tempDir.listFiles();
            int n5 = fileArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                File file = fileArray2[n6];
                String fullName = file.getName();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Resource file " + fullName + " does not exist.", "NooJ: Project file is invalid", 1);
                } else {
                    String fName = fullName;
                    String pref = fName.substring(0, 2);
                    String fName2 = fName.substring(2);
                    String ext = FilenameUtils.getExtension(fullName);
                    if (ext.equalsIgnoreCase("nog")) {
                        resModel.addRow(new Object[]{pref, fName2});
                        listModel.addElement(fName2);
                    }
                }
                ++n6;
            }
        }
    }

    public void GetAllResourcesFromPref(String languagename) {
        String ext;
        int i;
        ArrayList<String> f = Launcher.preferences.ldic.get(languagename);
        if (f != null) {
            i = 0;
            while (i < f.size()) {
                String prefname = f.get(i);
                ext = FilenameUtils.getExtension(prefname);
                if (ext.equalsIgnoreCase("jnod")) {
                    this.CheckPrefResourceInLvLex(prefname, this.dialog.getTableDictionary());
                } else if (ext.equalsIgnoreCase("jnom")) {
                    this.CheckPrefResourceInLvLex(prefname, this.dialog.getTableMorphology());
                }
                ++i;
            }
        }
        if ((f = Launcher.preferences.lsyn.get(languagename)) != null) {
            i = 0;
            while (i < f.size()) {
                String prefName = f.get(i);
                ext = FilenameUtils.getExtension(prefName);
                if (ext.equalsIgnoreCase("nog")) {
                    String pref = prefName.substring(0, 2);
                    String fName = prefName.substring(2);
                    int prio = 0;
                    prio = Integer.parseInt(pref);
                    if (prio != 0) {
                        this.CheckPrefResourceInLvSyn(fName, prio, this.lvSGrm);
                    }
                }
                ++i;
            }
        }
    }

    private void CheckPrefResourceInLvLex(String prefname, JTable lv) {
        String fName = prefname;
        String prio = "";
        if (lv == this.lvSGrm) {
            prio = fName.substring(0, 2);
            if (Character.isDigit(prio.charAt(0))) {
                if (Character.isDigit(prio.charAt(1))) {
                    fName = fName.substring(1);
                } else {
                    prio = prio.substring(0, 1);
                    fName = fName.substring(1);
                }
            }
            if (prio.equals("0") || prio.equals("00")) {
                prio = "";
            }
        } else {
            int priority;
            String prefx = fName.substring(0, 2);
            try {
                priority = Integer.parseInt(prefx);
            }
            catch (Exception e) {
                priority = 0;
            }
            prio = priority < 0 ? "H" + String.valueOf(-priority) : (priority > 0 ? "L" + String.valueOf(priority) : "");
            fName = fName.substring(2);
        }
        DefaultTableModel model = (DefaultTableModel)lv.getModel();
        Vector<Vector> dataVector = model.getDataVector();
        Object[] data = dataVector.toArray();
        int i = 0;
        while (i < data.length) {
            Vector file = (Vector)data[i];
            CustomCell value = (CustomCell)file.get(0);
            String fname2 = value.label.getText();
            if (fname2.equalsIgnoreCase(fName)) {
                value.checkBox.setSelected(true);
                model.setValueAt(value, i, 0);
                model.setValueAt(prio, i, 1);
                return;
            }
            ++i;
        }
    }

    private void CheckPrefResourceInLvSyn(String fname, int priority, JTable lvSGrm) {
        DefaultTableModel model = (DefaultTableModel)lvSGrm.getModel();
        model.addRow(new Object[]{priority, fname});
    }

    class CellEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = -7918950819212313412L;
        private CustomCell renderer = new CustomCell();
        private CustomCell editor = new CustomCell();

        CellEditorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer = (CustomCell)value;
            if (isSelected) {
                this.renderer.setBackground(table.getSelectionBackground());
            } else {
                this.renderer.setBackground(table.getBackground());
            }
            return this.renderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor = (CustomCell)value;
            this.editor.setBackground(table.getSelectionBackground());
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }
    }
}

