/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.helper.DotNetToJavaStringHelper;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Dic {
    private static int LEMMA_PREFIX_LENGTH = "LEMMA".length();
    private static int CAT_PREFIX_LENGTH = "CAT".length();
    private static int ENT_PREFIX_LENTH = "ENT".length();
    public static String LogFileName;

    static void initLoad(OutputStreamWriter writer, String languageName) throws IOException {
        ParameterCheck.mandatory("writer", writer);
        writer.write("# NooJ V3\n");
        writer.write("# Dictionary\n");
        writer.write("#\n");
        writer.write("# Input Language is: " + languageName + "\n");
        writer.write("#\n");
        writer.write("# Alphabetical order is not required.\n");
        writer.write("#\n");
        writer.write("# Use any number of inflectional/derivational description files (.nof), e.g.:\n");
        writer.write("# Special Command: #use description.nof\n");
        writer.write("# INFLECTIONAL AND DERIVATIONAL DESCRIPTION FILES MUST BE STORED IN SAME DIRECTORY AS THE DICTIONARY\n");
        writer.write("#\n");
        writer.write("# Special Features: +NW (non-word) +FXC (frozen expression component) +UNAMB (unambiguous lexical entry)\n");
        writer.write("#                   +FLX= (inflectional paradigm) +DRV (derivational paradigm)\n");
        writer.write("#\n");
        writer.write("# Special Characters: '\\' '\"' '+' ',' '#' ' '\n");
        writer.write("#\n");
    }

    private static boolean parseFactorizedInfo(String line0, RefObject<String> lemma, RefObject<String> info) {
        info.argvalue = null;
        lemma.argvalue = null;
        int index = -1;
        int ii = 0;
        while (ii < line0.length()) {
            if (line0.charAt(ii) == '\\') {
                ++ii;
            } else if (line0.charAt(ii) == '<') {
                ++ii;
                while (ii < line0.length() && line0.charAt(ii) != '>') {
                    ++ii;
                }
            } else if (line0.charAt(ii) == '{') {
                ++ii;
                while (ii < line0.length() && line0.charAt(ii) != '}') {
                    ++ii;
                }
            } else if (line0.charAt(ii) == '#') {
                index = ii;
                break;
            }
            ++ii;
        }
        String line = index == -1 ? line0 : line0.substring(0, index);
        if (line.length() == 0) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                sb.append(line.charAt(++i));
            } else if (line.charAt(i) == '<') {
                sb.append(line.charAt(i));
                ++i;
                while (i < line.length() && line.charAt(i) != '>') {
                    sb.append(line.charAt(i));
                    ++i;
                }
                sb.append(line.charAt(i));
            } else if (line.charAt(i) == '{') {
                sb.append(line.charAt(i));
                ++i;
                while (i < line.length() && line.charAt(i) != '}') {
                    sb.append(line.charAt(i));
                    ++i;
                }
                sb.append(line.charAt(i));
            } else {
                sb.append(line.charAt(i));
            }
            ++i;
        }
        if (i == line.length()) {
            info.argvalue = line;
            return true;
        }
        lemma.argvalue = sb.toString();
        info.argvalue = line.substring(i + 1);
        Character[] charactersToTrim = null;
        info.argvalue = DotNetToJavaStringHelper.trimEnd((String)info.argvalue, charactersToTrim);
        return !((String)info.argvalue).equals("");
    }

    static boolean parseFactorizedInfo(String line0, RefObject<String> lemma, RefObject<String> info, RefObject<String> category, RefObject<String[]> features) {
        ParameterCheck.mandatory("line0", line0);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("info", info);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        if (!Dic.parseFactorizedInfo(line0, lemma, info)) {
            return false;
        }
        category.argvalue = null;
        features.argvalue = null;
        int k = 0;
        while (k < ((String)info.argvalue).length() && Character.isUpperCase(((String)info.argvalue).charAt(k))) {
            ++k;
        }
        category.argvalue = ((String)info.argvalue).substring(0, k);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        String allfeatures = ((String)info.argvalue).substring(k);
        features.argvalue = Dic.splitAllFeaturesWithPlus(allfeatures);
        return true;
    }

    static boolean isALexicalConstraint(String symbol) {
        if (symbol == null || symbol.length() == 0) {
            return false;
        }
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        int i = 1;
        while (i < symbol.length()) {
            if (symbol.charAt(i) == '\\') {
                ++i;
            } else {
                if (symbol.charAt(i) == ',' || symbol.charAt(i) == '<') {
                    return false;
                }
                if (symbol.charAt(i) == '=') {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isALexicalSymbol(String symbol) {
        ParameterCheck.mandatoryString("symbol", symbol);
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        int i = 1;
        while (i < symbol.length() - 1) {
            if (symbol.charAt(i) == '=') {
                return false;
            }
            if (symbol.charAt(i) == ',') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] parseSequenceOfSymbols(String sequence) {
        ParameterCheck.mandatory("sequence", sequence);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sequence.length()) {
            int j;
            if (sequence.charAt(i) == '<') {
                int embeddedAngle = 0;
                j = 1;
                while (i + j < sequence.length() && (sequence.charAt(i + j) != '>' || sequence.charAt(i + j) == '>' && embeddedAngle != 0)) {
                    if (sequence.charAt(i + j) == '<') {
                        ++embeddedAngle;
                    } else if (sequence.charAt(i + j) == '>') {
                        --embeddedAngle;
                    }
                    ++j;
                }
                if (i + j < sequence.length()) {
                    result.add(sequence.substring(i, i + ++j));
                } else {
                    result.add(sequence.substring(i));
                }
                i += j;
                continue;
            }
            if (Character.isWhitespace(sequence.charAt(i))) {
                ++i;
                continue;
            }
            if (sequence.charAt(i) == '\"') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '\"') {
                    ++j;
                }
                i += ++j;
                continue;
            }
            result.add(String.valueOf(sequence.charAt(i)));
            ++i;
        }
        String[] res = result.toArray(new String[result.size()]);
        return res;
    }

    public static boolean isThereALexicalConstraint(ArrayList<String> symbols) {
        ParameterCheck.mandatory("symbols", symbols);
        int i = 0;
        while (i < symbols.size()) {
            String so = symbols.get(i);
            if (so != null && !so.equals("")) {
                int iso = 0;
                while (iso < so.length()) {
                    String so2;
                    if (so.charAt(iso) != '<') {
                        ++iso;
                        continue;
                    }
                    int len = -1;
                    len = 1;
                    while (iso + len < so.length()) {
                        if (so.charAt(iso + len) == '>') break;
                        ++len;
                    }
                    if (iso + len < so.length() && Dic.isALexicalConstraint(so2 = so.substring(iso, iso + len + 1))) {
                        return true;
                    }
                    iso += len + 1;
                }
            }
            ++i;
        }
        return false;
    }

    public static String noComment(String buf) {
        ParameterCheck.mandatory("buf", buf);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < buf.length()) {
            if (buf.charAt(i) == '#') {
                while (i < buf.length() && buf.charAt(i) != '\n') {
                    ++i;
                }
            }
            char c = buf.charAt(i);
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static int getRule(String line, int ibuf, RefObject<String> category, RefObject<String> property, RefObject<String[]> features, RefObject<String> errMessage) {
        ParameterCheck.mandatory("line", line);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("property", property);
        ParameterCheck.mandatory("features", features);
        ParameterCheck.mandatory("errmessage", errMessage);
        errMessage.argvalue = null;
        property.argvalue = null;
        category.argvalue = null;
        features.argvalue = null;
        int i = ibuf;
        while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        if (i == line.length()) {
            return -1;
        }
        int j = 0;
        while (i + j < line.length() && line.charAt(i + j) != '=' && !Character.isWhitespace(line.charAt(i + j))) {
            ++j;
        }
        if (i + j == line.length()) {
            return -1;
        }
        category.argvalue = line.substring(i, i + j);
        int index = ((String)category.argvalue).indexOf(95);
        if (index != -1) {
            property.argvalue = ((String)category.argvalue).substring(index + 1);
            category.argvalue = ((String)category.argvalue).substring(0, index);
        }
        int k = 0;
        while (i + j + k < line.length() && line.charAt(i + j + k) != '=' && Character.isWhitespace(line.charAt(i + j + k))) {
            ++k;
        }
        if (i + j + k == line.length() || line.charAt(i + j + k) != '=') {
            errMessage.argvalue = "Syntax Error: '=' is missing";
            Dic.writeLog((String)errMessage.argvalue);
            return -1;
        }
        int m = 1;
        while (i + j + k + m < line.length() && line.charAt(i + j + k + m) != ';') {
            ++m;
        }
        if (i + j + k + m == line.length() || line.charAt(i + j + k + m) != ';') {
            errMessage.argvalue = "Syntax Error: ';' is missing";
            Dic.writeLog((String)errMessage.argvalue);
            return -1;
        }
        String exp = line.substring(i + j + k + 1, i + j + k + 1 + m - 1);
        features.argvalue = exp.split("[+|]", -1);
        int ifeat = 0;
        while (ifeat < ((String[])features.argvalue).length) {
            ((String[])features.argvalue)[ifeat] = ((String[])features.argvalue)[ifeat].trim();
            ++ifeat;
        }
        return i + j + k + m + 1;
    }

    public static boolean getProperty(String feature, String category, HashMap<String, String> properties, RefObject<String> propertyName, RefObject<String> propertyValue) {
        ParameterCheck.mandatory("feature", feature);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("propertyName", propertyName);
        ParameterCheck.mandatory("propertyValue", propertyValue);
        propertyName.argvalue = propertyValue.argvalue = feature;
        int index = feature.indexOf(61);
        if (index != -1) {
            propertyName.argvalue = feature.substring(0, index);
            propertyValue.argvalue = feature.substring(index + 1);
            return true;
        }
        if (properties == null) {
            return false;
        }
        String property = properties.get(String.valueOf(category) + "_" + feature);
        if (property == null) {
            return false;
        }
        propertyName.argvalue = property;
        propertyValue.argvalue = feature;
        return true;
    }

    static ArrayList<String> normalizeInformation(String category, String[] features, HashMap<String, String> properties) {
        if (features == null || features.length == 0) {
            ArrayList<String> infos = new ArrayList<String>();
            infos.add(category);
            return infos;
        }
        ArrayList lfeatures = new ArrayList(features.length);
        Collections.addAll(lfeatures, features);
        ArrayList<String> res = new ArrayList<String>();
        res.add(category);
        int i = 0;
        while (i < lfeatures.size()) {
            String ifeat = (String)lfeatures.get(i);
            String ipropname = null;
            String ipropvalue = null;
            RefObject<Object> tempRef_ipropname = new RefObject<Object>(ipropname);
            RefObject<Object> tempRef_ipropvalue = new RefObject<Object>(ipropvalue);
            Dic.getProperty(ifeat, category, properties, tempRef_ipropname, tempRef_ipropvalue);
            ipropname = (String)tempRef_ipropname.argvalue;
            ipropvalue = (String)tempRef_ipropvalue.argvalue;
            ArrayList<String> res2 = new ArrayList<String>();
            int j = 0;
            while (j < res.size()) {
                String info = res.get(j);
                if (ipropname.equals(ipropvalue)) {
                    res2.add(String.valueOf(info) + "+" + ipropname);
                } else {
                    res2.add(String.valueOf(info) + "+" + ipropname + "=" + ipropvalue);
                }
                ++j;
            }
            if (!ipropname.equals("DRV") && i + 1 < lfeatures.size()) {
                j = i + 1;
                while (j < lfeatures.size()) {
                    String jfeat = (String)lfeatures.get(j);
                    String jpropname = null;
                    String jpropvalue = null;
                    RefObject<Object> tempRef_jpropname = new RefObject<Object>(jpropname);
                    RefObject<Object> tempRef_jpropvalue = new RefObject<Object>(jpropvalue);
                    Dic.getProperty(jfeat, category, properties, tempRef_jpropname, tempRef_jpropvalue);
                    jpropname = (String)tempRef_jpropname.argvalue;
                    jpropvalue = (String)tempRef_jpropvalue.argvalue;
                    if (ipropname.equals(jpropname)) {
                        int k = 0;
                        while (k < res.size()) {
                            String info = res.get(k);
                            if (jpropname.equals(jpropvalue)) {
                                res2.add(String.valueOf(info) + "+" + jpropname);
                            } else {
                                res2.add(String.valueOf(info) + "+" + jpropname + "=" + jpropvalue);
                            }
                            ++k;
                        }
                        lfeatures.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
            res = res2;
            ++i;
        }
        return res;
    }

    static boolean normalizeLexicalEntry(String line, Engine engine, RefObject<ArrayList<String>> lines) {
        ParameterCheck.mandatory("engine", engine);
        ParameterCheck.mandatory("lines", lines);
        String entry = null;
        String lemma = null;
        String category = null;
        String[] features = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(line, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            return false;
        }
        ArrayList<String> infos = Dic.normalizeInformation(category, features, engine.properties);
        if (infos == null || infos.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < infos.size()) {
            String info = infos.get(i);
            String line0 = String.valueOf(entry) + "," + lemma + "," + info;
            if (lines.argvalue == null) {
                lines.argvalue = new ArrayList();
            }
            ((ArrayList)lines.argvalue).add(line0);
            ++i;
        }
        return true;
    }

    static boolean normalizeLexemeSymbol(String lexeme, Engine engine, RefObject<ArrayList<String>> lexemes) {
        ParameterCheck.mandatoryString("lexeme", lexeme);
        ParameterCheck.mandatory("lexemes", lexemes);
        String line = lexeme.substring(1, 1 + lexeme.length() - 2);
        ArrayList lines = null;
        RefObject<Object> tempRef_lines = new RefObject<Object>(lines);
        boolean tempVar = !Dic.normalizeLexicalEntry(line, engine, tempRef_lines);
        lines = (ArrayList)tempRef_lines.argvalue;
        if (tempVar) {
            return false;
        }
        int i = 0;
        while (i < lines.size()) {
            String line0 = (String)lines.get(i);
            if (lexemes.argvalue == null) {
                lexemes.argvalue = new ArrayList();
            }
            ((ArrayList)lexemes.argvalue).add("<" + line0 + ">");
            ++i;
        }
        return true;
    }

    static String getPropertyValue(String feature) {
        ParameterCheck.mandatory("feature", feature);
        int index = feature.indexOf(61);
        if (index == -1) {
            return feature;
        }
        return feature.substring(index + 1);
    }

    public static String getPropertyValue(String propertyName, String information) {
        String[] features;
        ParameterCheck.mandatory("propertyName", propertyName);
        ParameterCheck.mandatory("information", information);
        int index = information.indexOf(43);
        if (index == -1) {
            return null;
        }
        String info = information.substring(index);
        String[] stringArray = features = Dic.splitAllFeaturesWithPlus(info);
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            String name = null;
            String value = null;
            RefObject<Object> tempRef_name = new RefObject<Object>(name);
            RefObject<Object> tempRef_value = new RefObject<Object>(value);
            Dic.getPropertyNameValue(feat, tempRef_name, tempRef_value);
            name = (String)tempRef_name.argvalue;
            value = (String)tempRef_value.argvalue;
            if (propertyName.equals(name)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static String cleanUpDoubleQuotes(String info) {
        ParameterCheck.mandatory("info", info);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        i = 0;
        while (i < info.length()) {
            if (info.charAt(i) == '\\') {
                sb.append('\\');
                sb.append(info.charAt(++i));
                ++i;
                continue;
            }
            if (info.charAt(i) == '\"') {
                sb.append('\"');
                ++i;
                while (i < info.length() && info.charAt(i) != '\"') {
                    sb.append(info.charAt(i));
                    ++i;
                }
                if (i < info.length()) {
                    sb.append('\"');
                }
                ++i;
                continue;
            }
            if (info.charAt(i) != '=') {
                sb.append(info.charAt(i));
                ++i;
                continue;
            }
            sb.append('=');
            StringBuilder sval = new StringBuilder();
            boolean thereIsDoubleQuote = false;
            ++i;
            while (i < info.length() && info.charAt(i) != '+') {
                if (info.charAt(i) == '\\') {
                    sval.append('\\');
                    sval.append(info.charAt(++i));
                    ++i;
                    continue;
                }
                if (info.charAt(i) != '\"') {
                    sval.append(info.charAt(i));
                    ++i;
                    continue;
                }
                thereIsDoubleQuote = true;
                ++i;
                while (i < info.length() && info.charAt(i) != '\"') {
                    sval.append(info.charAt(i));
                    ++i;
                }
                ++i;
            }
            if (thereIsDoubleQuote) {
                sb.append('\"');
                sb.append((CharSequence)sval);
                sb.append('\"');
                continue;
            }
            sb.append((CharSequence)sval);
        }
        return sb.toString();
    }

    public static String protectComma(String entry) {
        ParameterCheck.mandatory("entry", entry);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < entry.length()) {
            if (entry.charAt(i) == ',') {
                sb.append('\\');
            }
            sb.append(entry.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static boolean parseDELAS(String line, RefObject<String> entry, RefObject<String> info) {
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("info", info);
        info.argvalue = null;
        entry.argvalue = null;
        line = Dic.cleanUpDoubleQuotes(line);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                sb.append('\\');
                sb.append(line.charAt(++i));
            } else if (line.charAt(i) == '\"') {
                sb.append('\"');
                ++i;
                while (i < line.length() && line.charAt(i) != '\"') {
                    sb.append(line.charAt(i));
                    ++i;
                }
                sb.append('\"');
            } else {
                sb.append(line.charAt(i));
            }
            ++i;
        }
        if (i == line.length()) {
            return false;
        }
        entry.argvalue = sb.toString();
        info.argvalue = line.substring(i + 1);
        return !((String)info.argvalue).equals("");
    }

    public static boolean parseDELAS(String line, RefObject<String> entry, RefObject<String> category, RefObject<String> features) {
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        features.argvalue = null;
        category.argvalue = null;
        entry.argvalue = null;
        String info = null;
        RefObject<Object> tempRef_info = new RefObject<Object>(info);
        boolean tempVar = !Dic.parseDELAS(line, entry, tempRef_info);
        info = (String)tempRef_info.argvalue;
        if (tempVar) {
            return false;
        }
        if (info.length() == 0) {
            return false;
        }
        if (info.charAt(0) < 'A' || info.charAt(0) > 'Z') {
            return false;
        }
        int i = 0;
        while (i < info.length() && info.charAt(i) >= 'A' && info.charAt(i) <= 'Z') {
            ++i;
        }
        if (i >= info.length()) {
            category.argvalue = info;
        } else {
            category.argvalue = info.substring(0, i);
            features.argvalue = info.substring(i);
            if (((String)features.argvalue).charAt(0) != '+') {
                return false;
            }
        }
        return true;
    }

    public static boolean parseDELASFeatureArray(String line, RefObject<String> entry, RefObject<String> category, RefObject<String[]> features) {
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        category.argvalue = null;
        entry.argvalue = null;
        features.argvalue = null;
        String allFeatures = null;
        RefObject<Object> tempRef_allFeatures = new RefObject<Object>(allFeatures);
        boolean tempVar = !Dic.parseDELAS(line, entry, category, tempRef_allFeatures);
        allFeatures = (String)tempRef_allFeatures.argvalue;
        if (tempVar) {
            return false;
        }
        features.argvalue = Dic.splitAllFeaturesWithPlus(allFeatures);
        return true;
    }

    public static boolean parseContracted(String line, RefObject<String> entry, RefObject<String> info) {
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("info", info);
        info.argvalue = null;
        entry.argvalue = null;
        if (!Dic.parseDELAS(line, entry, info)) {
            return false;
        }
        if (((String)info.argvalue).length() == 0) {
            return false;
        }
        return ((String)info.argvalue).charAt(0) == '<';
    }

    public static boolean parseDELAF(String line, RefObject<String> entry, RefObject<String> lemma, RefObject<String> info) {
        ParameterCheck.mandatory("line", line);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("info", info);
        info.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        if (line.length() == 0) {
            return false;
        }
        line = Dic.cleanUpDoubleQuotes(line);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                sb.append(line.charAt(++i));
            } else if (line.charAt(i) == '<') {
                sb.append(line.charAt(i));
                ++i;
                while (i < line.length() && line.charAt(i) != '>') {
                    sb.append(line.charAt(i));
                    ++i;
                }
                sb.append(line.charAt(i));
            } else if (line.charAt(i) == '\"') {
                sb.append(line.charAt(i));
                ++i;
                while (i < line.length() && line.charAt(i) != '\"') {
                    sb.append(line.charAt(i));
                    ++i;
                }
                sb.append(line.charAt(i));
            } else {
                sb.append(line.charAt(i));
            }
            ++i;
        }
        if (i == line.length()) {
            return false;
        }
        entry.argvalue = sb.toString();
        sb = new StringBuilder();
        int j = i + 1;
        while (j < line.length() && line.charAt(j) != ',') {
            if (line.charAt(j) == '\\') {
                sb.append(line.charAt(++j));
            } else if (line.charAt(j) == '<') {
                sb.append(line.charAt(j));
                ++j;
                while (j < line.length() && line.charAt(j) != '>') {
                    sb.append(line.charAt(j));
                    ++j;
                }
                if (j == line.length()) {
                    return false;
                }
                sb.append(line.charAt(j));
            } else {
                sb.append(line.charAt(j));
            }
            ++j;
        }
        if (j == line.length()) {
            lemma.argvalue = null;
            info.argvalue = line.substring(i + 1, i + 1 + j - i - 1).trim();
            return true;
        }
        lemma.argvalue = sb.toString();
        info.argvalue = line.substring(j + 1);
        return !((String)info.argvalue).equals("");
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parseDELAF(String line, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String> features) {
        ParameterCheck.mandatory("line", line);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        features.argvalue = null;
        category.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        if (line.length() == 0) {
            return false;
        }
        line = Dic.cleanUpDoubleQuotes(line);
        sb = new StringBuilder();
        i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            sb.append(line.charAt(i));
            ++i;
        }
        if (i == line.length()) {
            return false;
        }
        entry.argvalue = sb.toString();
        sb = new StringBuilder();
        j = i + 1;
        while (j < line.length() && line.charAt(j) != ',') {
            block21: {
                if (line.charAt(j) != '\\') break block21;
                ++j;
                ** GOTO lbl-1000
            }
            if (line.charAt(j) == '\"') {
                ++j;
                while (j < line.length() && line.charAt(j) != '\"') {
                    sb.append(line.charAt(j));
                    ++j;
                }
                if (j == line.length()) {
                    return false;
                }
            } else if (line.charAt(j) == '<') {
                sb.append('<');
                ++j;
                while (j < line.length() && line.charAt(j) != '>') {
                    sb.append(line.charAt(j));
                    ++j;
                }
                if (j == line.length()) {
                    return false;
                }
                sb.append('>');
            } else lbl-1000:
            // 2 sources

            {
                sb.append(line.charAt(j));
            }
            ++j;
        }
        if (j >= line.length()) {
            lemma.argvalue = (String)entry.argvalue;
            j = i;
        } else {
            lemma.argvalue = sb.toString();
            if (((String)lemma.argvalue).equals("")) {
                lemma.argvalue = (String)entry.argvalue;
            }
        }
        k = j + 1;
        while (k < line.length() && Character.isUpperCase(line.charAt(k))) {
            ++k;
        }
        category.argvalue = line.substring(j + 1, j + 1 + k - j - 1);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        if (k == line.length()) {
            features.argvalue = "";
        } else if (line.charAt(k) != '+' && line.charAt(k) != '=') {
            return false;
        }
        features.argvalue = line.substring(k);
        return true;
    }

    public static boolean parseDELAFFeatureArray(String line, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features) {
        ParameterCheck.mandatory("features", features);
        String allFeatures = null;
        features.argvalue = null;
        RefObject<Object> tempRef_allFeatures = new RefObject<Object>(allFeatures);
        boolean tempVar = !Dic.parseDELAF(line, entry, lemma, category, tempRef_allFeatures);
        allFeatures = (String)tempRef_allFeatures.argvalue;
        if (tempVar) {
            return false;
        }
        features.argvalue = Dic.splitAllFeaturesWithPlus(allFeatures);
        return true;
    }

    public static boolean isALexemeSymbol(String lexeme) {
        ParameterCheck.mandatory("lexeme", lexeme);
        if (lexeme.length() < 2 || lexeme.charAt(0) != '<' || lexeme.charAt(lexeme.length() - 1) != '>') {
            return false;
        }
        String entry = null;
        String lemma = null;
        String category = null;
        String info = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_info = new RefObject<Object>(info);
        boolean tempVar = Dic.parseDELAF(lexeme.substring(1, 1 + lexeme.length() - 2), tempRef_entry, tempRef_lemma, tempRef_category, tempRef_info);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        info = (String)tempRef_info.argvalue;
        return tempVar;
    }

    public static boolean isALexicalAnnotation(String lexeme) {
        String entry = null;
        String lemma = null;
        String info = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_info = new RefObject<Object>(info);
        boolean tempVar = Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, tempRef_info);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        info = (String)tempRef_info.argvalue;
        return tempVar;
    }

    private static boolean invalidCategory(String cat) {
        ParameterCheck.mandatory("cat", cat);
        int i = 0;
        while (i < cat.length()) {
            if (cat.charAt(i) < 'A' || cat.charAt(i) > 'Z') {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean parseXmlInfo(String info, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String> features) {
        if (info == null || info.length() == 0) {
            return false;
        }
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        features.argvalue = null;
        category.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        String[] feats = Dic.getAllFeaturesWithoutPlus(info);
        int i = 0;
        while (i < feats.length) {
            String feat = feats[i];
            if (!feat.equals("")) {
                if (feat.length() >= LEMMA_PREFIX_LENGTH && (feat.substring(0, LEMMA_PREFIX_LENGTH).equals("LEMMA") || feat.substring(0, LEMMA_PREFIX_LENGTH).equals("lemma"))) {
                    lemma.argvalue = feat.substring(LEMMA_PREFIX_LENGTH + 1);
                    if (((String)lemma.argvalue).length() == 0) {
                        lemma.argvalue = "INVALIDLEMMA";
                    } else {
                        if (((String)lemma.argvalue).charAt(0) == '\"') {
                            lemma.argvalue = ((String)lemma.argvalue).substring(1);
                        }
                        if (((String)lemma.argvalue).charAt(((String)lemma.argvalue).length() - 1) == '\"') {
                            lemma.argvalue = ((String)lemma.argvalue).substring(0, ((String)lemma.argvalue).length() - 1);
                        }
                    }
                } else if (feat.length() >= CAT_PREFIX_LENGTH && (feat.substring(0, CAT_PREFIX_LENGTH).equals("CAT") || feat.substring(0, CAT_PREFIX_LENGTH).equals("cat"))) {
                    category.argvalue = feat.substring(CAT_PREFIX_LENGTH + 1);
                    if (Dic.invalidCategory((String)category.argvalue)) {
                        Dic.writeLog("Category '" + (String)category.argvalue + "' is invalid");
                        category.argvalue = "INVALIDCAT";
                    } else {
                        if (((String)category.argvalue).charAt(0) == '\"') {
                            category.argvalue = ((String)category.argvalue).substring(1);
                        }
                        if (((String)category.argvalue).charAt(((String)category.argvalue).length() - 1) == '\"') {
                            category.argvalue = ((String)category.argvalue).substring(0, ((String)category.argvalue).length() - 1);
                        }
                    }
                } else if (feat.length() >= ENT_PREFIX_LENTH && (feat.substring(0, ENT_PREFIX_LENTH).equals("ENT") || feat.substring(0, ENT_PREFIX_LENTH).equals("ent"))) {
                    entry.argvalue = feat.substring(new String("ENT").length() + 1);
                    if (((String)entry.argvalue).length() == 0) {
                        entry.argvalue = "INVALIDENTRY";
                    } else {
                        if (((String)entry.argvalue).charAt(0) == '\"') {
                            entry.argvalue = ((String)entry.argvalue).substring(1);
                        }
                        if (((String)entry.argvalue).charAt(((String)entry.argvalue).length() - 1) == '\"') {
                            entry.argvalue = ((String)entry.argvalue).substring(0, ((String)entry.argvalue).length() - 1);
                        }
                    }
                } else {
                    features.argvalue = features.argvalue == null ? feat : String.valueOf(features.argvalue) + "+" + feat;
                }
            }
            ++i;
        }
        return category.argvalue != null;
    }

    public static String cleanupEntry(String text, boolean xmlText) {
        ParameterCheck.mandatory("text", text);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == ',' || Character.isWhitespace(text.charAt(i)) || Character.isISOControl(text.charAt(i))) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                    sb.append(' ');
                }
            } else if (xmlText && text.charAt(i) == '<') {
                int j = i + 1;
                while (j < text.length() && text.charAt(j) != '>') {
                    ++j;
                }
                i = j;
            } else {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        while (sb.length() > 0 && sb.charAt(0) == ' ') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    static String cleanupXmlEntry(String text) {
        ParameterCheck.mandatory("text", text);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == ',' || text.charAt(i) == '<' || text.charAt(i) == '>' || text.charAt(i) == '\"' || Character.isWhitespace(text.charAt(i)) || Character.isISOControl(text.charAt(i))) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                    sb.append(' ');
                }
            } else {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        while (sb.length() > 0 && sb.charAt(0) == ' ') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    static String cleanupXmlInfo(String info, RefObject<String> xmlCategory) {
        ParameterCheck.mandatory("info", info);
        ParameterCheck.mandatory("xmlCategory", xmlCategory);
        xmlCategory.argvalue = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < info.length() && info.charAt(i) != ' ') {
            if (info.charAt(i) >= 'A' && info.charAt(i) <= 'Z') {
                sb.append(info.charAt(i));
            } else if (info.charAt(i) >= 'a' && info.charAt(i) <= 'z') {
                sb.append(Character.toUpperCase(info.charAt(i)));
            } else {
                sb.append('X');
            }
            ++i;
        }
        xmlCategory.argvalue = sb.toString();
        sb = new StringBuilder();
        if (i < info.length()) {
            while (i < info.length()) {
                if (info.charAt(i) == '\"') {
                    ++i;
                    while (i < info.length() && info.charAt(i) != '\"') {
                        sb.append(info.charAt(i));
                        ++i;
                    }
                } else if (info.charAt(i) == ' ') {
                    sb.append("+");
                    ++i;
                    while (i < info.length() && info.charAt(i) == ' ') {
                        ++i;
                    }
                    --i;
                } else if (info.charAt(i) != '<' && info.charAt(i) != '>') {
                    sb.append(info.charAt(i));
                }
                ++i;
            }
        }
        return sb.toString();
    }

    static String getFullVariableName(String text, int currentPosition, RefObject<Integer> newPosition) {
        ParameterCheck.mandatory("text", text);
        ParameterCheck.mandatory("newPosition", newPosition);
        int i = currentPosition + 1;
        newPosition.argvalue = -1;
        int j = 0;
        while (i + j < text.length() && !Character.isWhitespace(text.charAt(i + j)) && text.charAt(i + j) != '#' && text.charAt(i + j) != '=' && text.charAt(i + j) != ',' && text.charAt(i + j) != '>' && text.charAt(i + j) != '}') {
            ++j;
        }
        String varname = text.toString().substring(i, i + j);
        if ((j += i) < text.length() && text.charAt(j) == '#') {
            ++j;
        }
        newPosition.argvalue = j;
        return varname;
    }

    static boolean parseLexicalConstraint(String symbol, RefObject<String> left, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features, RefObject<String> op, RefObject<Boolean> negation) {
        String line;
        ParameterCheck.mandatory("symbol", symbol);
        ParameterCheck.mandatory("left", left);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        ParameterCheck.mandatory("op", op);
        ParameterCheck.mandatory("negation", negation);
        op.argvalue = null;
        category.argvalue = null;
        lemma.argvalue = null;
        left.argvalue = null;
        features.argvalue = null;
        negation.argvalue = false;
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        if (symbol.charAt(1) == '!') {
            line = symbol.substring(2, 2 + symbol.length() - 3);
            negation.argvalue = true;
        } else {
            line = symbol.substring(1, 1 + symbol.length() - 2);
        }
        if (line.length() == 0) {
            return false;
        }
        int i0 = 0;
        while (i0 < line.length() && line.charAt(i0) != '=') {
            if (line.charAt(i0) == '\\') {
                ++i0;
            }
            ++i0;
        }
        if (i0 == line.length()) {
            return false;
        }
        if (line.charAt(i0 + 1) != ':') {
            if (line.charAt(i0 + 1) == '!') {
                return false;
            }
            if (i0 > 0 && line.charAt(i0 - 1) == '!') {
                op.argvalue = "!=";
                left.argvalue = line.substring(0, i0 - 1);
                lemma.argvalue = line.substring(i0 + 1);
                return true;
            }
            op.argvalue = "=";
            left.argvalue = line.substring(0, i0);
            lemma.argvalue = line.substring(i0 + 1);
            return true;
        }
        if (line.charAt(i0 + 1) == '!') {
            return false;
        }
        op.argvalue = "=:";
        left.argvalue = line.substring(0, i0);
        line = line.substring(i0 + 2);
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i == line.length()) {
            boolean cat = true;
            int ii = 0;
            while (ii < line.length() && line.charAt(ii) != '+' && line.charAt(ii) != '-') {
                if (!Character.isUpperCase(line.charAt(ii))) {
                    cat = false;
                }
                ++ii;
            }
            if (ii == 0) {
                return false;
            }
            if (cat) {
                if (ii == line.length()) {
                    category.argvalue = line;
                    return true;
                }
                category.argvalue = line.substring(0, ii);
            } else {
                if (ii == line.length()) {
                    lemma.argvalue = line;
                    return true;
                }
                lemma.argvalue = line.substring(0, ii);
            }
            if (line.charAt(ii) == '+' || line.charAt(ii) == '-') {
                features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(line.substring(ii));
            }
            return true;
        }
        lemma.argvalue = line.substring(0, i);
        int lastcomma = i;
        int j = i + 1;
        while (j < line.length()) {
            if (line.charAt(j) == '\\') {
                ++j;
            } else if (line.charAt(j) == ',') {
                lastcomma = j;
            }
            ++j;
        }
        int k = lastcomma + 1;
        while (k < line.length() && Character.isUpperCase(line.charAt(k))) {
            ++k;
        }
        category.argvalue = line.substring(lastcomma + 1, lastcomma + 1 + k - lastcomma - 1);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        String allfeatures = line.substring(k);
        if (allfeatures.equals("")) {
            return true;
        }
        if (allfeatures.charAt(0) == '+' || allfeatures.charAt(0) == '-') {
            features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(allfeatures);
            return true;
        }
        return false;
    }

    static boolean parseLexicalConstraintRightSide(String right, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features, RefObject<Boolean> negation) {
        String line;
        ParameterCheck.mandatory("right", right);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        ParameterCheck.mandatory("negation", negation);
        category.argvalue = null;
        lemma.argvalue = null;
        features.argvalue = null;
        negation.argvalue = false;
        if (right.charAt(0) == '!') {
            line = right.substring(1);
            negation.argvalue = true;
        } else {
            line = right;
        }
        if (line.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i == line.length()) {
            boolean cat = true;
            int ii = 0;
            while (ii < line.length() && line.charAt(ii) != '+' && line.charAt(ii) != '-') {
                if (!Character.isUpperCase(line.charAt(ii))) {
                    cat = false;
                }
                ++ii;
            }
            if (ii == 0) {
                return false;
            }
            if (cat) {
                if (ii == line.length()) {
                    category.argvalue = line;
                    return true;
                }
                category.argvalue = line.substring(0, ii);
            } else {
                if (ii == line.length()) {
                    lemma.argvalue = line;
                    return true;
                }
                lemma.argvalue = line.substring(0, ii);
            }
            if (line.charAt(ii) == '+' || line.charAt(ii) == '-') {
                features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(line.substring(ii));
            }
            return true;
        }
        lemma.argvalue = line.substring(0, i);
        int lastcomma = i;
        int j = i + 1;
        while (j < line.length()) {
            if (line.charAt(j) == '\\') {
                ++j;
            } else if (line.charAt(j) == ',') {
                lastcomma = j;
            }
            ++j;
        }
        int k = lastcomma + 1;
        while (k < line.length() && Character.isUpperCase(line.charAt(k))) {
            ++k;
        }
        category.argvalue = line.substring(lastcomma + 1, lastcomma + 1 + k - lastcomma - 1);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        String allFeatures = line.substring(k);
        if (allFeatures.equals("")) {
            return true;
        }
        if (allFeatures.charAt(0) == '+' || allFeatures.charAt(0) == '-') {
            features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(allFeatures);
            return true;
        }
        return false;
    }

    static boolean parseLexicalConstraint(String constraint, RefObject<String> left, RefObject<String> op, RefObject<String> right) {
        ParameterCheck.mandatory("constraint", constraint);
        ParameterCheck.mandatory("left", left);
        ParameterCheck.mandatory("op", op);
        ParameterCheck.mandatory("right", right);
        op.argvalue = null;
        right.argvalue = null;
        left.argvalue = null;
        if (constraint.charAt(0) != '<') {
            return false;
        }
        if (constraint.charAt(constraint.length() - 1) != '>') {
            return false;
        }
        String line = constraint.substring(1, 1 + constraint.length() - 2);
        if (line.length() == 0) {
            return false;
        }
        int i0 = 0;
        while (i0 < line.length() && line.charAt(i0) != '=') {
            if (line.charAt(i0) == '\\') {
                ++i0;
            }
            ++i0;
        }
        if (i0 == line.length()) {
            return false;
        }
        if (line.charAt(i0 + 1) != ':') {
            if (line.charAt(i0 + 1) == '!') {
                return false;
            }
            if (i0 > 0 && line.charAt(i0 - 1) == '!') {
                op.argvalue = "!=";
                left.argvalue = line.substring(0, i0 - 1);
                right.argvalue = line.substring(i0 + 1);
                return true;
            }
            op.argvalue = "=";
            left.argvalue = line.substring(0, i0);
            right.argvalue = line.substring(i0 + 1);
            return true;
        }
        if (line.charAt(i0 + 1) == '!') {
            return false;
        }
        op.argvalue = "=:";
        left.argvalue = line.substring(0, i0);
        right.argvalue = line.substring(i0 + 2);
        return true;
    }

    public static boolean parseSymbolFeatureArray(String symbol, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features, RefObject<Boolean> negation) {
        String line;
        ParameterCheck.mandatory("symbol", symbol);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        ParameterCheck.mandatory("negation", negation);
        category.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        features.argvalue = null;
        negation.argvalue = false;
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        if (symbol.charAt(1) == '!') {
            line = symbol.substring(2, 2 + symbol.length() - 3);
            negation.argvalue = true;
        } else {
            line = symbol.substring(1, 1 + symbol.length() - 2);
        }
        if (line.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i == line.length()) {
            boolean cat = true;
            int ii = 0;
            while (ii < line.length() && line.charAt(ii) != '+' && line.charAt(ii) != '-') {
                if (!Character.isUpperCase(line.charAt(ii))) {
                    cat = false;
                }
                ++ii;
            }
            if (cat) {
                if (ii == line.length()) {
                    category.argvalue = line;
                    return true;
                }
                category.argvalue = line.substring(0, ii);
            } else {
                if (ii == line.length()) {
                    lemma.argvalue = line;
                    return true;
                }
                lemma.argvalue = line.substring(0, ii);
            }
            if (line.charAt(ii) == '+' || line.charAt(ii) == '-') {
                features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(line.substring(ii));
            }
            return true;
        }
        lemma.argvalue = line.substring(0, i);
        int follow = i + 1;
        int j = 0;
        while (follow + j < line.length() && line.charAt(follow + j) != ',') {
            if (line.charAt(follow + j) == '\\') {
                ++j;
            }
            ++j;
        }
        if (follow + j < line.length() && line.charAt(follow + j) == ',') {
            entry.argvalue = (String)lemma.argvalue;
            lemma.argvalue = line.substring(follow, follow + j);
            follow = i + j + 2;
        }
        int k = follow;
        while (k < line.length() && Character.isUpperCase(line.charAt(k))) {
            ++k;
        }
        category.argvalue = line.substring(follow, k);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        String allfeatures = line.substring(k);
        if (allfeatures.equals("")) {
            return true;
        }
        if (allfeatures.charAt(0) == '+' || allfeatures.charAt(0) == '-') {
            features.argvalue = Dic.splitAllFeaturesWithPlusOrMinus(allfeatures);
            return true;
        }
        return false;
    }

    static boolean parseLexicalUnit(String lexeme, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features) {
        ParameterCheck.mandatory("lexeme", lexeme);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        category.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        features.argvalue = null;
        String line = lexeme.substring(4, 4 + lexeme.length() - 5);
        if (line.length() == 0) {
            return false;
        }
        int i0 = 0;
        while (i0 < line.length() && line.charAt(i0) != ',') {
            if (line.charAt(i0) == '\\') {
                ++i0;
            }
            ++i0;
        }
        if (i0 == line.length()) {
            return false;
        }
        entry.argvalue = line.substring(0, i0);
        line = line.substring(i0 + 1);
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i == line.length()) {
            return false;
        }
        lemma.argvalue = line.substring(0, i);
        int k = i + 1;
        while (k < line.length() && Character.isUpperCase(line.charAt(k))) {
            ++k;
        }
        category.argvalue = line.substring(i + 1, i + 1 + k - i - 1);
        if (((String)category.argvalue).equals("") || category.argvalue == null) {
            return false;
        }
        String allfeatures = line.substring(k);
        if (allfeatures.equals("")) {
            return true;
        }
        if (allfeatures.charAt(0) == '+') {
            features.argvalue = Dic.splitAllFeaturesWithPlus(allfeatures);
            return true;
        }
        return false;
    }

    public static boolean parseLexemeSymbol(String symbol, RefObject<String> entry, RefObject<String> lemma, RefObject<String> category, RefObject<String[]> features) {
        ParameterCheck.mandatory("symbol", symbol);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("category", category);
        ParameterCheck.mandatory("features", features);
        category.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        features.argvalue = null;
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        String line = symbol.substring(1, 1 + symbol.length() - 2);
        if (line.length() == 0) {
            return false;
        }
        return Dic.parseDELAFFeatureArray(line, entry, lemma, category, features);
    }

    public static boolean parseLexemeSymbol(String symbol, RefObject<String> entry, RefObject<String> lemma, RefObject<String> info) {
        ParameterCheck.mandatory("symbol", symbol);
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        ParameterCheck.mandatory("info", info);
        info.argvalue = null;
        lemma.argvalue = null;
        entry.argvalue = null;
        if (symbol.charAt(0) != '<') {
            return false;
        }
        if (symbol.charAt(symbol.length() - 1) != '>') {
            return false;
        }
        String line = symbol.substring(1, 1 + symbol.length() - 2);
        if (line.length() == 0) {
            return false;
        }
        return Dic.parseDELAF(line, entry, lemma, info);
    }

    public static boolean getPropertyNameValue(String feature, RefObject<String> propertyName, RefObject<String> propertyValue) {
        ParameterCheck.mandatory("feature", feature);
        ParameterCheck.mandatory("propertyName", propertyName);
        ParameterCheck.mandatory("propertyValue", propertyValue);
        propertyName.argvalue = propertyValue.argvalue = feature;
        int index = feature.indexOf(61);
        if (index == -1) {
            return false;
        }
        propertyName.argvalue = feature.substring(0, index);
        propertyValue.argvalue = feature.substring(index + 1);
        if (propertyValue.argvalue != null && ((String)propertyValue.argvalue).length() > 2 && ((String)propertyValue.argvalue).charAt(0) == '\"' && ((String)propertyValue.argvalue).charAt(((String)propertyValue.argvalue).length() - 1) == '\"') {
            propertyValue.argvalue = ((String)propertyValue.argvalue).substring(1, 1 + ((String)propertyValue.argvalue).length() - 2);
        }
        return true;
    }

    public static String[] getAllFeaturesWithoutPlus(String info) {
        String[] following;
        ParameterCheck.mandatory("info", info);
        ArrayList<String> allfields = new ArrayList<String>();
        int i = 0;
        while (i < info.length() && info.charAt(i) != '+') {
            ++i;
        }
        if (i > 0) {
            allfields.add(info.substring(0, i));
        }
        if (i < info.length() && (following = Dic.splitAllFeaturesWithPlus(info.substring(i))) != null) {
            allfields.addAll(Arrays.asList(following));
        }
        return allfields.toArray(new String[allfields.size()]);
    }

    public static String sortInfos(String info) {
        String[] fields = Dic.getAllFeaturesWithoutPlus(info);
        int i = 0;
        while (i < fields.length) {
            if (fields[i] != null) {
                int j = i + 1;
                while (j < fields.length) {
                    if (fields[i].equals(fields[j])) {
                        fields[j] = null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String fd = stringArray[n2];
            if (fd != null) {
                sb.append("+" + fd);
            }
            ++n2;
        }
        return sb.toString();
    }

    private static String[] splitAllFeaturesWithPlus(String allFeatures) {
        int len;
        if (allFeatures == null || allFeatures.equals("")) {
            return null;
        }
        if (allFeatures.charAt(0) != '+') {
            return null;
        }
        ArrayList<String> feats = new ArrayList<String>();
        for (int i = 0; i < allFeatures.length(); i += len) {
            len = 1;
            while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '+') {
                if (allFeatures.charAt(i + len) == '\\') {
                    ++len;
                } else if (allFeatures.charAt(i + len) == '\"') {
                    ++len;
                    while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '\"') {
                        ++len;
                    }
                } else if (allFeatures.charAt(i + len) == '<') {
                    ++len;
                    while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '>') {
                        ++len;
                    }
                }
                ++len;
            }
            if (i + len < allFeatures.length()) {
                feats.add(allFeatures.substring(i + 1, i + 1 + len - 1));
                continue;
            }
            feats.add(allFeatures.substring(i + 1));
            break;
        }
        return feats.toArray(new String[feats.size()]);
    }

    public static String[] splitAllFeaturesWithPlusOrMinus(String allFeatures) {
        int len;
        if (allFeatures == null || allFeatures.equals("")) {
            return null;
        }
        if (allFeatures.charAt(0) != '+' && allFeatures.charAt(0) != '-') {
            return null;
        }
        ArrayList<String> feats = new ArrayList<String>();
        for (int i = 0; i < allFeatures.length(); i += len) {
            len = 1;
            while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '+' && allFeatures.charAt(i + len) != '-') {
                if (allFeatures.charAt(i + len) == '\\') {
                    ++len;
                } else if (allFeatures.charAt(i + len) == '\"') {
                    ++len;
                    while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '\"') {
                        ++len;
                    }
                } else if (allFeatures.charAt(i + len) == '<') {
                    ++len;
                    while (i + len < allFeatures.length() && allFeatures.charAt(i + len) != '>') {
                        ++len;
                    }
                }
                ++len;
            }
            if (i + len < allFeatures.length()) {
                feats.add(allFeatures.substring(i, i + len));
                continue;
            }
            feats.add(allFeatures.substring(i));
            break;
        }
        return feats.toArray(new String[feats.size()]);
    }

    public static String getRidOfSpecialFeatures(String[] features) {
        if (features == null || features.length == 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            if (!(feat.equals("UNAMB") || feat.length() > 4 && (feat.substring(0, 4).equals("FLX=") || feat.substring(0, 4).equals("DRV=")) || feat.length() > 6 && feat.substring(0, 6).equals("COLOR="))) {
                res.append("+" + feat);
            }
            ++n2;
        }
        return res.toString();
    }

    public static String getRidOfSpecialFeaturesPlus(String[] features) {
        if (features == null || features.length == 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            if (!(feat.equals("UNAMB") || feat.length() > 4 && (feat.substring(0, 4).equals("FLX=") || feat.substring(0, 4).equals("DRV=")) || feat.length() > 5 && feat.substring(0, 5).equals("XREF=") || feat.length() > 6 && feat.substring(0, 6).equals("HIDDEN") || feat.length() > 6 && feat.substring(0, 6).equals("COLOR="))) {
                res.append("+" + feat);
            }
            ++n2;
        }
        return res.toString();
    }

    static String[] getRidOfInflectionalFeatures(String[] features, HashMap<String, Boolean> inflectionalProperties) {
        if (features == null || features.length == 0) {
            return null;
        }
        ArrayList<String> myFeatures = new ArrayList<String>();
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            if (inflectionalProperties != null && inflectionalProperties.size() > 0) {
                int i = feat.indexOf(61);
                String value = i != -1 ? feat.substring(i + 1) : feat;
                if (!inflectionalProperties.containsKey(value)) {
                    myFeatures.add(feat);
                }
            } else {
                myFeatures.add(feat);
            }
            ++n2;
        }
        if (myFeatures.isEmpty()) {
            return null;
        }
        return myFeatures.toArray(new String[myFeatures.size()]);
    }

    static String getRidOfSpecialFeatures(String lexeme) {
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            return null;
        }
        String newinfos = Dic.getRidOfSpecialFeatures(features);
        return String.valueOf(entry) + "," + lemma + "," + category + newinfos;
    }

    private static String simpleLookFor(String feature0, String info) {
        ParameterCheck.mandatory("feature0", feature0);
        ParameterCheck.mandatory("info", info);
        int i = info.indexOf("+" + feature0, 0);
        if (i == -1) {
            return null;
        }
        int j = 1;
        ++i;
        while (i + j < info.length() && info.charAt(i + j) != '+') {
            ++j;
        }
        return info.substring(i, i + j);
    }

    static String lookForAtBeg(String feature0, String info) {
        ParameterCheck.mandatory("feature0", feature0);
        ParameterCheck.mandatory("info", info);
        int i = info.indexOf(feature0, 0);
        if (i != 0) {
            return null;
        }
        int j = 1;
        while (j < info.length() && info.charAt(j) != '+') {
            ++j;
        }
        return info.substring(0, j);
    }

    private static String complexLookFor(String feature0, String info) {
        ParameterCheck.mandatory("info", info);
        int i = 0;
        while (i < info.length()) {
            String simpleLex;
            int j;
            if (info.charAt(i) == '<') {
                int recLevel = 0;
                j = 0;
                while (i + j < info.length()) {
                    if (info.charAt(i + j) == '<') {
                        ++recLevel;
                    } else if (info.charAt(i + j) == '>' && --recLevel <= 0) break;
                    ++j;
                }
                simpleLex = info.substring(i + 1, i + 1 + j - 1);
            } else if (info.charAt(i) == '{') {
                j = 0;
                while (i + j < info.length() && info.charAt(i + j) != '}') {
                    ++j;
                }
                simpleLex = info.substring(i + 1, i + 1 + j - 1);
            } else {
                return null;
            }
            String simpleEntry = null;
            String simpleLemma = null;
            String simpleInfo = null;
            if (simpleLex.startsWith("INFO")) {
                String looked = Dic.simpleLookFor(feature0, simpleLex);
                if (looked != null) {
                    return looked;
                }
            } else {
                String looked;
                RefObject<Object> tempRef_simpleentry = new RefObject<Object>(simpleEntry);
                RefObject<Object> tempRef_simplelemma = new RefObject<Object>(simpleLemma);
                RefObject<Object> tempRef_simpleinfo = new RefObject<Object>(simpleInfo);
                boolean tempVar = Dic.parseDELAF(simpleLex, tempRef_simpleentry, tempRef_simplelemma, tempRef_simpleinfo);
                simpleEntry = (String)tempRef_simpleentry.argvalue;
                simpleLemma = (String)tempRef_simplelemma.argvalue;
                simpleInfo = (String)tempRef_simpleinfo.argvalue;
                if (tempVar && (looked = Dic.simpleLookFor(feature0, simpleInfo)) != null) {
                    return looked;
                }
            }
            i += j + 1;
        }
        return null;
    }

    public static String lookFor(String feature0, String info) {
        if (info == null || info.length() == 0) {
            return null;
        }
        if (info.charAt(0) == '<' || info.charAt(0) == '{') {
            return Dic.complexLookFor(feature0, info);
        }
        return Dic.simpleLookFor(feature0, info);
    }

    static String lookFor(String feature0, String[] infos) {
        ParameterCheck.mandatory("feature0", feature0);
        if (infos == null || infos.length == 0) {
            return null;
        }
        String[] stringArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String info = stringArray[n2];
            if (info.length() >= feature0.length() && ((index = info.indexOf(61)) != -1 ? feature0.equals(info.substring(0, index)) : feature0.equals(info))) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    private static String[] simpleLookForAll(String feature0, String info) {
        ParameterCheck.mandatory("feature0", feature0);
        ParameterCheck.mandatory("info", info);
        int i = info.indexOf("+" + feature0, 0);
        if (i == -1) {
            return null;
        }
        ArrayList<String> ares = new ArrayList<String>();
        while (i != -1) {
            int j = 1;
            ++i;
            while (i + j < info.length() && info.charAt(i + j) != '+') {
                ++j;
            }
            ares.add(info.substring(i, i + j));
            i = info.indexOf("+" + feature0, i + j);
        }
        return ares.toArray(new String[ares.size()]);
    }

    private static String[] complexLookForAll(String feature0, String info) {
        ParameterCheck.mandatory("info", info);
        ArrayList<String> ares = new ArrayList<String>();
        int i = 0;
        while (i < info.length()) {
            String simplelex;
            int j;
            if (info.charAt(i) == '<') {
                j = 0;
                while (i + j < info.length() && info.charAt(i + j) != '>') {
                    ++j;
                }
                simplelex = info.substring(i + 1, i + 1 + j - 2);
            } else if (info.charAt(i) == '{') {
                j = 0;
                while (i + j < info.length() && info.charAt(i + j) != '}') {
                    ++j;
                }
                simplelex = info.substring(i + 1, i + 1 + j - 2);
            } else {
                return null;
            }
            if (simplelex.startsWith("INFO")) {
                String looked = Dic.simpleLookFor(feature0, simplelex);
                if (looked != null) {
                    ares.add(looked);
                }
            } else if (simplelex.indexOf(61) == -1) {
                String looked;
                String simpleentry = null;
                String simplelemma = null;
                String simpleinfo = null;
                RefObject<Object> tempRef_simpleentry = new RefObject<Object>(simpleentry);
                RefObject<Object> tempRef_simplelemma = new RefObject<Object>(simplelemma);
                RefObject<Object> tempRef_simpleinfo = new RefObject<Object>(simpleinfo);
                boolean tempVar = Dic.parseDELAF(simplelex, tempRef_simpleentry, tempRef_simplelemma, tempRef_simpleinfo);
                simpleentry = (String)tempRef_simpleentry.argvalue;
                simplelemma = (String)tempRef_simplelemma.argvalue;
                simpleinfo = (String)tempRef_simpleinfo.argvalue;
                if (tempVar && (looked = Dic.simpleLookFor(feature0, simpleinfo)) != null) {
                    ares.add(looked);
                }
            }
            i += j + 1;
        }
        if (ares.isEmpty()) {
            return null;
        }
        return ares.toArray(new String[ares.size()]);
    }

    static String[] lookForAll(String feature0, String info) {
        if (info == null || info.length() == 0) {
            return null;
        }
        if (info.charAt(0) == '<' || info.charAt(0) == '{') {
            return Dic.complexLookForAll(feature0, info);
        }
        return Dic.simpleLookForAll(feature0, info);
    }

    static String[] lookForAll(String feature0, String[] features) {
        ParameterCheck.mandatory("feature0", feature0);
        if (features == null || features.length == 0) {
            return null;
        }
        ArrayList<String> resfeatures = new ArrayList<String>();
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            if (feat.length() > feature0.length() && feature0.equals(feat.substring(0, feature0.length()))) {
                resfeatures.add(feat);
            }
            ++n2;
        }
        if (resfeatures.isEmpty()) {
            return null;
        }
        return resfeatures.toArray(new String[resfeatures.size()]);
    }

    public static String removeFeature(String feature0, String info) {
        ParameterCheck.mandatory("feature0", feature0);
        if (info == null || info.length() == 0) {
            return null;
        }
        String[] infos = Dic.getAllFeaturesWithoutPlus(info);
        if (infos == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].length() < feature0.length() || !feature0.equals(infos[i].substring(0, feature0.length()))) {
                if (info.charAt(0) == '+' || res.length() > 0) {
                    res.append("+");
                }
                res.append(infos[i]);
            }
            ++i;
        }
        return res.toString();
    }

    static String unCompressSimpleLemma(String entry, String clemma) {
        if (clemma == null || clemma.equals("")) {
            return entry;
        }
        ParameterCheck.mandatory("entry", entry);
        if (clemma.charAt(0) == '0') {
            return Dic.unCompressSimpleLemma(entry.substring(clemma.charAt(1) - 48), clemma.substring(2));
        }
        int val = 0;
        int i = 0;
        while (i < clemma.length() && Character.isDigit(clemma.charAt(i))) {
            val = val * 10 + (clemma.charAt(i) - 48);
            ++i;
        }
        if (entry.length() < val) {
            return entry;
        }
        return String.valueOf(entry.substring(0, entry.length() - val)) + clemma.substring(i);
    }

    static String unCompressCompoundLemma(String entry, String clemma) {
        ParameterCheck.mandatory("clemma", clemma);
        if (clemma.equals("")) {
            return entry;
        }
        StringBuilder res = new StringBuilder();
        String[] entries = Dic.splitInSimpleWords(entry);
        String[] clemmas = Dic.splitInSimpleWords(clemma);
        int i = 0;
        while (i < entries.length && i < clemmas.length) {
            if (Character.isLetter(entries[i].charAt(0))) {
                int ichar = 0;
                if (Character.isDigit(clemmas[i].charAt(0))) {
                    ichar = 0;
                    while (ichar < clemmas[i].length() && Character.isDigit(clemmas[i].charAt(ichar))) {
                        ++ichar;
                    }
                    int val = Integer.parseInt(clemmas[i].substring(0, ichar));
                    res.append(entries[i].substring(0, entries[i].length() - val));
                } else {
                    res.append(entries[i]);
                }
                res.append(clemmas[i].substring(ichar));
            } else {
                res.append(Dic.protectComma(clemmas[i]));
            }
            ++i;
        }
        if (entries.length < clemmas.length) {
            while (i < clemmas.length) {
                res.append(Dic.protectComma(clemmas[i]));
                ++i;
            }
        }
        return res.toString();
    }

    public static int nbOfCommas(String line) {
        ParameterCheck.mandatory("line", line);
        int nbofcommas = 0;
        boolean ininfo = false;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '\\') {
                ++i;
            } else if (ininfo && line.charAt(i) == '<') {
                ++i;
                while (i < line.length() && line.charAt(i) != '>') {
                    ++i;
                }
            } else if (ininfo && line.charAt(i) == '\"') {
                ++i;
                while (i < line.length() && line.charAt(i) != '\"') {
                    ++i;
                }
            } else {
                if (line.charAt(i) == '#') {
                    return nbofcommas;
                }
                if (line.charAt(i) == ',') {
                    ininfo = true;
                    ++nbofcommas;
                }
            }
            ++i;
        }
        return nbofcommas;
    }

    private static String[] splitInSimpleWords(String text) {
        ParameterCheck.mandatory("text", text);
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < text.length()) {
            int j;
            if (Character.isLetter(text.charAt(i)) || Character.isDigit(text.charAt(i))) {
                j = 1;
                while (i + j < text.length() && (Character.isLetter(text.charAt(i + j)) || Character.isDigit(text.charAt(i + j)))) {
                    ++j;
                }
            } else {
                j = 1;
                while (i + j < text.length() && !Character.isLetter(text.charAt(i + j)) && !Character.isDigit(text.charAt(i + j))) {
                    ++j;
                }
            }
            res.add(text.substring(i, i + j));
            i += j;
        }
        return res.toArray(new String[res.size()]);
    }

    static String compressSimpleLemma(String entry, String lemma) {
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        if (entry.equals(lemma)) {
            return "";
        }
        int ichar = 0;
        while (ichar < entry.length() && ichar < lemma.length() && entry.charAt(ichar) == lemma.charAt(ichar)) {
            ++ichar;
        }
        if (ichar == entry.length()) {
            return lemma.substring(ichar);
        }
        if (ichar == lemma.length()) {
            return String.valueOf(entry.length() - ichar);
        }
        if (ichar == 0) {
            if (lemma.length() >= 2 && entry.length() >= 2) {
                int jchar = 1;
                while (jchar < 10 && jchar < entry.length() - 1 && (entry.charAt(jchar) != lemma.charAt(0) || entry.charAt(jchar + 1) != lemma.charAt(1))) {
                    ++jchar;
                }
                if (jchar < 10 && jchar < entry.length()) {
                    return "0" + new Integer(jchar).toString() + Dic.compressSimpleLemma(entry.substring(jchar), lemma);
                }
            }
            return String.valueOf(String.valueOf(entry.length() - ichar)) + lemma.substring(ichar);
        }
        return String.valueOf(String.valueOf(entry.length() - ichar)) + lemma.substring(ichar);
    }

    static String compressCompoundLemma(String entry, String lemma) {
        int ii;
        ParameterCheck.mandatory("entry", entry);
        ParameterCheck.mandatory("lemma", lemma);
        if (entry.equals(lemma)) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        String[] entries = Dic.splitInSimpleWords(entry);
        String[] lemmas = Dic.splitInSimpleWords(lemma);
        int i = 0;
        while (i < entries.length && i < lemmas.length) {
            if (Character.isLetter(entries[i].charAt(0)) && Character.isLetter(lemmas[i].charAt(0))) {
                if (entries[i].equals(lemmas[i])) {
                    res.append("0");
                } else {
                    int ichar = 0;
                    while (ichar < entries[i].length() && ichar < lemmas[i].length()) {
                        if (entries[i].charAt(ichar) != lemmas[i].charAt(ichar)) break;
                        ++ichar;
                    }
                    if (ichar == entries[i].length()) {
                        res.append(lemmas[i].substring(ichar));
                    } else if (ichar == lemmas[i].length()) {
                        res.append(String.valueOf(entries[i].length() - ichar));
                    } else {
                        res.append(String.valueOf(String.valueOf(entries[i].length() - ichar)) + lemmas[i].substring(ichar));
                    }
                }
            } else if (i < lemmas.length) {
                ii = 0;
                while (ii < lemmas[i].length()) {
                    if (lemmas[i].charAt(ii) == ',') {
                        res.append('\\');
                    }
                    res.append(lemmas[i].charAt(ii));
                    ++ii;
                }
            }
            ++i;
        }
        if (entries.length <= lemmas.length && lemmas.length > entries.length) {
            while (i < lemmas.length) {
                ii = 0;
                while (ii < lemmas[i].length()) {
                    if (lemmas[i].charAt(ii) == ',') {
                        res.append('\\');
                    }
                    res.append(lemmas[i].charAt(ii));
                    ++ii;
                }
                ++i;
            }
        }
        return res.toString();
    }

    public static String[] convertFromDls(String line, RefObject<String> errMessage) {
        ParameterCheck.mandatory("line", line);
        ParameterCheck.mandatory("errMessage", errMessage);
        errMessage.argvalue = null;
        String rline = null;
        String[] res = null;
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i >= line.length()) {
            errMessage.argvalue = "cannot find comma in DLS line: " + line;
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        rline = String.valueOf(rline) + line.substring(0, i);
        ++i;
        int j = 0;
        while (i + j < line.length() && line.charAt(i + j) != '.' && line.charAt(i + j) != ':' && line.charAt(i + j) != ' ' && line.charAt(i + j) != '/') {
            if (line.charAt(i + j) == '\\') {
                ++j;
            }
            ++j;
        }
        if (j == 0) {
            errMessage.argvalue = "cannot find category in DLS line: " + line;
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        if (i + j < line.length() && line.charAt(i + j) == ':') {
            errMessage.argvalue = "invalid character ':' in DLS line: " + line;
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        if (i + j < line.length() && line.charAt(i + j) == '.') {
            errMessage.argvalue = "invalid character '.' in DLS line: " + line;
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        if (i + j == line.length()) {
            rline = String.valueOf(rline) + "," + line.substring(i, i + j);
            res = new String[]{rline};
            return res;
        }
        if (line.charAt(i + j) == ' ' || line.charAt(i + j) == '/') {
            rline = String.valueOf(rline) + "," + line.substring(i, i + j) + '#' + line.substring(i + j + 1);
            res = new String[]{rline};
            return res;
        }
        errMessage.argvalue = "unknown error";
        return null;
    }

    public static String[] convertFromDlf(String line, RefObject<String> errMessage) {
        ParameterCheck.mandatory("line", line);
        ParameterCheck.mandatory("errMessage", errMessage);
        errMessage.argvalue = null;
        ArrayList<String> list = null;
        String rline = null;
        String[] res = null;
        int i = 0;
        while (i < line.length() && line.charAt(i) != ',') {
            if (line.charAt(i) == '\\') {
                ++i;
            }
            ++i;
        }
        if (i >= line.length()) {
            errMessage.argvalue = "no comma";
            return null;
        }
        rline = String.valueOf(rline) + line.substring(0, i);
        ++i;
        int j = 0;
        while (i + j < line.length() && line.charAt(i + j) != '.') {
            if (line.charAt(i + j) == '\\') {
                ++j;
            }
            ++j;
        }
        if (i + j == line.length()) {
            errMessage.argvalue = "no dot";
            return null;
        }
        rline = String.valueOf(rline) + "," + line.substring(i, i + j);
        ++j;
        int k = 0;
        while (i + j + k < line.length() && line.charAt(i + j + k) != ':' && line.charAt(i + j + k) != ' ' && line.charAt(i + j + k) != '/') {
            ++k;
        }
        rline = String.valueOf(rline) + "," + line.substring(i + j, i + j + k);
        if (i + j + k == line.length()) {
            res = new String[]{rline};
            return res;
        }
        if (line.charAt(i + j + k) != ':') {
            rline = String.valueOf(rline) + '#' + line.substring(i + j + k + 1);
            res = new String[]{rline};
            return res;
        }
        list = new ArrayList<String>();
        while (i + j + k < line.length() && line.charAt(i + j + k) == ':') {
            String rline0 = rline;
            ++k;
            while (i + j + k < line.length() && line.charAt(i + j + k) != ':' && line.charAt(i + j + k) != ' ' && line.charAt(i + j + k) != '/') {
                rline0 = String.valueOf(rline0) + "+" + String.valueOf(line.charAt(i + j + k));
                ++k;
            }
            list.add(rline0);
        }
        return list.toArray(new String[list.size()]);
    }

    public static void writeLog(String message) {
        block12: {
            OutputStreamWriter sw = null;
            try {
                try {
                    sw = new OutputStreamWriter(new FileOutputStream(LogFileName, true));
                    sw.write(message);
                    sw.write(10);
                }
                catch (IOException iOException) {
                    if (sw == null) break block12;
                    try {
                        sw.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (sw != null) {
                    try {
                        sw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void writeLogInit(String message) {
        block12: {
            OutputStreamWriter sw = null;
            try {
                try {
                    sw = new OutputStreamWriter(new FileOutputStream(LogFileName, false));
                    sw.write(message);
                    sw.write(10);
                    sw.write("");
                    sw.write(10);
                }
                catch (IOException iOException) {
                    if (sw == null) break block12;
                    try {
                        sw.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (sw != null) {
                    try {
                        sw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

