/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.FSDic;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexps;
import net.nooj4nlp.engine.helper.ParameterCheck;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class Dictionary {
    private static int USE_PREFIX_LENGTH = "#use ".length();
    private static int FLX_PREFIX_LENGTH = "FLX=".length();
    private static int DRV_PREFIX_LENGTH = "DRV=".length();
    public static StringBuilder errMessage = null;

    public static String getLanguage(String filePath) throws IOException {
        ParameterCheck.mandatoryString("filePath", filePath);
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF8"));
            line = reader.readLine();
            line = reader.readLine();
            line = reader.readLine();
            line = reader.readLine();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (line == null || line.length() < 21) {
            return null;
        }
        return line.substring(21);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean inflect(String fullname, String resName, boolean checkagreement, Language lan, Preferences preferences) throws IOException {
        if (Launcher.preferences.ldic.get(lan.isoName) == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find any lex resource for " + lan.isoName, "NooJ", 1);
        }
        lanRef = new RefObject<Language>(lan);
        engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        lan = (Language)lanRef.argvalue;
        errMessage = new StringBuilder();
        nbOfEntries = DictionaryDialogController.count(fullname);
        dname = FilenameUtils.getFullPath(fullname);
        grammar = null;
        sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
            return false;
        }
        sw = null;
        try {
            sw = new OutputStreamWriter(new FileOutputStream(resName));
            Dic.initLoad(sw, lan.isoName);
            sw.write("# This dictionary was automatically built from " + FilenameUtils.getName(fullname) + "\n");
            sw.write("#\n");
        }
        catch (IOException e) {
            if (sr != null) {
                sr.close();
            }
            if (sw != null) {
                sw.close();
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return false;
        }
        itu = 0;
        progressPercentage = 0;
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                sr.close();
                sw.close();
                return false;
            }
            Launcher.progressMessage = "1/2 Compiling Paradigms...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        line0 = sr.readLine();
        while (line0 != null) {
            if (!(line0 = line0.trim()).equals("") && line0.startsWith("#use ")) {
                fname = line0.substring(Dictionary.USE_PREFIX_LENGTH);
                fname = fname.trim();
                flxname = String.valueOf(dname) + fname;
                ext = "." + FilenameUtils.getExtension(flxname);
                file = new File(flxname);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "cannot find file " + flxname, "NooJ: file does not exist", 1);
                } else {
                    sw.write(String.valueOf(line0) + "\n");
                    if (ext.equals(".nof") || ext.equals(".grm") || ext.equals(".NOF") || ext.equals(".GRM")) {
                        istextual = Grammar.isItTextual(flxname);
                        if (istextual) {
                            errmessage = null;
                            errmessage_Ref = new RefObject<Object>(errmessage);
                            cgrammar = Grammar.loadTextual(flxname, GramType.FLX, errmessage_Ref);
                            errmessage = (String)errmessage_Ref.argvalue;
                            if (errmessage != null) {
                                if (sr != null) {
                                    sr.close();
                                }
                                if (sw != null) {
                                    sw.close();
                                }
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Problem in grammar " + flxname + ":\n" + errmessage, "NooJ: Cannot handle grammar", 1);
                                return false;
                            }
                        } else {
                            cgrammar = Grammar.loadONooJGrammar(flxname);
                        }
                        if (cgrammar == null) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load grammar " + flxname, "NooJ", 1);
                            sr.close();
                            sw.close();
                        } else if (cgrammar.gramType != GramType.FLX) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(flxname) + " is not an inflectional/derivational description", "NooJ: invalid grammar type", 1);
                        } else {
                            cgrammar.compileAll(null);
                            if (grammar == null) {
                                grammar = cgrammar;
                            } else {
                                grammar.addGrams(cgrammar);
                            }
                        }
                    } else {
                        if (ext.equals(".def") || ext.equals(".DEF")) {
                            JOptionPane.showMessageDialog(null, "In NooJ V3, the only property defininition file is stored in Lexical Analysis\\_properties.def", "NooJ V3", 1);
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "In NooJ V3, there is no more support for the obsolete command \"#use properties.def\"", "NooJ V3", 1);
                            sr.close();
                            sw.close();
                            file1 = new File(resName);
                            file1.delete();
                            return false;
                        }
                        if (ext.equals(".flx") || ext.equals(".FLX")) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "In NooJ V3, the only valid inflection/derivation files are stored in .nof files", "NooJ V3", 1);
                            sr.close();
                            sw.close();
                            return false;
                        }
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File " + flxname + " has an incorrect extension", "NooJ: cannot handle extension " + ext, 1);
                        sr.close();
                        sw.close();
                        return false;
                    }
                }
            }
            line0 = sr.readLine();
        }
        if (grammar == null || grammar.grams == null || grammar.grams.size() == 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has no associated inflectional/derivational description", "NooJ", 1);
            sr.close();
            sw.close();
            return false;
        }
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                sr.close();
                sw.close();
                return false;
            }
            Launcher.progressMessage = "2/2 Processing Inflection...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        nbofinflectedforms = 0;
        sr.close();
        sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
        sw.write("#\n");
        nboferrors = 0;
        line = sr.readLine();
        while (line != null) {
            block71: {
                block78: {
                    block75: {
                        block76: {
                            block77: {
                                block72: {
                                    block73: {
                                        block74: {
                                            line = line.trim();
                                            entry = null;
                                            category = null;
                                            lemma = null;
                                            info = null;
                                            if (line.equals("") || line.charAt(0) == '#') break block71;
                                            ++itu % 1000;
                                            if (Launcher.multithread) {
                                                if (Launcher.backgroundWorker.isCancellationPending()) {
                                                    sr.close();
                                                    sw.close();
                                                    return false;
                                                }
                                                nprogress = (int)((float)itu * 100.0f / (float)nbOfEntries);
                                                if (nprogress != progressPercentage) {
                                                    progressPercentage = nprogress;
                                                    if (Launcher.backgroundWorker.isBusy()) {
                                                        Launcher.backgroundWorker.reportProgress(nprogress);
                                                    }
                                                }
                                            }
                                            if ((nbofcommas = Dic.nbOfCommas(line)) != 1) break block72;
                                            entryRef = new RefObject<Object>(entry);
                                            categoryRef = new RefObject<Object>(category);
                                            infoRef = new RefObject<Object>(info);
                                            tmp = Dic.parseDELAS(line, entryRef, categoryRef, infoRef);
                                            entry = (String)entryRef.argvalue;
                                            category = (String)categoryRef.argvalue;
                                            info = (String)infoRef.argvalue;
                                            if (tmp) break block73;
                                            tmp1 = Dic.parseContracted(line, entryRef, infoRef);
                                            entry = (String)entryRef.argvalue;
                                            info = (String)infoRef.argvalue;
                                            if (tmp1) break block74;
                                            errMessage.append("\n* Invalid dictionary line: " + line);
                                            if (++nboferrors > 100) {
                                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compress dictionary", "NooJ: cannot compile", 1);
                                                sr.close();
                                                sw.close();
                                                return false;
                                            }
                                            break block71;
                                        }
                                        category = null;
                                        lemma = entry;
                                        break block75;
                                    }
                                    lemma = entry;
                                    break block75;
                                }
                                if (nbofcommas != 2) break block76;
                                entryRef = new RefObject<Object>(entry);
                                lemmaRef = new RefObject<Object>(lemma);
                                categoryRef = new RefObject<Object>(category);
                                infoRef = new RefObject<Object>(info);
                                tmp = Dic.parseDELAF(line, entryRef, lemmaRef, categoryRef, infoRef);
                                entry = (String)entryRef.argvalue;
                                lemma = (String)lemmaRef.argvalue;
                                category = (String)categoryRef.argvalue;
                                info = (String)infoRef.argvalue;
                                if (tmp) break block77;
                                errMessage.append("\n* Invalid dictionary line: " + line);
                                if (++nboferrors > 100) {
                                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compress dictionary", "NooJ: cannot compile", 1);
                                    sr.close();
                                    sw.close();
                                    return false;
                                }
                                break block71;
                            }
                            if (lemma != null && !lemma.equals("")) break block75;
                            errMessage.append("\n* No lemma in line: " + line);
                            if (++nboferrors > 100) {
                                sr.close();
                                sw.close();
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compress dictionary", "NooJ: cannot compile", 1);
                                return false;
                            }
                            break block71;
                        }
                        errMessage.append("* Cannot parse line: " + line + " (nb of commas " + nbofcommas + " is invalid)\n");
                        Dic.writeLog("Cannot parse line: " + line + " (nb of commas " + nbofcommas + " is invalid)");
                        if (++nboferrors > 100) {
                            sr.close();
                            sw.close();
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compress dictionary", "NooJ: cannot compile", 1);
                            return false;
                        }
                        break block71;
                    }
                    myfeature = Dic.lookFor("FLX", info);
                    if (myfeature != null) break block78;
                    res = String.valueOf(entry) + "," + lemma + "," + (category == null ? "" : category) + (info == null ? "" : info);
                    sw.write(String.valueOf(res) + "\n");
                    ++nbofinflectedforms;
                    ** GOTO lbl251
                }
                expname = myfeature.substring(Dictionary.FLX_PREFIX_LENGTH);
                if (grammar == null || grammar.grams == null || !grammar.grams.containsKey(expname)) {
                    errMessage.append("\n* Cannot find inflectional rule \"" + expname + "\" for lexical entry: " + line);
                } else {
                    grm = grammar.grams.get(expname);
                    if (grm == null) {
                        errMessage.append("\n* Cannot load inflectional rule \"" + expname + "\" for lexical entry: " + line);
                    } else {
                        forms = null;
                        outputs = null;
                        formsRef = new RefObject<Object>(forms);
                        outputsRef = new RefObject<Object>(outputs);
                        grm.inflect(lan, entry, formsRef, outputsRef, grammar.grams);
                        forms = (String[])formsRef.argvalue;
                        outputs = (String[])outputsRef.argvalue;
                        if (forms == null || forms.length == 0) {
                            errMessage.append("\n* Cannot apply inflectional rule \"" + expname + "\"");
                        } else {
                            ires = 0;
                            while (ires < forms.length) {
                                if (!checkagreement || !Dictionary.agreementProblemsIn(category, outputs[ires], engine.properties)) {
                                    infoflex = Dictionary.removeDuplicates(outputs[ires]);
                                    res = String.valueOf(forms[ires]) + "," + lemma + "," + category + Dic.removeFeature("NW", info) + infoflex;
                                    sw.write(String.valueOf(res) + "\n");
                                    ++nbofinflectedforms;
                                }
                                ++ires;
                            }
lbl251:
                            // 2 sources

                            myfeatures = Dic.lookForAll("DRV", info);
                            if (myfeatures != null) {
                                var28_42 = myfeatures;
                                var27_41 = myfeatures.length;
                                var26_35 = 0;
                                while (var26_35 < var27_41) {
                                    mydrv = var28_42[var26_35];
                                    expname = null;
                                    flxname = null;
                                    expname0 = mydrv.substring(Dictionary.DRV_PREFIX_LENGTH);
                                    icomb = expname0.indexOf(58);
                                    if (icomb != -1) {
                                        expname = expname0.substring(0, icomb);
                                        flxname = expname0.substring(icomb + 1);
                                    } else {
                                        expname = expname0;
                                        flxname = myfeature != null ? myfeature.substring(Dictionary.FLX_PREFIX_LENGTH) : null;
                                    }
                                    if (grammar == null || grammar.grams == null || !grammar.grams.containsKey(expname)) {
                                        errMessage.append("\n* Cannot find derivational rule \"" + expname + "\" for lexical information: " + info);
                                    } else {
                                        grm = grammar.grams.get(expname);
                                        if (grm == null) {
                                            errMessage.append("\n* Cannot load derivational rule \"" + expname + "\" for lexical information: " + info);
                                        } else {
                                            forms = null;
                                            outputs = null;
                                            formsRef = new RefObject<Object>(forms);
                                            outputsRef = new RefObject<Object>(outputs);
                                            grm.inflect(lan, entry, formsRef, outputsRef, grammar.grams);
                                            forms = (String[])formsRef.argvalue;
                                            outputs = (String[])outputsRef.argvalue;
                                            if (forms == null || forms.length == 0) {
                                                errMessage.append("\n* Cannot use derivational rule \"" + expname + "\"");
                                            } else {
                                                ires = 0;
                                                while (ires < forms.length) {
                                                    initialinfo = Dic.removeFeature("NW", info);
                                                    newinfo = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? outputs[ires].substring(1) : outputs[ires];
                                                    if (flxname == null) {
                                                        res = String.valueOf(forms[ires]) + "," + lemma + "," + newinfo + initialinfo;
                                                        sw.write(String.valueOf(res) + "\n");
                                                        ++nbofinflectedforms;
                                                    } else if (grammar == null || grammar.grams == null || !grammar.grams.containsKey(flxname)) {
                                                        errMessage.append("\n* Cannot find inflectional rule \"" + expname + "\" for lexical entry: " + line);
                                                    } else {
                                                        grm2 = grammar.grams.get(flxname);
                                                        if (grm2 == null) {
                                                            errMessage.append("\n* Cannot compile inflectional rule \"" + flxname + "\"");
                                                        } else {
                                                            dforms = null;
                                                            doutputs = null;
                                                            dformsRef = new RefObject<Object>(dforms);
                                                            doutputsRef = new RefObject<Object>(doutputs);
                                                            grm2.inflect(lan, forms[ires], dformsRef, doutputsRef, grammar.grams);
                                                            dforms = (String[])dformsRef.argvalue;
                                                            doutputs = (String[])doutputsRef.argvalue;
                                                            if (dforms == null || dforms.length == 0) {
                                                                errMessage.append("\n* Cannot use inflectional rule \"" + flxname + "\"");
                                                            } else {
                                                                i2res = 0;
                                                                while (i2res < dforms.length) {
                                                                    lastinfo = doutputs[i2res];
                                                                    res = String.valueOf(dforms[i2res]) + "," + lemma + "," + newinfo + initialinfo + lastinfo;
                                                                    sw.write(String.valueOf(res) + "\n");
                                                                    ++nbofinflectedforms;
                                                                    ++i2res;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    ++ires;
                                                }
                                            }
                                        }
                                    }
                                    ++var26_35;
                                }
                            }
                        }
                    }
                }
            }
            line = sr.readLine();
        }
        sr.close();
        sw.close();
        if (nbofinflectedforms > 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary " + resName + " has been successfully compiled:\n" + Integer.toString(nbofinflectedforms) + " inflected forms.", "NooJ: Success", 1);
        }
        return true;
    }

    private static String removeDuplicates(String inflectionalcodes) {
        String[] features = Dic.getAllFeaturesWithoutPlus(inflectionalcodes);
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < features.length) {
            String ifeat = features[i];
            boolean dup = false;
            int j = i + 1;
            while (j < features.length) {
                String jfeat = features[j];
                if (ifeat == jfeat) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (!dup) {
                res.add(ifeat);
            }
            ++i;
        }
        StringBuilder sbres = new StringBuilder();
        for (String feat : res) {
            sbres.append("+" + feat);
        }
        return sbres.toString();
    }

    private static boolean agreementProblemsIn(String category, String inflectionalcodes, HashMap<String, String> properties) {
        String[] features = Dic.getAllFeaturesWithoutPlus(inflectionalcodes);
        int i = 0;
        while (i < features.length) {
            String feat = features[i];
            String ipropname = null;
            String ipropval = null;
            RefObject<Object> ipropnameRef = new RefObject<Object>(ipropname);
            RefObject<Object> ipropvalRef = new RefObject<Object>(ipropval);
            Dic.getProperty(feat, category, properties, ipropnameRef, ipropvalRef);
            ipropname = (String)ipropnameRef.argvalue;
            ipropval = (String)ipropvalRef.argvalue;
            int j = i + 1;
            while (j < features.length) {
                String jfeat = features[j];
                String jpropname = null;
                String jpropval = null;
                RefObject<Object> jpropnameRef = new RefObject<Object>(jpropname);
                RefObject<Object> jpropvalRef = new RefObject<Object>(jpropval);
                Dic.getProperty(jfeat, category, properties, jpropnameRef, jpropvalRef);
                jpropname = (String)jpropnameRef.argvalue;
                jpropval = (String)jpropvalRef.argvalue;
                if (jpropname == ipropname && ipropval != jpropval) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean compile(String fullname, String resName, boolean checkagreement, Language lan) throws IOException {
        if (Launcher.preferences.ldic.get(lan.isoName) == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find any lex resource for " + lan.isoName, "NooJ", 1);
        }
        RefObject<Language> lanRef = new RefObject<Language>(lan);
        Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
        lan = (Language)lanRef.argvalue;
        errMessage = new StringBuilder();
        int nbOfEntries = DictionaryDialogController.count(fullname);
        String dname = FilenameUtils.getFullPath(fullname);
        int nboferrors = 0;
        Dic.writeLog("Starting compilation for dictionary: " + fullname);
        Date today = new Date();
        Dic.writeLog(DateFormat.getDateTimeInstance(0, 0, lan.locale).format(today));
        FSDic dics = new FSDic(lan.isoName);
        FSDic dicsLemma = new FSDic(lan.isoName);
        FSDic dicc = new FSDic(lan.isoName);
        FSDic diccLemma = new FSDic(lan.isoName);
        Dic.writeLog("1/4 Compiling inflectional & derivational paradigms");
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                return false;
            }
            Launcher.getStatusBar().getProgressLabel().setText("1/4 Compiling Paradigms...");
            Launcher.progressMessage = "1/4 Compiling Paradigms...";
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        Grammar grammar = null;
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
            return false;
        }
        String line0 = sr.readLine();
        while (line0 != null) {
            if (!(line0 = line0.trim()).equals("") && line0.startsWith("#use ")) {
                Object fname = line0.substring(USE_PREFIX_LENGTH);
                fname = ((String)fname).trim();
                String flxname = String.valueOf(dname) + (String)fname;
                String ext = "." + FilenameUtils.getExtension(flxname);
                File file = new File(flxname);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file " + flxname, "NooJ: file does not exist", 1);
                    sr.close();
                    return false;
                }
                Grammar cgrammar = null;
                if (ext.equals(".def") || ext.equals(".DEF")) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "In NooJ V3, the only property defininition file is stored in Lexical Analysis\\_properties.def", "NooJ V3", 1);
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "In NooJ V3, there is no more support for the obsolete command \"#use properties.def\"", "NooJ V3", 1);
                    sr.close();
                    return false;
                }
                if (ext.equals(".nof") || ext.equals(".grm") || ext.equals(".NOF") || ext.equals(".GRM")) {
                    boolean istextual = Grammar.isItTextual(flxname);
                    if (istextual) {
                        String errmessage = null;
                        RefObject<Object> errmessageRef = new RefObject<Object>(errmessage);
                        cgrammar = Grammar.loadTextual(flxname, GramType.FLX, errmessageRef);
                        errmessage = (String)errmessageRef.argvalue;
                        if (errmessage != null) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Problem in grammar " + flxname + ":\n" + errmessage, "NooJ: Cannot handle grammar", 1);
                            sr.close();
                            return false;
                        }
                    } else {
                        cgrammar = Grammar.loadONooJGrammar(flxname);
                    }
                    if (cgrammar == null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load grammar \"" + flxname + "\"", "NooJ: grammar has errors", 1);
                        sr.close();
                        return false;
                    }
                    cgrammar.compileAll(null);
                    if (grammar == null) {
                        grammar = cgrammar;
                    } else {
                        String em = grammar.addGrams(cgrammar);
                        if (em != null) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), em, "Problem with paradigms", 1);
                            sr.close();
                            return false;
                        }
                    }
                } else if (ext.equals(".flx") || ext.equals(".FLX")) {
                    String errmessage = null;
                    String ilanguagename = null;
                    String olanguagename = null;
                    RefObject<Object> errmessageRef = new RefObject<Object>(errmessage);
                    RefObject<Object> ilanguagenameRef = new RefObject<Object>(ilanguagename);
                    RefObject<Object> olanguagenameRef = new RefObject<Object>(olanguagename);
                    Regexps rs = Regexps.load(flxname, errmessageRef, ilanguagenameRef, olanguagenameRef);
                    errmessage = (String)errmessageRef.argvalue;
                    ilanguagename = (String)ilanguagenameRef.argvalue;
                    olanguagename = (String)olanguagenameRef.argvalue;
                    if (rs == null) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Grammar file \"" + flxname + "\" contains invalid statements:\n" + errmessage, "NooJ: cannot handle file.", 1);
                        sr.close();
                        return false;
                    }
                    if (rs.grammar.grams.size() == 0) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File \"" + flxname + "\" is empty", "NooJ: cannot handle file.", 1);
                    } else {
                        if (!ilanguagename.equals(lan.isoName)) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Language in \"" + flxname + "\" does not match dictionary's", "WARNING", 1);
                        }
                        for (String expname : rs.grammar.grams.keySet()) {
                            Gram grm = rs.grammar.grams.get(expname);
                            if (grm == null) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error in rule " + expname, "NooJ: rule has not compiled successfully", 1);
                                sr.close();
                                return false;
                            }
                            if (grm.vocabIn != null) continue;
                            grm.prepareForParsing();
                        }
                        cgrammar = rs.grammar;
                        if (grammar == null) {
                            grammar = cgrammar;
                        } else {
                            String em = grammar.addGrams(cgrammar);
                            if (em != null) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), em, "Problem with paradigms", 1);
                                sr.close();
                                return false;
                            }
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File \"" + flxname + "\" has an incorrect extension", "NooJ: cannot handle extension " + ext, 1);
                    sr.close();
                    return false;
                }
            }
            line0 = sr.readLine();
        }
        sr.close();
        if ((grammar == null || grammar.grams == null || grammar.grams.size() == 0) && JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Dictionary has no associated inflectional/derivational description.\nDo you want to continue?", "NooJ", 0) != 0) {
            return false;
        }
        dics.paradigms = new HashMap();
        if (grammar != null && grammar.grams != null && grammar.grams.size() > 0) {
            for (String paradname : grammar.grams.keySet()) {
                if (dics.paradigms.containsKey(paradname)) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Morphological paradigm " + paradname + " is defined more than once.", "NooJ ignores the 2nd version of duplicate paradigms", 1);
                    continue;
                }
                dics.paradigms.put(paradname, grammar.grams.get(paradname));
            }
        }
        Dic.writeLog(" > " + dics.paradigms.size() + " inflectional/derivational paradigms.");
        Dic.writeLog("2/4 Processing inflection & derivation");
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                return false;
            }
            Launcher.progressMessage = "2/4 Processing inflection & derivation...";
            Launcher.getStatusBar().getProgressLabel().setText("2/4 Processing inflection & derivation...");
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        int nbofinflectedforms = 0;
        sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullname), "UTF8"));
        int progressPercentage = 0;
        int itu = 0;
        HashMap<String, Integer> hDicInfos = new HashMap<String, Integer>();
        ArrayList<String> aDicInfos = new ArrayList<String>();
        aDicInfos.add("NA");
        String line = sr.readLine();
        while (line != null) {
            block87: {
                String[] myfeaturesdrv;
                String myfeatureflx;
                String info;
                String lemma;
                String entry;
                block96: {
                    String[] outputs;
                    String[] forms;
                    String category;
                    block100: {
                        Gram grm;
                        String expname;
                        block99: {
                            block98: {
                                block97: {
                                    block95: {
                                        block92: {
                                            int nbofcommas;
                                            block93: {
                                                block94: {
                                                    RefObject<Object> entryRef;
                                                    block89: {
                                                        block90: {
                                                            block91: {
                                                                block88: {
                                                                    if (line.equals("")) break block87;
                                                                    if (line.charAt(0) != '#') break block88;
                                                                    if (line.length() >= 2 && line.charAt(1) == '#') {
                                                                        dics.Comments = String.valueOf(dics.Comments) + line.substring(2) + "\r\n";
                                                                    }
                                                                    break block87;
                                                                }
                                                                ++itu;
                                                                if (Launcher.multithread) {
                                                                    if (Launcher.backgroundWorker.isCancellationPending()) {
                                                                        sr.close();
                                                                        return false;
                                                                    }
                                                                    int nprogress = (int)((float)itu * 100.0f / (float)nbOfEntries);
                                                                    if (nprogress != progressPercentage) {
                                                                        progressPercentage = nprogress;
                                                                        if (Launcher.backgroundWorker.isBusy()) {
                                                                            Launcher.backgroundWorker.reportProgress(nprogress);
                                                                        }
                                                                    }
                                                                }
                                                                entry = null;
                                                                lemma = null;
                                                                category = null;
                                                                info = null;
                                                                nbofcommas = Dic.nbOfCommas(line);
                                                                if (nbofcommas != 1) break block89;
                                                                entryRef = new RefObject<Object>(entry);
                                                                RefObject<Object> categoryRef = new RefObject<Object>(category);
                                                                RefObject<Object> infoRef = new RefObject<Object>(info);
                                                                boolean tmp = Dic.parseDELAS(line, entryRef, categoryRef, infoRef);
                                                                entry = (String)entryRef.argvalue;
                                                                category = (String)categoryRef.argvalue;
                                                                info = (String)infoRef.argvalue;
                                                                if (tmp) break block90;
                                                                boolean tmp1 = Dic.parseContracted(line, entryRef, infoRef);
                                                                entry = (String)entryRef.argvalue;
                                                                info = (String)infoRef.argvalue;
                                                                if (tmp1) break block91;
                                                                errMessage.append("* Cannot parse line: " + line + "\n");
                                                                if (++nboferrors > 100) {
                                                                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors (100) while trying to compile dictionary", "NooJ: cannot compile", 1);
                                                                    sr.close();
                                                                    return false;
                                                                }
                                                                break block87;
                                                            }
                                                            category = null;
                                                            lemma = entry;
                                                            break block92;
                                                        }
                                                        lemma = entry;
                                                        break block92;
                                                    }
                                                    if (nbofcommas != 2) break block93;
                                                    entryRef = new RefObject<Object>(entry);
                                                    RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
                                                    RefObject<Object> categoryRef = new RefObject<Object>(category);
                                                    RefObject<Object> infoRef = new RefObject<Object>(info);
                                                    boolean tmp = Dic.parseDELAF(line, entryRef, lemmaRef, categoryRef, infoRef);
                                                    entry = (String)entryRef.argvalue;
                                                    lemma = (String)lemmaRef.argvalue;
                                                    category = (String)categoryRef.argvalue;
                                                    info = (String)infoRef.argvalue;
                                                    if (tmp) break block94;
                                                    errMessage.append("* Cannot parse line: " + line + "\n");
                                                    if (++nboferrors > 100) {
                                                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors (100) while trying to compile dictionary", "NooJ: cannot compile", 1);
                                                        sr.close();
                                                        return false;
                                                    }
                                                    break block87;
                                                }
                                                if (lemma != null && !lemma.equals("")) break block92;
                                                lemma = entry;
                                                break block92;
                                            }
                                            errMessage.append("* Cannot parse line: " + line + " (nb of commas " + nbofcommas + " is invalid)\n");
                                            Dic.writeLog("Cannot parse line: " + line + " (nb of commas " + nbofcommas + " is invalid)");
                                            if (++nboferrors > 100) {
                                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors (100) while trying to compile dictionary", "NooJ: cannot compile", 1);
                                                sr.close();
                                                return false;
                                            }
                                            break block87;
                                        }
                                        myfeatureflx = Dic.lookFor("FLX", info);
                                        myfeaturesdrv = Dic.lookForAll("DRV", info);
                                        if (myfeatureflx != null) break block95;
                                        if (dics.Lan.isACompound(entry) || lan.asianTokenizer) {
                                            dicc.addLexLineToDic(entry, lemma, String.valueOf(category == null ? "" : category) + (info == null ? "" : info), "", dics, dics, hDicInfos, aDicInfos, true);
                                        } else {
                                            dics.addLexLineToDic(entry, lemma, String.valueOf(category == null ? "" : category) + (info == null ? "" : info), "", dics, dics, hDicInfos, aDicInfos, false);
                                        }
                                        ++nbofinflectedforms;
                                        if (myfeaturesdrv == null) break block87;
                                    }
                                    if (dics.Lan.isACompound(entry) || lan.asianTokenizer) {
                                        diccLemma.addLexLineToDic(entry, lemma, String.valueOf(category) + Dic.removeFeature("NW", info), "", dics, dics, hDicInfos, aDicInfos, true);
                                    } else {
                                        dicsLemma.addLexLineToDic(entry, lemma, String.valueOf(category) + Dic.removeFeature("NW", info), "", dics, dics, hDicInfos, aDicInfos, false);
                                    }
                                    if (myfeatureflx == null) break block96;
                                    if (myfeatureflx.length() >= 5) break block97;
                                    errMessage.append("* Cannot parse FLX code in: " + line + "\n");
                                    if (++nboferrors > 100) {
                                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compile dictionary", "NooJ: cannot compile", 1);
                                        sr.close();
                                        return false;
                                    }
                                    break block87;
                                }
                                expname = myfeatureflx.substring(FLX_PREFIX_LENGTH);
                                grm = null;
                                if (dics.paradigms.containsKey(expname)) break block98;
                                errMessage.append("* Cannot find inflectional class: " + expname + " in line '" + line + "'\n");
                                if (++nboferrors > 100) {
                                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compile dictionary", "NooJ: cannot compile", 1);
                                    sr.close();
                                    return false;
                                }
                                ++nbofinflectedforms;
                                break block87;
                            }
                            grm = dics.paradigms.get(expname);
                            if (grm != null) break block99;
                            errMessage.append("* inflectional class: " + expname + " did not compile\n");
                            if (++nboferrors > 100) {
                                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compile dictionary", "NooJ: cannot compile", 1);
                                sr.close();
                                return false;
                            }
                            ++nbofinflectedforms;
                            break block87;
                        }
                        forms = null;
                        outputs = null;
                        RefObject<Object> formsRef = new RefObject<Object>(forms);
                        RefObject<Object> outputsRef = new RefObject<Object>(outputs);
                        grm.inflect(lan, entry, formsRef, outputsRef, dics.paradigms);
                        forms = (String[])formsRef.argvalue;
                        outputs = (String[])outputsRef.argvalue;
                        if (forms != null && forms.length > 0) break block100;
                        errMessage.append("* Cannot process inflectional class: " + expname + "\n");
                        if (++nboferrors > 100) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many errors while trying to compile dictionary", "NooJ: cannot compile", 1);
                            sr.close();
                            return false;
                        }
                        ++nbofinflectedforms;
                        break block87;
                    }
                    int ires = 0;
                    while (ires < forms.length) {
                        block102: {
                            block103: {
                                block101: {
                                    if (!dics.Lan.isACompound(forms[ires]) && !dics.Lan.asianTokenizer) break block101;
                                    if (checkagreement && Dictionary.agreementProblemsIn(category, outputs[ires], engine.properties)) break block102;
                                    String infoflex = Dictionary.removeDuplicates(outputs[ires]);
                                    dicc.addLexLineToDic(forms[ires], lemma, String.valueOf(category) + "+" + myfeatureflx, infoflex, dics, dics, hDicInfos, aDicInfos, true);
                                    break block103;
                                }
                                dics.addLexLineToDic(forms[ires], lemma, String.valueOf(category) + "+" + myfeatureflx, outputs[ires], dics, dics, hDicInfos, aDicInfos, false);
                            }
                            ++nbofinflectedforms;
                        }
                        ++ires;
                    }
                }
                if (myfeaturesdrv != null) {
                    String[] stringArray = myfeaturesdrv;
                    int n = myfeaturesdrv.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String mydrv = stringArray[n2];
                        String expname = null;
                        String flxname = null;
                        String expname0 = mydrv.substring(DRV_PREFIX_LENGTH);
                        int icomb = expname0.indexOf(58);
                        if (icomb != -1) {
                            expname = expname0.substring(0, icomb);
                            flxname = expname0.substring(icomb + 1);
                        } else {
                            expname = expname0;
                            flxname = myfeatureflx != null ? myfeatureflx.substring(FLX_PREFIX_LENGTH) : null;
                        }
                        if (grammar == null || grammar.grams == null || !grammar.grams.containsKey(expname)) {
                            errMessage.append("* Cannot find derivational rule \"" + expname + "\" for lexical information:\n" + info);
                        } else {
                            Gram grm = grammar.grams.get(expname);
                            if (grm == null) {
                                errMessage.append("* Cannot load derivational rule \"" + expname + "\" for lexical information:\n" + info);
                            } else {
                                String[] forms = null;
                                String[] outputs = null;
                                RefObject<Object> formsRef = new RefObject<Object>(forms);
                                RefObject<Object> outputsRef = new RefObject<Object>(outputs);
                                grm.inflect(lan, entry, formsRef, outputsRef, grammar.grams);
                                forms = (String[])formsRef.argvalue;
                                outputs = (String[])outputsRef.argvalue;
                                if (forms == null || forms.length == 0) {
                                    errMessage.append("* Cannot use derivational rule \"" + expname + "\"\n");
                                } else {
                                    int ires = 0;
                                    while (ires < forms.length) {
                                        String newcategory = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? outputs[ires].substring(1) : outputs[ires];
                                        if (flxname == null) {
                                            if (dics.Lan.isACompound(forms[ires]) || dics.Lan.asianTokenizer) {
                                                diccLemma.addLexLineToDic(forms[ires], lemma, String.valueOf(newcategory) + "+" + mydrv, "", dics, dics, hDicInfos, aDicInfos, true);
                                            } else {
                                                dics.addLexLineToDic(forms[ires], lemma, String.valueOf(newcategory) + "+" + mydrv, "", dics, dics, hDicInfos, aDicInfos, false);
                                            }
                                            ++nbofinflectedforms;
                                        } else if (grammar == null || grammar.grams == null || !grammar.grams.containsKey(flxname)) {
                                            errMessage.append("* Cannot find inflectional rule \"" + expname + "\" for lexical entry:\n" + line);
                                        } else {
                                            Gram grm2 = grammar.grams.get(flxname);
                                            if (grm2 == null) {
                                                errMessage.append("* Cannot find inflectional rule \"" + expname + "\" for lexical entry:\n" + line);
                                            } else {
                                                String[] dforms = null;
                                                String[] doutputs = null;
                                                RefObject<Object> dformsRef = new RefObject<Object>(dforms);
                                                RefObject<Object> doutputsRef = new RefObject<Object>(doutputs);
                                                grm2.inflect(lan, forms[ires], dformsRef, doutputsRef, grammar.grams);
                                                dforms = (String[])dformsRef.argvalue;
                                                doutputs = (String[])doutputsRef.argvalue;
                                                if (dforms == null || dforms.length == 0) {
                                                    errMessage.append("* Cannot use rule \"" + flxname + "\"");
                                                } else {
                                                    int i2res = 0;
                                                    while (i2res < dforms.length) {
                                                        String lastinfo = doutputs[i2res];
                                                        if (lastinfo.equals("+")) {
                                                            lastinfo = "";
                                                        }
                                                        if (dics.Lan.isACompound(dforms[i2res]) || dics.Lan.asianTokenizer) {
                                                            dicc.addLexLineToDic(dforms[i2res], lemma, String.valueOf(newcategory) + "+" + mydrv, lastinfo, dics, dics, hDicInfos, aDicInfos, true);
                                                        } else {
                                                            dics.addLexLineToDic(dforms[i2res], lemma, String.valueOf(newcategory) + "+" + mydrv, lastinfo, dics, dics, hDicInfos, aDicInfos, false);
                                                        }
                                                        ++nbofinflectedforms;
                                                        ++i2res;
                                                    }
                                                }
                                            }
                                        }
                                        ++ires;
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            line = sr.readLine();
        }
        sr.close();
        Dic.writeLog(" > " + itu + " entries, " + nbofinflectedforms + " forms, (" + dics.states.size() + "/" + dicsLemma.states.size() + ", " + dicc.states.size() + "/" + diccLemma.states.size() + ") states, " + aDicInfos.size() + " different infos.");
        hDicInfos = null;
        aDicInfos.trimToSize();
        dics.infos = aDicInfos.toArray(new String[aDicInfos.size()]);
        aDicInfos = null;
        dics.cleanupInflectionCommands();
        Dic.writeLog("3/4 Minimizing dictionary");
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                return false;
            }
            Launcher.progressMessage = "3/4 Minimize dictionary...";
            Launcher.getStatusBar().getProgressLabel().setText("3/4 Minimize dictionary...");
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        dics.minimize(dics.infos.length);
        dicsLemma.minimize(dics.infos.length);
        dicc.minimize(dics.infos.length);
        diccLemma.minimize(dics.infos.length);
        Dic.writeLog("4/4 Saving dictionary file");
        if (Launcher.multithread) {
            if (Launcher.backgroundWorker.isCancellationPending()) {
                return false;
            }
            Launcher.progressMessage = "4/4 Save dictionary...";
            Launcher.getStatusBar().getProgressLabel().setText("4/4 Save dictionary...");
            Launcher.progressPercentage = 0;
            if (Launcher.backgroundWorker.isBusy()) {
                Launcher.backgroundWorker.reportProgress(0);
            }
        }
        if (dics == null || dicc == null || dicsLemma == null || diccLemma == null) {
            JOptionPane.showMessageDialog(null, "Problem with the compression", "NooJ", 1);
            return false;
        }
        FSDic.computeAllLogs(dics, dicc, dicsLemma, diccLemma);
        dics.buffer = dics.toBinary(dics);
        dics.bufferc = dicc.toBinary(dics);
        dics.bufferl = dicsLemma.toBinary(dics);
        dics.buffercl = diccLemma.toBinary(dics);
        dics.toBinaryAlphabetInfobitstable();
        String dnamelex = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(lan.isoName, "Lexical Analysis"));
        String nodname = FilenameUtils.concat(dnamelex, String.valueOf(FilenameUtils.getBaseName(fullname)) + "." + "jnod");
        dics.save(nodname);
        String txtname = FilenameUtils.concat(dnamelex, String.valueOf(FilenameUtils.getBaseName(fullname)) + ".txt");
        dics.saveComments(txtname, nbofinflectedforms, dics.states.size(), dicc.states.size(), dicsLemma.states.size(), diccLemma.states.size());
        Dic.writeLog(" > Dictionary successfully compiled: " + dics.states.size() + "/" + dicc.states.size() + " states; " + dics.infos.length + " infos; recognizes " + nbofinflectedforms + " forms");
        today = new Date();
        Dic.writeLog(DateFormat.getDateTimeInstance(0, 0, lan.locale).format(today));
        Dic.writeLog("");
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has been successfully compiled in file:\n" + nodname + "\n(" + dics.states.size() + "/" + dicc.states.size() + " states; " + dics.infos.length + " infos; recognizes " + nbofinflectedforms + " forms)", "NooJ: Success", 1);
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Make sure the resource " + FilenameUtils.getBaseName(nodname) + "\nis checked in Info > Preferences > Lexical Analysis", "NooJ", 1);
        diccLemma = null;
        dicsLemma = null;
        dicc = null;
        dics = null;
        return true;
    }
}

