/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import net.nooj4nlp.engine.AmbiguitiesUnambiguitiesObject;
import net.nooj4nlp.engine.Charlist;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.FSDic;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Indexkey;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MatchType;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.Regexps;
import net.nooj4nlp.engine.TheSolutions;
import net.nooj4nlp.engine.TransitionPair;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.engine.helper.ParameterCheck;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Engine {
    public Language Lan;
    private HashMap<String, Gram> paradigms;
    private String applicationDir;
    public String docDir;
    private String projectDir;
    private boolean projectMode;
    public boolean BackgroundWorking;
    public BackgroundWorker backgroundWorker;
    public Preferences preferences;
    public boolean ResourcesLoaded;
    HashMap<String, String> properties;
    private HashMap<String, Boolean> prop_cat;
    private HashMap<String, Boolean> prop_inf;
    private ArrayList<Object> lexBins;
    private ArrayList<Object> lexGrms;
    public ArrayList<Object> synGrms;
    transient HashMap<String, String> recursiveMorphology = null;
    private String CurrentLine;
    private Engine engine2;
    private transient HashMap<String, ArrayList<String>> lexforalldics;

    private final int loadNodResources(ArrayList<String> lexresources, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        int cpt = 0;
        errmessage.argvalue = null;
        if (lexresources == null) {
            return 0;
        }
        for (String prefname0 : lexresources) {
            String fullname;
            String prefname = new File(prefname0).getName();
            String prio = prefname.substring(0, 2);
            int priority = 0;
            try {
                priority = Integer.parseInt(prio);
            }
            catch (Exception e) {
                errmessage.argvalue = "Cannot parse priority for file " + prefname;
                Dic.writeLog((String)errmessage.argvalue);
                return -1;
            }
            if (this.docDir != null) {
                String dname;
                String lname = this.Lan.isoName;
                String fname = prefname.substring(2);
                if (this.projectMode) {
                    dname = FilenameUtils.concat(this.projectDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    fullname = FilenameUtils.concat(dname, prefname);
                } else {
                    dname = FilenameUtils.concat(this.docDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    fullname = FilenameUtils.concat(dname, fname);
                }
            } else {
                String dname = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(prefname0));
                fullname = FilenameUtils.concat(dname, prefname.substring(2));
            }
            if (!new File(fullname).isFile()) {
                errmessage.argvalue = "Cannot find file " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return -1;
            }
            String ext = FilenameUtils.getExtension(fullname);
            if (!ext.equalsIgnoreCase("jnod")) continue;
            FSDic[] dics = FSDic.load(fullname, this, errmessage);
            if (dics == null) {
                errmessage.argvalue = "Cannot load dictionary " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return -1;
            }
            FSDic[] fSDicArray = dics;
            int n = dics.length;
            int n2 = 0;
            while (n2 < n) {
                FSDic dic = fSDicArray[n2];
                if (dic != null) {
                    ++cpt;
                    this.lexBins.add(dic);
                    this.lexBins.add(priority);
                    if (dic.paradigms != null) {
                        for (String expname : dic.paradigms.keySet()) {
                            if (this.paradigms.containsKey(expname)) continue;
                            this.paradigms.put(expname, dic.paradigms.get(expname));
                        }
                    }
                }
                ++n2;
            }
        }
        this.ResourcesLoaded = true;
        return cpt;
    }

    public final boolean loadResources(ArrayList<String> lexresources, ArrayList<String> synresources, boolean handlelexicongrammarpairs, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        String dname;
        String fullname;
        String lname;
        int priority;
        String prio;
        String prefname;
        errmessage.argvalue = null;
        if (lexresources == null) {
            errmessage.argvalue = "no lexical resource is provided";
            Dic.writeLog((String)errmessage.argvalue);
            return false;
        }
        for (String prefname0 : lexresources) {
            prefname = new File(prefname0).getName();
            prio = prefname.substring(0, 2);
            priority = 0;
            try {
                priority = Integer.parseInt(prio);
            }
            catch (Exception e) {
                errmessage.argvalue = "Cannot parse priority for file " + prefname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            if (this.docDir != null) {
                String dname2;
                lname = this.Lan.isoName;
                String fname = prefname.substring(2);
                if (this.projectMode) {
                    dname2 = FilenameUtils.concat(this.projectDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    if (!new File(dname2).isDirectory()) {
                        dname2 = FilenameUtils.concat(this.projectDir, lname);
                    }
                    fullname = FilenameUtils.concat(dname2, prefname);
                } else {
                    dname2 = FilenameUtils.concat(this.docDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    fullname = FilenameUtils.concat(dname2, fname);
                }
            } else {
                dname = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(prefname0));
                fullname = FilenameUtils.concat(dname, prefname.substring(2));
            }
            File newFile = new File(fullname);
            if (!newFile.isFile()) {
                errmessage.argvalue = "Cannot find resource file " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            String ext = FilenameUtils.getExtension(fullname);
            if (ext.equalsIgnoreCase("jnod")) {
                Grammar grm;
                String lg;
                FSDic[] dics = null;
                dics = FSDic.load(fullname, this, errmessage);
                if (dics == null) {
                    errmessage.argvalue = "Cannot load dictionary binary file " + fullname;
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
                FSDic[] fSDicArray = dics;
                int n = dics.length;
                int n2 = 0;
                while (n2 < n) {
                    FSDic dic = fSDicArray[n2];
                    if (dic != null) {
                        this.lexBins.add(dic);
                        this.lexBins.add(priority);
                        if (dic.paradigms != null) {
                            for (String expname : dic.paradigms.keySet()) {
                                if (this.paradigms.containsKey(expname)) continue;
                                this.paradigms.put(expname, dic.paradigms.get(expname));
                            }
                        }
                    }
                    ++n2;
                }
                if (!handlelexicongrammarpairs || !new File(lg = FilenameUtils.concat(FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(fullname)), String.valueOf(FilenameUtils.getBaseName(fullname)) + "." + "nog")).isFile() || (grm = Grammar.loadONooJGrammar(lg)) == null || grm.compileAll(this) != null) continue;
                this.synGrms.add(grm);
                this.synGrms.add(0);
                this.synGrms.add(Character.valueOf('X'));
                continue;
            }
            if (!ext.equals("nom") && !ext.equals("NOM")) continue;
            Grammar grm = null;
            boolean istextual = Grammar.isItTextual(fullname);
            if (istextual) {
                grm = Grammar.loadTextual(fullname, GramType.MORPHO, errmessage);
                if (errmessage.argvalue != null) {
                    errmessage.argvalue = "Problem in grammar " + fullname + ":\n" + (String)errmessage.argvalue;
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
            } else {
                grm = Grammar.loadGraphical(fullname, false);
            }
            if (grm == null || grm.compileAll(this) != null) continue;
            this.lexGrms.add(grm);
            this.lexGrms.add(priority);
        }
        if (synresources == null) {
            return true;
        }
        for (String prefname0 : synresources) {
            prefname = new File(prefname0).getName();
            prio = prefname.substring(0, 2);
            try {
                priority = Integer.parseInt(prio);
            }
            catch (Exception e2) {
                errmessage.argvalue = "Cannot parse order number for resource file " + prefname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            if (this.docDir != null) {
                String dname3;
                lname = this.Lan.isoName;
                if (this.projectMode) {
                    dname3 = FilenameUtils.concat(this.projectDir, FilenameUtils.concat(lname, "Syntactic Analysis"));
                    if (!new File(dname3).isDirectory()) {
                        dname3 = FilenameUtils.concat(this.projectDir, lname);
                    }
                    fullname = FilenameUtils.concat(dname3, prefname);
                } else {
                    String fname = prefname.substring(2);
                    dname3 = FilenameUtils.concat(this.docDir, FilenameUtils.concat(lname, "Syntactic Analysis"));
                    fullname = FilenameUtils.concat(dname3, fname);
                }
            } else {
                dname = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(prefname0));
                fullname = FilenameUtils.concat(dname, prefname.substring(2));
            }
            if (!new File(fullname).isFile()) {
                errmessage.argvalue = "Cannot find file " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            String ext = FilenameUtils.getExtension(fullname);
            String fn = FilenameUtils.getBaseName(fullname);
            char cfn = '\u0000';
            if (fn.length() > 2 && fn.charAt(fn.length() - 2) == '-') {
                cfn = fn.charAt(fn.length() - 1);
            }
            if (ext.equalsIgnoreCase("nog")) {
                Grammar grm = null;
                boolean istextual = Grammar.isItTextual(fullname);
                if (istextual) {
                    grm = Grammar.loadTextual(fullname, GramType.SYNTAX, errmessage);
                    if (errmessage.argvalue != null) {
                        return false;
                    }
                } else {
                    grm = Grammar.loadGraphical(fullname, false);
                }
                if (grm == null || grm.compileAll(this) != null) continue;
                this.synGrms.add(grm);
                this.synGrms.add(priority);
                if (cfn == 'A') {
                    this.synGrms.add(Character.valueOf('A'));
                    continue;
                }
                if (cfn == 'S') {
                    this.synGrms.add(Character.valueOf('S'));
                    continue;
                }
                this.synGrms.add(Character.valueOf('L'));
                continue;
            }
            if (!ext.equals("nox") && !ext.equals("NOX")) continue;
            String rawBuffer = FileUtils.readFileToString(new File(fullname), "UTF-8");
            Regexp regexp = new Regexp(this.Lan, rawBuffer, GramType.SYNTAX);
            if (regexp.Grm == null) continue;
            regexp.Grm.prepareForParsing();
            Regexps regexps = new Regexps(this.Lan, GramType.SYNTAX, regexp.Grm, this);
            Grammar grm = regexps.grammar;
            if (grm == null) continue;
            this.synGrms.add(grm);
            this.synGrms.add(priority);
            if (cfn == 'A') {
                this.synGrms.add(Character.valueOf('A'));
                continue;
            }
            if (cfn == 'S') {
                this.synGrms.add(Character.valueOf('S'));
                continue;
            }
            this.synGrms.add(Character.valueOf('L'));
        }
        this.ResourcesLoaded = true;
        return true;
    }

    /*
     * Exception decompiling
     */
    private final boolean loadCategoryPropertiesFeatures(RefObject<String> errmessage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Engine(RefObject<Language> lan, String appdir, String docdir, String projdir, boolean projectmode, Preferences prefs, boolean backgroundworking, BackgroundWorker backgroundworker) {
        String chartname;
        this.Lan = (Language)lan.argvalue;
        this.applicationDir = appdir;
        this.docDir = docdir;
        this.projectDir = projdir;
        this.projectMode = projectmode;
        this.BackgroundWorking = backgroundworking;
        this.backgroundWorker = backgroundworker;
        this.preferences = prefs;
        this.lexBins = new ArrayList();
        this.lexGrms = new ArrayList();
        this.paradigms = new HashMap();
        this.synGrms = new ArrayList();
        this.recursiveMorphology = null;
        this.engine2 = null;
        String errmessage = null;
        RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
        this.loadCategoryPropertiesFeatures(tempRef_errmessage);
        errmessage = (String)tempRef_errmessage.argvalue;
        if (errmessage != null) {
            System.out.println(errmessage);
        }
        if (!new File(chartname = FilenameUtils.concat(this.docDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "charvariants.txt")))).isFile() && !new File(chartname = FilenameUtils.concat(this.docDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "_charvariants.txt")))).isFile()) {
            return;
        }
        StringBuilder errmessage2t = new StringBuilder("");
        boolean tempVar = false;
        try {
            tempVar = !this.Lan.loadCharacterVariants(chartname, errmessage2t);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
        if (tempVar) {
            System.out.println(errmessage2t.toString());
        }
    }

    public final Mft delimit(Ntext text) {
        Mft mft = null;
        if (text.DelimPattern == null || text.DelimPattern.equals("")) {
            if (text.buffer.length() > 65535) {
                return null;
            }
            text.nbOfTextUnits = 1;
            mft = new Mft(1);
            mft.tuAddresses[1] = 0;
            mft.tuLengths[1] = text.buffer.length();
        } else {
            Pattern rexp = Pattern.compile(text.DelimPattern, 8);
            Matcher mc = rexp.matcher(text.buffer);
            int groupCount = 0;
            while (mc.find()) {
                ++groupCount;
            }
            mc = rexp.matcher(text.buffer);
            mft = new Mft(groupCount + 1);
            int itu = 1;
            int strt = 0;
            int len = 0;
            boolean needtoresize = false;
            while (mc.find()) {
                mc.group();
                int end = mc.start();
                len = mc.end() - end;
                boolean foundsomething = false;
                int i = strt;
                while (i < end) {
                    if (!Character.isWhitespace(text.buffer.charAt(i))) {
                        foundsomething = true;
                    }
                    ++i;
                }
                if (foundsomething) {
                    needtoresize = true;
                    mft.tuAddresses[itu] = strt;
                    mft.tuLengths[itu] = end - strt;
                    ++itu;
                }
                strt = end + len;
            }
            mft.tuAddresses[itu] = strt;
            mft.tuLengths[itu] = text.buffer.length() - strt;
            if (needtoresize) {
                mft.reSize(itu);
            }
            text.nbOfTextUnits = itu;
        }
        return mft;
    }

    public final String delimitTextUnits(Ntext mytext) {
        return mytext.delimitTextUnits(this);
    }

    public final Mft delimitXml(Ntext text, String[] tags, RefObject<String> errmessage) {
        errmessage.argvalue = null;
        if (tags == null || tags.length == 0) {
            errmessage.argvalue = "no XML tag for text unit?";
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        ArrayList<xmlnode> nodes = new ArrayList<xmlnode>();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            StringBuilder perltag0 = new StringBuilder();
            int i = 0;
            while (i < tag.length() - 1) {
                if (tag.charAt(i) == '\"' || tag.charAt(i) == '\'') {
                    perltag0.append('\\');
                }
                perltag0.append(tag.charAt(i));
                ++i;
            }
            String perltag = String.valueOf(perltag0.toString()) + "(>| [^>]*>)";
            Pattern begexp = Pattern.compile(perltag, 8);
            Matcher begExpMatcher = begexp.matcher(text.buffer);
            int begexpGroupCount = 0;
            while (begExpMatcher.find()) {
                ++begexpGroupCount;
            }
            if (begexpGroupCount == 0) {
                errmessage.argvalue = "Cannot find any opening tag for TUs";
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            int index = tag.indexOf(32);
            String tagending = index == -1 ? tag.substring(0, tag.length() - 1) : tag.substring(0, index);
            String endtag = "</" + tagending.substring(1) + ">";
            Pattern endexp = Pattern.compile(endtag, 8);
            Matcher endExpMatcher = endexp.matcher(text.buffer);
            int endexpGroupCount = 0;
            while (endExpMatcher.find()) {
                ++endexpGroupCount;
            }
            if (endexpGroupCount == 0) {
                errmessage.argvalue = "Cannot find any ending tag for TUs";
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            if (begexpGroupCount != endexpGroupCount) {
                errmessage.argvalue = "Numbers of beginning tags (" + begexpGroupCount + ") and ending tags (" + endexpGroupCount + ") are not equal";
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            begExpMatcher = begexp.matcher(text.buffer);
            while (begExpMatcher.find()) {
                endExpMatcher = endexp.matcher(text.buffer);
                int strt = begExpMatcher.end();
                while (endExpMatcher.find()) {
                    int end = endExpMatcher.start();
                    if (end < strt || end <= strt) continue;
                    xmlnode node = new xmlnode(strt, end);
                    nodes.add(node);
                }
            }
            ++n2;
        }
        if (nodes.isEmpty()) {
            errmessage.argvalue = "Cannot find even one pair <TU> ... </TU>";
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        Collections.sort(nodes);
        xmlnode node0 = (xmlnode)nodes.get(0);
        int i = 1;
        while (i < nodes.size()) {
            xmlnode cnode = (xmlnode)nodes.get(i);
            if (cnode.beg < node0.end) {
                nodes.remove(i);
                continue;
            }
            node0 = cnode;
            ++i;
        }
        Mft mft = new Mft(nodes.size());
        int tu = 1;
        int i2 = 0;
        while (i2 < nodes.size()) {
            xmlnode node = (xmlnode)nodes.get(i2);
            int beg = node.beg;
            int end = node.end;
            if (end > beg) {
                mft.tuAddresses[tu] = beg;
                mft.tuLengths[tu] = end - beg;
                ++tu;
            }
            ++i2;
        }
        text.nbOfTextUnits = tu - 1;
        return mft;
    }

    public final String delimitXmlTextUnitsAndImportXmlTags(Corpus corpus, Ntext mytext) {
        mytext.hLexemes = new HashMap();
        mytext.hPhrases = new HashMap();
        mytext.annotations = new ArrayList();
        String errmessage = mytext.delimitXmlTextUnitsAndImportXmlTags(corpus, this, mytext.XmlNodes, mytext.annotations, mytext.hLexemes, mytext.hPhrases);
        return errmessage;
    }

    public final void countChars(Ntext text, HashMap<Character, Integer> thechars) {
        int i = 0;
        while (i < text.buffer.length()) {
            int frq;
            char c = text.buffer.charAt(i);
            if (!thechars.containsKey(Character.valueOf(c))) {
                frq = 1;
                thechars.put(Character.valueOf(c), frq);
            } else {
                frq = thechars.get(Character.valueOf(c));
                thechars.put(Character.valueOf(c), frq + 1);
            }
            ++i;
        }
    }

    public final void computeAlphabet(Ntext text) {
        text.nbOfDiffChars = 0;
        text.nbOfChars = 0;
        text.nbOfDiffLetters = 0;
        text.nbOfLetters = 0;
        text.nbOfDiffDelimiters = 0;
        text.nbOfDelimiters = 0;
        text.nbOfDiffBlanks = 0;
        text.nbOfBlanks = 0;
        text.nbOfDiffDigits = 0;
        text.nbOfDigits = 0;
        HashMap<Character, Integer> thechars = new HashMap<Character, Integer>();
        this.countChars(text, thechars);
        text.charlist = new Charlist();
        for (char cc : thechars.keySet()) {
            ++text.nbOfDiffChars;
            text.nbOfChars += thechars.get(Character.valueOf(cc)).intValue();
            text.charlist.chars.add(Character.valueOf(cc));
            text.charlist.freqs.add((int)thechars.get(Character.valueOf(cc)));
            if (Language.isLetter(cc)) {
                ++text.nbOfDiffLetters;
                text.nbOfLetters += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("WFORM");
                continue;
            }
            if (Character.isWhitespace(cc)) {
                ++text.nbOfDiffBlanks;
                text.nbOfBlanks += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("WSPACE");
                continue;
            }
            if (Character.isDigit(cc)) {
                ++text.nbOfDiffDigits;
                text.nbOfDigits += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("DIGIT");
                continue;
            }
            ++text.nbOfDiffDelimiters;
            text.nbOfDelimiters += thechars.get(Character.valueOf(cc)).intValue();
            text.charlist.types.add("DELIM");
        }
    }

    public final void computeAlphabet(Corpus corpus, HashMap<Character, Integer> thechars) {
        corpus.nbOfDiffChars = 0;
        corpus.nbOfChars = 0;
        corpus.nbOfDiffLetters = 0;
        corpus.nbOfLetters = 0;
        corpus.nbOfDiffDelimiters = 0;
        corpus.nbOfDelimiters = 0;
        corpus.nbOfDiffBlanks = 0;
        corpus.nbOfBlanks = 0;
        corpus.nbOfDiffDigits = 0;
        corpus.nbOfDigits = 0;
        corpus.charlist = new Charlist();
        for (char cc : thechars.keySet()) {
            ++corpus.nbOfDiffChars;
            corpus.nbOfChars += thechars.get(Character.valueOf(cc)).intValue();
            corpus.charlist.chars.add(Character.valueOf(cc));
            corpus.charlist.freqs.add((int)thechars.get(Character.valueOf(cc)));
            if (Language.isLetter(cc)) {
                ++corpus.nbOfDiffLetters;
                corpus.nbOfLetters += thechars.get(Character.valueOf(cc)).intValue();
                corpus.charlist.types.add("WFORM");
                continue;
            }
            if (Character.isWhitespace(cc)) {
                ++corpus.nbOfDiffBlanks;
                corpus.nbOfBlanks += thechars.get(Character.valueOf(cc)).intValue();
                corpus.charlist.types.add("WSPACE");
                continue;
            }
            if (Character.isDigit(cc)) {
                ++corpus.nbOfDiffDigits;
                corpus.nbOfDigits += thechars.get(Character.valueOf(cc)).intValue();
                corpus.charlist.types.add("DIGIT");
                continue;
            }
            ++corpus.nbOfDiffDelimiters;
            corpus.nbOfDelimiters += thechars.get(Character.valueOf(cc)).intValue();
            corpus.charlist.types.add("DELIM");
        }
    }

    private final void addToken(HashMap<String, Integer> hCorpusTokens, HashMap<String, Indexkey> hTextTokens, String token, int begaddress, int endaddress) {
        Indexkey indexkey;
        if (hTextTokens.containsKey(token)) {
            indexkey = hTextTokens.get(token);
            indexkey.addresses.add(begaddress);
            indexkey.addresses.add(endaddress);
        } else {
            indexkey = new Indexkey();
            indexkey.addresses.add(begaddress);
            indexkey.addresses.add(endaddress);
            hTextTokens.put(token, indexkey);
        }
        if (hCorpusTokens != null) {
            if (hCorpusTokens.containsKey(token)) {
                int freq = hCorpusTokens.get(token);
                hCorpusTokens.put(token, ++freq);
            } else {
                hCorpusTokens.put(token, 1);
            }
        }
    }

    public final void addLexemeToText(ArrayList<Object> annotations, HashMap<String, Integer> hTextLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress) {
        int tokenId;
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        if (hTextLexemes.containsKey(lexeme)) {
            tokenId = hTextLexemes.get(lexeme);
        } else {
            annotations.add(lexeme);
            tokenId = annotations.size() - 1;
            hTextLexemes.put(lexeme, tokenId);
        }
        textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
    }

    public final void addLexemeToCorpus(ArrayList<Object> annotations, HashMap<String, Integer> hCorpusLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress) {
        int tokenId;
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        if (hCorpusLexemes.containsKey(lexeme)) {
            tokenId = hCorpusLexemes.get(lexeme);
        } else {
            annotations.add(lexeme);
            tokenId = annotations.size() - 1;
            hCorpusLexemes.put(lexeme, tokenId);
        }
        textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
    }

    private final void addSyntaxToText(ArrayList<Object> annotations, ArrayList<Object> coloredtext, HashMap<String, Integer> hTextLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress, boolean resetannotations) {
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        ArrayList<String> infos = Dic.normalizeInformation(category, features, this.properties);
        if (coloredtext == null) {
            coloredtext = new ArrayList();
        }
        for (String inf : infos) {
            int tokenId;
            String lex = String.valueOf(entry) + "," + lemma + "," + inf;
            String myfeature = Dic.lookFor("COLOR", lex);
            if (myfeature != null) {
                coloredtext.add((double)textmft.tuAddresses[tunb] + relbegaddress);
                String colorname = myfeature.substring(new String("COLOR=").length());
                Color c = colorname.equals("RED") ? Color.RED : (colorname.equals("GREEN") ? Color.GREEN : (colorname.equals("BLUE") ? Color.BLUE : (colorname.equals("LIGHTRED") ? Color.PINK : (colorname.equals("LIGHTGREEN") ? Color.green : (colorname.equals("LIGHTBLUE") ? Color.blue : (colorname.equals("YELLOW") ? Color.YELLOW : (colorname.equals("PURPLE") ? Color.MAGENTA : (colorname.equals("CYAN") ? Color.CYAN : Color.BLACK))))))));
                coloredtext.add(c);
                coloredtext.add(relendaddress - relbegaddress);
            }
            if (hTextLexemes.containsKey(lex)) {
                tokenId = hTextLexemes.get(lex);
                textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
                continue;
            }
            annotations.add(lex);
            tokenId = annotations.size() - 1;
            if (!hTextLexemes.containsKey(lex)) {
                hTextLexemes.put(lex, tokenId);
            }
            if (resetannotations) {
                textmft.deleteNonXrefsAndAddTransition(tunb, relbegaddress, tokenId, annotations, relendaddress);
                continue;
            }
            textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
        }
    }

    public final void addSyntaxToCorpus(ArrayList<Object> annotations, ArrayList<Object> coloredtext, HashMap<String, Integer> hCorpusLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress, boolean resetannotations) {
        int tokenId;
        String myfeature;
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        if ((myfeature = Dic.lookFor("COLOR", lexeme)) != null) {
            if (coloredtext == null) {
                coloredtext = new ArrayList();
            }
            coloredtext.add((double)textmft.tuAddresses[tunb] + relbegaddress);
            String colorname = myfeature.substring(new String("COLOR=").length());
            Color c = colorname.equals("RED") ? Color.RED : (colorname.equals("GREEN") ? Color.GREEN : (colorname.equals("BLUE") ? Color.BLUE : (colorname.equals("LIGHTRED") ? Color.PINK : (colorname.equals("LIGHTGREEN") ? Color.green : (colorname.equals("LIGHTBLUE") ? Color.blue : (colorname.equals("YELLOW") ? Color.YELLOW : (colorname.equals("PURPLE") ? Color.MAGENTA : (colorname.equals("CYAN") ? Color.CYAN : Color.BLACK))))))));
            coloredtext.add(c);
            coloredtext.add(relendaddress - relbegaddress);
        }
        if (hCorpusLexemes.containsKey(lexeme)) {
            tokenId = hCorpusLexemes.get(lexeme);
        } else {
            annotations.add(lexeme);
            tokenId = annotations.size() - 1;
            hCorpusLexemes.put(lexeme, tokenId);
        }
        if (resetannotations) {
            textmft.deleteNonXrefsAndAddTransition(tunb, relbegaddress, tokenId, annotations, relendaddress);
        } else {
            textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
        }
    }

    private final void addUnknown(ArrayList<Object> annotations, HashMap<String, Integer> hCorpusUnknowns, HashMap<String, Integer> hTextUnknowns, String unknownform) {
        int tokenId;
        String lex = String.valueOf(unknownform) + ",UNKNOWN";
        if (hCorpusUnknowns != null) {
            if (hCorpusUnknowns.containsKey(lex)) {
                tokenId = hCorpusUnknowns.get(lex);
            } else {
                annotations.add(lex);
                tokenId = annotations.size() - 1;
                hCorpusUnknowns.put(lex, tokenId);
            }
        } else {
            annotations.add(lex);
            tokenId = annotations.size() - 1;
        }
        if (!hTextUnknowns.containsKey(lex)) {
            hTextUnknowns.put(lex, tokenId);
        }
    }

    private void addSequenceToText(ArrayList<Object> annotations, HashMap<String, Integer> hCorpusLexemes, HashMap<String, Integer> hTextLexemes, ArrayList<String> tokens, Mft textmft, int tunb, int relbegaddress, int relendaddress) {
        double strtadd = relbegaddress;
        textmft.multiplier = 100.0;
        int i = 0;
        while (i < tokens.size()) {
            double intadd;
            String token = tokens.get(i);
            if (token.charAt(0) == '<' || token.charAt(0) == '{') {
                String lexeme = token.substring(1, 1 + token.length() - 2);
                if (i == tokens.size() - 1) {
                    intadd = relendaddress;
                } else {
                    ArrayList<TransitionPair> outgoings = textmft.getOutgoingTransitions(tunb, strtadd);
                    int zz = (int)((strtadd + 0.005) * 100.0) + 1;
                    intadd = (double)zz / 100.0;
                    if (outgoings != null) {
                        String entry = null;
                        String info = null;
                        String currententry = null;
                        String currentinfo = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        Dic.parseDELAS(lexeme, tempRef_entry, tempRef_info);
                        entry = (String)tempRef_entry.argvalue;
                        info = (String)tempRef_info.argvalue;
                        boolean foundcompatible = false;
                        int io = 0;
                        while (io < outgoings.size()) {
                            int tid = outgoings.get(io).getTokenId();
                            String currentlexeme = (String)annotations.get(tid);
                            RefObject<Object> tempRef_currententry = new RefObject<Object>(currententry);
                            RefObject<Object> tempRef_currentinfo = new RefObject<Object>(currentinfo);
                            Dic.parseDELAS(currentlexeme, tempRef_currententry, tempRef_currentinfo);
                            currententry = (String)tempRef_currententry.argvalue;
                            currentinfo = (String)tempRef_currentinfo.argvalue;
                            if (entry.equals(currententry) && info.equals(currentinfo)) {
                                intadd = outgoings.get(io).getRelEndAddress();
                                foundcompatible = true;
                                break;
                            }
                            ++io;
                        }
                        if (!foundcompatible) {
                            intadd = textmft.getANewVirginAddress(tunb, strtadd, relendaddress);
                        }
                    }
                }
                this.addLexemeToText(annotations, hTextLexemes, lexeme, textmft, tunb, strtadd, intadd);
            } else {
                int zz = (int)((strtadd + 0.005) * 100.0) + 1;
                intadd = (double)zz / 100.0;
            }
            strtadd = intadd;
            ++i;
        }
    }

    private void addSequenceToCorpus(ArrayList<Object> annotations, HashMap<String, Integer> hCorpusLexemes, HashMap<String, Integer> hTextLexemes, ArrayList<String> tokens, Mft textmft, int tunb, int relbegaddress, int relendaddress) {
        double strtadd = relbegaddress;
        textmft.multiplier = 100.0;
        int i = 0;
        while (i < tokens.size()) {
            double intadd;
            String token = tokens.get(i);
            if (token.charAt(0) == '<' || token.charAt(0) == '{') {
                String lexeme = token.substring(1, 1 + token.length() - 2);
                if (i == tokens.size() - 1) {
                    intadd = relendaddress;
                } else {
                    ArrayList<TransitionPair> outgoings = textmft.getOutgoingTransitions(tunb, strtadd);
                    int zz = (int)((strtadd + 0.005) * 100.0) + 1;
                    intadd = (double)zz / 100.0;
                    if (outgoings != null) {
                        String entry = null;
                        String info = null;
                        String currententry = null;
                        String currentinfo = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        Dic.parseDELAS(lexeme, tempRef_entry, tempRef_info);
                        entry = (String)tempRef_entry.argvalue;
                        info = (String)tempRef_info.argvalue;
                        boolean foundcompatible = false;
                        int io = 0;
                        while (io < outgoings.size()) {
                            int tid = outgoings.get(io).getTokenId();
                            String currentlexeme = (String)annotations.get(tid);
                            RefObject<Object> tempRef_currententry = new RefObject<Object>(currententry);
                            RefObject<Object> tempRef_currentinfo = new RefObject<Object>(currentinfo);
                            Dic.parseDELAS(currentlexeme, tempRef_currententry, tempRef_currentinfo);
                            currententry = (String)tempRef_currententry.argvalue;
                            currentinfo = (String)tempRef_currentinfo.argvalue;
                            if (entry.equals(currententry) && info.equals(currentinfo)) {
                                intadd = outgoings.get(io).getRelEndAddress();
                                foundcompatible = true;
                                break;
                            }
                            ++io;
                        }
                        if (!foundcompatible) {
                            intadd = textmft.getANewVirginAddress(tunb, strtadd, relendaddress);
                        }
                    }
                }
                this.addLexemeToCorpus(annotations, hCorpusLexemes, lexeme, textmft, tunb, strtadd, intadd);
            } else {
                int zz = (int)((strtadd + 0.005) * 100.0) + 1;
                intadd = (double)zz / 100.0;
            }
            strtadd = intadd;
            ++i;
        }
    }

    private final ArrayList<String> lookupAllLexsForCompounds(int position, String simpletoken) {
        ArrayList<String> sols = null;
        int iprio = -9;
        while (iprio < 10) {
            int idic = 0;
            while (idic < this.lexBins.size()) {
                if ((Integer)this.lexBins.get(idic + 1) == iprio) {
                    ArrayList<String> tmp;
                    FSDic lexBin = (FSDic)this.lexBins.get(idic);
                    if (lexBin.bufferc != null && (tmp = this.Lan.isoName.equals("ar") || this.Lan.isoName.equals("he") ? lexBin.lookUpCompoundSemitic(this.CurrentLine, position, this) : lexBin.lookUpCompound(this.CurrentLine, position, this)) != null && tmp.size() > 0) {
                        if (sols == null) {
                            sols = new ArrayList<String>();
                        }
                        sols.addAll(tmp);
                    }
                }
                idic += 2;
            }
            if (sols != null) break;
            ++iprio;
        }
        if (sols != null && !this.Lan.asianTokenizer) {
            this.filterSimples(sols, simpletoken.length());
        }
        return sols;
    }

    final ArrayList<String> lookupAllLexsAndMorphsForSimples(String simpletoken, boolean processconstraints, String currentline, int cpos) {
        ArrayList<String> sols = null;
        int iprio = -9;
        while (iprio < 10) {
            ArrayList<String> tmp;
            int idic = 0;
            while (idic < this.lexBins.size()) {
                FSDic lexBin = (FSDic)this.lexBins.get(idic);
                if ((Integer)this.lexBins.get(idic + 1) == iprio && (tmp = this.Lan.isoName.equals("ar") || this.Lan.isoName.equals("he") ? lexBin.lookUpSimpleSemitic(simpletoken, 0, this) : lexBin.lookUpSimple(simpletoken, 0, this)) != null && tmp.size() > 0) {
                    if (sols == null) {
                        sols = new ArrayList<String>();
                    }
                    sols.addAll(tmp);
                }
                idic += 2;
            }
            idic = 0;
            while (idic < this.lexGrms.size()) {
                Grammar lexGrm = (Grammar)this.lexGrms.get(idic);
                if ((Integer)this.lexGrms.get(idic + 1) == iprio && (tmp = lexGrm.matchWord(simpletoken, this, processconstraints, currentline, cpos)) != null && tmp.size() > 0) {
                    if (sols == null) {
                        sols = new ArrayList();
                    }
                    sols.addAll(tmp);
                }
                idic += 2;
            }
            if (sols != null) break;
            ++iprio;
        }
        if (sols == null || sols.isEmpty()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        int isol = 0;
        while (isol < sols.size()) {
            if (((String)sols.get(isol)).getClass() == String.class) {
                res.add((String)sols.get(isol));
                res.add(Integer.toString(simpletoken.length()));
            } else {
                res.add((String)sols.get(isol + 1));
                res.add((String)sols.get(isol));
                ++isol;
            }
            ++isol;
        }
        return res;
    }

    private final ArrayList<String> lookupAndAnalyzeSimpleOrCompound(String token, RefObject<String> errmessage) {
        ArrayList<String> ressols = null;
        errmessage.argvalue = null;
        ArrayList<String> sols = this.Lan.isACompound(token) ? this.lookupAllLexsForCompounds(0, token) : this.lookupAllLexsAndMorphsForSimples(token, false, null, 0);
        if (sols != null) {
            ressols = new ArrayList<String>();
            int i = 0;
            while (i < sols.size()) {
                String entry = null;
                String info = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
                entry = (String)tempRef_entry.argvalue;
                info = (String)tempRef_info.argvalue;
                if (this.isComplex(info)) {
                    ArrayList<ArrayList<String>> resultingexp = this.processTokenAnalysis(1, info, token, 1, errmessage);
                    if (resultingexp == null) {
                        if (errmessage.argvalue != null) {
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                    } else {
                        ArrayList<ArrayList<String>> defactorizedexp = new ArrayList<ArrayList<String>>();
                        Engine.recursiveDevelop(new ArrayList<String>(), resultingexp, defactorizedexp);
                        int iterm = 0;
                        while (iterm < defactorizedexp.size()) {
                            ArrayList<String> sequence = defactorizedexp.get(iterm);
                            ArrayList<String> seq2 = this.getRidOfConstraints(sequence);
                            ArrayList<String> seq3 = this.getRidOfAngles(seq2);
                            StringBuilder asol = Grammar.computeInput(seq3);
                            ressols.add(asol.toString());
                            ++iterm;
                        }
                    }
                } else {
                    ressols.add(sols.get(i));
                }
                i += 2;
            }
        }
        return ressols;
    }

    final ArrayList<String> getRidOfConstraints(ArrayList<String> sequence) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < sequence.size()) {
            String tok = sequence.get(i);
            if (tok != null && !Dic.isALexicalConstraint(tok)) {
                res.add(tok);
            }
            ++i;
        }
        return res;
    }

    private final ArrayList<String> getRidOfAngles(ArrayList<String> sequence) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < sequence.size()) {
            String tok = sequence.get(i);
            if (tok != null) {
                if (tok.charAt(0) == '<' || tok.charAt(0) == '{') {
                    res.add(tok.substring(1, 1 + tok.length() - 2));
                } else {
                    res.add(tok);
                }
            }
            ++i;
        }
        return res;
    }

    private void filterSimples(ArrayList<String> sols, int simpleTokenLength) {
        String entry = null;
        String info = null;
        int i = 0;
        while (i < sols.size()) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            if (entry.length() == simpleTokenLength) {
                sols.subList(i, 2 + i).clear();
                continue;
            }
            i += 2;
        }
    }

    private final boolean filterUnamb(ArrayList<String> sols) {
        String myfeature;
        String entry = null;
        String info = null;
        boolean found = false;
        int i = 0;
        while (i < sols.size()) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            myfeature = Dic.lookFor("UNAMB", info);
            if (myfeature != null) {
                found = true;
                break;
            }
            i += 2;
        }
        if (!found) {
            return false;
        }
        if (found) {
            i = 0;
            while (i < sols.size()) {
                RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
                RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
                Dic.parseDELAS(sols.get(i), tempRef_entry2, tempRef_info2);
                entry = (String)tempRef_entry2.argvalue;
                info = (String)tempRef_info2.argvalue;
                myfeature = Dic.lookFor("UNAMB", info);
                if (myfeature == null) {
                    sols.subList(i, 2 + i).clear();
                    continue;
                }
                i += 2;
            }
        }
        i = 0;
        while (i < sols.size()) {
            String line = sols.get(i);
            int index = line.indexOf("+UNAMB");
            if (index != -1) {
                String line2 = String.valueOf(line.substring(0, index)) + line.substring(index + new String("+UNAMB").length());
                sols.set(i, line2);
            }
            i += 2;
        }
        return true;
    }

    public static void filterNonWords(ArrayList<String> sols) {
        String entry = null;
        String info = null;
        int i = 0;
        while (i < sols.size()) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            String myfeature = Dic.lookFor("NW", info);
            if (myfeature != null) {
                sols.subList(i, 2 + i).clear();
                continue;
            }
            i += 2;
        }
    }

    private ArrayList<ArrayList<String>> processTokenAnalysis(int itu, String tokenSequence, String initialtoken, int priority, RefObject<String> errmessage) {
        ArrayList<ArrayList<String>> result = null;
        errmessage.argvalue = null;
        String[] tokens = this.Lan.parseSequenceOfTokens(tokenSequence);
        if ((tokens = this.concatenateAllINFOs(tokens)) == null) {
            errmessage.argvalue = "invalid lexical info: " + tokenSequence;
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        int i = 0;
        while (i < tokens.length) {
            ArrayList<String> csols;
            ArrayList<String> csols0;
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            String op = null;
            boolean negation = false;
            if (Dic.isALexicalConstraint(tokens[i])) {
                csols0 = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                RefObject<Object> tempRef_op = new RefObject<Object>(op);
                RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
                Dic.parseLexicalConstraint(tokens[i], tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_op, tempRef_negation);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String[])tempRef_features.argvalue;
                op = (String)tempRef_op.argvalue;
                negation = (Boolean)tempRef_negation.argvalue;
                if (!op.equals("=:")) {
                    Dic.writeLog("Operator '" + op + "' in symbol " + tokens[i] + " is invalid");
                }
                if (category != null && category.length() > 1) {
                    if (!initialtoken.equals(entry)) {
                        if (this.recursiveMorphology == null) {
                            this.recursiveMorphology = new HashMap();
                        } else if (this.recursiveMorphology.containsKey(entry)) {
                            return null;
                        }
                        this.recursiveMorphology.put(entry, null);
                        csols0 = this.lookupAndAnalyzeSimpleOrCompound(entry, errmessage);
                        if (csols0 == null && errmessage.argvalue != null) {
                            return null;
                        }
                        this.recursiveMorphology.remove(entry);
                    }
                } else if (lemma != null && lemma.length() > 1 && !initialtoken.equals(entry)) {
                    if (this.recursiveMorphology == null) {
                        this.recursiveMorphology = new HashMap();
                    } else if (this.recursiveMorphology.containsKey(entry)) {
                        return null;
                    }
                    this.recursiveMorphology.put(entry, null);
                    csols0 = this.lookupAndAnalyzeSimpleOrCompound(entry, errmessage);
                    if (csols0 == null && errmessage.argvalue != null) {
                        return null;
                    }
                    this.recursiveMorphology.remove(entry);
                }
                if (csols0 == null || csols0.isEmpty()) {
                    return null;
                }
                ArrayList<String> csols2 = new ArrayList<String>(csols0);
                if (category != null) {
                    Grammar.filterConstraint(csols2, entry, lemma, category, features, negation);
                }
                if (csols2.isEmpty()) {
                    return null;
                }
                csols = Grammar.transformConstraintIntoLUNoLU(csols2);
            } else if (tokens[i].charAt(0) == '<') {
                csols = new ArrayList();
                RefObject<ArrayList<String>> tempRef_csols = new RefObject<ArrayList<String>>(csols);
                Dic.normalizeLexemeSymbol(tokens[i], this, tempRef_csols);
                csols = (ArrayList<String>)tempRef_csols.argvalue;
            } else {
                csols0 = this.lookupAllLexsAndMorphsForSimples(tokens[i], false, tokens[i], 0);
                if (csols0 == null) {
                    csols = new ArrayList();
                    csols.add(tokens[i]);
                } else {
                    csols = Grammar.addBracketsAround(csols0);
                }
            }
            if (result == null) {
                result = new ArrayList<ArrayList<String>>();
            }
            result.add(csols);
            ++i;
        }
        return result;
    }

    private static void recursiveDevelop(ArrayList<String> prefix, ArrayList<ArrayList<String>> expression, ArrayList<ArrayList<String>> result) {
        if (expression.isEmpty()) {
            result.add(new ArrayList<String>(prefix));
            return;
        }
        ArrayList<String> fact = expression.get(0);
        if (fact == null) {
            ArrayList expSublist = new ArrayList();
            if (expression.size() == 1) {
                expSublist = new ArrayList();
            } else if (expression.size() == 2) {
                expSublist.add(expression.get(1));
            } else {
                expSublist = (ArrayList)expression.subList(1, expression.size() - 1);
            }
            Engine.recursiveDevelop(prefix, expSublist, result);
        } else {
            int iterm = 0;
            while (iterm < fact.size()) {
                ArrayList expSublist = new ArrayList();
                ArrayList<String> tmp = new ArrayList<String>(prefix);
                tmp.add(fact.get(iterm));
                if (expression.size() == 1) {
                    expSublist = new ArrayList();
                } else if (expression.size() == 2) {
                    expSublist.add(expression.get(1));
                } else {
                    expSublist = (ArrayList)expression.subList(1, expression.size() - 1);
                }
                Engine.recursiveDevelop(tmp, expSublist, result);
                ++iterm;
            }
        }
    }

    private final boolean isComplex(String info) {
        return info != null && !info.equals("") && (info.charAt(0) == '<' || info.charAt(0) == '{');
    }

    private final boolean isComplex(String info, RefObject<Boolean> thereisalexicalunit) {
        thereisalexicalunit.argvalue = false;
        boolean iscomplex = false;
        if (info == null) {
            return false;
        }
        if (info.equals("")) {
            return false;
        }
        if (info.charAt(0) != '<' && info.charAt(0) != '{') {
            return false;
        }
        int i = 0;
        while (i < info.length()) {
            String simplelex;
            int j;
            if (info.charAt(i) == '<') {
                iscomplex = true;
                j = 0;
                while (j + i < info.length() && info.charAt(i + j) != '>') {
                    ++j;
                }
                simplelex = info.substring(i, i + j + 1);
            } else if (info.charAt(i) == '{') {
                iscomplex = true;
                j = 0;
                while (j + i < info.length() && info.charAt(i + j) != '}') {
                    ++j;
                }
                simplelex = info.substring(i, i + j + 1);
            } else {
                return false;
            }
            if (Dic.isALexicalSymbol(simplelex)) {
                thereisalexicalunit.argvalue = true;
                return true;
            }
            i += j;
            ++i;
        }
        return iscomplex;
    }

    private String getLexicalUnit(ArrayList<String> sequence, int varnumber) {
        int nb = 1;
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (token != null && token.length() > 4) {
                int istrt = 0;
                int found = token.indexOf("<LU=", istrt);
                while (found != -1) {
                    int level = 1;
                    int len = 4;
                    while (found + len < token.length()) {
                        if (token.charAt(found + len) == '<') {
                            ++level;
                        } else if (token.charAt(found + len) == '>' && --level == 0) {
                            ++len;
                            break;
                        }
                        ++len;
                    }
                    if (nb == varnumber) {
                        return token.substring(found, found + len);
                    }
                    ++nb;
                    found = token.indexOf("<LU=", found + len);
                }
            }
            ++iseq;
        }
        return null;
    }

    private void deleteAllLUsFromOutput(ArrayList<String> sequence) {
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (token == null || token.length() < 4) {
                ++iseq;
                continue;
            }
            int istrt = 0;
            int found = token.indexOf("<LU=", istrt);
            if (found == -1) {
                ++iseq;
                continue;
            }
            int len = 4;
            while (found + len < token.length() && token.charAt(found + len) != '>') {
                ++len;
            }
            sequence.set(iseq, String.valueOf(token.substring(0, found)) + token.substring(found + len + 1));
        }
    }

    private final boolean isASyntacticFeature(String feature) {
        if (this.prop_inf == null) {
            return feature.length() > 1;
        }
        int index = feature.indexOf(61);
        if (index != -1) {
            String feat = feature.substring(index + 1);
            return !this.prop_inf.containsKey(feat);
        }
        return !this.prop_inf.containsKey(feature);
    }

    private final boolean isAninflectionalFeature(String feature) {
        if (feature.equals("NW")) {
            return false;
        }
        if (feature.equals("FXC")) {
            return false;
        }
        if (this.prop_inf == null) {
            return feature.length() == 1;
        }
        int index = feature.indexOf(61);
        if (index != -1) {
            String feat = feature.substring(index + 1);
            return this.prop_inf.containsKey(feat);
        }
        return this.prop_inf.containsKey(feature);
    }

    private String getVariableValue(ArrayList<String> sequence, int varnumber, char vartype) {
        String lu = this.getLexicalUnit(sequence, varnumber);
        if (lu == null) {
            return null;
        }
        String entry = null;
        String category = null;
        String lemma = null;
        String[] features = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        Dic.parseLexicalUnit(lu, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        StringBuilder res = null;
        switch (vartype) {
            case 'E': {
                return entry;
            }
            case 'L': {
                return lemma;
            }
            case 'C': {
                return category;
            }
            case 'S': {
                if (features == null) {
                    return "";
                }
                res = new StringBuilder();
                int i = 0;
                while (i < features.length) {
                    if (features[i] != null && !features[i].equals("") && this.isASyntacticFeature(features[i]) && !features[i].equals("NW")) {
                        res.append("+" + features[i]);
                    }
                    ++i;
                }
                return res.toString();
            }
            case 'F': {
                if (features == null) {
                    return "";
                }
                res = new StringBuilder();
                int i = 0;
                while (i < features.length) {
                    if (features[i] != null && !features[i].equals("") && this.isAninflectionalFeature(features[i])) {
                        res.append("+" + features[i]);
                    }
                    ++i;
                }
                return res.toString();
            }
        }
        return null;
    }

    private String getMorphoValue(String varname, ArrayList<String> inputs) {
        int index = -1;
        int iinput = inputs.size() - 1;
        while (iinput >= 0) {
            String si = inputs.get(iinput);
            if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                index = iinput;
                break;
            }
            --iinput;
        }
        StringBuilder res = new StringBuilder();
        int rec = 0;
        ++index;
        while (index < inputs.size()) {
            String si = inputs.get(index);
            if (si != null && si.length() != 0) {
                if (si.length() > 2 && si.charAt(0) == '$' && si.charAt(1) == '(') {
                    ++rec;
                } else if (si.length() >= 2 && si.charAt(0) == '$' && si.charAt(1) == ')') {
                    if (rec == 0) break;
                    --rec;
                } else {
                    res.append(si);
                }
            }
            ++index;
        }
        return res.toString();
    }

    public final void processELCSFVariables(ArrayList<String> sequence, String wholetoken) {
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (token != null && token.length() > 0) {
                StringBuilder res = new StringBuilder();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) == '$') {
                        if (Character.isDigit(token.charAt(i + 1))) {
                            int varnb = Character.digit(token.charAt(i + 1), 10);
                            String val = null;
                            if (varnb > 0) {
                                val = this.getVariableValue(sequence, varnb, token.charAt(i + 2));
                                res.append(val);
                                i += 3;
                                continue;
                            }
                            val = wholetoken;
                            res.append(val);
                            i += 2;
                            continue;
                        }
                        res.append(token.charAt(i++));
                        continue;
                    }
                    if (token.charAt(i) == '\\') {
                        res.append(token.charAt(i++));
                        res.append(token.charAt(i++));
                        continue;
                    }
                    res.append(token.charAt(i++));
                }
                sequence.set(iseq, res.toString());
            }
            ++iseq;
        }
    }

    private void removeConstraints(ArrayList<String> sequence) {
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (Dic.isALexicalConstraint(token)) {
                sequence.remove(iseq);
                continue;
            }
            ++iseq;
        }
    }

    private String[] concatenateAllINFOs(String[] sequence) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        int iseq = 0;
        while (iseq < sequence.length) {
            String token0 = sequence[iseq];
            String token = token0.replace('{', '<').replace('}', '>');
            if (token.length() >= 5 && token.substring(0, 5).equals("<INFO")) {
                suffixes.add(token);
            } else {
                result.add(token);
            }
            ++iseq;
        }
        if (suffixes.size() > 0) {
            if (result.isEmpty()) {
                result.add("<INVALIDANNOTATION>");
                String[] res0 = new String[result.size()];
                result.toArray(res0);
                return res0;
            }
            String last0 = (String)result.get(result.size() - 1);
            String last = last0.substring(0, last0.length() - 1);
            int i = 0;
            while (i < suffixes.size()) {
                String suf0 = (String)suffixes.get(i);
                String suf = suf0.substring(5, 5 + suf0.length() - 6);
                last = String.valueOf(last) + suf;
                ++i;
            }
            result.set(result.size() - 1, String.valueOf(last) + ">");
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    private ArrayList<String> concatenateAllINFOs(ArrayList<String> sequence) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token0 = sequence.get(iseq);
            String token = token0.replace('{', '<').replace('}', '>');
            if (token.length() >= 5 && token.substring(0, 5).equals("<INFO")) {
                suffixes.add(token);
            } else {
                result.add(token);
            }
            ++iseq;
        }
        if (suffixes.size() > 0) {
            if (result.isEmpty()) {
                result.add("<INVALIDANNOTATION>");
                return result;
            }
            String last0 = result.get(result.size() - 1);
            String last = last0.substring(0, last0.length() - 1);
            int i = 0;
            while (i < suffixes.size()) {
                String suf0 = (String)suffixes.get(i);
                String suf = suf0.substring(5, 5 + suf0.length() - 6);
                last = String.valueOf(last) + suf;
                ++i;
            }
            result.set(result.size() - 1, String.valueOf(last) + ">");
        }
        return result;
    }

    private final ArrayList<String> processDollarZero(ArrayList<String> sequence, String dollarzerovalue) {
        ArrayList<String> result = new ArrayList<String>();
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            result.add(token.replace("$0", dollarzerovalue));
            ++iseq;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean tokenize(Corpus corpus, Ntext text, ArrayList<Object> annotations, HashMap<String, ArrayList<String>> simpleWordMorphology, RefObject<String> errmessage) {
        errmessage.argvalue = null;
        if (corpus == null) {
            hCorpusLexemes = null;
            hCorpusUnknowns = null;
        } else {
            hCorpusLexemes = corpus.hLexemes;
            hCorpusUnknowns = corpus.hUnknowns;
        }
        text.hLexemes = new HashMap<K, V>();
        text.hUnknowns = new HashMap<K, V>();
        text.hTokens = new HashMap<K, V>();
        text.nbOfWords = 0;
        text.nbOfTokens = 0;
        text.nbOfDelimiters = 0;
        text.nbOfDigits = 0;
        text.nbOfTokens = 0;
        text.nbOfWords = 0;
        progressPercentage = 0;
        processConstraints = new HashMap<String, ArrayList>();
        itu = 1;
        while (itu < text.mft.tuAddresses.length) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                if (corpus == null && (nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits)) != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                block45: {
                    if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                        ++ichar;
                        continue;
                    }
                    cpos = ichar++;
                    ++text.nbOfTokens;
                    if (Language.isLetter(this.CurrentLine.charAt(cpos))) {
                        ++text.nbOfWords;
                        if (this.Lan.asianTokenizer) {
                            token = this.CurrentLine.substring(cpos, cpos + 1);
                        } else {
                            ++ichar;
                            while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                                ++ichar;
                            }
                            token = this.CurrentLine.substring(cpos, ichar);
                        }
                    } else {
                        if (text.XmlNodes != null && this.CurrentLine.charAt(cpos) == '<') {
                            ++ichar;
                            while (ichar < this.CurrentLine.length() && this.CurrentLine.charAt(ichar) != '>') {
                                ++ichar;
                            }
                            if (ichar < this.CurrentLine.length()) {
                                token = this.CurrentLine.substring(cpos, ++ichar);
                                continue;
                            }
                            ichar = cpos + 1;
                            token = this.CurrentLine.substring(cpos, cpos + 1);
                            continue;
                        }
                        if (Character.isDigit(this.CurrentLine.charAt(cpos))) {
                            ++text.nbOfDigits;
                        } else {
                            ++text.nbOfDelimiters;
                        }
                        ++ichar;
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                    }
                    found = false;
                    s_sols = null;
                    if (!this.Lan.asianTokenizer && Language.isLetter(token.charAt(0))) {
                        if (this.Lan.isoName.equals("ar") || this.Lan.isoName.equals("he") || this.Lan.isoName.equals("vi")) {
                            s_sols = this.lookupAllLexsAndMorphsForSimples(token, true, this.CurrentLine, cpos);
                            if (s_sols != null) {
                                Engine.filterNonWords(s_sols);
                                this.filterUnamb(s_sols);
                            }
                        } else if (simpleWordMorphology.containsKey(token)) {
                            s_sols = simpleWordMorphology.get(token);
                        } else {
                            s_sols = this.lookupAllLexsAndMorphsForSimples(token, true, this.CurrentLine, cpos);
                            if (s_sols == null) {
                                simpleWordMorphology.put(token, null);
                            } else {
                                Engine.filterNonWords(s_sols);
                                this.filterUnamb(s_sols);
                                simpleWordMorphology.put(token, s_sols);
                            }
                        }
                    }
                    thereisunamb = false;
                    c_sols = this.lookupAllLexsForCompounds(cpos, token);
                    if (c_sols != null && c_sols.size() > 0) {
                        Engine.filterNonWords(c_sols);
                        thereisunamb = this.filterUnamb(c_sols);
                        if (s_sols != null && s_sols.size() > 0) {
                            if (!thereisunamb) {
                                sols /* !! */  = new ArrayList<String>(s_sols);
                                sols /* !! */ .addAll(c_sols);
                            } else {
                                sols /* !! */  = new ArrayList<String>(c_sols);
                            }
                        } else {
                            sols /* !! */  = new ArrayList<String>(c_sols);
                        }
                    } else {
                        sols /* !! */  = s_sols != null && s_sols.size() > 0 ? new ArrayList<E>(s_sols) : null;
                    }
                    if (sols /* !! */  == null) break block45;
                    i = 0;
                    while (i < sols /* !! */ .size()) {
                        block46: {
                            block47: {
                                block48: {
                                    entry = null;
                                    lemma = null;
                                    info = null;
                                    tempRef_entry = new RefObject<Object>(entry);
                                    tempRef_lemma = new RefObject<Object>(lemma);
                                    tempRef_info = new RefObject<Object>(info);
                                    tempVar = Dic.parseDELAF(((String)sols /* !! */ .get(i)).toString(), tempRef_entry, tempRef_lemma, tempRef_info) == false;
                                    entry = (String)tempRef_entry.argvalue;
                                    lemma = (String)tempRef_lemma.argvalue;
                                    info = (String)tempRef_info.argvalue;
                                    if (tempVar) break block46;
                                    len = Integer.parseInt(((String)sols /* !! */ .get(i + 1)).toString());
                                    if (thereisunamb) {
                                        ichar = cpos + len;
                                    }
                                    lextags = false;
                                    tempRef_lextags = new RefObject<Boolean>(lextags);
                                    tempVar2 = this.isComplex(info, tempRef_lextags);
                                    lextags = (Boolean)tempRef_lextags.argvalue;
                                    if (!tempVar2) break block47;
                                    defactorizedexp = new ArrayList();
                                    if (!processConstraints.containsKey(info)) break block48;
                                    defactorizedexp = (ArrayList)processConstraints.get(info);
                                    ** GOTO lbl150
                                }
                                resultingexp = this.processTokenAnalysis(itu, info, token, 1, errmessage);
                                if (resultingexp == null) {
                                    if (errmessage.argvalue != null && !((String)errmessage.argvalue).equals("")) {
                                        return false;
                                    }
                                } else {
                                    Engine.recursiveDevelop(new ArrayList<String>(), resultingexp, defactorizedexp);
                                    if (lextags) {
                                        iterm = 0;
                                        while (iterm < defactorizedexp.size()) {
                                            sequence = (ArrayList<String>)defactorizedexp.get(iterm);
                                            this.processELCSFVariables(sequence, token);
                                            this.removeConstraints(sequence);
                                            sequence = this.concatenateAllINFOs(sequence);
                                            sequence = this.processDollarZero(sequence, token);
                                            defactorizedexp.set(iterm, sequence);
                                            ++iterm;
                                        }
                                    }
                                    processConstraints.put(info, defactorizedexp);
lbl150:
                                    // 2 sources

                                    iterm = 0;
                                    while (iterm < defactorizedexp.size()) {
                                        sequence = (ArrayList)defactorizedexp.get(iterm);
                                        if (corpus != null) {
                                            this.addSequenceToCorpus(annotations, hCorpusLexemes, text.hLexemes, sequence, text.mft, itu, cpos, cpos + len);
                                        } else {
                                            this.addSequenceToText(annotations, hCorpusLexemes, text.hLexemes, sequence, text.mft, itu, cpos, cpos + len);
                                        }
                                        ++iterm;
                                    }
                                    found = true;
                                }
                                break block46;
                            }
                            if (corpus != null) {
                                this.addLexemeToCorpus(annotations, hCorpusLexemes, ((String)sols /* !! */ .get(i)).toString(), text.mft, itu, cpos, cpos + len);
                            } else {
                                this.addLexemeToText(annotations, text.hLexemes, ((String)sols /* !! */ .get(i)).toString(), text.mft, itu, cpos, cpos + len);
                            }
                            found = true;
                        }
                        i += 2;
                    }
                }
                if (found || !Language.isLetter(this.CurrentLine.charAt(cpos))) continue;
                this.addUnknown(annotations, hCorpusUnknowns, text.hUnknowns, token);
            }
            ++itu;
        }
        return true;
    }

    public final boolean computeAmbiguities(Corpus corpus, String fname, Ntext text, ArrayList<Object> annotations, RefObject<HashMap<String, ArrayList<Object>>> hAmbiguities) {
        int progressPercentage = 0;
        int itu = 1;
        while (itu < text.mft.tuAddresses.length) {
            if (this.BackgroundWorking) {
                int nprogress;
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                if (corpus == null && (nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits)) != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            ArrayList<AmbiguitiesUnambiguitiesObject> ambs = text.mft.getAllAmbiguitiesInTextUnit(itu);
            int i = 0;
            while (i < ambs.size()) {
                ArrayList addresses;
                double beg = ambs.get(i).getRelBegAddress() + (double)text.mft.tuAddresses[itu];
                ArrayList<Integer> tokenids = ambs.get(i).getTokenIds();
                double end = ambs.get(i).getRelEndAddress() + (double)text.mft.tuAddresses[itu];
                StringBuilder ambannotations = new StringBuilder();
                for (int tk : tokenids) {
                    String info;
                    RefObject<Object> tempRef_info;
                    String lemma;
                    RefObject<Object> tempRef_lemma;
                    String entry;
                    RefObject<Object> tempRef_entry;
                    String lex = (String)annotations.get(tk);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_info = new RefObject<Object>((info = null)));
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (tempVar) continue;
                    if (lemma != null) {
                        ambannotations.append("<" + Dic.protectComma(lemma) + "," + info + "> ");
                        continue;
                    }
                    ambannotations.append("<" + info + "> ");
                }
                String amb = ambannotations.toString();
                if (((HashMap)hAmbiguities.argvalue).containsKey(amb)) {
                    addresses = (ArrayList)((HashMap)hAmbiguities.argvalue).get(amb);
                    addresses.add(beg);
                    addresses.add(end);
                    if (corpus != null) {
                        addresses.add(fname);
                    }
                    addresses.add(itu);
                } else {
                    addresses = new ArrayList();
                    addresses.add(beg);
                    addresses.add(end);
                    if (corpus != null) {
                        addresses.add(fname);
                    }
                    addresses.add(itu);
                    ((HashMap)hAmbiguities.argvalue).put(amb, addresses);
                }
                ++i;
            }
            ++itu;
        }
        return true;
    }

    public final boolean computeUnambiguities(Corpus corpus, String fname, Ntext text, ArrayList<Object> annotations, RefObject<HashMap<String, ArrayList<Object>>> hUnambiguities) {
        int progressPercentage = 0;
        int itu = 1;
        while (itu < text.mft.tuAddresses.length) {
            if (this.BackgroundWorking) {
                int nprogress;
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                if (corpus == null && (nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits)) != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            ArrayList<AmbiguitiesUnambiguitiesObject> ambs = text.mft.getAllUnambiguitiesInTextUnit(itu);
            int i = 0;
            while (i < ambs.size()) {
                ArrayList addresses;
                double beg = ambs.get(i).getRelBegAddress() + (double)text.mft.tuAddresses[itu];
                ArrayList<Integer> tokenids = ambs.get(i).getTokenIds();
                double end = ambs.get(i).getRelEndAddress() + (double)text.mft.tuAddresses[itu];
                StringBuilder ambannotations = new StringBuilder();
                for (int tk : tokenids) {
                    String info;
                    RefObject<Object> tempRef_info;
                    String lemma;
                    RefObject<Object> tempRef_lemma;
                    String entry;
                    RefObject<Object> tempRef_entry;
                    String lex = (String)annotations.get(tk);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_info = new RefObject<Object>((info = null)));
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (tempVar) continue;
                    if (lemma != null) {
                        ambannotations.append("<" + Dic.protectComma(lemma) + "," + info + ">");
                        continue;
                    }
                    ambannotations.append("<" + info + ">");
                }
                String amb = ambannotations.toString();
                if (((HashMap)hUnambiguities.argvalue).containsKey(amb)) {
                    addresses = (ArrayList)((HashMap)hUnambiguities.argvalue).get(amb);
                    addresses.add(beg);
                    addresses.add(end);
                    if (corpus != null) {
                        addresses.add(fname);
                    }
                    addresses.add(itu);
                } else {
                    addresses = new ArrayList();
                    addresses.add(beg);
                    addresses.add(end);
                    if (corpus != null) {
                        addresses.add(fname);
                    }
                    addresses.add(itu);
                    ((HashMap)hUnambiguities.argvalue).put(amb, addresses);
                }
                ++i;
            }
            ++itu;
        }
        return true;
    }

    public final String enrichDictionary(String[] dictionarylines) {
        StringBuilder resultingdic = new StringBuilder();
        int progressPercentage = 0;
        int itu = 0;
        while (itu < dictionarylines.length) {
            String currentline;
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return null;
                }
                int nprogress = (int)((float)itu * 100.0f / (float)dictionarylines.length);
                if (nprogress != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            if ((currentline = dictionarylines[itu]).equals("") || currentline.charAt(0) == '#') {
                resultingdic.append(String.valueOf(currentline) + "\n");
            } else {
                String lineentry = null;
                RefObject<Object> tempRef_lineentry = new RefObject<Object>(lineentry);
                String linelemma = null;
                RefObject<Object> tempRef_linelemma = new RefObject<Object>(linelemma);
                String linecategory = null;
                RefObject<Object> tempRef_linecategory = new RefObject<Object>(linecategory);
                String[] linefeatures = null;
                RefObject<Object> tempRef_linefeatures = new RefObject<Object>(linefeatures);
                boolean tempVar = !Dic.parseDELAFFeatureArray(currentline, tempRef_lineentry, tempRef_linelemma, tempRef_linecategory, tempRef_linefeatures);
                lineentry = (String)tempRef_lineentry.argvalue;
                linelemma = (String)tempRef_linelemma.argvalue;
                linecategory = (String)tempRef_linecategory.argvalue;
                linefeatures = (String[])tempRef_linefeatures.argvalue;
                if (!tempVar && !linecategory.equals("")) {
                    ArrayList sols;
                    ArrayList<String> c_sols;
                    ArrayList<String> s_sols = null;
                    if (!this.Lan.asianTokenizer) {
                        s_sols = this.lookupAllLexsAndMorphsForSimples(lineentry, true, null, 0);
                    }
                    if ((c_sols = this.lookupAllLexsForCompounds(0, lineentry)) != null && c_sols.size() > 0) {
                        if (s_sols != null && s_sols.size() > 0) {
                            sols = (ArrayList)s_sols.clone();
                            sols.addAll(c_sols);
                        } else {
                            sols = (ArrayList)c_sols.clone();
                        }
                    } else {
                        sols = s_sols != null && s_sols.size() > 0 ? (ArrayList)s_sols.clone() : null;
                    }
                    if (sols == null) {
                        resultingdic.append(String.valueOf(currentline) + "\n");
                    } else {
                        StringBuilder linefeats = new StringBuilder();
                        if (linefeatures != null) {
                            String[] stringArray = linefeatures;
                            int n = linefeatures.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String linefeat = stringArray[n2];
                                linefeats.append("+" + linefeat);
                                ++n2;
                            }
                        }
                        boolean didsomething = false;
                        int i = 0;
                        while (i < sols.size()) {
                            StringBuilder newfeats = new StringBuilder(linefeats.toString());
                            String entry = null;
                            String lemma = null;
                            String category = null;
                            String[] features = null;
                            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                            RefObject<Object> tempRef_category = new RefObject<Object>(category);
                            RefObject<Object> tempRef_features = new RefObject<Object>(features);
                            boolean tempVar2 = !Dic.parseDELAFFeatureArray((String)sols.get(i), tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
                            entry = (String)tempRef_entry.argvalue;
                            lemma = (String)tempRef_lemma.argvalue;
                            category = (String)tempRef_category.argvalue;
                            features = (String[])tempRef_features.argvalue;
                            if (!tempVar2 && entry.length() >= lineentry.length() && entry.equals(lemma) && linecategory.equals(category)) {
                                Dic.getRidOfSpecialFeatures(features);
                                if (features != null && features.length > 0) {
                                    ArrayList<String> newfeatures = new ArrayList<String>();
                                    String[] stringArray = features;
                                    int n = features.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        String feat = stringArray[n3];
                                        boolean found = false;
                                        if (linefeatures != null && linefeatures.length > 0) {
                                            String[] stringArray2 = linefeatures;
                                            int n4 = linefeatures.length;
                                            int n5 = 0;
                                            while (n5 < n4) {
                                                String linefeat = stringArray2[n5];
                                                if (feat.equals(linefeat)) {
                                                    found = true;
                                                    break;
                                                }
                                                ++n5;
                                            }
                                        }
                                        if (!found) {
                                            newfeatures.add(feat);
                                        }
                                        ++n3;
                                    }
                                    for (String newfeat : newfeatures) {
                                        newfeats.append("+" + newfeat);
                                    }
                                }
                                String resline = String.valueOf(entry) + "," + category + newfeats;
                                resultingdic.append(String.valueOf(resline) + "\n");
                                didsomething = true;
                            }
                            i += 2;
                        }
                        if (!didsomething) {
                            resultingdic.append(String.valueOf(currentline) + "\n");
                        }
                    }
                }
            }
            ++itu;
        }
        return resultingdic.toString();
    }

    public final void computeTokens(Corpus corpus, Ntext text) {
        HashMap<String, Integer> hCorpusTokens = corpus == null ? null : corpus.hTokens;
        text.hTokens = new HashMap();
        text.nbOfWords = 0;
        text.nbOfTokens = 0;
        int progressPercentage = 0;
        int itu = 1;
        while (itu < text.mft.tuAddresses.length) {
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            int ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                int epos;
                String token;
                if (this.BackgroundWorking) {
                    int nprogress;
                    if (this.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    if (corpus == null && (nprogress = (int)((float)ichar * 100.0f / (float)this.CurrentLine.length())) != progressPercentage) {
                        progressPercentage = nprogress;
                        if (this.backgroundWorker.isBusy()) {
                            this.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                int cpos = ichar;
                ++text.nbOfTokens;
                if (Language.isLetter(this.CurrentLine.charAt(cpos)) || this.CurrentLine.charAt(cpos) == '\'' && this.Lan.russianTokenizer) {
                    if (this.Lan.asianTokenizer) {
                        ++text.nbOfWords;
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                        epos = ++ichar;
                    } else if (this.Lan.russianTokenizer) {
                        ++text.nbOfWords;
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && (this.CurrentLine.charAt(ichar) == '\'' || Language.isLetter(this.CurrentLine.charAt(ichar)))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    } else {
                        ++text.nbOfWords;
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    }
                    this.addToken(hCorpusTokens, text.hTokens, token, text.mft.tuAddresses[itu] + cpos, text.mft.tuAddresses[itu] + epos);
                    continue;
                }
                if (text.XmlNodes != null && text.buffer.charAt(cpos) == '<') {
                    ++ichar;
                    while (ichar < this.CurrentLine.length() && this.CurrentLine.charAt(ichar) != '>') {
                        ++ichar;
                    }
                    if (ichar < this.CurrentLine.length()) {
                        token = this.CurrentLine.substring(cpos, ++ichar);
                        epos = ichar;
                        continue;
                    }
                    ichar = cpos + 1;
                    token = this.CurrentLine.substring(cpos, cpos + 1);
                    epos = ichar;
                    continue;
                }
                token = this.CurrentLine.substring(cpos, cpos + 1);
                int n = ++ichar;
            }
            ++itu;
        }
    }

    public final void computeDigrams(Corpus corpus, Ntext text) {
        HashMap<String, Integer> hCorpusDigrams = corpus == null ? null : corpus.hDigrams;
        text.hDigrams = new HashMap();
        int progressPercentage = 0;
        int itu = 1;
        while (itu < text.mft.tuAddresses.length) {
            String lasttoken = null;
            int lastbeg = 0;
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            int ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                String token;
                int cpos;
                if (this.BackgroundWorking) {
                    int nprogress;
                    if (this.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    if (corpus == null && (nprogress = (int)((float)ichar * 100.0f / (float)this.CurrentLine.length())) != progressPercentage) {
                        progressPercentage = nprogress;
                        if (this.backgroundWorker.isBusy()) {
                            this.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                if (Language.isLetter(this.CurrentLine.charAt(cpos = ichar++))) {
                    int epos;
                    if (this.Lan.asianTokenizer) {
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                        epos = ichar;
                    } else {
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    }
                    if (lasttoken != null) {
                        String digram = this.Lan.asianTokenizer ? String.valueOf(lasttoken) + token : String.valueOf(lasttoken) + " " + token;
                        this.addToken(hCorpusDigrams, text.hDigrams, digram, text.mft.tuAddresses[itu] + lastbeg, text.mft.tuAddresses[itu] + epos);
                    }
                    lasttoken = token;
                    lastbeg = cpos;
                    continue;
                }
                if (text.XmlNodes != null && text.buffer.charAt(cpos) == '<') {
                    ++ichar;
                    while (ichar < this.CurrentLine.length() && this.CurrentLine.charAt(ichar) != '>') {
                        ++ichar;
                    }
                    if (ichar < this.CurrentLine.length()) {
                        token = this.CurrentLine.substring(cpos, ++ichar);
                        continue;
                    }
                    ichar = cpos + 1;
                    token = this.CurrentLine.substring(cpos, cpos + 1);
                    continue;
                }
                ++ichar;
                String string = this.CurrentLine.substring(cpos, cpos + 1);
            }
            ++itu;
        }
    }

    private boolean alreadythere(TheSolutions thesolutions, int inewsols, int tunb, double position, double length, ArrayList<Double> input, ArrayList<String> output) {
        if (inewsols == -1) {
            inewsols = 0;
        }
        int isol = inewsols;
        while (isol < thesolutions.list.size()) {
            double slength;
            double sposition;
            int stunb = thesolutions.getTuNb(isol);
            if (stunb == tunb && (sposition = thesolutions.getBegAddress(isol)) == position && (slength = thesolutions.getLength(isol)) == length) {
                boolean identical = true;
                ArrayList<Double> sinput = thesolutions.getInput(isol);
                if (sinput.size() == input.size()) {
                    ArrayList<String> soutput;
                    int j = 0;
                    while (j < sinput.size()) {
                        double sf;
                        double f = input.get(j);
                        if (f != (sf = sinput.get(j).doubleValue())) {
                            identical = false;
                            break;
                        }
                        ++j;
                    }
                    if (identical && (soutput = thesolutions.getOutput(isol)).size() == output.size()) {
                        int j2 = 0;
                        while (j2 < soutput.size()) {
                            String so;
                            String o = output.get(j2);
                            if (!o.equals(so = soutput.get(j2))) {
                                identical = false;
                                break;
                            }
                            ++j2;
                        }
                        if (identical) {
                            return true;
                        }
                    }
                }
            }
            ++isol;
        }
        return false;
    }

    private int filterUnamb(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs, RefObject<Boolean> found, RefObject<Double> smallerlength) {
        String po;
        int io;
        ArrayList<String> output;
        int found2;
        found.argvalue = false;
        smallerlength.argvalue = -1.0;
        int isol = 0;
        while (isol < soloutputs.size()) {
            ArrayList<String> output2 = soloutputs.get(isol);
            int io2 = 0;
            while (io2 < output2.size()) {
                String po2 = output2.get(io2);
                if (po2 != null && !po2.equals("") && po2.indexOf("UNAMB") != -1) {
                    found.argvalue = true;
                    break;
                }
                ++io2;
            }
            if (((Boolean)found.argvalue).booleanValue()) break;
            ++isol;
        }
        if (!((Boolean)found.argvalue).booleanValue()) {
            return soloutputs.size();
        }
        int maxfound2 = -1;
        int isol2 = 0;
        while (isol2 < soloutputs.size()) {
            found2 = 0;
            output = soloutputs.get(isol2);
            io = 0;
            while (io < output.size()) {
                po = output.get(io);
                if (po != null && !po.equals("") && po.indexOf("UNAMB") != -1) {
                    ++found2;
                }
                ++io;
            }
            if (found2 > maxfound2) {
                maxfound2 = found2;
            }
            if (found2 == 0) {
                sollengths.remove(isol2);
                solinputs.remove(isol2);
                solvariables.remove(isol2);
                soloutputs.remove(isol2);
                continue;
            }
            ++isol2;
        }
        if (soloutputs.size() > 1) {
            isol2 = 0;
            while (isol2 < soloutputs.size()) {
                found2 = 0;
                output = soloutputs.get(isol2);
                io = 0;
                while (io < output.size()) {
                    po = output.get(io);
                    if (po != null && !po.equals("") && po.indexOf("UNAMB") != -1) {
                        ++found2;
                    }
                    ++io;
                }
                if (found2 < maxfound2) {
                    sollengths.remove(isol2);
                    solinputs.remove(isol2);
                    solvariables.remove(isol2);
                    soloutputs.remove(isol2);
                    continue;
                }
                ++isol2;
            }
        }
        smallerlength.argvalue = (double)sollengths.get(0);
        isol2 = 0;
        while (isol2 < soloutputs.size()) {
            if (sollengths.get(isol2) < (Double)smallerlength.argvalue) {
                smallerlength.argvalue = (double)sollengths.get(isol2);
            }
            ArrayList<String> output3 = soloutputs.get(isol2);
            int io3 = 0;
            while (io3 < output3.size()) {
                String po3 = output3.get(io3);
                if (po3 != null && !po3.equals("")) {
                    int iu;
                    if (po3.equals("UNAMB") || po3.equals("+UNAMB")) {
                        output3.set(io3, "");
                    }
                    if ((iu = po3.indexOf("+UNAMB")) != -1) {
                        output3.set(io3, po3.substring(0, iu));
                        output3.set(io3, String.valueOf(output3.get(io3)) + po3.substring(iu + 6));
                    }
                }
                ++io3;
            }
            ++isol2;
        }
        return soloutputs.size();
    }

    private int filterExclude(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs, RefObject<Boolean> minimlength, RefObject<Double> longestlength) {
        minimlength.argvalue = false;
        longestlength.argvalue = -1.0;
        int isol = 0;
        while (isol < soloutputs.size()) {
            ArrayList<String> output = soloutputs.get(isol);
            int io = 0;
            while (io < output.size()) {
                String po = output.get(io);
                if (po != null && !po.equals("") && po.indexOf("EXCLUDE") != -1 && sollengths.get(isol) > (Double)longestlength.argvalue) {
                    minimlength.argvalue = true;
                    longestlength.argvalue = (double)sollengths.get(isol);
                }
                ++io;
            }
            ++isol;
        }
        if (((Boolean)minimlength.argvalue).booleanValue()) {
            sollengths.clear();
            solinputs.clear();
            solvariables.clear();
            soloutputs.clear();
            return 0;
        }
        return soloutputs.size();
    }

    private int keepLongest(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs) {
        double longestlength = sollengths.get(0);
        int isol = 1;
        while (isol < sollengths.size()) {
            if (sollengths.get(isol) > longestlength) {
                longestlength = sollengths.get(isol);
            }
            ++isol;
        }
        isol = 0;
        while (isol < sollengths.size()) {
            if (sollengths.get(isol) < longestlength) {
                sollengths.remove(isol);
                solinputs.remove(isol);
                solvariables.remove(isol);
                soloutputs.remove(isol);
                continue;
            }
            ++isol;
        }
        return sollengths.size();
    }

    private int keepShortest(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs) {
        double shortestlength = sollengths.get(0);
        int isol = 1;
        while (isol < sollengths.size()) {
            if (sollengths.get(isol) < shortestlength) {
                shortestlength = sollengths.get(isol);
            }
            ++isol;
        }
        isol = 0;
        while (isol < soloutputs.size()) {
            if (sollengths.get(isol) > shortestlength) {
                sollengths.remove(isol);
                solinputs.remove(isol);
                solvariables.remove(isol);
                soloutputs.remove(isol);
                continue;
            }
            ++isol;
        }
        return sollengths.size();
    }

    private void deleteONCE(ArrayList<String> output) {
        int io = 0;
        while (io < output.size()) {
            String po = output.get(io);
            if (po != null && po.indexOf("<ONCE") == 0) {
                output.set(io, null);
            }
            ++io;
        }
    }

    private int filterXrefs(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs) {
        while (true) {
            int index = -1;
            boolean removeSolutionBreaked = false;
            int isol = 0;
            block1: while (isol < solvariables.size()) {
                String suf;
                int xrefnumber;
                String xref = null;
                int nbofxrefs = 0;
                ArrayList<String> variable = solvariables.get(isol);
                int iv = 0;
                while (iv < variable.size()) {
                    int posxref;
                    String lex = variable.get(iv);
                    if (lex != null && !lex.equals("") && (posxref = lex.indexOf("XREF=")) != -1) {
                        StringBuilder sb = new StringBuilder();
                        int i = posxref + new String("XREF=").length();
                        while (i < lex.length() && (Character.isDigit(lex.charAt(i)) || lex.charAt(i) == '.')) {
                            sb.append(lex.charAt(i));
                            ++i;
                        }
                        String currentxref = sb.toString();
                        if (xref == null) {
                            xref = currentxref;
                            nbofxrefs = 1;
                        } else {
                            if (!xref.equals(currentxref)) {
                                index = isol;
                                removeSolutionBreaked = true;
                                break block1;
                            }
                            ++nbofxrefs;
                        }
                    }
                    ++iv;
                }
                if (xref != null && (xrefnumber = Integer.parseInt(suf = xref.substring(xref.indexOf(46) + 1))) != nbofxrefs) {
                    index = isol;
                    removeSolutionBreaked = true;
                    break;
                }
                ++isol;
            }
            if (!removeSolutionBreaked) {
                return soloutputs.size();
            }
            sollengths.remove(index);
            solinputs.remove(index);
            solvariables.remove(index);
            soloutputs.remove(index);
        }
    }

    private boolean lexInfoMatchOperator(String lexcategory, String[] lexfeatures, String morphoperator) {
        String[] operators;
        int index = morphoperator.indexOf(43);
        if (index != -1 && index != 0) {
            String cat = morphoperator.substring(0, index);
            if (!lexcategory.equals(cat)) {
                return false;
            }
            operators = Dic.getAllFeaturesWithoutPlus(morphoperator.substring(index));
        } else {
            operators = Dic.getAllFeaturesWithoutPlus(morphoperator);
        }
        String[] stringArray = operators;
        int n = operators.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (!lexcategory.equals(op)) {
                boolean found = false;
                String[] stringArray2 = lexfeatures;
                int n3 = lexfeatures.length;
                int n4 = 0;
                while (n4 < n3) {
                    String lexfeat = stringArray2[n4];
                    if (op.equals(lexfeat)) {
                        found = true;
                        break;
                    }
                    if (lexfeat.indexOf(61) != -1) {
                        String propname = null;
                        String propvalue = null;
                        RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                        RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                        Dic.getPropertyNameValue(lexfeat, tempRef_propname, tempRef_propvalue);
                        propname = (String)tempRef_propname.argvalue;
                        propvalue = (String)tempRef_propvalue.argvalue;
                        if (op.equals(propname) || op.equals(propvalue)) {
                            found = true;
                            break;
                        }
                    }
                    ++n4;
                }
                if (!found) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private String[] getValues(String text, String varcompletename, RefObject<Boolean> compoundvariable, ArrayList<Double> positions, int rightmargin, ArrayList<String> variables, double cpos, int ipos, RefObject<Language> lan1, Mft textmft, ArrayList<Object> annotations, int tunb) throws IOException, ClassNotFoundException {
        String si;
        boolean listvariable;
        lan1.argvalue = null;
        compoundvariable.argvalue = false;
        boolean bl = listvariable = varcompletename.charAt(0) == '$';
        if (listvariable) {
            varcompletename = varcompletename.substring(1);
        }
        int index1 = varcompletename.indexOf(95);
        int index2 = varcompletename.indexOf(36, 1);
        int index = index1;
        if (index == -1) {
            index = index2;
        } else if (index2 == -1) {
            index = index1;
        } else if (index2 < index) {
            index = index2;
        }
        String varname = index == -1 ? ((index = varcompletename.indexOf(36)) == -1 ? varcompletename : varcompletename.substring(0, index)) : varcompletename.substring(0, index);
        if (!varcompletename.equals(varname)) {
            compoundvariable.argvalue = true;
        }
        if (!listvariable) {
            String si2;
            boolean symbolvar = false;
            index = -1;
            int iinput = ipos;
            while (iinput >= 0) {
                si2 = variables.get(iinput);
                if (si2 != null && si2.length() != 0 && si2.equals("$(" + varname)) {
                    index = iinput;
                    break;
                }
                --iinput;
            }
            if (index == -1) {
                iinput = ipos;
                while (iinput < variables.size()) {
                    si2 = variables.get(iinput);
                    if (si2 != null && si2.length() != 0 && si2.equals("$(" + varname)) {
                        index = iinput;
                        break;
                    }
                    ++iinput;
                }
            }
            if (index == -1) {
                return null;
            }
            int begaddress = (int)positions.get(index).doubleValue();
            String sj = null;
            if (symbolvar) {
                int jinput = index;
                int endaddress = index + 1 < positions.size() ? (int)positions.get(index + 1).doubleValue() : rightmargin;
                if (endaddress == -1) {
                    int iindex = 1;
                    while (endaddress == -1 && index + iindex < positions.size()) {
                        endaddress = (int)positions.get(index + ++iindex).doubleValue();
                    }
                }
                if (varcompletename.length() == varname.length()) {
                    String res = text.substring(begaddress, endaddress).trim();
                    String[] results = new String[]{res};
                    return results;
                }
                String lex = variables.get(index);
                ArrayList<String> lexs = new ArrayList<String>();
                lexs.add(lex);
                String[] results = this.computeDerivations(varcompletename.substring(varname.length()), lexs, text, positions, lan1, index, jinput);
                return results;
            }
            int reclevel = 0;
            int jinput = index + 1;
            while (jinput < variables.size()) {
                sj = variables.get(jinput);
                if (sj != null && sj.length() != 0) {
                    if (sj.charAt(0) == '$' && sj.length() > 2 && sj.charAt(1) == '(') {
                        ++reclevel;
                    } else if (sj.charAt(0) == '$' && sj.length() >= 2 && sj.charAt(1) == ')') {
                        if (reclevel == 0) break;
                        --reclevel;
                    }
                }
                ++jinput;
            }
            if (jinput >= positions.size()) {
                String[] results = new String[]{"*NoClosingParenthesisForVariable " + varname + "*"};
                return results;
            }
            int endaddress = (int)positions.get(jinput).doubleValue();
            if (sj != null && sj.length() > 2) {
                String[] results = new String[]{sj.substring(2)};
                return results;
            }
            if (varcompletename.length() == varname.length()) {
                String res = text.substring(begaddress, endaddress).trim();
                String[] results = new String[]{res};
                return results;
            }
            String lex = this.getLexFromVariable(variables, index, varname);
            ArrayList<String> lexs = new ArrayList<String>();
            lexs.add(lex);
            String[] results = this.computeDerivations(varcompletename.substring(varname.length()), lexs, text, positions, lan1, index + 1, jinput);
            return results;
        }
        boolean foundatleastone = false;
        String[] results = new String[]{""};
        int iinput = 0;
        while (iinput < variables.size()) {
            si = variables.get(iinput);
            if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                foundatleastone = true;
                int begaddress = (int)positions.get(iinput).doubleValue();
                String sj = null;
                int reclevel = 0;
                int jinput = iinput + 1;
                while (jinput < variables.size()) {
                    sj = variables.get(jinput);
                    if (sj != null && sj.length() != 0) {
                        if (sj.charAt(0) == '$' && sj.length() > 2 && sj.charAt(1) == '(') {
                            ++reclevel;
                        } else if (sj.charAt(0) == '$' && sj.length() >= 2 && sj.charAt(1) == ')') {
                            if (reclevel == 0) break;
                            --reclevel;
                        }
                    }
                    ++jinput;
                }
                if (jinput >= positions.size()) {
                    results[0] = String.valueOf(results[0]) + "*NoClosingParenthesisForVariable " + varname + "*";
                    iinput = jinput;
                } else {
                    int endaddress = (int)positions.get(jinput).doubleValue();
                    if (sj != null && sj.length() > 2) {
                        results[0] = String.valueOf(results[0]) + sj.substring(2);
                        iinput = jinput;
                    } else if (begaddress == endaddress) {
                        results[0] = String.valueOf(results[0]) + "*EmptyString*";
                        iinput = jinput;
                    } else if (varcompletename.length() == varname.length()) {
                        String res = text.substring(begaddress, endaddress).trim();
                        results[0] = String.valueOf(results[0]) + res;
                        iinput = jinput;
                    } else {
                        String lex = this.getLexFromVariable(variables, iinput, varname);
                        ArrayList<String> lexs = new ArrayList<String>();
                        lexs.add(lex);
                        String[] intermediateresults = this.computeDerivations(varcompletename.substring(varname.length()), lexs, text, positions, lan1, index + 1, jinput);
                        results[0] = String.valueOf(results[0]) + intermediateresults[0];
                        iinput = jinput;
                    }
                }
            }
            ++iinput;
        }
        if (!foundatleastone) {
            iinput = 0;
            while (iinput < variables.size()) {
                si = variables.get(iinput);
                if (si != null && si.length() != 0) {
                    String entry = null;
                    RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                    String lemma = null;
                    RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                    String cat = null;
                    RefObject<Object> tempRef_cat = new RefObject<Object>(cat);
                    String features = null;
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    boolean tempVar = !Dic.parseDELAF(si, tempRef_entry, tempRef_lemma, tempRef_cat, tempRef_features);
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    cat = (String)tempRef_cat.argvalue;
                    features = (String)tempRef_features.argvalue;
                    if (!tempVar && cat != null && !cat.equals("") && varname.equals(cat)) {
                        foundatleastone = true;
                        int begaddress = (int)positions.get(index).doubleValue();
                        int jinput = iinput;
                        int endaddress = (int)cpos;
                        if (varcompletename.length() == varname.length()) {
                            String res = text.substring(begaddress, endaddress).trim();
                            results[0] = String.valueOf(results[0]) + res;
                            iinput = jinput;
                        } else {
                            String lex = variables.get(index);
                            ArrayList<String> lexs = new ArrayList<String>();
                            lexs.add(lex);
                            String[] intermediateresults = this.computeDerivations(varcompletename.substring(varname.length()), lexs, text, positions, lan1, index, jinput);
                            results[0] = String.valueOf(results[0]) + intermediateresults[0];
                            iinput = jinput;
                        }
                    }
                }
                ++iinput;
            }
        }
        return results;
    }

    private ArrayList<String> recDevelop(ArrayList<String[]> listofresults, int index) {
        ArrayList<String> res = new ArrayList<String>();
        if (index >= listofresults.size()) {
            res.add(null);
            return res;
        }
        ArrayList<String> tail = this.recDevelop(listofresults, index + 1);
        String[] stringArray = listofresults.get(index);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            for (String t : tail) {
                if (t != null) {
                    res.add(String.valueOf(c) + " " + t);
                    continue;
                }
                res.add(c);
            }
            ++n2;
        }
        return res;
    }

    private String[] newGetValues(String text, String varcompletename, RefObject<Boolean> compoundvariable, ArrayList<Double> positions, int rightmargin, ArrayList<String> variables, double cpos, int ipos, RefObject<Language> lan1, Mft textmft, ArrayList<Object> annotations, int tunb, RefObject<ArrayList<HashMap<String, String>>> varvalues, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        int endaddress;
        int indexend;
        int begaddress;
        lan1.argvalue = null;
        compoundvariable.argvalue = false;
        varvalues.argvalue = null;
        errmessage.argvalue = null;
        int index1 = varcompletename.indexOf(95);
        int index2 = varcompletename.indexOf(36, 1);
        int index = index1;
        if (index == -1) {
            index = index2;
        } else if (index2 == -1) {
            index = index1;
        } else if (index2 < index) {
            index = index2;
        }
        String varname = index == -1 ? ((index = varcompletename.indexOf(36)) == -1 ? varcompletename : varcompletename.substring(0, index)) : varcompletename.substring(0, index);
        if (!varcompletename.equals(varname)) {
            compoundvariable.argvalue = true;
        }
        if (varname.equals("THIS")) {
            index = ipos;
            begaddress = (int)positions.get(index).doubleValue();
            indexend = index + 1;
            while (indexend < positions.size()) {
                String var = variables.get(indexend);
                if (var != null) break;
                ++indexend;
            }
            if (indexend >= positions.size()) {
                indexend = index;
                endaddress = (int)positions.get(indexend).doubleValue();
            } else {
                endaddress = ++indexend >= positions.size() ? (int)positions.get(indexend - 1).doubleValue() : (int)positions.get(indexend).doubleValue();
            }
        } else {
            String si;
            index = -1;
            int iinput = ipos;
            while (iinput >= 0) {
                si = variables.get(iinput);
                if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                    index = iinput;
                    break;
                }
                --iinput;
            }
            if (index == -1) {
                iinput = ipos;
                while (iinput < variables.size()) {
                    si = variables.get(iinput);
                    if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                        index = iinput;
                        break;
                    }
                    ++iinput;
                }
            }
            if (index == -1) {
                errmessage.argvalue = "Undefined variable $" + varname;
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            begaddress = (int)positions.get(index).doubleValue();
            String sj = null;
            int reclevel = 0;
            indexend = index + 1;
            while (indexend < variables.size()) {
                sj = variables.get(indexend);
                if (sj != null && sj.length() != 0) {
                    if (sj.charAt(0) == '$' && sj.length() > 2 && sj.charAt(1) == '(') {
                        ++reclevel;
                    } else if (sj.charAt(0) == '$' && sj.length() >= 2 && sj.charAt(1) == ')') {
                        if (reclevel == 0) break;
                        --reclevel;
                    }
                }
                ++indexend;
            }
            if (indexend >= positions.size()) {
                errmessage.argvalue = "No closing Parenthesis for variable " + varname;
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            endaddress = (int)positions.get(indexend).doubleValue();
            if (sj != null && sj.length() > 2) {
                String[] results = new String[]{sj.substring(2)};
                return results;
            }
        }
        if (varcompletename.length() == varname.length()) {
            String[] results;
            if (begaddress == endaddress) {
                results = new String[]{""};
                return results;
            }
            String res = text.substring(begaddress, endaddress).trim();
            results = new String[]{res};
            varvalues.argvalue = new ArrayList();
            HashMap<String, String> varvalue = new HashMap<String, String>();
            varvalue.put(varname, res);
            ((ArrayList)varvalues.argvalue).add(varvalue);
            String lex = null;
            int ii = index + 1;
            while (ii < indexend) {
                String var = variables.get(ii);
                String entry = null;
                String lemma = null;
                String info = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                boolean tempVar = var != null && Dic.parseDELAF(var, tempRef_entry, tempRef_lemma, tempRef_info);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                info = (String)tempRef_info.argvalue;
                if (tempVar) {
                    lex = var;
                    break;
                }
                ++ii;
            }
            if (lex != null) {
                varvalue.put("LU_" + varname, lex);
            }
            return results;
        }
        ArrayList<String[]> listofresults = new ArrayList<String[]>();
        String lex = null;
        int ii = index + 1;
        while (ii < indexend) {
            String var = variables.get(ii);
            String entry = null;
            String lemma = null;
            String info = null;
            RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
            boolean tempVar2 = var != null && Dic.parseDELAF(var, tempRef_entry2, tempRef_lemma2, tempRef_info2);
            entry = (String)tempRef_entry2.argvalue;
            lemma = (String)tempRef_lemma2.argvalue;
            info = (String)tempRef_info2.argvalue;
            if (tempVar2) {
                lex = var;
                ArrayList<String> lexs = new ArrayList<String>();
                lexs.add(lex);
                String[] cresults = this.computeDerivations(varcompletename.substring(varname.length()), lexs, text, positions, lan1, index + 1, indexend);
                if (cresults != null) {
                    listofresults.add(cresults);
                }
            }
            ++ii;
        }
        if (listofresults.isEmpty()) {
            return null;
        }
        ArrayList<String> devlistofresults = this.recDevelop(listofresults, 0);
        String[] results = new String[devlistofresults.size()];
        varvalues.argvalue = new ArrayList();
        int i = 0;
        for (String res : devlistofresults) {
            results[i++] = res;
            HashMap<String, String> varvalue = new HashMap<String, String>();
            varvalue.put("LU_" + varname, lex);
            varvalue.put(varcompletename, res);
            ((ArrayList)varvalues.argvalue).add(varvalue);
        }
        return results;
    }

    private int getPositionIndex(String varcompletename, ArrayList<String> variables, int ipos) {
        String si;
        int index1 = varcompletename.indexOf(95);
        int index2 = varcompletename.indexOf(36);
        int index = index1;
        if (index == -1) {
            index = index2;
        } else if (index2 == -1) {
            index = index1;
        } else if (index2 < index) {
            index = index2;
        }
        String varname = index == -1 ? varcompletename : varcompletename.substring(0, index);
        int iinput = ipos;
        while (iinput >= 0) {
            si = variables.get(iinput);
            if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                return iinput;
            }
            --iinput;
        }
        iinput = ipos;
        while (iinput < variables.size()) {
            si = variables.get(iinput);
            if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                return iinput;
            }
            ++iinput;
        }
        return -1;
    }

    final String processVariableInMorphoLabel(String label, ArrayList<String> inputs) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < label.length()) {
            String val;
            if (label.charAt(i) == '\\') {
                res.append(label.charAt(i));
                res.append(label.charAt(i + 1));
                i += 2;
                continue;
            }
            if (label.charAt(i) != '$') {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            if (i + 1 < label.length() && (label.charAt(i + 1) == '(' || label.charAt(i + 1) == ')')) {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            if (i + 1 < label.length() && (label.charAt(i + 1) == '>' || label.charAt(i + 1) == '}' || label.charAt(i + 1) == '$' || label.charAt(i + 1) == ',' || label.charAt(i + 1) == '=' || label.charAt(i + 1) == '#')) {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            ++i;
            int j = 0;
            while (i + j < label.length() && !Character.isWhitespace(label.charAt(i + j)) && label.charAt(i + j) != '#' && label.charAt(i + j) != '=' && label.charAt(i + j) != ',' && label.charAt(i + j) != '>' && label.charAt(i + j) != '}') {
                ++j;
            }
            String varname = label.toString().substring(i, i + j);
            if (i + j < label.length() && label.charAt(i + j) == '#') {
                ++j;
            }
            if ((val = this.getMorphoValue(varname, inputs)) == null || val.length() == 0) {
                res.append("*UNDEFINED*");
            } else {
                res.append(val);
            }
            i += j;
        }
        return res.toString();
    }

    final boolean thereIsAVariableInLabel(String label) {
        int i = 0;
        while (i < label.length()) {
            if (label.charAt(i) == '\\') {
                i += 2;
                continue;
            }
            if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
                ++i;
                continue;
            }
            if (label.charAt(i) == '$') {
                if (i + 1 < label.length() && (label.charAt(i + 1) == '(' || label.charAt(i + 1) == ')')) {
                    ++i;
                    continue;
                }
                if (i + 1 < label.length() && label.charAt(i + 1) == '>') {
                    ++i;
                    continue;
                }
                return i + 1 != label.length();
            }
            ++i;
        }
        return false;
    }

    private String getLexFromVariable(ArrayList<String> variable, int pos1) {
        int i = pos1 + 1;
        while (i < variable.size()) {
            String line = null;
            String entry = null;
            String lemma = null;
            String info = null;
            line = variable.get(i);
            if (line != null && !line.equals("")) {
                int level = 1;
                if (line.length() > 2 && line.charAt(0) == '$' && line.charAt(1) == '(') {
                    ++level;
                } else if (line.length() >= 2 && line.charAt(0) == '$' && line.charAt(1) == ')' && --level == 0) {
                    return null;
                }
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                boolean tempVar = Dic.parseDELAF(line, tempRef_entry, tempRef_lemma, tempRef_info);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                info = (String)tempRef_info.argvalue;
                if (tempVar) {
                    return line;
                }
            }
            ++i;
        }
        return null;
    }

    private String getLexFromVariable(ArrayList<String> variables, int position, String varname) {
        int vpos = this.getPositionIndex(varname, variables, position);
        if (vpos == -1) {
            return null;
        }
        return this.getLexFromVariable(variables, vpos);
    }

    private final boolean processConstraint(String current, Mft textmft, int tunb, ArrayList<Object> annotations, Grammar grammar, ArrayList<Double> position, int rightmargin, ArrayList<String> variable, double cpos, int ipos, String so, RefObject<ArrayList<String>> sols, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        boolean negation;
        RefObject<Boolean> tempRef_negation;
        String op;
        RefObject<Object> tempRef_op;
        String[] features;
        RefObject<Object> tempRef_features;
        String category;
        RefObject<Object> tempRef_category;
        String lemma;
        RefObject<Object> tempRef_lemma;
        String left;
        RefObject<Object> tempRef_left;
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatoryString("so", so);
        ParameterCheck.mandatory("sols", sols);
        ParameterCheck.mandatory("errmessage", errmessage);
        sols.argvalue = null;
        int pos1 = -1;
        int pos2 = -1;
        Language lan1 = null;
        String[] str1 = null;
        String[] str2 = null;
        boolean compound1 = false;
        boolean compound2 = false;
        errmessage.argvalue = null;
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < so.length()) {
            if (so.charAt(i) == '\\') {
                res.append(so.charAt(i));
                res.append(so.charAt(i + 1));
                i += 2;
                continue;
            }
            if (so.charAt(i) != '$') {
                res.append(so.charAt(i));
                ++i;
                continue;
            }
            int j = 0;
            RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
            String varname = Dic.getFullVariableName(so, i, tempRef_j);
            i = j = ((Integer)tempRef_j.argvalue).intValue();
            int vpos = this.getPositionIndex(varname, variable, ipos);
            if (vpos == -1) {
                pos1 = -2;
                errmessage.argvalue = "$" + varname + " is undefined";
                res.append("*UNDEFINED*");
                continue;
            }
            if (pos1 == -1) {
                pos1 = vpos;
                RefObject<Boolean> tempRef_compound1 = new RefObject<Boolean>(compound1);
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                str1 = this.getValues(current, varname, tempRef_compound1, position, rightmargin, variable, cpos, pos1, tempRef_lan1, textmft, annotations, tunb);
                compound1 = (Boolean)tempRef_compound1.argvalue;
                lan1 = (Language)tempRef_lan1.argvalue;
                if (str1 == null) {
                    res.append("*UNDEFINED*");
                    errmessage.argvalue = "$" + varname + " has no value";
                    Dic.writeLog((String)errmessage.argvalue);
                    continue;
                }
                res.append(str1[0]);
                continue;
            }
            pos2 = vpos;
            RefObject<Boolean> tempRef_compound2 = new RefObject<Boolean>(compound2);
            RefObject<Object> tempRef_lan12 = new RefObject<Object>(lan1);
            str2 = this.getValues(current, varname, tempRef_compound2, position, rightmargin, variable, cpos, pos2, tempRef_lan12, textmft, annotations, tunb);
            compound2 = (Boolean)tempRef_compound2.argvalue;
            lan1 = (Language)tempRef_lan12.argvalue;
            if (str2 == null) {
                res.append("*UNDEFINED*");
                errmessage.argvalue = "$" + varname + " has no value";
                Dic.writeLog((String)errmessage.argvalue);
                continue;
            }
            res.append(str2[0]);
        }
        String constraint = res.toString();
        boolean tempVar = !Dic.parseLexicalConstraint(constraint, tempRef_left = new RefObject<Object>((left = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_category = new RefObject<Object>((category = null)), tempRef_features = new RefObject<Object>((features = null)), tempRef_op = new RefObject<Object>((op = null)), tempRef_negation = new RefObject<Boolean>(negation = false));
        left = (String)tempRef_left.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        op = (String)tempRef_op.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar) {
            return false;
        }
        if (op.equals("=:")) {
            if (pos1 == -1) {
                errmessage.argvalue = "no variable";
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            sols.argvalue = new ArrayList();
            if (lan1 == null) {
                if (pos2 == -1) {
                    if (!compound1) {
                        String lex = this.getLexFromVariable(variable, pos1);
                        if (lex == null || lex.indexOf(",WF") != -1) {
                            int istr = 0;
                            while (istr < str1.length) {
                                ArrayList<String> tsols = this.lookupAndAnalyzeSimpleOrCompound(str1[istr], errmessage);
                                if (errmessage.argvalue != null) {
                                    return false;
                                }
                                if (tsols != null && tsols.size() > 0) {
                                    ((ArrayList)sols.argvalue).addAll(tsols);
                                }
                                ++istr;
                            }
                        } else {
                            ((ArrayList)sols.argvalue).add(lex);
                        }
                    } else {
                        int istr = 0;
                        while (istr < str1.length) {
                            ArrayList<String> tsols = this.lookupAndAnalyzeSimpleOrCompound(str1[istr], errmessage);
                            if (errmessage.argvalue != null) {
                                return false;
                            }
                            if (tsols != null && tsols.size() > 0) {
                                ((ArrayList)sols.argvalue).addAll(tsols);
                            }
                            ++istr;
                        }
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    int ileft = 0;
                    while (ileft < left.length()) {
                        if (left.charAt(ileft) != '#') {
                            sb.append(left.charAt(ileft));
                        }
                        ++ileft;
                    }
                    String word = sb.toString();
                    ArrayList<String> tsols = this.lookupAndAnalyzeSimpleOrCompound(word, errmessage);
                    if (errmessage.argvalue != null) {
                        return false;
                    }
                    if (tsols != null && tsols.size() > 0) {
                        ((ArrayList)sols.argvalue).addAll(tsols);
                    }
                }
            } else {
                if (this.engine2 == null || !this.engine2.Lan.isoName.equals(lan1.isoName)) {
                    RefObject<Language> tempRef_lan13 = new RefObject<Language>(lan1);
                    this.engine2 = new Engine(tempRef_lan13, this.applicationDir, this.docDir, this.projectDir, this.projectMode, this.preferences, this.BackgroundWorking, this.backgroundWorker);
                    lan1 = (Language)tempRef_lan13.argvalue;
                    if (this.engine2.loadNodResources(this.preferences.ldic.get(lan1.isoName), errmessage) == -1) {
                        errmessage.argvalue = "no linguistic resource for " + lan1.isoName;
                        Dic.writeLog((String)errmessage.argvalue);
                        return false;
                    }
                }
                sols.argvalue = new ArrayList();
                int istr = 0;
                while (istr < str1.length) {
                    ArrayList<String> tsols = this.engine2.lookupAndAnalyzeSimpleOrCompound(str1[istr], errmessage);
                    if (errmessage.argvalue != null) {
                        errmessage.argvalue = "no lexical entry for " + str1[istr];
                        Dic.writeLog((String)errmessage.argvalue);
                        return false;
                    }
                    if (tsols != null && tsols.size() > 0) {
                        ((ArrayList)sols.argvalue).addAll(tsols);
                    }
                    ++istr;
                }
                int isol = 0;
                while (isol < ((ArrayList)sols.argvalue).size()) {
                    String si = (String)((ArrayList)sols.argvalue).get(isol);
                    int jsol = isol + 1;
                    while (jsol < ((ArrayList)sols.argvalue).size()) {
                        String sj = (String)((ArrayList)sols.argvalue).get(jsol);
                        if (si.equals(sj)) {
                            ((ArrayList)sols.argvalue).remove(jsol);
                            continue;
                        }
                        ++jsol;
                    }
                    ++isol;
                }
            }
            if (sols.argvalue == null || ((ArrayList)sols.argvalue).isEmpty()) {
                return negation;
            }
            grammar.filterLexemes(sols, lemma, category, features, negation);
            if (sols.argvalue == null || ((ArrayList)sols.argvalue).isEmpty()) {
                errmessage.argvalue = String.valueOf(constraint) + " failed";
                return negation;
            }
            return !negation;
        }
        if (op.equals("=")) {
            if (str1 == null) {
                str1 = new String[]{"*UNDEFINED*"};
            }
            if (str2 == null) {
                str2 = new String[]{lemma};
            }
            boolean thereisamatch = false;
            int uu = 0;
            block7: while (uu < 1) {
                if (str1 != null) {
                    String[] stringArray = str1;
                    int n = str1.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s1 = stringArray[n2];
                        if (str2 != null) {
                            String[] stringArray2 = str2;
                            int n3 = str2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String s2 = stringArray2[n4];
                                if (s2 != null && s2.length() >= 2 && s2.charAt(0) == '\"' && s2.charAt(s2.length() - 1) == '\"') {
                                    String s22 = s2.substring(1, 1 + s2.length() - 2);
                                    if (this.Lan.doWordFormsMatch(s1, s22)) {
                                        thereisamatch = true;
                                        break block7;
                                    }
                                } else if (this.Lan.doWordFormsMatch(s1, s2)) {
                                    thereisamatch = true;
                                    break block7;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                ++uu;
            }
            if (thereisamatch) {
                return !negation;
            }
            errmessage.argvalue = String.valueOf(constraint) + " failed";
            return negation;
        }
        if (op.equals("!=")) {
            if (str1 == null) {
                str1 = new String[]{"*UNDEFINED*"};
            }
            if (str2 == null) {
                str2 = new String[]{lemma};
            }
            boolean thereisamatch = false;
            String[] stringArray = str1;
            int n = str1.length;
            int n5 = 0;
            block10: while (n5 < n) {
                String s1 = stringArray[n5];
                String[] stringArray3 = str2;
                int n6 = str2.length;
                int n7 = 0;
                while (n7 < n6) {
                    String s2 = stringArray3[n7];
                    if (!this.Lan.doWordFormsMatch(s1, s2)) {
                        thereisamatch = true;
                        break block10;
                    }
                    ++n7;
                }
                ++n5;
            }
            if (thereisamatch) {
                return !negation;
            }
            errmessage.argvalue = String.valueOf(constraint) + " failed";
            return negation;
        }
        errmessage.argvalue = "operator '" + op + "' unknown in constraint '" + constraint + "'";
        Dic.writeLog((String)errmessage.argvalue);
        return false;
    }

    private final boolean newProcessVariablesInString(String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        ArrayList tailoutputs = null;
        if (soutput.charAt(recindex) != '$') {
            StringBuilder sb = new StringBuilder();
            int iso = recindex;
            while (iso < soutput.length() && soutput.charAt(iso) != '$') {
                if (soutput.charAt(iso) != '#') {
                    sb.append(soutput.charAt(iso));
                }
                ++iso;
            }
            String curoutput = sb.toString();
            RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
            boolean res = this.newProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs, resvariables, iso);
            tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < tailoutputs.size()) {
                String aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++i2;
            }
            return true;
        }
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        int iso = j = ((Integer)tempRef_j.argvalue).intValue();
        if (varname.charAt(0) >= '0' && varname.charAt(0) <= '9') {
            String curoutput = String.valueOf('$') + varname;
            RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
            boolean res = this.newProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs2, resvariables, iso);
            tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < tailoutputs.size()) {
                String aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++i2;
            }
            return true;
        }
        ArrayList<String> curoutputs = new ArrayList<String>();
        ArrayList newresvariables = new ArrayList();
        int ivars = 0;
        while (ivars < ((ArrayList)resvariables.argvalue).size()) {
            HashMap hvariables = (HashMap)((ArrayList)resvariables.argvalue).get(ivars);
            if (hvariables.containsKey(varname)) {
                newresvariables.add(hvariables);
                curoutputs.add((String)hvariables.get(varname));
            } else if (variabletrace != null) {
                Language lan1 = null;
                boolean compoundvariable = false;
                ArrayList curvars = null;
                String errmessage = null;
                RefObject<Boolean> tempRef_compoundvariable = new RefObject<Boolean>(compoundvariable);
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                RefObject<Object> tempRef_curvars = new RefObject<Object>(curvars);
                RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                String[] tmpoutputs = this.newGetValues(currentline, varname, tempRef_compoundvariable, positiontrace, rightmargin, variabletrace, cpos, ipos, tempRef_lan1, textmft, annotations, tunb, tempRef_curvars, tempRef_errmessage);
                compoundvariable = (Boolean)tempRef_compoundvariable.argvalue;
                lan1 = (Language)tempRef_lan1.argvalue;
                curvars = (ArrayList)tempRef_curvars.argvalue;
                errmessage = (String)tempRef_errmessage.argvalue;
                if (tmpoutputs == null || curvars == null) {
                    if (errmessage != null) {
                        System.out.println(errmessage);
                    }
                } else {
                    int jvars = 0;
                    while (jvars < curvars.size()) {
                        String tmpoutput = tmpoutputs[jvars];
                        curoutputs.add(tmpoutput);
                        HashMap<String, String> newhvariables = new HashMap<String, String>(hvariables);
                        HashMap curvar = (HashMap)curvars.get(jvars);
                        newhvariables.put(varname, (String)curvar.get(varname));
                        if (curvar.containsKey("LU_" + varname)) {
                            newhvariables.put("LU_" + varname, (String)curvar.get("LU_" + varname));
                        }
                        newresvariables.add(newhvariables);
                        ++jvars;
                    }
                }
            }
            ++ivars;
        }
        if (newresvariables.isEmpty()) {
            resoutputs.argvalue = null;
            return false;
        }
        resvariables.argvalue = newresvariables;
        RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
        boolean res = this.newProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs3, resvariables, iso);
        tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
        if (!res) {
            resoutputs.argvalue = null;
            return false;
        }
        if (tailoutputs == null) {
            resoutputs.argvalue = null;
            return true;
        }
        resoutputs.argvalue = new ArrayList();
        int icur = 0;
        while (icur < curoutputs.size()) {
            String curoutput = (String)curoutputs.get(icur);
            int itail = 0;
            while (itail < tailoutputs.size()) {
                String sres = String.valueOf(curoutput) + (String)tailoutputs.get(itail);
                ((ArrayList)resoutputs.argvalue).add(sres);
                ++itail;
            }
            ++icur;
        }
        return true;
    }

    private boolean pureVariable(String left) {
        ParameterCheck.mandatoryString("left", left);
        if (left.length() == 0) {
            return false;
        }
        if (left.charAt(0) != '$') {
            return false;
        }
        int j = 1;
        while (j < left.length() && !Character.isWhitespace(left.charAt(j)) && left.charAt(j) != '#' && left.charAt(j) != '=' && left.charAt(j) != ',' && left.charAt(j) != '>') {
            ++j;
        }
        return j >= left.length();
    }

    private boolean newSolveConstraint(String originalleft, ArrayList<String> leftstrings, ArrayList<String> rightstrings, String nop, boolean negation, Grammar grammar, RefObject<ArrayList<String>> curoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, RefObject<String> errmessage) {
        ParameterCheck.mandatory("leftstrings", leftstrings);
        ParameterCheck.mandatory("rightstrings", rightstrings);
        ParameterCheck.mandatory("nop", nop);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (nop.equals("=")) {
            boolean match = false;
            block0: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    String info;
                    String lemma;
                    String entry;
                    if (Dic.isALexemeSymbol(left) && !Dic.isALexemeSymbol(right)) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(left, tempRef_entry, tempRef_lemma, tempRef_info);
                        entry = (String)tempRef_entry.argvalue;
                        lemma = (String)tempRef_lemma.argvalue;
                        info = (String)tempRef_info.argvalue;
                        if (!this.Lan.doWordFormsMatch(left, entry)) continue;
                        match = true;
                        continue block0;
                    }
                    if (!Dic.isALexemeSymbol(left) && Dic.isALexemeSymbol(right)) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(right, tempRef_entry2, tempRef_lemma2, tempRef_info2);
                        entry = (String)tempRef_entry2.argvalue;
                        lemma = (String)tempRef_lemma2.argvalue;
                        info = (String)tempRef_info2.argvalue;
                        if (!this.Lan.doWordFormsMatch(left, entry)) continue;
                        match = true;
                        continue block0;
                    }
                    if (!this.Lan.doWordFormsMatch(left, right)) continue;
                    match = true;
                    continue block0;
                }
            }
            if (match) {
                curoutputs.argvalue = new ArrayList();
                ((ArrayList)curoutputs.argvalue).add("");
                return !negation;
            }
            curoutputs.argvalue = null;
            return negation;
        }
        if (nop.equals("!=")) {
            boolean match = false;
            block2: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    String info;
                    String lemma;
                    String entry;
                    if (Dic.isALexemeSymbol(left) && !Dic.isALexemeSymbol(right)) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry3 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma3 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info3 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(left, tempRef_entry3, tempRef_lemma3, tempRef_info3);
                        entry = (String)tempRef_entry3.argvalue;
                        lemma = (String)tempRef_lemma3.argvalue;
                        info = (String)tempRef_info3.argvalue;
                        if (!this.Lan.doWordFormsMatch(left, entry)) continue;
                        match = true;
                        continue block2;
                    }
                    if (!Dic.isALexemeSymbol(left) && Dic.isALexemeSymbol(right)) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry4 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma4 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info4 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(right, tempRef_entry4, tempRef_lemma4, tempRef_info4);
                        entry = (String)tempRef_entry4.argvalue;
                        lemma = (String)tempRef_lemma4.argvalue;
                        info = (String)tempRef_info4.argvalue;
                        if (!this.Lan.doWordFormsMatch(left, entry)) continue;
                        match = true;
                        continue block2;
                    }
                    if (!this.Lan.doWordFormsMatch(left, right)) continue;
                    match = true;
                    continue block2;
                }
            }
            if (!match) {
                curoutputs.argvalue = new ArrayList();
                ((ArrayList)curoutputs.argvalue).add("");
                return !negation;
            }
            curoutputs.argvalue = null;
            return negation;
        }
        if (nop.equals("=:")) {
            if (this.pureVariable(originalleft)) {
                ArrayList sols = new ArrayList();
                int ilex = 0;
                while (ilex < ((ArrayList)resvariables.argvalue).size()) {
                    HashMap vals = (HashMap)((ArrayList)resvariables.argvalue).get(ilex);
                    if (originalleft.length() > 1 && originalleft.charAt(0) == '$' && vals.containsKey("LU_" + originalleft.substring(1))) {
                        String lexeme = (String)vals.get("LU_" + originalleft.substring(1));
                        sols.add(lexeme);
                    }
                    ++ilex;
                }
                if (sols.isEmpty()) {
                    curoutputs.argvalue = null;
                    return negation;
                }
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols = new ArrayList(sols);
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma5 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation2 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma5, tempRef_category, tempRef_features, tempRef_negation2);
                    lemma = (String)tempRef_lemma5.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    negation2 = (Boolean)tempRef_negation2.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols = new RefObject<ArrayList<String>>(tsols);
                    grammar.filterLexemes(tempRef_tsols, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols = (ArrayList)tempRef_tsols.argvalue;
                    if (tsols == null || tsols.size() <= 0) continue;
                    sols = tsols;
                    amatch = true;
                    break;
                }
                if (!amatch) {
                    curoutputs.argvalue = null;
                    return negation;
                }
                curoutputs.argvalue = new ArrayList();
                for (String lex : sols) {
                    ((ArrayList)curoutputs.argvalue).add("<LU=" + lex + ">");
                }
                return !negation;
            }
            curoutputs.argvalue = new ArrayList();
            ArrayList sols = new ArrayList();
            for (String left : leftstrings) {
                ArrayList tsols = this.lookupAndAnalyzeSimpleOrCompound(left, errmessage);
                if (errmessage.argvalue != null) {
                    return false;
                }
                if (tsols == null || tsols.isEmpty()) continue;
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols2 = new ArrayList(tsols);
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma6 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category2 = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features2 = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation22 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma6, tempRef_category2, tempRef_features2, tempRef_negation22);
                    lemma = (String)tempRef_lemma6.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    negation2 = (Boolean)tempRef_negation22.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols2 = new RefObject<ArrayList<String>>(tsols2);
                    grammar.filterLexemes(tempRef_tsols2, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols2 = (ArrayList)tempRef_tsols2.argvalue;
                    if (tsols2 == null || tsols2.size() <= 0) continue;
                    tsols = tsols2;
                    amatch = true;
                    break;
                }
                if (!amatch) continue;
                sols.addAll(tsols);
            }
            for (String lex : sols) {
                ((ArrayList)curoutputs.argvalue).add("<LU=" + lex + ">");
            }
            return !negation;
        }
        curoutputs.argvalue = null;
        return false;
    }

    private boolean newSolveConstraintForTransformed(String originalleft, ArrayList<String> leftstrings, ArrayList<String> rightstrings, String nop, boolean negation, Grammar grammar, RefObject<ArrayList<HashMap<String, String>>> resvariables, RefObject<String> errmessage) {
        ParameterCheck.mandatory("leftstrings", leftstrings);
        ParameterCheck.mandatory("rightstrings", rightstrings);
        ParameterCheck.mandatory("nop", nop);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (nop.equals("=")) {
            boolean match = false;
            String res = null;
            block0: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    if (!left.equals(right)) continue;
                    match = true;
                    res = left;
                    continue block0;
                }
            }
            if (match) {
                return !negation;
            }
            return negation;
        }
        if (nop.equals("!=")) {
            boolean match = false;
            String res = null;
            block2: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    if (left.equals(right)) {
                        match = true;
                        continue block2;
                    }
                    res = left;
                }
            }
            if (!match) {
                return !negation;
            }
            return negation;
        }
        if (nop.equals("=:")) {
            if (this.pureVariable(originalleft)) {
                ArrayList sols = new ArrayList();
                int ilex = 0;
                while (ilex < ((ArrayList)resvariables.argvalue).size()) {
                    HashMap vals = (HashMap)((ArrayList)resvariables.argvalue).get(ilex);
                    if (originalleft.length() > 1 && originalleft.charAt(0) == '$' && vals.containsKey(originalleft.substring(1))) {
                        String lexeme = (String)vals.get(originalleft.substring(1));
                        sols.add(lexeme.substring(1, 1 + lexeme.length() - 2));
                    }
                    ++ilex;
                }
                if (sols.isEmpty()) {
                    return negation;
                }
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols = (ArrayList)sols.clone();
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation2 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation2);
                    lemma = (String)tempRef_lemma.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    negation2 = (Boolean)tempRef_negation2.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols = new RefObject<ArrayList<String>>(tsols);
                    grammar.filterLexemes(tempRef_tsols, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols = (ArrayList)tempRef_tsols.argvalue;
                    if (tsols == null || tsols.size() <= 0) continue;
                    sols = tsols;
                    amatch = true;
                    break;
                }
                if (!amatch) {
                    return negation;
                }
                return !negation;
            }
            ArrayList sols = new ArrayList();
            for (String left : leftstrings) {
                ArrayList tsols = this.lookupAndAnalyzeSimpleOrCompound(left, errmessage);
                if (errmessage.argvalue != null) {
                    return false;
                }
                if (tsols == null || tsols.isEmpty()) continue;
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols2 = (ArrayList)tsols.clone();
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category2 = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features2 = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation22 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma2, tempRef_category2, tempRef_features2, tempRef_negation22);
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    negation2 = (Boolean)tempRef_negation22.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols2 = new RefObject<ArrayList<String>>(tsols2);
                    grammar.filterLexemes(tempRef_tsols2, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols2 = (ArrayList)tempRef_tsols2.argvalue;
                    if (tsols2 == null || tsols2.size() <= 0) continue;
                    tsols = tsols2;
                    amatch = true;
                    break;
                }
                if (!amatch) continue;
                sols.addAll(tsols);
            }
            if (sols.isEmpty()) {
                return negation;
            }
            return !negation;
        }
        return false;
    }

    private boolean newProcessSingleVariableInString(String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<Integer> iso) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("iso", iso);
        resoutputs.argvalue = new ArrayList();
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        j = (Integer)tempRef_j.argvalue;
        iso.argvalue = j;
        if (varname.charAt(0) >= '0' && varname.charAt(0) <= '9') {
            String curoutput = String.valueOf('$') + varname;
            ((ArrayList)resoutputs.argvalue).add(curoutput);
            return true;
        }
        ArrayList newresvariables = new ArrayList();
        int ivars = 0;
        while (ivars < ((ArrayList)resvariables.argvalue).size()) {
            HashMap hvariables = (HashMap)((ArrayList)resvariables.argvalue).get(ivars);
            if (hvariables.containsKey(varname)) {
                newresvariables.add(hvariables);
                ((ArrayList)resoutputs.argvalue).add((String)hvariables.get(varname));
            } else {
                Language lan1 = null;
                boolean compoundvariable = false;
                ArrayList curvars = null;
                String errmessage = null;
                RefObject<Boolean> tempRef_compoundvariable = new RefObject<Boolean>(compoundvariable);
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                RefObject<Object> tempRef_curvars = new RefObject<Object>(curvars);
                RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                String[] tmpoutputs = this.newGetValues(currentline, varname, tempRef_compoundvariable, positiontrace, rightmargin, variabletrace, cpos, ipos, tempRef_lan1, textmft, annotations, tunb, tempRef_curvars, tempRef_errmessage);
                compoundvariable = (Boolean)tempRef_compoundvariable.argvalue;
                lan1 = (Language)tempRef_lan1.argvalue;
                curvars = (ArrayList)tempRef_curvars.argvalue;
                errmessage = (String)tempRef_errmessage.argvalue;
                if (tmpoutputs != null) {
                    int jvars = 0;
                    while (jvars < curvars.size()) {
                        String tmpoutput = tmpoutputs[jvars];
                        ((ArrayList)resoutputs.argvalue).add(tmpoutput);
                        HashMap<String, String> newhvariables = new HashMap<String, String>(hvariables);
                        HashMap curvar = (HashMap)curvars.get(jvars);
                        if (varname.length() < 4 || varname.length() == 4 && !varname.equals("THIS") || varname.length() > 4 && !varname.substring(0, 4).equals("THIS")) {
                            newhvariables.put(varname, (String)curvar.get(varname));
                            if (curvar.containsKey("LU_" + varname)) {
                                newhvariables.put("LU_" + varname, (String)curvar.get("LU_" + varname));
                            }
                        }
                        newresvariables.add(newhvariables);
                        ++jvars;
                    }
                }
            }
            ++ivars;
        }
        resvariables.argvalue = newresvariables;
        return ((ArrayList)resvariables.argvalue).size() > 0;
    }

    private boolean newProcessSingleVariableInString(String soutput, HashMap<String, String> hvariables, int recindex, RefObject<Integer> nextindex, RefObject<ArrayList<String>> resoutputs, RefObject<String> errmessage) {
        ParameterCheck.mandatory("hvariables", hvariables);
        ParameterCheck.mandatory("nextindex", nextindex);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        resoutputs.argvalue = new ArrayList();
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        j = (Integer)tempRef_j.argvalue;
        nextindex.argvalue = j;
        ArrayList curoutputs = new ArrayList();
        if (varname.charAt(0) >= '0' && varname.charAt(0) <= '9') {
            String curoutput = String.valueOf('$') + varname;
            ((ArrayList)resoutputs.argvalue).add(curoutput);
            return true;
        }
        if (hvariables.containsKey(varname)) {
            ((ArrayList)resoutputs.argvalue).add(hvariables.get(varname));
            return true;
        }
        errmessage.argvalue = String.valueOf(varname) + " undefined";
        return false;
    }

    public final boolean newProcessVariablesInString(String soutput, HashMap<String, String> hvariables, int recindex, RefObject<ArrayList<String>> resoutputs) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        ArrayList tailoutputs = null;
        if (soutput.charAt(recindex) != '$') {
            StringBuilder sb = new StringBuilder();
            int iso = recindex;
            while (iso < soutput.length() && soutput.charAt(iso) != '$') {
                if (soutput.charAt(iso) != '#') {
                    sb.append(soutput.charAt(iso));
                }
                ++iso;
            }
            String curoutput = sb.toString();
            RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
            boolean res = this.newProcessVariablesInString(soutput, hvariables, iso, tempRef_tailoutputs);
            tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < tailoutputs.size()) {
                String aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++i2;
            }
            return true;
        }
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        int iso = j = ((Integer)tempRef_j.argvalue).intValue();
        if (varname.charAt(0) >= '0' && varname.charAt(0) <= '9') {
            String curoutput = String.valueOf('$') + varname;
            RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
            boolean res = this.newProcessVariablesInString(soutput, hvariables, iso, tempRef_tailoutputs2);
            tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < tailoutputs.size()) {
                String aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++i2;
            }
            return true;
        }
        ArrayList<String> curoutputs = new ArrayList<String>();
        if (hvariables.containsKey(varname)) {
            curoutputs.add(hvariables.get(varname));
        } else if (varname.indexOf(36) != -1) {
            String basename = varname.substring(0, varname.indexOf(36));
            String lex = hvariables.get(basename);
            if (lex == null) {
                resoutputs.argvalue = null;
                return false;
            }
            ArrayList lexs = null;
            RefObject<Object> tempRef_lexs = new RefObject<Object>(lexs);
            Dic.normalizeLexemeSymbol(lex, this, tempRef_lexs);
            lexs = (ArrayList)tempRef_lexs.argvalue;
            if (lexs == null) {
                resoutputs.argvalue = null;
                return false;
            }
            Language lan1 = null;
            String errmessage = null;
            curoutputs = new ArrayList();
            for (String lex0 : lexs) {
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                curoutputs.addAll(this.computeDerivations(varname.substring(basename.length()), lex0, tempRef_lan1, tempRef_errmessage));
                lan1 = (Language)tempRef_lan1.argvalue;
                errmessage = (String)tempRef_errmessage.argvalue;
            }
            if (curoutputs.isEmpty()) {
                resoutputs.argvalue = null;
                return false;
            }
        } else {
            resoutputs.argvalue = null;
            return false;
        }
        RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
        boolean res = this.newProcessVariablesInString(soutput, hvariables, iso, tempRef_tailoutputs3);
        tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
        if (!res) {
            resoutputs.argvalue = null;
            return false;
        }
        if (tailoutputs == null) {
            resoutputs.argvalue = null;
            return true;
        }
        resoutputs.argvalue = new ArrayList();
        int icur = 0;
        while (icur < curoutputs.size()) {
            String curoutput = (String)curoutputs.get(icur);
            int itail = 0;
            while (itail < tailoutputs.size()) {
                String sres = String.valueOf(curoutput) + (String)tailoutputs.get(itail);
                ((ArrayList)resoutputs.argvalue).add(sres);
                ++itail;
            }
            ++icur;
        }
        return true;
    }

    private final boolean newProcessConstraintsInString(String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        boolean check;
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        int iso = 0;
        ArrayList curoutputs = null;
        ArrayList tailoutputs = null;
        int uu = 0;
        while (uu < 1) {
            String aresoutput;
            String curoutput;
            if (soutput.charAt(recindex) == '$') {
                RefObject<Object> tempRef_curoutputs = new RefObject<Object>(curoutputs);
                RefObject<Integer> tempRef_iso = new RefObject<Integer>(iso);
                check = this.newProcessSingleVariableInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_curoutputs, resvariables, recindex, tempRef_iso);
                curoutputs = (ArrayList)tempRef_curoutputs.argvalue;
                iso = (Integer)tempRef_iso.argvalue;
                if (check) break;
                errmessage.argvalue = String.valueOf(soutput.substring(recindex)) + " undefined";
                resoutputs.argvalue = null;
                resvariables.argvalue = null;
                return false;
            }
            if (soutput.charAt(recindex) == '\"') {
                StringBuilder sb = new StringBuilder();
                sb.append('\"');
                iso = recindex + 1;
                while (iso < soutput.length() && soutput.charAt(iso) != '\"') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                sb.append('\"');
                curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs, resvariables, iso + 1, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                    ++i2;
                }
                return true;
            }
            if (soutput.charAt(recindex) != '<') {
                StringBuilder sb = new StringBuilder();
                iso = recindex;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '\"' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs2, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    aresoutput = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                    ++i2;
                }
                return true;
            }
            int j = 1;
            while (recindex + j < soutput.length() && soutput.charAt(recindex + j) != '>') {
                ++j;
            }
            if (recindex + j >= soutput.length()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                iso = recindex + 1;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                String curoutput2 = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs3, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    String aresoutput2 = String.valueOf(curoutput2) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput2);
                    ++i2;
                }
                return true;
            }
            String constraint = soutput.substring(recindex, recindex + j + 1);
            if (!Dic.isALexicalConstraint(constraint)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                iso = recindex + 1;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                String curoutput3 = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs4 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs4, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs4.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    String aresoutput3 = String.valueOf(curoutput3) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput3);
                    ++i2;
                }
                return true;
            }
            String left = null;
            String nop = null;
            String right = null;
            RefObject<Object> tempRef_left = new RefObject<Object>(left);
            RefObject<Object> tempRef_nop = new RefObject<Object>(nop);
            RefObject<Object> tempRef_right = new RefObject<Object>(right);
            Dic.parseLexicalConstraint(constraint, tempRef_left, tempRef_nop, tempRef_right);
            left = (String)tempRef_left.argvalue;
            nop = (String)tempRef_nop.argvalue;
            right = (String)tempRef_right.argvalue;
            boolean negation = false;
            ArrayList leftstrings = null;
            ArrayList rightstrings = null;
            RefObject<Object> tempRef_leftstrings = new RefObject<Object>(leftstrings);
            boolean leftcheck = this.newProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, left, grammar, tempRef_leftstrings, resvariables, 0);
            leftstrings = (ArrayList)tempRef_leftstrings.argvalue;
            if (!leftcheck) {
                errmessage.argvalue = String.valueOf(constraint) + " undefined";
            }
            boolean rightcheck = false;
            if (leftcheck) {
                RefObject<Object> tempRef_rightstrings = new RefObject<Object>(rightstrings);
                rightcheck = this.newProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, right, grammar, tempRef_rightstrings, resvariables, 0);
                rightstrings = (ArrayList)tempRef_rightstrings.argvalue;
                if (!rightcheck) {
                    errmessage.argvalue = String.valueOf(constraint) + " undefined";
                }
                if (rightcheck) {
                    RefObject<ArrayList<String>> tempRef_curoutputs2 = new RefObject<ArrayList<String>>(curoutputs);
                    check = this.newSolveConstraint(left, leftstrings, rightstrings, nop, negation, grammar, tempRef_curoutputs2, resvariables, errmessage);
                    curoutputs = (ArrayList)tempRef_curoutputs2.argvalue;
                    if (!check) {
                        errmessage.argvalue = String.valueOf(constraint) + " failed";
                        resoutputs.argvalue = null;
                        resvariables.argvalue = null;
                        return false;
                    }
                } else {
                    curoutputs = new ArrayList();
                    curoutputs.add("");
                }
            } else {
                curoutputs = new ArrayList();
                curoutputs.add("");
            }
            iso = recindex + j + 1;
            ++uu;
        }
        RefObject<Object> tempRef_tailoutputs5 = new RefObject<Object>(tailoutputs);
        check = this.newProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs5, resvariables, iso, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs5.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            resvariables.argvalue = null;
            return false;
        }
        resoutputs.argvalue = new ArrayList();
        int i2 = 0;
        while (i2 < tailoutputs.size()) {
            int icur = 0;
            while (icur < curoutputs.size()) {
                String aresoutput = String.valueOf((String)curoutputs.get(icur)) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++icur;
            }
            ++i2;
        }
        return true;
    }

    public final boolean newProcessConstraintsInStringForTransformed(String soutput, HashMap<String, String> hvars, int recindex, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        String aresoutput;
        boolean check;
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        int iso = 0;
        ArrayList<String> curoutputs = null;
        ArrayList tailoutputs = null;
        int uu = 0;
        while (uu < 1) {
            if (soutput.charAt(recindex) == '$') {
                RefObject<Integer> tempRef_iso = new RefObject<Integer>(iso);
                RefObject<Object> tempRef_curoutputs = new RefObject<Object>(curoutputs);
                check = this.newProcessSingleVariableInString(soutput, hvars, recindex, tempRef_iso, tempRef_curoutputs, errmessage);
                iso = (Integer)tempRef_iso.argvalue;
                curoutputs = (ArrayList<String>)tempRef_curoutputs.argvalue;
                if (check) break;
                errmessage.argvalue = String.valueOf(soutput) + " undefined";
                aresoutput = "*" + soutput + " undefined*";
                resoutputs.argvalue = new ArrayList();
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                return true;
            }
            if (soutput.charAt(recindex) != '<') {
                StringBuilder sb = new StringBuilder();
                iso = recindex;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    String aresoutput2 = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput2);
                    ++i2;
                }
                return true;
            }
            int j = 1;
            while (recindex + j < soutput.length() && soutput.charAt(recindex + j) != '>') {
                ++j;
            }
            if (recindex + j >= soutput.length()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                iso = recindex + 1;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs2, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    String aresoutput3 = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput3);
                    ++i2;
                }
                return true;
            }
            String constraint = soutput.substring(recindex, recindex + j + 1);
            if (!Dic.isALexicalConstraint(constraint)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                iso = recindex + 1;
                while (iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$') {
                    sb.append(soutput.charAt(iso));
                    ++iso;
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.newProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs3, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                int i2 = 0;
                while (i2 < tailoutputs.size()) {
                    String aresoutput4 = String.valueOf(curoutput) + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput4);
                    ++i2;
                }
                return true;
            }
            curoutputs = new ArrayList<String>();
            curoutputs.add("");
            String left = null;
            String nop = null;
            String right = null;
            RefObject<Object> tempRef_left = new RefObject<Object>(left);
            RefObject<Object> tempRef_nop = new RefObject<Object>(nop);
            RefObject<Object> tempRef_right = new RefObject<Object>(right);
            Dic.parseLexicalConstraint(constraint, tempRef_left, tempRef_nop, tempRef_right);
            left = (String)tempRef_left.argvalue;
            nop = (String)tempRef_nop.argvalue;
            right = (String)tempRef_right.argvalue;
            boolean negation = false;
            ArrayList leftstrings = null;
            ArrayList rightstrings = null;
            RefObject<Object> tempRef_leftstrings = new RefObject<Object>(leftstrings);
            boolean leftcheck = this.newProcessVariablesInString(left, hvars, 0, tempRef_leftstrings);
            leftstrings = (ArrayList)tempRef_leftstrings.argvalue;
            if (!leftcheck) {
                errmessage.argvalue = String.valueOf(constraint) + " undefined";
            }
            boolean rightcheck = false;
            if (leftcheck) {
                RefObject<Object> tempRef_rightstrings = new RefObject<Object>(rightstrings);
                rightcheck = this.newProcessVariablesInString(right, hvars, 0, tempRef_rightstrings);
                rightstrings = (ArrayList)tempRef_rightstrings.argvalue;
                if (!rightcheck) {
                    errmessage.argvalue = String.valueOf(constraint) + " undefined";
                }
                if (rightcheck) {
                    ArrayList listofhvars = new ArrayList();
                    listofhvars.add(hvars);
                    RefObject<ArrayList<HashMap<String, String>>> tempRef_listofhvars = new RefObject<ArrayList<HashMap<String, String>>>(listofhvars);
                    check = this.newSolveConstraintForTransformed(left, leftstrings, rightstrings, nop, negation, grammar, tempRef_listofhvars, errmessage);
                    listofhvars = (ArrayList)tempRef_listofhvars.argvalue;
                    if (!check) {
                        errmessage.argvalue = String.valueOf(constraint) + " failed";
                        resoutputs.argvalue = null;
                        return false;
                    }
                }
            }
            iso = recindex + j + 1;
            ++uu;
        }
        RefObject<Object> tempRef_tailoutputs4 = new RefObject<Object>(tailoutputs);
        check = this.newProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs4, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs4.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            return false;
        }
        resoutputs.argvalue = new ArrayList();
        int i2 = 0;
        while (i2 < tailoutputs.size()) {
            int icur = 0;
            while (icur < curoutputs.size()) {
                aresoutput = String.valueOf((String)curoutputs.get(icur)) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                ++icur;
            }
            ++i2;
        }
        return true;
    }

    private boolean sameHashMaps(HashMap<String, String> h1, HashMap<String, String> h2) {
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.size() != h2.size()) {
            return false;
        }
        for (String key : h1.keySet()) {
            String val2;
            if (!h2.containsKey(key)) {
                return false;
            }
            String val1 = h1.get(key);
            if (val1.equals(val2 = h2.get(key))) continue;
            return false;
        }
        return true;
    }

    private void removeAllThisVariables(RefObject<ArrayList<HashMap<String, String>>> resvariables) {
        ParameterCheck.mandatory("resvariables", resvariables);
        int i = 0;
        while (i < ((ArrayList)resvariables.argvalue).size()) {
            HashMap hvar = (HashMap)((ArrayList)resvariables.argvalue).get(i);
            ArrayList<String> allkeystoremove = new ArrayList<String>();
            for (String key : hvar.keySet()) {
                if (key.length() < new String("THIS").length() || !key.substring(0, new String("THIS").length()).equals("THIS")) continue;
                allkeystoremove.add(key);
            }
            for (String key : allkeystoremove) {
                hvar.remove(key);
            }
            ++i;
        }
    }

    public final boolean newProcessConstraints(String currentline, Mft textmft, ArrayList<Object> annotations, int tunb, Grammar grammar, ArrayList<Double> positiontrace, int rightmargin, ArrayList<String> variabletrace, double cpos, ArrayList<String> output, RefObject<ArrayList<ArrayList<String>>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatory("output", output);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= output.size()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add(new ArrayList());
            return true;
        }
        ArrayList tailoutputs = null;
        RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
        boolean check = this.newProcessConstraints(currentline, textmft, annotations, tunb, grammar, positiontrace, rightmargin, variabletrace, cpos, output, tempRef_tailoutputs, resvariables, recindex + 1, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            return false;
        }
        ArrayList curoutputs2 = null;
        String soutput = output.get(recindex);
        if (soutput == null) {
            curoutputs2 = new ArrayList();
            curoutputs2.add(null);
        } else {
            RefObject<ArrayList<String>> tempRef_curoutputs2 = new RefObject<ArrayList<String>>(curoutputs2);
            check = this.newProcessConstraintsInString(currentline, cpos, recindex, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_curoutputs2, resvariables, 0, errmessage);
            curoutputs2 = (ArrayList)tempRef_curoutputs2.argvalue;
            if (!check) {
                resoutputs.argvalue = null;
                resvariables.argvalue = null;
                return false;
            }
            this.removeAllThisVariables(resvariables);
            if (curoutputs2 != null && curoutputs2.size() >= 2) {
                int i = 0;
                while (i < curoutputs2.size()) {
                    int j = i + 1;
                    while (j < curoutputs2.size()) {
                        if (curoutputs2.get(i) == curoutputs2.get(j) && this.sameHashMaps((HashMap)((ArrayList)resvariables.argvalue).get(i), (HashMap)((ArrayList)resvariables.argvalue).get(j))) {
                            curoutputs2.remove(j);
                            ((ArrayList)resvariables.argvalue).remove(j);
                            continue;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        resoutputs.argvalue = new ArrayList();
        if (curoutputs2 != null) {
            int itail = 0;
            while (itail < tailoutputs.size()) {
                ArrayList atailoutput = (ArrayList)tailoutputs.get(itail);
                int icur = 0;
                while (icur < curoutputs2.size()) {
                    String curoutput = (String)curoutputs2.get(icur);
                    ArrayList<String> aresoutput = new ArrayList<String>(atailoutput);
                    aresoutput.add(0, curoutput);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                    ++icur;
                }
                ++itail;
            }
        }
        return true;
    }

    public final void moveBegAddressOufOfSpaces(String buffer, boolean expectXMLtags, RefObject<Double> absolutebegaddress) {
        ParameterCheck.mandatoryString("buffer", buffer);
        ParameterCheck.mandatory("absolutebegaddress", absolutebegaddress);
        boolean aproblem = true;
        while (aproblem) {
            aproblem = false;
            if (Character.isWhitespace(buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()))) {
                aproblem = true;
                absolutebegaddress.argvalue = (Double)absolutebegaddress.argvalue + 1.0;
                continue;
            }
            if (!expectXMLtags || buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()) != '<') continue;
            aproblem = true;
            absolutebegaddress.argvalue = (Double)absolutebegaddress.argvalue + 1.0;
            while (buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()) != '>') {
                absolutebegaddress.argvalue = (Double)absolutebegaddress.argvalue + 1.0;
            }
            absolutebegaddress.argvalue = (Double)absolutebegaddress.argvalue + 1.0;
        }
    }

    private ArrayList<String> mergeOutputWithLexemes(ArrayList<String> output, ArrayList<String> lexemes) {
        ParameterCheck.mandatory("output", output);
        ParameterCheck.mandatory("lexemes", lexemes);
        ArrayList<String> merged = new ArrayList<String>();
        int i = 0;
        while (i < output.size()) {
            String op = output.get(i);
            String lx = lexemes.get(i);
            if (op != null) {
                merged.add(String.valueOf(op) + "#");
            }
            if (lx != null) {
                if (lx.length() >= 1 && lx.charAt(0) == ':') {
                    merged.add(String.valueOf(lx) + "#");
                } else if (lx.length() > 2 && lx.charAt(0) == '$' && lx.charAt(1) == '(' || lx.charAt(1) == ')') {
                    merged.add(String.valueOf(lx) + "#");
                } else {
                    merged.add("<" + Dic.getRidOfSpecialFeatures(lx) + ">" + "#");
                }
            }
            ++i;
        }
        return merged;
    }

    public final TheSolutions syntacticParsing(Corpus corpus, Ntext text, ArrayList<Object> annotations, Grammar grammar, char cm, int limitation, boolean keepLexemesInSolution, boolean enforcecompletexrefs, RefObject<Boolean> thereisunamb, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        MatchType typeofmatch;
        ParameterCheck.mandatory("text", text);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("thereisunamb", thereisunamb);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        ArrayList<String> recursiveCalls = new ArrayList<String>();
        TheSolutions sols = null;
        thereisunamb.argvalue = false;
        Gram grm = grammar.grams.get("Main");
        if (grm == null) {
            errmessage.argvalue = "Grammar has no main graph/rule";
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        if (cm == 'A') {
            typeofmatch = MatchType.ALL;
        } else if (cm == 'S') {
            typeofmatch = MatchType.SHORTEST;
        } else if (cm == 'L') {
            typeofmatch = MatchType.LONGEST;
        } else if (cm == 'X') {
            typeofmatch = MatchType.ALL;
        } else {
            System.out.println("type of match unknown");
            return null;
        }
        boolean limitfinish = false;
        int nbofmatches = 0;
        int progressPercentage = 0;
        int itu = 1;
        while (itu <= text.mft.tuAddresses.length - 1 && !limitfinish) {
            int tuaddress = text.mft.tuAddresses[itu];
            this.CurrentLine = text.buffer.substring(tuaddress, tuaddress + text.mft.tuLengths[itu]);
            int inewsols = -1;
            if (sols != null) {
                inewsols = sols.list.size();
            }
            int ichar = 0;
            block1: while (ichar < this.CurrentLine.length() && !limitfinish) {
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                double cpos = ichar;
                if (!this.Lan.asianTokenizer && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                        ++ichar;
                    }
                } else if (text.XmlNodes != null && this.CurrentLine.charAt((int)cpos) == '<') {
                    ++ichar;
                    while (ichar < this.CurrentLine.length() && this.CurrentLine.charAt(ichar) != '>') {
                        ++ichar;
                    }
                    if (ichar < this.CurrentLine.length()) {
                        ++ichar;
                        continue;
                    }
                    ichar = (int)cpos + 1;
                } else {
                    ++ichar;
                }
                ArrayList sollengths = null;
                ArrayList solinputs = null;
                ArrayList soloutputs = null;
                Object solnodes = null;
                ArrayList solvariables = null;
                while (true) {
                    if (this.BackgroundWorking) {
                        int nprogress;
                        if (this.backgroundWorker.isCancellationPending()) {
                            errmessage.argvalue = "Cancelled";
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        if (corpus == null && (nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits)) != progressPercentage) {
                            progressPercentage = nprogress;
                            if (this.backgroundWorker.isBusy()) {
                                this.backgroundWorker.reportProgress(nprogress);
                            }
                        }
                    }
                    RefObject<Object> tempRef_sollengths = new RefObject<Object>(sollengths);
                    RefObject<Object> tempRef_solinputs = new RefObject<Object>(solinputs);
                    RefObject<Object> tempRef_solvariables = new RefObject<Object>(solvariables);
                    RefObject<Object> tempRef_soloutputs = new RefObject<Object>(soloutputs);
                    RefObject<Object> tempRef_solnodes = new RefObject<Object>(solnodes);
                    int da = grammar.syntaxMatch(grammar.fullName, -1, this.CurrentLine, cpos, itu, text.mft, annotations, grm, tempRef_sollengths, tempRef_solinputs, tempRef_solvariables, tempRef_soloutputs, tempRef_solnodes, MatchType.ALL, true, text.XmlNodes != null, recursiveCalls);
                    sollengths = (ArrayList)tempRef_sollengths.argvalue;
                    solinputs = (ArrayList)tempRef_solinputs.argvalue;
                    solvariables = (ArrayList)tempRef_solvariables.argvalue;
                    soloutputs = (ArrayList)tempRef_soloutputs.argvalue;
                    if (da > 0 && enforcecompletexrefs) {
                        da = this.filterXrefs(sollengths, solinputs, solvariables, soloutputs);
                    }
                    if (da > 0) {
                        ArrayList<ArrayList> res_solinputs = new ArrayList<ArrayList>();
                        ArrayList<ArrayList> res_soloutputs = new ArrayList<ArrayList>();
                        ArrayList<Double> res_sollengths = new ArrayList<Double>();
                        ArrayList<ArrayList> res_solvariables = new ArrayList<ArrayList>();
                        int isol = 0;
                        while (isol < sollengths.size()) {
                            ArrayList soloutput = (ArrayList)soloutputs.get(isol);
                            this.deleteONCE(soloutput);
                            int rightmargin = (int)(cpos + (Double)sollengths.get(isol));
                            ArrayList tmpoutputs = null;
                            ArrayList resvariables = new ArrayList();
                            resvariables.add(new HashMap());
                            RefObject<Object> tempRef_tmpoutputs = new RefObject<Object>(tmpoutputs);
                            RefObject<ArrayList<HashMap<String, String>>> tempRef_resvariables = new RefObject<ArrayList<HashMap<String, String>>>(resvariables);
                            boolean check = this.newProcessConstraints(this.CurrentLine, text.mft, annotations, itu, grammar, (ArrayList)solinputs.get(isol), rightmargin, (ArrayList)solvariables.get(isol), cpos, soloutput, tempRef_tmpoutputs, tempRef_resvariables, 0, errmessage);
                            tmpoutputs = (ArrayList)tempRef_tmpoutputs.argvalue;
                            resvariables = (ArrayList)tempRef_resvariables.argvalue;
                            if (check) {
                                int i2 = 0;
                                while (i2 < tmpoutputs.size()) {
                                    soloutput = (ArrayList)tmpoutputs.get(i2);
                                    this.processELCSFVariables(soloutput, "");
                                    this.deleteAllLUsFromOutput(soloutput);
                                    res_solinputs.add((ArrayList)solinputs.get(isol));
                                    res_soloutputs.add((ArrayList)tmpoutputs.get(i2));
                                    res_sollengths.add((Double)sollengths.get(isol));
                                    res_solvariables.add((ArrayList)solvariables.get(isol));
                                    ++i2;
                                }
                            }
                            ++isol;
                        }
                        solinputs = new ArrayList(res_solinputs);
                        soloutputs = new ArrayList(res_soloutputs);
                        sollengths = new ArrayList(res_sollengths);
                        solvariables = new ArrayList(res_solvariables);
                        da = sollengths.size();
                    }
                    boolean needminimlength = false;
                    double smallerlength = 0.0;
                    if (da > 0) {
                        RefObject<Boolean> tempRef_needminimlength = new RefObject<Boolean>(needminimlength);
                        RefObject<Double> tempRef_smallerlength = new RefObject<Double>(smallerlength);
                        da = this.filterExclude(sollengths, solinputs, solvariables, soloutputs, tempRef_needminimlength, tempRef_smallerlength);
                        needminimlength = (Boolean)tempRef_needminimlength.argvalue;
                        smallerlength = (Double)tempRef_smallerlength.argvalue;
                    }
                    if (da > 0) {
                        RefObject<Double> tempRef_smallerlength2 = new RefObject<Double>(smallerlength);
                        da = this.filterUnamb(sollengths, solinputs, solvariables, soloutputs, thereisunamb, tempRef_smallerlength2);
                        smallerlength = (Double)tempRef_smallerlength2.argvalue;
                        if (((Boolean)thereisunamb.argvalue).booleanValue()) {
                            needminimlength = true;
                        }
                    }
                    if (da > 0) {
                        if (typeofmatch == MatchType.LONGEST) {
                            if (da > 1) {
                                da = this.keepLongest(sollengths, solinputs, solvariables, soloutputs);
                            }
                            needminimlength = true;
                            smallerlength = (Double)sollengths.get(0);
                        } else if (typeofmatch == MatchType.SHORTEST) {
                            if (da > 1) {
                                da = this.keepShortest(sollengths, solinputs, solvariables, soloutputs);
                            }
                            needminimlength = true;
                            smallerlength = (Double)sollengths.get(0);
                        }
                        int isol = 0;
                        while (!limitfinish && isol < sollengths.size()) {
                            if ((Double)sollengths.get(isol) == 0.0) {
                                errmessage.argvalue = "Grammar " + new File(grammar.fullName).getName() + " recognizes the empty string.";
                                Dic.writeLog((String)errmessage.argvalue);
                                return null;
                            }
                            if (needminimlength) {
                                smallerlength = (Double)sollengths.get(isol);
                            }
                            if (sols == null) {
                                sols = new TheSolutions();
                            }
                            ArrayList output2 = (ArrayList)soloutputs.get(isol);
                            if (keepLexemesInSolution) {
                                ArrayList<String> o3 = this.mergeOutputWithLexemes(output2, (ArrayList)solvariables.get(isol));
                                if (!this.alreadythere(sols, inewsols, itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), o3)) {
                                    sols.addASolution(itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), o3);
                                    if (limitation != -1 && ++nbofmatches > limitation) {
                                        limitfinish = true;
                                        break;
                                    }
                                }
                            } else if (!this.alreadythere(sols, inewsols, itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), output2)) {
                                sols.addASolution(itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), output2);
                                if (limitation != -1 && ++nbofmatches > limitation) {
                                    limitfinish = true;
                                    break;
                                }
                            }
                            ++isol;
                        }
                    }
                    if (needminimlength) {
                        if (da > 0 && ((Boolean)thereisunamb.argvalue).booleanValue()) {
                            ArrayList output = (ArrayList)soloutputs.get(0);
                            int minlen = output.size();
                            int iminlen = 0;
                            int isol = 1;
                            while (isol < soloutputs.size()) {
                                output = (ArrayList)soloutputs.get(isol);
                                if (output.size() < minlen) {
                                    minlen = output.size();
                                    iminlen = isol;
                                }
                                ++isol;
                            }
                            if ((cpos += ((Double)sollengths.get(iminlen)).doubleValue()) < (double)ichar) continue;
                            if (!(cpos > (double)ichar)) continue block1;
                            ichar = (int)cpos;
                            continue block1;
                        }
                        if ((cpos += smallerlength) < (double)ichar) continue;
                        if (!(cpos > (double)ichar)) continue block1;
                        ichar = (int)cpos;
                        continue block1;
                    }
                    if (!text.mft.thereAreLexs(itu, cpos + 0.01)) continue block1;
                    cpos += 0.01;
                }
            }
            ++itu;
        }
        errmessage.argvalue = null;
        return sols;
    }

    public boolean processConstraints(String current, Mft textmft, int tunb, ArrayList<Object> annotations, Grammar grammar, ArrayList<Double> position, int rightmargin, ArrayList<String> variable, double cpos, ArrayList<String> output, RefObject<String> errMessage) throws IOException, ClassNotFoundException {
        errMessage.argvalue = "";
        int ipos = 0;
        while (ipos < output.size()) {
            String so = output.get(ipos);
            if (so != null && !so.equals("")) {
                boolean remove = false;
                int iso = 0;
                while (iso < so.length()) {
                    String so2;
                    if (so.charAt(iso) != '<') {
                        ++iso;
                        continue;
                    }
                    int len = -1;
                    len = 1;
                    while (iso + len < so.length()) {
                        if (so.charAt(iso + len) == '>') break;
                        ++len;
                    }
                    if (iso + len < so.length() && Dic.isALexicalConstraint(so2 = so.substring(iso, iso + len + 1))) {
                        RefObject<ArrayList<String>> constraintresults = new RefObject<ArrayList<String>>(new ArrayList());
                        if (!this.processConstraint(current, textmft, tunb, annotations, grammar, position, rightmargin, variable, cpos, ipos, so2, constraintresults, errMessage)) {
                            return false;
                        }
                        if (constraintresults != null && ((ArrayList)constraintresults.argvalue).size() > 0) {
                            output.add(ipos, "<LU=" + (String)((ArrayList)constraintresults.argvalue).get(0) + ">");
                        } else {
                            remove = true;
                        }
                    }
                    iso += len + 1;
                }
                if (remove) {
                    output.add(ipos, "");
                }
            }
            ++ipos;
        }
        return true;
    }

    public static ArrayList<Double> rel2Abs(ArrayList<Double> reladdresses, long absbegaddress) {
        ParameterCheck.mandatory("reladdresses", reladdresses);
        ArrayList<Double> res = new ArrayList<Double>();
        int i = 0;
        while (i < reladdresses.size()) {
            long hundaddress = (long)(100.0 * reladdresses.get(i)) + 100L * absbegaddress;
            double absaddress = (double)hundaddress / 100.0;
            res.add(absaddress);
            ++i;
        }
        return res;
    }

    public final boolean applyAllGrammars(Corpus corpus, Ntext mytext, ArrayList<Object> annotations, int startingpoint, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        boolean xmltext;
        HashMap<String, Integer> hCorpusPhrases;
        ParameterCheck.mandatory("mytext", mytext);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (corpus != null) {
            hCorpusPhrases = corpus.hPhrases;
            xmltext = corpus.xmlNodes != null;
        } else {
            hCorpusPhrases = null;
            boolean bl = xmltext = mytext.XmlNodes != null;
        }
        if (this.synGrms == null || this.synGrms.isEmpty()) {
            errmessage.argvalue = "No grammar to apply";
            Dic.writeLog((String)errmessage.argvalue);
            return false;
        }
        int iprio = startingpoint;
        while (iprio < 100) {
            if (startingpoint == 0 && iprio > 0) break;
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    errmessage.argvalue = "Cancelled";
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
                if (corpus == null && this.backgroundWorker.isBusy()) {
                    this.backgroundWorker.reportProgress(0);
                }
            }
            int idic = 0;
            while (idic < this.synGrms.size()) {
                Grammar synGrm = (Grammar)this.synGrms.get(idic);
                if ((Integer)this.synGrms.get(idic + 1) == iprio) {
                    char parsingmode = ((Character)this.synGrms.get(idic + 2)).charValue();
                    boolean thereisunamb = false;
                    RefObject<Boolean> tempRef_thereisunamb = new RefObject<Boolean>(thereisunamb);
                    TheSolutions thesolutions = this.syntacticParsing(corpus, mytext, annotations, synGrm, parsingmode, -1, false, true, tempRef_thereisunamb, errmessage);
                    thereisunamb = (Boolean)tempRef_thereisunamb.argvalue;
                    if (thesolutions == null && errmessage.argvalue != null) {
                        return false;
                    }
                    if (thesolutions != null && !thesolutions.list.isEmpty()) {
                        int isol = 0;
                        while (isol < thesolutions.list.size()) {
                            ArrayList<String> output;
                            ArrayList<Double> reladdresses;
                            ArrayList<Double> absaddresses;
                            long hund_endaddress;
                            double absoluteendaddress;
                            long hund_begaddress;
                            double absolutebegaddress;
                            int tunb = thesolutions.getTuNb(isol);
                            ArrayList<Object> seqofannotations = this.mergeIntoAnnotations(mytext.buffer, tunb, absolutebegaddress = (double)(hund_begaddress = (long)(100.0 * thesolutions.getBegAddress(isol)) + (long)(100 * mytext.mft.tuAddresses[tunb])) / 100.0, absoluteendaddress = (double)(hund_endaddress = (long)((absolutebegaddress + 0.005) * 100.0) + (long)(thesolutions.getLength(isol) * 100.0)) / 100.0, absaddresses = Engine.rel2Abs(reladdresses = thesolutions.getInput(isol), mytext.mft.tuAddresses[tunb]), output = thesolutions.getOutput(isol), false);
                            if (seqofannotations != null) {
                                int xrefnb = corpus == null ? mytext.annotations.size() : corpus.annotations.size();
                                int ia = 4;
                                while (ia < seqofannotations.size()) {
                                    double item_absolutebegaddress = (Double)seqofannotations.get(ia);
                                    RefObject<Double> tempRef_item_absolutebegaddress = new RefObject<Double>(item_absolutebegaddress);
                                    this.moveBegAddressOufOfSpaces(mytext.buffer, xmltext, tempRef_item_absolutebegaddress);
                                    item_absolutebegaddress = (Double)tempRef_item_absolutebegaddress.argvalue;
                                    String item_soutput = (String)seqofannotations.get(ia + 1);
                                    double item_absoluteendaddress = (Double)seqofannotations.get(ia + 2);
                                    if (item_absolutebegaddress == item_absoluteendaddress) {
                                        int nbofsolutions = 1;
                                        int c_isol = 0;
                                        while (c_isol < thesolutions.list.size()) {
                                            int c_tunb = thesolutions.getTuNb(c_isol);
                                            if (c_tunb >= tunb) {
                                                double c_begaddress;
                                                if (c_tunb > tunb) break;
                                                if (c_isol != isol && !((c_begaddress = (double)(hund_begaddress = (long)(100.0 * thesolutions.getBegAddress(c_isol)) + (long)(100 * mytext.mft.tuAddresses[c_tunb])) / 100.0) < absolutebegaddress)) {
                                                    if (c_begaddress > absolutebegaddress) break;
                                                    hund_endaddress = (long)(100.0 * c_begaddress) + (long)(100.0 * thesolutions.getLength(c_isol));
                                                    double c_endaddress = (double)hund_endaddress / 100.0;
                                                    if (c_endaddress == absoluteendaddress) {
                                                        ++nbofsolutions;
                                                        break;
                                                    }
                                                }
                                            }
                                            ++c_isol;
                                        }
                                        if (nbofsolutions == 1) {
                                            long a = (long)((item_absolutebegaddress + 0.005) * 100.0);
                                            long r = a - (long)(100 * mytext.mft.tuAddresses[tunb]);
                                            double relbegaddress = (double)r / 100.0;
                                            boolean anxrefwasremoved = false;
                                            RefObject<Boolean> tempRef_anxrefwasremoved = new RefObject<Boolean>(anxrefwasremoved);
                                            mytext.mft.filterTransitions(annotations, tunb, relbegaddress, item_soutput, tempRef_anxrefwasremoved);
                                            anxrefwasremoved = (Boolean)tempRef_anxrefwasremoved.argvalue;
                                            if (anxrefwasremoved) {
                                                mytext.mft.filterInconsistentXrefs(annotations, tunb);
                                            }
                                        }
                                    }
                                    ia += 3;
                                }
                                int nbxref = 0;
                                int ia2 = 4;
                                while (ia2 < seqofannotations.size()) {
                                    String item_soutput = (String)seqofannotations.get(ia2 + 1);
                                    if (item_soutput != null && item_soutput.indexOf("XREF") != -1) {
                                        ++nbxref;
                                    }
                                    ia2 += 3;
                                }
                                ia2 = 4;
                                while (ia2 < seqofannotations.size()) {
                                    double item_absolutebegaddress = (Double)seqofannotations.get(ia2);
                                    RefObject<Double> tempRef_item_absolutebegaddress2 = new RefObject<Double>(item_absolutebegaddress);
                                    this.moveBegAddressOufOfSpaces(mytext.buffer, xmltext, tempRef_item_absolutebegaddress2);
                                    item_absolutebegaddress = (Double)tempRef_item_absolutebegaddress2.argvalue;
                                    String item_soutput = (String)seqofannotations.get(ia2 + 1);
                                    double item_absoluteendaddress = (Double)seqofannotations.get(ia2 + 2);
                                    if (item_absolutebegaddress < item_absoluteendaddress) {
                                        boolean resetannotations;
                                        long hund_relbegaddress = (long)(100.0 * item_absolutebegaddress) - 100L * (long)mytext.mft.tuAddresses[tunb];
                                        double relbegaddress = (double)hund_relbegaddress / 100.0;
                                        long hund_relendaddress = (long)(100.0 * item_absoluteendaddress) - 100L * (long)mytext.mft.tuAddresses[tunb];
                                        double relendaddress = (double)hund_relendaddress / 100.0;
                                        String sinput = Dic.cleanupEntry(mytext.buffer.substring((int)item_absolutebegaddress, (int)item_absoluteendaddress), xmltext);
                                        if (item_soutput != null && item_soutput.indexOf("XREF") != -1) {
                                            item_soutput = item_soutput.replace("XREF", "XREF=" + xrefnb + "." + nbxref);
                                        }
                                        if ((item_soutput = Dic.cleanUpDoubleQuotes(item_soutput)).length() > 0 && item_soutput.charAt(0) == '<') {
                                            StringBuilder sb = new StringBuilder();
                                            int reclevel = 1;
                                            int i = 1;
                                            while (i < item_soutput.length()) {
                                                if (reclevel == 1 && item_soutput.charAt(i) == '>') {
                                                    --reclevel;
                                                } else {
                                                    if (item_soutput.charAt(i) == '<') {
                                                        ++reclevel;
                                                    }
                                                    if (item_soutput.charAt(i) == '>') {
                                                        --reclevel;
                                                    }
                                                    sb.append(item_soutput.charAt(i));
                                                }
                                                ++i;
                                            }
                                            item_soutput = sb.toString();
                                        }
                                        boolean bl = resetannotations = parsingmode == 'X' && thereisunamb;
                                        if (Dic.isALexicalAnnotation(item_soutput)) {
                                            if (sinput.equals("")) {
                                                if (hCorpusPhrases != null) {
                                                    this.addSyntaxToCorpus(annotations, null, hCorpusPhrases, item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                                } else {
                                                    this.addSyntaxToText(annotations, null, mytext.hPhrases, item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                                }
                                            } else if (hCorpusPhrases != null) {
                                                this.addSyntaxToCorpus(annotations, null, hCorpusPhrases, String.valueOf(sinput) + "," + item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                            } else {
                                                this.addSyntaxToText(annotations, null, mytext.hPhrases, String.valueOf(sinput) + "," + item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                            }
                                        } else {
                                            String lexeme = String.valueOf(sinput) + ",SYNTAX," + item_soutput;
                                            if (Dic.isALexicalAnnotation(lexeme)) {
                                                if (hCorpusPhrases != null) {
                                                    this.addSyntaxToCorpus(annotations, null, hCorpusPhrases, lexeme, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                                } else {
                                                    this.addSyntaxToText(annotations, null, mytext.hPhrases, lexeme, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                                }
                                            } else if (hCorpusPhrases != null) {
                                                this.addSyntaxToCorpus(annotations, null, hCorpusPhrases, String.valueOf(sinput) + ",INVALIDLEXEME", mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                            } else {
                                                this.addSyntaxToText(annotations, null, mytext.hPhrases, String.valueOf(sinput) + ",INVALIDLEXEME", mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                            }
                                        }
                                    }
                                    ia2 += 3;
                                }
                            }
                            ++isol;
                        }
                    }
                }
                idic += 3;
            }
            ++iprio;
        }
        return true;
    }

    private String combineAllFeatures(String[] alloriginalfeatures) {
        if (alloriginalfeatures == null || alloriginalfeatures.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = alloriginalfeatures;
        int n = alloriginalfeatures.length;
        int n2 = 0;
        while (n2 < n) {
            String feat = stringArray[n2];
            sb.append("+" + feat);
            ++n2;
        }
        return sb.toString();
    }

    private ArrayList<String> inflectAndDerive(String entry, String lemma, String category, String[] alloriginalfeatures) {
        String[] myfeaturesdrv;
        Gram grm;
        ParameterCheck.mandatoryString("category", category);
        ArrayList lexemes = null;
        String[] lexfeatures = Dic.getRidOfInflectionalFeatures(alloriginalfeatures, this.prop_inf);
        String myfeatureflx = Dic.lookFor("FLX", lexfeatures);
        String expname = null;
        if (myfeatureflx != null && (grm = this.paradigms.get(expname = myfeatureflx.substring(new String("FLX=").length()))) != null) {
            if (grm.vocabIn == null) {
                grm.prepareForParsing();
            }
            String[] forms = null;
            String[] outputs = null;
            RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
            RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
            grm.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
            forms = (String[])tempRef_forms.argvalue;
            outputs = (String[])tempRef_outputs.argvalue;
            int ires = 0;
            while (ires < forms.length) {
                String lex0 = String.valueOf(forms[ires]) + "," + lemma + "," + category + outputs[ires] + this.combineAllFeatures(lexfeatures);
                RefObject<Object> tempRef_lexemes = new RefObject<Object>(lexemes);
                Dic.normalizeLexicalEntry(lex0, this, tempRef_lexemes);
                lexemes = (ArrayList)tempRef_lexemes.argvalue;
                ++ires;
            }
        }
        if ((myfeaturesdrv = Dic.lookForAll("DRV", lexfeatures)) == null) {
            return lexemes;
        }
        String[] nonflxfeatures = Dic.getRidOfInflectionalFeatures(lexfeatures, this.prop_inf);
        if (nonflxfeatures == null) {
            return lexemes;
        }
        String[] stringArray = myfeaturesdrv;
        int n = myfeaturesdrv.length;
        int n2 = 0;
        while (n2 < n) {
            String flxname;
            String drvname;
            String myfeaturedrv = stringArray[n2];
            String expname2 = myfeaturedrv.substring(new String("DRV=").length());
            int index = expname2.indexOf(58);
            if (index == -1) {
                drvname = expname2;
                flxname = expname;
            } else {
                drvname = expname2.substring(0, index);
                flxname = expname2.substring(index + 1);
            }
            Gram grm2 = this.paradigms.get(drvname);
            if (grm2 != null) {
                if (grm2.vocabIn == null) {
                    grm2.prepareForParsing();
                }
                String[] forms = null;
                String[] outputs = null;
                RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
                RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
                grm2.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
                forms = (String[])tempRef_forms.argvalue;
                outputs = (String[])tempRef_outputs.argvalue;
                StringBuilder initialinfo = new StringBuilder();
                String[] stringArray2 = nonflxfeatures;
                int n3 = nonflxfeatures.length;
                int n4 = 0;
                while (n4 < n3) {
                    String feat = stringArray2[n4];
                    if (!feat.equals("NW")) {
                        initialinfo.append("+" + feat);
                    }
                    ++n4;
                }
                int ires = 0;
                while (ires < forms.length) {
                    if (flxname == null) {
                        String res = String.valueOf(forms[ires]) + "," + lemma + ",";
                        res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? String.valueOf(res) + outputs[ires].substring(1) : String.valueOf(res) + outputs[ires];
                        RefObject<ArrayList<String>> tempRef_lexemes2 = new RefObject<ArrayList<String>>(lexemes);
                        Dic.normalizeLexicalEntry(res, this, tempRef_lexemes2);
                        lexemes = (ArrayList)tempRef_lexemes2.argvalue;
                    } else {
                        Gram grm22 = this.paradigms.get(flxname);
                        if (grm22 == null) {
                            String res = String.valueOf(forms[ires]) + "," + lemma + ",";
                            res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? String.valueOf(res) + outputs[ires].substring(1) : String.valueOf(res) + outputs[ires];
                            RefObject<ArrayList<String>> tempRef_lexemes3 = new RefObject<ArrayList<String>>(lexemes);
                            Dic.normalizeLexicalEntry(String.valueOf(res) + this.combineAllFeatures(lexfeatures), this, tempRef_lexemes3);
                            lexemes = (ArrayList)tempRef_lexemes3.argvalue;
                        } else {
                            if (grm22.vocabIn == null) {
                                grm22.prepareForParsing();
                            }
                            String[] forms2 = null;
                            String[] outputs2 = null;
                            RefObject<Object> tempRef_forms2 = new RefObject<Object>(forms2);
                            RefObject<Object> tempRef_outputs2 = new RefObject<Object>(outputs2);
                            grm22.inflect(this.Lan, forms[ires], tempRef_forms2, tempRef_outputs2, this.paradigms);
                            forms2 = (String[])tempRef_forms2.argvalue;
                            outputs2 = (String[])tempRef_outputs2.argvalue;
                            if (forms2 != null) {
                                int ires2 = 0;
                                while (ires2 < forms2.length) {
                                    String res = String.valueOf(forms2[ires2]) + "," + lemma + ",";
                                    res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? String.valueOf(res) + outputs[ires].substring(1) : String.valueOf(res) + outputs[ires];
                                    res = String.valueOf(res) + initialinfo.toString() + outputs2[ires2];
                                    RefObject<ArrayList<String>> tempRef_lexemes4 = new RefObject<ArrayList<String>>(lexemes);
                                    Dic.normalizeLexicalEntry(String.valueOf(res) + this.combineAllFeatures(lexfeatures), this, tempRef_lexemes4);
                                    lexemes = (ArrayList)tempRef_lexemes4.argvalue;
                                    ++ires2;
                                }
                            }
                        }
                    }
                    ++ires;
                }
            }
            ++n2;
        }
        return lexemes;
    }

    public final ArrayList<String> inflectSolutions(ArrayList<String> sols) {
        ParameterCheck.mandatory("sols", sols);
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> lemmas = new ArrayList<String>();
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<String> paradigms = new ArrayList<String>();
        int isols = 0;
        while (isols < sols.size()) {
            String info;
            RefObject<Object> tempRef_info;
            String category;
            RefObject<Object> tempRef_category;
            String lemma;
            RefObject<Object> tempRef_lemma;
            String entry;
            RefObject<Object> tempRef_entry;
            String lex = sols.get(isols);
            boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_category = new RefObject<Object>((category = null)), tempRef_info = new RefObject<Object>((info = null)));
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            info = (String)tempRef_info.argvalue;
            if (!tempVar) {
                String[] myfeatures;
                String myfeature = Dic.lookFor("FLX", info);
                if (myfeature != null) {
                    String expname = myfeature.substring(new String("FLX=").length());
                    int index = -1;
                    int i = 0;
                    while (i < lemmas.size()) {
                        if (lemma.equals(lemmas.get(i)) && category.equals(categories.get(i)) && expname.equals(paradigms.get(i))) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        Gram grm;
                        lemmas.add(lemma);
                        categories.add(category);
                        paradigms.add(expname);
                        if (this.paradigms.containsKey(expname) && (grm = this.paradigms.get(expname)) != null) {
                            if (grm.vocabIn == null) {
                                grm.prepareForParsing();
                            }
                            String[] forms = null;
                            String[] outputs = null;
                            RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
                            RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
                            grm.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
                            forms = (String[])tempRef_forms.argvalue;
                            outputs = (String[])tempRef_outputs.argvalue;
                            int ires = 0;
                            while (ires < forms.length) {
                                results.add(forms[ires]);
                                if (outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+') {
                                    results.add(outputs[ires].substring(1));
                                } else {
                                    results.add(outputs[ires]);
                                }
                                ++ires;
                            }
                        }
                    }
                } else if ((myfeatures = Dic.lookForAll("DRV", info)) != null) {
                    String[] stringArray = myfeatures;
                    int n = myfeatures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Gram grm;
                        String mydrv = stringArray[n2];
                        String expname = null;
                        String flxname = null;
                        String expname0 = mydrv.substring(new String("DRV=").length());
                        int icomb = expname0.indexOf(58);
                        if (icomb != -1) {
                            expname = expname0.substring(0, icomb);
                            flxname = expname0.substring(icomb + 1);
                        } else {
                            expname = expname0;
                            flxname = myfeature.substring(new String("FLX=").length());
                        }
                        if (this.paradigms.containsKey(expname) && (grm = this.paradigms.get(expname)) != null) {
                            if (grm.vocabIn == null) {
                                grm.prepareForParsing();
                            }
                            String[] forms = null;
                            String[] outputs = null;
                            RefObject<Object> tempRef_forms2 = new RefObject<Object>(forms);
                            RefObject<Object> tempRef_outputs2 = new RefObject<Object>(outputs);
                            grm.inflect(this.Lan, entry, tempRef_forms2, tempRef_outputs2, this.paradigms);
                            forms = (String[])tempRef_forms2.argvalue;
                            outputs = (String[])tempRef_outputs2.argvalue;
                            if (forms != null && forms.length != 0) {
                                int ires = 0;
                                while (ires < forms.length) {
                                    String initialinfo = Dic.removeFeature("NW", info);
                                    int index = initialinfo.indexOf(43);
                                    if (index != -1) {
                                        initialinfo = initialinfo.substring(index);
                                    }
                                    String newinfo = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? outputs[ires].substring(1) : outputs[ires];
                                    if (flxname == null) {
                                        results.add(forms[ires]);
                                        results.add(newinfo);
                                    } else {
                                        Gram grm2 = this.paradigms.get(flxname);
                                        if (grm2 != null) {
                                            if (grm2.vocabIn == null) {
                                                grm2.prepareForParsing();
                                            }
                                            String[] dforms = null;
                                            String[] doutputs = null;
                                            RefObject<Object> tempRef_dforms = new RefObject<Object>(dforms);
                                            RefObject<Object> tempRef_doutputs = new RefObject<Object>(doutputs);
                                            grm2.inflect(this.Lan, forms[ires], tempRef_dforms, tempRef_doutputs, this.paradigms);
                                            dforms = (String[])tempRef_dforms.argvalue;
                                            doutputs = (String[])tempRef_doutputs.argvalue;
                                            if (dforms != null && dforms.length != 0) {
                                                int i2res = 0;
                                                while (i2res < dforms.length) {
                                                    String lastinfo = doutputs[i2res];
                                                    results.add(dforms[i2res]);
                                                    results.add(String.valueOf(newinfo) + lastinfo);
                                                    ++i2res;
                                                }
                                            }
                                        }
                                    }
                                    ++ires;
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++isols;
        }
        return results;
    }

    private void filterOutComplexInfos(ArrayList<String> sols) {
        int i = 0;
        while (i < sols.size()) {
            String entry = null;
            String info = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            if (this.isComplex(info)) {
                sols.subList(i, i + 1).clear();
                continue;
            }
            ++i;
        }
    }

    public final ArrayList<String> lookupAllSDics(String token) {
        if (this.lexforalldics == null) {
            this.lexforalldics = new HashMap();
        }
        if (this.lexforalldics.containsKey(token)) {
            return this.lexforalldics.get(token);
        }
        ArrayList<String> sols = null;
        int iprio = -9;
        while (iprio < 10) {
            if (this.lexBins != null) {
                int idic = 0;
                while (idic < this.lexBins.size()) {
                    ArrayList<String> tmp;
                    FSDic lexBin = (FSDic)this.lexBins.get(idic);
                    if ((Integer)this.lexBins.get(idic + 1) <= iprio && (tmp = this.Lan.isoName.equals("ar") || this.Lan.isoName.equals("he") ? lexBin.lookUpSimpleSemitic(token, 0, this) : lexBin.lookUpSimple(token, 0, this)) != null && tmp.size() > 0) {
                        if (sols == null) {
                            sols = new ArrayList<String>();
                        }
                        sols.addAll(tmp);
                    }
                    idic += 2;
                }
                if (sols != null) {
                    this.filterOutComplexInfos(sols);
                }
                if (sols != null && sols.size() > 0) break;
            }
            ++iprio;
        }
        this.lexforalldics.put(token, sols);
        return sols;
    }

    private String[] computeDerivations(String op, ArrayList<String> lexs, String text, ArrayList<Double> positions, RefObject<Language> lan1, int beg, int end) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("op", op);
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lan1", lan1);
        String errmessage = null;
        lan1.argvalue = null;
        String[] finalres = null;
        if (lexs.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int ilex = 0;
        while (ilex < lexs.size()) {
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            boolean tempVar = !Dic.parseDELAFFeatureArray(lexs.get(ilex), tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String[])tempRef_features.argvalue;
            if (!tempVar) {
                if (op.equals("_")) {
                    results.add(lemma);
                } else if (op.length() > 1 && op.charAt(0) == '_') {
                    ArrayList<String> lexemes;
                    if (!this.ResourcesLoaded) {
                        RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                        this.loadNodResources(this.preferences.ldic.get(this.Lan.isoName), tempRef_errmessage);
                        errmessage = (String)tempRef_errmessage.argvalue;
                    }
                    if ((lexemes = this.inflectAndDerive(entry, lemma, category, features)) == null || lexemes.size() == 0) {
                        errmessage = "Cannot derive " + lemma;
                        Dic.writeLog(errmessage);
                    } else {
                        for (String lexeme : lexemes) {
                            String[] listoffeatures;
                            RefObject<Object> tempRef_listoffeatures;
                            RefObject<String> tempRef_category2;
                            RefObject<String> tempRef_lemma2;
                            RefObject<String> tempRef_entry2;
                            boolean tempVar2 = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry2 = new RefObject<String>(entry), tempRef_lemma2 = new RefObject<String>(lemma), tempRef_category2 = new RefObject<String>(category), tempRef_listoffeatures = new RefObject<Object>((listoffeatures = null)));
                            entry = (String)tempRef_entry2.argvalue;
                            lemma = (String)tempRef_lemma2.argvalue;
                            category = (String)tempRef_category2.argvalue;
                            listoffeatures = (String[])tempRef_listoffeatures.argvalue;
                            if (tempVar2 || !this.lexInfoMatchOperator(category, listoffeatures, op.substring(1))) continue;
                            results.add(entry);
                        }
                    }
                } else if (op.length() > 1 && op.charAt(0) == '$') {
                    StringBuilder sb;
                    String opfield;
                    String oplanguage;
                    String opconstraints;
                    String op3;
                    String op2 = op.substring(1);
                    int index1 = op2.indexOf(95);
                    if (index1 == -1) {
                        op3 = op2;
                        opconstraints = null;
                    } else {
                        op3 = op2.substring(0, index1);
                        opconstraints = op2.substring(index1 + 1);
                    }
                    int index2 = op3.indexOf(36);
                    if (index2 == -1) {
                        oplanguage = op3;
                        opfield = null;
                    } else {
                        oplanguage = op3.substring(0, index2);
                        opfield = op3.substring(index2 + 1);
                    }
                    if (oplanguage.equals("CAT")) {
                        results.add(category);
                    } else if (oplanguage.equals("ENT")) {
                        results.add(entry);
                    } else if (oplanguage.equals("ALLS")) {
                        sb = new StringBuilder();
                        if (features != null) {
                            int i = 0;
                            while (i < features.length) {
                                String feat = features[i];
                                if (feat == null || feat.equals("")) {
                                    System.out.println("a feature is empty???");
                                } else {
                                    String propval = Dic.getPropertyValue(feat);
                                    if (this.isASyntacticFeature(propval) && !propval.equals("NW") && !propval.equals("FXC")) {
                                        sb.append("+" + feat);
                                    }
                                }
                                ++i;
                            }
                        }
                        results.add(sb.toString());
                    } else if (oplanguage.equals("ALLF")) {
                        sb = new StringBuilder();
                        if (features != null) {
                            int i = 0;
                            while (i < features.length) {
                                String feat = features[i];
                                if (feat == null || feat.equals("")) {
                                    System.out.println("a feature is empty???");
                                } else {
                                    String propval = Dic.getPropertyValue(feat);
                                    if (this.isAninflectionalFeature(propval)) {
                                        sb.append("+" + feat);
                                    }
                                }
                                ++i;
                            }
                        }
                        results.add(sb.toString());
                    } else if (features != null) {
                        ArrayList<String> myfeatures = new ArrayList<String>();
                        String[] stringArray = features;
                        int propval = features.length;
                        int feat = 0;
                        while (feat < propval) {
                            String feat2 = stringArray[feat];
                            String propname = null;
                            String propvalue = null;
                            RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                            RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                            Dic.getPropertyNameValue(feat2, tempRef_propname, tempRef_propvalue);
                            propname = (String)tempRef_propname.argvalue;
                            propvalue = (String)tempRef_propvalue.argvalue;
                            if (oplanguage.equals(propname)) {
                                myfeatures.add(propvalue);
                            }
                            ++feat;
                        }
                        if (index1 == -1 && index2 == -1) {
                            results.addAll(myfeatures);
                        } else {
                            Language lan2 = null;
                            if (oplanguage.length() == 2 && Character.isUpperCase(oplanguage.charAt(0)) && Character.isUpperCase(oplanguage.charAt(1))) {
                                lan2 = new Language(oplanguage.toLowerCase());
                                if (lan1.argvalue == null) {
                                    lan1.argvalue = lan2;
                                }
                            }
                            if (lan2 == null) {
                                this.engine2 = this;
                                lan2 = this.Lan;
                            } else if (this.engine2 == null || !this.engine2.Lan.isoName.equals(lan2.isoName)) {
                                RefObject<Language> tempRef_lan2 = new RefObject<Language>(lan2);
                                this.engine2 = new Engine(tempRef_lan2, this.applicationDir, this.docDir, this.projectDir, this.projectMode, this.preferences, this.BackgroundWorking, this.backgroundWorker);
                                lan2 = (Language)tempRef_lan2.argvalue;
                                RefObject<String> tempRef_errmessage2 = new RefObject<String>(errmessage);
                                this.engine2.loadNodResources(this.preferences.ldic.get(lan2.isoName), tempRef_errmessage2);
                                errmessage = (String)tempRef_errmessage2.argvalue;
                            } else {
                                lan2 = this.engine2.Lan;
                            }
                            ArrayList<String> s_sols = null;
                            for (String val : myfeatures) {
                                ArrayList<String> lexs2;
                                ArrayList<String> c_sols;
                                if (!lan2.asianTokenizer && (s_sols = this.engine2.lookupAllLexsAndMorphsForSimples(val, true, null, 0)) != null) {
                                    Engine.filterNonWords(s_sols);
                                    this.filterUnamb(s_sols);
                                }
                                if ((c_sols = this.engine2.lookupAllLexsAndMorphsForSimples(val, false, val, 0)) != null && c_sols.size() > 0) {
                                    Engine.filterNonWords(c_sols);
                                    this.filterUnamb(c_sols);
                                    lexs2 = new ArrayList<String>(c_sols);
                                } else {
                                    lexs2 = s_sols != null && s_sols.size() > 0 ? new ArrayList<String>(s_sols) : null;
                                }
                                if (lexs2 == null) {
                                    errmessage = "Cannot find " + val + " in target language " + lan2.isoName;
                                    Dic.writeLog(errmessage);
                                    continue;
                                }
                                int ilex2 = 0;
                                while (ilex2 < lexs2.size()) {
                                    RefObject<String[]> tempRef_features2;
                                    RefObject<String> tempRef_category3;
                                    RefObject<String> tempRef_lemma3;
                                    RefObject<String> tempRef_entry3;
                                    String lex = lexs2.get(ilex2);
                                    boolean tempVar3 = !Dic.parseDELAFFeatureArray(lex, tempRef_entry3 = new RefObject<String>(entry), tempRef_lemma3 = new RefObject<String>(lemma), tempRef_category3 = new RefObject<String>(category), tempRef_features2 = new RefObject<String[]>(features));
                                    entry = (String)tempRef_entry3.argvalue;
                                    lemma = (String)tempRef_lemma3.argvalue;
                                    category = (String)tempRef_category3.argvalue;
                                    features = (String[])tempRef_features2.argvalue;
                                    if (!tempVar3) {
                                        if (opfield != null) {
                                            ArrayList<String> myfeatures2 = new ArrayList<String>();
                                            if (features != null) {
                                                String[] stringArray2 = features;
                                                int n = features.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    String feat3 = stringArray2[n2];
                                                    String propname = null;
                                                    String propvalue = null;
                                                    RefObject<Object> tempRef_propname2 = new RefObject<Object>(propname);
                                                    RefObject<Object> tempRef_propvalue2 = new RefObject<Object>(propvalue);
                                                    Dic.getPropertyNameValue(feat3, tempRef_propname2, tempRef_propvalue2);
                                                    propname = (String)tempRef_propname2.argvalue;
                                                    propvalue = (String)tempRef_propvalue2.argvalue;
                                                    if (opfield.equals(propname)) {
                                                        myfeatures2.add(propvalue);
                                                    }
                                                    ++n2;
                                                }
                                            }
                                            results.addAll(myfeatures2);
                                        } else {
                                            ArrayList<String> lexemes = this.engine2.inflectAndDerive(val, lemma, category, features);
                                            if (lexemes == null || lexemes.isEmpty()) {
                                                errmessage = "Cannot derive '" + val + "' in target language '" + lan2.isoName.toUpperCase() + "' to compute " + op;
                                                Dic.writeLog(errmessage);
                                            } else {
                                                for (String lexeme : lexemes) {
                                                    String[] listoffeatures;
                                                    RefObject<Object> tempRef_listoffeatures2;
                                                    RefObject<String> tempRef_category4;
                                                    RefObject<String> tempRef_lemma4;
                                                    RefObject<String> tempRef_entry4;
                                                    boolean tempVar4 = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry4 = new RefObject<String>(entry), tempRef_lemma4 = new RefObject<String>(lemma), tempRef_category4 = new RefObject<String>(category), tempRef_listoffeatures2 = new RefObject<Object>((listoffeatures = null)));
                                                    entry = (String)tempRef_entry4.argvalue;
                                                    lemma = (String)tempRef_lemma4.argvalue;
                                                    category = (String)tempRef_category4.argvalue;
                                                    listoffeatures = (String[])tempRef_listoffeatures2.argvalue;
                                                    if (tempVar4 || !this.lexInfoMatchOperator(category, listoffeatures, opconstraints)) continue;
                                                    results.add(entry);
                                                }
                                            }
                                        }
                                    }
                                    ilex2 += 2;
                                }
                            }
                        }
                    }
                }
            }
            ++ilex;
        }
        if (results.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < results.size()) {
            String res = (String)results.get(i);
            int j = i + 1;
            while (j < results.size()) {
                String res2 = (String)results.get(j);
                if (res.equals(res2)) {
                    results.remove(j);
                    continue;
                }
                ++j;
            }
            ++i;
        }
        finalres = new String[results.size()];
        results.toArray(finalres);
        return finalres;
    }

    private ArrayList<String> computeDerivations(String op, String lex, RefObject<Language> lan1, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        ArrayList<String> results;
        block48: {
            String opfield;
            String oplanguage;
            String opconstraints;
            String op3;
            String[] features;
            String category;
            String lemma;
            String entry;
            block49: {
                ArrayList<String> lexemes;
                block47: {
                    ParameterCheck.mandatoryString("op", op);
                    ParameterCheck.mandatory("lan1", lan1);
                    ParameterCheck.mandatory("errmessage", errmessage);
                    errmessage.argvalue = null;
                    lan1.argvalue = null;
                    entry = null;
                    lemma = null;
                    category = null;
                    features = null;
                    RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                    RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    boolean tempVar = !Dic.parseLexemeSymbol(lex, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    if (tempVar) {
                        errmessage.argvalue = "<" + lex + ">" + "is not a valid lexeme";
                        return null;
                    }
                    results = new ArrayList<String>();
                    if (!op.equals("_")) break block47;
                    results.add(lemma);
                    break block48;
                }
                if (op.length() <= 1 || op.charAt(0) != '_') break block49;
                if (!this.ResourcesLoaded) {
                    this.loadNodResources(this.preferences.ldic.get(this.Lan.isoName), errmessage);
                }
                if ((lexemes = this.inflectAndDerive(entry, lemma, category, features)) == null || lexemes.size() == 0) {
                    errmessage.argvalue = "Cannot derive " + lemma;
                    return null;
                }
                for (String lexeme : lexemes) {
                    String[] listoffeatures;
                    RefObject<Object> tempRef_listoffeatures;
                    RefObject<String> tempRef_category2;
                    RefObject<String> tempRef_lemma2;
                    RefObject<String> tempRef_entry2;
                    boolean tempVar2 = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry2 = new RefObject<String>(entry), tempRef_lemma2 = new RefObject<String>(lemma), tempRef_category2 = new RefObject<String>(category), tempRef_listoffeatures = new RefObject<Object>((listoffeatures = null)));
                    entry = (String)tempRef_entry2.argvalue;
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    listoffeatures = (String[])tempRef_listoffeatures.argvalue;
                    if (tempVar2 || !this.lexInfoMatchOperator(category, listoffeatures, op.substring(1))) continue;
                    results.add(entry);
                }
                break block48;
            }
            if (op.length() <= 1 || op.charAt(0) != '$') break block48;
            String op2 = op.substring(1);
            int index1 = op2.indexOf(95);
            if (index1 == -1) {
                op3 = op2;
                opconstraints = null;
            } else {
                op3 = op2.substring(0, index1);
                opconstraints = op2.substring(index1 + 1);
            }
            int index2 = op3.indexOf(36);
            if (index2 == -1) {
                oplanguage = op3;
                opfield = null;
            } else {
                oplanguage = op3.substring(0, index2);
                opfield = op3.substring(index2 + 1);
            }
            if (oplanguage.equals("CAT")) {
                results.add(category);
                return results;
            }
            if (oplanguage.equals("ENT")) {
                results.add(entry);
                return results;
            }
            if (oplanguage.equals("ALLS")) {
                StringBuilder sb = new StringBuilder();
                if (features != null) {
                    int i = 0;
                    while (i < features.length) {
                        String feat = features[i];
                        if (feat == null || feat.equals("")) {
                            System.out.println("a feature is empty???");
                        } else {
                            String propval = Dic.getPropertyValue(feat);
                            if (this.isASyntacticFeature(propval) && !propval.equals("NW") && !propval.equals("FXC")) {
                                sb.append("+" + feat);
                            }
                        }
                        ++i;
                    }
                }
                results.add(sb.toString());
                return results;
            }
            if (oplanguage.equals("ALLF")) {
                StringBuilder sb = new StringBuilder();
                if (features != null) {
                    int i = 0;
                    while (i < features.length) {
                        String feat = features[i];
                        if (feat == null || feat.equals("")) {
                            System.out.println("a feature is empty???");
                        } else {
                            String propval = Dic.getPropertyValue(feat);
                            if (this.isAninflectionalFeature(propval)) {
                                sb.append("+" + feat);
                            }
                        }
                        ++i;
                    }
                }
                results.add(sb.toString());
                return results;
            }
            if (features == null) {
                return results;
            }
            ArrayList<String> myfeatures = new ArrayList<String>();
            String[] stringArray = features;
            int propval = features.length;
            int feat = 0;
            while (feat < propval) {
                String feat2 = stringArray[feat];
                String propname = null;
                String propvalue = null;
                RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                Dic.getPropertyNameValue(feat2, tempRef_propname, tempRef_propvalue);
                propname = (String)tempRef_propname.argvalue;
                propvalue = (String)tempRef_propvalue.argvalue;
                if (oplanguage.equals(propname)) {
                    myfeatures.add(propvalue);
                }
                ++feat;
            }
            if (index1 == -1 && index2 == -1) {
                results.addAll(myfeatures);
                return results;
            }
            Language lan2 = null;
            if (oplanguage.length() == 2 && Character.isUpperCase(oplanguage.charAt(0)) && Character.isUpperCase(oplanguage.charAt(1))) {
                lan2 = new Language(oplanguage.toLowerCase());
                if (lan1.argvalue == null) {
                    lan1.argvalue = lan2;
                }
            }
            if (lan2 == null) {
                this.engine2 = this;
                lan2 = this.Lan;
            } else if (this.engine2 == null || !this.engine2.Lan.isoName.equals(lan2.isoName)) {
                RefObject<Language> tempRef_lan2 = new RefObject<Language>(lan2);
                this.engine2 = new Engine(tempRef_lan2, this.applicationDir, this.docDir, this.projectDir, this.projectMode, this.preferences, this.BackgroundWorking, this.backgroundWorker);
                lan2 = (Language)tempRef_lan2.argvalue;
                this.engine2.loadNodResources(this.preferences.ldic.get(lan2.isoName), errmessage);
            } else {
                lan2 = this.engine2.Lan;
            }
            ArrayList<String> s_sols = null;
            for (String val : myfeatures) {
                ArrayList lexs2;
                if (!lan2.asianTokenizer && (s_sols = this.engine2.lookupAllLexsAndMorphsForSimples(val, true, null, 0)) != null) {
                    Engine.filterNonWords(s_sols);
                    this.filterUnamb(s_sols);
                }
                boolean thereisunamb = false;
                ArrayList<String> c_sols = this.engine2.lookupAllLexsForCompounds(0, val);
                if (c_sols != null && c_sols.size() > 0) {
                    Engine.filterNonWords(c_sols);
                    thereisunamb = this.filterUnamb(c_sols);
                    lexs2 = (ArrayList)c_sols.clone();
                } else {
                    lexs2 = s_sols != null && s_sols.size() > 0 ? (ArrayList)s_sols.clone() : null;
                }
                if (lexs2 == null) {
                    errmessage.argvalue = "Cannot find " + val + " in target language " + lan2.isoName;
                    Dic.writeLog((String)errmessage.argvalue);
                    return null;
                }
                int ilex2 = 0;
                while (ilex2 < lexs2.size()) {
                    RefObject<String[]> tempRef_features2;
                    RefObject<String> tempRef_category3;
                    RefObject<String> tempRef_lemma3;
                    RefObject<String> tempRef_entry3;
                    String lex2 = (String)lexs2.get(ilex2);
                    boolean tempVar3 = !Dic.parseDELAFFeatureArray(lex2, tempRef_entry3 = new RefObject<String>(entry), tempRef_lemma3 = new RefObject<String>(lemma), tempRef_category3 = new RefObject<String>(category), tempRef_features2 = new RefObject<String[]>(features));
                    entry = (String)tempRef_entry3.argvalue;
                    lemma = (String)tempRef_lemma3.argvalue;
                    category = (String)tempRef_category3.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    if (!tempVar3) {
                        if (opfield != null) {
                            ArrayList<String> myfeatures2 = new ArrayList<String>();
                            if (features != null) {
                                String[] stringArray2 = features;
                                int n = features.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String feat3 = stringArray2[n2];
                                    String propname = null;
                                    String propvalue = null;
                                    RefObject<Object> tempRef_propname2 = new RefObject<Object>(propname);
                                    RefObject<Object> tempRef_propvalue2 = new RefObject<Object>(propvalue);
                                    Dic.getPropertyNameValue(feat3, tempRef_propname2, tempRef_propvalue2);
                                    propname = (String)tempRef_propname2.argvalue;
                                    propvalue = (String)tempRef_propvalue2.argvalue;
                                    if (opfield.equals(propname)) {
                                        myfeatures2.add(propvalue);
                                    }
                                    ++n2;
                                }
                            }
                            results.addAll(myfeatures2);
                        } else {
                            ArrayList<String> lexemes = this.engine2.inflectAndDerive(val, lemma, category, features);
                            if (lexemes == null || lexemes.isEmpty()) {
                                errmessage.argvalue = "Cannot derive '" + val + "' in target language '" + lan2.isoName.toUpperCase() + "' to compute " + op;
                                Dic.writeLog((String)errmessage.argvalue);
                            } else {
                                for (String lexeme : lexemes) {
                                    String[] listoffeatures;
                                    RefObject<Object> tempRef_listoffeatures2;
                                    RefObject<String> tempRef_category4;
                                    RefObject<String> tempRef_lemma4;
                                    RefObject<String> tempRef_entry4;
                                    boolean tempVar4 = !Dic.parseDELAFFeatureArray(lexeme, tempRef_entry4 = new RefObject<String>(entry), tempRef_lemma4 = new RefObject<String>(lemma), tempRef_category4 = new RefObject<String>(category), tempRef_listoffeatures2 = new RefObject<Object>((listoffeatures = null)));
                                    entry = (String)tempRef_entry4.argvalue;
                                    lemma = (String)tempRef_lemma4.argvalue;
                                    category = (String)tempRef_category4.argvalue;
                                    listoffeatures = (String[])tempRef_listoffeatures2.argvalue;
                                    if (tempVar4 || !this.lexInfoMatchOperator(category, listoffeatures, opconstraints)) continue;
                                    results.add(entry);
                                }
                            }
                        }
                    }
                    ilex2 += 2;
                }
            }
        }
        return results;
    }

    public final String[] computeDerivations(String lexeme, String constraint) throws IOException, ClassNotFoundException {
        ArrayList<String> lexemes;
        ArrayList<String> results = new ArrayList<String>();
        String entry = null;
        String lemma = null;
        String category = null;
        String[] features = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        Dic.parseLexemeSymbol(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (!this.ResourcesLoaded) {
            String errmessage = null;
            RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
            this.loadNodResources(this.preferences.ldic.get(this.Lan.isoName), tempRef_errmessage);
            errmessage = (String)tempRef_errmessage.argvalue;
            if (errmessage != null) {
                return null;
            }
        }
        if ((lexemes = this.inflectAndDerive(entry, lemma, category, features)) == null || lexemes.isEmpty()) {
            return null;
        }
        for (String lex : lexemes) {
            String[] listoffeatures;
            RefObject<Object> tempRef_listoffeatures;
            RefObject<String> tempRef_category2;
            RefObject<String> tempRef_lemma2;
            RefObject<String> tempRef_entry2;
            boolean tempVar = !Dic.parseDELAFFeatureArray(lex, tempRef_entry2 = new RefObject<String>(entry), tempRef_lemma2 = new RefObject<String>(lemma), tempRef_category2 = new RefObject<String>(category), tempRef_listoffeatures = new RefObject<Object>((listoffeatures = null)));
            entry = (String)tempRef_entry2.argvalue;
            lemma = (String)tempRef_lemma2.argvalue;
            category = (String)tempRef_category2.argvalue;
            listoffeatures = (String[])tempRef_listoffeatures.argvalue;
            if (tempVar || listoffeatures == null || !this.lexInfoMatchOperator(category, listoffeatures, constraint)) continue;
            results.add("<" + lex + ">");
        }
        if (results.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < results.size()) {
            String res = (String)results.get(i);
            int j = i + 1;
            while (j < results.size()) {
                String res2 = (String)results.get(j);
                if (res.equals(res2)) {
                    results.remove(j);
                    continue;
                }
                ++j;
            }
            ++i;
        }
        String[] finalres = new String[results.size()];
        results.toArray(finalres);
        return finalres;
    }

    public final ArrayList<Object> mergeIntoAnnotations(String textbuffer, int tunb, double absolutebegaddress, double absoluteendaddress, ArrayList<Double> absaddresses, ArrayList<String> output, boolean keepLexemes) {
        ParameterCheck.mandatoryString("textbuffer", textbuffer);
        if (output == null || output.isEmpty() || absaddresses == null || absaddresses.isEmpty()) {
            return null;
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        StringBuilder sboutput = new StringBuilder();
        int iout = 0;
        while (iout < output.size()) {
            if (output.get(iout) != null) {
                sboutput.append(output.get(iout));
            }
            ++iout;
        }
        String soutput = sboutput.toString();
        annotations.add(tunb);
        annotations.add(soutput);
        annotations.add(absolutebegaddress);
        annotations.add(absoluteendaddress);
        int i = 0;
        while (i < output.size() && i < absaddresses.size()) {
            String out1 = output.get(i);
            if (out1 != null && !out1.equals("") && out1.charAt(0) == '<') {
                String out2;
                int j;
                int reclevel;
                double beg;
                if (!keepLexemes) {
                    beg = absaddresses.get(i);
                    if (beg < (double)textbuffer.length() && beg > 0.0 && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                        while (beg < (double)textbuffer.length() && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                            beg += 1.0;
                        }
                    }
                    reclevel = 1;
                    int iout1 = 1;
                    while (iout1 < out1.length()) {
                        if (out1.charAt(iout1) == '>') {
                            --reclevel;
                        } else if (out1.charAt(iout1) == '<') {
                            ++reclevel;
                        }
                        ++iout1;
                    }
                    if (reclevel == 0) {
                        annotations.add(beg);
                        annotations.add(out1);
                        annotations.add(beg);
                    } else {
                        reclevel = 1;
                        String outputannotation = out1.substring(1);
                        j = i + 1;
                        while (j < output.size() && j < absaddresses.size()) {
                            out2 = output.get(j);
                            if (out2 != null && !out2.equals("")) {
                                if (out2.charAt(0) == '<') {
                                    ++reclevel;
                                }
                                if (out2.charAt(out2.length() - 1) == '>') {
                                    if (--reclevel == 0) {
                                        annotations.add(beg);
                                        outputannotation = String.valueOf(outputannotation) + out2.substring(0, out2.length() - 1);
                                        annotations.add(outputannotation);
                                        annotations.add((double)absaddresses.get(j));
                                        break;
                                    }
                                } else if (reclevel == 1) {
                                    outputannotation = String.valueOf(outputannotation) + out2;
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    beg = absaddresses.get(i);
                    if (beg < (double)textbuffer.length() && beg > 0.0 && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                        while (beg < (double)textbuffer.length() && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                            beg += 1.0;
                        }
                    }
                    out1 = out1.substring(0, out1.length() - 1);
                    reclevel = 1;
                    int iout1 = 1;
                    while (iout1 < out1.length()) {
                        if (out1.charAt(iout1) == '>') {
                            --reclevel;
                        } else if (out1.charAt(iout1) == '<') {
                            ++reclevel;
                        }
                        ++iout1;
                    }
                    if (reclevel == 0) {
                        annotations.add(beg);
                        annotations.add(out1);
                        annotations.add(beg);
                    } else {
                        reclevel = 1;
                        String outputannotation = out1.substring(1);
                        j = i + 1;
                        while (j < output.size() && j < absaddresses.size()) {
                            out2 = output.get(j);
                            if ((out2 = out2.substring(0, out2.length() - 1)) != null && !out2.equals("")) {
                                if (out2.charAt(0) == '<') {
                                    if (out2.charAt(out2.length() - 1) != '>') {
                                        ++reclevel;
                                    }
                                } else if (out2.charAt(0) == '>') {
                                    if (--reclevel == 0) {
                                        annotations.add(beg);
                                        outputannotation = String.valueOf(outputannotation) + out2.substring(0, out2.length() - 1);
                                        annotations.add(outputannotation);
                                        annotations.add((double)absaddresses.get(j));
                                        break;
                                    }
                                } else if (reclevel == 1 && out2.charAt(0) != ':') {
                                    outputannotation = String.valueOf(outputannotation) + out2;
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        return annotations;
    }

    private ArrayList<Object> addXmlAnnotations(String buffer, RefObject<String> newbuffer) {
        ParameterCheck.mandatoryString("buffer", buffer);
        ParameterCheck.mandatory("newbuffer", newbuffer);
        String begpat = "<[^/][^ >]*( |[^>])*>";
        String endpat = "</[^>]*>";
        Pattern compileBegPat = Pattern.compile(begpat, 10);
        Pattern compileEndPat = Pattern.compile(endpat, 10);
        Matcher matcherBegPat = compileBegPat.matcher(buffer);
        StringBuilder sbuffer = new StringBuilder(buffer);
        ArrayList<Object> tags = null;
        while (matcherBegPat.find()) {
            String begTag;
            Matcher matcherEndPat = compileEndPat.matcher(buffer);
            String xmlTag = begTag = matcherBegPat.group();
            int startIndexOfBeg = matcherBegPat.start();
            int endIndexOfBeg = matcherBegPat.end();
            int startIndexOfEnd = 0;
            int endIndexOfEnd = 0;
            String endTag = null;
            int ibeg = (begTag = begTag.substring(1, begTag.length() - 1)).indexOf(32);
            if (ibeg != -1) {
                begTag = begTag.substring(0, ibeg);
            }
            int endFound = -1;
            int jj = 0;
            while (matcherEndPat.find()) {
                endTag = matcherEndPat.group();
                startIndexOfEnd = matcherEndPat.start();
                endIndexOfEnd = matcherEndPat.end();
                if (startIndexOfEnd < endIndexOfBeg) continue;
                if ((endTag = endTag.substring(1, endTag.length() - 1)).equals("/" + begTag)) {
                    endFound = jj;
                    break;
                }
                ++jj;
            }
            if (endFound == -1) break;
            if (tags == null) {
                tags = new ArrayList<Object>();
            }
            double ipos = endIndexOfBeg;
            RefObject<Double> tempRef_ipos = new RefObject<Double>(ipos);
            Grammar.skipSpaces(buffer, tempRef_ipos, true);
            ipos = (Double)tempRef_ipos.argvalue;
            double len = (double)startIndexOfEnd - ipos;
            if (!(len > 0.0)) continue;
            String sinput = Dic.cleanupXmlEntry(buffer.substring((int)ipos, (int)ipos + (int)len));
            String mcategory = null;
            String xmltag = xmlTag;
            RefObject<Object> tempRef_mcategory = new RefObject<Object>(mcategory);
            String label = Dic.cleanupXmlInfo(xmltag.substring(1, 1 + xmltag.length() - 2), tempRef_mcategory);
            mcategory = (String)tempRef_mcategory.argvalue;
            if (mcategory.equals("LU") && label.length() > 1) {
                String entry = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                String lemma = null;
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                String category = null;
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                String features = null;
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                boolean tempVar = !Dic.parseXmlInfo(label, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String)tempRef_features.argvalue;
                if (tempVar) continue;
                if (category.equals("W") || category.equals("L") || category.equals("U") || category.equals("P") || category.equals("D") || category.equals("UPP") || category.equals("LOW") || category.equals("CAP") || category.equals("NB")) {
                    category = String.valueOf(category) + "XML";
                }
                if (entry == null) {
                    entry = sinput;
                }
                String lexeme = String.valueOf(entry) + ",";
                lexeme = lemma == null ? String.valueOf(lexeme) + entry + "," + category : String.valueOf(lexeme) + lemma + "," + category;
                if (features != null) {
                    lexeme = String.valueOf(lexeme) + "+" + features;
                }
                tags.add(ipos);
                tags.add(lexeme);
                tags.add(len);
            } else {
                if (mcategory.equals("W") || mcategory.equals("L") || mcategory.equals("U") || mcategory.equals("P") || mcategory.equals("D") || mcategory.equals("UPP") || mcategory.equals("LOW") || mcategory.equals("CAP") || mcategory.equals("NB")) {
                    mcategory = String.valueOf(mcategory) + "XML";
                }
                tags.add(ipos);
                tags.add(String.valueOf(sinput) + ",SYNTAX," + mcategory + label);
                tags.add(len);
            }
            int begMatchLength = endIndexOfBeg - startIndexOfBeg;
            int j = 0;
            while (j < begMatchLength) {
                sbuffer.setCharAt(startIndexOfBeg + j, '\u0000');
                ++j;
            }
            int endMatchLength = endIndexOfEnd - startIndexOfEnd;
            int j2 = 0;
            while (j2 < endMatchLength) {
                sbuffer.setCharAt(startIndexOfEnd + j2, '\u0000');
                ++j2;
            }
        }
        newbuffer.argvalue = sbuffer.toString();
        return tags;
    }

    final boolean addAllXmlAnnotations(Corpus corpus, Ntext text, ArrayList<Object> annotations) {
        ParameterCheck.mandatory("text", text);
        HashMap<String, Integer> hCorpusPhrases = corpus == null ? null : corpus.hPhrases;
        StringBuilder alltext = new StringBuilder(text.buffer);
        int itu = 1;
        while (itu <= text.nbOfTextUnits) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                if (corpus == null && this.backgroundWorker.isBusy()) {
                    this.backgroundWorker.reportProgress(0);
                }
            }
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            String newcurrentline = null;
            RefObject<Object> tempRef_newcurrentline = new RefObject<Object>(newcurrentline);
            ArrayList<Object> sols = this.addXmlAnnotations(this.CurrentLine, tempRef_newcurrentline);
            newcurrentline = (String)tempRef_newcurrentline.argvalue;
            if (sols != null && sols.size() > 0) {
                int ichar = 0;
                while (ichar < text.mft.tuLengths[itu]) {
                    alltext.setCharAt(text.mft.tuAddresses[itu] + ichar, newcurrentline.charAt(ichar));
                    ++ichar;
                }
                int i = 0;
                while (i < sols.size()) {
                    int startaddress = ((Double)sols.get(i)).intValue();
                    String output = (String)sols.get(i + 1);
                    int ichar2 = ((Double)sols.get(i)).intValue() + ((Double)sols.get(i + 2)).intValue();
                    while (ichar2 < this.CurrentLine.length() && Character.isWhitespace(this.CurrentLine.charAt(ichar2))) {
                        ++ichar2;
                    }
                    int endaddress = ichar2;
                    if (corpus != null) {
                        this.addLexemeToCorpus(annotations, hCorpusPhrases, output, text.mft, itu, startaddress, endaddress);
                    } else {
                        this.addLexemeToText(annotations, text.hPhrases, output, text.mft, itu, startaddress, endaddress);
                    }
                    i += 3;
                }
            }
            ++itu;
        }
        text.buffer = alltext.toString();
        alltext = new StringBuilder();
        int[] shift = new int[text.buffer.length()];
        int currentshift = 0;
        int i = 0;
        while (i < text.buffer.length()) {
            shift[i] = currentshift++;
            if (text.buffer.charAt(i) != '\u0000') {
                alltext.append(text.buffer.charAt(i));
            }
            ++i;
        }
        text.mft.shiftAllTransitions(shift);
        text.buffer = alltext.toString();
        return true;
    }

    private static class xmlnode
    implements Comparable<Object> {
        private int beg;
        private int end;

        private xmlnode(int b, int e) {
            this.beg = b;
            this.end = e;
        }

        @Override
        public int compareTo(Object o) {
            xmlnode other = (xmlnode)o;
            if (this.beg < other.beg) {
                return -1;
            }
            if (this.beg > other.beg) {
                return 1;
            }
            return 0;
        }
    }
}

